<%
/*
 *   File		:	EgConfigureComponentTests.jsp
 *   Purpose	:	To view and configure tests for components
 *   Author		:	S.Anand (2008)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.EgAgentInfo" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import="java.net.URLDecoder" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgMemCheck" %>
<%@ page import="com.egurkha.admin.EgTestSpecification"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgUsersInfo"%>

<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String ua = request.getHeader( "User-Agent" );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
%>

<!-- used to collect the tests relevent to the component type -->
<jsp:useBean id="testlist" scope ="page" class ="egurkha.TestConfigSpecsBean"/>
<!-- used to collect list of unconfigured tests for all components -->
<jsp:useBean id="TestConfig" scope="page" class="egurkha.TestsNotConfigured"/>
<!-- used to collect excluded test from a component -->
<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%
	String queryString = request.getQueryString();
	String strSearch = request.getParameter("strSearch");
	boolean isSearchResult = (strSearch != null && !strSearch.equalsIgnoreCase(""));
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer strTokens = new StringTokenizer(strSearch);
		while (strTokens.hasMoreTokens())
		{
			String thisToken = strTokens.nextToken().trim();
			if (thisToken.equals("")) continue;
			searchList.add(thisToken);
		}
	}
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean userBasedLicense = usersInfo.isUserBasedLicense();
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	boolean remoteControlEnabled = new EgMemCheck().isRemoteControlEnabled();
	IniFile egTestParamIni = null;
	com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

	String allowQualifiedHostNames = servicesIniFile.getValue("MISC_ARGS","AllowQualifiedHostNames");
	allowQualifiedHostNames = StringUtils.isNull(allowQualifiedHostNames)?"yes":allowQualifiedHostNames.trim();
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);

	String testType = request.getParameter("testType");
	testType = (testType == null)?"PerformanceTest":testType;

	String pfSelected = "";
	String cfSelected = "";
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	String componentType = request.getParameter("componentType");
	componentType = (componentType == null)?"":componentType;
	int enableConfTestSize = 0;

	String componentName = request.getParameter("componentName");
	componentName = (componentName == null)?"":componentName;
	String testName = request.getParameter("testName");
	testName = (testName == null)?"":testName;
	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null)?previousTestName:"";
	boolean isAutoConfiguration = false;
	boolean allowAggregateOperation = false;

	//added by pravat - Start
	boolean isXDMGetDevicesInfo = false;
	if (componentType != null && componentType.equalsIgnoreCase("XenMobileMDM"))
	{
		if (testName != null && testName.equalsIgnoreCase("WebServiceTest"))
		{
			isXDMGetDevicesInfo = false;
		}
		else
		{
			isXDMGetDevicesInfo = true;
		}
	}
	//added by pravat - End

	//User license  starts
	String usrBasedTests = "";
	if (userBasedLicense)
	{
		if(!componentType.equals(""))
		{
			ArrayList userBasedTests = usersInfo.getUserBasedTests(componentType);
			for (int i=0; i<userBasedTests.size(); i++)
			{
				String test = userBasedTests.get(i).toString();
				if(usrBasedTests.equals(""))
				{
					usrBasedTests += test;
				}
				else
				{
					usrBasedTests += ","+test;
				}
			}
		}
	}
	//User license  ends

	String componentNickName = null;
	String selectedCompType = "";
	String testperiod = "";
	String adminUsers = "";
	String hostEditableMode = "";
	String portEditableMode = "";
	String[] componentsList = null;
	Hashtable ht_AgentsList = new Hashtable();
	List listAgents = null;
	ArrayList aListPasswordParameters = null;
	String allowedParams = "";
	String[] tcKeywords = new String[0];
	ArrayList aListTcKeywordsLowerCase = new ArrayList();
	String strTcKeywords = "";
	ArrayList aListDefaultPasswordParameters = null;
	ArrayList aListParamsWithDoubleQuotes = null;
	String strDoubleQuotesParams = "";
	String strDelimiter = "";
	String strDelimiterMask = "";
	String paramForDisplayingValidateButton="";

	//contains enabled test for a component type
	ArrayList aListEnabledTestForCompType = new ArrayList();

	ArrayList unconfiguredTestList = new ArrayList();
	ArrayList defaultconfiguredTestList = new ArrayList();
	ArrayList userconfiguredTestList = new ArrayList();
	ArrayList excludedTestList = new ArrayList();

	ArrayList aResultant = new ArrayList();
	//lowercase in unordered format of aResultant
	ArrayList aListResultantTempInLowerCase = new ArrayList();
	//lowercase in ordered format of aResultant
	ArrayList aListResultantInLowerCase = new ArrayList();

	//apply to other components
	ArrayList aListConfigureComponents = new ArrayList();
	ArrayList aListConfigureComponentsClone = null;

	//For SNMP - Start
	String[] versions = {"v1","v2","v3"};
	String[] authTypes = {"MD5","SHA"};
	String[] encryptTypes = {"DES","AES"};
	boolean isSnmp = false;
	boolean isLogFile = false;
	boolean isWarFile = false;
	boolean isSnmpV1V2 = false;
	boolean donotShowParamForSnmpV3 = false;
	boolean isSnmpV3 = false;
	boolean isOldSnmp = false;
	String encryptValue = "";
	String encryptFlag = "";
	String snmpVer = "";
	String tempSnmpVersion = "";
	//For SNMP - End

	boolean isRemote = false;
	boolean isUrlParamExist = false;
	boolean isPortRelevantForTest = false;
	boolean isInfoRelevantForTest = false;
	boolean isAggregateTest = false;
	boolean isModeParamExist =false;
	boolean isMeasureModeParamExist =false;
	boolean isMeasurementModeParamExist =false;
	//for tests which is mutiple user enabled
	boolean multiUserMode = false;
	boolean multiNamePatternMode = false;
	boolean isCredentialParamExist = false;
	boolean isWsdlUrlExist=false;
	boolean isPrivateKeyParamExist = false;

	boolean isTestConfigurable = true;//Scenario : The test is disabled.
	boolean isComponentConfigurable = true;//Scenario : The component is either unmanaged or deleted.

	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;
	boolean isAutoSelected = false;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	//policy filter start
	boolean isPolicyParamExists = false;
	ArrayList aPolicyFilter = new ArrayList();
	String tPolicyFilter = "";
	//policy filter end

	//show_alias_and_interface_name - starts
	boolean hasShowAliasParam = false;
	String useAliasValue = "";
	String strFromReConfig = "";
	//show_alias_and_interface_name - ends

	//ejbtest start
	boolean isEjbGroupingRequired = false;
	String pageNameForEjbGrouping = "";
	//ejbtest end

	//Detailed diagnosis - starts
	boolean detailedDiagnosisOptionEnabled = true;
	boolean allowDetailedDiagnosis = false;
	boolean isTestDetailedDiagnosisDisabledGlobally = false;
	String detailedDiagnosisOn = "";
	String detailedDiagnosisOff = "";
	//Detailed diagnosis - ends

	//contains multiple user enabled test - starts
	List listMultipleUserSupportTest = null;
	//contains multiple user enabled test - starts

	//intimate to user - no enabled tests found for a component type - starts
	boolean isAtleastOneTestEnabled = true;
	//intimate to user - no enabled tests found for a component type - ends

	//set the test period value defaultly to -1
	int minimumTestPeriod = -1;

	//virtual center
	String[] virtualCenters = null;

	//HMC
	String[] hmcs = null;
	boolean isHMC = false;
	String resIsManagedByValue = "";

	//RHEV
	String[] rhevs = null;

	//Oracle Database
	boolean isOracleDatabaseCompType = false;

	//url parameter(Http or HttpPost Test)
	String previousUrl = null;

	String remoteAgent="";

	ArrayList listOfComponents = new ArrayList();
	ArrayList aUrlCredentialVal = new ArrayList();
	ArrayList aListParamNamesValues = new ArrayList();
	ArrayList aListDisplay = new ArrayList();
	ArrayList aListDescriptorParam=new ArrayList();
	ArrayList aListContentValues = new ArrayList();
	ArrayList aListEncodingValues = new ArrayList();
	ArrayList aListFilePathValues = new ArrayList();

	//showAllOnly - starts
	boolean hasShowAllOnlyParam = false;
	String showAllEventsValue = "";
	//showAllOnly - ends

	//Report_only_total - starts
	boolean hasReportOnlyTotalParam = false;
	String reportTotalValue = "";
	//Report_only_total - ends

	TreeMap periodMap = new TreeMap();

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
	EgAgentInfo agentInfo = new EgAgentInfo("manager");
	//used for getting agent os for internal agent mapping
	AgentConfig agentconfig =  AgentConfig.getAgentConfig();
	EgDiscInfo egDisc = new EgDiscInfo("manager");

	String tmpUrl = "listSearch.jsp?title=AGENTS - TESTS - SPECIFIC CONFIGURATION&subtitle=false";
	String fromUnconfigTest = request.getParameter("reqfrom");
	fromUnconfigTest = (fromUnconfigTest == null)?"":fromUnconfigTest;
	if (fromUnconfigTest.length() > 0)
	{
		if (fromUnconfigTest.equalsIgnoreCase("UnconfigTests") || 
			fromUnconfigTest.equalsIgnoreCase("testView") || 
			fromUnconfigTest.equalsIgnoreCase("aggTestPeriod") || 
			fromUnconfigTest.equalsIgnoreCase("enabledisabletest"))
		{
			String showBackButton = request.getParameter("showBackButton");
			if (showBackButton != null && showBackButton.equals("false"))
			{
				tmpUrl = tmpUrl + "&backButton=false";
			}
			else
			{
				tmpUrl = tmpUrl + "&backButton=true";
			}
		}
		else if (fromUnconfigTest.equalsIgnoreCase("EgErrors.jsp"))
		{
			String showBackButton = request.getParameter("showBackButton");
			if (showBackButton != null && showBackButton.equals("true"))
			{
				tmpUrl = tmpUrl + "&backButton=true";
			}
		}
	}

	if (componentType != null && !componentType.equals("-1"))
	{
		componentsList = ri.getAllServersOfType(componentType);
		listOfComponents = new ArrayList(Arrays.asList(componentsList));

		if (testType.equalsIgnoreCase("PerformanceTest"))
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
		}

		if (aListEnabledTestForCompType.isEmpty())
		{
			isAtleastOneTestEnabled = false;
		}
	}

	boolean viewAccessOnly = false;

	String validationURL="/final/admin/validateApplicationServerCredentails.jsp";
	String validationUrlForWebservice = "/final/admin/validateWebServiceURL.jsp";
	String paramsForValidationURL="test="+EgURLEncoder.encode(testName,"UTF-8")+"&action=pickAgentToValidate&taskName="+EgURLEncoder.encode(componentType,"UTF-8")+"&compName="+EgURLEncoder.encode(componentName,"UTF-8")+"&componentType="+componentType+"&configurationType=specificConfiguration"+"&allowHostName="+isAllowHostName;
	String validationTitle=_mapping.getTextDescription("admin.common.Validating monitoring settings for")+" ";
	String requiredParamNames="";
	if (componentType != null && !componentType.equals("") && componentName != null && !componentName.equals("-1") && !componentName.equals(""))
	{
		egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
		requiredParamNames=egTestParamIni.getValue("VALIDATIONS_FIELDS",componentType+":Default");
		String specificValidationFieldsForTest=egTestParamIni.getValue("VALIDATIONS_FIELDS",testName);
		if(specificValidationFieldsForTest!=null && (!specificValidationFieldsForTest.equals("") && !specificValidationFieldsForTest.equalsIgnoreCase("null")))
		{
			requiredParamNames=requiredParamNames+","+specificValidationFieldsForTest;
		}
		StringBuffer sbreqValsForValidation=new StringBuffer(256);
		if(requiredParamNames!=null && !requiredParamNames.equals(""))
		{
			StringTokenizer stkvFields=new StringTokenizer(requiredParamNames,",");
			while(stkvFields.hasMoreTokens())
			{
				String fieldName=stkvFields.nextToken();
				fieldName=fieldName.toLowerCase();
				sbreqValsForValidation.append(fieldName+",");
			}
		}
		requiredParamNames=sbreqValsForValidation.toString()+"componentcredentialsneededtodovalidation";
		if(requiredParamNames!=null && requiredParamNames.endsWith(","))
		 	requiredParamNames=requiredParamNames.substring(0,(requiredParamNames.length()-1));

		paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",testName);
		if(paramForDisplayingValidateButton!=null && (paramForDisplayingValidateButton.equals("") || paramForDisplayingValidateButton.equalsIgnoreCase("null")))
		{
			paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",componentType+":Default");
		}
		boolean hasPasswordParameters = false;
		String[] passwordTests = egTestParamIni.getVariables("PASSWORD");
		List listPasswordTests = Arrays.asList(passwordTests);
		for (int i=0;i<aListEnabledTestForCompType.size();i++)
		{
			String strTest = (String)aListEnabledTestForCompType.get(i);
			if (listPasswordTests.contains(strTest))
			{
				String strPasswordParams = egTestParamIni.getValue("PASSWORD",strTest);
				StringTokenizer stPasswordParams = new StringTokenizer(strPasswordParams,",");
				while (stPasswordParams.hasMoreTokens())
				{
					String tempParam = stPasswordParams.nextToken();
					tempParam = "-" + tempParam;
					if (aListPasswordParameters == null)
					{
						aListPasswordParameters = new ArrayList();
						hasPasswordParameters = true;
					}

					if (aListPasswordParameters.contains(tempParam)) continue;

					aListPasswordParameters.add(tempParam);
				}
			}
		}

		allowedParams = egTestParamIni.getValue("SPECIAL_CHARACTERS","Parameters");
		tcKeywords=egTestParamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
		List listTcKeywords = Arrays.asList(tcKeywords);
		strTcKeywords = listTcKeywords.toString();
		strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
		strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
		for (int i=0;i<listTcKeywords.size();i++)
		{
			String strKeyword = (String)listTcKeywords.get(i);
			strKeyword = strKeyword.trim();
			strKeyword = strKeyword.toLowerCase();
			aListTcKeywordsLowerCase.add(strKeyword);
		}

		String[] defaultControl = egTestParamIni.getVariables("PARAM-CONTROL");
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String tempParamName = defaultControl[i];
				String tempParamValue = egTestParamIni.getValue("PARAM-CONTROL",tempParamName);
				if (tempParamValue.equalsIgnoreCase("password"))
				{
					if (aListDefaultPasswordParameters == null)
					{
						aListDefaultPasswordParameters = new ArrayList();
					}

					aListDefaultPasswordParameters.add("-"+tempParamName.toLowerCase());
				}
			}
		}

		//String[] paramsWithDoubleQuotes = egTestParamIni.getVariables("ENCLOSE_WITH_DOUBLEQUOTES");
		String[] paramsWithDoubleQuotes = null;
		if (paramsWithDoubleQuotes != null && paramsWithDoubleQuotes.length > 0)
		{
			for (int i=0;i<paramsWithDoubleQuotes.length;i++)
			{
				String tempParamName = paramsWithDoubleQuotes[i];
				if (aListParamsWithDoubleQuotes == null)
				{
					aListParamsWithDoubleQuotes = new ArrayList();
				}
				aListParamsWithDoubleQuotes.add(tempParamName.toLowerCase());
			}

			strDoubleQuotesParams = aListParamsWithDoubleQuotes.toString();
			strDoubleQuotesParams = strDoubleQuotesParams.substring(1,strDoubleQuotesParams.length()-1);
			strDoubleQuotesParams = StringUtils.replace(strDoubleQuotesParams,", ",",");
		}

		isOracleDatabaseCompType = componentType.equals("Oracle_server");
		listAgents = getAgents(componentName);
		ht_AgentsList = getAgentsList(componentType,componentName);
		componentNickName = componentName.substring(0,componentName.indexOf(":"));
		isRemote = egExternalInfo.isRemoteBased(componentNickName);

		if (!listOfComponents.contains(componentType+":"+componentName))
		{
			isComponentConfigurable = false;
		}

		//Scenario : The component is either unmanaged or deleted
		if (!isComponentConfigurable)
		{
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Test"));
			sess_vec.addElement("EgConfigureComponentTests.jsp?&server="+componentType);
			sess_vec.addElement("Component not configurable");
			sess_vec.addElement(_mapping.getTextDescription("admin.test.This component is currently not available for configuration")+". ");
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".");
			session.setAttribute("vec_Errors",sess_vec);
%>
			<jsp:forward page="EgErrors.jsp"/>
<%
		}

		//To fetch excluded tests - Start
		prgBean.createFile("eg_disable.ini");
		String excludedTestForComp = prgBean.getStrValue(componentType,componentType+":"+componentName);
		if (excludedTestForComp != null && !excludedTestForComp.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForComp,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTestComp = (String)excludedTestTokens.nextElement();
				boolean isCompHost = aListEnabledTestForCompType.contains(excludeTestComp);
				if (isCompHost)
				{
					if (excludedTestList != null && !excludedTestList.contains(excludeTestComp))
					{
						excludedTestList.add(excludeTestComp);
					}
				}
			}
		}

		String excludedTestForHost = prgBean.getStrValue("Default_server","Default_server"+":"+componentNickName);
		if (excludedTestForHost != null && !excludedTestForHost.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForHost,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTest = (String)excludedTestTokens.nextElement();
				boolean isComptypeTest = aListEnabledTestForCompType.contains(excludeTest);
				if (isComptypeTest)
				{
					if (excludedTestList != null && !excludedTestList.contains(excludeTest))
					{
						excludedTestList.add(excludeTest);
					}
				}
			}
		}
		//To fetch excluded tests - End

		//Will contain only running tests after the removeAll operation
		aListEnabledTestForCompType.removeAll(excludedTestList);
		prgBean.createFile("eg_agents.ini");

		ArrayList unconfiguredConfTestList = new ArrayList();
		ArrayList defaultconfiguredConfTestList = new ArrayList();
		ArrayList userconfiguredConfTestList = new ArrayList();
		if (isConfigSupported)
		{
			ArrayList aListEnabledConfTestForCompType = null;
			if (!componentType.equals("") && !componentType.equals("-1"))
			{
				if (testType.equals("PerformanceTest"))
				{
					aListEnabledConfTestForCompType = egSpecs.getEnabledTests(componentType,true);
					for (int i=0;i<aListEnabledConfTestForCompType.size();i++)
					{
						String strEnabledConfTest = (String)aListEnabledConfTestForCompType.get(i);
						String tempConfAgentName = getAgentNickName(componentType,strEnabledConfTest,listAgents);

						if (tempConfAgentName == null) continue;

						String[] testConfVariables = prgBean.getVariables(tempConfAgentName);
						String resultantConfPattern = getResultantPattern(componentType,componentName,strEnabledConfTest,testConfVariables);

						if (resultantConfPattern == null) continue;

						String tempConfTestValue = prgBean.getStrValue(tempConfAgentName,resultantConfPattern);
						String tempTestConfConfigurationStatus = tempConfTestValue.substring(0,tempConfTestValue.indexOf(","));
						tempTestConfConfigurationStatus = tempTestConfConfigurationStatus.trim();

						if (tempTestConfConfigurationStatus.equalsIgnoreCase("-auto"))
						{
							if (tempConfTestValue.indexOf(" $") > -1 && hasUnConfiguredParam(tempConfTestValue,hasPasswordParameters,aListPasswordParameters,aListTcKeywordsLowerCase,aListDefaultPasswordParameters))
							{
								unconfiguredConfTestList.add(strEnabledConfTest);
							}
							else
							{
								defaultconfiguredConfTestList.add(strEnabledConfTest);
							}
						}
						else
						{
							userconfiguredConfTestList.add(strEnabledConfTest);
						}
					}
				}
			}
		}
		if(defaultconfiguredConfTestList != null && defaultconfiguredConfTestList.size() > 0)
		{
			enableConfTestSize = defaultconfiguredConfTestList.size();
		}
		for (int i=0;i<aListEnabledTestForCompType.size();i++)
		{
			String strEnabledTest = (String)aListEnabledTestForCompType.get(i);
			String tempAgentName = getAgentNickName(componentType,strEnabledTest,listAgents);

			if (tempAgentName == null) continue;

			String[] testVariables = prgBean.getVariables(tempAgentName);
			String resultantPattern = getResultantPattern(componentType,componentName,strEnabledTest,testVariables);

			if (resultantPattern == null) continue;

			String tempTestValue = prgBean.getStrValue(tempAgentName,resultantPattern);
			String tempTestConfigurationStatus = tempTestValue.substring(0,tempTestValue.indexOf(","));
			tempTestConfigurationStatus = tempTestConfigurationStatus.trim();

			if (tempTestConfigurationStatus.equalsIgnoreCase("-auto"))
			{
				if (tempTestValue.indexOf(" $") > -1 && hasUnConfiguredParam(tempTestValue,hasPasswordParameters,aListPasswordParameters,aListTcKeywordsLowerCase,aListDefaultPasswordParameters))
				{
					unconfiguredTestList.add(strEnabledTest);
				}
				else
				{
					defaultconfiguredTestList.add(strEnabledTest);
				}
			}
			else
			{
				userconfiguredTestList.add(strEnabledTest);
			}
		}

		unconfiguredTestList = sorter.getSortedTestList(unconfiguredTestList);
		defaultconfiguredTestList = sorter.getSortedTestList(defaultconfiguredTestList);
		userconfiguredTestList = sorter.getSortedTestList(userconfiguredTestList);
		excludedTestList = sorter.getSortedTestList(excludedTestList);

		ArrayList aListDesktopInfrastructures = usersInfo.getAllUserBasedCompTypes();
		if (userBasedLicense && aListDesktopInfrastructures != null && aListDesktopInfrastructures.contains(componentType))
		{
			viewAccessOnly = true;
		}

		if (testName != null && !testName.equals(""))
		{
			isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
			prgBean.createFile("eg_agents.ini");

			//fetch the exact agent
			String tempAgentName = getAgentNickName(componentType,testName,listAgents);
			tempAgentName = tempAgentName!=null?tempAgentName:"";

			String[] testVariables = prgBean.getVariables(tempAgentName);

			String resultantPattern = getResultantPattern(componentType,componentName,testName,testVariables);
			resultantPattern = resultantPattern!=null?resultantPattern:"";

			String tempTestValue = prgBean.getStrValue(tempAgentName,resultantPattern);
			String tempTestConfiguration = tempTestValue.substring(0,tempTestValue.indexOf(","));
			tempTestConfiguration = tempTestConfiguration.trim();
			if (tempTestConfiguration.equalsIgnoreCase("-auto"))
			{
				isAutoConfiguration = true;
			}
			aResultant = getTestValuesWithControl(tempTestValue,testName,egTestParamIni);
			testperiod = tempTestValue.substring(tempTestValue.lastIndexOf(EgConstants.COMMA)+1).trim();

			if (aResultant.isEmpty())
			{
				isTestConfigurable = false;
			}

			//Scenario : The test is disabled.
			if (!isTestConfigurable)
			{
				Vector sess_vec = new Vector();
				sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Test"));
				sess_vec.addElement("EgConfigureComponentTests.jsp?&server="+componentType);
				sess_vec.addElement("Test not configurable");
				sess_vec.addElement(_mapping.getTextDescription("admin.test.This test is currently not available for configuration")+". ");
				sess_vec.addElement(_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".");
				session.setAttribute("vec_Errors",sess_vec);
%>
				<jsp:forward page="EgErrors.jsp"/>
<%
			}

			IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
			String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
			if (!EgUtils.isNull((Object)testFormatPeriod))
			{
				for (int i=0;i<testFormatPeriod.length;i++)
				{
					String prdStr = uiIni.getValue("TEST_FREQUENCY",testFormatPeriod[i]);
					long lngVal = Long.parseLong(prdStr);
					periodMap.put(new Long(lngVal),testFormatPeriod[i]);
				}
			}

			hostEditableMode = uiIni.getValue("TEST_CONFIG_CONTROLS","hostEditable");
			portEditableMode = uiIni.getValue("TEST_CONFIG_CONTROLS","portEditable");

			//snmp work starts here
			for (int i=0;i<aResultant.size();i++)
			{
				aListResultantTempInLowerCase.add(aResultant.get(i).toString().toLowerCase());
			}

			if (aListResultantTempInLowerCase.contains("-usealias") && 
				aListResultantTempInLowerCase.contains("-show_alias_and_interface_name"))
			{
				hasShowAliasParam = true;
				int useAliasIdx = aListResultantTempInLowerCase.indexOf("-usealias");
				strFromReConfig = request.getParameter("fromReConfigure");
				String useAliasCase = (String)aResultant.get(useAliasIdx);
				useAliasCase = useAliasCase.substring(1);
				if (StringUtils.isNull(strFromReConfig))
				{
					useAliasValue = request.getParameter(useAliasCase);
				}
				if (useAliasValue == null || useAliasValue.length() == 0)
				{
					useAliasValue = (String)aResultant.get(useAliasIdx+1);
				}
			}

			isSnmp = aListResultantTempInLowerCase.contains("-snmpport");

			isLogFile = (aListResultantTempInLowerCase.contains("-jrehome") && 
				aListResultantTempInLowerCase.contains("-logfilename"));

			isWarFile = (aListResultantTempInLowerCase.contains("-ssl") && 
				aListResultantTempInLowerCase.contains("-url"));

			isModeParamExist = (isSnmp && 
								aListResultantTempInLowerCase.contains("-mode") && 
								aListResultantTempInLowerCase.contains("-jmx_remote_port"));

			isMeasureModeParamExist = (isLogFile && 
								aListResultantTempInLowerCase.contains("-measure_mode") && 
								aListResultantTempInLowerCase.contains("-jmx_remote_port"));

			isMeasurementModeParamExist = (isWarFile && 
								aListResultantTempInLowerCase.contains("-measurement_mode") && 
								aListResultantTempInLowerCase.contains("-jmx_remote_port"));

			if (aListResultantTempInLowerCase.contains("-showallevents") && 
				aListResultantTempInLowerCase.contains("-showallonly"))
			{
				hasShowAllOnlyParam = true;
				strFromReConfig = request.getParameter("fromReConfigure");
				int showAllEventsIdx = aListResultantTempInLowerCase.indexOf("-showallevents");
				String showAllEventsCase = (String)aResultant.get(showAllEventsIdx);
				showAllEventsCase = showAllEventsCase.substring(1);
				if (StringUtils.isNull(strFromReConfig))
				{
					showAllEventsValue = request.getParameter(showAllEventsCase);
				}
				if (showAllEventsValue == null || showAllEventsValue.length() == 0)
				{
					showAllEventsValue = (String)aResultant.get(showAllEventsIdx+1);
				}
			}

			if (aListResultantTempInLowerCase.contains("-report_total") && 
				aListResultantTempInLowerCase.contains("-report_only_total"))
			{
				hasReportOnlyTotalParam = true;
				strFromReConfig = request.getParameter("fromReConfigure");
				int reportTotalIdx = aListResultantTempInLowerCase.indexOf("-report_total");
				String reportTotalCase = (String)aResultant.get(reportTotalIdx);
				reportTotalCase = reportTotalCase.substring(1);
				if (StringUtils.isNull(strFromReConfig))
				{
					reportTotalValue = request.getParameter(reportTotalCase);
				}
				if (reportTotalValue == null || reportTotalValue.length() == 0)
				{
					reportTotalValue = (String)aResultant.get(reportTotalIdx+1);
				}
			}

			if (isMeasurementModeParamExist)
			{
				int portIdx = aListResultantTempInLowerCase.indexOf("-port");
				String portCase = null;
				if (portIdx != -1)
				{
					portCase = (String)aResultant.get(portIdx);
				}

				int modeIdx = aListResultantTempInLowerCase.indexOf("-measurement_mode");
				String modeCase = null;
				if (modeIdx != -1)
				{
					modeCase = (String)aResultant.get(modeIdx);
				}

				//put measure_mode after port
				//-host,-port,-measure_mode
				int tempModeIdx = aResultant.indexOf(modeCase);
				String moveModeParam = (String)aResultant.remove(tempModeIdx);
				String moveModeValue = (String)aResultant.remove(tempModeIdx);
				String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

				int tempPortIdx = aResultant.indexOf(portCase);
				aResultant.add(tempPortIdx+3,moveModeParam);
				aResultant.add(tempPortIdx+4,moveModeValue);
				aResultant.add(tempPortIdx+5,moveModeDisplayControl);
			}

			if (isMeasureModeParamExist)
			{
				int portIdx = aListResultantTempInLowerCase.indexOf("-port");
				String portCase = null;
				if (portIdx != -1)
				{
					portCase = (String)aResultant.get(portIdx);
				}

				int modeIdx = aListResultantTempInLowerCase.indexOf("-measure_mode");
				String modeCase = null;
				if (modeIdx != -1)
				{
					modeCase = (String)aResultant.get(modeIdx);
				}

				//put measure_mode after port
				//-host,-port,-measure_mode
				int tempModeIdx = aResultant.indexOf(modeCase);
				String moveModeParam = (String)aResultant.remove(tempModeIdx);
				String moveModeValue = (String)aResultant.remove(tempModeIdx);
				String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

				int tempPortIdx = aResultant.indexOf(portCase);
				aResultant.add(tempPortIdx+3,moveModeParam);
				aResultant.add(tempPortIdx+4,moveModeValue);
				aResultant.add(tempPortIdx+5,moveModeDisplayControl);
			}

			if (isSnmp)
			{
				int portIdx = aListResultantTempInLowerCase.indexOf("-port");
				String portCase = null;
				if (portIdx != -1)
				{
					portCase = (String)aResultant.get(portIdx);
				}

				int timeOutIdx = aListResultantTempInLowerCase.indexOf("-timeout");
				String timeOutCase = null;
				if (timeOutIdx != -1)
				{
					timeOutCase = (String)aResultant.get(timeOutIdx);
				}

				int modeIdx = aListResultantTempInLowerCase.indexOf("-mode");
				String modeCase = null;
				if (modeIdx != -1)
				{
					modeCase = (String)aResultant.get(modeIdx);
				}

				int snmpComIdx=aListResultantTempInLowerCase.indexOf("-snmpcommunity");

				//for older version of snmp not having snmpversion
				String selectToAdd = "";
				if (!aListResultantTempInLowerCase.contains("-snmpversion"))
				{
					aResultant.add(snmpComIdx+3,"-snmpversion");
					aResultant.add(snmpComIdx+4,"v1");
					aResultant.add(snmpComIdx+5,"select");

					aListResultantTempInLowerCase.add(snmpComIdx+3,"-snmpversion");
					aListResultantTempInLowerCase.add(snmpComIdx+4,"v1");
					aListResultantTempInLowerCase.add(snmpComIdx+5,"select");

					selectToAdd = selectToAdd + ",snmpversion";
					isOldSnmp = true;

					String[] tmpVersions = {"v1","v2"};
					versions = tmpVersions;
				}

				if (aListResultantTempInLowerCase.contains("-snmpversion") && !aListResultantTempInLowerCase.contains("-authtype") && !aListResultantTempInLowerCase.contains("-encrypttype"))
				{
					isOldSnmp = true;

					String[] tmpVersions = {"v1","v2"};
					versions = tmpVersions;
				}

				if (selectToAdd.length() > 0)
				{
					IniFile egTestParamIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testparam.ini");
					egTestParamIniSync.setValue("SELECT",testName,selectToAdd.substring(1));
					egTestParamIniSync.saveFile();
					EgConfigFilesSync.releaseInstance(egTestParamIniSync);
				}

				int snmpVerIdx = aListResultantTempInLowerCase.indexOf("-snmpversion");

				String originalSnmpParam = ((String)aResultant.get(snmpVerIdx)).substring(1);
				if (testName.equals(previousTestName))
				{
					snmpVer = request.getParameter(originalSnmpParam);
					snmpVer = (snmpVer!=null)?snmpVer:"";
				}

				if (snmpVer.equals(""))
				{
					isSnmpV1V2 = (aListResultantTempInLowerCase.contains("v1") || aListResultantTempInLowerCase.contains("v2"))?true:false;
				}
				else
				{
					isSnmpV1V2 = (snmpVer.equalsIgnoreCase("v1") || snmpVer.equalsIgnoreCase("v2"))?true:false;
				}

				if(!isSnmpV1V2)
				{
					encryptValue = (String)aResultant.get(aListResultantTempInLowerCase.indexOf("-encryptflag")+1);
				}

				//displaying snmp community afer snmp version
				String moveSnmpCommParam = (String)aResultant.remove(snmpComIdx);
				String moveSnmpCommValue = (String)aResultant.remove(snmpComIdx);
				String moveSnmpCommDisplayControl = (String)aResultant.remove(snmpComIdx);

				int tempSnmpVerIdx = aResultant.indexOf("-"+originalSnmpParam);
				aResultant.add(tempSnmpVerIdx+3,moveSnmpCommParam);
				aResultant.add(tempSnmpVerIdx+4,moveSnmpCommValue);
				aResultant.add(tempSnmpVerIdx+5,moveSnmpCommDisplayControl);

				int encryptFlagIdx = aListResultantTempInLowerCase.indexOf("-encryptflag");
				if (encryptFlagIdx > -1)
				{
					encryptFlag = request.getParameter(((String)aResultant.get(encryptFlagIdx)).substring(1));
				}
				encryptFlag = (encryptFlag!=null)?encryptFlag:"";

				if (isModeParamExist)
				{
					if (timeOutIdx == -1)
					{
						//put mode after port
						//-host,-port,-mode
						int tempModeIdx = aResultant.indexOf(modeCase);
						String moveModeParam = (String)aResultant.remove(tempModeIdx);
						String moveModeValue = (String)aResultant.remove(tempModeIdx);
						String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

						int tempPortIdx = aResultant.indexOf(portCase);
						aResultant.add(tempPortIdx+3,moveModeParam);
						aResultant.add(tempPortIdx+4,moveModeValue);
						aResultant.add(tempPortIdx+5,moveModeDisplayControl);
					}
					else
					{
						int tempTimeOutCaseIdx = aResultant.indexOf(timeOutCase);
						String moveTimeOutParam = (String)aResultant.remove(tempTimeOutCaseIdx);
						String moveTimeOutValue = (String)aResultant.remove(tempTimeOutCaseIdx);
						String moveTimeOutDisplayControl = (String)aResultant.remove(tempTimeOutCaseIdx);

						//-host,-port,-timeout,-mode
						//put timeout after port
						int tempPortIdx = aResultant.indexOf(portCase);
						aResultant.add(tempPortIdx+3,moveTimeOutParam);
						aResultant.add(tempPortIdx+4,moveTimeOutValue);
						aResultant.add(tempPortIdx+5,moveTimeOutDisplayControl);

						int tempModeCaseIdx = aResultant.indexOf(modeCase);
						String moveModeParam = (String)aResultant.remove(tempModeCaseIdx);
						String moveModeValue = (String)aResultant.remove(tempModeCaseIdx);
						String moveModeDisplayControl = (String)aResultant.remove(tempModeCaseIdx);

						//put mode after timeout
						int tempTimeOutCaseIdx1 = aResultant.indexOf(timeOutCase);
						aResultant.add(tempTimeOutCaseIdx1+3,moveModeParam);
						aResultant.add(tempTimeOutCaseIdx1+4,moveModeValue);
						aResultant.add(tempTimeOutCaseIdx1+5,moveModeDisplayControl);
					}
				}
			}
			//snmp work end here

			//policy filter work starts here
			isPolicyParamExists = aListResultantTempInLowerCase.contains("-policyfilter") && aListResultantTempInLowerCase.contains("-filter");

			String tLogType = "";
			int tLogTypeIdx = aListResultantTempInLowerCase.indexOf("-logtype");
			if (tLogTypeIdx > -1)
			{
				tLogType = request.getParameter(((String)aResultant.get(tLogTypeIdx)).substring(1));
			}
			tLogType = (tLogType != null && tLogType.length() > 0)?tLogType:"";

			int tPolicyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
			if (tPolicyFilterIdx > -1)
			{
				tPolicyFilter = request.getParameter(((String)aResultant.get(tPolicyFilterIdx)).substring(1));
			}
			tPolicyFilter = (tPolicyFilter != null && tPolicyFilter.length() > 0)?tPolicyFilter:"";

			if (isPolicyParamExists)
			{
				int policyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
				String policyFilterValue = (String)aResultant.get(policyFilterIdx+1);

				if ((policyFilterValue.equalsIgnoreCase("true") && 
					(tPolicyFilter.length()==0 || tPolicyFilter.equalsIgnoreCase("true"))) || 
					tPolicyFilter.equalsIgnoreCase("true"))
				{
					IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
					String testParam[] = testsIni.getVariables("EVENTLOG_POLICIES");
					for(int i = 0;i<testParam.length;i++)
					{
						if(!(testParam[i].startsWith(testName+":"))) continue;
						String str = testParam[i].substring(testParam[i].lastIndexOf(":")+1,testParam[i].length());
						aPolicyFilter.add(str);
					}
				}
				if(tPolicyFilter.equalsIgnoreCase("false"))
				{
					ArrayList aListPolicy = new ArrayList();
					int filterIdx = aListResultantTempInLowerCase.indexOf("-filter");
					String filterValue = (String)aResultant.get(filterIdx+1);
					if(filterValue.indexOf(":") > -1)
					{
						if(filterValue.indexOf(";") > -1)
						{
							StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
							while(policyTokens.hasMoreTokens())
							{
								String tempPolicy = policyTokens.nextToken();
								tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
								aListPolicy.add(tempPolicy);
							}
						}
						else
						{
							aListPolicy.add(filterValue.substring(0,filterValue.indexOf(":")));
						}
					}
					else
					{
						if(filterValue.indexOf(";")>-1)
						{
							//more than one policy name i.e -filter IISEvents;CitrixEvents;XchgEvents
							StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
							while(policyTokens.hasMoreTokens())
							{
								aListPolicy.add(policyTokens.nextToken());
							}
						}
						else
						{
							//one policy name i.e -filter IISEvents
							aListPolicy.add(filterValue);
						}
					}
					IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
					for(int c=0;c<aListPolicy.size();c++)
					{
						String pattern = testName+":"+tLogType+":"+aListPolicy.get(c);
						String strVal = testsIni.getValue("EVENTLOG_POLICIES",pattern);
						strVal = (aListPolicy.get(c)).toString()+":"+strVal;
						aPolicyFilter.add(strVal);
					}
				}

				if (aPolicyFilter.size() > 0)
				{
					if (aPolicyFilter.contains("all"))
					{
						aPolicyFilter.remove("all");
						Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
						aPolicyFilter.add(0,"all");
					}
					else
					{
						Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					}
				}
			}
			//policy filter work ends here

			//credential work starts here(http test)
			String moreUrl = request.getParameter("moreurl");
			moreUrl = (moreUrl!=null)?moreUrl:"";
			isCredentialParamExist = aListResultantTempInLowerCase.contains("-credentials");
			isUrlParamExist = aListResultantTempInLowerCase.contains("-url");
			isWsdlUrlExist = aListResultantTempInLowerCase.contains("-wsdl_url");
			isPrivateKeyParamExist = aListResultantTempInLowerCase.contains("-privatekey");
			ArrayList aTempUrl = new ArrayList();
			if (isCredentialParamExist)
			{
				int urlIdx=0;
				if(isUrlParamExist)
					urlIdx = aListResultantTempInLowerCase.indexOf("-url");
				else if(isWsdlUrlExist)
					urlIdx = aListResultantTempInLowerCase.indexOf("-wsdl_url");

				String urls = aResultant.get(urlIdx+1).toString();
				previousUrl = urls;
				StringTokenizer urlTokens = new StringTokenizer(urls,"|");
				int urlCount = urlTokens.countTokens();
				int credentialIdx = aListResultantTempInLowerCase.indexOf("-credentials");
				String credentialValues = aResultant.get(credentialIdx+1).toString();
				StringTokenizer credentialValuesTokens = new StringTokenizer(credentialValues,"|");
				int credentialTokens = credentialValuesTokens.countTokens();

				int contentIdx = aListResultantTempInLowerCase.indexOf("-content");
				String contentValues = aResultant.get(contentIdx+1).toString();
				StringTokenizer contentValuesTokens = new StringTokenizer(contentValues,"|");
				int contentTokens = contentValuesTokens.countTokens();

				int encodingIdx = aListResultantTempInLowerCase.indexOf("-encoding");
				String encodingValues = aResultant.get(encodingIdx+1).toString();
				StringTokenizer encodingValuesTokens = new StringTokenizer(encodingValues,"|");
				int encodingTokens = encodingValuesTokens.countTokens();

				//will encounter when urlCount exceeds credentialTokens and vice versa
				//This case will be encountered in apply to other component case
				if (urlCount != credentialTokens)
				{
					if (urlCount > credentialTokens)
					{
						int difference = urlCount - credentialTokens;
						String tempPassword = EgCrypt.encrypt("none");
						for (int i=0;i<difference;i++)
						{
							credentialValues = credentialValues + "|" + "none" + ":" +tempPassword;
						}
					}
					if (urlCount < credentialTokens)
					{
						int difference = credentialTokens - urlCount;
						for (int i=0;i<difference;i++)
						{
							credentialValues = credentialValues.substring(0,credentialValues.lastIndexOf("|"));
						}
					}
					credentialValuesTokens = new StringTokenizer(credentialValues,"|");
				}

				if (urlCount != contentTokens)
				{
					if (urlCount > contentTokens)
					{
						int difference = urlCount - contentTokens;
						for (int i=0;i<difference;i++)
						{
							contentValues = contentValues + "|" + "none:none";
						}
					}
					if (urlCount < contentTokens)
					{
						int difference = contentTokens - urlCount;
						for (int i=0;i<difference;i++)
						{
							contentValues = contentValues.substring(0,contentValues.lastIndexOf("|"));
						}
					}
					contentValuesTokens = new StringTokenizer(contentValues,"|");
				}

				if (urlCount != encodingTokens)
				{
					if (urlCount > encodingTokens)
					{
						int difference = urlCount - encodingTokens;
						for (int i=0;i<difference;i++)
						{
							encodingValues = encodingValues + "|" + "none";
						}
					}
					if (urlCount < encodingTokens)
					{
						int difference = encodingTokens - urlCount;
						for (int i=0;i<difference;i++)
						{
							encodingValues = encodingValues.substring(0,encodingValues.lastIndexOf("|"));
						}
					}
					encodingValuesTokens = new StringTokenizer(encodingValues,"|");
				}
				
				String filePathValues ="";
				StringTokenizer filePathValuesTokens =null;
				int filePathTokens =0;
				if(isPrivateKeyParamExist)
				{
					int filePathIdx = aListResultantTempInLowerCase.indexOf("-privatekey");
					filePathValues = aResultant.get(filePathIdx+1).toString();
					filePathValuesTokens = new StringTokenizer(filePathValues,"|");
					filePathTokens = filePathValuesTokens.countTokens();
					if (urlCount != filePathTokens)
					{
						if (urlCount > filePathTokens)
						{
							int difference = urlCount - filePathTokens;
							String tempPassword = EgCrypt.encrypt("none");
							for (int i=0;i<difference;i++)
							{
								filePathValues = filePathValues + "|" + "none" + ":" +tempPassword;
							}
						}
						if (urlCount < filePathTokens)
						{
							int difference = filePathTokens - urlCount;
							for (int i=0;i<difference;i++)
							{
								filePathValues = filePathValues.substring(0,filePathValues.lastIndexOf("|"));
							}
						}
						filePathValuesTokens = new StringTokenizer(filePathValues,"|");
					}
				}

				while(urlTokens.hasMoreTokens())
				{
					String s = urlTokens.nextToken();
					if (s.indexOf(":") > -1) //URL Format->$name:$url
					{
						aUrlCredentialVal.add(s.substring(0,s.indexOf(":")));
						String s1 = credentialValuesTokens.nextElement().toString();
						aUrlCredentialVal.add(s1.substring(0,s1.indexOf(":")));
						//decrypting the password
						String s2 = s1.substring(s1.indexOf(":")+1);
						s2 = EgCrypt.decrypt(s2);
						aUrlCredentialVal.add(s2);

						String s3 = contentValuesTokens.nextElement().toString();
						aListContentValues.add(s3);
						String s4 = encodingValuesTokens.nextElement().toString();
						aListEncodingValues.add(s4);
						
						if(isPrivateKeyParamExist)
						{
							String s5 = filePathValuesTokens.nextElement().toString();
							if(s5 != null && s5.startsWith("none"))
							{
								if(s5.indexOf(":")>-1)
								{
									aListFilePathValues.add(s5.substring(0,s5.indexOf(":")));
									//decrypting the password
									String s6 = s5.substring(s5.indexOf(":")+1);
									aListFilePathValues.add(EgCrypt.decrypt(s6));
								}
							}
							else
							{
								if(s5.indexOf(":")>-1)
								{
									String start = s5.substring(0,s5.indexOf(":"));
									String remaining = s5.substring(s5.indexOf(":")+1);
									String end = "";
									String passStr = "";
									if(s5.indexOf(":/")> -1 || s5.indexOf(":\\")> -1)
									{
										end = remaining.substring(0, remaining.indexOf(":"));
										passStr = remaining.substring(remaining.indexOf(":")+1);
									}
									else
									{
										passStr = remaining;
									}
									if(end.length() > 0)
									{
										aListFilePathValues.add(start+":"+end);
									}
									else
									{
										aListFilePathValues.add(start);
									}
									//decrypting the password
									aListFilePathValues.add(EgCrypt.decrypt(passStr));
								}
							}
						}
					}
					else //URL Format->$unconfigured
					{
						aUrlCredentialVal.add("$unconfigured");
						aUrlCredentialVal.add("none");
						aUrlCredentialVal.add("none");

						aListContentValues.add("none:none");
						aListEncodingValues.add("none");
						
						if(isPrivateKeyParamExist)
						{
							aListFilePathValues.add("none");
							aListFilePathValues.add("none");
						}
					}
				}

				if (moreUrl.equals("true"))
				{
					String reqUrlVal = "";
					if(isUrlParamExist)
						reqUrlVal = request.getParameter("url");
					else if(isWsdlUrlExist)
						reqUrlVal = request.getParameter("WSDL_URL");

					StringTokenizer reqUrlTokens = new StringTokenizer(reqUrlVal,",");
					while (reqUrlTokens.hasMoreTokens())
					{
						String s3 = reqUrlTokens.nextToken();
						String s4 = s3.substring(0,s3.indexOf(":"));
						aTempUrl.add(s4);
						boolean urlExist = aUrlCredentialVal.contains(s4);
						if(urlExist)
						{
							int urlIndex = aUrlCredentialVal.indexOf(s4);
							String urlUsername = (String)aUrlCredentialVal.get(urlIndex+1);
							String urlUserpass = (String)aUrlCredentialVal.get(urlIndex+2);
							aTempUrl.add(urlUsername);
							aTempUrl.add(urlUserpass);
						}
						else
						{
							aTempUrl.add("none");
							aTempUrl.add("none");
						}
					}
					aUrlCredentialVal = aTempUrl;
				}
			}
			//credential work ends here

			//ejb test - starts
			String ejbValues = egSpecs.getTestsInGroup("EgConfigInfos.jsp");
			String[] values = StringUtils.getTokens(ejbValues,EgConstants.COMMA);
			ArrayList aListEjbValues = new ArrayList(Arrays.asList(values));
			if (aListEjbValues.contains(testName))
			{
				isEjbGroupingRequired = true;
				pageNameForEjbGrouping = "EgConfigInfos.jsp";
			}

			ejbValues = egSpecs.getTestsInGroup("EgConfigEjb.jsp");
			values = StringUtils.getTokens(ejbValues,EgConstants.COMMA);
			aListEjbValues = new ArrayList(Arrays.asList(values));
			if (aListEjbValues.contains(testName))
			{
				isEjbGroupingRequired = true;
				pageNameForEjbGrouping = "EgConfigEjb.jsp";
			}
			//ejb test - ends

			prgBean.createFile("eg_tests.ini");

			//contains multiple user enabled test
			listMultipleUserSupportTest = Arrays.asList(prgBean.getVariables("MULTIPLE_USERS"));

			//Detailed diagnosis - starts
			//Initial check for DD frequency from eg_tests.ini [FREQUENCY_MAPPING]
			//if normal and bad = 0 no dd option
			String normalFrequency = prgBean.getStrValue("FREQUENCY_MAPPING","Normal_frequency");
			String badFrequency = prgBean.getStrValue("FREQUENCY_MAPPING","Bad_frequency");
			if (normalFrequency.equalsIgnoreCase("0") && badFrequency.equalsIgnoreCase("0"))
			{
				detailedDiagnosisOptionEnabled = false;
			}
			if (detailedDiagnosisOptionEnabled)
			{
				prgBean.createFile("eg_format.ini");
				String[] detailedDiagnosisVariable = prgBean.getVariables("FORMAT");
				ArrayList aListDetailedDiagnosisTest = new ArrayList();
				for(int i=0;i<detailedDiagnosisVariable.length ;i++)
				{
					String detailedDiagnosisTest = detailedDiagnosisVariable[i].substring(0,detailedDiagnosisVariable[i].indexOf(":"));
					if (!aListDetailedDiagnosisTest.contains(detailedDiagnosisTest))
					{
						aListDetailedDiagnosisTest.add(detailedDiagnosisTest);
					}
				}

				ArrayList aListDisabledDetailedDiagnosisTest = new ArrayList();
				if (testName != null && aListDetailedDiagnosisTest.contains(testName))
				{
					allowDetailedDiagnosis = true;

					//Default
					prgBean.createFile("eg_testinfo.ini");
					String[] disableDDVariables = prgBean.getVariables("Disable_DD");
					for(int i=0;i<disableDDVariables.length;i++)
					{
						if(!aListDisabledDetailedDiagnosisTest.contains(disableDDVariables[i]))
						{
							aListDisabledDetailedDiagnosisTest.add(disableDDVariables[i]);
						}
					}

					//Specific
					Hashtable hashDDSpecficVariablesValues = new Hashtable();
					String[] disableSpecficDDVariables1 = prgBean.getVariables("Disable_Specific_DD");
					for(int i=0;i<disableSpecficDDVariables1.length;i++)
					{
						String str = prgBean.getStrValue("Disable_Specific_DD",disableSpecficDDVariables1[i]);
						hashDDSpecficVariablesValues.put(disableSpecficDDVariables1[i],str);
					}

					boolean specificDDCheck = false;
					String ddSpecficTest = "";
					if (isPortRelevantForTest)
					{
						ddSpecficTest = (String)hashDDSpecficVariablesValues.get(componentName);
					}
					else
					{
						ddSpecficTest = (String)hashDDSpecficVariablesValues.get(componentNickName+":NULL");
					}
					ddSpecficTest = (ddSpecficTest != null)?ddSpecficTest:"";
					StringTokenizer sTokens = new StringTokenizer(ddSpecficTest,",");
					while (sTokens.hasMoreTokens())
					{
						String eachTest  = sTokens.nextToken();
						if (eachTest.equals(testName))
						{
							specificDDCheck = true;
							break;
						}
					}

					if (aListDisabledDetailedDiagnosisTest.contains(testName) || specificDDCheck)
					{
						detailedDiagnosisOff = "checked";
					}
					else
					{
						detailedDiagnosisOn = "checked";
					}

					if (aListDisabledDetailedDiagnosisTest.contains(testName))
					{
						isTestDetailedDiagnosisDisabledGlobally = true;
					}
				}
			}
			//Detailed diagnosis - ends

			//egruntime - starts
			if ((aListResultantTempInLowerCase.contains("-process") || 
				aListResultantTempInLowerCase.contains("-servicename")) && 
				aListResultantTempInLowerCase.contains("(eg_runtime)"))
			{
				String hostOS = "";
				String pattern = "";
				if (isRemote)
				{
					hostOS = ((String)aResultant.get(aListResultantTempInLowerCase.indexOf("-os")+1)).trim();
					if (hostOS.equalsIgnoreCase("2016"))
					{
						hostOS = "Windows2016";
					}
					else if (hostOS.equalsIgnoreCase("2012"))
					{
						hostOS = "Windows2012";
					}
					else if (hostOS.equalsIgnoreCase("w2k"))
					{
						hostOS = "Windows2000";
					}
					else if (hostOS.equalsIgnoreCase("nt"))
					{
						hostOS = "WindowsNT";
					}
					else if (hostOS.equalsIgnoreCase("2003") || hostOS.equalsIgnoreCase("xp"))
					{
						hostOS = "Windows2003";
					}
					else if (hostOS.equalsIgnoreCase("2008") || hostOS.equalsIgnoreCase("Vista"))
					{
						hostOS = "Windows2008";
					}
					else if (hostOS.equalsIgnoreCase("solaris"))
					{
						hostOS = "Solaris";
					}
					else if (hostOS.equalsIgnoreCase("linux"))
					{
						hostOS = "Linux";
					}
					else if (hostOS.equalsIgnoreCase("aix"))
					{
						hostOS = "AIX";
					}
					else if (hostOS.equalsIgnoreCase("hpux"))
					{
						hostOS = "HPUX";
					}
					else if (hostOS.equalsIgnoreCase("tru64"))
					{
						hostOS = "Tru64";
					}
					else if (hostOS.equalsIgnoreCase("other"))
					{
						hostOS = "Other";
					}
				}
				else
				{
					hostOS = agentconfig.getAgentOS((String)listAgents.get(0));
				}
				if (hostOS != null)
				{
					prgBean.createFile("eg_tests.ini");
					pattern = prgBean.getStrValue("OS_PROCESSPATTERN",hostOS+":"+componentType+":"+testName);
					pattern = (!pattern.equals(""))?pattern:"(EG_RUNTIME)";
					pattern = StringUtils.replace(pattern,"#",EgConstants.COMMA);
					int processIdx = aListResultantTempInLowerCase.indexOf("-process");
					if (((String)aResultant.get(processIdx+1)).equals("(EG_RUNTIME)"))
					{
						aResultant.remove(processIdx+1);
						aResultant.add(processIdx+1,pattern);
					}
				}
			}
			//egruntime - ends

			//eghomedir starts
			if (aListResultantTempInLowerCase.contains("-alertfile"))
			{
				if (testName.equalsIgnoreCase("EgErrorLogTest") || 
					testName.equalsIgnoreCase("EgThreshLogTest") || 
					testName.equalsIgnoreCase("EgTrendLogTest"))
				{
					int logFileIndex = aListResultantTempInLowerCase.indexOf("-alertfile");
					String strValue = (String)aResultant.get(logFileIndex+1);
					if (strValue.indexOf("|") != -1)
					{
						String strUpdatedParamValue = "";
						StringTokenizer strTokens = new StringTokenizer(strValue,"|");
						while (strTokens.hasMoreTokens())
						{
							String strToken = strTokens.nextToken();
							strUpdatedParamValue = strUpdatedParamValue + strToken.substring(strToken.indexOf("(EG_HOME_DIR)")+13) + "|";
						}
						strValue = strUpdatedParamValue.substring(0,strUpdatedParamValue.length()-1);
					}
					else
					{
						strValue = strValue.substring(strValue.indexOf("(EG_HOME_DIR)")+13);
					}
					aResultant.remove(logFileIndex+1);
					aResultant.add(logFileIndex+1,strValue);
				}
			}
			//eghomedir ends

			//aggregate specific - starts
			EgAggregateInfo egAggInfo = new EgAggregateInfo("manager");
			isAggregateTest = egAggInfo.isAggregateTest(testName);
			if (allowAggregateOperation)
			{
				if (EgInstallInfo.isAggSupported && isAggregateTest)
				{
					ArrayList aListAggComp = new ArrayList();
					IniFile  aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
					String variables[] = aggIni.getVariables("AGGREGATE_COMPONENTS");
					if (variables != null && variables.length>0)
					{
						String temp = componentType + ":" + componentNickName + ":";
						for(int i=0;i<variables.length;i++)
						{
							if (!variables[i].startsWith(temp)) continue;
							aListAggComp.add(variables[i].substring(variables[i].indexOf("#")+1));
						}
					}

					IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
					String testSelected = aggIni.getValue("AGGREGATE_TEST",testName);

					for(int i=0;i<aListAggComp.size();i++)
					{
						String str = (String) aListAggComp.get(i);
						String tempCompType = str.substring(0,str.indexOf(":"));
						String tempCompName = str.substring(str.indexOf(":")+1,str.length());
						List agentNames = egExternalInfo.getAgentsFor(testSelected, tempCompType,tempCompName.substring(0,tempCompName.indexOf(":")));
						for(int k=0; k<agentNames.size(); k++)
						{
							String agentName = (String)agentNames.get(k);
							String tempVariables[] = agentsIni.getVariables(agentName);
							String specificPattern_A = testSelected + ":" + tempCompType + ":" + tempCompName;
							String specificPattern_B = testSelected + ":" + tempCompType + ":" + tempCompName.substring(0,tempCompName.indexOf(":"));
							String defaultPattern_A = testSelected + "::" + tempCompName;
							String defaultPattern_B = testSelected + "::" + tempCompName.substring(0,tempCompName.indexOf(":"));

							String s_temp  = "";

							List aListTempVariables = Arrays.asList(tempVariables);
							if (aListTempVariables.contains(specificPattern_A))
							{
								s_temp = specificPattern_A;
							}
							else if (aListTempVariables.contains(specificPattern_B))
							{
								s_temp = specificPattern_B;
							}
							else if (aListTempVariables.contains(defaultPattern_A))
							{
								s_temp = defaultPattern_A;
							}
							else if (aListTempVariables.contains(defaultPattern_B))
							{
								s_temp = defaultPattern_B;
							}

							if (s_temp.equalsIgnoreCase("")) continue;

							String iniValue = agentsIni.getValue(agentName,s_temp);
							String timePeriod = iniValue.substring(iniValue.lastIndexOf(EgConstants.COMMA)+1).trim();
							int intValue = Integer.parseInt(timePeriod);
							if (intValue > minimumTestPeriod) 
							{
								minimumTestPeriod = intValue;
							}
						}
					}
				}
			}
			//aggregate specific - ends

			//To configure value for specific Descriptor - starts
			com.eg.IniFile specIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini");
			String descriptorDetail =specIniFile.getValue("DESCRIPTOR_DETAILS",testName);
			StringTokenizer st = new StringTokenizer(descriptorDetail,",");
			while (st.hasMoreTokens())
			{
				aListDescriptorParam.add(st.nextToken());
			}
			//To configure value for specific Descriptor - ends

			//To do the following
			//1.Configure value for virtual centers 
			//2.Change webport value,when its value is default - starts
			if (aListResultantTempInLowerCase.contains("-webport") && 
				aListResultantTempInLowerCase.contains("-ssl"))
			{
				if (aListResultantTempInLowerCase.contains("-virtual_center"))
				{
					//To configure value for virtual centers - starts
					int tempVirtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
					String tempVirtual_centerValue = ((String)aResultant.get(tempVirtual_centerIdx+1)).trim();

					virtualCenters = servicesIniFile.getVariables("VIRTUAL_CENTER");
					String selectedVirtualCenter = "";
					if (testName.equals(previousTestName))
					{
						selectedVirtualCenter = request.getParameter("virtual_center");
						selectedVirtualCenter = (selectedVirtualCenter != null)?selectedVirtualCenter:"";
					}
					if (!selectedVirtualCenter.equals(""))
					{
						String sslValue = "";
						String esx_UserValue = "";
						String esx_PassWord = "";
						String webPort = "";
						String selectedVirtualCenterValue = "";
						if (selectedVirtualCenter.equalsIgnoreCase("none"))
						{
							if (tempVirtual_centerValue.equalsIgnoreCase("none"))
							{
								int tempIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
								esx_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
								esx_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								sslValue = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
								webPort = ((String)aResultant.get(tempIdx+1)).trim();

								if (webPort.equalsIgnoreCase("default"))
								{
									if (sslValue.equalsIgnoreCase("true") || 
									sslValue.equalsIgnoreCase("yes"))
									{
										webPort = "443";
									}
									else
									{
										webPort = "80";
									}
								}
							}
							else
							{
								esx_UserValue = "$unconfigured";
								esx_PassWord = "$unconfigured";
								sslValue = "true";
								webPort = "443";
							}
						}
						else if (selectedVirtualCenter.equalsIgnoreCase("other"))
						{
							esx_UserValue = "none";
							esx_PassWord = "none";
							sslValue = "true";
							webPort = "443";
						}
						else
						{
							selectedVirtualCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",selectedVirtualCenter);
							selectedVirtualCenterValue = (selectedVirtualCenterValue != null)?selectedVirtualCenterValue:"";
							if (!selectedVirtualCenterValue.equals(""))
							{
								StringTokenizer stVirtualCenterTokens = null;
								stVirtualCenterTokens = new StringTokenizer(selectedVirtualCenterValue,"#");
								sslValue = stVirtualCenterTokens.nextToken();
								esx_UserValue = stVirtualCenterTokens.nextToken();
								esx_PassWord = stVirtualCenterTokens.nextToken();
								stVirtualCenterTokens.nextToken();
								webPort = stVirtualCenterTokens.nextToken();
							}
						}

						int virtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
						aResultant.remove(virtual_centerIdx+1);
						aResultant.add(virtual_centerIdx+1,selectedVirtualCenter);

						int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						aResultant.remove(sslIdx+1);
						aResultant.add(sslIdx+1,sslValue.toLowerCase());

						int esx_userIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
						aResultant.remove(esx_userIdx+1);
						aResultant.add(esx_userIdx+1,esx_UserValue);

						int esx_PassWordIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
						aResultant.remove(esx_PassWordIdx+1);
						aResultant.add(esx_PassWordIdx+1,esx_PassWord);

						int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
						aResultant.remove(webPortIdx+1);
						aResultant.add(webPortIdx+1,webPort);
					}
					else
					{
						ArrayList aListTempVirtualCenters = null;
						boolean hasVirtualCenters = false;
						if (virtualCenters != null && virtualCenters.length > 0)
						{
							aListTempVirtualCenters = new ArrayList(Arrays.asList(virtualCenters));
							hasVirtualCenters = true;
						}

						if (tempVirtual_centerValue.equalsIgnoreCase("none"))
						{
							int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							String webPort = ((String)aResultant.get(tempIdx+1)).trim();
							if (webPort.equalsIgnoreCase("default"))
							{
								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
								if (sslValue.equalsIgnoreCase("true") || 
									sslValue.equalsIgnoreCase("yes"))
								{
									webPort = "443";
								}
								else
								{
									webPort = "80";
								}

								int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
								aResultant.remove(webPortIdx+1);
								aResultant.add(webPortIdx+1,webPort);
							}
						}
						else if ((aListTempVirtualCenters == null) || (hasVirtualCenters && !aListTempVirtualCenters.contains(tempVirtual_centerValue)))
						{
							//upgrade issue
							int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							String webPort = ((String)aResultant.get(tempIdx+1)).trim();
							if (webPort.equalsIgnoreCase("default"))
							{
								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
								if (sslValue.equalsIgnoreCase("true") || 
									sslValue.equalsIgnoreCase("yes"))
								{
									webPort = "443";
								}
								else
								{
									webPort = "80";
								}

								int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
								aResultant.remove(webPortIdx+1);
								aResultant.add(webPortIdx+1,webPort);
							}
						}
					}
					//To configure value for virtual centers - ends
				}
				else
				{
					int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
					String webPort = ((String)aResultant.get(webPortIdx+1)).trim();
					if (webPort.equalsIgnoreCase("default"))
					{
						int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						String tempSslValue = (String)aResultant.get(sslIdx+1);
						if (tempSslValue.equalsIgnoreCase("true") || 
							tempSslValue.equalsIgnoreCase("yes"))
						{
							webPort = "443";
						}
						else
						{
							webPort = "80";
						}
						aResultant.remove(webPortIdx+1);
						aResultant.add(webPortIdx+1,webPort);
					}
				}
			}
			//ends

			//To do the following
			//1.Configure value for HMCs
			if (aListResultantTempInLowerCase.contains("-is_managed_by") && 
				aListResultantTempInLowerCase.contains("-management_server"))
			{
				hmcs = servicesIniFile.getVariables("HMC");
				isHMC = true;

				if (testName.equals(previousTestName))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged == null)
					{
						String hmcMgmtServer = request.getParameter("management_server");
						if (hmcMgmtServer == null)
						{
							hmcMgmtServer = "none";
						}

						String strMgmtUser = "";
						String strMgmtPassword = "";
						if (hmcMgmtServer.equalsIgnoreCase("none"))
						{
							strMgmtUser = "$unconfigured";
							strMgmtPassword = "$unconfigured";
						}
						else
						{
							String strTemp = servicesIniFile.getValue("HMC",hmcMgmtServer);
							strTemp = strTemp.substring(strTemp.indexOf("#")+1);

							strMgmtUser = strTemp.substring(0,strTemp.indexOf("#"));
							strTemp = strTemp.substring(strTemp.indexOf("#")+1);

							strMgmtPassword = strTemp.substring(0,strTemp.indexOf("#"));
							strMgmtPassword = EgCrypt.decrypt(strMgmtPassword);
						}

						int managementUserIdx = aListResultantTempInLowerCase.indexOf("-management_user");
						aResultant.remove(managementUserIdx+1);
						aResultant.add(managementUserIdx+1,strMgmtUser);

						int managementPasswordIdx = aListResultantTempInLowerCase.indexOf("-management_password");
						aResultant.remove(managementPasswordIdx+1);
						aResultant.add(managementPasswordIdx+1,strMgmtPassword);
					}
					else
					{
						String tempManagedBy = request.getParameter("is_managed_by");
						if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("hmc"))
						{
							request.setAttribute("management_server","none");
							request.setAttribute("management_user","none");
							request.setAttribute("management_password","none");
						}
						else if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
						{
							request.setAttribute("management_server","$unconfigured");
							request.setAttribute("management_user","$unconfigured");
							request.setAttribute("management_password","$unconfigured");
						}
					}

					resIsManagedByValue = request.getParameter("is_managed_by");
				}
				else
				{
					int isManagedByIdx = aListResultantTempInLowerCase.indexOf("-is_managed_by");
					resIsManagedByValue = (String)aResultant.get(isManagedByIdx+1);
				}
			}

			////////RHEV- Code Starts
			if (aListResultantTempInLowerCase.contains("-rhel_mgr_host"))
			{
				rhevs = servicesIniFile.getVariables("RHEV");
				if (testName.equals(previousTestName))
				{
					String rhevManager = request.getParameter("Rhel_mgr_host");
					if (rhevManager == null)
					{
							rhevManager = "none";
					}
		
					String strRhevUser = "";
					String strRhevPassword = "";
					String strRhevPort = "";
					String strRhevDomain = "";
					String strSSL = "";
					if (rhevManager.equalsIgnoreCase("none"))
					{
						strRhevUser = "$unconfigured";
						strRhevPassword = "$unconfigured";
						strRhevPort = "8443";
						strRhevDomain = "internal";
						strSSL = "false";
					}
					else
					{
						String strTemp = servicesIniFile.getValue("RHEV",rhevManager);
						strSSL = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strRhevUser = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strRhevPassword = strTemp.substring(0,strTemp.indexOf("#"));
						strRhevPassword = EgCrypt.decrypt(strRhevPassword);
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);
						strRhevPort = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);
						strRhevDomain = strTemp;

					}
					int userIdx = aListResultantTempInLowerCase.indexOf("-rhel_mgr_user");
					aResultant.remove(userIdx+1);
					aResultant.add(userIdx+1,strRhevUser);

					int pwdIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_password");
					aResultant.remove(pwdIndex+1);
					aResultant.add(pwdIndex+1,strRhevPassword);

					int portIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_port");
					aResultant.remove(portIndex+1);
					aResultant.add(portIndex+1,strRhevPort);

					int domainIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_domain");
					aResultant.remove(domainIndex+1);
					aResultant.add(domainIndex+1,strRhevDomain);

					int sslIndex = aListResultantTempInLowerCase.indexOf("-ssl");
					aResultant.remove(sslIndex+1);
					aResultant.add(sslIndex+1,strSSL);
				}
			}
			////////RHEV - Code Ends

			//apply to other components - starts
			aListConfigureComponents = new ArrayList(listOfComponents);
			String currentConfigComponent = componentType + ":" + componentName;
			if (aListConfigureComponents.contains(currentConfigComponent))
			{
				aListConfigureComponents.remove(currentConfigComponent);
			}
			if (aListConfigureComponents.size() > 0)
			{
				prgBean.createFile("eg_disable.ini");
				aListConfigureComponentsClone = (ArrayList)aListConfigureComponents.clone();
				for (int i=0;i<aListConfigureComponents.size();i++)
				{
					String strComp = (String)aListConfigureComponents.get(i);
					strComp = strComp.substring(strComp.indexOf(":")+1,strComp.length());
					String tempComp = new String(strComp);
					String excludedTestForComponent = "";
					if (isPortRelevantForTest)
					{
						excludedTestForComponent = prgBean.getStrValue(componentType,componentType+":"+strComp);
					}
					else
					{
						strComp = strComp.substring(0,strComp.indexOf(":"));
						excludedTestForComponent = prgBean.getStrValue("Default_server","Default_server"+":"+strComp);
					}

					if (excludedTestForComponent.equals("")) continue;

					StringTokenizer stComp = new StringTokenizer(excludedTestForComponent,",");
					while(stComp.hasMoreTokens())
					{
						String strTest = stComp.nextToken();
						if (strTest.equals(testName))
						{
							aListConfigureComponentsClone.remove(componentType+":"+tempComp);
							break;
						}
					}
				}
			}
			//apply to other components - ends
		}
	}

%>

<%!
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	String[] getAllExternalServerTypes = egSpecs.getAllExternalServerTypes();
	List listExternalServerTypes = Arrays.asList(getAllExternalServerTypes);

	//param to continue globally
	String[] paramToContinue = {"mCount","rptName","agentless","Hyperv","remotePort","isLdoms","server_type_name"};

	//process paramters to be continued in remote based monitoring
	String[] processParamremoteContinue = {"agentless","aluser","alpassword","correct","almode","os","sshPort"};

	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	//param to be continued in snmpV3 when encrypt param is false
	String[] snmpV3ParamToContinue = {"encrypttype","encryptpassword"};

	//param to set in read-only mode when the test is set to have muti-user enabled
	String[] multiUserReadOnlyParam = {"user","admin_user","domain","password","admin_password"};
	String[] multiNameReadOnlyParam = {"name","pattern","threshold_value"};

	//param to continue when mode is true.(applicable to java application component type)
	String[] modeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","user","password"};

	//param to continue when mode is false.(applicable to java application component type)
	String[] modeFalseToContinue = {"snmpversion","snmpcommunity","snmpPort","authtype","authpass","username","encryptflag","encryptpassword","encrypttype"};

	//param to continue when measure mode is true.(applicable to JvmMemPoolGCTest alone)
	String[] measureModeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","user","password"};

	//param to continue when measure mode is false.(applicable to JvmMemPoolGCTest alone)
	String[] measureModeFalseToContinue = {"JREHome","LogFileName"};

	//param to continue when measure mode is true.(applicable to java application Tomcat & JBoss component types)
	String[] measurementModeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","Jmx_user","Jmx_password"};

	//param to continue when measure mode is false.(applicable to java application Tomcat & JBoss component types)
	String[] measurementModeFalseToContinue = {"ssl","url","username","password","encryptPass"};

	String[] targetDiskIORateLabel = {"Equals","Less Than","Less Than or Equal To","Greater Than","Greater Than or Equal To"};

	String[] paramsNeededToDoValidation={"agentless","almode","aluser","alpassword","info","sshPort","os","rptname"};

	String[] targetDiskIORateValue = {"EQ","LT","LE","GT","GE"};

	ArrayList aListDynamicSelectOptionNameAndValue = null;
	ArrayList aListDynamicRadioOptionNameAndValue = null;

	ArrayList aListPages = new ArrayList();
	public ArrayList getTestValuesWithControl(String testValues,String testName,IniFile egTestParamIni)
	{
		ArrayList aResultant = new ArrayList();
		String temp = "";
		HashMap hmapTestParamDetails = new HashMap();

		aListDynamicSelectOptionNameAndValue = new ArrayList();
		aListDynamicRadioOptionNameAndValue = new ArrayList();

		StringTokenizer testVal = new StringTokenizer(testValues,",");
		testVal.nextToken();
		String reqTestVal = testVal.nextToken();

		//radio
		String testRadioValue = egTestParamIni.getValue("RADIO",testName);
		StringTokenizer radioTokens = new StringTokenizer(testRadioValue,",");
		while (radioTokens.hasMoreTokens())
		{
			String eachRadioToken = radioTokens.nextToken();
			if (eachRadioToken.indexOf("(") > -1 && eachRadioToken.indexOf(")") > -1)
			{
				String tempStrs = eachRadioToken.substring(eachRadioToken.indexOf("(")+1,eachRadioToken.indexOf(")"));
				eachRadioToken = eachRadioToken.substring(0,eachRadioToken.indexOf("("));
				if (!aListDynamicRadioOptionNameAndValue.contains(eachRadioToken))
				{
					aListDynamicRadioOptionNameAndValue.add(eachRadioToken);//param name
					aListDynamicRadioOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachRadioToken.toLowerCase(),"radio");
		}

		//select
		String testSelectValue = egTestParamIni.getValue("SELECT",testName);
		StringTokenizer selectTokens = new StringTokenizer(testSelectValue,",");
		while (selectTokens.hasMoreTokens())
		{
			String eachSelectToken = selectTokens.nextToken();
			if (eachSelectToken.indexOf("(") > -1 && eachSelectToken.indexOf(")") > -1)
			{
				String tempStrs = eachSelectToken.substring(eachSelectToken.indexOf("(")+1,eachSelectToken.lastIndexOf(")"));
				eachSelectToken = eachSelectToken.substring(0,eachSelectToken.indexOf("("));
				if (!aListDynamicSelectOptionNameAndValue.contains(eachSelectToken))
				{
					aListDynamicSelectOptionNameAndValue.add(eachSelectToken);//param name
					aListDynamicSelectOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachSelectToken.toLowerCase(),"select");
		}

		//password
		String testPwdValue = egTestParamIni.getValue("PASSWORD",testName);
		StringTokenizer pwdTokens = new StringTokenizer(testPwdValue,",");
		while (pwdTokens.hasMoreTokens())
		{
			String eachPwdToken = pwdTokens.nextToken();
			hmapTestParamDetails.put(eachPwdToken.toLowerCase(),"password");
		}

		//textarea
		String testTextAreaValue = egTestParamIni.getValue("TEXTAREA",testName);
		StringTokenizer txtAreaTokens = new StringTokenizer(testTextAreaValue,",");
		while (txtAreaTokens.hasMoreTokens())
		{
			String eachTxtAreaCount = txtAreaTokens.nextToken();
			hmapTestParamDetails.put(eachTxtAreaCount.toLowerCase(),"textarea");
		}

		String[] defaultControl = egTestParamIni.getVariables("PARAM-CONTROL");
		List listDefaultControls = new ArrayList();
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String strControls = (defaultControl[i]).toLowerCase();
				listDefaultControls.add(strControls);
			}
		}

		ArrayList aListTemp = getParameterList(reqTestVal,false);
		for (int i=0;i<aListTemp.size();i=i+2)
		{
			String strParamName = (String)aListTemp.get(i);
			String strSearch = strParamName.substring(1);
			strSearch = strSearch.toLowerCase();
			String strParamValue = (String)aListTemp.get(i+1);
			String controlName = null;

			boolean isParamExist = hmapTestParamDetails.containsKey(strSearch);
			if (isParamExist)
			{
				controlName = hmapTestParamDetails.get(strSearch).toString();
			}
			else if (listDefaultControls.contains(strSearch))
			{
				String tempName = strParamName.substring(1);
				controlName = egTestParamIni.getValue("PARAM-CONTROL",tempName.toLowerCase());
				if (controlName.indexOf("(") > -1 && controlName.indexOf(")") > -1)
				{
					String tempStrs = controlName.substring(controlName.indexOf("(")+1,controlName.length()-1);
					controlName = controlName.substring(0,controlName.indexOf("("));
					if (controlName.equals("select") && 
						!aListDynamicSelectOptionNameAndValue.contains(tempName))
					{
						aListDynamicSelectOptionNameAndValue.add(tempName);
						aListDynamicSelectOptionNameAndValue.add(tempStrs);
					}
					if (controlName.equals("radio") && 
						!aListDynamicRadioOptionNameAndValue.contains(tempName))
					{
						aListDynamicRadioOptionNameAndValue.add(strParamName.substring(1));
						aListDynamicRadioOptionNameAndValue.add(tempStrs);
					}
				}
			}
			else
			{
				controlName = "text";
			}

			aResultant.add(strParamName);
			aResultant.add(strParamValue);
			aResultant.add(controlName);
		}

		return aResultant;
	}

	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;

				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}

		return aListResultant;
	}

	public String removeNull(String componentName)
	{
		if (componentName != null && componentName.length()>0)
		{
			return (componentName.endsWith(":NULL"))?componentName.substring(0,componentName.indexOf(":NULL")):componentName;
		}
		else
		{
			return "";
		}
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);

			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	//provide a set of agents (internal or remote agent,external agent(s)) for a component
	private Hashtable getAgentsList(String componentType,String componentName)
	{
		Hashtable ht_agentsList = new Hashtable();

		boolean compNamehasOnlyExternalAgents = listExternalServerTypes.contains(componentType);

		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";

		if (!compNamehasOnlyExternalAgents)
		{
			boolean isRemote = false;
			//To fetch the exact agent for the selected component - start
			isRemote = egExternalInfo.isRemoteBased(componentNickName);
			if (isRemote)
			{
				//Agentless
				agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
				ht_agentsList.put("REMOTE AGENT",agentNickName);
			}
			else
			{
				//Auto or Manual
				String agentName = egExternalInfo.getAgentFor(componentNickName);
				if (agentName != null) //Manual
				{
					if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
					{
						agentNickName = (String)internalAgentMap.get(agentName);
					}
					else
					{
						agentNickName = agentName;
					}
				}
				else //Auto
				{
					agentNickName = componentNickName;
				}
				ht_agentsList.put("INTERNAL AGENT",agentNickName);
			}
			//To fetch the exact agent for the selected component - end
		}

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			ArrayList aListExtAgents = new ArrayList(Arrays.asList(extAgents));
			String strExtAgents = aListExtAgents.toString();
			strExtAgents = strExtAgents.substring(1,strExtAgents.length()-1);
			ht_agentsList.put("EXTERNAL AGENT",strExtAgents);
		}
		//To fetch the external agent for the selected component type - ends

		return ht_agentsList;
	}

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String testName,List listAgents)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			agentName = (String)listAgents.get(1);
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			agentName = (String)listAgents.get(0);
		}

		return agentName;
	}

	//Will provide the right pattern (variable) for a component
	private String getResultantPattern(String componentType,String componentName,String testName,String[] testVariables)
	{
		String tempResultantPattern = null;
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}

		return tempResultantPattern;
	}

	public boolean hasUnConfiguredParam(String paramValue,boolean hasPasswordParam,ArrayList aListPasswordParameters,ArrayList aListTcKeywordsLowerCase,ArrayList aListDefaultPasswordParameters)
	{
		boolean hasUnconfiguredParam = false;
		StringTokenizer st = new StringTokenizer(paramValue,",");
		st.nextToken();
		ArrayList aListParamNameValue = getParameterList(st.nextToken(),true);

		String snmpVersion = null;
		boolean isSnmp = aListParamNameValue.contains("-snmpversion");

		if (isSnmp)
		{
			//put snmp version before snmp community.
			int snmpCommunityIdx = aListParamNameValue.indexOf("-snmpcommunity");
			String snmpCommunityVal = (String)aListParamNameValue.get(snmpCommunityIdx+1);
			aListParamNameValue.remove(snmpCommunityIdx);
			aListParamNameValue.remove(snmpCommunityIdx);

			int snmpVerIdx = aListParamNameValue.indexOf("-snmpversion");
			snmpVersion = (String)aListParamNameValue.get(snmpVerIdx+1);

			aListParamNameValue.add(snmpVerIdx+2,"-snmpcommunity");
			aListParamNameValue.add(snmpVerIdx+3,snmpCommunityVal);
		}

		for (int i=0;i<aListParamNameValue.size();i=i+2)
		{
			String strParamName = (String)aListParamNameValue.get(i);
			String strParamValue = (String)aListParamNameValue.get(i+1);

			if (hasPasswordParam)
			{
				if (aListPasswordParameters.contains(strParamName))
				{
					continue;
				}
			}
			else if (aListDefaultPasswordParameters != null && aListDefaultPasswordParameters.contains(strParamName.toLowerCase()))
			{
				continue;
			}

			if (isSnmp && snmpVersion != null)
			{
				if (snmpVersion.equalsIgnoreCase("v3"))
				{
					if (strParamName.equalsIgnoreCase("-snmpcommunity"))
					{
						continue;
					}
				}
			}

			strParamValue = strParamValue.trim();
			if (strParamValue.startsWith("$") && aListTcKeywordsLowerCase.contains(strParamValue.toLowerCase()))
			{
				hasUnconfiguredParam = true;
				break;
			}
		}

		return hasUnconfiguredParam;
	}

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = EgCrypt.decrypt(encryptParam);
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}

	private boolean isItemExists(List searchList, String compValue)
	{
		Iterator i = searchList.iterator();
		while (i.hasNext())
		{
			String nextStr = (String) i.next();
			if(compValue.indexOf(nextStr) != -1 || (compValue.toUpperCase().indexOf(nextStr.toUpperCase())) != -1)
			{
				return true;
			}
		}
		return false;
	}
%>

<html>
<head>
<title>Component Type Test List</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui = "adminindex"/>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
<script  src="/final/jquery/ui/jquery.ui.widget.js"></script> 
<script  src="/final/jquery/ui/jquery.ui.mouse.js"></script>
<script  src="/final/jquery/ui/jquery.ui.draggable.js"></script>
<script  src="/final/jquery/ui/jquery.ui.resizable.js"></script>

<script language="JavaScript" src="eg_scripts/validate.js"></script>
<script language="JavaScript" src="eg_scripts/testvalidate.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/common.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/eg_configcomponent.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/ajaxutils.js"></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/prototype-1.6.0.3.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2" src="/final/scripts/screen_display.js"></script>
<script language="JavaScript" src="eg_scripts/eg_validate.js"></script>
<script language="javascript">

var $j = jQuery.noConflict();

$j(document).ready(function(){
	/*   JQuery Drag & Drop Functionality  (Begin)   */
	$j.globalVars = {
		maxHeight: $j(window).height(),
		maxWidth:  $j(window).width()
	};

	$j( "#WebServiceDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});
	$j( "#WebServiceResponseDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});
	/*   JQuery Drag & Drop Functionality  (End)   */
});

//for update button
var updationInProgress = "false";
var policyNameCheckFlag="true";
var policyName="";
var comp_type = "";
var plusButtonClicked="false";
var validationLoadingMsg="<table width='540' border='0' bgcolor='white' height='170px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top><egui:intnl text='admin.common.Trying to get validation information from the agent'/>...<br><egui:intnl text='admin.common.This may take a few minutes'/>...</td></tr></table>";
var validationManagerLoadingMsg="<table width='540' border='0' bgcolor='white' height='170px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top><egui:intnl text='admin.common.Trying to get validation information from the manager'/>...<br><egui:intnl text='admin.common.This may take a few minutes'/>...</td></tr></table>";
var vmlogLoadingMsg="<table width='100%' border='0' bgcolor='white' height='270px' style='padding-left:20px;'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top><egui:intnl text='admin.common.Please wait the log file is being loaded'/>...<br><egui:intnl text='admin.common.This may take a few minutes'/>...</td></tr></table>";

function showComponents()
{
	var thisForm = document.topology;
	var strSearch = document.getElementById('strSearch').value;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	thisForm.componentName.value = "-1";
	if (thisForm.testType != null && thisForm.testType.value != undefined)
	{
		thisForm.testType.value = "PerformanceTest";
	}
	
	thisForm.showPopup.value = "true";
	thisForm.testName.value = "";
	thisForm.method = "post";
	if (strSearch == null || strSearch == "" || strSearch == "Search")
	{
		thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType;
	}
	else
	{
		thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&strSearch="+strSearch;
	}
	thisForm.submit();
}
function showTestList(optionType)
{
	var thisForm = document.topology;
	var strSearch = '<%=strSearch%>';
	if (strSearch == "null")
	{
		strSearch = "";
	}
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	if (optionType == "componentName")
	{
		thisForm.showPopup.value = "true";
	}
	else
	{
		thisForm.showPopup.value = "true";
	}
	thisForm.testName.value = "";
	thisForm.method = "post";
	thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&strSearch="+strSearch;
	thisForm.submit();
}

function unconfigTestToExclude()
{
	//journey from unconfigTests to excludeTests
	var thisForm = document.topology;
	var unconfigTestsLen = thisForm.unconfigTests.options.length;
	var excludeTestsLen = thisForm.excludeTests.options.length;
	var unConfigTestList = thisForm.unconfigTests;
	var excludeTestList = thisForm.excludeTests;
	thisForm.showPopup.value = "false";
	var temp = "";
	if (unConfigTestList.selectedIndex == -1)
	{
		alert(_selectTest);
	}
	else
	{
		var usrTests ='<%=usrBasedTests%>';
		var usrTestArr = new Array();
		var findings = '';
		if (usrTests != null && usrTests != "")
		{
			usrTestArr = usrTests.split(",");
		}
		for (var i=0; i<unconfigTestsLen; i++)
		{
			if (unConfigTestList.options[i].selected == true)
			{
				var testTxt = unConfigTestList.options[i].text;
				var testVal = unConfigTestList.options[i].value;
				//user license  starts
				var needToContinue = false;
				for (var u=0;u<usrTestArr.length;u++)
				{
					var userTest = usrTestArr[u];
					if(userTest == testVal)
					{
						if (findings == '')
						{
							findings += testTxt;
						}else
						{
							findings += ','+testTxt;
						}
						needToContinue = true;
						break;
					}
				}
				if (needToContinue)
				{
					continue;
				}
				//ends
				temp = temp + testVal + ",";
				excludeTestList.options[excludeTestsLen++] = new Option(testTxt,testVal);
			}
		}
		if (findings != "")
		{
			alert("<egui:intnl text='admin.test.The following test(s) cannot be excluded as these tests are required for validating named user counts for eG licensing'/>. <egui:intnl text='admin.test.Test name(s)'/>: "+findings);			
		}
		for (var i = unconfigTestsLen; i>0; i--)
		{
			if(unConfigTestList.options[i-1].selected == true)
			{
				//User license -starts
				var testVal = unConfigTestList.options[i-1].value;
				var needToContinue = false;
				for (var u=0; u<usrTestArr.length; u++)
				{
					var userTest = usrTestArr[u];
					if(userTest == testVal)
					{
						needToContinue = true;
						break;					
					}
				}
				if(needToContinue)
				{
					continue;
				}				
				//User license -ends
				unConfigTestList.options[i-1] = null;
			}
		}

		temp = temp.substring(0,temp.length-1);
		if(temp!="")
		{
			var testVals = temp.split(",");
			thisForm.TestsForExclusion.value = testVals;
			thisForm.excludingState.value = "unconfiguredstate";
			thisForm.testName.value = "";
			thisForm.configurebutton.disabled = true;
			thisForm.unconfigexcludebutton.disabled = true;
			thisForm.reconfigurebutton.disabled = true;
			thisForm.configureexcludebutton.disabled = true;
			thisForm.includebutton.disabled = true;
			if (thisForm.updatebutton != null && thisForm.updatebutton.value != undefined)
			{
				thisForm.updatebutton.disabled = true;
			}
			thisForm.method = "post";
			thisForm.action = "EgExcludeComponents.jsp";
			thisForm.submit();
		}
	}
}

function configTestToExclude(enableConfTestSize)
{
	//journey from configTests to excludeTests
	var thisForm = document.topology;
	var configTestsLen = thisForm.configTests.options.length;
	var excludeTestsLen = thisForm.excludeTests.options.length;
	var configTestList = thisForm.configTests;
	var excludeTestList = thisForm.excludeTests;
	thisForm.showPopup.value = "false";
	var temp = "";
	if (configTestList.selectedIndex == -1)
	{
		alert(_selectTest);
	}
	else
	{
		var usrTests ='<%=usrBasedTests%>';
		var usrTestArr = new Array();
		var findings = '';
		if (usrTests != null && usrTests != "")
		{
			usrTestArr = usrTests.split(",");
		}
		for (var i=0; i<configTestsLen; i++)
		{
			if (configTestList.options[i].selected == true)
			{
				var testTxt = configTestList.options[i].text;
				var testVal = configTestList.options[i].value;
				//user license  starts
				var needToContinue = false;
				var index = usrTestArr.indexOf(testVal);
				for (var u=0;u<usrTestArr.length; u++)
				{
					var userTest = usrTestArr[u];
					if(userTest == testVal)
					{
						if (findings == '')
						{
							findings += testTxt;
						}else
						{
							findings += ','+testTxt;
						}
						needToContinue = true;
						break;
					}
				}
				if (needToContinue)
				{
					continue;
				}
				//ends
				temp = temp + testVal + ",";
				excludeTestList.options[excludeTestsLen++] = new Option(testTxt,testVal);
			}
		}
		if (findings != "")
		{
			alert ('<egui:intnl text="admin.test.The following test(s) cannot be excluded as these tests are required for validating named user counts for eG licensing"/>. '+'<egui:intnl text="admin.test.Test name(s)"/>: '+ findings);			
		}
		for (var i = configTestsLen; i>0; i--)
		{
			if (configTestList.options[i-1].selected == true)
			{
				//User license -starts
				var testVal = configTestList.options[i-1].value;
				var needToContinue = false;
				for (var u=0; u<usrTestArr.length;u++)
				{
					var userTest = usrTestArr[u];
					if(usrTestArr.indexOf(testVal) > -1)
					{
						needToContinue = true;
						break;
					}
				}
				if (needToContinue)
				{
					continue;
				}
				//User license -ends
				configTestList.options[i-1] = null;
			}
		}

		temp = temp.substring(0,temp.length-1);
		if(temp != "")
		{
			var testVals = temp.split(",");
			thisForm.TestsForExclusion.value = testVals;
			thisForm.excludingState.value = "configuredstate";
			thisForm.testName.value = "";
			thisForm.configurebutton.disabled = true;
			thisForm.unconfigexcludebutton.disabled = true;
			thisForm.reconfigurebutton.disabled = true;
			thisForm.configureexcludebutton.disabled = true;
			thisForm.includebutton.disabled = true;
			if (thisForm.updatebutton != null && thisForm.updatebutton.value != undefined)
			{
				thisForm.updatebutton.disabled = true;
			}
			if(enableConfTestSize >= 1)
			{
				thisForm.method = "post";
				thisForm.action = "EgExcludeComponents.jsp?enableConfTestSize=<%=enableConfTestSize%>";
			}
			else
			{
				thisForm.method = "post";
				thisForm.action = "EgExcludeComponents.jsp";
			}
			thisForm.submit();
		}
	}
}

function includeToUnconfigTest()
{
	//journey from excludeTests to unconfigTests
	var thisForm = document.topology;
	var excludeTestsLen = thisForm.excludeTests.options.length;
	var unconfigTestsLen = thisForm.unconfigTests.options.length;
	var excludeTestList = thisForm.excludeTests;
	var unConfigTestList = thisForm.unconfigTests;
	thisForm.showPopup.value = "false";
	var testVal = "";
	var temp = "";

	if (excludeTestList.selectedIndex == -1)
	{
		alert(_selectTest);
	}
	else
	{
		for (var i=0; i<excludeTestsLen; i++)
		{
			if (excludeTestList.options[i].selected == true)
			{
				testVal = excludeTestList.options[i].value;
				temp = temp + testVal + ",";
			}
		}

		for (var i=excludeTestsLen; i>0; i--)
		{
			if (excludeTestList.options[i-1].selected == true)
			{
				excludeTestList.options[i-1] = null;
			}
		}

		temp = temp.substring(0,temp.length-1);
		if(temp!="")
		{
			var testVals = temp.split(",");
			thisForm.TestsForInclusion.value = testVals;
			thisForm.testName.value = "";
			thisForm.configurebutton.disabled = true;
			thisForm.unconfigexcludebutton.disabled = true;
			thisForm.reconfigurebutton.disabled = true;
			thisForm.configureexcludebutton.disabled = true;
			thisForm.includebutton.disabled = true;
			if (thisForm.updatebutton != null && thisForm.updatebutton.value != undefined)
			{
				thisForm.updatebutton.disabled = true;
			}
			thisForm.method = "post";
			thisForm.action = "EgIncludeComponents.jsp";
			thisForm.submit();
		}
	}
}

function configureUnconfiguredTest(componentType,componentName)
{
	var thisForm = document.topology;
	var unConfigTestList = thisForm.unconfigTests;
	var unconfigTestsLen = thisForm.unconfigTests.options.length;
	thisForm.showPopup.value = "false";
	var optionSelected = false;
	var testValue = "";
	var compsPicked = 0;

	if (unConfigTestList.selectedIndex == -1)
	{
		alert(_selectTest);
		return;
	}
	else
	{
		for (var i=0; i<unconfigTestsLen; i++)
		{
			if (unConfigTestList.options[i].selected == true)
			{
				optionSelected = true;
				compsPicked++;
				testValue = unConfigTestList.options[i].value;
			}
		}
	}
	if (compsPicked!=1)
	{
		optionSelected = false;
		alert(_testAlert);
		return;
	}
	if (optionSelected && componentType != "" && componentName != "")
	{
		thisForm.testName.value = testValue;
		thisForm.previousTestName.value = "";
		thisForm.configurebutton.disabled = true;
		thisForm.unconfigexcludebutton.disabled = true;
		thisForm.reconfigurebutton.disabled = true;
		thisForm.configureexcludebutton.disabled = true;
		thisForm.includebutton.disabled = true;
		thisForm.method = "post";
		thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testValue;
		thisForm.submit();
	}
}

function configureReconfiguredTest(componentType,componentName)
{
	var thisForm = document.topology;
	var configTestList = thisForm.configTests;
	var configTestLen = thisForm.configTests.options.length;
	thisForm.showPopup.value = "false";
	var optionSelected = false;
	var testValue = "";
	var compsPicked = 0;
	if (configTestList.selectedIndex == -1)
	{
		alert(_selectTest);
		return;
	}
	else
	{
		for (var i=0; i<configTestLen; i++)
		{
			if (configTestList.options[i].selected == true)
			{
				optionSelected = true;
				compsPicked++;
				testValue = configTestList.options[i].value;
			}
		}
	}
	if (compsPicked!=1)
	{
		optionSelected = false;
		alert(_testAlert);
		return;
	}
	if(optionSelected && componentType != "" && componentName != "")
	{
		thisForm.testName.value = testValue;
		thisForm.fromReConfigure.value = "true";
		thisForm.previousTestName.value = "";
		thisForm.configurebutton.disabled = true;
		thisForm.unconfigexcludebutton.disabled = true;
		thisForm.reconfigurebutton.disabled = true;
		thisForm.configureexcludebutton.disabled = true;
		thisForm.includebutton.disabled = true;
		thisForm.method = "post";
		thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testValue;
		thisForm.submit();
	}
}

function changeValue()
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}
	thisForm.method = "post";
	thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
	thisForm.submit();
}

function changeIsManagedValue()
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}
	thisForm.method = "post";
	thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName+"&isManagedByChanged=true";
	thisForm.submit();
}

function createCredentials(urlFieldName,urlFieldValue)
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var urls = document.getElementById(urlFieldName).value;
	var urlList = new Array();
	var duplicateValue = "false";

	if (urls.charAt(0) == "," || urls.charAt(urls.length -1) == "," || urls.indexOf(",,") > -1)
	{
		alert(_checkurl);
		thisForm.url.focus();
		urlValidated = "true";
		duplicateValue = "true";
		return;
	}

	if(urls.indexOf(",") > -1)
	{
		urlList = urls.split(",");
	}
	else
	{
		urlList[0] = urls;
	}
	var toMatch = /^(http|ftp|https)\:(\\\\|\/\/)([A-Za-z0-9]+(\.)*[A-Za-z0-9]*)+/;
	var urlValidated="false";
	for (var i=0;i<urlList.length;i++)
	{
		var eachUrl = urlList[i];
		var ColonIdx = eachUrl.indexOf(":");
		if (ColonIdx <= 0)
		{
			alert(_checkurl);
			thisForm.url.focus();
			urlValidated = "true";
			duplicateValue = "true";
			return;
		}
		eachUrl = eachUrl.substring(0,ColonIdx);
		var urlValue = urlList[i].substring(ColonIdx+1);
		if (urlValidated == "false")
		{
			var validUrl = "false";
			if (toMatch.test(urlValue))
			{
				validUrl = "true";
			}

			if (validUrl == "false")
			{
				duplicateValue = "true";
				urlValidated = "true"
				alert(_urlNameValue + " '" + eachUrl + "' " + _isInvalid);
				var datawin = window.open("Data.jsp?fieldName="+encodeURIComponent(urlFieldName),"DataWindow","width=625,height=300,left=0,top=132,scrollbars=0,scrollbars=no,resizable=no");
				datawin.focus();
			}
		}

		if (urlValidated == "false")
		{
			for (var j=i+1;j<urlList.length;j++)
			{
				var nextUrl =  urlList[j];
				nextUrl = nextUrl.substring(0,nextUrl.indexOf(":"));
				if (eachUrl.toUpperCase() == nextUrl.toUpperCase())
				{
					alert('<egui:intnl text="admin.test.Please enter different name"/>');
					duplicateValue = "true";
					if(urls!=null)
					{
						while(urls.indexOf("#") > -1)
						{
							urls = urls.replace("#","~egHash~");
						}
					}

					var datawin = window.open("Data.jsp?fieldName="+encodeURIComponent(urlFieldName),"DataWindow","width=625,height=300,left=0,top=132,scrollbars=0,scrollbars=no,resizable=no");
					datawin.focus();
				}
			}
		}
	}
	if (duplicateValue == "false")
	{
		if (urls != urlFieldValue)
		{
			var componentType = "";
			if (thisForm.componentType != null && thisForm.componentType != undefined)
			{
				componentType = thisForm.componentType.value;
			}
			var testName = "";
			if (thisForm.testName != null && thisForm.testName != undefined)
			{
				testName = thisForm.testName.value;
			}
			thisForm.moreurl.value = "true";
			thisForm.urls.value = urls;
			thisForm.method = "post";
			thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
			thisForm.submit();
		}
	}
}

function config_popup(theURL,winName,features)
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}
	theURL = theURL + "&fromPage_HelpPage=EgConfigureComponentTests.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName;

	plusButtonClicked = "true";
	if(!window.vmgWindow)
	{
		vmgWindow=open(theURL,winName,features);
	}
	else
	{
		if(!vmgWindow.closed)
		{
			vmgWindow.close();
			vmgWindow = open(theURL,winName,features);
			vmgWindow.focus();
		}
		else
		{
			vmgWindow=open(theURL,winName,features);
		}
	}
}

function changeExecutiontime(optionSelected)
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}

	var testPeriod = "86400";
	if (optionSelected == 'hourly') testPeriod = "3600";
	thisForm.testPeriod.value = testPeriod;
	thisForm.method = "post";
	thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
	thisForm.submit();
}
// RHEV
function changeRhevMgrValue(optionSelected)
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}

	if (optionSelected == 'Other')
	{
		openVCDetails(this.event,"EgRhevConfig.jsp?fromPage_HelpPage=EgConfigureComponentTests.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName);
		//openVCDetails(this.event,"EgRHEVDiscovery.jsp?fromPage_HelpPage=EgConfigureComponentTests.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName);
	}
	else
	{
		thisForm.Rhel_mgr_host.value = optionSelected;
		thisForm.method = "post";
		thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
		thisForm.submit();
	}
}

function changeVirtualCenterValue(optionSelected)
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}

	if (optionSelected == 'Other')
	{
		openVCDetails(this.event,"EgVcConfig.jsp?fromPage_HelpPage=EgConfigureComponentTests.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName);
	}
	else
	{
		thisForm.virtual_center.value = optionSelected;
		thisForm.method = "post";
		thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
		thisForm.submit();
	}
}

function changeHMCValue(optionSelected)
{
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}

	if (optionSelected == 'Other')
	{
		openVCDetails(this.event,"EgHMCConfig.jsp?fromPage_HelpPage=EgConfigureComponentTests.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName);
	}
	else
	{
		thisForm.management_server.value = optionSelected;
		thisForm.method = "post";
		thisForm.action = "EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
		thisForm.submit();
	}
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);
	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);
	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function showAgentSummary()
{
	document.getElementById('AgentSummaryHeading_2').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'table-row';
		document.getElementById('AgentSummary').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'block';
		document.getElementById('AgentSummary').style.display = 'block';
	}
}

function hideAgentSummary()
{
	document.getElementById('AgentSummaryHeading_1').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'table-row';
		document.getElementById('AgentSummary').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'block';
		document.getElementById('AgentSummary').style.display = 'block';
	}
	document.getElementById('AgentSummary').style.display = 'none';
}

var newDomainValue = "";
//for MultiUserSupportTest
var newAdminUserValue = "";
//for CtxAuthTest,TermAuthTest,WinAuthTest
var newUserValue = "";
function getUserValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "domain")
	{
		newDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		newAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		newUserValue = thisForm.user.value;
	}
}

var newNameValue = "";
var newPatternValue = "";
var newThresholdValue = "";
function getNamePatternValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "name")
	{
		newNameValue = thisForm.name.value;
	}
	else if (paramName.toLowerCase() == "pattern")
	{
		newPatternValue = thisForm.pattern.value;
	}
	else if (paramName.toLowerCase() == "threshold_value")
	{
		newThresholdValue = thisForm.threshold_value.value;
	}
}

var changedDomainValue = "";
var changedAdminUserValue = "";
var changedUserValue = "";
function getUserChangedValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "domain")
	{
		changedDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		changedAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		changedUserValue = thisForm.user.value;
	}
}

var changedNameValue = "";
var changedPatternValue = "";
var changedThresholdValue = "";
function getNamePatternChangedValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "name")
	{
		changedNameValue = thisForm.name.value;
	}
	else if (paramName.toLowerCase() == "pattern")
	{
		changedPatternValue = thisForm.pattern.value;
	}
	else if (paramName.toLowerCase() == "threshold_value")
	{
		changedThresholdValue = thisForm.threshold_value.value;
	}
}

function checkMultipleNamePattern(paramName,paramValue)
{
	var thisForm = document.topology;
	var multiName = "false";

	if (paramName.toLowerCase() == "name")
	{
		var nameValue = thisForm.name.value;
		if (nameValue.indexOf(",") > -1)
		{
			multiName = "true";
		}
	}
	else if (paramName.toLowerCase() == "pattern")
	{
		var patternValue = thisForm.pattern.value;
		if (patternValue.indexOf(",") > -1)
		{
			multiName = "true";
		}
	}
	else if (paramName.toLowerCase() == "threshold_value")
	{
		var thresholdValue = thisForm.threshold_value.value;
		if (thresholdValue.indexOf(",") > -1)
		{
			multiName = "true";
		}
	}

	if (multiName == "true")
	{
		var orginalPatternValue = "";
		var orginalNameValue = "";
		var orginalThresholdValue = "";
		if (plusButtonClicked == "true")
		{
			if (paramName.toLowerCase() == "pattern")
			{
				var patternValue = thisForm.pattern.value;
				if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
				{
					orginalPatternValue = newPatternValue;
				}
			}
			else if (paramName.toLowerCase() == "name")
			{
				var nameValue = thisForm.name.value;
				if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
				{
					orginalNameValue = newNameValue;
				}
			}
			else if (paramName.toLowerCase() == "threshold_value")
			{
				var thresholdValue = thisForm.threshold_value.value;
				if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
				{
					orginalThresholdValue = newThresholdValue;
				}
			}
		}
		else
		{
			if (paramName.toLowerCase() == "pattern")
			{
				var patternValue = thisForm.pattern.value;
				if (patternValue != paramValue && patternValue.indexOf(",") > -1)
				{
					orginalPatternValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "threshold_value")
			{
				var thresholdValue = thisForm.threshold_value.value;
				if (thresholdValue != paramValue && thresholdValue.indexOf(",") > -1)
				{
					orginalthresholdValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "name")
			{
				var nameValue = thisForm.name.value;
				if (nameValue != paramValue && nameValue.indexOf(",") > -1)
				{
					orginalNameValue = nameValue;
				}
			}
		}

		if (paramName.toLowerCase() == "name")
		{
			var nameValue = thisForm.name.value;
			if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "SlowTransTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
				}
				thisForm.name.value = changedNameValue.substring(0,changedNameValue.indexOf(","));
				tempField = thisForm.name;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			var patternValue = thisForm.pattern.value;
			if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "SlowTransTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
				}
				thisForm.pattern.value = changedPatternValue.substring(0,changedPatternValue.indexOf(","));
				tempField = thisForm.pattern;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			var thresholdValue = thisForm.threshold_value.value;
			if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "SlowTransTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
				}
				thisForm.threshold_value.value = changedThresholdValue.substring(0,changedThresholdValue.indexOf(","));
				tempField = thisForm.threshold_value;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
	}
}

function checkMultipleUser(paramName,paramValue)
{
	var thisForm = document.topology;
	var multiUser = "false";
	if (paramName.toLowerCase() == "domain")
	{
		var domainValue = thisForm.domain.value;
		if (domainValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "user")
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}

	if (multiUser == "true")
	{
		var orginalDomainValue = "";
		var orginalUserValue = "";
		if (plusButtonClicked == "true")
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = newDomainValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = newAdminUserValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != newUserValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = newUserValue;
				}
			}
		}
		else
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != paramValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != paramValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != paramValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
		}

		if (paramName.toLowerCase() == "domain")
		{
			var domainValue = thisForm.domain.value;
			if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "CtxAuthTest" || 
						thisForm.testname.value == "WinAuthTest" || 
						thisForm.testname.value == "TermAuthTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
					}
					else
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				}
				thisForm.domain.value = changedDomainValue.substring(0,changedDomainValue.indexOf(","));
				tempField = thisForm.domain;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			var adminUserValue = thisForm.admin_user.value;
			if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
				thisForm.admin_user.value = changedAdminUserValue.substring(0,changedAdminUserValue.indexOf(","));
				tempField = thisForm.admin_user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "user")
		{
			var userValue = thisForm.user.value;
			if (userValue != newUserValue && userValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				thisForm.user.value = changedUserValue.substring(0,changedUserValue.indexOf(","));
				tempField = thisForm.user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
	}
}

function checkHashTildeHash()
{
	var thisForm = document.topology;
	var multiUser = "false";

	if (thisForm.admin_user != null && thisForm.admin_user.value != undefined)
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var admin_passwordValue = thisForm.admin_password.value;

			if (!checkspecialnomess(admin_passwordValue,"|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe' />");
				tempField = thisForm.admin_password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < admin_passwordValue.length;k++)
			{
				if(admin_passwordValue.charAt(k) == '#' && 
					admin_passwordValue.charAt(k + 1) == '~' && 
					admin_passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.admin_password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
	else if (thisForm.user != null && thisForm.user.value != undefined)
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var passwordValue = thisForm.password.value;

			if (!checkspecialnomess(passwordValue,",|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe and comma' />");
				tempField = thisForm.password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < passwordValue.length;k++)
			{
				if (passwordValue.charAt(k) == '#' && 
					passwordValue.charAt(k + 1) == '~' && 
					passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
}

function InsideViewChange(value)
{
	var thisForm = document.topology;
	var domainValue = "";

	if (thisForm.domain != null && 
		thisForm.domain != undefined)
	{
		domainValue = thisForm.domain.value;
	}

	if (value == "tcp" || value == "wmi")
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "$unconfigured")
		{
			thisForm.domain.value = "none";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "$unconfigured")
		{
			thisForm.admin_user.value = "none";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "$unconfigured")
		{
			thisForm.admin_password.value = "none";
		}

		if (thisForm.admin_passwordconfirmpassword != null && 
			thisForm.admin_passwordconfirmpassword != undefined && 
			thisForm.admin_passwordconfirmpassword.value == "$unconfigured")
		{
			thisForm.admin_passwordconfirmpassword.value = "none";
		}
	}
	else
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "none")
		{
			thisForm.domain.value = "$unconfigured";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "none")
		{
			thisForm.admin_user.value = "$unconfigured";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "none")
		{
			thisForm.admin_password.value = "$unconfigured";
		}

		if (thisForm.admin_passwordconfirmpassword != null && 
			thisForm.admin_passwordconfirmpassword != undefined && 
			thisForm.admin_passwordconfirmpassword.value == "none")
		{
			thisForm.admin_passwordconfirmpassword.value = "$unconfigured";
		}
	}
}

function scrollWindow()
{
	window.scroll(0,500); // horizontal and vertical scroll targets
}

var unconfigwin;
function cleanup()
{
	if(unconfigwin != null && unconfigwin != undefined && !unconfigwin.closed)
	{
		unconfigwin.close();
	}
	if(windowRef != null && windowRef != undefined && !windowRef.closed)
	{
		windowRef.close();
	}
}
var windowRef;
function process_popup(dummy)
{
	var result_now=document.forms['topology'].process.value;
	var url = "/final/admin/setSessionAttribute.jsp";
	var params = "from=mainPage&attributeName=paramValue&attributeValue="+encodeURIComponent(result_now);
	var ajaxObj = new Ajax.Request(
		url,
		{
			method: 'POST',
			parameters: params,
			onComplete: callProcessConfigPage
		});
		
}

function callProcessConfigPage(ajaxRes)
{
	theURL="/final/admin/processConfiguration.jsp?compname=<%=EgURLEncoder.encode(componentName,"UTF-8")%>";
	if(document.getElementById('wide'))
	{
		theURL+='&s_wide='+document.topology.wide[0].checked+'&showonlyconcise=false';
	}
	else
	{
		theURL+='&s_wide=false&showonlyconcise=true';
	}
	winName="processWindow";
	var width = 900;
	var height = 450;
	var left = parseInt((screen.availWidth/2) - (width/2));
	var top = parseInt((screen.availHeight/2) - (height/2));
	features='scrollbars=yes,width=900,height=450,top='+top+',left='+left;
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	plusButtonClicked = "true";
	if(!window.vmgWindow)
	{
		vmgWindow=open(theURL,winName,features);
		windowRef = vmgWindow;
	}
	else
	{
		if(!vmgWindow.closed)
		{
			vmgWindow.close();
			vmgWindow = open(theURL,winName,features);
			vmgWindow.focus();
			windowRef = vmgWindow;
		}
		else
		{
			vmgWindow=open(theURL,winName,features);
			windowRef = vmgWindow;
		}
	}
}
function loadAdapters()
{
	document.getElementById("device_id").value = "Default";
	document.getElementById("device_name").length=0;
	var opt = document.createElement('option');
	opt.value = "-1";
	opt.text = "This may take sometime. Please wait...";
	document.getElementById("device_name").add(opt);
	var url = "/final/admin/setSessionAttribute.jsp";
	var params = "action=getnetworkAdapters&componentNick=<%=EgURLEncoder.encode(componentName,"UTF-8")%>";
	var ajaxObj = new Ajax.Request(
		url,
		{
			method: 'POST',
			parameters: params,
			onComplete: callAdapterConfigPage
		});
}
var localArray = new Array();
function callAdapterConfigPage(ajaxRes)
{
	document.getElementById("device_name").length=0;
	document.getElementById("device_id").value = "Default";
	if(ajaxRes.responseText != null && ajaxRes.responseText.length >0)
	{
		localArray = ajaxRes.responseText.split("~#~");
		for(var i=0;i<localArray.length;i++)
		{
			var arr1 = localArray[i].split("~,~");
			var opt = document.createElement('option');
			opt.value = arr1[0];
			opt.text = arr1[0];
			document.getElementById("device_name").options.add(opt);
			if(i==0)
			{
				document.getElementById("device_id").value = arr1[1];
			}
		}
	}
	else
	{
		var opt = document.createElement('option');
		opt.value = "Default";
		opt.text = "Default";
		document.getElementById("device_name").add(opt);
	}
}
function changeDeviceId(ind)
{
	var arr2 = localArray[ind].split("~,~");
	document.getElementById("device_id").value = arr2[1];
}
function setCurrentValue(currentWide,val)
{
	if(val.length>0)
	{
		document.topology.process.value = val;
		if(document.getElementById('wide'))
		{
			if(currentWide=="detailed")
			{
				document.topology.wide[0].checked=true;
			}
			if(currentWide=="concise")
			{
				document.topology.wide[1].checked=true;
			}
		}
	}
	if(windowRef != null)
		windowRef.close();
}

function setServices(val)
{
	if(val.length>0)
	{
		document.topology.serviceName.value = val;
	}
	if(windowRef != null)
		windowRef.close();
}

function windows_services_popup(dummy)
{
	var result_now=document.forms['topology'].serviceName.value;
	var url = "/final/admin/setSessionAttribute.jsp";
	var params = "attributeName=paramValue&attributeValue="+encodeURIComponent(result_now);
	var ajaxObj = new Ajax.Request(
		url,
		{
			method: 'POST',
			parameters: params,
			onComplete: callWindowsServicesConfigPage
		});
		
}
function callWindowsServicesConfigPage(ajaxRes)
{
	theURL="/final/admin/winServicesConfiguration.jsp?test=<%=testName%>&compname=<%=EgURLEncoder.encode(componentName,"UTF-8")%>"; 
	winName="winServicesWindow";
	var width = 900;
	var height = 450;
	var left = parseInt((screen.availWidth/2) - (width/2));
	var top = parseInt((screen.availHeight/2) - (height/2));
	features='scrollbars=yes,width=900,height=450,top='+top+',left='+left;
	var thisForm = document.topology;
	thisForm.showPopup.value = "false";
	plusButtonClicked = "true";
	if(!window.vmgWindow)
	{
		vmgWindow=open(theURL,winName,features);
		windowRef = vmgWindow;
	}
	else
	{
		if(!vmgWindow.closed)
		{
			vmgWindow.close();
			vmgWindow = open(theURL,winName,features);
			vmgWindow.focus();
			windowRef = vmgWindow;
		}
		else
		{
			vmgWindow=open(theURL,winName,features);
			windowRef = vmgWindow;
		}
	}
}

var customizedPopupDiv="customizedPopupDiv";
var dragStarted=false;
var startX=0;
var startY=0;
var windowWidth="";
var windowHeight="";
function startDrag(event,divId)
{
	if(divId!=null && divId!='undefined')
	{
		customizedPopupDiv=document.getElementById(divId);
		if(!isIE())
		{
			windowHeight = window.innerHeight;
			windowWidth = window.innerWidth;
		}
		else
		{
			windowWidth=document.body.clientWidth;
			windowHeight=document.body.clientHeight;
		}
		document.body.style.cursor="move";
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		if(customizedPopupDiv!=null)
		{
			startX=event.clientX-parseInt(customizedPopupDiv.style.left);
			startY=event.clientY-parseInt(customizedPopupDiv.style.top);
		}
		dragStarted=true;
	}
}
function drag(event)
{
	var iframe1=document.getElementById("iframe1");
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	if(dragStarted)
	{
		if(customizedPopupDiv!=null)
		{
			var clickXPos=event.clientX;
			var clickYPos=event.clientY;
			var rightMaxPos=windowWidth;
			var leftMaxPos=0;
			var customizedDivXStartPos=(clickXPos-startX);

			if((customizedDivXStartPos+580)<=rightMaxPos)
			{
				customizedPopupDiv.style.left=customizedDivXStartPos;
				if(iframe1!=null)
					iframe1.style.left=customizedDivXStartPos;
			}
		
			customizedPopupDiv.style.top=(clickYPos-startY);
			if(iframe1!=null)
				iframe1.style.top=(clickYPos-startY);
		}
	}
}

function endDrag(event)
{
	document.body.style.cursor="default";
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	startX=0;
	startY=0;
	dragStarted=false;
}

function Search()
{
	var thisForm = document.topology;
	var strSearch = document.getElementById('strSearch').value;
	var comType = thisForm.componentType.value;
	if (comType == -1)
	{
		alert('<egui:intnl text="admin.common.Please select the component type"/>');
		return false;
	}
	if (strSearch == null || strSearch == " " || strSearch == "Search")
	{
		window.location.href = "EgConfigureComponentTests.jsp?componentType="+comType;
	}
	else
	{
		window.location.href = "EgConfigureComponentTests.jsp?strSearch="+strSearch+"&componentType="+comType;
	}
}

documentView ={
		getObject: function()
		{
			if(typeof( window.innerWidth) == 'number')
			{//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth-10;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight ))
			{//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight)
			{ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			this.screenHeight=window.screen.availHeight;
			this.screenWidth=window.screen.availWidth;
			return this;
		},
		getScreenHeight: function()
		{
			return this.getObject().screenHeight;
		},
		getScreenWidth: function()
		{
			return this.getObject().screenWidth;
		},
		getHeight: function()
		{
			return this.getObject().height;
		},
		getWidth: function()
		{
			return this.getObject().width;
		},
		isIE: function()
		{
			return this.getObject().ie;
		},
		isFireFox: function()
		{
			return this.getObject().fireFox;
		}
	};
var old_width=0;
function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}
	var selectWidth1Obj = document.getElementById('selectWidth1');
	var selectWidth2Obj = document.getElementById('selectWidth2');
	var selectWidth3Obj = document.getElementById('selectWidth3');
	if(selectWidth1Obj!=null && selectWidth1Obj!=undefined)
	{
		var selectWidth = selectWidth1Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth1Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(selectWidth2Obj!=null && selectWidth2Obj!=undefined)
	{
		var selectWidth = selectWidth2Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth2Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(selectWidth3Obj!=null && selectWidth3Obj!=undefined)
	{
		var selectWidth = selectWidth3Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth3Obj.style.width=(newSelectWidth)+"px";
		}
	}
	old_width=documentView.getWidth();
}
window.onresize = bigScreenPage;

function checkURLAndCredentials(paramValue)
{
	var thisForm = document.topology;
	var v_url='';
	if(thisForm.url!=null && thisForm.url!=undefined)
	{
		v_url = thisForm.url.value;
	}
	else if(thisForm.WSDL_URL!=null && thisForm.WSDL_URL!=undefined)
	{
		v_url = thisForm.WSDL_URL.value;
	}
	//var v_url = thisForm.url.value;
	var v_cred = thisForm.credentials.value;
	var arrURL = v_url.split(",");
	var arrCred = v_cred.split(",");
	if (arrURL.length != arrCred.length && plusButtonClicked == "false")
	{
		alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the URL text box or the \'Click here\' link above the test parameters to configure URL and credentials'/>.");
		
		if(thisForm.url!=null && thisForm.url!=undefined)
		{
			thisForm.url.value = paramValue;
			tempField = thisForm.url;
		}
		else if(thisForm.WSDL_URL!=null && thisForm.WSDL_URL!=undefined)
		{
			thisForm.WSDL_URL.value = paramValue;
			tempField = thisForm.WSDL_URL;
		}
		//tempField = thisForm.url;
		
		setTimeout("tempField.focus()",0);
		return false;
	}
}
function openWebServiceDiv(componentName)
{
	var wsdlurl =  document.getElementById('WSDL_URL').value;
	if(wsdlurl!=null && wsdlurl.indexOf("$") < 0 ){
		ShowWebServiceDiv(wsdlurl,componentName);
	}
	else{
		alert("InValid :"+wsdlurl);
	}
}
function hideWebServiceDiv(divId)
{
	$j("#"+divId).hide("slow");
}
function ShowWebServiceDiv(wsdlurl,componentName)
{
	var operation = document.getElementById('Operations').value;
	var credentials = document.getElementById('credentials').value;
	
	//url1:user1:pwd1
	var credentialWithPattern='';
	var pattern='';
	var partsOfUrl = wsdlurl.split(',');
	var partsOfCreden = credentials.split(',');
	for(var i=0;i<partsOfUrl.length;i++)
	{
		var urlPart = partsOfUrl[i];
		var credenPart = partsOfCreden[i];
		var pattern = urlPart.substring(0,urlPart.indexOf(":"));
		var values = pattern+":"+credenPart;
		credentialWithPattern=credentialWithPattern+","+values;
	}
	if(credentialWithPattern.startsWith(","))
	{
		credentialWithPattern = credentialWithPattern.substring(credentialWithPattern.indexOf(",")+1);
	}

	var href = 'EgWebServiceConfig.jsp?wsdl='+encodeURI(wsdlurl)+"&componentName="+encodeURI(componentName) +"&operation="+encodeURI(operation)+"&reqFrom=testConfig"+"&credentialWithPattern="+encodeURI(credentialWithPattern);
	var maxInd = maxIndex();
	$j("#WebServiceDiv").css({"display":"block" , "position":"absolute" });
	$j("#WebServiceDiv").css({"z-index":maxInd+1});
	$j("#WebServiceDiv").show('slow');
	var divId = document.getElementById("innerWebServiceDiv");
	divId.innerHTML = "<table width='100%' border='0' bgcolor='white' height='300px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top></td></tr></table>";
	$j('#innerWebServiceDiv').load(href);
	
}

function maxIndex()
{
	var index_highest = 0;
	$j('div').each(function(){
		var index_current = parseInt($j(this).css("z-index"), 10);
		if(index_current > index_highest) {
			index_highest = index_current;
		}
	});
	return index_highest.toString();
}
function urlVal()
{
	var thisForm = document.topology;
	var configTestsLen = thisForm.configTests.options.length;
	if('<%=queryString%>'.indexOf("enableConfTestSize") > -1)
	{
		var EnableConfTest = '<%=queryString%>'.substring('<%=queryString%>'.indexOf("enableConfTestSize"));
		var valEnableConfTest = EnableConfTest.substring(EnableConfTest.indexOf("=")+1,EnableConfTest.length);
		if((configTestsLen == 0) && ('<%=testType%>' == "PerformanceTest") && (valEnableConfTest != "null"))
		{
			if(valEnableConfTest != 0)
			{
				var compoType = '<%=queryString%>'.substring('<%=queryString%>'.indexOf("=")+1);
				var comType =compoType.substring(0,compoType.indexOf("&componentName"));

				var compoName = compoType.substring(compoType.indexOf("=")+1);
				var comName = compoName.substring(0,compoName.indexOf("&testType"));
				var dispLocalCName = '<%=queryString%>'.substring('<%=queryString%>'.indexOf("dispCName"));
				var dispCName = dispLocalCName.substring(dispLocalCName.indexOf("=")+1,dispLocalCName.indexOf("&"));
				
				if (dispCName.indexOf(":NULL") > -1)
				{
					dispCName = dispCName.substring(0,dispCName.indexOf(":NULL"));
				}

				var flag = confirm('<egui:intnl text="admin.test.Would you like to exclude configuration tests for the component"/>, \''+ dispCName + "\' ?");
				if(flag)
				{
					window.location.href = "EgConfigureComponentTests.jsp?componentType="+comType+"&componentName="+comName+"&testType=ConfigurationTest";
				}
			}
		}
	}
}

function onloadFunc()
{
	scrollWindow();
	bigScreenPage();
	urlVal();
}
</script>
</head>
<body style="overflow:auto" id="space6" scroll="auto" onload="javascript:onloadFunc();" onunload="cleanup()" onmousemove="javascript:drag(event);" onmouseup="javascript:endDrag(event);">
<%
	if(remoteControlEnabled)
	{
		String displayNick = componentName;
		if(componentName.indexOf(":")>0)
		{
			displayNick = displayNick.substring(0,displayNick.indexOf(":"));
		}
		Hashtable ht = egDisc.getNickIpMap();
		String agentIP = "";
		if(ht != null && ht.size()>0)
		{
			agentIP = (String)ht.get(displayNick);
		}
	}
%>
<div id="customizedPopupDiv" name="customizedPopupDiv" style="z-index:1000;display:none;left:50px;top:10px;width:580px;height:200px;border:0px solid #ff0000; position:absolute;">
	<table border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg" class="eg_whitebg" onmousedown="javascript:startDrag(event,'customizedPopupDiv');" onmouseover='document.body.style.cursor="move"' onmouseout='document.body.style.cursor="default"'><img src="/final/admin/eg_images/spacer.gif" width="11" height="2"></td>
			<td class="eg_whitebg" onmousedown="javascript:startDrag(event,'customizedPopupDiv');" onmouseover='document.body.style.cursor="move"' onmouseout='document.body.style.cursor="default"'>
				<table cellspacing="1" cellpadding="0" border="0" width="100%">
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0" border="0" width="100%">
								<tr>
									<td width="100%" align="center" class="eg_subcontentbg" id="form_spacing" style="border-right-width:0px"><div id="AppValidationTitle"></div></td>
									<td style="width:20px" class="eg_subcontentbg" id="form_spacing" style="border-left-width:0px">
										<img src="/final/admin/eg_images/winclose.gif" onclick="hideDivs('customizedPopupDiv');" border="1" class="mouse" title="close">
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
			<td class="pop2_right_bg" class="eg_whitebg" onmousedown="javascript:startDrag(event,'customizedPopupDiv');" onmouseover='document.body.style.cursor="move"' onmouseout='document.body.style.cursor="default"'><img src="/final/admin/eg_images/spacer.gif" width="11" height="2"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11"></td>
			<td class="eg_whitebg">
				<div id='customizedLinkInnerDiv' name='customizedLinkInnerDiv' class="div_scroll" style="z-index:1000;height:190px;border:0px solid #ff00ff;"></div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>
<%
	String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";
%>

<!-- WebServiceDiv -->
<div id="WebServiceDiv" name="WebServiceDiv" class="ui-widget-content" style="display:none;left:120px;top:250px;width:710px;height:420px;border:0px solid red; position:absolute;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="WebServiceTitle" class="popup_topbg eg_75bold whitefont"  height="27px"> <egui:intnl text='monitor.layermodel.Web Service Operation Configuration'/> </td>
					<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideWebServiceDiv('WebServiceDiv');"> </td>
					<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="white_bg">
							<div class="div_scroll" id="innerWebServiceDiv" name="innerWebServiceDiv" style="left:0px;top:0px;width:670px;height:300px;border:0px solid green;"> </div>
						</td>
					</tr>
				</table>
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>

<!----Webservice response div------->
<div id="WebServiceResponseDiv" name="WebServiceResponseDiv" class="ui-widget-content" style="display:none;left:150px;top:380px;width:560px;height:280px;border:0px solid #ffff00; position:absolute;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="WebServiceRespomse" class="popup_topbg eg_75bold whitefont"  height="27px"> <egui:intnl text='monitor.layermodel.Web Service Response'/> </td>
					<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideWebServiceDiv('WebServiceResponseDiv');"> </td>
					<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="white_bg">
							<div class="div_scroll" id="innerWebServiceResponseDiv" name="innerWebServiceResponseDiv" style="left:0px;top:0px;width:550px;height:240px;border:0px solid #ff0000;"> </div>
							<!-- <iframe frameborder="0" src="" width="540px" height="240px"  id="innerWebServiceResponseDiv" name="innerWebServiceResponseDiv" align="center">  -->
							</iframe>
						</td>
					</tr>
				</table>
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>

<form name="topology" method="post" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="<%=tmpUrl%>"/>

<%
	if (componentType!=null && !componentType.equals("") && !componentType.equals("-1"))
	{
%>
	<tr>
		<td>
			<table border="0" width="90%" align="center">
				<tr>
					<td nowrap height="24" align="right">
<%
		if (componentName!=null && !componentName.equals("") && !componentName.equals("-1"))
		{
%>
						<a href="EgEnableAndDisableTests.jsp?componentType=<%=componentType%>&testType=<%=testType%>&showBackButton=true&componentName=<%=componentName%>" class="eg_monlink">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>
<%
		}
		else
		{
%>
						<a href="EgEnableAndDisableTests.jsp?componentType=<%=componentType%>&testType=<%=testType%>&showBackButton=true" class="eg_monlink">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>
<%
		}

		if (isConfigSupported)
		{
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
%>
						<egui:intnl text="admin.test.to enable and disable performance tests for"/>&nbsp;<%=_mapping.getComponentTypeDescription(componentType)%>
<%
			}
			else
			{
%>
						<egui:intnl text="admin.test.to enable and disable configuration tests for"/>&nbsp;<%=_mapping.getComponentTypeDescription(componentType)%>
<%
			}
		}
		else
		{
%>
						<egui:intnl text="admin.test.to enable and disable tests for"/>&nbsp;<%=_mapping.getComponentTypeDescription(componentType)%>
<%
		}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else
	{
%>
	<tr>
		<td>
			<table border="0" width="90%" align="center">
				<tr>
					<td nowrap height="24" align="right">
<%
		if (isConfigSupported)
		{
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
%>
						<a href="EgEnableAndDisableTests.jsp?testType=PerformanceTest&showBackButton=true" class="eg_monlink">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0">
						</a>
						<egui:intnl text="admin.test.to enable and disable performance tests"/>
<%
			}
			else
			{
%>
						<a href="EgEnableAndDisableTests.jsp?testType=ConfigurationTest&showBackButton=true" class="eg_monlink">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0">
						</a>
						<egui:intnl text="admin.test.to enable and disable configuration tests"/>
<%
			}
		}
		else
		{
%>
						<a href="EgEnableAndDisableTests.jsp?showBackButton=true" class="eg_monlink">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0">
						</a>
						<egui:intnl text="admin.test.to enable and disable tests"/>
<%
		}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="18%" align="right"><egui:intnl text="admin.server.Component type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="32%"><select name="componentType" id="componentType" style="width:230px" onchange="javascript:showComponents()">
<%
	if (listComponentTypes.size() > 0)
	{
%>
		<option value="-1"><egui:intnl text="admin.common.Choose a component type"/></option>
<%
	}
	else
	{
%>
		<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}

	//EgName class is used to hold name and its localised name.
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		if (actualname.equals(componentType))
		{
			selectedCompType = localname;
%>
			<option value="<%=actualname%>" selected><%=localname%></option>
<%
		}
		else
		{
%>
			<option value="<%=actualname%>"><%=localname%></option>
<%
		}
	}
%>
								</select>
								</td>
<%
	if (componentType!=null && !componentType.equals("-1") && egSpecs.getTestsForServer(componentType) == null)
	{
		isAtleastOneTestEnabled = false;
	}
%>
								<td width="20%" align="right"><egui:intnl text="admin.server.Component Search"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" width="30%">
									<div id="txtSearch" name="txtSearch" class="searchImg" style="float:left">
										<div class="rightside" style="display:inline;border:0px solid blue;" onkeypress="if(event.keyCode==13) javascript:Search();">
											<input class="textBoxImg" type="text" onfocus="if(this.value=='Search') this.value='';" onblur="if(this.value=='') this.value='Search';" value='<%=(strSearch==null || strSearch.equalsIgnoreCase(""))?"Search":strSearch%>' id="strSearch"/>
										</div>
										<div class="searchIcon" style="display:inline;border:0px solid red;float:left">
											<a id="eg_strInput" href="javascript:void(0)" name="Go" onclick="javascript:Search()"><img src="/final/images/gray/search-icon.png" style="text-decoration:none" border="0" class="png"/></a>
										</div>
									</div>
								</td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td>&nbsp;</td>
				</tr>

				<tr>
					<td width="7" align="left" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="18%" align="right"><egui:intnl text="admin.server.Component name"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="32%"><select name="componentName" id="componentName" style="width:230px" onchange="javascript:showTestList('componentName')">
<%
	if (listOfComponents.size() > 0)
	{
		if (strSearch ==null || strSearch.equalsIgnoreCase("") ||strSearch.equalsIgnoreCase("Search") )
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose a component"/></option>
<%
		}
	}
	else
	{
%>
		<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}

	//get the list of components for the particular component type
	if (componentType != null && componentType.length() > 0)
	{
		String tempComponentName = "";
		int checkSearchItem = -1;
		int checkComponentSearchItem = 0;
		String component = request.getParameter("componentName");
		for (int i=0; i<listOfComponents.size(); i++)
		{
			String eachComp = (String)listOfComponents.get(i);
			String port = eachComp.substring(eachComp.lastIndexOf(":")+1,eachComp.length());
			String compValue = eachComp.substring(eachComp.indexOf(":") + 1);

			if (isOracleDatabaseCompType)
			{
				tempComponentName = eachComp.substring(eachComp.indexOf(":")+1,eachComp.length());
			}
			else
			{
				if (port.equalsIgnoreCase("NULL"))
				{
					tempComponentName = eachComp.substring(eachComp.indexOf(":") + 1, eachComp.lastIndexOf(":"));
				}
				else
				{
					tempComponentName = eachComp.substring(eachComp.indexOf(":") + 1);
				}
			}
			if (searchList != null && searchList.size() > 0)
			{
				if (isItemExists(searchList,compValue))
				{
					if (checkSearchItem == -1)
					{
%>
						<option value="-1"><egui:intnl text="admin.common.Choose a component"/></option>
<%
					}
					checkSearchItem = 1;
					checkComponentSearchItem = 1;
					if (compValue.equals(component))
					{
%>
						<option value="<%=compValue%>" selected><%=tempComponentName%></option>
<%
					}
					else
					{
%>
						<option value="<%=compValue%>"><%=tempComponentName%></option>
<%
					}
				}
			}
			else
			{
				if (compValue.equals(component))
				{
%>
					<option value="<%=compValue%>" selected><%=tempComponentName%></option>
<%
				}
				else
				{
%>
					<option value="<%=compValue%>"><%=tempComponentName%></option>
<%
				}
			}
		}

		if (searchList != null && searchList.size() > 0 && checkComponentSearchItem == 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
	}
%>
								</select></td>
<%
	if (isConfigSupported)
	{
%>

								<td width="20%" align="right"><egui:intnl text="admin.server.Test type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="30%"><select name="testType" style="width:230px" onchange="javascript:showTestList('testType')">
									<option value="PerformanceTest" <%=pfSelected%>><egui:intnl text="admin.server.Performance" /></option>
									<option value="ConfigurationTest" <%=cfSelected%>><egui:intnl text="admin.server.Configuration" /></option>
								</select></td>
<%
	}
	else
	{
%>
								<td colspan="2">&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>

<%
	boolean isUnconfiguredTestPopupEnabled = false;
	String strPopup = null;
	if (servicesIniFile != null)
	{
		strPopup = servicesIniFile.getValue("MISC_ARGS","ShowUnconfiguredTestsInPopup");
	}

	if (strPopup != null && strPopup.equalsIgnoreCase("true"))
	{
		isUnconfiguredTestPopupEnabled = true;
	}

	if (isUnconfiguredTestPopupEnabled)
	{
		EgTestSpecification egTestSpecification = null;
		List listUnconfiguredComponents = ri.getAllServers();
		boolean hasManagedComponents = listUnconfiguredComponents!=null && listUnconfiguredComponents.size() > 0 ? true:false;
		boolean hasUnConfiguredTests = false;
		int unConfiguredTestsCount = 0;
		if (hasManagedComponents)
		{
			egTestSpecification = new EgTestSpecification(listUnconfiguredComponents);
			if (_user != null && EgInstallInfo.isConfigSupported)
			{
				egTestSpecification.setConfigSupported(isConfigSupported);
			}
			TreeMap tmapUnConfigTests = egTestSpecification.getUnconfiguredTest();
			unConfiguredTestsCount = egTestSpecification.getTotalUnconfiguredTestsCount();
			hasUnConfiguredTests = (unConfiguredTestsCount > 0)?true:false;
		}

		if (hasUnConfiguredTests)
		{
			String showPopup = request.getParameter("showPopup");
			if (showPopup == null)
			{
				showPopup = "true";
			}
%>
<!--for showing unconfigured test popup - starts-->
<script language="javascript">
	var showPopup = '<%=showPopup%>';
	if (showPopup == "true")
	{
		var thisForm = document.topology;
		var componentType = thisForm.componentType.options[thisForm.componentType.selectedIndex].value;
		var testTypeSelected = "PerformanceTest";
		if ('<%=fromUnconfigTest%>' != "UnconfigTests" && 
			'<%=fromUnconfigTest%>' != "testView")
		{
			if ('<%=cfSelected%>' == "selected")
			{
				testTypeSelected = "ConfigurationTest";
			}

			if (testTypeSelected == "PerformanceTest")
			{
				//unconfigwin = parent.openWindow("EgUnconfiguredTestsSummary.jsp?fromPage=testConfiguration&componentType=<%=componentType%>&componentName=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&showTestType=perTest&showBackButton=false","","width=1012,height=333,left=0,top=100,scrollbars=1,scrollbars=yes,resizable");
				unconfigwin = window.open("EgUnconfiguredTestsSummary.jsp?fromPage=testConfiguration&componentType=<%=componentType%>&componentName=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&showTestType=perTest&showBackButton=false","","width=1012,height=333,left=0,top=100,scrollbars=1,scrollbars=yes,resizable");
			}
			else
			{
				//unconfigwin = parent.openWindow("EgUnconfiguredTestsSummary.jsp?fromPage=testConfiguration&componentType=<%=componentType%>&componentName=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&showTestType=conTest&showBackButton=false","","width=1012,height=333,left=0,top=100,scrollbars=1,scrollbars=yes,resizable");
				unconfigwin = window.open("EgUnconfiguredTestsSummary.jsp?fromPage=testConfiguration&componentType=<%=componentType%>&componentName=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&showTestType=conTest&showBackButton=false","","width=1012,height=333,left=0,top=100,scrollbars=1,scrollbars=yes,resizable");
			}
		}
	}
</script>
<!--for showing unconfigured test popup - ends-->
<%
		}
	}

	if (!ht_AgentsList.isEmpty())
	{
		String agentType = "";
		String mainAgent = "";
		String externalAgents = (String)ht_AgentsList.get("EXTERNAL AGENT");
		if (externalAgents.length() > 110)
		{
			StringTokenizer st = new StringTokenizer(externalAgents,",");
			String str = "";
			int count = 0;
			while (st.hasMoreTokens())
			{
				count++;
				String temp = st.nextToken();
				temp = temp + ",";
				if (count%7 == 0)
				{
					temp = temp + "\n";
				}
				str = str + temp;
			}
			externalAgents = str.substring(0,str.length()-2);
		}
		if (ht_AgentsList.containsKey("INTERNAL AGENT"))
		{
			agentType = "INTERNAL AGENT";
			mainAgent = (String)ht_AgentsList.get(agentType);
		}
		else if (ht_AgentsList.containsKey("REMOTE AGENT"))
		{
			agentType = "REMOTE AGENT";
			mainAgent = (String)ht_AgentsList.get(agentType);
		}
%>
	<tr>
		<td><img src="/final/admin/eg_images/spacer.gif" height="10"></td>
	</tr>
	<tr>
		<td width="100%" id="eg_whitebg" align="center">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummaryHeading_1">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3" width="100%">
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td width="100%"><b><egui:intnl text="admin.test.AGENT SUMMARY"/></b></td>
								<td style="width:30px" align="center"><img id="img0" class="mouse" src="/final/admin/eg_images/arrowup.gif" border="0" onClick="javascript:hideAgentSummary();"></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummaryHeading_2" style="display:none">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3" width="100%">
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td width="100%"><b><egui:intnl text="admin.test.AGENT SUMMARY"/></b></td>
								<td style="width:30px" align="center"><img id="img0" class="mouse" src="/final/admin/eg_images/arrowdn.gif" border="0" onClick="javascript:showAgentSummary();"></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummary">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td colspan="3" align="center" width="100%" >
<%
		if (agentType.equals("INTERNAL AGENT") || agentType.equals("REMOTE AGENT"))
		{
%>
						<div class="div_scroll" style="width:100%;height:52px; border:0px solid #ff0000;">
<%
		}
		else
		{
%>
						<div class="div_scroll" style="width:100%;height:35px; border:0px solid #ff0000;">

<%
		}
%>
						<table align="center" border="0" width="100%"  cellpadding="2" cellspacing="0" class="tableborder_ad">
<%
		if (agentType.equals("INTERNAL AGENT") || agentType.equals("REMOTE AGENT"))
		{
%>
							<tr>
								<td width="20%" class="tdborder_ad" valign="top">
<%
			if (agentType.equals("INTERNAL AGENT"))
			{
%>
				<egui:intnl text="admin.test.INTERNAL AGENT" />
<%
			}
			else
			{
%>
				<egui:intnl text="admin.test.REMOTE AGENT" />
<%
			}
			remoteAgent = mainAgent;
%>
								</td>
								<td width="80%" class="tdborder_ad" valign="top"><%=mainAgent%></td>
							</tr>
<%
		}
%>
							<tr>
								<td width="30%" class="tdborder_ad" valign="top"><egui:intnl text="admin.test.EXTERNAL AGENT(S)" /></td>
								<td width="70%" class="tdborder_ad" valign="top"><%=externalAgents%></td>
							</tr>
						</table>
						</div>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}

	if (isAtleastOneTestEnabled)
	{
		//This condition will be fired only when the component is managed in an agentless manner
		if (componentType != null && !componentType.equals("") && componentName != null && !componentName.equals("-1") && !componentName.equals(""))
		{
			if (unconfiguredTestList != null && unconfiguredTestList.isEmpty() && 
				defaultconfiguredTestList != null && defaultconfiguredTestList.isEmpty() && 
				userconfiguredTestList != null && userconfiguredTestList.isEmpty() && 
				excludedTestList != null && excludedTestList.isEmpty())
			{
%>
	<tr>
		<td><img src="/final/admin/eg_images/spacer.gif" height="10"></td>
	</tr>
<%
				if (isConfigSupported)
				{
					if (ht_AgentsList != null && ht_AgentsList.containsKey("REMOTE AGENT"))
					{
						if (testType.equalsIgnoreCase("PerformanceTest"))
						{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><%=removeNull(componentName)%></b>&nbsp;<b><egui:intnl text="admin.test.is managed in an agentless manner"/></b>.&nbsp;<b><egui:intnl text="admin.test.No agentless performance tests are currently available for this component"/></b>.</td>
	</tr>
<%
						}
						else
						{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><%=removeNull(componentName)%></b>&nbsp;<b><egui:intnl text="admin.test.is managed in an agentless manner"/></b>.&nbsp;<b><egui:intnl text="admin.test.No agentless configuration tests are currently available for this component"/></b>.</td>
	</tr>
<%
						}
					}
					else
					{
						if (testType.equalsIgnoreCase("PerformanceTest"))
						{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><egui:intnl text="admin.test.Performance test(s) is/are currently not available for configuration for"/>&nbsp;<%=removeNull(componentName)%></b>.&nbsp;<br><b><egui:intnl text="admin.test.Please wait for the system configurations to be updated and try again after a few minutes"/></b>.</td>
	</tr>
<%
						}
						else
						{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><egui:intnl text="admin.test.Configuration test(s) is/are currently not available for configuration for"/>&nbsp;<%=removeNull(componentName)%></b>.&nbsp;<br><b><egui:intnl text="admin.test.Please wait for the system configurations to be updated and try again after a few minutes"/></b>.</td>
	</tr>
<%
						}
					}
				}
				else
				{
					if (ht_AgentsList != null && ht_AgentsList.containsKey("REMOTE AGENT"))
					{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><%=removeNull(componentName)%></b>&nbsp;<b><egui:intnl text="admin.test.is managed in an agentless manner"/></b>.&nbsp;<b><egui:intnl text="admin.test.No agentless tests are currently available for this component"/></b>.</td>
	</tr>
<%
					}
					else
					{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><egui:intnl text="admin.test.Test(s) is/are currently not available for configuration for"/>&nbsp;<%=removeNull(componentName)%></b>.&nbsp;<br><b><egui:intnl text="admin.test.Please wait for the system configurations to be updated and try again after a few minutes"/></b>.</td>
	</tr>
<%
					}
				}
			}
		}
	}
	else
	{
		if (selectedCompType != null  && !selectedCompType.equals(""))
		{
%>
	<tr>
		<td><img src="/final/admin/eg_images/spacer.gif" height="10"></td>
	</tr>
<%
			if (isConfigSupported)
			{
				if(testType.equalsIgnoreCase("PerformanceTest"))
				{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><egui:intnl text="admin.test.No performance test(s) are enabled for"/></b>&nbsp;<b><egui:intnl type="<%=selectedCompType%>"/></b>.&nbsp;<b><egui:intnl text="admin.test.Please enable atleast one performance test for configuration"/></b>.</td>
	</tr>
<%
				}
				else
				{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><egui:intnl text="admin.test.No configuration test(s) are enabled for"/></b>&nbsp;<b><egui:intnl type="<%=selectedCompType%>"/></b>.&nbsp;<b><egui:intnl text="admin.test.Please enable atleast one configuration test for configuration"/></b>.</td>
	</tr>
<%
				}
			}
			else
			{
%>
	<tr>
		<td align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><b><egui:intnl text="admin.test.No test(s) are enabled for"/></b>&nbsp;<b><egui:intnl type="<%=selectedCompType%>"/></b>.&nbsp;<b><egui:intnl text="admin.test.Please enable atleast one test for configuration"/></b>.</td>
	</tr>
<%
			}
		}
	}
%>

	<tr>
		<td><img src="/final/admin/eg_images/spacer.gif" height="10"></td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6" ></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" width="7">&nbsp;</td>
					<td nowrap valign="top" width="100%" align="center">
						<table cellspacing="0" cellpadding="0" border="0"><col width="33%"><col width="33%"><col width="33%">
							<tr>
								<td nowrap valign="top" id="space1">
									<table align="right" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td align="center" id="eg_subheadbg" nowrap="nowrap" class="head_padding4" style="border-left-width:1px;border-right-width:1px"><b><egui:intnl text="admin.test.UNCONFIGURED TESTS"/></b></td>
										</tr>
										<tr>
											<td id="eg_subcontentbg"  valign="top" nowrap class="cell_border1">
												<select name="unconfigTests" id="unconfigTests" size="13" style="width:275px;margin:0px;" multiple>
<%
	for (int i=0; i<unconfiguredTestList.size(); i++)
	{
		EgName nameObj = (EgName)unconfiguredTestList.get(i);
		String strTestName = nameObj.getActualName();
		String strTestDisplayValue = nameObj.getLocalName();
		if (testName != null && strTestName.equals(testName))
		{
%>
			<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%
		}
		else
		{
%>
			<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
		}
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>
												<table align="center" width="100%" cellspacing="2" cellpadding="2" border="0">
													<tr>
														<td align="right" width="50%"><input type="button" name="configurebutton" value='<egui:intnl text="admin.test.Configure"/>' class="eg_back" style="width: 85px;" onclick="javascript:configureUnconfiguredTest('<%=componentType%>','<%=componentName%>');"></td>
														<td align="left" width="50%"><input type="button" name="unconfigexcludebutton" value='<egui:intnl text="admin.test.Exclude"/>' class="eg_back" style="width: 85px;" onclick="javascript:unconfigTestToExclude();"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
								<td nowrap valign="top" id="space1">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align="center" class="head_padding4" style="border-left-width:1px;border-right-width:1px" ><b><egui:intnl text="admin.test.CONFIGURED TESTS"/></b></td>
										</tr>
										<tr>
											<td id="eg_subcontentbg" valign="top" nowrap class="cell_border1">
												<select name="configTests" size="13" style="width:275px;margin:0px;" multiple>
<%
	for (int i=0; i<userconfiguredTestList.size(); i++)
	{
		EgName nameObj = (EgName)userconfiguredTestList.get(i);
		String strTestName = nameObj.getActualName();
		String strTestDisplayValue = nameObj.getLocalName();
		if (i==0)
		{
%>
			<optgroup label="Tests with specific configuration">
<%
		}
		if (testName != null && strTestName.equals(testName))
		{
%>
			<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%
		}
		else
		{
%>
			<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
		}
	}

	for (int i=0; i<defaultconfiguredTestList.size(); i++)
	{
		EgName nameObj = (EgName)defaultconfiguredTestList.get(i);
		String strTestName = nameObj.getActualName();
		String strTestDisplayValue = nameObj.getLocalName();
		if (i==0)
		{
%>
			<optgroup label="Tests with default configuration">
<%
		}
		if (testName != null && strTestName.equals(testName))
		{
%>
			<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%
		}
		else
		{
%>
			<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
		}
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>
												<table align="center" width="100%" cellspacing="2" cellpadding="2" border="0">
													<tr>
														<td align="right" width="50%"><input type="button" name="reconfigurebutton" value='<egui:intnl text="admin.test.Reconfigure"/>' class="eg_back" style="width: 85px;" onclick="javascript:configureReconfiguredTest('<%=componentType%>','<%=componentName%>');"></td>
														<td align="left" width="50%"><input type="button" name="configureexcludebutton" value='<egui:intnl text="admin.test.Exclude"/>' class="eg_back" style="width: 85px;" onclick="javascript:configTestToExclude('<%=enableConfTestSize%>');"></td>
														<input type="hidden" name="fromReConfigure" value="">
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
								<td nowrap valign="top" id="space1">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align="center" class="head_padding4" style="border-left-width:1px;border-right-width:1px"><b><egui:intnl text="admin.test.EXCLUDED TESTS"/></b></td>
										</tr>
										<tr>
											<td id="eg_subcontentbg" valign="top" nowrap class="cell_border1">
												<select name="excludeTests" size="13" style="width:275px;margin:0px;" multiple>
<%
	for (int i=0;i<excludedTestList.size();i++)
	{
		EgName nameObj = (EgName)excludedTestList.get(i);
		String strTestName = nameObj.getActualName();
		String strTestDisplayValue = nameObj.getLocalName();
%>
		<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>
												<table align="center" width="100%" cellspacing="2" cellpadding="2" border="0">
													<tr>
														<td id="eg_subcontentbg" align="center"><input type="button" name="includebutton" value='<egui:intnl text="admin.test.Include"/>' class="eg_back" style="width: 85px;" onclick="javascript:includeToUnconfigTest();"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
					<td id="eg_subcontentbg" width="7">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" width="100%" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	String componentCredentialsNeededToDoValidation="";
	if (componentType != null && !componentType.equals("") && 
		componentName != null && !componentName.equals("-1") && !componentName.equals("") && 
		testName != null && !testName.equals(""))
	{
		for (int i=0;i<aResultant.size();i++)
		{
			aListResultantInLowerCase.add(aResultant.get(i).toString().toLowerCase());
		}
%>
	<tr>
		<td>&nbsp;</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
<%
		String enabled = "";
		String disabled = "";
%>
				<tr>
					<td nowrap height="24" align="left"><div style="float:left"><b><egui:intnl test="<%=testName%>"/></b>&nbsp;<egui:intnl text="admin.test.parameters to be configured for"/><b>&nbsp;<%=removeNull(componentName)%></b>&nbsp;<b>(<egui:intnl type="<%=componentType%>"/>)</b></div>
<%
		if (testName.indexOf("Vmg")>-1 && !isAggregateTest)
		{
			String mappingType = "";
			if ( componentType.equals("VmEsx_i_server") || componentType.equals("VmVdi_i_server") )
				mappingType = "esx";
			else if ( componentType.equals("Xen_virtual_server"))
				mappingType = "xen";
%>
					<div style="float:right"><egui:intnl text="admin.test.To View VMs details"/>&nbsp;<a class ="eg_monlink" href="javascript:void(0);" onclick="javascript:showVmLogTable('EgVmLogDisplay.jsp?phyServer=<%=componentNickName%>&type=<%=mappingType%>','from=testconfig','<%=remoteAgent%>','eg_vm.ini',event);"><b><egui:intnl text="admin.test.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></div></td>
				</tr>
<%
		}
		if (isOracleDatabaseCompType && 
			isPortRelevantForTest && 
			egSpecs.isInfoRelevantForTest(testName))
		{
			String compwithcompTypeandPort = componentType+":"+componentName;
			compwithcompTypeandPort = compwithcompTypeandPort.trim();
			String[] valArr = egDisc.getFieldValuesForServer(componentType,compwithcompTypeandPort);
			String hostportlisName = valArr[1] + ":" + valArr[3] + ":" + valArr[5];
			hostportlisName = hostportlisName.trim();
			if (hostportlisName == null)
			{
				hostportlisName = componentName;
			}
%>
				<tr>
					<td nowrap height="24" align="left">&nbsp;<egui:intnl text="admin.test.To create a new database user"/>&nbsp;<a class="eg_monlink" href="EgDbUserCreation.jsp?comptype=<%=componentType%>&compname=<%=hostportlisName%>&qctr=1&rctr=0&t_name=<%=testName%>&server=<%=componentType%>&c_name=<%=componentName%>&version=null&requestFrom=EgConfigureComponentTests.jsp&testType=<%=testType%>"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
		}
		else if (isPolicyParamExists)
		{
			int logTypeIdx = aListResultantInLowerCase.indexOf("-logtype");
			String logTypeVal = (String)aResultant.get(logTypeIdx+1);
			int policyFilterIdx = aListResultantInLowerCase.indexOf("-policyfilter");
			String policyFilterVal = (String)aResultant.get(policyFilterIdx+1);

			if ((policyFilterVal.equalsIgnoreCase("true") && tPolicyFilter.length() == 0) || 
				tPolicyFilter.equalsIgnoreCase("true"))
			{
%>
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To add/modify Policy"/>&nbsp;<a href="ViewPolicy.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&showAll=no&logtype=<%=logTypeVal%>&requestFrom=EgConfigureComponentTests.jsp&componentName=<%=componentName%>&testType=<%=testType%>" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
			}
		}
		else if (listMultipleUserSupportTest != null && 
				listMultipleUserSupportTest.contains(testName))
		{
			multiUserMode = true;
%>
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To configure users for this test" />&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./VmgUsers.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(componentName),"UTF-8")%>','','scrollbars=yes,width=900,height=380,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
		}
		else if (testName.equalsIgnoreCase("SlowTransTest"))
		{
			multiNamePatternMode = true;
%>
			<tr>
				<td nowrap height="24" align="left"><egui:intnl text="admin.test.To configure url patterns for this test"/>&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./EgConfigureNamePattern.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(componentName),"UTF-8")%>','','scrollbars=yes,width=900,height=380,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></td>
			</tr>
<%
		}
		else if (testName.equalsIgnoreCase("CtxAuthTest") || 
				testName.equalsIgnoreCase("WinAuthTest") || 
				testName.equalsIgnoreCase("TermAuthTest"))
		{
			multiUserMode = true;
%>
			<tr>
				<td nowrap height="24" align="left"><egui:intnl text="admin.test.To configure users for this test"/>&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./EgConfigureMultipleUsers.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(componentName),"UTF-8")%>','','scrollbars=yes,width=900,height=380,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></td>
			</tr>
<%
		}
		else if (isEjbGroupingRequired)
		{
			boolean autoDiscovery = false;
			if (aListResultantInLowerCase.contains("-autodiscovery"))
			{
				String autoDiscoveryValue = aResultant.get(aListResultantInLowerCase.indexOf("-autodiscovery")+1).toString().trim();
				autoDiscovery = autoDiscoveryValue.equalsIgnoreCase("true")?true:autoDiscovery;
			}

			if (!autoDiscovery)
			{
				session.setAttribute("sName",componentType);
%>
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To add/modify Groups"/>&nbsp;<a href="<%=pageNameForEjbGrouping%>?comp=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&test=<%=testName%>&server=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&requestFrom=EgConfigureComponentTests.jsp" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
			}
		}
		else if (isAggregateTest)
		{
%>
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To add/modify Aggregate Groups"/>&nbsp;<a class="eg_monlink" href="EgConfigAggregate.jsp?comp=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&test=<%=testName%>&server=<%=componentType%>&requestFrom=EgConfigureComponentTests.jsp"><b><egui:intnl text="admin.common.Click Here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
		}
		else if (testName.equalsIgnoreCase("VCTaskEvtTest"))
		{
%>
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To configure tasks for this test" />&nbsp;<a class="eg_monlink" href="/final/admin/EgConfigureVCTasks.jsp?fromPage=TestConfiguration&componentType=<%=componentType%>&componentName=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&testName=<%=testName%>&requestFrom=EgConfigureComponentTests.jsp"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
		}
		else if (testName.equalsIgnoreCase("VCEventsTest"))
		{
%>
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To configure events for this test" />&nbsp;<a class="eg_monlink" href="/final/admin/EgConfigureVCEvents.jsp?fromPage=TestConfiguration&componentType=<%=componentType%>&componentName=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&testName=<%=testName%>&requestFrom=EgConfigureComponentTests.jsp"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
		}
		else if (isUrlParamExist && isCredentialParamExist)
		{
%>
			<tr>
				<td nowrap height="24" align="left"><egui:intnl text="admin.test.To view/configure URL and credentials for this test"/>&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./EgConfigureUrlAndCredentials.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(componentName),"UTF-8")%>&isPrivateKeyParamExist=<%=isPrivateKeyParamExist%>','','scrollbars=yes,width=900,height=500,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></td>
			</tr>
<%
		}

		String testPeriodVal = "";
		String reqCorrectValue = "";
		if (testName.equals(previousTestName))
		{
			testPeriodVal = request.getParameter("testPeriod");
			testPeriodVal = (testPeriodVal != null)?testPeriodVal:"";

			reqCorrectValue = request.getParameter("correct");
			reqCorrectValue = (reqCorrectValue != null)?reqCorrectValue:"";
		}
%>

				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">&nbsp;<%=componentNickName%></td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_subcontentbg"><col width="7px"><col width="350"><col width="25"><col width="60%"><col width="7px">
							<tr>
								<td id="formtop_border">&nbsp;</td>
								<td id="formtop_border"><egui:intnl text="admin.test.TEST PERIOD"/></td>
								<td id="formtop_border">:</td>
								<td id="formtop_border">
									<select name="testPeriod" class="list">
<%
		boolean b = true;
		Iterator itr = periodMap.keySet().iterator();
		for (int i=0; i<periodMap.size(); i++)
		{
			Long lngperiod = (Long)itr.next();
			String periodVal = lngperiod.toString();
			String periodStr = (String)periodMap.get(lngperiod);

			/* aggregate test frequency should be greater than or equals to its member's test frequency */
			/* starts */
			if(EgInstallInfo.isAggSupported && allowAggregateOperation)
			{
				if(minimumTestPeriod>-1 && (Integer.parseInt(periodVal))<minimumTestPeriod) continue;
			}
			/* ends */

			if (periodVal.equals(testPeriodVal))
			{
				out.println("<option value = '" + periodVal + "' selected>" + periodStr + "</option>");
				b = false;
			}
			else if (periodVal.equals(testperiod) && b)
			{
				out.println("<option value = '" + periodVal + "' selected>" + periodStr + "</option>");
			}
			else
			{
				out.println("<option value = '" + periodVal + "'>" + periodStr + "</option>");
			}
		}
%>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
		boolean isCorrectParamExist = (aListResultantInLowerCase.contains("-correct") && aListResultantInLowerCase.contains("-alarmtype") && aListResultantInLowerCase.contains("-userparams") && aListResultantInLowerCase.contains("-correctivescript"));

		boolean isCorrectiveScriptEnabled = false;
		if (isCorrectParamExist)
		{
			int correctiveIdx = aListResultantInLowerCase.indexOf("-correct");
			String correctVal = (String)aResultant.get(correctiveIdx+1);
			if (reqCorrectValue.length() == 0)
			{
				if (correctVal.equals("true"))
				{
					isCorrectiveScriptEnabled = true;
				}
			}
			else
			{
				if (reqCorrectValue.equals("true"))
				{
					isCorrectiveScriptEnabled = true;
				}
			}
		}

		//start here for retrieving agent os
		boolean isPortParamExist = aListResultantInLowerCase.contains("-host");
		if (isPortParamExist)
		{
			boolean isCompAgentless = agentInfo.isAgentlessServer(componentNickName,componentType);
			boolean isInternalTest = egSpecs.isTestInternal(testName, componentType);
			String agentName = "";
			String agentOS = "";
			if (isInternalTest)
			{
				String interAgentMappingName = (String)internalAgentMap.get(componentNickName);
				if (interAgentMappingName == null)
				{
					agentName = componentNickName;
				}
				else
				{
					agentName = interAgentMappingName;
				}
			}
			else
			{
				String mappingName[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
				String agentExternalName = mappingName[0];
				agentName = agentExternalName;
			}
			agentOS = agentconfig.getAgentOS(agentName);
%>
			<input type="hidden" name="agentOS" value="<%=agentOS%>">
<%
		}

		Arrays.sort(paramToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(processParamremoteContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(snmpV1V2ParamToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(snmpV3ParamToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(multiUserReadOnlyParam, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(multiNameReadOnlyParam, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(modeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(modeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measureModeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measureModeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measurementModeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measurementModeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(paramsNeededToDoValidation, String.CASE_INSENSITIVE_ORDER);

		String testInfoDelimiter = egSpecs.getTestInfoDelimiter(testName);
		if (testInfoDelimiter.trim().length() == 0)
		{
			testInfoDelimiter = "#";
		}
		strDelimiter = testInfoDelimiter;
		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
		String[] infoDelilimterMasksArr  = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
		ArrayList infoDelilimterMasksList = new ArrayList();
		if (infoDelilimterMasksArr != null)
		{
			infoDelilimterMasksList = new ArrayList(Arrays.asList(infoDelilimterMasksArr));
		}

		boolean hasMultipleUsers = false;
		boolean hasMultipleNames = false;

// code starts to form component credentials for Validation - Rajesh


		StringBuffer sbValForValidation=new StringBuffer(256);
		if(aListResultantTempInLowerCase!=null && !aListResultantTempInLowerCase.isEmpty())
		{
			Iterator itrAListResultant=aListResultantTempInLowerCase.iterator();
			for(int p=0;p<aListResultantTempInLowerCase.size();p=p+3)
			{
				String aListParam=(String)aListResultantTempInLowerCase.get(p);
				if(aListParam!=null)
				{
					aListParam=aListParam.substring(1,aListParam.length());
					aListParam=aListParam.toLowerCase();
					int validateParamIdx = Arrays.binarySearch(paramsNeededToDoValidation,aListParam,String.CASE_INSENSITIVE_ORDER);
					if(validateParamIdx>-1)
					{
						String aListValue=(String)aListResultantTempInLowerCase.get(p+1);
						if(aListValue!=null && (!aListValue.equals("") && !aListValue.equalsIgnoreCase("null")))
						{
							sbValForValidation.append("-"+aListParam+":"+aListValue+"|#|");
						}
					}
					if (isSnmp)
					{
						if (!isSnmpV1V2)
						{
							int snmpV3ParamIdx = Arrays.binarySearch(snmpV3ParamToContinue,aListParam,String.CASE_INSENSITIVE_ORDER);
							if(snmpV3ParamIdx>-1)
							{
								String aListValue=(String)aListResultantTempInLowerCase.get(p+1);
								if(aListValue!=null && (!aListValue.equals("") && !aListValue.equalsIgnoreCase("null")))
								{
									sbValForValidation.append("-"+aListParam+":"+aListValue+"|#|");
								}
							}
						}
					}
				}
			}

			if(componentType!=null && componentType.equalsIgnoreCase("ms_sql_server"))
			{
				if(aListResultantTempInLowerCase!=null && aListResultantTempInLowerCase.contains("-isntlmv2"))
				{
					paramForDisplayingValidateButton="isntlmv2";
				}
			}
			else if(componentType!=null && (componentType.equalsIgnoreCase("network_node") || componentType.toLowerCase().indexOf("cisco")>-1))
			{
				if(paramForDisplayingValidateButton!=null && (!paramForDisplayingValidateButton.equals("") && !paramForDisplayingValidateButton.equalsIgnoreCase("null"))) // This condition is to make sure that validation settings are configured for componenttype.bcoz  validation button must be placed on specific location only when validation settings are configured for the componenttype.
				{
					if (isSnmp)
					{
						if (!isSnmpV1V2)
						{
							if(aListResultantTempInLowerCase!=null && aListResultantTempInLowerCase.contains("-encryptflag"))
							{
								paramForDisplayingValidateButton="encryptflag";
							}
						}
					}
				}
			}
		}
		if(sbValForValidation!=null)
		{
			componentCredentialsNeededToDoValidation=sbValForValidation.toString();
		}
		paramsForValidationURL=paramsForValidationURL+"&isSNMP="+isSnmp;
// code ends to form component credentials for Validation  

		//added by pravat --start
		if (isXDMGetDevicesInfo)
		{
			paramsForValidationURL = "test="+EgURLEncoder.encode(testName,"UTF-8")+"&action=pickAgentToValidate&taskName=WebServiceValidity"+"&compName="+EgURLEncoder.encode(componentName,"UTF-8")+"&componentType="+componentType+"&configurationType=specificConfiguration"+"&allowHostName="+isAllowHostName;
			requiredParamNames = requiredParamNames+",passwordconfirmpassword";
			int userNameIdx = aListResultantInLowerCase.indexOf("-username");
			String userName = (String)aResultant.get(userNameIdx+1);
			int passwordIdx = aListResultantInLowerCase.indexOf("-password");
			String passWord = (String)aResultant.get(passwordIdx+1);
			passWord = EgCrypt.decrypt(passWord);
			paramsForValidationURL = paramsForValidationURL+"&xenMobileUserName="+userName+"&xenMobilePassword="+passWord;
		}
		//added by pravat -- end

		for (int i=0;i<aResultant.size();i=i+3)
		{
			String paramName = (String)aResultant.get(i);

			aListParamNamesValues.add(paramName);

			paramName = paramName.substring(1).trim();

			if (infoDelilimterMasksList.contains(testName+":"+paramName+":"+testInfoDelimiter))
			{
				strDelimiterMask = testsIni.getValue("TEST_INFO_DELIMITER_MASK",testName+":"+paramName+":"+testInfoDelimiter);
				if (strDelimiterMask.trim().length() == 0)
				{
					strDelimiterMask = "0egHash1";
				}
			}
			String paramValue = (String)aResultant.get(i+1);

			if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
			{
%>
				<input type="hidden" name="AGGREGATEDESCRIPTOR_previous" value="<%=paramValue%>">
<%
			}

			String displayControl = (String)aResultant.get(i+2);
			displayControl = displayControl.trim();

			//if (aListParamsWithDoubleQuotes != null && !aListParamsWithDoubleQuotes.contains(paramName.toLowerCase()) && !displayControl.equalsIgnoreCase("password"))
			if (!displayControl.equalsIgnoreCase("password"))
			{
				paramValue = paramValue.trim();

				if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
				{
					paramValue = paramValue.substring(1,paramValue.length()-1);
				}
			}
			aListParamNamesValues.add(paramValue);

			if(componentType.equals("Client_desktop") && (testName.equals("ClientServiceTest") || testName.equals("ClientTcpTest")))
			{
				if(paramName.equalsIgnoreCase("adapter_device_selection"))
				{
					String paramValue_new = request.getParameter("adapter_device_selection");
					if(paramValue_new != null && (paramValue_new=paramValue_new.trim()).length()>0 && !paramValue_new.equalsIgnoreCase("null"))
					{
						paramValue = paramValue_new;
					}
					if(paramValue.equalsIgnoreCase("automatic"))
					{
						isAutoSelected = true;
					}
				}
				if((paramName.equalsIgnoreCase("device_name") || paramName.equalsIgnoreCase("device_id")) && isAutoSelected)
				{
%>
					<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='Default'>
<%
					continue;
				}
			}

			int elementIdx = Arrays.binarySearch(paramToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
			if (elementIdx > -1) continue;
			if (testName.equalsIgnoreCase("SecurityLogTest"))
			{
				if (paramName.equalsIgnoreCase("users") || paramName.equalsIgnoreCase("eventids"))
				{
					continue;
				}
			}

			if (isSnmp)
			{
				//Displaying the needed parameters in the ui for snmpV1 and snmpV2 only.
				int snmpParamIdx = Arrays.binarySearch(snmpV1V2ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				if (snmpVer.length() == 0)
				{
					if (isSnmpV1V2)
					{
						if (snmpParamIdx > -1) continue;
					}
				}
				else if(snmpVer.equals("v1") || snmpVer.equals("v2"))
				{
					if (snmpParamIdx > -1) continue;
				}

				//for snmpV3
				if (paramName.equalsIgnoreCase("snmpversion"))
				{
					tempSnmpVersion = paramValue;
				}

				if (paramName.equalsIgnoreCase("snmpcommunity"))
				{
					if (snmpVer.length() == 0)
					{
						if (tempSnmpVersion.equalsIgnoreCase("v3")) continue;
					}
					else
					{
						if (snmpVer.equalsIgnoreCase("v3")) continue;
					}
				}

				//In snmpV3 hiding encrypt type and encrypt password when its value is false.
				int snmpV3ParamIdx = Arrays.binarySearch(snmpV3ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				if (!isSnmpV1V2)
				{
					if (encryptFlag.length() == 0)
					{
						if (encryptValue.equalsIgnoreCase("false"))
						{
							if (snmpV3ParamIdx > -1) continue;
						}
					}
					else if(encryptFlag.equalsIgnoreCase("false"))
					{
						if (snmpV3ParamIdx > -1) continue;
					}
				}

				if (isModeParamExist)
				{
					int modeIdx = aListResultantInLowerCase.indexOf("-mode");
					String modeValue = ((String)aResultant.get(modeIdx+1)).trim();

					String requestModeValue = "";
					if (testName.equals(previousTestName))
					{
						requestModeValue = request.getParameter(((String)aResultant.get(modeIdx)).substring(1));
						requestModeValue = (requestModeValue == null)?"":requestModeValue;
					}

					if (!requestModeValue.equals("")) 
					{
						modeValue = requestModeValue;
					}

					if (modeValue.equalsIgnoreCase("true"))
					{
						int modeTrueParamIdx = Arrays.binarySearch(modeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
						if (modeTrueParamIdx > -1) continue;
					}
					else
					{
						int modeFalseParamIdx = Arrays.binarySearch(modeFalseToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
						if (modeFalseParamIdx > -1) continue;
					}

					int profilerIdx = aListResultantInLowerCase.indexOf("-profiler");
					if (profilerIdx > -1)
					{
						String profilerValue = ((String)aResultant.get(profilerIdx+1)).trim();

						String requestProfilerValue = "";
						if (testName.equals(previousTestName))
						{
							requestProfilerValue = request.getParameter(((String)aResultant.get(profilerIdx)).substring(1));
							requestProfilerValue = (requestProfilerValue == null)?"":requestProfilerValue;
						}

						if (!requestProfilerValue.equals("")) 
						{
							profilerValue = requestProfilerValue;
						}

						if (paramName.equalsIgnoreCase("profiler_home") && 
							profilerValue.equalsIgnoreCase("false"))
						{
							continue;
						}
					}

					int heapAnalysisIdx = aListResultantInLowerCase.indexOf("-heap_analysis");
					if (heapAnalysisIdx > -1)
					{
						String heapAnalysisValue = ((String)aResultant.get(heapAnalysisIdx+1)).trim();

						String requestHeapAnalysisValue = "";
						if (testName.equals(previousTestName))
						{
							requestHeapAnalysisValue = request.getParameter(((String)aResultant.get(heapAnalysisIdx)).substring(1));
							requestHeapAnalysisValue = (requestHeapAnalysisValue == null)?"":requestHeapAnalysisValue;
						}

						if (!requestHeapAnalysisValue.equals("")) 
						{
							heapAnalysisValue = requestHeapAnalysisValue;
						}

						if ((paramName.equalsIgnoreCase("java_home") ||  
							 paramName.equalsIgnoreCase("include_packages") || 
							 paramName.equalsIgnoreCase("exclude_packages")) && 
							heapAnalysisValue.equalsIgnoreCase("false"))
						{
							continue;
						}
					}
				}
			}

			if(isMeasureModeParamExist)
			{
				int modeIdx = aListResultantInLowerCase.indexOf("-measure_mode");
				String modeValue = ((String)aResultant.get(modeIdx+1)).trim();

				String requestModeValue = "";
				if (testName.equals(previousTestName))
				{
					requestModeValue = request.getParameter(((String)aResultant.get(modeIdx)).substring(1));
					requestModeValue = (requestModeValue == null)?"":requestModeValue;
				}

				if (!requestModeValue.equals("")) 
				{
					modeValue = requestModeValue;
				}

				if (modeValue.equalsIgnoreCase("true"))
				{
					int modeTrueParamIdx = Arrays.binarySearch(measureModeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
					if (modeTrueParamIdx > -1) continue;
				}
				else
				{
					int modeFalseParamIdx = Arrays.binarySearch(measureModeFalseToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
					if (modeFalseParamIdx > -1) continue;
				}
			}

			if (isMeasurementModeParamExist)
			{
				int modeIdx = aListResultantInLowerCase.indexOf("-measurement_mode");
				String modeValue = ((String)aResultant.get(modeIdx+1)).trim();

				String requestModeValue = "";
				if (testName.equals(previousTestName))
				{
					requestModeValue = request.getParameter(((String)aResultant.get(modeIdx)).substring(1));
					requestModeValue = (requestModeValue == null)?"":requestModeValue;
				}

				if (!requestModeValue.equals("")) 
				{
					modeValue = requestModeValue;
				}

				if (modeValue.equalsIgnoreCase("true"))
				{
					int modeTrueParamIdx = Arrays.binarySearch(measurementModeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
					if (modeTrueParamIdx > -1) continue;
				}
				else
				{
					int modeFalseParamIdx = Arrays.binarySearch(measurementModeFalseToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
					if (modeFalseParamIdx > -1) continue;
				}
			}

			if (isCorrectParamExist && !isCorrectiveScriptEnabled)
			{
				if (paramName.equalsIgnoreCase("alarmtype") || 
					paramName.equalsIgnoreCase("userparams") || 
					paramName.equalsIgnoreCase("correctivescript"))
				{
					continue;
				}
			}

			//for remote based monitoring continuing the process parameters
			int remProcessParamIdx = Arrays.binarySearch(processParamremoteContinue,paramName,String.CASE_INSENSITIVE_ORDER);
			if(remProcessParamIdx > -1 && isRemote) continue;

			//parameter value comes only for component type called "web" for the parameter "site"
			if (paramValue.equalsIgnoreCase("noteditable")) continue;

			//hide the parameter info
			if (!componentType.equals("Oracle_cluster_service") && paramName.equalsIgnoreCase("info"))
			{
				continue;
			}

			int readOnlyParamIdx = Arrays.binarySearch(multiUserReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			if(readOnlyParamIdx <= -1)
			{
				readOnlyParamIdx = Arrays.binarySearch(multiNameReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			}

			if (readOnlyParamIdx > -1)
			{
				if (paramName.equalsIgnoreCase("domain") || 
					paramName.equalsIgnoreCase("user") || 
					paramName.equalsIgnoreCase("admin_user"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						hasMultipleUsers = true;
					}
				}
				else if (paramName.equalsIgnoreCase("name") || 
					paramName.equalsIgnoreCase("pattern") || 
					paramName.equalsIgnoreCase("threshold_value"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						hasMultipleNames = true;
					}
				}
			}
			if (isAggregateTest)
			{
				if (paramName.equalsIgnoreCase("host") || 
					paramName.equalsIgnoreCase("port"))
				{
					continue;
				}
			}

			if (hasShowAliasParam)
			{
				if (paramName.equalsIgnoreCase("show_alias_and_interface_name") && useAliasValue.equalsIgnoreCase("false"))
				{
					continue;
				}
			}

			if (hasShowAllOnlyParam)
			{
				if (paramName.equalsIgnoreCase("showAllOnly") && showAllEventsValue.equalsIgnoreCase("false"))
				{
					continue;
				}
			}

			if (hasReportOnlyTotalParam)
			{
				if (paramName.equalsIgnoreCase("Report_only_total") && reportTotalValue.equalsIgnoreCase("false"))
				{
					continue;
				}
			}

			String readOnly = "";
			String descriptorButton = "";
			if (aListDescriptorParam.contains(paramName))
			{
				descriptorButton = "<img src=\"/final/admin/eg_images/descriptor-1.gif\" title=\"Click here to configure value for specfic descriptor\" class=\"leftmouse\" onClick=\"openDescriptorDetails(\'this.event\',\'EgDetailsTest.jsp?t_name="+testName+"&c_name="+componentName+"&p_value="+paramValue+"&p_name="+paramName+"\')\">";
				readOnly = "readOnly";
			}

			//By default both the fields (host,port) are expected to be read-only
			if (paramName.equalsIgnoreCase("host") && hostEditableMode.equalsIgnoreCase("false"))
			{
				readOnly = "readOnly";
			}
			if (paramName.equalsIgnoreCase("port") && portEditableMode.equalsIgnoreCase("false"))
			{
				readOnly = "readOnly";
			}
			//By default both the fields(host,port) are expected to be read-only

			if (paramName.equalsIgnoreCase("credentials"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aUrlCredentialVal.size();k=k+3)
				{
					if (k >= 3)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aUrlCredentialVal.get(k+1));
					strBuffer.append(":");
					strBuffer.append(aUrlCredentialVal.get(k+2));
				}
%>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}

			if (paramName.equalsIgnoreCase("content"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListContentValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListContentValues.get(k));
				}
%>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}

			if (paramName.equalsIgnoreCase("encoding"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListEncodingValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListEncodingValues.get(k));
				}
%>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}
			
			if (paramName.equalsIgnoreCase("privateKey"))
			{
				StringBuffer strBuffer = new StringBuffer();				
				for (int k=0;k<aListFilePathValues.size();k=k+2)
				{
					if (k >= 2)
					{
						strBuffer.append(",");
					}					
					strBuffer.append(aListFilePathValues.get(k));
					strBuffer.append("#~~#");
					strBuffer.append(aListFilePathValues.get(k+1));
				}
				
%>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}

			if (testName.equalsIgnoreCase("WindowshareTest") && 
				(paramName.equalsIgnoreCase("domainname") || 
				paramName.equalsIgnoreCase("shareusername") || 
				paramName.equalsIgnoreCase("password")))
			{
				if (displayControl.equalsIgnoreCase("password"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						String tempStr = "";
						StringTokenizer st1 = new StringTokenizer(paramValue,"|");
						while(st1.hasMoreTokens())
						{
							tempStr += EgCrypt.decrypt(st1.nextToken()) + "#~#";
						}
						paramValue = tempStr.substring(0, tempStr.length()-3);
					}
					else
					{
						paramValue = EgCrypt.decrypt(paramValue);
					}
				}
				else
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
				}
%>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=paramValue%>'>
<%
				continue;
			}
%>
							<tr>
								<td id="formtop_border" style="valign:middle">
<%
			boolean showStar = false;
			if (isAutoConfiguration && paramValue.startsWith("$") && aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
			{
				showStar = true;
				String tempNewValue = null;
				if (testName.equals(previousTestName))
				{
					tempNewValue = request.getParameter(paramName);
					if (tempNewValue != null)
					{
						tempNewValue = tempNewValue.toLowerCase();
						if (!aListTcKeywordsLowerCase.contains(tempNewValue))
						{
							showStar = false;
						}
					}
				}

				if (showStar)
				{
%>
					<font color='black'>&nbsp;&nbsp;*&nbsp;</font>
<%
				}
				else
				{
%>
					&nbsp;&nbsp;
<%
				}
			}
			else
			{
%>
				&nbsp;&nbsp;
<%
			}
%>
								</td>
								<td id="formtop_border"><egui:intnl text='<%="admin.test."+paramName.toUpperCase()%>'/></td>
								<td id="formtop_border">:</td>
<%
			if (displayControl.equalsIgnoreCase("radio"))
			{
				//Dependent Parameter - Having relationship with other parameters
				//For e.g., correct which has relations with alarmtype,userparams,correctivescript
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., isPassive
				//ProcessTest=wide(Yes:true#No:false) - Independent param
				//parameter value definition = (Yes:true#No:false)
				//Independent parameter having values true (or) false,yes (or) no,y (or) n doesnt 
				//need to define parameter value definition.
				//so ProcessTest=wide(Yes:true#No:false) can also be called as ProcessTest=wide
				//This will be handled in else block
				boolean isIndependentParam = aListDynamicRadioOptionNameAndValue.contains(paramName);
				if (isIndependentParam)
				{
					//block fires when the user put corresponding value to the isolated
					//radio parameter.
					int paramIdx = aListDynamicRadioOptionNameAndValue.indexOf(paramName);
					String tempParamValue = (String)aListDynamicRadioOptionNameAndValue.get(paramIdx+1);
					StringTokenizer st = new StringTokenizer(tempParamValue,"#");
					String tempParam = st.nextToken();
					String tempName1 = tempParam.substring(0,tempParam.indexOf(":"));
					String tempValue1 = tempParam.substring(tempParam.indexOf(":")+1,tempParam.length());
					String tempParam1 = st.nextToken();
					String tempName2 = tempParam1.substring(0,tempParam1.indexOf(":"));
					String tempValue2 = tempParam1.substring(tempParam1.indexOf(":")+1,tempParam1.length());

					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
					}

					if (paramValue.equalsIgnoreCase("yes"))
					{
						paramValue = "true";
					}
					else if (paramValue.equalsIgnoreCase("no"))
					{
						paramValue = "false";
					}

					if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue1.equalsIgnoreCase(paramValue))
					{
						enabled = "checked";
						disabled = "";
					}
					else if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue2.equalsIgnoreCase(paramValue))
					{
						enabled = "";
						disabled = "checked";
					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue1))
					{
						enabled = "checked";
						disabled = "";
					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue2))
					{
						enabled = "";
						disabled = "checked";
					}

					aListDisplay.add(paramName+"#"+tempValue1);
					aListDisplay.add(tempName1);
					aListDisplay.add(paramName+"#"+tempValue2);
					aListDisplay.add(tempName2);
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
<%
					if (paramName.equalsIgnoreCase("Aggregate_user_sessions") && 
						viewAccessOnly && disabled.equalsIgnoreCase("checked"))
					{
%>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue1%>" <%=enabled%> disabled></td>
														<td valign="middle"><%=tempName1%></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue2%>" <%=disabled%> disabled></td>
														<td valign="middle"><%=tempName2%></td>
													</tr>
												</table>
											</td>
<%
					}
					else
					{
%>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue1%>" <%=enabled%>></td>
														<td valign="middle"><%=tempName1%></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue2%>" <%=disabled%>></td>
														<td valign="middle"><%=tempName2%></td>
													</tr>
												</table>
											</td>
<%
					}

					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
				}
				else
				{
					if (paramName.equalsIgnoreCase("encryptflag") && isSnmp)
					{
						String encryptFlagVal = "";
						if (testName.equals(previousTestName))
						{
							encryptFlagVal = request.getParameter(paramName);
							encryptFlagVal = (encryptFlagVal!=null)?encryptFlagVal:"";
						}

						if (paramValue.equalsIgnoreCase("true") && encryptFlagVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
						}
						else if (paramValue.equalsIgnoreCase("false") && encryptFlagVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
						}
						else if (encryptFlagVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
						}
						else if (encryptFlagVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=enabled%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=disabled%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%					
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("policyfilter") && isPolicyParamExists)
					{
						String policyFilterValue = "";
						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(paramName);
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}

						if (paramValue.equalsIgnoreCase("true") && policyFilterValue.length()==0)
						{
							enabled = "checked";
							disabled = "";
						}
						if (paramValue.equalsIgnoreCase("false") && policyFilterValue.length()==0)
						{
							enabled = "";
							disabled = "checked";
						}
						else if(policyFilterValue.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
						}
						else if(policyFilterValue.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=enabled%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=disabled%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%					
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("correct") && !isRemote && isCorrectParamExist)
					{
						String correctVal = "";
						if (testName.equals(previousTestName))
						{
							correctVal = request.getParameter(paramName);
							correctVal = (correctVal != null && correctVal.length() > 0)?correctVal:"";
						}

						if(paramValue.equalsIgnoreCase("false") && correctVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
						}
						else if(paramValue.equalsIgnoreCase("true") && correctVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
						}
						else if(correctVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
						}
						else if(correctVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=enabled%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=disabled%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%					
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
					}
					else if(paramName.equalsIgnoreCase("mode") && isModeParamExist)
					{
						String snmpSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							snmpSelected = "checked";
						}
						else
						{
							jmxSelected = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=snmpSelected%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.SNMP"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=jmxSelected%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.JMX"/></td>
													</tr>
												</table>
											</td>
<%					
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("SNMP");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					else if(paramName.equalsIgnoreCase("measure_mode") && isMeasureModeParamExist)
					{
						String logFileSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							logFileSelected = "checked";
						}
						else
						{
							jmxSelected = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=logFileSelected%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.Log File"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=jmxSelected%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.JMX"/></td>
													</tr>
												</table>
											</td>
<%
						if (paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
						}
						else
						{
%>
											<td>&nbsp;</td>
<%
						}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Log File");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					else if(paramName.equalsIgnoreCase("measurement_mode") && isMeasurementModeParamExist)
					{
						String warFileSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							warFileSelected = "checked";
						}
						else
						{
							jmxSelected = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=warFileSelected%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.War File"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=jmxSelected%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.JMX"/></td>
													</tr>
												</table>
											</td>
<%
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
						}
						else
						{
%>
											<td>&nbsp;</td>
<%
						}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("War File");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					else if(paramName.equalsIgnoreCase("profiler") && isModeParamExist)
					{
						String profilerOn = "";
						String profilerOff = "";
						String profilerValue = new String(paramValue);

						String requestProfilerValue = "";
						if (testName.equals(previousTestName))
						{
							requestProfilerValue = request.getParameter(paramName);
							requestProfilerValue = (requestProfilerValue==null)?"":requestProfilerValue;
						}

						if (!requestProfilerValue.equals(""))
						{
							profilerValue = requestProfilerValue;
						}

						if (profilerValue.equalsIgnoreCase("true"))
						{
							profilerOn = "checked";
						}
						else
						{
							profilerOff = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=profilerOn%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.On"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=profilerOff%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.Off"/></td>
													</tr>
												</table>
											</td>
<%					
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("On");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("Off");
					}
					else if(paramName.equalsIgnoreCase("heap_analysis") && isModeParamExist)
					{
						String heapAnalysisYes = "";
						String heapAnalysisNo = "";
						String heapAnalysisValue = new String(paramValue);

						String requestHeapAnalysisValue = "";
						if (testName.equals(previousTestName))
						{
							requestHeapAnalysisValue = request.getParameter(paramName);
							requestHeapAnalysisValue = (requestHeapAnalysisValue==null)?"":requestHeapAnalysisValue;
						}

						if (!requestHeapAnalysisValue.equals(""))
						{
							heapAnalysisValue = requestHeapAnalysisValue;
						}

						if (heapAnalysisValue.equalsIgnoreCase("true"))
						{
							heapAnalysisYes = "checked";
						}
						else
						{
							heapAnalysisNo = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=heapAnalysisYes%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=heapAnalysisNo%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%					
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if(paramName.equalsIgnoreCase("useAlias") && hasShowAliasParam)
					{
						String usealiasYes = "";
						String usealiasNo = "";
						String usealiasValue = new String(paramValue);

						String requestusealiasValue = "";
						if (testName.equals(previousTestName))
						{
							requestusealiasValue = request.getParameter(paramName);
							requestusealiasValue = (requestusealiasValue==null)?"":requestusealiasValue;
						}

						if (!requestusealiasValue.equals(""))
						{
							usealiasValue = requestusealiasValue;
						}
						if (usealiasValue.equalsIgnoreCase("true") || usealiasValue.equalsIgnoreCase("yes"))
						{
							usealiasYes = "checked";
						}
						else
						{
							usealiasNo = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=usealiasYes%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=usealiasNo%> onclick='javascript:changeValue()'></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%					
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("showAllEvents") && hasShowAllOnlyParam)
					{
						String showalleventsYes = "";
						String showalleventsNo = "";
						String showalleventsValue = new String(paramValue);

						String requestshowalleventsValue = "";
						if (testName.equals(previousTestName))
						{
							requestshowalleventsValue = request.getParameter(paramName);
							requestshowalleventsValue = (requestshowalleventsValue==null)?"":requestshowalleventsValue;
						}

						if (!requestshowalleventsValue.equals(""))
						{
							showalleventsValue = requestshowalleventsValue;
						}
						if (showalleventsValue.equalsIgnoreCase("true") || showalleventsValue.equalsIgnoreCase("yes"))
						{
							showalleventsYes = "checked";
						}
						else
						{
							showalleventsNo = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=showalleventsYes%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=showalleventsNo%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("Report_total") && hasReportOnlyTotalParam)
					{
						String reporttotalYes = "";
						String reporttotalNo = "";
						String reporttotalValue = new String(paramValue);

						String requestreporttotalValue = "";
						if (testName.equals(previousTestName))
						{
							requestreporttotalValue = request.getParameter(paramName);
							requestreporttotalValue = (requestreporttotalValue==null)?"":requestreporttotalValue;
						}

						if (!requestreporttotalValue.equals(""))
						{
							reporttotalValue = requestreporttotalValue;
						}
						if (reporttotalValue.equalsIgnoreCase("true") || reporttotalValue.equalsIgnoreCase("yes"))
						{
							reporttotalYes = "checked";
						}
						else
						{
							reporttotalNo = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=reporttotalYes%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=reporttotalNo%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("adapter_device_selection"))
					{
						String automaticChecked = "checked";
						String manualChecked = "checked";
						if(paramValue == null ||  paramValue.equalsIgnoreCase("automatic"))
						{
							manualChecked = "";
						}
						else
						{
							automaticChecked = "";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="automatic" onclick='javascript:changeValue()' <%=automaticChecked%>></td>
														<td valign="middle"><egui:intnl text="admin.common.Automatic"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="manual" onclick='javascript:changeValue()' <%=manualChecked%>></td>
														<td valign="middle"><egui:intnl text="admin.common.Manual"/></td>
													</tr>
												</table>
											</td>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Automatic");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("Manual");
					}
					else
					{
						//handling independent parameter for radio - starts
						//handled yes,no,true,false,y and n only
						//block fires when the user forgets to put corresponding value
						//to the isolated radio parameter.Parameter are handled to their
						//default values.
						String value1 = "";
						String value2 = "";

						if (paramValue.equalsIgnoreCase("yes") || 
							paramValue.equalsIgnoreCase("no"))
						{
							value1 = "yes";
							value2 = "no";
						}
						else if (paramValue.equalsIgnoreCase("true") || 
							paramValue.equalsIgnoreCase("false"))
						{
							value1 = "true";
							value2 = "false";
						}
						else
						{
							value1 = "y";
							value2 = "n";
						}

						String selectedParamValue = "";
						if (testName.equals(previousTestName))
						{
							selectedParamValue = request.getParameter(paramName);
							selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
						}

						if (selectedParamValue.equals(""))
						{
							if (paramValue.equalsIgnoreCase("n") || 
								paramValue.equalsIgnoreCase("no") || 
								paramValue.equalsIgnoreCase("false"))
							{
								enabled = "";
								disabled = "checked";
							}
							else
							{
								enabled = "checked";
								disabled = "";
							}
						}
						else
						{
							if (selectedParamValue.equalsIgnoreCase("n") || 
								selectedParamValue.equalsIgnoreCase("no") || 
								selectedParamValue.equalsIgnoreCase("false"))
							{
								enabled = "";
								disabled = "checked";
							}
							else
							{
								enabled = "checked";
								disabled = "";
							}
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
<%
						if (paramName.equalsIgnoreCase("Report_By_User") && 
							viewAccessOnly && enabled.equalsIgnoreCase("checked"))
						{
%>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value1%>" <%=enabled%> disabled></td>
														<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value2%>" <%=disabled%> disabled></td>
														<td valign="middle"><egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%
						}
						else if (paramName.equalsIgnoreCase("ReportByClientName") && 
							viewAccessOnly && disabled.equalsIgnoreCase("checked"))
						{
%>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value1%>" <%=enabled%> disabled></td>
														<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value2%>" <%=disabled%> disabled></td>
														<td valign="middle"><egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%
						}
						else
						{
%>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value1%>" <%=enabled%>></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value2%>" <%=disabled%>></td>
														<td valign="middle">&nbsp;<egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
<%
						}

					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
											<td><div style="padding-left:50px"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></div></td>
<%
					}
					else
					{
%>
											<td>&nbsp;</td>
<%
					}
%>
										</tr>
									</table>
								</td>
							</tr>
<%
						//handling independent parameter for radio - ends
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("select"))
			{
				//Dependent Parameter - Having relationship with other parameters
				//For e.g., snmpVersion which has relations with snmpCommunity,AuthType,AuthPass,EncryptType,EncryptPass
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., alarmtype
				boolean isIndependentParam = aListDynamicSelectOptionNameAndValue.contains(paramName);
				if (isIndependentParam)
				{
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" id="<%=paramName%>">
<%
					int strParamIdx = aListDynamicSelectOptionNameAndValue.indexOf(paramName);
					String strParamValue = (String)aListDynamicSelectOptionNameAndValue.get(strParamIdx+1);

					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue != null)?selectedParamValue:"";
					}

					StringTokenizer st = new StringTokenizer(strParamValue,"#");
					while (st.hasMoreTokens())
					{
						String s = st.nextToken();
						String strText = s.substring(0,s.indexOf(":"));
						String strValue = s.substring(s.indexOf(":")+1,s.length());
						aListDisplay.add(paramName+"#"+strValue);
						aListDisplay.add(strText);
						if (paramValue.equals(strValue))
						{
%>
								<option value=<%=strValue%> selected><%=strText%></option>
<%
						}
						else if (selectedParamValue.equals(strValue))
						{
%>
								<option value=<%=strValue%> selected><%=strText%></option>
<%
						}
						else
						{
%>
								<option value=<%=strValue%>><%=strText%></option>
<%
						}
					}
%>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
				}
				else
				{
					if (paramName.equalsIgnoreCase("snmpversion") && isSnmp)
					{
						String temp = paramValue;
						String strVal = "";
						if (testName.equals(previousTestName))
						{
							strVal = request.getParameter(paramName);
						}

						paramValue = (strVal == null || strVal.equals(""))?temp:strVal;
						String select = "";
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" class="list" onChange='javaScript:changeValue()' id="<%=paramName%>">
<%
						for(int k=0;k<versions.length;k++)
						{
							if(versions[k].equalsIgnoreCase(paramValue))
							{
								select = "selected";
							}
							else
							{
								select = "";
							}
%>
							<option value="<%=versions[k]%>"<%=select%>><%=versions[k]%></option>
<%
						}
%>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("authtype") && isSnmp)
					{
						String select = "";
						String authTypeVal = paramValue;

						if (testName.equals(previousTestName))
						{
							authTypeVal = request.getParameter(paramName);
						}

						authTypeVal = (authTypeVal!=null)?authTypeVal:paramValue;
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" class="list" id="<%=paramName%>">
<%
						for(int k=0;k<authTypes.length;k++)
						{
							if(authTypeVal.equals(authTypes[k]))
							{
								select = "selected";
							}
							else
							{
								select = "";
							}
%>
							<option value="<%=authTypes[k]%>"<%=select%>><%=authTypes[k]%></option>
<%
						}
%>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("encrypttype") && isSnmp)
					{
						String select = "";
						String encryptTypeVal = paramValue;

						if (testName.equals(previousTestName))
						{
							encryptTypeVal = request.getParameter(paramName);
						}

						encryptTypeVal = (encryptTypeVal!=null)?encryptTypeVal:paramValue;
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" class="list" id="<%=paramName%>">
<%
						for(int k=0;k<encryptTypes.length;k++)
						{
							if(encryptTypeVal.equals(encryptTypes[k]))
							{
								select = "selected";
							}
							else
							{
								select = "";
							}
%>
							<option value="<%=encryptTypes[k]%>"<%=select%>><%=encryptTypes[k]%></option>
<%
						}
%>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if(paramName.equalsIgnoreCase("filter") && isPolicyParamExists)
					{
						int policyFilterIdx = aListResultantInLowerCase.indexOf("-policyfilter");

						String policyFilterValue = "";
						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(((String)aResultant.get(policyFilterIdx)).substring(1));
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}
						if (policyFilterValue.equalsIgnoreCase("true"))
						{
							ArrayList aListPolicy = new ArrayList();
							String select = "";
							String filterName = paramValue;
							if(filterName.indexOf(":") > -1)
							{
								if(filterName.indexOf(";") > -1)
								{
									StringTokenizer policyTokens = new StringTokenizer(filterName,";");
									while(policyTokens.hasMoreTokens())
									{
										String tempPolicy = policyTokens.nextToken();
										tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
										aListPolicy.add(tempPolicy);
									}
								}
								else
								{
									aListPolicy.add(filterName.substring(0,filterName.indexOf(":")));
								}
							}
							else if (filterName.indexOf(";") > -1)
							{
								StringTokenizer policyTokens = new StringTokenizer(filterName,";");
								while(policyTokens.hasMoreTokens())
								{
									String tempPolicy = policyTokens.nextToken();
									aListPolicy.add(tempPolicy);
								}
							}
							else
							{
								aListPolicy.add(filterName);
							}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" class="list" multiple size="5" width="350" style="width:350px;" id="<%=paramName%>">
<%
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								if(aListPolicy.contains(aPolicyFilter.get(k)))
								{
									select = "selected";
								}
								else
								{
									select = "";
								}
%>
								<option value="<%=(String)aPolicyFilter.get(k)%>" <%=select%>><%=(String)aPolicyFilter.get(k)%></option>
<%
							}
%>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") > -1)
						{
							//called while loading the page when policy filter value is "no"
							paramValue = StringUtils.replace(paramValue,"|",",");
%>
								<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td valign="top"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="28"><%=paramValue%></textarea></td>
											<td nowrap>&nbsp;&nbsp;<input type="button" name ="viewurl" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;"></td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") == -1)
						{
							ArrayList aTemp = new ArrayList();
							if (paramValue.indexOf(";") > -1)
							{
								StringTokenizer st = new StringTokenizer(paramValue,";");
								while (st.hasMoreTokens())
								{
									aTemp.add(st.nextToken().trim());
								}
							}
							else
							{
								aTemp.add(paramValue);
							}
								String select = "";
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" id="<%=paramName%>" class="list" multiple size="5" width="350" style="width:350px;">
<%
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								if(aTemp.contains((String)aPolicyFilter.get(k)))
								{
									select = "selected";
								}
								else
								{
									select = "";
								}
%>
								<option value="<%=(String)aPolicyFilter.get(k)%>" <%=select%>><%=(String)aPolicyFilter.get(k)%></option>
<%
							}
%>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
						}
						else if (policyFilterValue.equalsIgnoreCase("false"))//special case
						{
							String tempPolicyFilterValue = "";
							for(int z=0;z<aPolicyFilter.size();z++)
							{
								if (z > 0)
								{
									tempPolicyFilterValue = tempPolicyFilterValue + ";";
								}

								tempPolicyFilterValue = tempPolicyFilterValue + (aPolicyFilter.get(z)).toString();
							}
%>
								<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td valign="top"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="28"><%=tempPolicyFilterValue%></textarea></td>
											<td nowrap>&nbsp;&nbsp;<input type="button" name ="viewurl" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;"></td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
						}
					}
					else if (paramName.equalsIgnoreCase("virtual_center"))
					{
						String selectedVirtualCenter = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedVirtualCenter = request.getParameter(paramName);
						}
						selectedVirtualCenter = (selectedVirtualCenter!=null)?selectedVirtualCenter:paramValue;
						String noneSelected = "";
						String otherSelected = "";
						if (selectedVirtualCenter.equalsIgnoreCase("none"))
						{
							noneSelected = "selected";
						}
						else if (selectedVirtualCenter.equalsIgnoreCase("other"))
						{
							otherSelected = "selected";
						}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" size="1" style="width:150px;"
									onchange="javascript:changeVirtualCenterValue(this.value);" id="<%=paramName%>">
										<option value='None' <%=noneSelected%>><egui:intnl text="admin.test.None"/></option>
<%
						if (virtualCenters != null && virtualCenters.length > 0)
						{
							for (int k=0;k<virtualCenters.length;k++)
							{
								String selected = "";
								String eachVirtualCenter=virtualCenters[k];
								if (selectedVirtualCenter.equalsIgnoreCase(eachVirtualCenter))
								{
									selected = "selected";
								}
%>
											<option value="<%=eachVirtualCenter%>" <%=selected%>><%=eachVirtualCenter%></option>
<%
							}
						}
						else
						{
							if (!selectedVirtualCenter.equalsIgnoreCase("none"))
							{
%>
											<option value="<%=selectedVirtualCenter%>" selected><%=selectedVirtualCenter%></option>
<%
							}
						}
%>
										<option value='Other' <%=otherSelected%>><egui:intnl text="admin.test.Other"/></option>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					/////////////////////// RHEV Code Starts
					else if (paramName.equalsIgnoreCase("Rhel_mgr_host"))
					{
						String selectedRhevMgr = paramValue;//rhevManager
						if (testName.equals(previousTestName))
						{
							selectedRhevMgr = request.getParameter(paramName);
						}
						selectedRhevMgr = (selectedRhevMgr!=null)?selectedRhevMgr:paramValue;
						String noneSelected = "";
						String otherSelected = "";
						if (selectedRhevMgr.equalsIgnoreCase("$unconfigured"))
						{
							selectedRhevMgr = "none";
						}
						if (selectedRhevMgr.equalsIgnoreCase("none"))
						{
							noneSelected = "selected";
						}
						else if (selectedRhevMgr.equalsIgnoreCase("other"))
						{
							otherSelected = "selected";
						}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" size="1" style="width:175px;"
									onchange="javascript:changeRhevMgrValue(this.value);" id="<%=paramName%>">
										<option value='None' <%=noneSelected%>><egui:intnl text="admin.test.Choose an RHEV Manager"/></option>
<%
						if (rhevs != null && rhevs.length > 0)
						{
							for (int k=0;k<rhevs.length;k++)
							{
								String selected = "";
								String eachRhev=rhevs[k];
								if (selectedRhevMgr.equalsIgnoreCase(eachRhev))
								{
									selected = "selected";
								}
%>
											<option value="<%=eachRhev%>" <%=selected%>><%=eachRhev%></option>
<%
							}
						}
						else
						{
							if (!selectedRhevMgr.equalsIgnoreCase("none"))
							{
%>
											<option value="<%=selectedRhevMgr%>" selected><%=selectedRhevMgr%></option>
<%
							}
						}
%>
										<option value='Other' <%=otherSelected%>><egui:intnl text="admin.test.Other"/></option>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					//////////////// RHEV code ends
					else if (paramName.equalsIgnoreCase("management_server"))
					{
						String selectedHMC = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedHMC = request.getParameter(paramName);
						}
						selectedHMC = (selectedHMC!=null)?selectedHMC:paramValue;

						boolean showTextBox = false;
						String strIsManagedByChanged = request.getParameter("isManagedByChanged");
						if (strIsManagedByChanged == null)
						{
							if (resIsManagedByValue.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}
						else if (strIsManagedByChanged != null && strIsManagedByChanged.equalsIgnoreCase("true"))
						{
							String tempManagedBy = request.getParameter("is_managed_by");
							String tempMgmtServerVal = (String)request.getAttribute("management_server");
							if (tempMgmtServerVal != null)
							{
								paramValue = tempMgmtServerVal;
							}

							if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}

						if (showTextBox)
						{
%>
								<td height="30" id="formtop_border">
									<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
								</td>
<%
						}
						else
						{
							String noneSelected = "";
							String otherSelected = "";
							if (selectedHMC.equalsIgnoreCase("none"))
							{
								noneSelected = "selected";
							}
							else if (selectedHMC.equalsIgnoreCase("other"))
							{
								otherSelected = "selected";
							}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" size="1" style="width:150px;"
									onchange="javascript:changeHMCValue(this.value);" id="<%=paramName%>">
										<option value='None' <%=noneSelected%>><egui:intnl text="admin.test.None"/></option>
<%
							if (hmcs != null && hmcs.length > 0)
							{
								for (int k=0;k<hmcs.length;k++)
								{
									String selected = "";
									String eachHMC=hmcs[k];
									if (selectedHMC.equalsIgnoreCase(eachHMC))
									{
										selected = "selected";
									}
%>
											<option value="<%=eachHMC%>" <%=selected%>><%=eachHMC%></option>
<%
								}
							}
							else
							{
								if (!selectedHMC.equalsIgnoreCase("none"))
								{
%>
											<option value="<%=selectedHMC%>" selected><%=selectedHMC%></option>
<%
								}
							}
%>
										<option value='Other' <%=otherSelected%>><egui:intnl text="admin.test.Other"/></option>
									</select>
								</td>
<%
						}
%>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("executiontime"))
					{
						String selectedOption = "";
						if (testName.equals(previousTestName))
						{
							selectedOption = request.getParameter(paramName);
							selectedOption = (selectedOption != null && selectedOption.length() > 0)?selectedOption:"";
						}

						String hourlySelected = "";
						String dailySelected = "";
						if (selectedOption.equals("") && paramValue.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
						}
						else if(!selectedOption.equals("") && selectedOption.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
						}
						else
						{
							dailySelected = "selected";
						}

						ArrayList hours = new ArrayList();
						for (int m=0;m<24;m++)
						{
							if (m < 10)
							{
								hours.add("0"+String.valueOf(m));
							}
							else
							{
								hours.add(String.valueOf(m));
							}
						}

						ArrayList minutes = new ArrayList();
						for (int m=0;m<60;m++)
						{
							if (m < 10)
							{
								minutes.add("0"+String.valueOf(m));
							}
							else
							{
								minutes.add(String.valueOf(m));
							}
						}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" size="1" style="width:70px;" onchange="javascript:changeExecutiontime(this.value);" id="<%=paramName%>">
										<option value="hourly" <%=hourlySelected%>><egui:intnl text="admin.test.Hourly"/></option>
										<option value="daily" <%=dailySelected%>><egui:intnl text="admin.test.Daily"/></option>
									</select>
<%
						if (dailySelected.equals("selected"))
						{
							if (!(paramValue.indexOf(":")>-1)) paramValue="00:00";
							String selectedHr = paramValue.substring(0,paramValue.indexOf(":"));
							String selectedMin = paramValue.substring(paramValue.indexOf(":")+1,paramValue.length());
%>
									&nbsp;&nbsp;Hrs&nbsp;:&nbsp;
									<select name="hours" size="1" width="100" style="width:40px;" id="hours">
<%
							for (int m=0;m<hours.size();m++)
							{
								String hrs = ((String)hours.get(m)).trim();
								if (selectedHr.equals(hrs))
								{
%>
									<option value=<%=hrs%> selected><%=hrs%></option>
<%
								}
								else
								{
%>
									<option value=<%=hrs%>><%=hrs%></option>
<%
								}
							}
%>
									</select>
									&nbsp;&nbsp;Mins&nbsp;:&nbsp;
									<select name="minutes" size="1"  width="100" style="width:40px;" id="minutes">
<%
							for (int m=0;m<minutes.size();m++)
							{
								String mins = ((String)minutes.get(m)).trim();
								if (selectedMin.equals(mins))
								{
%>
									<option value=<%=mins%> selected><%=mins%></option>
<%
								}
								else
								{
%>
									<option value=<%=mins%>><%=mins%></option>
<%
								}
							}
%>
									</select>
<%
						}
%>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("Inside_view_using"))
					{
						String exeSelected = "";
						String tcpSelected = "";
						if (paramValue.equalsIgnoreCase("exe"))
						{
							exeSelected = "selected";
						}
						else if(paramValue.equalsIgnoreCase("tcp") || paramValue.equalsIgnoreCase("wmi"))
						{
							tcpSelected = "selected";
						}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" id="<%=paramName%>" onchange="javascript:InsideViewChange(this.value);">
										<option value="exe" <%=exeSelected%>><egui:intnl text="admin.test.Netbios (Windows)"/></option>
										<option value="tcp" <%=tcpSelected%>><egui:intnl text="admin.test.TCP/WMI (Windows)"/></option>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("is_managed_by"))
					{
						String hmcSelected = "";
						String ivmSelected = "";
						if (testName.equals(previousTestName))
						{
							String strManagedBy = request.getParameter(paramName);
							if (strManagedBy != null)
							{
								paramValue = strManagedBy;
							}
						}

						if (paramValue.equalsIgnoreCase("hmc"))
						{
							hmcSelected = "selected";
						}
						else if(paramValue.equalsIgnoreCase("ivm"))
						{
							ivmSelected = "selected";
						}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" id="<%=paramName%>" onchange="javascript:changeIsManagedValue();">
										<option value="hmc" <%=hmcSelected%>><egui:intnl text="admin.test.HMC"/></option>
										<option value="ivm" <%=ivmSelected%>><egui:intnl text="admin.test.IVM"/></option>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if(paramName.equalsIgnoreCase("device_name"))
					{
%>
								<td height="30" id="formtop_border">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td valign="middle"><select name="<%=paramName%>" id="<%=paramName%>" style="width:350px;" onChange="javascript:changeDeviceId(this.selectedIndex);">
<%
						if(paramValue.equalsIgnoreCase("Default"))
						{
%>
											<option value="Default"><egui:intnl text="admin.test.Default"/></option>
<%
						}
						else
						{
%>
											<option value="<%=paramValue%>" selected><%=paramValue%></option>
<%
						}
%>
											</select></td>
											<td valign="middle">&nbsp;<input class="eg_back" type="button" name="selbutton" value='<egui:intnl text="admin.common.Discover"/>' onclick="javascript:loadAdapters()" style="width:80px;"></td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else
					{
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>">
										<option value=<%=paramValue%> selected><%=paramValue%></option>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("password"))
			{
				if (isSnmp)
				{
					String temp = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?temp:strVal;
				}
				else if (paramName.equalsIgnoreCase("management_password"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged != null && strIsManagedByChanged.equals("true"))
					{
						String tempPassValue = (String)request.getAttribute("management_password");
						if (tempPassValue != null)
						{
							paramValue = tempPassValue;
						}
					}
				}

				if(paramValue.indexOf("|") > -1)
				{
					String tempStr = "";
					StringTokenizer st1 = new StringTokenizer(paramValue,"|");
					while(st1.hasMoreTokens())
					{
						tempStr += EgCrypt.decrypt(st1.nextToken()) + "#~#";
					}
					paramValue = tempStr.substring(0, tempStr.length()-3);
				}
				else
				{
					paramValue = EgCrypt.decrypt(paramValue);
				}

				if (paramValue.indexOf("\"") > -1)
				{
					paramValue = StringUtils.replace(paramValue,"\"","&#34;");
				}

				if (readOnlyParamIdx > -1 && multiUserMode && hasMultipleUsers)
				{
					readOnly = "readOnly";
				}
				if (readOnlyParamIdx > -1 && multiNamePatternMode && hasMultipleNames)
				{
					readOnly = "readOnly";
				}

				if (multiUserMode)
				{
%>
								<td id="formtop_border"><input type="password" id="<%=paramName%>" name="<%=paramName%>" value="<%=paramValue%>"<%=readOnly%> onblur="javascript:checkHashTildeHash()">
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
				}
				else
				{
%>
								<td id="formtop_border"><input type="password" id="<%=paramName%>" name="<%=paramName%>" value="<%=paramValue%>">
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
				}

				if (!readOnly.equals("readOnly"))
				{
%>
							<tr>
								<td id="formtop_border">
<%
					if (showStar)
					{
%>
						<font color='black'>&nbsp;&nbsp;*&nbsp;</font>
<%
					}
					else
					{
%>
						&nbsp;&nbsp;
<%
					}
%>
								</td>
								<td id="formtop_border">CONFIRM PASSWORD</td>
								<td id="formtop_border">:</td>
<%
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
								requiredParamNames=requiredParamNames+",passwordconfirmpassword";
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<input type="password" id="<%=paramName+"confirmpassword"%>" name="<%=paramName+"confirmpassword"%>" value="<%=paramValue%>">
											</td>
											<td>
<%
						if (!isXDMGetDevicesInfo)
						{
%>
											<input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);">
<%
						}
						else
						{
%>
											<input class="eg_back" type="button" id="validateForWsdl" name="validateForWsdl" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationUrlForWebservice%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);">
<%
						}
%>
											</td>
										</tr>
									</table>
								</td>
<%
					}
					else
					{
%>
								<td id="formtop_border">
								<input type="password" id="<%=paramName+"confirmpassword"%>" name="<%=paramName+"confirmpassword"%>" value="<%=paramValue%>"></td>
								<td id="formtop_border" align="center">&nbsp;</td>
<%
					}
%>
							</tr>
<%
				}
			}
			else if (displayControl.equalsIgnoreCase("textarea"))
			{
				String temp = paramValue;
				String strVal = null;
				if (testName.equals(previousTestName))
				{
					strVal = request.getParameter(paramName);
				}
				paramValue = (strVal==null)?temp:strVal;

				if (paramValue.indexOf(EgConstants.PIPE) > -1)
				{
					paramValue = StringUtils.replace(paramValue, EgConstants.PIPE, EgConstants.COMMA);
				}

				boolean isAgentInstalledAndRunning = false;
				if((paramName.equalsIgnoreCase("serviceName") 
					|| paramName.equalsIgnoreCase("process")) 
					&& !agentInfo.isAgentlessServer(componentNickName,componentType) 
					&& isAgentReporting(componentNickName))
				{
					com.eg.EgServerList serverList = new com.eg.EgServerList();
					ArrayList aList_A = new ArrayList();
					aList_A.add((String)listAgents.get(0));
					ArrayList aList_B = serverList.getAgentList(aList_A);
					if (aList_B != null && !aList_B.isEmpty())
					{
						String agentStatus = (String)aList_B.get(1);
						if (agentStatus.equalsIgnoreCase("Installed-Running"))
						{
							isAgentInstalledAndRunning = true;
						}
					}
				}

				if(paramName.equalsIgnoreCase("serviceName") 
					&& !agentInfo.isAgentlessServer(componentNickName,componentType) 
					&& isAgentInstalledAndRunning)
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
					}
					if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
					}
					session.setAttribute("paramValue",paramValue);
					session.removeAttribute("winServicesList");
%>
								<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td valign="top"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="28"><%=paramValue%></textarea></td>
											<td nowrap>
												&nbsp;&nbsp;<input class="eg_back" type="button" name="selbutton" value='<egui:intnl text="admin.common.View"/>/<egui:intnl text="admin.common.Configure"/>' onclick="windows_services_popup('dummy')">
											</td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
				}
				else if(paramName.equalsIgnoreCase("process") 
					&& !agentInfo.isAgentlessServer(componentNickName,componentType) 
					&& isAgentInstalledAndRunning)
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
					}
					session.removeAttribute("keyList");
					session.removeAttribute("valueList");
					session.removeAttribute("now");
					session.setAttribute("paramValue",paramValue);
%>
								<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td valign="top"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="35"><%=paramValue%></textarea></td>
											<td nowrap> &nbsp;&nbsp;<input class="eg_back" type="button" name="selbutton" value='<egui:intnl text="admin.common.View"/>/<egui:intnl text="admin.common.Configure"/>' onclick="process_popup('dummy')">
											</td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
							<input type='hidden' name='hiddenvalues' value='<%=response.encodeURL(paramValue)%>'>
<%
				}
				else if(paramName.equalsIgnoreCase("exclude") || 
					paramName.equalsIgnoreCase("serviceName") || 
					paramName.equalsIgnoreCase("process") || 
					paramName.equalsIgnoreCase("searchPattern"))
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
					}
					if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
					}
%>
								<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td valign="top"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="28"><%=paramValue%></textarea></td>
											<td nowrap>
												&nbsp;&nbsp;<input type="button" name ="viewurl" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;">
											</td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
				}
				else
				{
%>
								<td height="30" id="formtop_border" class="eg_subcontent"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="35"><%=paramValue%></textarea></td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
				}
			}
			else //text
			{
				if (isSnmp || isPolicyParamExists || isCorrectParamExist || isUrlParamExist || isWsdlUrlExist || paramName.equalsIgnoreCase("real_ServerName"))
				{
					String temp = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?temp:strVal;
				}

				if(paramName.equalsIgnoreCase("correctivescript"))
				{
					if(paramValue.indexOf("#") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"#",",");
					}
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
%>
							<td height="30" id="formtop_border" colspan="2">
								<table border="0" cellspacing="0" cellpadding="0">
									<tr>
										<td>
											<table border="0" cellpadding="0" cellspacing="0">
												<tr>
													<td valign="middle">
														<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;<input type="button" value="Choose" class="eg_lightbutton" onclick = 'Javascript:openwindow1()'>&nbsp;&nbsp;<input type="button" value="Clear" class="eg_lightbutton" onclick='Javascript:clearFun("<%=paramName%>")'>
													</td>
													<td><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
<%
					}
					else
					{

%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;<input type="button" value="Choose" class="eg_lightbutton" onclick = 'Javascript:openwindow1()'>&nbsp;&nbsp;<input type="button" value="Clear" class="eg_lightbutton" onclick='Javascript:clearFun("<%=paramName%>")'></td>
								<td id="formtop_border">
								&nbsp;</td>
<%
					}
%>
							</tr>
<%
				}
				else if (paramName.equalsIgnoreCase("management_user"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged == null)
					{
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
%>
							<td height="30" id="formtop_border" colspan="2">
								<table border="0" cellspacing="0" cellpadding="0">
									<tr>
										<td id="formtop_border">
											<table border="0" cellpadding="0" cellspacing="0">
												<tr>
													<td valign="middle">
														<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
													</td>
													<td><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
<%
						}
						else
						{
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>"></td>
								<td id="formtop_border">
								&nbsp;</td>
<%
						}
%>
							</tr>
<%
					}
					else
					{
						String tempUser = (String)request.getAttribute("management_user");
						if (tempUser != null)
						{
							paramValue = tempUser;
						}
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
%>
							<td height="30" id="formtop_border" colspan="2">
								<table border="0" cellspacing="0" cellpadding="0">
									<tr>
										<td>
											<table border="0" cellpadding="0" cellspacing="0">
												<tr>
													<td valign="middle">
														<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
													</td>
													<td><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></td>
												</tr>
											</table>
										</td>
									</tr>
								</table
							</td>
<%
						}
						else
						{
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>"></td>
								<td id="formtop_border">
								&nbsp;</td>
<%
						}
%>
							</tr>
<%
					}
				}
				else if(paramName.equalsIgnoreCase("url"))
				{
					if (isCredentialParamExist)
					{
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							paramValue = paramValue.trim();
							if (paramValue.indexOf("|") > -1)
							{
								String decodedUrl = "";
								StringTokenizer st12 = new StringTokenizer(paramValue,"|");
								String tempUrl = "";
								while (st12.hasMoreTokens())
								{
									tempUrl = st12.nextToken();
									if (tempUrl.indexOf("?") > -1)
									{
										int urlIndex = tempUrl.indexOf("?");
										tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLDecoder.decode(tempUrl.substring(urlIndex + 1));
									}
									if (decodedUrl != null && !decodedUrl.equals(""))
									{
										decodedUrl = decodedUrl + "|" + tempUrl;
									}
									else
									{
										decodedUrl = tempUrl;
									}
								}
								paramValue = decodedUrl;
							}
							else
							{
								if (paramValue.indexOf("?") > -1)
								{
									int vecValIndex = paramValue.indexOf("?");
									paramValue = paramValue.substring(0, vecValIndex) + "?" + URLDecoder.decode(paramValue.substring(vecValIndex + 1));
								}
							}
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
%>
								<td id="formtop_border">
									<table cellpadding="0" cellspacing="0" border="0">
										<tr>
											<td><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" onblur="javascript:checkURLAndCredentials('<%=paramValue%>');"></td>
											<td valign="middle" align="center">&nbsp;&nbsp;<img src="/final/admin/eg_images/plus.gif" title="Click here to view/configure URL and credentials" class="leftmouse" onClick="config_popup('./EgConfigureUrlAndCredentials.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(componentName),"UTF-8")%>&isPrivateKeyParamExist=<%=isPrivateKeyParamExist%>','','scrollbars=yes,width=900,height=500,top=150,left=50')"></td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
<%
					}
					else
					{
						if (paramValue.trim().indexOf("?") > -1)
						{
							int vecValIndex = paramValue.indexOf("?");
							paramValue = paramValue.substring(0, vecValIndex) + "?" + URLDecoder.decode(paramValue.substring(vecValIndex + 1));
						}
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
%>
								<td height="30" id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle">
															<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;<input type="button" name ="viewurl" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= paramName %>')" style="width:60px;">
														</td>
														<td><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
<%
						}
						else
						{
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;<input type="button" name ="viewurl" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= paramName %>')" style="width:60px;"></td>
								<td id="formtop_border">
								&nbsp;</td>
<%
						}
					}
%>
							</tr>
<%
				}
				else if(paramName.equalsIgnoreCase("WSDL_URL"))
				{
					if (!isXDMGetDevicesInfo)
					{
						paramsForValidationURL = "test="+EgURLEncoder.encode(testName,"UTF-8")+"&action=pickAgentToValidate&taskName=WebServiceValidity"+"&compName="+EgURLEncoder.encode(componentName,"UTF-8")+"&componentType="+componentType+"&configurationType=specificConfiguration"+"&allowHostName="+isAllowHostName;
						requiredParamNames = requiredParamNames+",passwordconfirmpassword";
						updateWebServiceIniFile(previousUrl,componentName);
						paramsForValidationURL = paramsForValidationURL+"&xenMobileUserName="+""+"&xenMobilePassword="+"";
					}

					if (isCredentialParamExist)
					{
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
%>
								<td id="formtop_border">
									<table cellpadding="0" cellspacing="0" border="0">
										<tr>
											<td><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" onblur="javascript:checkURLAndCredentials('<%=paramValue%>');">
											</td>
											<td valign="middle" align="center">&nbsp;&nbsp;<img src="/final/admin/eg_images/plus.gif" title="Click here to view/configure URL and credentials" class="leftmouse" onClick="config_popup('./EgConfigureWsdlUrlAndCredentials.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(componentName),"UTF-8")%>','','scrollbars=yes,width=900,height=500,top=150,left=50')"></td>
											<td id="formtop_border">&nbsp;</td>
											<td><input class="eg_back" type="button" id="validateForWsdl" name="validateForWsdl" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationUrlForWebservice%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></td>
										</tr>
									</table>
								</td>
								
<%
					}
					else
					{
						paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						if (isXDMGetDevicesInfo)
						{
%>
								<td height="30" id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle">
															<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
<%
						}
						else
						{
							if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
							{
%>
								<td height="30" id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle">
															<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;
														</td>
														<td><input class="eg_back" type="button" id="validateForWsdl" name="validateForWsdl" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationUrlForWebservice%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
<%
							}
						}
					}
				}
				else if(paramName.equalsIgnoreCase("Operations"))
				{
%>					<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
						<table cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td valign="top"><textarea rows="5" cols="40" name="<%=paramName%>" id="<%=paramName%>"><%=paramValue%></textarea></td>
								<td nowrap> &nbsp;&nbsp;<input type="button" class="eg_back" value='<egui:intnl text="admin.common.Add Operation"/>' id="configureForWsdl" name="configureForWsdl" onClick="javascript:openWebServiceDiv('<%=componentName%>');" style="width:120px;">
								</td>
							</tr>
						</table>
					</td>
<%				}
				else if(paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
				{
					String tempTargetDiskIORate = "";
					String tempTargetDiskIORateValue = "";

					if (paramValue.equalsIgnoreCase("$unconfigured"))
					{
						tempTargetDiskIORateValue = paramValue;
					}
					else
					{
						tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
						tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());
						paramValue = tempTargetDiskIORateValue;
					}
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
%>
								<td id="formtop_border">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle">
															<select name="TargetDiskIORate_select" id ="TargetDiskIORate_select" style="width:180px" >&nbsp;
	<%
						for (int k=0;k<targetDiskIORateLabel.length;k++)
						{
							String strTargetDiskIORateLabel = targetDiskIORateLabel[k];
							String strTargetDiskIORateValue = targetDiskIORateValue[k];
							if (strTargetDiskIORateValue.equalsIgnoreCase(tempTargetDiskIORate))
							{
	%>
																<option value="<%=strTargetDiskIORateValue%>" selected><%=strTargetDiskIORateLabel%></option>
	<%
							}
							else
							{
	%>
																<option value="<%=strTargetDiskIORateValue%>"><%=strTargetDiskIORateLabel%></option>
	<%
							}
						}
	%>
															</select>
															<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
														</td>
														<td valign="middle"><input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
<%
					}
					else
					{
%>
								<td id="formtop_border">
									<select name="TargetDiskIORate_select" id ="TargetDiskIORate_select" style="width:180px" >&nbsp;
<%
						for (int k=0;k<targetDiskIORateLabel.length;k++)
						{
							String strTargetDiskIORateLabel = targetDiskIORateLabel[k];
							String strTargetDiskIORateValue = targetDiskIORateValue[k];
							if (strTargetDiskIORateValue.equalsIgnoreCase(tempTargetDiskIORate))
							{
%>
								<option value="<%=strTargetDiskIORateValue%>" selected><%=strTargetDiskIORateLabel%></option>
<%
							}
							else
							{
%>
								<option value="<%=strTargetDiskIORateValue%>"><%=strTargetDiskIORateLabel%></option>
<%
							}
						}
%>
									</select>
									<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
								</td>
								<td id="formtop_border">
								&nbsp;</td>
<%
					}
%>
							</tr>
<%
				}
				else if (testName.equalsIgnoreCase("WindowshareTest") && 
					paramName.equalsIgnoreCase("sharename"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
%>
								<td id="formtop_border"><a href = "javascript:void(0)" onClick="config_popup('./EgConfigureWinSharedFolders.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(componentName),"UTF-8")%>','','scrollbars=yes,width=900,height=500,top=150,left=50')" class="eg_monlink"><egui:intnl text="admin.test.To view/configure shared folders for monitoring"/>,&nbsp;<b><egui:intnl text="admin.common.click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=paramValue%>'>
<%
				}
				else
				{
					//for remote based monitoring continuing the process parameters
					if (remProcessParamIdx > -1 && isRemote) continue;

					String destinationPage = "";
					String plusButton = "";
					String onBlurStr  = "";
					String onFocusStr = "";
					String onChangeStr = "";

					if (multiUserMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleUsers)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("user"))
						{
							destinationPage = "EgConfigureMultipleUsers.jsp";
						}
						else
						{
							destinationPage = "VmgUsers.jsp";
						}
						if (paramName.equalsIgnoreCase("admin_user") || paramName.equalsIgnoreCase("user"))
						{
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";

						}
						onBlurStr =  "javascript:checkMultipleUser('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getUserValue('"+paramName+"')"; 
						onChangeStr = "javascript:getUserChangedValue('"+paramName+"')";
					}

					if (multiNamePatternMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleNames)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("name"))
						{
							destinationPage = "EgConfigureNamePattern.jsp";
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure url pattern(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";
						}
						onBlurStr =  "javascript:checkMultipleNamePattern('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getNamePatternValue('"+paramName+"')"; 
						onChangeStr = "javascript:getNamePatternChangedValue('"+paramName+"')";
					}

					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramValue.indexOf("~#~") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"~#~",";");
					}

					if (multiUserMode || multiNamePatternMode)
					{
						if (readOnlyParamIdx > -1)
						{
%>
								<td id="formtop_border">
									<table cellpadding="0" cellspacing="0" border="0">
										<tr>
											<td><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>"<%=readOnly%> onblur="<%=onBlurStr%>" onfocus="<%=onFocusStr%>" onchange="<%=onChangeStr%>"></td>
											<td valign="middle">
												&nbsp;<%=plusButton%>
											</td>
										</tr>
									</table>
								</td>
<%
						}
						else
						{
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" <%=readOnly%>>
<%
							if (paramValue.length() > 20 && readOnly.equals(""))
							{
%>
								&nbsp;<input type="button" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;">
<%
							}
						}
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
%>
								&nbsp;<input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','false','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);">
<%
						}
%>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else
					{
						if (paramValue.indexOf(EgConstants.PIPE) > -1)
						{
							paramValue = StringUtils.replace(paramValue, EgConstants.PIPE, EgConstants.COMMA);
						}
						else if ((testName.equalsIgnoreCase("ProcessTest") || testName.equalsIgnoreCase("AppProcessTest")) && 
								paramName.equalsIgnoreCase("user") && 
								paramValue.indexOf("#") != -1)
						{
							paramValue = StringUtils.replace(paramValue,"#",",");
						}

						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
%>
								<td id="formtop_border" align="left" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" <%=readOnly%>>
												&nbsp;<%=descriptorButton%>
<%
							if (paramValue.length() > 20 && readOnly.equals(""))
							{
%>
												&nbsp;<input type="button" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;">
<%
							}
%>
											</td>
											<td>
												<input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','<%=removeNull(componentName)%>');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','<%=componentType%>','<%=testName%>','<%=multiUserMode%>','<%=isAllowHostName%>','<%=requiredParamNames%>','testConfig',event);">
											</td>
										</tr>
									</table>
								</td>
<%
						}
						else if(paramName.equals("device_id"))
						{
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" readOnly style="width:350px;">
								</td>
								<td id="formtop_border">&nbsp;</td>
<%
						}
						else
						{
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" <%=readOnly%>>
						&nbsp;<%=descriptorButton%>
<%
						if (paramValue.length() > 20 && readOnly.equals(""))
						{
%>
								&nbsp;<input type="button" class="eg_back" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;">
<%
						}
%>
								</td>
								<td id="formtop_border">&nbsp;</td>
<%
						}
%>
							</tr>
<%
					}
				}
			}
		}

		if (allowDetailedDiagnosis)
		{
%>
							<tr>
								<td id="formtop_border">&nbsp;</td>
								<td id="formtop_border"><egui:intnl text="admin.test.DETAILED DIAGNOSIS"/></td>
								<td id="formtop_border">:</td></td>
<%
			if (isTestDetailedDiagnosisDisabledGlobally)
			{
%>
								<td id="formtop_border" class="eg_subcontent"><b><egui:intnl text="admin.common.Off"/></b></td>
								<input type="hidden" name="detaileddiagnosis" id="detaileddiagnosis" value="Off"/>
<%
			}
			else
			{
%>
								<td id="formtop_border">
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td valign="middle"><input type="radio"class="eg_input" name="detaileddiagnosis" id="detaileddiagnosis" value="On" <%=detailedDiagnosisOn%>></td>
											<td valign="middle">&nbsp;<egui:intnl text="admin.common.On"/></td>
											<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
											<td valign="middle"><input type="radio" class="eg_input"name="detaileddiagnosis" id="detaileddiagnosis" value="Off" <%=detailedDiagnosisOff%>></td>
											<td valign="middle">&nbsp;<egui:intnl text="admin.common.Off"/></td>
										</tr>
									</table>
								</td>
<%
			}
%>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
		}

		//apply to other components - starts
		if (aListConfigureComponentsClone != null && aListConfigureComponentsClone.size() > 0)
		{
%>
							<tr>
								<td id="formtop_border">&nbsp;</td>
								<td width="210" id="formtop_border" class="eg_subcontent" nowrap><egui:intnl text="admin.test.APPLY TO OTHER COMPONENTS"/></td>
								<td width="20" id="formtop_border" class="eg_subcontent" height="22">:</td>
								<td align="left" id="formtop_border" class="eg_subcontent"><input type="checkbox" class="eg_input" name="applyAll" id="applyAll"/></td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
		}
		//apply to other components - ends
%>

							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg" colspan="3" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="5" id="eg_blankspace" height="10" class="eg_whitebg">&nbsp;</td>
							</tr>
							<tr>
								<input type="hidden" name="testChoosenToConfigure" value="<%=testName%>">
								<input type="hidden" name="allowedParams" value="<%=allowedParams%>">
								<input type="hidden" name="strTcKeywords" value="<%=strTcKeywords%>">
								<input type="hidden" name="strDoubleQuotesParams" value="<%=strDoubleQuotesParams%>">
								<td colspan="5" align="center" id="eg_whitebg"><input type="button" name="updatebutton" value='<egui:intnl text="admin.common.Update"/>' onclick="javascript:populate('<%=testName%>','specificConfiguration','<%=multiUserMode%>','<%=isAllowHostName%>')" name="update" class="eg_back">
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td>&nbsp;</td>
	</tr>
<%
		session.setAttribute("aListParamNamesValues",aListParamNamesValues);
		session.setAttribute("aListDisplay",aListDisplay);
		session.setAttribute("specialCharactersAllowedParameter",allowedParams);
		session.setAttribute("tcKeywords",tcKeywords);
		session.setAttribute("aListPasswordParameters",aListPasswordParameters);
		session.setAttribute("aListDefaultPasswordParameters",aListDefaultPasswordParameters);
		session.setAttribute("aListParamsWithDoubleQuotes",aListParamsWithDoubleQuotes);
		session.setAttribute("isOldSnmp",new Boolean(isOldSnmp));
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigureComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8"));

	//used for help page support.when data.jsp is clicked
	aListPages.add("/final/admin/EgConfigureComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8"));
	if (aListPages.size() > 2)
	{
		aListPages.remove(0);
	}
	session.setAttribute("aListPages",aListPages);
%>
</table>
<iframe id="iframe1" name="iframe1" frameborder="0" style="background-color:transprent;display:none;position:absolute;z-index:10"></iframe>
<input type="hidden" id="componentcredentialsneededtodovalidation" name="componentcredentialsneededtodovalidation" value="<%=componentCredentialsNeededToDoValidation%>">
<input type="hidden" name="testName" value="<%=testName%>">
<input type="hidden" name="TestsForExclusion" value="">
<input type="hidden" name="excludingState" value="">
<input type="hidden" name="TestsForInclusion" value="">
<input type="hidden" name="moreurl" value="">
<input type="hidden" name="urls" value="">
<input type="hidden" name="previousTestName" value="<%=testName%>">
<input type="hidden" name="isCredentialParamExist" value="<%=isCredentialParamExist%>">
<input type="hidden" name="showPopup" value="">
<input type="hidden" name="delimiter" value="<%=strDelimiter%>">
<input type="hidden" name="delimiterMask" value="<%=strDelimiterMask%>">
</form>
</body>
</html>

<%!
	boolean isAgentReporting(String nick)
	{
		if(EgInstallInfo.isClusterSupported)
		{
			com.eg.EgManagersIniForManager mi = com.eg.EgManagersIniForManager.getInstance();
			Vector reportingAgentIPs= mi.getReportingAgentsFor(mi.getManagerIP());
			if(reportingAgentIPs != null && reportingAgentIPs.size() > 0)
			{
				EgDiscInfo discInfo = new EgDiscInfo("manager");
				Hashtable nickIpMap = discInfo.getNickIpMap();
				if(nickIpMap != null && nickIpMap.size()>0)
				{
					String agentIP =(String) nickIpMap.get(nick);
					if(!StringUtils.isNull(agentIP) && reportingAgentIPs.contains(agentIP))
					{
						return true;
					}
				}
			}
			return false;
		}
		else
			return true;
	}

	public void updateWebServiceIniFile(String previousUrl , String componentName)
	{
		String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_webservices.ini";
		IniFile webServiceIni  = EgConfigFilesSync.getInstance(iniFileName,true);
		if(previousUrl.indexOf("$unconfigured")>-1)
		{
			String ConfigVariables[] = webServiceIni.getVariables("CONFIGURED_OPERATIONS");
			if(ConfigVariables!=null && ConfigVariables.length >0)
			{
				for(int v=0;v<ConfigVariables.length;v++)
				{
					String variable = (String)ConfigVariables[v];
					String varComp = variable.substring(0,variable.lastIndexOf(":"));
					if(varComp.trim().equals(componentName.trim()))
					{
						String deleteValue = webServiceIni.getValue("CONFIGURED_OPERATIONS",variable);
						webServiceIni.deleteValue("CONFIGURED_OPERATIONS",variable);
						
						StringTokenizer del = new StringTokenizer(deleteValue,",");
						while(del.hasMoreTokens())
						{
							String token = (String)del.nextToken();
							String todelete = variable+":"+token;
							webServiceIni.deleteValue("CONFIGURED_SOAP_REQUEST",todelete);
						}
					}
				}
				webServiceIni.saveFile();
			}
			String associatedVariables[] = webServiceIni.getVariables("ASSOCIATED_OPERATIONS");
			if(associatedVariables!=null && associatedVariables.length >0)
			{
				for(int v=0;v<associatedVariables.length;v++)
				{
					String variable = (String)associatedVariables[v];
					String varComp = variable.substring(0,variable.lastIndexOf(":"));
					if(varComp.trim().equals(componentName.trim()))
					{
						String deleteValue = webServiceIni.getValue("ASSOCIATED_OPERATIONS",variable);
						webServiceIni.deleteValue("ASSOCIATED_OPERATIONS",variable);
						
						StringTokenizer del = new StringTokenizer(deleteValue,",");
						while(del.hasMoreTokens())
						{
							String token = (String)del.nextToken();
							String todelete = variable+":"+token;
							webServiceIni.deleteValue("ASSOCIATED_SOAP_REQUEST",todelete);
						}
					}
				}
				webServiceIni.saveFile();
			}
		}
		webServiceIni.saveFile();
		EgConfigFilesSync.releaseInstance(webServiceIni);
	}
%>



