<%
/**
 *	Name			:		EgConfigTestp.jsp
 *	Purpose			:		Configure Test Topology
 *	Version			:		0.1
 *	CreationDate	:		28/09/2000
 *	Last Modified	:		
 *			22/06/2004	Arun		Weblogic tests have	use	a "server" parameter which is also used	by 
 *									the	JSP	to send	the	server type. Change	the	query parameter	to 
 *									typeOfServer to	remove ambiguity.
 *
 *			30/08/2001 //sandhya - to stop discovery before	deleting from eg_agents.ini	
 *									and	to start discovery after deleting from eg_agents.ini.
 *			06/06/2001 //Bala IniFile save 
 *			21/03/2001 //Sandhya.K - To	delete tests from eg_agents.ini	
 *			28/09/2000	// Sandhya.K 
 *	Author			:		Sridevi.T
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="sBean"	scope="page" class="egurkha.ServiceBean"/>

<%
	String serverName = request.getParameter("server");
	String testName = request.getParameter("t_name");
	String strTok = "";
	String componentsForExclusion =	request.getParameter("ComponentsForExclusion");
	boolean isExternalTest = egSpecs.isExternalTest(testName,serverName);

	prgBean.createFile("eg_services.ini");
	String strSubject = "NOPORT_SERVERS";
	String strVariables[] = prgBean.getVariables(strSubject);
	listNoPortServers = Arrays.asList(strVariables);

	//to add a test	whose server+hostname is excluded in eg_disable.ini
	//prgBean.createFile("eg_disable.ini","save");
	prgBean.createSyncFile("eg_disable.ini","save");
	String subTestParam = "Default_server";
	StringTokenizer	st = new StringTokenizer(componentsForExclusion,",");
	while (st.hasMoreTokens())
	{
		String str_host_name = (st.nextToken()).trim();
		if ((str_host_name.equals("")) || (str_host_name.equals(" ")))
			continue;

		String stringTemp =	subTestParam + ":" + str_host_name;

		/* to write into eg_disable.ini*/
		//if server exist then append testname to the existing server
		String strVal = prgBean.getStrValue(subTestParam,stringTemp);
		if (strVal.equals(testName)
			|| (strVal.startsWith(testName+",")) 
			|| (strVal.endsWith(","+testName)) 
			|| (strVal.indexOf(","+testName+",")>0))
			continue;

		if(strVal.length() > 0)
		{
			prgBean.setValues(subTestParam,stringTemp,strVal+","+testName);
		}
		else
		{
			prgBean.setValues(subTestParam,stringTemp,testName);
		}
	}
	prgBean.saveFile();
	prgBean.releaseInstance();

	/* to remove tests with no port numbers from eg_agents.ini */
	//prgBean.createFile("eg_agents.ini","save");

	/* to stop discovery before deleting from eg_agents.ini*/
	sBean.stopDiscovery();

	prgBean.createSyncFile("eg_agents.ini","save");
	st = new StringTokenizer(componentsForExclusion,",");
	while (st.hasMoreTokens())
	{
		String str_host_name = (st.nextToken()).trim();
		if ((str_host_name.equals("")) || (str_host_name.equals(" "))) continue;

		List aListAgents = getAgents(str_host_name);
		List aListTempAgents = null;
		if (isExternalTest)
		{
			aListTempAgents = aListAgents.subList(1,aListAgents.size());
		}
		else
		{
			aListTempAgents = aListAgents.subList(0,1);
		}

		for(int i=0; i<aListTempAgents.size(); i++)
		{
			String tempAgentName = (String)aListTempAgents.get(i);
			String iniVars[] = prgBean.getVariables(tempAgentName);
			ArrayList aListSearchPatterns = getSearchPatterns(serverName,str_host_name,testName);
			List listIniVars = Arrays.asList(iniVars);

			for (int d=0;d<aListSearchPatterns.size();d=d+2)
			{
				String resultantPattern = "";
				if (listIniVars.contains((String)aListSearchPatterns.get(d)))
				{
					resultantPattern = (String)aListSearchPatterns.get(d);
				}
				else if (listIniVars.contains((String)aListSearchPatterns.get(d+1)))
				{
					resultantPattern = (String)aListSearchPatterns.get(d+1);
				}

				if (resultantPattern.equals("")) continue;

				prgBean.deleteValues(tempAgentName,resultantPattern);
			}
		}
	}
	prgBean.saveFile();
	prgBean.releaseInstance();

	/* to start discovery after deleting from eg_agents.ini */
	String step = "1";
	sBean.startDiscovery(step, true);

	testName = request.getParameter("t_name");
	String ur = "EgConfigTest.jsp?t_name="+testName+"&qctr=0&rctr=0&typeOfServer=" + serverName;

	/* code for auditlog starts*/
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Tests");
	auditLogThread.setValue("Activity","Configure Test");
	
	if(testName.endsWith("_ex"))
		auditLogThread.setCurrentValue("Test Name",testName);
	else
		auditLogThread.setCurrentValue("Test Name","$test$:"+testName);

	if(serverName.endsWith("_ex"))
		auditLogThread.setCurrentValue("Component Type",serverName);
	else
		auditLogThread.setCurrentValue("Component Type","$ctype$:"+serverName);

	String hostNames = request.getParameter("componentsForExclusion");
	String hostNamesArray[] = null;
	if(hostNames != null && !hostNames.equals("null"))
	{
		StringTokenizer tokens = new StringTokenizer(hostNames,",");
		while(tokens.hasMoreTokens())
		{
			String token = tokens.nextToken().toString();
			int	index = token.indexOf(":");
			if(index != -1)
				auditLogThread.setCurrentValue("Excluded Component(s)",token.substring(0,index));
			else
				auditLogThread.setCurrentValue("Excluded Component(s)",token);
		}
	}
	auditLogThread.setValue("Description","Component(s)	have been excluded from	test configuration");
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
%>

<jsp:forward page="<%=ur%>"	/>

<%!

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	List listNoPortServers = null;

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String tempCompName = new String(componentName);
		String agentNickName = "";

		boolean isRemote = false;
		if (tempCompName.indexOf(":") > -1)
		{
			tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
		}

		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(tempCompName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(tempCompName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(tempCompName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = tempCompName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(tempCompName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(tempCompName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	private ArrayList getSearchPatterns(String componentType,String compName,String testName)
	{
		ArrayList aListSearchPatterns = new ArrayList();

		String tempComponentName = new String(compName);
		testName = testName.trim();
		if (tempComponentName.indexOf(":") > -1)
		{
			tempComponentName = tempComponentName.substring(0,tempComponentName.indexOf(":"));
		}

		ArrayList aListPorts = egDiscInfo.getPort(componentType,tempComponentName);
		boolean isDoneWithDefaultPattern = false;
		boolean b_isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);

		String specificPattern = testName + ":" + componentType + ":";
		if (compName.indexOf(":") == -1)
		{
			if (listNoPortServers.contains(componentType))
			{
				String defaultPattern = testName + "::";
				if (b_isPortRelevantForTest)
				{
					specificPattern = specificPattern + compName + ":NULL";
				}
				else
				{
					specificPattern = specificPattern + compName;
				}

				aListSearchPatterns.add(specificPattern);
			}
			else
			{
				isDoneWithDefaultPattern = true;
				for (int i=0;i<aListPorts.size();i++)
				{
					String strPort = (String)aListPorts.get(i);
					String tempSpecificPattern = specificPattern + compName + ":" + strPort;

					aListSearchPatterns.add(tempSpecificPattern);

					String tempDefaultPattern = testName + "::";
					if (b_isPortRelevantForTest)
					{
						tempDefaultPattern = tempDefaultPattern + compName + ":" + strPort;
					}
					else
					{
						tempDefaultPattern = tempDefaultPattern + compName;
					}

					aListSearchPatterns.add(tempDefaultPattern);
				}
			}
		}
		else
		{
			specificPattern = specificPattern + compName;
			aListSearchPatterns.add(specificPattern);
		}

		String defaultPattern = testName + "::";
		if (!isDoneWithDefaultPattern)
		{
			if (b_isPortRelevantForTest)
			{
				defaultPattern = defaultPattern + compName;
			}
			else
			{
				if (compName.indexOf(":") == -1)
				{
					defaultPattern = defaultPattern + compName;
				}
				else
				{
					defaultPattern = defaultPattern + compName.substring(0,compName.indexOf(":"));
				}
			}
			aListSearchPatterns.add(defaultPattern);
		}

		return aListSearchPatterns;
	}

%>



