<%
/*******************************************************************************
*	Name				:	EgConfigLogoMsg.jsp
*	Purpose				:	This jsp is used to configure custom logo and messages.
*	Version				:	eG 3.0
*	CreationDate		:	20/07/2001
*	LastModified		:	11/08/2001	Sandhya		To allow '@' in configure messages
*							26/11/2003	Williams	Changed the layout
*							08/12/2003	Arun		Path for custom images reflects the true path of 
*													the manager. Radio buttons are set according to
*													the selected choices and do not remain unchecked
*													even after updating.
*							11/12/2003	Arun		Included a text field for customising caption display
*							01/07/2004	Arun		Included field for customising logos for Reporter. 
*													Code modified to use IniUI instead of EgBackgroundSetting.
*							03/02/2005	Pandian		Included field for customising audible alerts for Alarm Widow. 
*														
*	Author				:	John Williams & Sandhya Kollath
*	Design Changes		:	Jaiwin
*******************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="java.io.*" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	boolean isDouble=EgDbInfo.doubleByteEnabled;
%>

<jsp:useBean id="configmsg" scope="page" class="egurkha.TransactionBean" />

<%

	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	boolean hasMonitorTab = userRole.hasAnyMonitorRole(EgUserPermission.MONITOR);
	boolean hasReporterTab = userRole.hasAnyReporterRole(EgUserPermission.REPORTER);
	boolean hasConfigTab = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

	String process = request.getParameter("process");
	process = (process == null ?"" :process);
	String from = request.getParameter("from");
	from = (from == null ? "" : from);
	configmsg.createFile("eg_ui.ini");

	String loginImageUploadStatus = "NotUploaded";
	String loginCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_LOGIN_LOGO");
	File loginCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/admin/eg_images/"+loginCustomGifFileName);
	//if (loginCustomGifFile != null && loginCustomGifFile.exists())
	//{
	//	loginImageUploadStatus = "Uploaded";
	//}

	String monitorImageUploadStatus = "NotUploaded";
	String monitorCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_MONITOR_LOGO");
	File monitorCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/monitor/eg_images/"+monitorCustomGifFileName);
	//if (monitorCustomGifFile != null && monitorCustomGifFile.exists())
	//{
	//	monitorImageUploadStatus = "Uploaded";
	//}

	String audibleAlertUploadStatus = "NotUploaded";
	File audibleAlertSoundFiles = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/monitor/eg_waves");
	String[] listOfSoundFiles = audibleAlertSoundFiles.list();
	for (int i=0; i<listOfSoundFiles.length; i++)
	{
		if(listOfSoundFiles[i].startsWith("custom-"))
		{
			audibleAlertUploadStatus = "Uploaded";
			break;
		}
	}

	String reporterImageUploadStatus = "NotUploaded";
	if (EgInstallInfo.isReporterSupported)
	{
		String reporterCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_REPORTER_LOGO");
		File reporterCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/reporter/images/"+reporterCustomGifFileName);
		//if (reporterCustomGifFile != null && reporterCustomGifFile.exists())
		//{
		//	reporterImageUploadStatus = "Uploaded";
		//}
	}

	String configMgmtImageUploadStatus = "NotUploaded";
	if (EgInstallInfo.isConfigSupported)
	{
		String configMgmtCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_CONFIG_LOGO");
		File configMgmtCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/config/images/"+configMgmtCustomGifFileName);
		//if (configMgmtCustomGifFile != null && configMgmtCustomGifFile.exists())
		//{
		//	configMgmtImageUploadStatus = "Uploaded";
		//}
	}
	/*-----------This code for single and double byte language support------start-------*/
	String tableWidth="";
	if(trackerLanguage!=null && (trackerLanguage.equals("en_US") || trackerLanguage.equals("ch_CH") || trackerLanguage.equals("ja_JP") || trackerLanguage.equals("ko_KR") || trackerLanguage.equals("th_TH")))
	{
		tableWidth="95%";
	}
	else if(trackerLanguage!=null && (trackerLanguage.equals("fr_FR") || trackerLanguage.equals("de_DE") || trackerLanguage.equals("es_ES") || trackerLanguage.equals("it_IT") || trackerLanguage.equals("pt_BR")))
	{
		tableWidth="97%";
	}
	/*-----------This code for single and double byte language support-----End--------*/
%>

<html>
<head>
<title>Configure logos and messages</title>
<egui:skin ui="admin"/>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2" src="/final/scripts/screen_display.js"></script>
<script language="JavaScript">

function call()
{
	window.location.href = "./EgAdminOperations.jsp";
}

function openUploadWin(url)
{
	if('<%=hasMonitorTab%>'== 'true' && '<%=hasReporterTab%>'=='true' && '<%=hasConfigTab%>'=='true')
	{
		uploadWin = window.open(url,"LogoFileUpload","width=525,height=215,scrollbars=no,resizable=yes");
	}
	else
	{
		uploadWin = window.open(url,"LogoFileUpload","width=450,height=160,scrollbars=no,resizable=yes");
	}
	uploadWin.focus();
}

function valform(str)
{
	var res = false;
	var strValue = str;
	var thisForm = document.logomsg;
	if(strValue == "" || strValue =="loginscreen")
	{
		var loginImageStatus = document.getElementById("loginImageStatus").value;
		if(document.logomsg.loginlogo[0].checked && loginImageStatus == "NotUploaded")
		{
			alert('<egui:intnl text="admin.logo.Please upload custom logo for login screen"/>');
			res="false";
			return;
		}
		else
		{
			res=true;
		}
	}
	if(strValue == "" || strValue =="monitorinterface")
	{
		var monitorImageStatus = document.getElementById("monitorImageStatus").value;
		if (document.logomsg.monitorlogo[0].checked && monitorImageStatus == "NotUploaded")
		{
			alert('<egui:intnl text="admin.logo.Please upload custom logo for monitor interface"/>');
			res="false";
			return;
		}
		else
		{
			res=true;
		}
	}
	if(strValue == "" || strValue =="reporterinterface")
	{
		var isReporterSupported = '<%=EgInstallInfo.isReporterSupported%>';
		var reporterImageStatus = "NotUploaded";
		if (isReporterSupported == "true")
		{
			reporterImageStatus = document.getElementById("reporterImageStatus").value;
		}
		if (isReporterSupported == "true" && document.logomsg.reporterlogo[0].checked && reporterImageStatus == "NotUploaded")
		{
			alert('<egui:intnl text="admin.logo.Please upload custom logo for reporter interface"/>');
			res="false";
			return;
		}
		else
		{
			res=true;
		}
	}
	if(strValue == "" || strValue =="configmanageinterface")
	{
		var isConfigMgmtSupported = '<%=EgInstallInfo.isConfigSupported%>';
		var configMgmtImageStatus = "NotUploaded";
		if (isConfigMgmtSupported == "true")
		{
			configMgmtImageStatus = document.getElementById("configMgmtImageStatus").value;
		}
		if (isConfigMgmtSupported == "true" && document.logomsg.configlogo[0].checked && configMgmtImageStatus == "NotUploaded")
		{
			alert('<egui:intnl text="admin.logo.Please upload custom logo for configuration management interface"/>');
			res="false";
			return;
		}
		else
		{
			res=true;
		}
	}
	if(strValue == "" || strValue =="audiblealerts")
	{
		var audibleAlertStatus = document.getElementById("audibleAlertStatus").value;
		if (document.logomsg.customwav[0].checked && audibleAlertStatus == "NotUploaded")
		{
			alert('<egui:intnl text="admin.logo.Please upload custom sound files for audible alerts"/>');
			res="false";
			return;
		}
		else
		{
			res=true;
		}
	}
		
	/*if (thisForm.caption.value == "")
	{
		alert('<egui:intnl text="admin.logo.Please enter the caption that should be displayed in the login page"/>');
		thisForm.caption.focus();
	}
	else */
	if(strValue == "" || strValue == "messages" )
	{
		var logo_caption=true;
		var err_msg=true;
		var warr_msg=true;
		var mail_alert=true;
		if('<%=isDouble%>'=="false")
		{
			logo_caption = validateSingleByte(thisForm.caption.value);
			err_msg = validateSingleByte(thisForm.msg1.value);
			warr_msg = validateSingleByte(thisForm.msg2.value);
			mail_alert = validateSingleByte(thisForm.msg3.value);
		}

		if(!checkspecial(thisForm.caption,"`~#$%^+=\'\"|\\;<>?\/"))
		{
			thisForm.caption.focus();
			return false;
		}
		else if(!logo_caption)
		{
			alert('<egui:intnl text="admin.logo.Caption is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.caption.focus();
			return false;
		}
		else if (!checkblank(thisForm.msg1))
		{
			alert('<egui:intnl text="admin.logo.Please enter subscription expired message"/>');
			thisForm.msg1.focus();
			return false;
		}
		else if(!checkspecial(thisForm.msg1,"`~#$%^&*+={}|\\:;<>?\/"))
		{
			thisForm.msg1.focus();
			return false;
		}
		else if(!err_msg)
		{
			alert('<egui:intnl text="admin.logo.Error Message is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.msg1.focus();
			return false;
		}
		else if (!checkblank(thisForm.msg2))
		{
			alert('<egui:intnl text="admin.logo.Please enter subscription expiry message"/>');
			thisForm.msg2.focus();
			return false;
		}
		else if(!warr_msg)
		{
			alert('<egui:intnl text="admin.logo.Warning message is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.msg2.focus();
			return false;
		}
		else if (!checkblank(thisForm.msg3))
		{
			alert('<egui:intnl text="admin.logo.Please enter subscription expiry mail message"/>');
			thisForm.msg3.focus();
			return false;
		}
		else if(!mail_alert)
		{
			alert('<egui:intnl text="admin.logo.Mail alert is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.msg3.focus();
			return false;
		}
		else if(!checkspecial(thisForm.msg2,"`~#$%^&*+={}|\\:;<>?\/"))
		{
			thisForm.msg2.focus();
			return false;
		}
		/*else if(thisForm.mailid.value == "")
		{
			alert('<egui:intnl text="admin.logo.Please enter a valid mailid"/>');
			thisForm.mailid.focus();
		}
		else if(!checkmailid(thisForm.mailid,"@."))
		{
			thisForm.mailid.focus();
		}
		else if(!checkspecial(thisForm.mailid,"`~!#$%^&*()+={}[]:,\\|?;\"\'\/<>"))
		{
			thisForm.mailid.focus();
		}
		else if(!checkspace(thisForm.mailid))
		{
			thisForm.mailid.focus();
		}*/
		else if(!validateEmail(thisForm.mailid.value))
		{
			alert('<egui:intnl text="admin.logo.Please enter a valid mail ID"/>');
			thisForm.mailid.focus();
			return false;
		}
		res = true;
	}
	if(res == true)
	{
		var monSelectVal = thisForm.monSelected.value;
		var repSelectVal = thisForm.repSelected.value;
		var conSelectVal = thisForm.conSelected.value;
		thisForm.action="Egconfiglogomsgp.jsp?process=<%=process%>&from=<%=from%>&monSelected="+monSelectVal+"&repSelected="+repSelectVal+"&conSelected="+conSelectVal;
		thisForm.update.value='<egui:intnl text="admin.common.Updating"/>...';
		thisForm.submit();
	}
}

function closeWin()
{
	if(window.uploadWin && !uploadWin.closed)
		uploadWin.close();
}

function audioAlert()
{
	var thisForm = document.logomsg;
	if(document.logomsg.customwav[0].checked)
	{
		document.logomsg.uploadsound.enabled = true;
		document.logomsg.uploadsound.disabled = false;
	}
	else
	{
		document.logomsg.uploadsound.enabled = false;
		document.logomsg.uploadsound.disabled = true;
	}
}

function adminCustomLogo()
{
	var thisForm = document.logomsg;
	if(thisForm.loginlogo[0].checked)
	{
		thisForm.uploadadmingif.enabled = true;
		thisForm.uploadadmingif.disabled = false;
	}
	else
	{
		thisForm.uploadadmingif.enabled = false;
		thisForm.uploadadmingif.disabled = true;
	}
}

function monitorCustomLogo()
{
	var thisForm = document.logomsg
	if(document.logomsg.monitorlogo[0].checked)
	{
		document.logomsg.uploadmongif.enabled = true;
		document.logomsg.uploadmongif.disabled = false;
	}
	else
	{
		document.logomsg.uploadmongif.enabled = false;
		document.logomsg.uploadmongif.disabled = true;
	}
}

function reporterCustomLogo()
{
	var thisForm = document.logomsg
	if(document.logomsg.reporterlogo[0].checked)
	{
		document.logomsg.uploadrepgif.enabled = true;
		document.logomsg.uploadrepgif.disabled = false;
	}
	else
	{
		document.logomsg.uploadrepgif.enabled = false;
		document.logomsg.uploadrepgif.disabled = true;
	}
}

function configCustomLogo()
{
	var thisForm = document.logomsg
	if(document.logomsg.configlogo[0].checked)
	{
		document.logomsg.uploadcongif.enabled = true;
		document.logomsg.uploadcongif.disabled = false;
	}
	else
	{
		document.logomsg.uploadcongif.enabled = false;
		document.logomsg.uploadcongif.disabled = true;
	}
}
</script>

</head>
<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF"  class="eg_cellbgmedium" -->
<body  id="space6" onUnLoad="javascript:closeWin();" style="overflow:auto" scroll="yes" onLoad="bigScreen();">
<form name="logomsg" method="POST" >
<%
	configmsg.createFile("eg_services.ini");

	String caption = configmsg.getStrValue("MISC_ARGS", "LogoText");
	String mess1 = configmsg.getStrValue("MISC_ARGS","LicenseExpiredMess");
	String mess2 = configmsg.getStrValue("MISC_ARGS","LicenseExpiryMess");
	String mess3 = configmsg.getStrValue("MISC_ARGS","LicenseExpiryMailMessage");
	String mailid = configmsg.getStrValue("MISC_ARGS","LicenseMgrMailid");

//	String monitorbgcolor = configmsg.getStrValue("MISC_ARGS","MonitorBgColor");
//	String adminbgcolor = configmsg.getStrValue("MISC_ARGS","AdminBgColor");

	/*
	 * Values for customising logos are saved in eg_ui.ini and NOT eg_services.ini
	 */
	IniUI ui = IniUI.getInstance();
	String monitorbgcolor = ui.getLogo(IniUI.MONITOR);
	String adminbgcolor = ui.getLogo(IniUI.LOGIN);
	String repImageOption = ui.getLogo(IniUI.REPORTER);
	String configImageOption = ui.getLogo(IniUI.CONFIG);
	String alarmOption = ui.getAlarmOption();

	String customSelected=(alarmOption.equals("CUSTOM"))?"checked":"";
	String defaultSelected=(alarmOption.equals("DEFAULT"))?"checked":"";
	String noneSelected=(alarmOption.equals("NONE"))?"checked":"";

	String  selectedOptions = "NONE";
	String  selectedOptionsOfConfigMgmt = "NONE";
	String  customStr = null,
			defaultStr = null,
			noneStr = null,

			repCustom = null,
			repDefault = null,
			repNone = null,

			configCustom = null,
			configDefault = null,
			configNone = null,

			loginYesStr = null,
			loginNoStr = null;

	if (monitorbgcolor != null && monitorbgcolor.equalsIgnoreCase("CUSTOM"))
	{
		customStr = "checked";
		defaultStr = "";
		noneStr = "";
	}
	else if (monitorbgcolor != null && monitorbgcolor.equalsIgnoreCase("DEFAULT"))
	{
		customStr = "";
		defaultStr = "checked";
		noneStr = "";
	}
	else
	{
		customStr = "";
		defaultStr = "";
		noneStr = "checked";
	}

	if (adminbgcolor != null && adminbgcolor.equalsIgnoreCase("YES"))
	{
		loginYesStr = "checked";
		loginNoStr = "";
	}
	else
	{
		loginYesStr = "";
		loginNoStr = "checked";
	}

	if (StringUtils.isNull(repImageOption) || repImageOption.equalsIgnoreCase(EgConstants.NULL_STRING))
	{
		repImageOption = EgConstants.DEFAULT;
	}

	if (repImageOption.equalsIgnoreCase(EgConstants.NONE))
	{
		selectedOptions = "NONE";
		repCustom = "";
		repDefault = "";
		repNone = " checked ";
	}
	else if (repImageOption.equalsIgnoreCase(EgConstants.DEFAULT))
	{
		selectedOptions = "DEFAULT";
		repCustom = "";
		repDefault = " checked ";
		repNone = "";
	}
	else
	{
		selectedOptions = "CUSTOM";
		repCustom = " checked ";
		repDefault = "";
		repNone = "";
	}

	if(configImageOption.equalsIgnoreCase(EgConstants.NONE))
	{
		selectedOptionsOfConfigMgmt = "NONE";
		configCustom = "";
		configDefault = "";
		configNone = " checked ";
	}
	else if (configImageOption.equalsIgnoreCase(EgConstants.DEFAULT))
	{
		selectedOptionsOfConfigMgmt = "DEFAULT";
		configCustom = "";
		configDefault = " checked ";
		configNone = "";
	}
	else
	{
		selectedOptionsOfConfigMgmt = "CUSTOM";
		configCustom = " checked ";
		configDefault = "";
		configNone = "";
	}

	String monpath = ui.getAbsoluteImagePath("/final/monitor/eg_images/");
	String admpath = ui.getAbsoluteImagePath("/final/admin/eg_images/");
	String reppath = ui.getAbsoluteImagePath("/final/reporter/images/");
	String configpath = ui.getAbsoluteImagePath("/final/config/images/");

//	String s_operating_system = configmsg.getStrValue("MISC_ARGS","ManagerOS");
//	//String s_operating_system = "WINDOWS";
//	String s_iniFileDir = EgInstallInfo.getInstallDir();
//	if(s_operating_system.equalsIgnoreCase("WINDOWS"))
//	{
//		monpath = s_iniFileDir + "\\manager\\tomcat\\webapps\\final\\monitor\\eg_images";
//		admpath = s_iniFileDir + "\\manager\\tomcat\\webapps\\final\\admin\\eg_images";
//	}
//	else
//	{
//		monpath = s_iniFileDir + "/manager/tomcat/webapps/final/monitor/eg_images";
//		admpath = s_iniFileDir + "/manager/tomcat/webapps/final/admin/eg_images";
//	}
%>
<!-- HEADER STARTS HERE -->
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
	<jsp:include page="listSearch.jsp?title=LOGO/MESSAGES &leftString=Add New Role&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">

			<table align="center" cellspacing="0" cellpadding="0" width="<%=tableWidth%>" border="0">
<%
	if(process.equals("") || process.equals("loginscreen"))
	{
%>
				<tr>
					<td colspan="3">
						<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.logo.Login screen"/></strong> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center" height="50" colspan="3" class="eg_subcontentbg">(<egui:intnl text="admin.logo.This option enables you to configure your organization logo on the left hand side of the login screen of eG manager"/>)</td>
				</tr>
<%
	String adminCustomImage = ui.getValue("LOGOS","CUSTOM_LOGIN_LOGO");
%>
				<tr>
					<td align="center" class="eg_subcontentbg" colspan="3" id="head_padding3">
						<table align="center" cellspacing="0" cellpadding="4" width="<%=tableWidth%>" border="0">
							<tr>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>&nbsp;<egui:intnl text="admin.logo.Would you like to configure a custom logo for the eG login interface"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="25"> &nbsp;:</td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type='radio' class="eg_input" name='loginlogo' value='YES' <%=loginYesStr%> onclick="javascript:adminCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="70"><egui:intnl text="admin.common.Yes"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type='radio' name='loginlogo'class="eg_input" value='NO' <%=loginNoStr%> onclick="javascript:adminCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" width="50%"><egui:intnl text="admin.common.No"/></td>

								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap >
								<input type="button" name="uploadadmingif" value='<egui:intnl text="admin.logo.Upload Logo"/>' id="eg_back" onClick="javascript:openUploadWin('EgFileUpload.jsp?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=login&uploadDir=manager/tomcat/webapps/final/admin/eg_images/<%=adminCustomImage%>&fileExt=gif')"></td>
								<input type="hidden" name="loginImageStatus" id="loginImageStatus" value="<%=loginImageUploadStatus%>">
								<input type="hidden" name="loginImageUploadStatusForAudit" id="loginImageUploadStatusForAudit" value="no">
							</tr>
							<script>
								adminCustomLogo();
							</script>
<%
	if(loginYesStr !=null && loginYesStr.equals("checked"))
	{
%>
		<input type='hidden' name='$_loginlogo' value='Custom logo for login screen$YES'>
<%
	}

	if(loginNoStr !=null && loginNoStr.equals("checked"))
	{
%>
		<input type='hidden' name='$_loginlogo' value='Custom logo for login screen$NO'>
<%
	}
%>
							<tr>
								<td nowrap colspan="6" height="10" id="eg_blankspace">&nbsp;</td>
							</tr>
							<tr>
								<td colspan="7" id="cell_border1" align="left">
									<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" >
										<tr >
											<td align="left"><b><egui:intnl text="admin.logo.Logo specifications"/> : </b></td>
											<td align="center"><egui:intnl text="admin.logo.Image type "/> : GIF</td>
											<td align="center"><egui:intnl text="admin.logo.Image size "/> : 15 KB</td>
											<td align="center"><egui:intnl text="admin.logo.Image resolution "/> : 200 x 100 pixels</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
			<tr><td align="center" colspan="3" id="eg_blankspace" height="5">&nbsp;</td></tr>
<%
	}
	if(process.equals("") || process.equals("monitorinterface"))
	{
%>
			<tr><td align="center" colspan="3" id="eg_blankspace" height="5">&nbsp;</td></tr>

			<table align="center" cellspacing="0" cellpadding="0" width="<%=tableWidth%>" border="0">
				<tr>
					<td colspan="3">
						<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.logo.Monitor interface"/></strong> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center" height="50" colspan="3" class="eg_subcontentbg">(<egui:intnl text="admin.logo.This option enables you to configure your organization logo on the monitor interface of eG manager"/>)</td>
				</tr>
<%
	String monitorCustomImage = ui.getValue("LOGOS","CUSTOM_MONITOR_LOGO");
%>
				<tr>
					<td align="center" colspan="3" class="eg_subcontentbg" id="head_padding3">
						<table align="center" cellspacing="0" cellpadding="4" width="<%=tableWidth%>" border="0">
							<tr>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>&nbsp;<egui:intnl text="admin.logo.Choose the logo type preferences for the eG monitor interface"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="10"> &nbsp;:</td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio" class="eg_input"name="monitorlogo" value="CUSTOM" <%=customStr%> onclick="javascript:monitorCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="48"><egui:intnl text="admin.logo.Custom"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio" class="eg_input"name="monitorlogo" value="DEFAULT" <%=defaultStr%> onclick="javascript:monitorCustomLogo();" ></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="48"><egui:intnl text="admin.logo.Default"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio"
								class="eg_input"name="monitorlogo" value="NONE" <%=noneStr%> onclick="javascript:monitorCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" width="25%"><egui:intnl text="admin.logo.None"/></td>

								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>
								<input type="button" name="uploadmongif" value='<egui:intnl text="admin.logo.Upload Logo"/>' id="eg_back"  onClick="javascript:openUploadWin('EgLogoFileUpload.jsp?title=Uploading Logo Files&dispCaption=CustomLogo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=monitor&uploadDir=manager/tomcat/webapps/final/monitor/eg_images/<%=monitorCustomImage%>&fileExt=gif')"></td>
								<input type="hidden" name="monitorImageStatus" id="monitorImageStatus" value="<%=monitorImageUploadStatus%>">
								<input type="hidden" name="monitorImageUploadStatusForAudit" id="monitorImageUploadStatusForAudit" value="no">
							</tr>
							<script>
								monitorCustomLogo();
							</script>
<%
	if(customStr !=null && customStr.equals("checked"))
	{
%>
		<input type='hidden' name='$_monitorlogo' value='Logo preference for monitor interface$CUSTOM'>
<%
	}

	if(defaultStr !=null && defaultStr.equals("checked"))
	{
%>
		<input type='hidden' name='$_monitorlogo' value='Logo preference for monitor interface$DEFAULT'>
<%
	}

	if(noneStr !=null && noneStr.equals("checked"))
	{
%>
		<input type='hidden' name='$_monitorlogo' value='Logo preference for monitor interface$NONE'>
<%
	}
%>
							<tr>
								<td nowrap colspan="9" height="10" id="eg_blankspace">&nbsp;</td>
							</tr>
							<tr>
								<td colspan="9" id="cell_border1" align="left" >
									<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" >
										<tr>
											<td align="left"><b><egui:intnl text="admin.logo.Logo specifications"/> : </b></td>
											<td align="center"><egui:intnl text="admin.logo.Image type "/> : GIF</td>
											<td align="center"><egui:intnl text="admin.logo.Image size "/> : 10 KB</td>
											<td align="center"><egui:intnl text="admin.logo.Image resolution "/> : 120 x 40 pixels</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
			<tr><td align="center" colspan="3" id="eg_blankspace" height="5">&nbsp;</td></tr>
<%
	}
	if(process.equals("") || process.equals("reporterinterface")) 
	{
		if (EgInstallInfo.isReporterSupported)
		{
%>			
			<table align="center" cellspacing="0" cellpadding="0" width="<%=tableWidth%>" border="0">
				<tr>
					<td colspan="3">
						<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.logo.Reporter interface"/></strong> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center" height="50"  id="eg_subcontentbg"  colspan="3">(<egui:intnl text="admin.logo.This option enables you to configure your organization logo on the reporter interface of eG manager"/>)</td>
				</tr>
<%
		String reporterCustomImage = ui.getValue("LOGOS","CUSTOM_REPORTER_LOGO");
%>
				<tr>
					<td align="center" class="eg_subcontentbg"  colspan="3" id="head_padding3">
						<table align="center" cellspacing="0" cellpadding="4" width="<%=tableWidth%>" border="0">
							<tr>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>&nbsp;<egui:intnl text="admin.logo.Choose the logo type preferences for the eG reporter interface"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="10"> &nbsp;:</td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio"
								class="eg_input" name="reporterlogo" value="CUSTOM" <%=repCustom%> onclick="javascript:reporterCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="48"><egui:intnl text="admin.logo.Custom"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio"
								class="eg_input" name="reporterlogo" value="DEFAULT" <%=repDefault%> onclick="javascript:reporterCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="48"><egui:intnl text="admin.logo.Default"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio" class="eg_input" name="reporterlogo" value="NONE" <%=repNone%> onclick="javascript:reporterCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" width="25%"><egui:intnl text="admin.logo.None"/></td>


								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>
									<input type="button" name="uploadrepgif" value='<egui:intnl text="admin.logo.Upload Logo"/>' id="eg_back"  onClick="javascript:openUploadWin('EgLogoFileUpload.jsp?title=Uploading Logo Files&requestFrom=EgConfigLogoMsg.jsp&uploadFor=reporter&dispCaption=CustomLogo&uploadDir=manager/tomcat/webapps/final/reporter/images/<%=reporterCustomImage%>&fileExt=gif')"></td>
									<input type="hidden" name="reporterImageStatus" id="reporterImageStatus" value="<%=reporterImageUploadStatus%>">
									<input type="hidden" name="reporterImageUploadStatusForAudit" id="reporterImageUploadStatusForAudit" value="no">
							</tr>
							<script>
								reporterCustomLogo();
							</script>
							<input type='hidden' name='$_reporterlogo' value='Logo preference for reporter interface$<%=selectedOptions%>'>
							<tr>
								<td nowrap colspan="9" height="10" id="eg_blankspace">&nbsp;</td>
							</tr>
							<tr>
								<td colspan="9" id="cell_border1" align="left" >
									<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" >
										<tr>
											<td align="left"><b><egui:intnl text="admin.logo.Logo specifications"/> : </b></td>
											<td align="center"><egui:intnl text="admin.logo.Image type "/> : GIF</td>
											<td align="center"><egui:intnl text="admin.logo.Image size "/> : 10 KB</td>
											<td align="center"><egui:intnl text="admin.logo.Image resolution "/> : 120 x 40 pixels</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
			<tr><td align="center" colspan="3" id="eg_blankspace" height="5">&nbsp;</td></tr>
<%
		}
	}
	if(process.equals("") || process.equals("configmanageinterface")) 
	{
		if (EgInstallInfo.isConfigSupported)
		{
%>			
			<table align="center" cellspacing="0" cellpadding="0"			  width="<%=tableWidth%>" border="0">
				<tr>
					<td colspan="3">
						<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.logo.Configuration Management Interface"/></strong> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center" height="50"  id="eg_subcontentbg"  colspan="3">(<egui:intnl text="admin.logo.This option enables you to configure your organization logo on the configuration management interface of eG manager"/>)</td>
				</tr>
<%
		String configCustomImage = ui.getValue("LOGOS","CUSTOM_CONFIG_LOGO");
%>
				<tr>
					<td align="center" class="eg_subcontentbg"  colspan="3" id="head_padding3">
						<table align="center" cellspacing="0" cellpadding="4" width="<%=tableWidth%>" border="0">
							<tr>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>&nbsp;<egui:intnl text="admin.logo.Choose the logo type preferences for the eG config mgmt interface"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="10"> &nbsp;:</td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio"
								class="eg_input" name="configlogo" value="CUSTOM" <%=configCustom%> onclick="javascript:configCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="38"><egui:intnl text="admin.logo.Custom"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio"
								class="eg_input" name="configlogo" value="DEFAULT" <%=configDefault%> onclick="javascript:configCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="38"><egui:intnl text="admin.logo.Default"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap><input type="radio" class="eg_input" name="configlogo" value="NONE" <%=configNone%> onclick="javascript:configCustomLogo();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent"><egui:intnl text="admin.logo.None"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>
									<input type="button" name="uploadcongif" value='<egui:intnl text="admin.logo.Upload Logo"/>' id="eg_back"  onClick="javascript:openUploadWin('EgLogoFileUpload.jsp?title=Uploading Logo Files&requestFrom=EgConfigLogoMsg.jsp&uploadFor=configMgmt&dispCaption=CustomLogo&uploadDir=manager/tomcat/webapps/final/config/images/<%=configCustomImage%>&fileExt=gif')"></td>
									<input type="hidden" name="configMgmtImageStatus" id="configMgmtImageStatus" value="<%=configMgmtImageUploadStatus%>">
									<input type="hidden" name="configMgmtImageUploadStatusForAudit" id="configMgmtImageUploadStatusForAudit" value="no">
							</tr>
							<script>
								configCustomLogo();
							</script>
							<input type='hidden' name='$_configmgmtlogo' value='Logo preference for configuration management interface$<%=selectedOptionsOfConfigMgmt%>'>
							<tr>
								<td nowrap colspan="9" height="10" id="eg_blankspace">&nbsp;</td>
							</tr>
							<tr>
								<td colspan="9" id="cell_border1" align="left" >
									<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" >
										<tr>
											<td align="left"><b><egui:intnl text="admin.logo.Logo specifications"/> : </b></td>
											<td align="center"><egui:intnl text="admin.logo.Image type "/> : GIF</td>
											<td align="center"><egui:intnl text="admin.logo.Image size "/> : 10 KB</td>
											<td align="center"><egui:intnl text="admin.logo.Image resolution "/> : 120 x 40 pixels</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
			<tr><td align="center" colspan="3" id="eg_blankspace" height="5">&nbsp;</td></tr>
<%
		}
	}
	if(process.equals("") || process.equals("audiblealerts")) 
	{
%>			
			<table align="center" cellspacing="0" cellpadding="0" width="<%=tableWidth%>" border="0">
				<tr>
					<td colspan="3">
						<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.logo.Audible alerts"/></strong> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td align="center" height="50" id="eg_subcontentbg" colspan="3">(<egui:intnl text="admin.logo.This option enables you to configure the audio &#46;wav files used for alerting the monitor user"/>)</td>
				</tr>
				<tr>
					<td align="center" class="eg_subcontentbg" colspan="3" id="head_padding3">
						<table align="center" cellspacing="0" cellpadding="4" width="<%=tableWidth%>" border="0" >
							<tr>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>&nbsp;<egui:intnl text="admin.logo.Choose your preference for audio alerts"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="10"> &nbsp;:</td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>
									<input type="radio"class="eg_input" name="customwav" value="CUSTOM" <%=customSelected%> onclick="javascript:audioAlert();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="48"><egui:intnl text="admin.logo.Custom"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>
									<input type="radio"class="eg_input" name="customwav" value="DEFAULT" <%=defaultSelected%> onclick="javascript:audioAlert();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="48"><egui:intnl text="admin.logo.Default"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>
								<input type="radio"class="eg_input" name="customwav" value="NONE" <%=noneSelected%> onclick="javascript:audioAlert();"></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap width="78"><egui:intnl text="admin.logo.None"/></td>
								<td class="eg_cellbgmedium" id="eg_subcontent" nowrap>
									<input type="button" name="uploadsound" value='<egui:intnl text="admin.logo.Upload Sound Files"/>' id="eg_back"  onClick="javascript:openUploadWin('EgFileUpload.jsp?title=Uploading Sound Files&requestFrom=EgConfigLogoMsg.jsp&uploadFor=audibleAlerts&dispCaption=Critical Alarm:Major Alarm:Minor Alarm&uploadDir=manager/tomcat/webapps/final/monitor/eg_waves/custom-high.wav:manager/tomcat/webapps/final/monitor/eg_waves/custom-medium.wav:manager/tomcat/webapps/final/monitor/eg_waves/custom-low.wav&fileExt=wav')"></td>
									<input type="hidden" name="audibleAlertStatus" id="audibleAlertStatus" value="<%=audibleAlertUploadStatus%>">
									<input type="hidden" name="audibleAlertUploadStatusForAudit" id="audibleAlertUploadStatusForAudit" value="no">
							</tr>
							<script>
								audioAlert();
							</script>
<%
	if(customSelected !=null && customSelected.equals("checked"))
	{
%>
		<input type='hidden' name='$_customwav' value='Preference for audio alerts$CUSTOM'>
<%
	}

	if(defaultSelected !=null && defaultSelected.equals("checked"))
	{
%>
		<input type='hidden' name='$_customwav' value='Preference for audio alerts$DEFAULT'>
<%
	}

	if(noneSelected !=null && noneSelected.equals("checked"))
	{
%>
		<input type='hidden' name='$_customwav' value='Preference for audio alerts$NONE'>
<%
	}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
			<tr><td align="center" colspan="3" id="eg_blankspace" height="5">&nbsp;</td></tr>
<%
	}
	if(process.equals("") || process.equals("messages")) 
	{
%>
			<table align="center" cellspacing="0" cellpadding="0" width="<%=tableWidth%>" border="0">
				<tr>
					<td colspan="5">
						<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"> <strong><egui:intnl text="admin.logo.Messages"/></strong> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
					<td class="form_border" id="eg_subcontentbg"  valign="top" nowrap> &nbsp; <egui:intnl text="admin.logo.Caption displayed at login"/></td>
					<td class="form_border" id="eg_subcontentbg" valign="top" nowrap align="center" width="20">:</td>
					<td class="form_border" id="eg_subcontentbg" valign="top" width="80%" id="paddingright"><input type='text' name='caption' value="<%=caption%>" maxlength="64" size="32" style="width:400px;"></td>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
				</tr>
				 <input type='hidden' name='$_caption' value='Caption displayed at login$<%=caption%>'>
				<tr>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
					<td class="form_border" id="eg_subcontentbg" valign="top" nowrap> &nbsp; <egui:intnl text="admin.logo.Error message displayed upon subscription expiry"/></td>
					<td class="form_border" id="eg_subcontentbg" valign="top" nowrap align="center" width="20">:</td>
					<td class="form_border" id="eg_subcontentbg" valign="top" width="80%"><textarea name="msg1" rows="3" cols="40" wrap="virtual" style="width:400px; height: 51px; line-height: 15px;padding:2px"><%=mess1%></textarea></td>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
				</tr>
				<input type='hidden' name='$_msg1' value='Error message displayed upon subscription expiry$<%=mess1%>'> 
				<tr>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
					<td class="form_border" id="eg_subcontentbg" valign="top" nowrap> &nbsp; <egui:intnl text="admin.logo.Warning message displayed prior to subscription expiry"/></td>
					<td class="form_border" id="eg_subcontentbg" valign="top" nowrap align="center" width="20">:</td>
					<td class="form_border" id="eg_subcontentbg" valign="top" width="80%"><textarea name="msg2" rows="3" cols="40" wrap="virtual" style="width:400px; height: 51px; line-height: 15px;padding:2px"><%=mess2%></textarea></td>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
				</tr>
				<tr>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
					<td class="form_border" id="eg_subcontentbg" valign="top" nowrap> &nbsp; <egui:intnl text="admin.logo.Mail alert sent prior to subscription expiry"/></td>
					<td class="form_border" id="eg_subcontentbg" valign="top" nowrap align="center" width="20">:</td>
					<td class="form_border" id="eg_subcontentbg" valign="top" width="80%"><textarea name="msg3" rows="3" cols="40" wrap="virtual" style="width:400px; height: 51px; line-height: 15px;padding:2px"><%=mess3%></textarea></td>
					<td width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
				</tr>
 				<input type='hidden' name='$_msg3' value='Mail alert sent prior to subscription expiry$<%=mess3%>'> 
				<tr>
					<td width="7" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
					<td class="form_spacing" id="eg_subcontentbg" nowrap> &nbsp; <egui:intnl text="admin.logo.Subscription manager's mail ID"/></td>
					<td class="form_spacing" id="eg_subcontentbg" nowrap align="center" width="20">:</td>
					<td class="form_spacing" id="eg_subcontentbg" width="80%"><input type='text' name='mailid' value="<%=mailid%>" maxlength="64" size="32" style="width:400px;"></td>
					<td width="7" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
				</tr>
				<input type='hidden' name='$_mailid' value='Subscription manager mail ID$<%=mailid%>'>
 				<tr>
					<td height="5" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
				</tr>
<%
	}			
%>
				<tr>
					<td colspan="5" align="center" height="60" nowrap id="eg_whitebg"><input type="button" name = "update" value='<egui:intnl text="admin.common.Update"/>' style="width: 85px;" id="eg_back" onClick="JavaScript:valform('<%=process%>')"></td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<input type="hidden" id="monSelected" value="" />
<input type="hidden" id="repSelected" value="" />
<input type="hidden" id="conSelected" value="" />
<!-- CONFIGURE MESSAGE ENDS HERE -->
<%	
	if(from.equals("logotree"))
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgSettingsTree.jsp?"+request.getQueryString()+"&treeViewSrc=/final/admin/EgConfigLogoMsg.jsp?process="+process+"&showtree=settingstree");
		}
		else
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgSettingsTree.jsp&treeViewSrc=/final/admin/EgConfigLogoMsg.jsp?process="+process+"&showtree=settingstree");
		}
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigLogoMsg.jsp?"+request.getQueryString()+"&process="+process+"&showtree=settingstree");
	}
%>

</form>
</body>
</html>



