<%
/*************************************************************************************************/
/*                 Name          : EgAutoMainPage.jsp                                            */
/*                 Purpose       : This page is used to create Java script Auto Topology         */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page session = "true" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<jsp:useBean id="zoneinfo" scope="page" class="egurkha.ZoneInfoBean"/>
<%!
	boolean isPreExists = false;
%>
<%
try
{
	//System.out.println("TEST 123");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	
	String topologySkin=_user.getAdminSkin();
	String bgColor = "";
	String compNameColor="";
	String fontFamily="LucidaGrandeRegular";
	String fontFamilyBold="LucidaGrandeBold";
	String mouseOverLineColor = "";
	String mouseOverTextColor="";
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	IniFile udTests=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	if(topologySkin!=null && topologySkin.equalsIgnoreCase("Dark"))
	{
		bgColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","MouseOverTextColor");
	}
	else
	{
		bgColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","MouseOverTextColor");
	}

	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList thisZoneComponents = new ArrayList();	// Contains all components from the given zone.
	ArrayList allZoneComponents = new ArrayList();	// Contains all components from all Zones Except the selected Zone
	String zone = request.getParameter("zone");
	String segmentName = request.getParameter("segment");
	//out.println("segment name"+segmentName);
	String zoomLevel = request.getParameter("zoom");
	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	String link = request.getParameter("link");
	String isAddFlag = request.getParameter("isAddFlag");
	boolean isRecflag = false;
	if(isAddFlag!=null && isAddFlag.equals("true"))
	{
		isRecflag = true;
	}
	boolean isFull = false;
	if(view!=null && view.equals("full"))
		isFull = true;

	String modify = request.getParameter("modify");
	//out.println("modify::"+modify);
	boolean modifySegment=false;
	boolean showComponents=true;
	if(modify!=null && modify.equals("modifySegment"))
		modifySegment = true;
	
	String fromAutoCompType = request.getParameter("fromAutoCompType");
	if(fromAutoCompType==null)
		fromAutoCompType = "false";
	if(modifySegment)
	{
		EgTesterInfo testsInfo = new EgTesterInfo("manager");
		boolean flag = testsInfo.isTopoDiscoveryEnabled();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String[] varArray = autoTopoIniFile.getVariables("Topo_Auto");
		boolean isTopoEntry = false;
		if(varArray!=null && varArray.length > 0)
			isTopoEntry = true;

		if(flag && isTopoEntry)
			showComponents = true;
		else
			showComponents = false;
	}
	
	String dragFn = request.getParameter("enableDrag");
	boolean dragEnabled = false;
	if(dragFn!=null && dragFn.equalsIgnoreCase("true"))
		dragEnabled=true;

	String hlc_type = request.getParameter("hlcomptype");	// High_Lighted_CompType
	String hlc = request.getParameter("hlcomp");			// High_Lighted_Comp
	if(hlc_type == null) 
	{
		hlc_type = request.getParameter("frmcomptype");
	}
	if(hlc == null)
	{
		hlc = request.getParameter("frmcompname");
	}
	
	String color = "A0A0A0";
	String dark = "150517";
	if(zoomLevel == null) zoomLevel = "100";
	if(phyTopology == null) phyTopology = "1";
	if(site == null) site = "egurkha.physical.topology";
	boolean isEntry = false;
	
	String conPath = request.getContextPath();
	//String contextPath = request.getContextPath()+"/admin/eg_images/";
	String contextPath1 = request.getContextPath()+"/images/component_icons/";
	String contextPath = request.getContextPath()+"/images/"+topologySkin+"/component_icons/";
	String ICImagePath=request.getContextPath()+"/images/"+topologySkin+"/ic_images/";
	String finalTopoStr = new String();

	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1")){
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;
	}

	Hashtable tmpHt = groupInfo.getAllComponentsUnderZone();
	if(tmpHt!=null && tmpHt.size() > 0)
	{
		if(isZone && tmpHt.containsKey(zone)){
			tmpHt.remove(zone);
		}
		ArrayList valList = new ArrayList(tmpHt.values());
		for(int k=0;k<valList.size();k++)
		{
			ArrayList tmpList = (ArrayList) valList.get(k);
			allZoneComponents.addAll(tmpList);
		}
	}

/* New Coding Starts here */
	String comptype = request.getParameter("comptype");
	if(comptype==null) comptype="";
	String compname = request.getParameter("compname");
	if(compname==null) compname="";
	StringBuffer  compDataStr = new StringBuffer();
	String action = request.getParameter("action");
	if(action!=null && action.equals("show"))
	{
		IniFile autoTopoIni1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		compDataStr.append(comptype+":"+compname);
		compDataStr.append(",");
		compDataStr.append(autoTopoIni1.getValue("Topo_Auto",comptype+":"+compname));
	}
	else if(action!=null && action.equals("addlink"))
	{
		if(compname !=null && compname.indexOf(",") > -1)
		{
			StringTokenizer stk = new StringTokenizer(compname, ",");
			while(stk.hasMoreTokens())
			{
				compDataStr.append(comptype+":"+stk.nextToken());
				compDataStr.append(",");
			}
		}
		else
		{
			compDataStr.append(comptype+":"+compname);
		}
	}
	String comparisonString = compDataStr.toString();
	Hashtable compList = getStartCompsFromTopoAuto(allZoneComponents);
	Hashtable segmentCompTable = getSegmentComps(segmentName);
	//out.println("segmentCompTable"+segmentCompTable.size());
	//Remove segment components from compList...(Begin)
	if(segmentCompTable!=null && segmentCompTable.size() > 0)
	{
		Set myKeys = segmentCompTable.keySet();
		Iterator myItr = myKeys.iterator();
		while(myItr.hasNext())
		{
			String myKey  = (String) myItr.next();
			ArrayList totalList = (ArrayList) compList.get(myKey);
			if(totalList!=null && totalList.size() > 0)
			{
				ArrayList myList = (ArrayList) segmentCompTable.get(myKey);
				if(myList!=null && myList.size() > 0)
				{
					boolean remove = false;
					for(int k=0;k<myList.size();k++)
					{
						String thisString = (String) myList.get(k);
						int index = totalList.indexOf(thisString);
						if(index >= 0)
						{
							totalList.remove(index);
							remove = true;
						}
					}
					if(remove)
					{
						if(totalList.size() > 0)
							compList.put(myKey, totalList);
						else
							compList.remove(myKey);
					}
				}
			}
		}
	}
	//Remove segment components from compList...(End)

	ArrayList serverTypes = new ArrayList();
	ArrayList compNames = new ArrayList(); 
	if(compList!=null && compList.size() > 0)
	{
		Set compTypeSet = compList.keySet();
		if(compTypeSet!=null && compTypeSet.size() > 0)
		{
			serverTypes = new ArrayList(compTypeSet);
			Collections.sort(serverTypes);
		}
		if(comptype!=null && comptype.length() > 0)
		{
			compNames = (ArrayList) compList.get(comptype);
			if(compNames!=null)
				Collections.sort(compNames);
		}
	}
/* New Coding Ends here */
	
	// For Save position
	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
	IniFile jsTopoIniObj  = EgConfigFilesSync.getInstance(iniFileName);
	String subjectName = segmentName;
	if(segmentName!=null && segmentName.equals("Independent_servers"))
	{
		subjectName = site+ ":"+segmentName;
	}
	String[] allLinesjs = jsTopoIniObj.getLinesUnderSubject(subjectName);
	String iniZoom = jsTopoIniObj.getValue(subjectName,"zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);

	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();
	if(allLinesjs!=null)
	{
		List positionList = Arrays.asList(allLinesjs);
		positionBuffer.append(positionList.toString().substring(1,positionList.toString().indexOf("]")));
		isPosition = true;
	}
	
	if(defaultPos !=null && defaultPos.equals("true"))
		isPosition = false;

	String loginID = _user.getLoginID();

	//Delete Previous INCOMPLETE_SEGMENT if any exists"
//	String INCOMPLETE_SEGMENT = "INCOMPLETE_SEGMENT";
//	String SESSION_DETAILS = "SESSION_DETAILS";
//	String iniFileNameAuto = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
//	IniFile autoTopologyIni  = EgConfigFilesSync.getInstance(iniFileNameAuto,true);
//	Vector sessionVariables = autoTopologyIni.getVariables(SESSION_DETAILS, false);
//	if(sessionVariables!=null && sessionVariables.size() > 0)
//	{
//		// Delete Previous invalid session details & its corresponding segments
//		for(int k=0;k<sessionVariables.size();k++)
//		{
//			String thisVariable = (String) sessionVariables.get(k);
//			boolean isValid = registry.isSessionValid(thisVariable);
//			if(isValid)
//				continue;
//
//			String sessionValue = autoTopologyIni.getValue(SESSION_DETAILS, thisVariable);
//			autoTopologyIni.deleteValue(SESSION_DETAILS, thisVariable);
//			StringTokenizer myTokenizer = new StringTokenizer(sessionValue,",");
//			while(myTokenizer.hasMoreTokens())
//			{
//				String thisToken = myTokenizer.nextToken();
//				autoTopologyIni.deleteValue(INCOMPLETE_SEGMENT, thisToken);
//				autoTopologyIni.deleteSubject(thisToken);
//			}
//		}
//		autoTopologyIni.saveFile();
//	}
//	//Check if the segment is already used by any other user, If "yes" Dn't allow 
//	Vector varVec = autoTopologyIni.getVariables(INCOMPLETE_SEGMENT, false);
//	boolean proceed = false;
//	if(varVec!=null && varVec.contains(segmentName))
//	{
//		String inCompleteValue = autoTopologyIni.getValue(INCOMPLETE_SEGMENT, segmentName);
//		String createdUser = inCompleteValue.substring(0,inCompleteValue.indexOf(":"));
//		String createdSessId = inCompleteValue.substring(inCompleteValue.indexOf(":")+1);
//		if(createdUser.equals(loginID) && createdSessId.equals(sessionID))
//		{
//			proceed = true;
//		}
//		else
//		{
//			proceed = false;
//		}
//	}
//	else
//	{
//		String valueString = loginID+":"+sessionID;
//		String previous_segment = autoTopologyIni.getValue(SESSION_DETAILS,sessionID);
//		if(previous_segment!=null && previous_segment.length() > 0)
//		{
//			if(segmentName!=null && segmentName.length() > 0){
//				previous_segment = previous_segment +","+segmentName;
//				autoTopologyIni.setValue(SESSION_DETAILS,sessionID,previous_segment);
//			}
//		}
//		else
//		{
//			autoTopologyIni.setValue(SESSION_DETAILS,sessionID,segmentName);
//		}
//		autoTopologyIni.setValue(INCOMPLETE_SEGMENT,segmentName,valueString);
//		proceed = true;
//	}
//	autoTopologyIni.saveFile();
//	EgConfigFilesSync.releaseInstance(autoTopologyIni);

	// To Remover Previous session entries
	session.removeAttribute("AllLinesInSegment");
	session.removeAttribute("sessionGroupTable");
	session.removeAttribute("GroupCompHashtable");
	session.removeAttribute("zoneLines");
	session.removeAttribute("THISSEGMENT");
	String from = request.getParameter("fromPage");
	if(from==null) from="";
	if(from!=null && from.equals("modifySegment"))
	{
		String iniFilePath= EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		
		String autoiniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
		IniFile autoTopoIni1  = EgConfigFilesSync.getInstance(autoiniFileName,true);
		
		String[] topoLines = iniFile.getLinesUnderSubject(segmentName);
		String[] autoTopoLines = autoTopoIni1.getLinesUnderSubject(segmentName);
		
		if(topoLines!=null && topoLines.length>0)
		{
			if(autoTopoLines==null)
			{			
				for(int k=0;k<topoLines.length;k++)
				{
					String line = topoLines[k];
					String lineVar = line.substring(0,line.indexOf("="));
					String lineVal = line.substring(line.indexOf("=")+1);
					autoTopoIni1.setValue(segmentName , lineVar , lineVal);
				}			
			}
			else if(autoTopoLines!=null && autoTopoLines.length>0)
			{
				autoTopoIni1.deleteSubject(segmentName);
				for(int k=0;k<topoLines.length;k++)
				{
					String line = topoLines[k];
					String lineVar = line.substring(0,line.indexOf("="));
					String lineVal = line.substring(line.indexOf("=")+1);
					autoTopoIni1.setValue(segmentName , lineVar , lineVal);
				}			
			}
			autoTopoIni1.saveFile();
		}
		EgConfigFilesSync.releaseInstance(autoTopoIni1);
	}
	
%>
<html>
<head>
<title>Auto Topology Generation</title>
<egui:skin ui = "admin"/>

<head>
<style type="text/css">
.myContextMenu .x-menu-body {
    background: #fff;
    padding: 1;
}

.myContextMenu ul {
    padding: 0;
    margin: 0;
    text-align: center;
}

.myContextMenu ul li {
    list-style-type: none;
}

.myContextMenu ul li:nth-child(odd) {
    background-color: #e6e6e6;
}

.myContextMenu a:hover {
    background-color: #ccf;
}

.myContextMenu a {
    text-decoration: none;
    color: #000;
    display: block;
    padding: .5em 0;
}
.DisableCheckBox{
	opacity:0.3
}
</style>
<script src="/final/scripts/map.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.zoom.js" type="text/javascript" charset="utf-8"></script>
<egui:skin ui="admin"/>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>


<script type="text/javascript">


var $j = jQuery.noConflict();

$j(document).ready(function(){
	// call it onload
	//centerBottom("#legendDiv");
	// assure that it gets called when the page resizes

	//alignZoomDiv('#ZoomDiv');

	$j(window).resize(function(){
		//centerBottom('#legendDiv');
		//alignZoomDiv('#ZoomDiv');
	});


	/*   JQuery Drag & Drop Functionality  (Begin)   */
	$j.globalVars = {
		//originalTop: 0,
		//originalLeft: 0,
		maxHeight: $j(window).height(),
		maxWidth:  $j(window).width()
	};

	/*$j( "#groupDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		//iframeFix: false,
		//snapMode: "both", 
		//opacity: 0.35,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
		//containment: "parent",
		//stop: handleDragStop
	});*/
	/*   JQuery Drag & Drop Functionality  (End)   */
});

//creating slider

Ext.onReady(function(){

	setSlider();

});


function setSlider()
{
	
	Ext.define('AlwaysVisibleTip', {
		extend: 'Ext.slider.Tip',
		id:'mytip',
		cls: 'yellowTip',
		init: function(slider) {
			var me = this;

			me.callParent(arguments);
			slider.removeListener('dragend', me.hide);
			slider.on({
				scope: me,
				change: me.onSlide,
				afterrender: {
					fn: function() {
						me.onSlide(slider, null, slider.thumbs[0]);
						tip_hide_task.delay(2000);


					},
					delay: 100
				}
			});
		}
	});

	var tip_hide_task = new Ext.util.DelayedTask(function(){
		if (Ext.getCmp('mytip') != undefined)
		{
		  Ext.getCmp('mytip').hide();
		}
	});

	Ext.create("Ext.form.Panel", {
	//width:108,
	renderTo: Ext.getBody(),
	baseCls:'emptyCls',
	height:210,
	border:0,
	plain:true,
	bodyStyle:{'background':'transparent'},
	style:{'position':'absolute','top':'10px','left':'10px','background':'transparent'},
	items: [
		{
			xtype: 'container',
			items: [{
				xtype: 'button',
				cls:'zoomInbt',
				width:18,
				height:18,
			  handler: function() {
				var sliderValue=Ext.getCmp('sliderSingle').getValue();
				sliderValue=parseInt(sliderValue);
				if(sliderValue<150)
				{
					sliderValue=sliderValue+10;
					
				}
				if(sliderValue>150)
				{
					sliderValue=150;
				}
				Ext.getCmp('sliderSingle').setValue(sliderValue);
				tip_hide_task.delay(2000);
				setZoomLevel(sliderValue);
			  }
			   
			},
			Ext.create('Ext.slider.Single', {
			hideLabel: true,
			id:'sliderSingle',
			useTips: false,
			animate: false,
			plugins: [Ext.create('AlwaysVisibleTip')],
			height: 118,
			value: '<%=zoomLevel%>',
			vertical: true,
			minValue: 10,
			maxValue: 150,
			listeners : {
				
					'changecomplete' : function( slider, e, eOpts )
					{
						var sliderValue=Ext.getCmp('sliderSingle').getValue();
						setZoomLevel(sliderValue);
						
					}
				}
			}), 
			{
				xtype: 'button',
				width:18,
				height:18,
				style:{'margin-top':'-6px'},
				cls:'zoomOutbt',
			  handler: function() {
					var sliderValue=Ext.getCmp('sliderSingle').getValue();
					sliderValue=parseInt(sliderValue);
					if(sliderValue>10)
					{
						sliderValue=sliderValue-10;
					}
					if(sliderValue<10)
					{
						sliderValue=10;
					}
				  Ext.getCmp('sliderSingle').setValue(sliderValue);
				  tip_hide_task.delay(2000);
				  setZoomLevel(sliderValue);
			  }
			}
        ]
    }]
   });
}

function alignToolsDiv(selector)
{
	var toolLeft = $j(window).width() - 180;
	$j(selector).css({
		'left': toolLeft
	});
}

function alignZoomDiv(selector)
{
	var zoomLeft = $j(window).width() - 250;
	$j(selector).css({
		'left': zoomLeft
	});
}

function centerBottom(selector) {
    var newTop =   $j(window).height() - $j(selector).height();
    var newLeft = ($j(window).width()  - $j(selector).width()) / 2;
    $j(selector).css({
        'position': 'absolute',
        'left': newLeft,
        'top': newTop - 33
    });
}

function hideDivs(divId)
{
	
	$j("#"+divId).hide("slow");
	Ext.getCmp('ExtMenu').hide();
}

/*	Context Menu  scripts (Begin) */
var ie = document.all
var ns6 = document.getElementById&&!document.all
var isMenu = false ;
var menuSelObj = null ;
var overpopupmenu = false;
function mouseSelect(e)
{
	var obj = ns6 ? e.target.parentNode : event.srcElement.parentElement;
	if( isMenu ){
		if( overpopupmenu == false ){
			isMenu = false ;
			overpopupmenu = false;
			document.getElementById('menudiv').style.display = "none" ;
			return true ;
		}
		return true ;
	}
	return false;
}

function ItemSelMenu(e, compstatus)
{
	var	obj = ns6 ? e.target.parentNode : event.srcElement.parentElement;
	menuSelObj = obj ;
	if (ns6){
		document.getElementById('menudiv').style.left = e.clientX+document.body.scrollLeft;
		document.getElementById('menudiv').style.top = e.clientY+document.body.scrollTop;
	}
	else{
		document.getElementById('menudiv').style.pixelLeft = event.clientX+document.body.scrollLeft;
		document.getElementById('menudiv').style.pixelTop = event.clientY+document.body.scrollTop;
	}
	document.getElementById('menudiv').style.display = "";
	isMenu = true;

	var thisTitle = document.getElementById('h_title').value;
	var thisSrc = document.getElementById('h_src').value;
	var usesRow = document.getElementById('usesRow');
	var removeRow = document.getElementById('removeRow');
	var manageRow = document.getElementById('manageRow');
	var groupRow = document.getElementById('groupRow');
	var unGroup = document.getElementById('unGroup');
	var groupCreate = document.getElementById('groupCreate');
	
	if(compstatus == "NEW" || compstatus == "UNMANAGE"){
		groupRow.style.display = 'none';
		unGroup.style.display = 'none';
		//groupCreate.style.display = 'none';
		if(usesRow.style.display == 'none') usesRow.style.display = '';
		if(removeRow.style.display == 'none') removeRow.style.display = '';
		if(manageRow.style.display == 'none') manageRow.style.display = '';
	}
	else if(compstatus == "MANAGED"){
		manageRow.style.display ='none';
		groupCreate.style.display = 'none';
		if(usesRow.style.display == 'none') usesRow.style.display = '';
		if(removeRow.style.display == 'none') removeRow.style.display = '';

		//If the component is Group
		if(thisSrc.indexOf("Group.png") > 0){
			groupRow.style.display ='';
			unGroup.style.display ='';
		}
		else{
			groupRow.style.display = 'none';
			unGroup.style.display = 'none';
			if(groupCreate.style.display == 'none') groupCreate.style.display = '';
		}
	}
	/*else if(compstatus == "UNKNOWN"){
		manageRow.style.display ='none';
		groupRow.style.display = 'none';
		if(usesRow.style.display == 'none') usesRow.style.display = '';
		if(removeRow.style.display == 'none') removeRow.style.display = '';
	}*/
	else if(compstatus == "User"){
		usesRow.style.display = 'none';
		removeRow.style.display = 'none';
		manageRow.style.display = 'none';
		groupRow.style.display = 'none';
		unGroup.style.display = 'none';
		groupCreate.style.display = 'none';
	}
	//$j("#connectDiv").hide("slow");
	return false ;
}
document.oncontextmenu = new Function("return false");

function getAbsoluteDivs(){
	
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for (i = 0; i < all_divs.length; i++)
		if (all_divs.item(i).style.position=='absolute'){
			arr[j] = all_divs.item(i);
			j++;
		}
	return arr;
}

function bringToFront(obj){
	
	if (!document.getElementsByTagName)
		return;
	var divs = getAbsoluteDivs();
	var max_index = 0;  
	var cur_index;

	for (i = 0; i < divs.length; i++){
		var item = divs[i];
		if (item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if (max_index < cur_index){
			max_index = cur_index;
		}
	}
	obj.style.zIndex = max_index + 1;
}

function refreshPage()
{
	var thiszone= document.getElementById("zone").value;
	var thissegment = document.getElementById("segment").value;
	var zoomValue = document.getElementById("zoom").value;
	var enableDrag = '';
	//
	document.getElementById('container').style.height = documentView.getHeight()+"px";  
	document.getElementById('container').style.width = documentView.getWidth()+"px";  
	//
	if($j('#dragCheckbx').is(':checked'))
	{
		enableDrag = 'true';
	}
	else
	{
		enableDrag = 'false';
	}
	var modify="<%=modify%>";
	var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+zoomValue+"&enableDrag="+encodeURI(enableDrag)+"&modify="+encodeURI(modify);
	setTimeout(function(){ window.location = myUrl;}, 0);
}

function RemoveFunction(myAction)
{
	var myUrl = getServletUrl(myAction);
	doFunction(myUrl, myAction);
}


function reloadMainPage(servertype , servername )
{
	var thiszone = $j("#zone").attr("value");
	var thissegment = $j("#segment").attr("value");
	var zoomValue = $j("#zoom").attr("value");
	var enableDrag = '';
	if($j('#dragCheckbx').is(':checked'))
	{
		enableDrag = 'true';
	}
	else
	{
		enableDrag = 'false';
	}
	var modify="<%=modify%>";
	var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+encodeURI(zoomValue)+"&enableDrag="+encodeURI(enableDrag);//+"&modify="+encodeURI(modify);
	if(servername==null)
	{
		if(servertype == "-1"){
			var sname = document.getElementById("servernames");
			sname.length = 1;
			alert('<egui:intnl text="admin.server.Please select a type of component"/>');
			return;
		}
		else{
			var comptype = servertype;
			myUrl = myUrl +"&comptype="+encodeURI(comptype);
			setTimeout(function(){ window.location = myUrl;}, 0);
		}
	}
	if(servertype==null)
	{
		if(servername == "-1"){
			alert('<egui:intnl text="admin.server.Please select a component"/>');
			return;
		}
		else{
			showTopology();
		}
	}
}

/*function hide_centered_box(id)
{
	var closediv = document.getElementById(id);
	if (closediv != null){
		closediv.style.display='none';
	}
	else{
		closediv = parent.document.getElementById(id);
		if(closediv!=null){
			closediv.style.display='none';
		}
	}
}*/

function showTopology()
{
	var thiszone = $j("#zone").attr("value");
	var thissegment = $j("#segment").attr("value");

	var thiscomptype='';
	var thiscompname='';
	if(document.getElementById("servertypes")!=null && document.getElementById("servernames")!=null)
	{
		thiscomptype = document.getElementById("servertypes").value;
		thiscompname = document.getElementById("servernames").value;
	}

	if(thiscomptype=="-1"){
		alert('<egui:intnl text="admin.server.Please select a type of component"/>');
		return;
	}
	if(thiscompname=="-1"){
		alert('<egui:intnl text="admin.server.Please select a component"/>');
		return;
	}
	var url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(thissegment)+'&zone='+encodeURI(thiszone)+'&comptype='+encodeURI(thiscomptype)+'&compname='+encodeURI(thiscompname)+"&action=show";
	doFunction(url, "show");
}

function OpenConnectUsesDiv(link)
{
	var thiszone = $j("#zone").attr("value");
	var thissegment = $j("#segment").attr("value");
	var comptitle = $j("#h_title").attr("value");
	var compsrc = $j("#h_src").attr("value");
	var zoom = $j("#zoom").attr("value");
	if(link.length == 0 )
		link = 'uses';
	$j("#lorn").attr({"value" : link});
	var frmcomptype="";
	var frmcompname=comptitle;

	if(comptitle.indexOf(":") < 0)
		frmcompname = comptitle+":NULL";
	if (compsrc.indexOf(".gif")>0)
		frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	else if (compsrc.indexOf(".png")>0)
		frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));

	var bw = new lib_bwcheck();
	var modify='<%=modify%>';
	var href = "/final/admin/EgAutoCompTypes.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&link="+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+"&modifySegment="+encodeURI(modify);

	var connectTitle = '<egui:intnl text="admin.server.Uses"/>';
	if(link == 'connect')
		connectTitle = '<egui:intnl text="admin.server.Connects"/>';
	window.parent.$j("#connectTitle").text(connectTitle);

	var maxInd = maxIndex();
	window.parent.$j("#connectDiv").css({"display":"block" , "position":"absolute" });
	window.parent.$j("#connectDiv").css({"z-index":maxInd+1});
	window.parent.$j("#connectDiv").show('slow');
	window.parent.$j("#innerConnectDiv").load(href);
	//$j("#menudiv").hide("slow"); //Close the menu Div..
}

var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
    selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,  
	renderer : function(val, meta, record, rowIndex, colIndex, store,view){
		if( record.get('Checked')== "checked")
		{  
			Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);
		}
		if( record.get('Disabled')=='disabled')
		{    
			meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
			return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker DisableCheckBox">&#160;</div>';
		}
		else
		{
			meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	selectAll: function(){
       
        var rowIndex=0;
        while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
            var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
            if (record.get('Disabled')=='disabled'){
                Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);
            }
            else {
                Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);
            }
            rowIndex++;
        }
		var view   = Ext.getCmp('gridDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd  = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
                checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');          
        }
    },
	deselectAll: function(){
       
        var rowIndex=0;
        while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
            var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
            Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);           
            rowIndex++;
        }
		var view   = Ext.getCmp('gridDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd  = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {            
             checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');            
        }
    }
});
/*function OpenUsesDiv()
{
	var win = Ext.create('Ext.Window', {
		requires:['Ext.grid.*',
			'Ext.ux.CheckColumn'],
		renderTo: Ext.getBody(),
		id : 'usesConnects',
		title: 'Uses',
		width: 330,
		height: 360, 
		x: 40,
		y: 60,
		autoScroll: true,
		modal: true,
		closeAction: 'destroy',
		items: [
			{
				xtype: 'container',
				layout: {
					type: 'vbox',
					align: 'center',
					pack: 'center'
				},
				items: [
					{
						xtype: 'combobox',
						cls: 'whitedropdown',
						id:'typeOfComp',
						name:'typeOfComp',
						displayField:'displayField',
						valueField:'valueField',
						queryMode: 'local',
						emptyText:'--Select--',
						parent:this,
						selectOnFocus:true,
						labelStyle: 'white-space: nowrap;',
						/*store:new Ext.data.Store({
							fields: ['displayField','valueField'],
							data: []
						}),*/
						/*store: ['Managed Components','New Components','Unmanaged Components'],
						defaultValue: 'Managed Components',
						margin: '10 0 0 0',
						width:250,
						listeners: {
							select: function(combo, record, index) {
							  loadComponentType(combo.getValue());
							}
						  }
					},
					{
						xtype: 'combobox',
						cls: 'whitedropdown',
						id:'compTypeCombo',
						name:'compTypeCombo',
						displayField:'displayField',
						valueField:'valueField',
						queryMode: 'local',
						emptyText:'--Select--',
						parent:this,
						selectOnFocus:true,
						labelStyle: 'white-space: nowrap;',
						store:new Ext.data.Store({
							fields: ['displayField','valueField'],
							data: []
						}),
						margin: '10 0 0 0',
						width:250,
						listeners: {
							select: function(combo, record, index) {
							  loadComponentNames(combo.getValue());
							}
						}
					},
					{
						xtype: 'container',
						id: 'NoComponentPresent',
						hidden:true,
						layout: {
							type: 'vbox',
							pack: 'center',
							align: 'center'
						},
						items: [
							{
								xtype: 'label',
								html: '<table><tr><td align="center" height="150"><table><tr><td align="center"><img src="/final/admin/eg_images/exclamation-icon.gif"></td></tr><tr><td align="center">'+'No Components found!'+'</td></tr></table></td></tr></table>'
							}
						]
					},
				]
			},
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'center',
					pack: 'center'
				},
				items: [
				{
					xtype: 'grid',
					id: 'gridDisplay',
					//hidden:true,
					store:new Ext.data.Store(
					{
						fields: ['Checked','Disabled','CheckboxValue','isZoneComp','isGroupType','isGroupName','Componentname'],
						 data:[]
					}),
					/*selModel: {
						selType: 'checkboxmodel',
						mode: 'MULTI',
						checkOnly: true
					},*/
					/*selModel:mySelectionModel,
					listeners : {
						beforeselect: function(selModel, record, index) {
							if (record.get('Disabled')=='disabled') {
								 return false;  
							}
						},
						rowclick : function (in_this, rowIndex, e) {
							var record = in_this.getStore().getAt(rowIndex);
							if (record.get('Disabled')=='disabled'){
								in_this.getSelectionModel().deselectRow(rowIndex);
							}
						},
						selectionchange : function()
						{
							//var selectedRows = Ext.getCmp('gridDisplay').getSelectionModel().getStore().getAt(index);
							//var CheckboxValue = record.get('CheckboxValue');
							//var isChecked = Ext.getCmp('gridDisplay').getSelectionModel().isChecked();
							//alert(selectedRows);
							//

							var store = Ext.getCmp('gridDisplay').getStore();
							var selModel = Ext.getCmp('gridDisplay').getSelectionModel();
							var selectedRecord = selModel.getSelection();
							for (var i=0; i<=selectedRecord.length-1; i++) {
								//alert(selectedRecord[i].get('CheckboxValue'));
								addOrRemoveComponents(selectedRecord[i].get('CheckboxValue'),'');
							}
							//addOrRemoveComponents(CheckboxValue,isChecked);

							/*var store = Ext.getCmp('gridDisplay').getStore();
							var selModel = Ext.getCmp('gridDisplay').getSelectionModel();
							var selectedRecord = selModel.getLastSelected();
							alert("SelectedRecord >>> "+selectedRecord.get('CheckboxValue'));
							var recordIndex = store.indexOf(selectedRecord);
							*/
							
					/*	},
						deselectAll: function(){
							alert("deselectall");
						}
					},
					autoScroll: true,
					margin: '10 0 0 0',
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: 'List of components',
								dataIndex: 'Componentname',
								id: 'DispComponentname',
								width:300
							}
						]
					}
				}]
			}
		]
	}); 
	win.show();
	Ext.getCmp('typeOfComp').setValue('Managed Components');
	loadComponentType('Managed Components');
}*/
function OpenUsesDivForParam()
{
	var link = 'uses';
	var thiszone = document.getElementById('zone').value;		//$j("#zone").attr("value");
	var thissegment = document.getElementById('segment').value; //$j("#segment").attr("value");
	var comptitle = document.getElementById('h_title').value;	//$j("#h_title").attr("value");
	var compsrc = document.getElementById('h_src').value;		//$j("#h_src").attr("value");
	var zoom = document.getElementById('zoom').value;			//$j("#zoom").attr("value");
	if(link.length == 0 )
		link = 'uses';
	//$j("#lorn").attr({"value" : link});
	document.getElementById('lorn').value= link;
	var frmcomptype="";
	var frmcompname=comptitle;

	if(comptitle.indexOf(":") < 0)
		frmcompname = comptitle+":NULL";
	//if (compsrc.indexOf(".gif")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	//else if (compsrc.indexOf(".png")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
	frmcomptype=compsrc;
	var modify='<%=modify%>';
	var href = "segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&link="+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+"&modifySegment="+encodeURI(modify);
	window.parent.OpenUsesDiv(href,'Uses');
}

function OpenConnectsDivForParam()
{
	
	var link = 'connect';
	var thiszone = document.getElementById('zone').value;		//$j("#zone").attr("value");
	var thissegment = document.getElementById('segment').value; //$j("#segment").attr("value");
	var comptitle = document.getElementById('h_title').value;	//$j("#h_title").attr("value");
	var compsrc = document.getElementById('h_src').value;		//$j("#h_src").attr("value");
	var zoom = document.getElementById('zoom').value;			//$j("#zoom").attr("value");
	if(link.length == 0 )
		link = 'connect';
	//$j("#lorn").attr({"value" : link});
	document.getElementById('lorn').value= link;
	var frmcomptype="";
	var frmcompname=comptitle;

	if(comptitle.indexOf(":") < 0)
		frmcompname = comptitle+":NULL";
	//if (compsrc.indexOf(".gif")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	//else if (compsrc.indexOf(".png")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
		frmcomptype=compsrc;
	var modify='<%=modify%>';
//	var href = "segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&link="+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+"&modifySegment="+encodeURI(modify);
var href = "zone="+encodeURI(thiszone)+"&link="+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+"&modifySegment="+encodeURI(modify);
	
	window.parent.OpenUsesDiv(href,'Connects');
}

function MyRemoveFunction()
{
	var myServletUrl = getServletUrl('remove');
	var thiszone = $j("#zone").attr("value");
	var thissegment = $j("#segment").attr("value");
	var zoomValue = $j("#zoom").attr("value");
	var modify="<%=modify%>";
	var myJspUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+encodeURI(zoomValue)+"&modify="+encodeURI(modify);
	window.parent.RemoveFunction(myServletUrl,myJspUrl);
}

function OpenManageSingleDiv()
{
	/*var thissegment = $j("#segment").attr("value");
	var thiszone = $j("#zone").attr("value");

	var urlToDisplay ='';
	var comptitle = $j("#h_title").attr("value");
	var compsrc = $j("#h_src").attr("value");
	var compstatus = $j("#h_status").attr("value"); 
	var servertype='';
	if (compsrc.indexOf(".gif")>0)
		servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	else if (compsrc.indexOf(".png")>0)
		servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
	var urlToDisplay = "EgNewServer.jsp?server=new&compstatus="+ encodeURI(compstatus)+"&serverType="+encodeURI(servertype)+"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&comptitle="+encodeURI(comptitle)+"&topoSegName="+encodeURI(thissegment);*/
	window.parent.OpenManageDiv();
}
function unGroupFunction()
{
	var mode = 'delete';
	var thistitle = $j("#h_title").attr("value");
	//var thiszone= $j("#zone").attr("value");
	var thiszone="-1";
	var fromPage = 'autoMainPage';
	var zoneString = $j("#zoneString").attr("value");
	var thissegment = $j("#segment").attr("value");
	var zoomValue = $j("#zoom").attr("value");
	var modify="<%=modify%>";

//	var url = '/final/admin/Egconfiggroupp.jsp?mode='+encodeURI(mode)+'&deleteGroups='+encodeURI(thistitle)+'&thiszone='+encodeURI(thiszone)+'&fromPage='+encodeURI(fromPage)+'&zoneString='+encodeURI(zoneString);
var url = '/final/admin/Egconfiggroupp.jsp?mode='+encodeURI(mode)+'&deleteGroups='+encodeURI(thistitle)+'&thiszone='+encodeURI(thiszone)+'&fromPage='+encodeURI(fromPage)+'&zoneString='+encodeURI(zoneString)+'&segment='+encodeURI(thissegment);
	var httpObj = parent.createRequestObject();
	var params = "";
	var tempurl = "";
	if (url.indexOf("?") > -1){
		params=url.substring(url.indexOf("?")+1);
		tempurl=url.substring(0,url.indexOf("?"));
	}
	else{
		tempurl=url;
	}
	httpObj.open('POST',tempurl,true);
	httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
	//httpObj.setRequestHeader('Content-length',params.length);
	//httpObj.setRequestHeader('Connection','close');
	httpObj.onreadystatechange = function() {
		if (httpObj.readyState == 4 && httpObj.status == 200)
		{
			var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+encodeURI(zoomValue)+"&modify="+encodeURI(modify);
			window.parent.UnGroupFunction(myUrl);
		}
	}
	httpObj.send(params);
}

function loadComponentType(comboValue)
{
	
	var link = 'uses';
	var choice='';
	if(comboValue=='Managed Components')
		choice = 'managedComp';
	else if(comboValue=='New Components')
		choice = 'newComp';
	else if(comboValue=='Unmanaged Components')
		choice = 'unManagedComp';

	var thiszone = document.getElementById('zone').value;		//$j("#zone").attr("value");
	var thissegment = document.getElementById('segment').value; //$j("#segment").attr("value");
	var comptitle = document.getElementById('h_title').value;	//$j("#h_title").attr("value");
	var compsrc = document.getElementById('h_src').value;		//$j("#h_src").attr("value");
	var zoom = document.getElementById('zoom').value;			//$j("#zoom").attr("value");
	if(link.length == 0 )
		link = 'uses';
	//$j("#lorn").attr({"value" : link});
	document.getElementById('lorn').value= link;
	var frmcomptype="";
	var frmcompname=comptitle;

	if(comptitle.indexOf(":") < 0)
		frmcompname = comptitle+":NULL";
	//if (compsrc.indexOf(".gif")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	//else if (compsrc.indexOf(".png")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
	frmcomptype = compsrc;
	var bw = new lib_bwcheck();
	var modify='<%=modify%>';
	var href = "AutoTopology/data/MainPageCompTypesJson.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&link="+encodeURI(link)+'&frmcomptype='+encodeURI(frmcomptype)+'&frmcompname='+encodeURI(frmcompname)+'&zoom='+encodeURI(zoom)+"&modifySegment="+encodeURI(modify)+"&choice="+choice;
	Ext.Ajax.request({
			url: href,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var mypublicJSON = Ext.decode( jsonText );
					var count = mypublicJSON['Total'];
					if(count == 0)
					{
						Ext.getCmp('NoComponentPresent').show();
						Ext.getCmp('compTypeCombo').hide();
						Ext.getCmp('gridDisplay').hide();
					}
					else
					{
						Ext.getCmp('NoComponentPresent').hide();
						Ext.getCmp('compTypeCombo').show();
						Ext.getCmp('gridDisplay').show();
					}
					Ext.getCmp('compTypeCombo').getStore().loadRawData(mypublicJSON['ComponentTypes']);
					Ext.getCmp('compTypeCombo').setValue(mypublicJSON['SelectedCompType']);
					loadComponentNames(mypublicJSON['SelectedCompType']);
				}
			}
	});
}
function loadComponentNames(comboValue)
{
	var thiszone = document.getElementById('zone').value;
	var thissegment = document.getElementById('segment').value;
	var comptitle = document.getElementById('h_title').value;
	var compsrc = document.getElementById('h_src').value;	
	var choiceValue = Ext.getCmp('typeOfComp').getValue();
	var choice='';
	if(choiceValue=='Managed Components')
		choice = 'managedComp';
	else if(choiceValue=='New Components')
		choice = 'newComp';
	else if(choiceValue=='Unmanaged Components')
		choice = 'unManagedComp';

	var frmcomptype="";
	var frmcompname=comptitle;

	if(comptitle.indexOf(":") < 0)
		frmcompname = comptitle+":NULL";
	//if (compsrc.indexOf(".gif")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	//else if (compsrc.indexOf(".png")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
	frmcomptype = compsrc;
	var url = 'Segment/data/EgAutoCompNamesJson.jsp?comptype='+encodeURI(comboValue)+"&zone="+encodeURI(thiszone)+"&segment="+encodeURI(thissegment)+"&choice="+encodeURI(choice)+"&frmcomptype="+encodeURI(frmcomptype)+"&frmcompname="+encodeURI(frmcompname);
	Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var mypublicJSON = Ext.decode( jsonText );
					Ext.getCmp('gridDisplay').getStore().loadRawData(mypublicJSON['CompNameGridValues']);
				}
			}
	});
}
function addOrRemoveComponents(cbValue,isChecked)
{
	
	var thissegment = document.getElementById("segment").value;
	var thiszone= document.getElementById("zone").value;
	var comptitle = document.getElementById('h_title').value;
	var compsrc = document.getElementById('h_src').value;	
	var thiscomptype = Ext.getCmp('compTypeCombo').getValue();
	var thiscompname = cbValue;
	var link = 'uses';
	var frmcomptype="";
	var frmcompname=comptitle;

	if(comptitle.indexOf(":") < 0)
		frmcompname = comptitle+":NULL";
	//if (compsrc.indexOf(".gif")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	//else if (compsrc.indexOf(".png")>0)
		//frmcomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
		frmcomptype = compsrc;
	var action = 'addlink';
	/*if(isChecked){
		action = 'addlink';
	}
	else{
		action = 'removelink';
	}*/
	var url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(thissegment)+'&zone='+encodeURI(thiszone)+'&comptype='+encodeURI(thiscomptype)+'&compname='+encodeURI(thiscompname)+'&link='+encodeURI(link)+'&action='+encodeURI(action)+"&frmcompname="+encodeURI(frmcompname)+"&frmcomptype="+encodeURI(frmcomptype);
	//loadPage(url, null, action);
	Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200)
				{
					var zoom = '100';
					var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment) +"&zone="+encodeURI(thiszone)+"&zoom="+encodeURI(zoom)+"&hlcomp="+encodeURI(frmcompname)+"&hlcomptype="+encodeURI(frmcomptype)+"&modify=false"+"&fromAutoCompType=true";
					window.parent.refreshTopologyDiv(myUrl);
					/*Ext.getCmp('topologyPanel').setVisible(true);
					Ext.getCmp('topologyFrame').setVisible(true);
					Ext.getCmp('topologyFrame').update('<iframe src="' + myUrl+ '" style="width:945px" height="600"></iframe>');*/
				}
			}
	});
}

function getServletUrl(action)
{
	var thiszone = $j("#zone").attr("value");
	var thissegment = $j("#segment").attr("value");
	var url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(thissegment)+'&zone='+encodeURI(thiszone);
	if(action == 'clearall'){
		url = url + "&action="+encodeURI(action);
	}
	else{
		var comptitle = $j("#h_title").attr("value");
		var compsrc = $j("#h_src").attr("value");
		var thiscomptype = compsrc;
		var thiscompname = comptitle;
		if(comptitle.indexOf(":") < 0)
			thiscompname = thiscompname+":NULL";
		//if (compsrc.indexOf(".gif")>0)
			//thiscomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
		//else if (compsrc.indexOf(".png")>0)
			//thiscomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
		thiscomptype = compsrc;
		url = url + '&comptype='+encodeURI(thiscomptype)+'&compname='+encodeURI(thiscompname)+"&action="+encodeURI(action);
	}
	return url;
}

function doFunction(url, action)
{
	var thiszone = $j("#zone").attr("value");
	var thissegment = $j("#segment").attr("value");
	var thiscomptype='';
	var thiscompname='';
	if(document.getElementById("servertypes")!=null && document.getElementById("servernames")!=null)
	{
		thiscomptype = document.getElementById("servertypes").value;
		thiscompname = document.getElementById("servernames").value;
	}
	var zoomValue = $j("#zoom").attr("value");
	var enableDrag = '';
	if($j('#dragCheckbx').is(':checked'))
	{
		enableDrag = 'true';
	}
	else
	{
		enableDrag = 'false';
	}
	var modify="<%=modify%>";

	var httpObj = parent.createRequestObject();
	var params = "";
	var tempurl = "";
	if (url.indexOf("?") > -1){
		params=url.substring(url.indexOf("?")+1);
		tempurl=url.substring(0,url.indexOf("?"));
	}
	else{
		tempurl=url;
	}
	httpObj.open('POST',tempurl,true);
	httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
	httpObj.setRequestHeader('Content-length',params.length);
	httpObj.setRequestHeader('Connection','close');
	httpObj.onreadystatechange = function() {
		if (httpObj.readyState == 4 && httpObj.status == 200)
		{
			var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+encodeURI(zoomValue)+"&enableDrag="+encodeURI(enableDrag)+"&modify="+encodeURI(modify);
			if(action == 'show'){
				myUrl = myUrl + "&comptype="+encodeURI(thiscomptype) + "&compname="+encodeURI(thiscompname);
			}
			setTimeout(function(){window.location = myUrl;}, 0);
		}
	}
	httpObj.send(params);
}

// Set height and width based on window screen size
documentView ={
		getObject: function(){
			if(typeof( window.innerWidth) == 'number'){//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight )){//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight){ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			return this;
		},
		getHeight: function(){
			return this.getObject().height;
		},
		getWidth: function(){
			return this.getObject().width;
		},
		isIE: function(){
				return this.getObject().ie;
		},
		isFireFox: function(){
				return this.getObject().fireFox;
		}
};

function pageHeightWidth()
{
	var containerDiv = document.getElementById("container");
	if (containerDiv!=null){
		//containerDiv.style.height = documentView.getHeight()- 60;
		//containerDiv.style.width = documentView.getWidth()- 8;
		if('<%=isFull%>' == 'true')
		{
			$j("#container").height(documentView.getHeight()- 10);
			$j("#container").width(documentView.getWidth()- 0);
		}
		else if('<%=isFull%>' == 'false')
		{
			//$j("#container").height(documentView.getHeight()- 60);
			$j("#container").height(documentView.getHeight());
			$j("#container").width(documentView.getWidth()- 0);
		}
	}
	var toolBoxOnOff = parent.document.getElementById("toolBoxOnOff");
	if(toolBoxOnOff!=null){
		var onoffval = toolBoxOnOff.value;
		if(onoffval == 'on'){
			showToolsDiv();
		}
	}

}

window.onresize=pageHeightWidth;

function overImage(obj){
	obj.className="tree_over_border tree_font";
}

function outImage(obj){
	obj.className="eg_whitebg tree_font";
}

function ShowGroupDetails()
{
	/*var thistitle = $j("#h_title").attr("value"); // GroupName
	var href = 'EgTopologyGroupPage.jsp?title='+thistitle;
	var maxInd = maxIndex();
	window.parent.$j("#groupDiv").css({"display":"block" , "position":"absolute" });
	window.parent.$j("#groupDiv").css({"z-index":maxInd+1});
	window.parent.$j("#groupDiv").show('slow');
	window.parent.$j('#innerGroupDiv').load(href);
	$j("#menudiv").hide("slow"); //Close the menu Div..*/
	
	/*var thistitle = document.getElementById('h_title').value;
	var win = Ext.create('Ext.Window', {
		requires:['Ext.grid.*'],
		renderTo: Ext.getBody(),
		id : 'groupdetails',
		title: 'Group Details',
		width: 500,
		height: 300, 
		x: 40,
		y: 60,
		autoScroll: true,
		modal: true,
		closeAction: 'destroy',
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/info2.gif" valign="middle">&nbsp&nbsp'+'Hosts associated with '+thistitle+'</center>',
				style: {
					background: '#f3f5fa',
					fontFamily: 'Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif',
					fontSize: '9px'
				},
				height: 25,
				padding: 5
			},
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					align: 'center',
					pack: 'center'
				},
				items: [
				{
					xtype: 'grid',
					id: 'gridDisplay',
					store:new Ext.data.Store(
					{
						fields: ['Hostname','Portno','Componenttype'],
						 data:[]
					}),
					autoScroll: true,
					margin: '10 0 0 10',
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: 'Host / nick name',
								dataIndex: 'Hostname',
								id: 'DispHostname',
								width: 100
							},
							{
								text: 'Port',
								dataIndex: 'Portno',
								id: 'DispPortno',
								flex:1
							},
							{
								text: 'Component type',
								dataIndex: 'Componenttype',
								id: 'DispComponenttype',
								width:300
							}
						]
					}
				}]
			}
		]
	}); 
	win.show();
	var url = 'Segment/data/EgTopologyGroupPageJson.jsp?title='+thistitle;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var mypublicJSON = Ext.decode( jsonText );
					Ext.getCmp('gridDisplay').show();
					Ext.getCmp('gridDisplay').getStore().loadRawData(mypublicJSON['GroupDetails']);
				}
			}
		});*/
	var thistitle = document.getElementById('h_title').value;
	window.parent.showGroupDetails(thistitle);
}

function createGroup()
{
	var thistitle = $j("#h_title").attr("value");
	var compsrc = $j("#h_src").attr("value");
	var segment = $j("#segment").attr("value");
	//var zone = $j("#zone").attr("value");
	var zone="-1";
	var src = compsrc;
	var compstatus = $j("#h_status").attr("value"); 
	var zoomValue = $j("#zoom").attr("value");
	var modify = '<%=modify%>';

	//if (compsrc.indexOf(".gif")>0)
		//src = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	//else if (compsrc.indexOf(".png")>0)
		//src = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
		zone="-1";
	var href = 'thiscomp='+encodeURI(thistitle)+'&src='+encodeURI(src)+'&segment='+encodeURI(segment)+'&zone='+encodeURI(zone)+'&status='+encodeURI(compstatus)+'&fromPage='+'automainPage'+'&zoom='+encodeURI(zoomValue)+"&modify="+encodeURI(modify);
	window.parent.CreateGroup(href);
	/*var maxInd = maxIndex();
	window.parent.$j('#innerGroupDiv').html("");
	var divId = window.parent.document.getElementById("innerGroupDiv");
	divId.innerHTML = "<table width='100%' border='0' bgcolor='white' height='300px'><tr><td align=center valign=bottom><img src=/final/admin/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top></td></tr></table>";
	window.parent.$j("#groupDiv").css({"display":"block" , "position":"absolute" });
	window.parent.$j("#groupDiv").css({"z-index":maxInd+1});
	window.parent.$j("#groupDiv").show('slow');
	window.parent.$j('#innerGroupDiv').load(href);
	$j("#menudiv").hide("slow"); //Close the menu Div..*/
}

function maxIndex()
{
	var index_highest = 0;
	$j('div').each(function(){
		var index_current = parseInt($j(this).css("z-index"), 10);
		if(index_current > index_highest) {
			index_highest = index_current;
		}
	});
	return index_highest.toString();
}

/*function showComponentsFromThis(comptitle , compsrc)
{
	var thiscomptype = compsrc;
	var thiscompname = comptitle;

	if(comptitle.indexOf(":") < 0)
		thiscompname = thiscompname+":NULL";
	if (compsrc.indexOf(".gif")>0)
		thiscomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
	else if (compsrc.indexOf(".png")>0)
		thiscomptype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));

	var thiszone= document.getElementById("zone").value;
	var thissegment = document.getElementById("segment").value;

	var guideDiv = parent.document.getElementById("guideDiv");
	var guideFrame = parent.document.getElementById("guideFrame");
	var bw = new lib_bwcheck();
	var href = "EgTopologyHelp.jsp?comptype="+encodeURI(thiscomptype)+"&compname="+encodeURI(thiscompname)+"&segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone);
	//var menuDiv = document.getElementById("menudiv");
	if(guideDiv!=null)
	{
		guideFrame.src = href;
		guideDiv.style.textAlign = 'right';
		guideDiv.style.padding = '0px';
		guideDiv.style.padding = '0px';
		guideDiv.style.display = 'block';
		guideDiv.style.position = 'absolute';
		bringToFront(guideDiv);
		//hide_centered_box('menudiv');		//Close the menu Div..
	}
}*/

function showToolsDiv()
{
	var toolsDiv = document.getElementById("toolsDiv");
	var toolBoxOnOff = parent.document.getElementById("toolBoxOnOff");
	if(toolsDiv!=null)
	{
		if(toolsDiv.style.display == 'block')
		{
			toolsDiv.style.display = "none";
			$j("#toolsDiv").hide("slow");
			toolBoxOnOff.value="off";
		}
		else
		{
			toolsDiv.style.display = 'block';
			toolsDiv.style.position = 'absolute';
			bringToFront(toolsDiv);
			toolBoxOnOff.value = "on";
		}
		$j("#menudiv").hide("slow");
		alignToolsDiv('#toolsDiv');
	}
}

function OpenManageAllDiv(val)
{
	var thissegment = $j("#segment").attr("value");
	var thiszone = $j("#zone").attr("value");
	
	var enableDrag = '';
	if($j('#dragCheckbx').is(':checked'))
	{
		enableDrag = 'true';
	}
	else
	{
		enableDrag = 'false';
	}

	var title = '<egui:intnl text="admin.server.Manage Discovered / Unmanaged  Components"/>';
	if(val == 'save')
		title = '<egui:intnl text="admin.server.Save Segment"/>';
	if(val == 'saveAs')
		title = '<egui:intnl text="admin.server.Save Segment as"/>';

	window.parent.$j("#manageAllDivTitle").text(title);
	var urlToDisplay ='';
	if(val == 'all'){
		urlToDisplay ="EgAutoManagePage.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&enableDrag="+encodeURI(enableDrag);
	}
	else if(val == 'save'){
		urlToDisplay ="EgAutoManagePage.jsp?segment="+encodeURI(thissegment)+"&action="+val+"&zone="+encodeURI(thiszone)+"&enableDrag="+encodeURI(enableDrag);
	}
	else if(val== 'saveAs')
	{
		urlToDisplay ="EgAutoManagePage.jsp?segment="+encodeURI(thissegment)+"&action="+val+"&zone="+encodeURI(thiszone)+"&enableDrag="+encodeURI(enableDrag);
		//return;
	}

	var maxInd = maxIndex();
	window.parent.$j("#manageAllDiv").css({"display":"block" , "position":"absolute" });
	window.parent.$j("#manageAllDiv").css({"z-index":maxInd+1});
	window.parent.$j("#manageAllDiv").show('slow');
	window.parent.$j('#innerManageAllDiv').load(urlToDisplay);
	$j("#menudiv").hide("slow"); //Close the menu Div..
}

function OpenManageDiv(val)
{
	//var manageDiv = parent.document.getElementById("manageDiv");
	var manageFrame = parent.document.getElementById("manageFrame");
	var thissegment = $j("#segment").attr("value");
	var thiszone = $j("#zone").attr("value");

	//var bw = new lib_bwcheck();
	var urlToDisplay ='';
	if(val == 'single'){
		var comptitle = $j("#h_title").attr("value");
		var compsrc = $j("#h_src").attr("value");
		var compstatus = $j("#h_status").attr("value"); 
		var servertype='';
		if (compsrc.indexOf(".gif")>0)
			servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
		else if (compsrc.indexOf(".png")>0)
			servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));
		urlToDisplay = "EgNewServer.jsp?server=new&compstatus="+ encodeURI(compstatus)+"&serverType="+encodeURI(servertype)+"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&comptitle="+encodeURI(comptitle)+"&topoSegName="+encodeURI(thissegment);
	}
	/*else if(val == 'all'){
		urlToDisplay ="EgAutoManagePage.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone);
	}
	else if(val == 'save'){
		urlToDisplay ="EgAutoManagePage.jsp?segment="+encodeURI(thissegment)+"&action="+val+"&zone="+encodeURI(thiszone);
	}*/

	var maxInd = maxIndex();
	window.parent.$j("#manageDiv").css({"display":"block" , "position":"absolute" });
	window.parent.$j("#manageDiv").css({"z-index":maxInd+1});
	window.parent.$j("#manageDiv").show('slow');
	manageFrame.src = urlToDisplay;
	$j("#menudiv").hide("slow"); //Close the menu Div..

	/*if(manageDiv!=null)
	{
		var divWidth = manageDiv.style.width;
		var divHeight = manageDiv.style.height;
		manageFrame.src = urlToDisplay;
		manageDiv.style.textAlign = 'right';
		manageDiv.style.padding = '0px';
		manageDiv.style.padding = '0px';
		manageDiv.style.background="white";
		manageDiv.style.display = 'block';
		manageDiv.style.position = 'absolute';
		bringToFront(manageDiv);
		$j("#menudiv").hide("slow");	//Close the menu Div..
	}*/
	
}

function showSettings()
{
	var maxInd = maxIndex();
	var href = "/final/admin/EgTopologySettings.jsp";
	window.parent.$j("#settingsDiv").css({"display":"block" , "position":"absolute" });
	window.parent.$j("#settingsDiv").css({"z-index":maxInd+1});
	window.parent.$j("#settingsDiv").show('slow');
	window.parent.$j("#innerSettingDiv").load(href);
	$j("#menudiv").hide("slow"); //Close the menu Div..
}

function setZoomLevel(val)
{
	//This is a Dummy function, used to avoid java script error. Original Function is defined inside Body
}

function unGroup()
{
	var mode = 'delete';
	var thistitle = $j("#h_title").attr("value");
	var thiszone= $j("#zone").attr("value");
	var fromPage = 'autoMainPage';
	var zoneString = $j("#zoneString").attr("value");
	var thissegment = $j("#segment").attr("value");
	var zoomValue = $j("#zoom").attr("value");
	var enableDrag = '';
//	if($j('#dragCheckbx').is(':checked'))
//	{
//		enableDrag = 'true';
//	}
//	else
//	{
//		enableDrag = 'false';
//	}
	var modify="<%=modify%>";

	var url = '/final/admin/Egconfiggroupp.jsp?mode='+encodeURI(mode)+'&deleteGroups='+encodeURI(thistitle)+'&thiszone='+encodeURI(thiszone)+'&fromPage='+encodeURI(fromPage)+'&zoneString='+encodeURI(zoneString);
	var httpObj = parent.createRequestObject();
	var params = "";
	var tempurl = "";
	if (url.indexOf("?") > -1){
		params=url.substring(url.indexOf("?")+1);
		tempurl=url.substring(0,url.indexOf("?"));
	}
	else{
		tempurl=url;
	}
	httpObj.open('POST',tempurl,true);
	httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
	httpObj.setRequestHeader('Content-length',params.length);
	httpObj.setRequestHeader('Connection','close');
	httpObj.onreadystatechange = function() {
		if (httpObj.readyState == 4 && httpObj.status == 200)
		{
			var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+encodeURI(zoomValue)+"&enableDrag="+encodeURI(enableDrag)+"&modify="+encodeURI(modify);
			setTimeout(function(){window.location = myUrl;}, 0);
		}
	}
	httpObj.send(params);
}

function getXMLObject()  //XML OBJECT
{
	var xmlHttp = false;
	try 
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) 
	{
		try 
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e2) 
		{
			xmlHttp = false;
		}
	}
	if (!xmlHttp && typeof XMLHttpRequest != 'undefined') 
	{
		xmlHttp = new XMLHttpRequest();
	}
	return xmlHttp;
}
var xmlhttp;
function savePositions(str)
{
	var segmentname ='<%=segmentName%>';
	if(segmentname == 'Independent_servers')
	{
		var siteName = '<%=site%>';
		segmentname = siteName+":"+segmentname;
	}
	var url = "/final/servlet/com.eg.SegmentPositionServlet";
	var zoomHidden = document.getElementById("zoom").value;
	var params;
	if(str == 'save')
	{
		var keys = compPosition.listKeys();
		params ="action="+str+"&segment="+segmentname+"&total="+keys.length+"&zoom="+zoomHidden;
		for(var k=0;k<keys.length;k++)
		{
			var key = keys[k];
			var val = compPosition.get(key);
			params = params+"&key"+k+"="+key+"&val"+k+"="+val;
		}
	}
	else if (str == 'zoom')
	{
		params = "action="+str+"&segment="+segmentname+"&zoom="+zoomHidden;
	}
	else if(str == 'delete')
	{
		params = "action="+str+"&segment="+segmentname;
	}

	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status == 200) 
				{
					if(str == 'save')
					{
						//showDivs('positionDiv');
						Ext.Msg.alert("Segment","Component positions have been saved successfully");
					}
				}
				else 
				{
					Ext.Msg.alert("Segment","Error occured. Please try again ....");
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}
function showDivs(divId)
{
	var show_div = document.getElementById(divId);
	if(show_div!=null)
	{
		show_div.style.display = 'block';
		show_div.style.position = 'absolute';
		bringToFront(show_div);
	}
}

function resetPositions()
{
	var segmentname ='<%=segmentName%>';
	var site ='<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var zoom = document.getElementById('zoom').value;
	var isfull = '<%=isFull%>';
	var modify = '<%=modify%>';
	var zone = '<%=zone%>';
	var compname='<%=compname%>';
	var comptype='<%=comptype%>';
	var hlcomptype = '<%=hlc_type%>';	// High_Lighted_CompType
	var hlcomp = '<%=hlc%>';
	var enableDrag = '';
	if($j('#dragCheckbx').is(':checked'))
	{
		enableDrag = 'true';
	}
	else
	{
		enableDrag = 'false';
	}
	document.getElementById('container').style.height = documentView.getHeight()+"px";  
	document.getElementById('container').style.width = documentView.getWidth()+"px"; 
	var myUrl = "EgAutoTopologyMainPageExt.jsp?segment="+encodeURIComponent(segmentname)+"&default=true&zoom="+zoom+"&site="+encodeURIComponent(site)+"&physical_topology="+phyTopo+"&modify="+modify+"&zone="+zone+"&compname="+compname+"&comptype="+comptype+"&hlcomptype="+hlcomptype+"&hlcomp="+hlcomp+"&enableDrag="+enableDrag;
	
	if(isfull == 'true')
		myUrl = myUrl + "&view=full";
	//window.location.href = myUrl;
	setTimeout(function(){
		window.location = myUrl;
	}, 0);
}

function openBigDiv()
{
	var mySegment = '<%=segmentName%>';
	var site ='<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var zoom = document.getElementById('zoom').value;
	var isfull = '<%=isFull%>';
	var modify = '<%=modify%>';
	var zone = '<%=zone%>';
	var compname='<%=compname%>';
	var comptype='<%=comptype%>';
	var hlcomptype = '<%=hlc_type%>';	// High_Lighted_CompType
	var hlcomp = '<%=hlc%>';	
	var enableDrag = '';
	if($j('#dragCheckbx').is(':checked'))
	{
		enableDrag = 'true';
	}
	else
	{
		enableDrag = 'false';
	}
	var myUrl = "EgAutoTopologyMainPageExt.jsp?index=main&segment="+encodeURIComponent(mySegment)+"&view=full&site="+encodeURIComponent(site)+"&physical_topology="+phyTopo+"&modify="+modify+"&zone="+zone;//+"&compname="+compname+"&comptype="+comptype+"&hlcomptype="+hlcomptype+"&hlcomp="+hlcomp+"&enableDrag="+enableDrag;
	newwindow=window.open(myUrl,'Topology','width='+screen.width+',height='+screen.height+', status=yes,scrollbars=no,resizable=yes');
	if (window.focus) {newwindow.focus()}
		return false;
}

function EnableOrDisableDrag()
{
	var thiszone= document.getElementById("zone").value;
	var thissegment = document.getElementById("segment").value;
	var zoomValue = document.getElementById("zoom").value;
	var modify="<%=modify%>";

	if($j('#dragCheckbx').is(':checked'))
	{
		//document.getElementById('dragLink').innerHTML="Drag On";
		var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+zoomValue+"&enableDrag=true"+"&modify="+encodeURI(modify);
		setTimeout(function(){ window.location = myUrl;}, 0);
	}
	else
	{
		
		//hideDivs('toolsDiv');
		showDivs('alertSavePositionDiv');
		//document.getElementById('dragLink').innerHTML="Drag Off";
		//var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+zoomValue+"&enableDrag=false";
		//setTimeout(function(){ window.location = myUrl;}, 0);
	}
}

function hideAndRefreshDivs(divId)
{
	$j("#"+divId).hide("slow");
	var thiszone= document.getElementById("zone").value;
	var thissegment = document.getElementById("segment").value;
	var zoomValue = document.getElementById("zoom").value;
	var enableDrag = '';
	if($j('#dragCheckbx').is(':checked'))
	{
		enableDrag = 'true';
	}
	else
	{
		enableDrag = 'false';
	}
	var modify="<%=modify%>";
	var myUrl = "/final/admin/EgAutoTopologyMainPageExt.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&zoom="+zoomValue+"&modify="+encodeURI(modify); //+"&enableDrag="+enableDrag;
	setTimeout(function(){ window.location = myUrl;}, 0);
}

</script>
</head>
<%
	finalTopoStr = getTopologyString(segmentName , site , phyTopology);
	//out.println("finalTopoStr :"+finalTopoStr);
	if(finalTopoStr.trim().equals("="))
	{
		finalTopoStr="Web_site:egurkha.physical.topology=null";
		
	}
	//out.println(""+finalTopoStr);
	//finalTopoStr="Web_site:egurkha.physical.topology=null";
	String sessionString = (String) session.getAttribute("THISSEGMENT");
	if(sessionString!=null && sessionString.length() > 0){
		session.setAttribute("THISSEGMENT",finalTopoStr);
	}
	else{
		session.setAttribute("THISSEGMENT",finalTopoStr);
	}
	
	// For UNDO -------> Starts

	Hashtable grpCompHash = groupInfo.getGroupCompHash();
	Hashtable sessGrpCompHash = (Hashtable)session.getAttribute("GroupCompHashtable");
	session.setAttribute("sessionGroupTable",(Hashtable)sessGrpCompHash);
	session.setAttribute("GroupCompHashtable",(Hashtable)grpCompHash);
	
	String grpFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini";
	IniFile groupIni = new IniFile(grpFilePath);
	String zoneString="";
	if(isZone)
	{
		String[] zoneLines = groupIni.getLinesUnderSubject("ZONE_DETAILS");
		String[] sessZone = (String[])session.getAttribute("zoneLines");
		if(sessZone!=null)
		{
			StringBuffer result = new StringBuffer();
			for (int i = 0; i < sessZone.length; i++) {
				result.append( sessZone[i] );
				result.append(" ");
			}
			zoneString = result.toString();
		}
		session.setAttribute("zoneLines",(String[])zoneLines);
	}

	String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
	IniFile autoTopoIni = new IniFile(iniFilePath);
	String[] allLines = autoTopoIni.getLinesUnderSubject(segmentName);
	String asString="";
	String[] sesAllLines = (String[])session.getAttribute("AllLinesInSegment");
	if(sesAllLines!=null )
	{
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < sesAllLines.length; i++) {
			result.append( sesAllLines[i] );
			result.append(" ");
		}
		asString = result.toString();
	}

	if(sesAllLines!=null && sesAllLines.length > 0){
		isPreExists = true;
	}
	else{
		isPreExists = false;
	}

	session.setAttribute("AllLinesInSegment",allLines);
	
	// For UNDO --------> Ends

	ArrayList postionArrList = null;
	int divHeight = 100;
	int divWidth  = 100;
	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs =	iniUI.getValue("TOPOLOGY_OPTIONS","Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS","Column_space");
	int rowspace = 50;
	int colspace = 50;
	try{
		if(rs!=null) rowspace = Integer.parseInt(rs);
		if(cs!=null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
		rowspace = 50;
		colspace = 50;
	}
	//Get row & column spacing from eg_ui.ini .... (End)
	if(finalTopoStr!=null && finalTopoStr.trim().length() > 1)
	{
		EgNewTopology egNewTopo= new EgNewTopology(finalTopoStr,rowspace,colspace);
		postionArrList = egNewTopo.getOutputValues();
		divHeight = egNewTopo.getHeight();
		divWidth  = egNewTopo.getWidth();
		isEntry = true;
	}
	StringBuffer outPutBuffer = new StringBuffer();
	if(postionArrList!=null){
		outPutBuffer.append(postionArrList.toString().substring(1,postionArrList.toString().indexOf("]")));
	}
	

	////getting data from eg_lang_US.ini file
	//ArrayList tokeList = new ArrayList();
	//for(int i=0;i<postionArrList.size();i++)
	//{
		//String key =(String)postionArrList.get(i);
		
		//StringTokenizer tokenizer = new StringTokenizer(key,",");
		//String tokenVal=tokenizer.nextToken();
		//tokeList.add(tokenVal);
	//}
	//ArrayList keyList= new ArrayList();
	//for(int i=0;i<tokeList.size();i++)
	//{
		//String t_key=(String)tokeList.get(i);
		//String key = t_key.substring(0,t_key.indexOf("="));
		//keyList.add(key);
		
	//}

	//StringBuffer pnameBuffer = new StringBuffer();
	//ArrayList valueList = new ArrayList();
	//boolean isName = true;
	//String delim="";
	//String val="";
	//for(int i=1;i<keyList.size();i++)
	//{
		//delim="=";
		//String key1=(String)keyList.get(i);
		//String keyValue=key1.substring(0,key1.indexOf(":"));
		//String keyinValue="";
		//if(keyValue.indexOf("Agg_")==0)
		//{
			//keyinValue=keyValue.substring(4);
			
		//}
		//else
		//{
			//keyinValue=keyValue;
		//}
		//String value=_mapping.getComponentTypeDescription(keyinValue);
		
			//val+=(keyinValue+":"+value+""+delim);
		////delim="=";
		
	//}
	
	//valueList.add(val);
	
	//if(valueList.size()>0)
	//{
		
		//pnameBuffer.append(valueList.toString().substring(1,valueList.toString().indexOf("]")));
		
		//isName=true;
	//}
	//end
	boolean isName = true;
	String compCategoryMapping="";
	String pnameBuffer="";
	eGComponentCategory compCategoryObj = eGComponentCategory.getInstance();
	for(int i=0;i<postionArrList.size();i++)
	{
		String line=(String)postionArrList.get(i);
		StringTokenizer tokenizer = new StringTokenizer(line,",");
		String var=tokenizer.nextToken();
		if(var.startsWith("egurkha.physical.topology"))
			continue;
		String comp_Type=var.substring(0,var.indexOf(":"));
		String category  ="";
		if(comp_Type.equals("Group"))
		{
			category="group";
		}
		else if(comp_Type.endsWith("_ex"))
		{
			category = udTests.getValue("COMP_DISPLAYIMAGE_NICK",comp_Type);
		}
		else if(comp_Type.toLowerCase().startsWith("agg_"))
		{
			category="AGGREGATES";
		}
		else
		{
			category=compCategoryObj.getCategoryforCompType(comp_Type);
		}
		compCategoryMapping+=(comp_Type+":"+category+"=");
		if(comp_Type.indexOf("Agg_")==0)
		{
			comp_Type=comp_Type.substring(4);
		}
		String value=_mapping.getComponentTypeDescription(comp_Type);
		pnameBuffer+=(comp_Type+":"+value+"=");
		
	}
	if(compCategoryMapping.endsWith("="))
	{
		compCategoryMapping=compCategoryMapping.substring(0,compCategoryMapping.lastIndexOf("="));
	}
	if(pnameBuffer.endsWith("="))
	{
		pnameBuffer=pnameBuffer.substring(0,pnameBuffer.lastIndexOf("="));
	}
	
	// ...... List of new & unmanage components (Begin)...........................//
	TreeSet newCompList = new TreeSet();
	TreeSet unManageList = new TreeSet();
	StringBuffer newCompBuffer = new StringBuffer();
	StringBuffer unManageBuffer = new StringBuffer();
	if(isEntry)
	{
		Hashtable resultTable = getUnmanageAndNewComponents(segmentName);
		newCompList = (TreeSet) resultTable.get("NEW");
		unManageList = (TreeSet) resultTable.get("UNMANAGE");
		if(newCompList!=null && newCompList.size() > 0)
			newCompBuffer.append(newCompList.toString().substring(1,newCompList.toString().indexOf("]")));
		if(unManageList!=null && unManageList.size() > 0)
			unManageBuffer.append(unManageList.toString().substring(1,unManageList.toString().indexOf("]")));
	}
	// ...... List of new & unmanage components (End)...........................//

	String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";
%>

<input type="hidden" id="h_previous" name="h_previous" value="<%=isPreExists%>">
<input type="hidden" id="h_title" name="h_title" value="">
<input type="hidden" id="h_src" name="h_src" value="">
<input type="hidden" id="h_status" name="h_status" value="">
<input type="hidden" id="lorn" name="lorn" value="">
<input type="hidden" id="asString" name="asString" value="<%=asString%>">
<input type="hidden" id="zoneString" name="zoneString" value="<%=zoneString%>">
<input type="hidden" id="link" name="link" value="<%=link%>">
<input type="hidden" id="site" name="site" value="<%=site%>">


<!-- <body onLoad="javascript:pageHeightWidth();" onclick="javascript:hideDivs('menudiv');" > -->
<body style="overflow:hidden;"  class="adminTopologyBg">
<!---------------------POPUP MENU-------------------------->
<div id="menudiv" style="position:absolute;display:none;top:0px;left:0px;z-index:10000;" onmouseover="javascript:overpopupmenu=true;" onmouseout="javascript:overpopupmenu=false;">
<table border="0" style="width:120px;" class="tree_border" cellpadding="0" cellspacing="0">
	<tr>
		<td rowspan="5" width="16px" class="tree_bgimage"></td>
		<td>
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<tr id="manageRow" name="manageRow"  onclick="javascript:OpenManageDiv('single');">
					<td class="eg_treelink eg_whitebg tree_font" id="Manage" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);"><a class="eg_adminlink"><egui:intnl text="admin.server.Manage"/></a></td>
				</tr>
				<tr id="usesRow" name="usesRow"  onclick="javascript:OpenConnectUsesDiv('uses');">
					<td class="eg_treelink eg_whitebg tree_font" id="Uses"  onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);" ><a class="eg_adminlink"><egui:intnl text="admin.server.Uses"/></a></td>
				</tr>
				<tr id="connectRow" name="connectRow" onclick="javascript:OpenConnectUsesDiv('connect');">
					<td class="eg_treelink eg_whitebg tree_font" id="Connect" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);"> <a class="eg_adminlink"><egui:intnl text="admin.server.Connect"/></a></td>
				</tr>
				<tr id="removeRow" name="removeRow" onclick="javascript:RemoveFunction('remove');">
					<td class="eg_treelink eg_whitebg tree_font" id="Remove" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);" ><a class="eg_adminlink"><egui:intnl text="admin.server.Remove"/></a></td>
				</tr>
				<tr id="groupRow" name="groupRow" onclick="javascript:ShowGroupDetails();">
					<td class="eg_treelink eg_whitebg tree_font" id="Group" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);" ><a class="eg_adminlink"><egui:intnl text="admin.server.Details"/></a></td>
				</tr>
				<tr id="groupCreate" name="groupCreate" onclick="javascript:createGroup();">
					<td class="eg_treelink eg_whitebg tree_font" id="GCreate" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);" > <a class="eg_adminlink"><egui:intnl text="admin.server.Group"/></a></td>
				</tr>
				<tr id="unGroup" name="unGroup" onclick="javascript:unGroup();">
					<td class="eg_treelink eg_whitebg tree_font" id="uGroup" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);" > <a class="eg_adminlink"><egui:intnl text="admin.server.Ungroup"/></a></td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>

<div id="toolsDiv" name="toolsDiv" style="display:none;left:805px;top:33px;position:absolute;border:0px solid #ff0000;z-index:500;" onmouseover="javascript:overpopupmenu=true;" onmouseout="javascript:overpopupmenu=false;">
<table border="0" style="width:160px;" class="tree_border" cellpadding="0" cellspacing="0">
	<tr>
		<td rowspan="4" width="16px" class="tree_bgimage"></td>
		<td>
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<tr onclick="javascript:OpenManageAllDiv('all');">
					<td class="eg_treelink eg_whitebg tree_font" id="Manageall" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);"> <a class="eg_adminlink"><egui:intnl text="admin.server.Manage all"/></a> </td>
				</tr>
				<tr onclick="javascript:OpenManageAllDiv('save');">
					<td class="eg_treelink eg_whitebg tree_font" id="Uses" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);"><a class="eg_adminlink"><egui:intnl text="admin.server.Save topology"/></a></td>
				</tr>
				<tr onclick="javascript:OpenManageAllDiv('saveAs');">
					<td class="eg_treelink eg_whitebg tree_font" id="Uses" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);"><a class="eg_adminlink"><egui:intnl text="admin.server.Save topology as"/></a></td>
				</tr>
				<tr>
					<td class="eg_treelink" height="2px"><hr></td>
				</tr>
				<tr onclick="javascript:refreshPage();">
					<td class="eg_treelink eg_whitebg tree_font" id="Refresh" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);"><a class="eg_adminlink"><egui:intnl text="admin.server.Refresh"/></a></td>
				</tr>
				<tr onclick="javascript:RemoveFunction('clearall');">
					<td class="eg_treelink eg_whitebg tree_font" id="Refresh" onmouseover="javascript:overImage(this);" onmouseout="javascript:outImage(this);"><a class="eg_adminlink" ><egui:intnl text="admin.server.Clear all"/></a></td>
				</tr>
				<tr>
					<td class="eg_treelink" height="2px"><hr></td>
				</tr>
				<tr id="dragRow">
					<%
						String checked="";
						String dragString="Drag On";
						if(dragEnabled)
						{
							checked="checked";
						}
					%>
					<td class="eg_treelink eg_whitebg tree_font" id="Drag">
						<egui:intnl text='<%="admin.common."+dragString%>'/>
						<input type="checkbox" id="dragCheckbx" name="dragCheckbx" onclick="javascript:EnableOrDisableDrag();" <%=checked%>/>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>


<!-- Legend DIV  -->
<%
	//if(!isFull)
	{
%>
<div id="legendDiv" name="legendDiv" style="visibility:visible;display:block;left:180px;top:8px;width:520px; position:absolute;z-Index:100;padding:4px" class="font_normal11 linesquare eg_subheadbg">
	<div style="float:left;margin-right:10px;"><img src="/final/admin/eg_images/icon_new_component.png;" style="vertical-align:middle" hspace="4px"><egui:intnl text="admin.server.Discovered Component"/></div>

	<div style="float:left;margin-right:10px"><img src="/final/admin/eg_images/icon_unmanaged_component.png" style="vertical-align:middle" hspace="4px"><egui:intnl text="admin.server.Unmanaged Component"/></div>

	<!--<div style="float:left;margin-right:10px"><img src="/final/admin/eg_images/icon_managed_component.png" style="vertical-align:middle" hspace="4px"><egui:intnl text="admin.server.Managed Component"/></div>-->

	<div style="float:left;margin-right:10px"><img src="/final/admin/eg_images/icon_recently_component.png" style="vertical-align:middle" hspace="4px"><egui:intnl text="admin.server.Recently Added"/></div>
</div>
<%
	}
%>
<div id="positionDiv" name="positionDiv" style="display:none;right:30px;top:45px;width:300px;height:50px;border:0px solid #ff0000; position:absolute;">
	<table  border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve" ><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
			<td class="eg_whitebg" align="center">
				<div style="height:50px;border:1px solid black;">
					<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%">
						<tr>
						<td align="center" nowrap valign="top"  style="padding:4px"><egui:intnl text='admin.zone.Component positions have been saved successfully'/><br>
						</td>
						</tr>
						<tr align="center">
							<td><input type="button" class="eg_lightbutton" name="okButton" id="okButton" value=" OK " onclick="javascript:hideAndRefreshDivs('positionDiv');"style="padding-left:4px;padding-right:4px"></td>
						</tr>
					</table>
				</div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>


<div id="alertSavePositionDiv" name="alertSavePositionDiv" style="display:none;right:30px;top:45px;width:300px;height:100px;border:0px solid #ff0000; position:absolute;">
	<table  border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve" ><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
			<td class="eg_whitebg" align="center">
				<div style="height:50px;border:1px solid black;">
					<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%">
						<tr>
							<td align="center" nowrap valign="top" style="padding:4px" ><egui:intnl text='admin.zone.Do you want to save the component position?'/><br>
							</td>
						</tr>
						<tr align="center">
							<td><input type="button" class="eg_lightbutton" name="okButton" id="okButton" value=" SAVE " onclick="javascript:savePositions('save');javascript:hideDivs('alertSavePositionDiv');">
							<input type="button" class="eg_lightbutton" name="cancelButton" id="cancelButton" value=" CANCEL " onclick="javascript:hideAndRefreshDivs('alertSavePositionDiv');">
							</td>
						</tr>
					</table>
				</div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>


<div id="mainDiv" name="mainDiv">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
	<input type="hidden" id="zone" name="zone" value="<%=zone%>">
	<input type="hidden" id="segment" name="segment" value="<%=segmentName%>">
	<tr>
		<td width="100%" align="center" height="100%" valign="top" >
			<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" >
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
							
							<tr>
								<td class="topoBg linesquare" >
									<div id="container" class="div_scroll" style="width:100%;height100%;border:0px solid red;overflow:auto">

<%
	//isEntry=true;							
								
	if(isEntry)
	{
%>
										<div id="paper" name="paper" style="width:100%;height:100%;z-index:10;border:0px solid green;">
										
										</div>
<script type="text/javascript">

   //disable right click
    
//end 
var zom = parseInt('<%=zoomLevel%>')/100;
//document.getElementById('container').style.width = documentView.getWidth()+"px";  
//document.getElementById('container').style.height = documentView.getHeight()+"px";  

//var width = 1265;
//var height = 865;
//var width = screen.width;
//var height = screen.height;

var width = 916;
var height = 520;

var gifWidth = 48*zom;
var gifHeight = 48*zom;
var userWidth = 48*zom;
var userHeight = 48*zom;
var newWidth = 19*zom;
var newHeight =  18*zom;
var rectShape ='';

var el;
var newUnmanageMap = new Map;
var compPosition = new Map;
var connectionArr = new Array();
var eGComps = new Array();
//var stateCircles = new Array();
var allCompNames = new Array();
var newUnmanageLables = new Array();
var compLables = new Map();

var compIndexMap = new Map();
var topostring ='<%=finalTopoStr%>';
var sessionstring = '<%=sessionString%>';
var positionString ='<%=outPutBuffer%>';
var newcompstring = '<%=newCompBuffer%>';
var unmanagerstring ='<%=unManageBuffer%>';
var isFlag ='<%=isRecflag%>';
var comparisonString ='<%=comparisonString%>';
var iniMaxW = 0;
var iniMaxH = 0;
// addding

var egtop_iniMap = new Map();
var alltpNames = new Array();
//end
//r = Raphael("paper", width, height);
r = Raphael("paper", width, height);
r.initZoom();
var compCategoryMapping='<%=compCategoryMapping%>';
var compGroupMap = new Map();
r.customAttributes.CompType = function (compType) {
		return {CompType : compType};
};
//Zoom supports from 10% to 150%
function setZoomLevel(zoomHidden)
{
	var zInt = parseInt(zoomHidden);
	zInt = zInt.toFixed();
	document.getElementById("zoom").value = zInt;
	setZoom(zInt / 100);
	savePositions("zoom");
}

function setZoom(zoom)
{
	var holderDiv = document.getElementById("paper");
	var holderH = document.getElementById("paper").clientHeight;
	var holderW = document.getElementById("paper").clientWidth;
	zom = zoom;
	var regW = holderW>iniMaxW?holderW:iniMaxW;
	var regH = holderH>iniMaxH?holderH:iniMaxH;
	//if(regW < 916) regW = 916;
	if(regW < 916) regW = 850;
	//if(regH < 512) regH = 512;
	if(regH < 512) regH = 320;
	var winHeight='';
	if('<%=isFull%>' == 'true')
	{
		winHeight = documentView.getHeight()- 10;
	}
	else
	{
		winHeight = documentView.getHeight()- 60;
	}
	var winWidth = documentView.getWidth()- 8;

	if(regH < winHeight)
		regH = winHeight;
	if(regW < winWidth)
		regW = winWidth;
	holderDiv.style.width = regW;
	holderDiv.style.height = regH;
	if(zoom <=1)
	{
		r.setSize(regW, regH);
	}
	else
	{
		r.setSize(1.2*regW*zoom,regH*zoom);
	}
	r.setZoom(zoom);
	
	if(parent.document.getElementById("zoomValue")!=null)
		parent.document.getElementById("zoomValue").value= (zom * 100).toFixed();
	
}

setZoom(zom);

function resizePaperDiv(w, h)
{
	
	var intW = w;
	var intH = h;
	var resize = "false";
	var holderDiv = document.getElementById("paper");
	var holderH = document.getElementById("paper").clientHeight;
	var holderW = document.getElementById("paper").clientWidth;
	if(intW > 916){
		resize = "true";
	}
	else{
		intW = 850;
	}

	if(intH > 520){
		resize ="true";
	}
	else{
		intH = 320;
	}
	var winHeight='';
	if('<%=isFull%>' == 'true')
	{
		winHeight = documentView.getHeight()- 10;
	}
	else
	{
		winHeight = documentView.getHeight()- 60;
	}
	var winWidth = documentView.getWidth()- 8;
	if(intH < winHeight)
		intH = winHeight;
	if(intW < winWidth)
		intW = winWidth;
	if(resize == "true"){
		r.setSize(intW*zom,intH*zom);
	}
}

function getMapDetails(posString, newcomString, unmanageString)
{
	
	var changeHeight = '<%=divHeight%>';
	var changeWidth = '<%=divWidth%>';
	var intW = parseInt(changeWidth);
	var intH = parseInt(changeHeight);
	resizePaperDiv(intW, intH);
	
	// Get Positions from ini File (Begin) , if it is already saved.
	var position = '<%=isPosition%>';
	var iniPositionArr = new Array();
	var iniMap = new Map();
	if(position == 'true')
	{
		var allvec = '<%=positionBuffer.toString()%>';
		iniPositionArr = allvec.split(", ");
	}

	for(var i=0; i<iniPositionArr.length;i++)
	{
		var arrElement =  iniPositionArr[i];
		var iniMapKey =  arrElement.substring(0,arrElement.indexOf("="));
		var iniMapValue = arrElement.substring(arrElement.indexOf("=")+1);
		iniMap.put(iniMapKey,iniMapValue);
	}
	// Get Positions from ini File (End)  
	//adding Data
		
		var isname = '<%=isName%>';
		var inidataArr = new Array();
		if(isname=='true')
		{
			var positionName = '<%=pnameBuffer.toString()%>';
			inidataArr=positionName.split("=");
		}
		for(var i=0;i<inidataArr.length;i++)
		{
			var arrElement =  inidataArr[i];
			
			var iniMapKey =  arrElement.substring(0,arrElement.indexOf(":"));
			var iniMapValue = arrElement.substring(arrElement.indexOf(":")+1);
			
			egtop_iniMap.put(iniMapKey,iniMapValue);
			
			
		}
	//end
	var compGrpArr = new Array();
	if(compCategoryMapping!=null )
	{
		compGrpArr=compCategoryMapping.split("=")
		for(var i=0;i<compGrpArr.length;i++)
		{
			var arrElement =  compGrpArr[i];
			var iniMapKey =  arrElement.substring(0,arrElement.indexOf(":"));
			var iniMapValue = arrElement.substring(arrElement.indexOf(":")+1);
			compGroupMap.put(iniMapKey,iniMapValue);
		}
	}
	//Store new comp details ....(Begin)
	if(newcomString!=null && newcomString.length > 0)
	{
		var tmptokens = newcomString.split(", ");
		for(var i=0; i<tmptokens.length;i++)
		{
			var tokvalue = tmptokens[i];
			newUnmanageMap.put(tokvalue,"NEW");
		}
	}
	//Store new comp details ....(End)
	//Store UnManager Comp Details (Start)
	if(unmanageString!=null && unmanageString.length > 0)
	{
		var tmptokens = unmanageString.split(", ");
		for(var i=0; i<tmptokens.length;i++)
		{
			var tokvalue = tmptokens[i];
			newUnmanageMap.put(tokvalue,"UNMANAGE");
		}
	}
	//Store UnManager Comp Details (End)

	var tokens = posString.split(", ");
	var compInd = 0;
	var resize = "false";
	iniMaxW = intW;
	iniMaxH = intH;

	for(var i=0; i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var key = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);

		if(key.indexOf(":")==0){
			key = 'egurkha.physical.topology';
		}
		if(iniMap.contains(key)) // Load Position from INI File......
		{
			var iniXY  = iniMap.get(key);
			var iniX = parseInt(iniXY.substring(0,iniXY.indexOf("#")));
			var iniY = parseInt(iniXY.substring(iniXY.indexOf("#")+1));

			if(iniX >= iniMaxW)
			{
				resize = "true";
				iniMaxW = iniX + 200;
			}

			if(iniY >=iniMaxH)
			{
				resize = "true";
				iniMaxH = iniY + 100;
			}
			
			if(key == 'egurkha.physical.topology') // User Image
			{
				eGComps.push(r.image('<%=contextPath%>'+'user_image.png', iniX*zom, iniY*zom , userWidth , userHeight).attr({"CompType":"user_image",title :"User"}));
				compPosition.put(key,iniX*zom+"#"+iniY*zom);
			}
			else	// Other components....
			{
				var comptype = key.substring(0,key.indexOf(":")); 
				var compCategory=compGroupMap.get(comptype);
				var comptip = key.substring(key.indexOf(":")+1);
				if(comptip.indexOf(":NULL")>0)
					comptip = comptip.substring(0,comptip.indexOf(":NULL"));
				var compImage="";
				if(comptype!=null && (comptype.match("_ex$")=="_ex" || (comptype.indexOf("Agg_")==0)))
				{
					if(comptype == 'Group')
					{	
						compImage = r.image('<%=contextPath1%>'+'group.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
					//else if(comptype.indexOf("Agg_")==0)
					//{
						//compImage = r.image('<%=contextPath%>'+'aggregate.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({title : comptip});
					//}
					else if(comptype.match("_ex$")=="_ex")
					{
						compImage = r.image('<%=ICImagePath%>'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
					else
					{
						compImage = r.image('<%=contextPath%>'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
				}
				else
				{
					if(comptype == 'Group')
						compImage = r.image('<%=contextPath1%>'+'group.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					else
						compImage = r.image('<%=contextPath%>'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
				}
				eGComps.push(compImage);
				compPosition.put(key, iniX*zom+"#"+iniY*zom);
			}
		}
		else
		{
			if(key == 'egurkha.physical.topology') //User
			{
				var xy = rhs;
				var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
				var yPos = parseInt(xy.substring(xy.indexOf("#")+1));

				var userImage = r.image('<%=contextPath%>'+'user_image.png', xPos*zom, yPos*zom , userWidth , userHeight).attr({"CompType":"user_image",title :"User"});

				//If User is highlighted , Draw BOX .... (Begin)
				if('<%=hlc_type%>' == 'user_image' && '<%=hlc%>' == 'User')
				{
					rectShape = r.rect (userImage.attr("x")-5*zom, userImage.attr("y")-5*zom, userImage.attr('width')+10*zom,userImage.attr('height')+5*zom).attr({
						"stroke-width": 2, 
						"stroke" : '#<%=dark%>'
					});
				}
				//If User is highlighted , Draw BOX .... (End)
				eGComps.push(userImage);
				//stateCircles.push("egurkha.physical.topology");
				//allCompNames.push("egurkha.physical.topology");
				compPosition.put(key, xPos*zom+"#"+yPos*zom);
			}
			else
			{
				var xy = rhs;
				var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
				var ystate = xy.substring(xy.indexOf("#")+1);
				var yPos = parseInt(ystate.substring(0,ystate.indexOf("#")));
				var state = xy.substring(xy.lastIndexOf("#")+1);

				var comptype = key.substring(0,key.indexOf(":")); 
				var compCategory=compGroupMap.get(comptype);
				var comptip = key.substring(key.indexOf(":")+1);
				if(comptip.indexOf(":NULL")>0)
					comptip = comptip.substring(0,comptip.indexOf(":NULL"));

				var coX = xPos*zom;
				var coY = yPos*zom;
				var compImage='';
				// Component Image (Begin)
				if(comptype == 'Group')
				{
						compImage = r.image('<%=contextPath1%>'+'group.png', coX, coY , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
				}
				//else if(comptype.indexOf("Agg_")==0)
				//{
					//compImage = r.image('<%=contextPath%>aggregate.png', coX, coY , gifWidth , gifHeight).attr({title : comptip});
				//}
				else if(comptype.match("_ex$")=="_ex")
				{
					compImage = r.image('<%=ICImagePath%>'+compCategory+'.png', coX, coY , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
				}
				else
				{
					compImage = r.image('<%=contextPath%>'+compCategory+'.png', coX, coY , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
				}
				//If this is highlighted comp, Draw BOX .... (Begin)
				if('<%=hlc_type%>' == comptype && '<%=hlc%>' == comptip)
				{
					rectShape = r.rect (compImage.attr("x")-5*zom, compImage.attr("y")-5*zom, compImage.attr('width')+10*zom,compImage.attr('height')+5*zom).attr({
						"stroke-width": 2, 
						"stroke" : '#<%=dark%>'
					});
				}
				//If this is highlighted comp, Draw BOX .... (End)
				eGComps.push(compImage);
				// Component Image (End)

				// State Image (Begin)
				
				compPosition.put(key, xPos*zom+"#"+yPos*zom);
				// State Image (End)

				//Component Name (Begin)
				var textstr = comptip;
				if(comptip.length > 22)
				{
					var mid ;
					if(textstr.length % 2 == 0)
						mid = textstr.length / 2;
					else
						mid = (textstr.length + 1) / 2;
					textstr = comptip.substring(0,mid)+"\n"+comptip.substring(mid);
				}
				var tX = parseInt(coX);
				var tY = parseInt(coY);
				
			}
		}
		compIndexMap.put(key,compInd);
		compInd = compInd + 1;
	}

	if(resize == "true"){
		resizePaperDiv(iniMaxW, iniMaxH);
	}
	// Creating connections between components.......
	createConnections(topostring);
	//setZoomLevel('1');
	//setZoomLevel('-1');
}

function createConnections(topostr)
{
	var tokens = topostr.split("|");
	for(var i = 0;i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var lhs = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);
		var key = lhs;

		if(i==0){
			key = "egurkha.physical.topology";
		}
		var lhsInd = compIndexMap.get(key);
		if(rhs != 'null')
		{
			var rhsArr = rhs.split(",");
			for(var j=0;j<rhsArr.length;j++)
			{
				var element = rhsArr[j];
				element = element.substring(0,element.lastIndexOf(":"));
				var LorN = element.substring(element.lastIndexOf(":")+1);
				element = element.substring(0,element.lastIndexOf(":"));
				var elementInd = compIndexMap.get(element);
				connectionArr.push(lhsInd+":"+LorN+">"+elementInd);
			}
		}
	}
}

function drawComponents(){
	return this.eGComps;
}
function drawimgNames ()
{
	return alltpNames;
}

window.onload = mainFunction;

function mainFunction ()
{
	if("<%=isEntry%>" == "true")
	{
		getMapDetails(positionString, newcompstring, unmanagerstring);
		var key;
		var thisIndex;
		var statesrc;
		var newUnmanageSrc;
		var newUnmanageLabelMap = new Map();

		if("<%=dragEnabled%>" == "true")
		{
			var dragger = function () {
								//alert(this.attr("src")+"   "+this.attr("title"));
								var src = this.attr("src");
								var title = this.attr("title");
								if(title.indexOf(":") < 0)
								{
									title = title+":NULL";
								}
								if (src.indexOf(".gif")>0)
									src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".gif"));
								else if (src.indexOf(".png")>0)
									src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".png"));

								if(src == 'user_image')
									key ="egurkha.physical.topology";
								else
									key = src+":"+title;
								thisIndex = compIndexMap.get(key);

								if(this.type == "image")
								{
									this.ox = this.attr("x");
									this.oy = this.attr("y");
								}
								if(thisIndex >0)
								{
									statesrc = stateCircles[thisIndex].attr('src');
									stateCircles[thisIndex].remove();
									compNames[thisIndex].remove();
									
									var value = compLabelMap.get(key); // Key:Raphael Object
									var newUnArray = new Array();
									if(value!=undefined)
									{
										for(var k=0;k<value.length;k++)
										{
											var imgObj = value[k];
											newUnmanageSrc = imgObj.attr('src');
											
											newUnArray.push(newUnmanageSrc);
											newUnmanageLabelMap.put(key,newUnArray); // Key:image Name
											imgObj.remove();
											//newImage[k].remove();
										}
										
									}
									
									if(rectShape!='')
										rectShape.remove();
								}
			},
			move = function (dx, dy) {
									if(this.type == "image")
									{
										var att =  {x: this.ox + dx, y: this.oy + dy};
										this.attr(att);
									}
									for (var i = connections.length; i--;) {
										r.connection('#<%=color%>',connections[i]);
									}
									r.safari();
			},
			up = function () {
							compPosition.put(key,this.attr("x")+"#"+this.attr("y"));
							if(key!="egurkha.physical.topology")
							{
								stateCircles[thisIndex] = r.image(statesrc,this.attr("x"),this.attr("y"),50*zom,50*zom);
								stateCircles[thisIndex].toBack();
								var textstr = this.attr("title");
								if(textstr.length > 15)
								{
									var mid ;
									if(textstr.length % 2 == 0)
										mid = textstr.length / 2;
									else
										mid = (textstr.length + 1) / 2;
									textstr = textstr.substring(0,mid)+"\n"+textstr.substring(mid);
								}
								compNames[thisIndex] = r.text(this.attr("x")+20*zom ,this.attr("y") + 60*zom , textstr).attr({"font-size" : 11*zom});
								var mapValue = newUnmanageLabelMap.get(key);
								if(mapValue!=undefined && mapValue!=null)
								{
									var arrValue = new Array();
									for(var k=0;k<mapValue.length;k++)
									{
										var link = mapValue[k];
										if(link=='<%=contextPath%>'+'icon_new_component.png')
										{
											newImage[k] = r.image(link,this.attr("x")-5*zom,this.attr("y")-8*zom,newWidth,newHeight);
										}
										else if(link=='<%=contextPath%>'+'icon_unmanaged_component.png')
										{
											newImage[k] = r.image(link,this.attr("x"),this.attr("y")+22*zom,newWidth,newHeight);
										}
										else if(link=='<%=contextPath%>'+'icon_recently_component.png')
										{
											newImage[k] = r.image(link,this.attr("x")+30*zom,this.attr("y")-8*zom,newWidth,newHeight);
										}
										arrValue.push(newImage[k]);
									}
									compLabelMap.put(key,arrValue);
								}
								
								if(rectShape!='')
								{
									/*rectShape.remove();
									rectShape.toBack();
									rectShape = r.rect (this.attr("x")-5*zom, this.attr("y")-5*zom, this.attr('width')+10*zom,this.attr('height')+5*zom).attr({
										"stroke-width": 2, 
										"stroke" : '#<%=dark%>'
									});*/
								}

							}
							beatFunction(shapes, compNames , thisIndex,connections);
			},

			connections = [],
			shapes = drawComponents(),
			stateCircles = drawStateCircles(),
			compNames = drawCompNames(),
			newImage = drawNewLabels(),
			compLabelMap = getCompLabels();
			
			var menu = showExtMenu();
			for (var i = 0, ii = shapes.length; i < ii; i++){
				//beatFunction(shapes, i, connections, compNames);
				/*shapes[i].hover(function () {
				this.stop().animate({'scale' : '1.2 1.2'}, 500);
				},  function () {
					this.stop().attr({'scale' : '1 1'});
				});*/
				shapes[i].attr({cursor: "move"});
				shapes[i].drag(move, dragger, up);
				beatFunction(shapes, compNames, i, connections,menu);
			}

			for(var k=0;k<connectionArr.length;k++)
			{
				var link = connectionArr[k];
				var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
				var ind1 = link.substring(0,link.indexOf(":"));
				var ind2 = link.substring(link.indexOf(">")+1);
				connections.push(r.connection('#<%=color%>',shapes[ind1], shapes[ind2], "#<%=color%>","#<%=color%>|1",lorn)); 
			}
		}
		else
		{
			var menu = showExtMenu();
			var connections = [],
			shapes = drawComponents(),
			stateCircle = drawStateCircles(),
			compNames = drawCompNames(),
			newImage = drawNewLabels();
			for (var i = 0, ii = shapes.length; i < ii; i++){
				beatFunction(shapes, compNames ,i, connections,menu );
				/*shapes[i].hover(function () {
				this.stop().animate({'scale' : '1.2 1.2'}, 500);
				},  function () {
					this.stop().attr({'scale' : '1 1'});
				});*/
			}

			for(var k=0;k<connectionArr.length;k++)
			{
				var link = connectionArr[k];
				var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
				var ind1 = link.substring(0,link.indexOf(":"));
				var ind2 = link.substring(link.indexOf(">")+1);
				connections.push(r.connection('#<%=color%>',shapes[ind1], shapes[ind2], "#<%=color%>","#<%=color%>|1",lorn)); 
			}
		}
	}
	pageHeightWidth();
}

function beatFunction(shapesObj,compNamesObj, index, connectionObj,menu)
{
	shapesObj[index].mouseover (function (event) {
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					//connectionObj[k].line.toFront();
					//connectionObj[k].tri.toFront();
					connectionObj[k].line.animate({'stroke' : '#<%=dark%>', 'stroke-width' : 2*zom},500);
					connectionObj[k].tri.animate({'stroke' : '#<%=dark%>','fill' : '#<%=dark%>', 'stroke-width' : 2*zom},500);
				}
			}
		}
	});

	shapesObj[index].mouseout (function (event){
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					//connectionObj[k].line.toBack();
					//connectionObj[k].tri.toBack();
					connectionObj[k].line.animate({'stroke' : '#<%=color%>', 'stroke-width' : 1*zom},500);
					connectionObj[k].tri.animate({'stroke' : '#<%=color%>','fill' : '#<%=color%>', 'stroke-width' : 1*zom},500);
				}
			}
		}
	});

	shapesObj[index].mousedown (function (event){
		
		var isShow = false;
		var isDiv = false;
		var browser = navigator.appName;
		//$j("#menudiv").hide("slow");
		if(browser == "Microsoft Internet Explorer"){		// Browser	Left Click	Middle Click	Right Click
			if(event.button == 2)							// Firefox		0			1				2
				isShow = true;								//	IE			1			4				2
			else if(event.button == 1)
				isDiv = true;
		}
		else{
			if(event.button == 2)
				isShow = true;
			else if(event.button == 0)
				isDiv = true;
		}
		//var src = this.attr("src");
		var src = this.attr("CompType");
		var title = this.attr("title");
		var status ="MANAGED";
		//if(isShow || isDiv)
		//{
			if(src.indexOf("Unknown_server") < 0){
				var comptype = '';
				//if (src.indexOf(".gif")>0)
					//first = src.substring(src.lastIndexOf("/")+1,src.indexOf(".gif"));
				//else if (src.indexOf(".png")>0)
				//{
					//first = src.substring(src.lastIndexOf("/")+1,src.indexOf(".png"));
				//}
				first =src;
				var second = title;
				if(title.indexOf(":") < 0)
					second = second+":"+"NULL";
				var key = first +":"+ second;
				var newstr = newUnmanageMap.get(key);
				if(newstr!=null)
				{
					if(newstr == 'NEW')
					{
						status = "NEW";
					}
					else if(newstr == 'UNMANAGE')
					{
						status = "UNMANAGE";
					}
				}
			}
			else{
				status ="UNKNOWN";
			}
			document.getElementById('h_title').value = title;
			document.getElementById('h_src').value = src;
			document.getElementById('h_status').value = status;
			
			if(title == 'User')
				status = "User";
		//}

		if("<%=dragEnabled%>" == "false" && '<%=isFull%>' == 'false'){
			if(rectShape!='')
				rectShape.remove();
			rectShape = r.rect (this.attr("x")-5*zom, this.attr("y")-5*zom, this.attr('width')+10*zom,this.attr('height')+5*zom).attr({
				"stroke-width": 0, 
				"stroke" : '#<%=dark%>'
			});
			rectShape.toBack();
			if(isShow){
				//ItemSelMenu(event, status);
			}
			//var p_link = $j("#lorn").attr("value");
			//OpenConnectUsesDiv(p_link);

			//Ext Js
			//Ext.getCmp('ExtMenu').setVisible(true);
			Ext.each(shapesObj[index], function(raphaelElement) 
			{
				Ext.fly(raphaelElement.node).on('click',function(e) 
				{
					window.parent.nameCheck();
					e.stopEvent();
					menu.showAt(e.getXY());
					Ext.getCmp('ExtMenu').setHeight(130);
					if(status == "NEW" || status == "UNMANAGE")
					{
						Ext.getCmp('ExtMenu').setHeight(150);
						Ext.getCmp('grouprow').setVisible(false);
						Ext.getCmp('ungrouprow').setVisible(false);
						
						if(!Ext.getCmp('usesrow').isVisible()) 
							Ext.getCmp('usesrow').setVisible(true);
						if(!Ext.getCmp('removerow').isVisible()) 
							Ext.getCmp('removerow').setVisible(true);
						if(!Ext.getCmp('managerow').isVisible()) 
							Ext.getCmp('managerow').setVisible(true);
						if(!Ext.getCmp('groupcreate').isVisible()) 
							Ext.getCmp('groupcreate').setVisible(true);
					}
					else if(status == "MANAGED")
					{
						Ext.getCmp('managerow').setVisible(false);
						Ext.getCmp('groupcreate').setVisible(false);
						if(!Ext.getCmp('usesrow').isVisible()) 
							Ext.getCmp('usesrow').setVisible(true);
						if(!Ext.getCmp('removerow').isVisible()) 
							Ext.getCmp('removerow').setVisible(true);

						//If the component is Group
						if(raphaelElement.attr('src').indexOf("group.png") > 0){
							Ext.getCmp('grouprow').setVisible(true);
							Ext.getCmp('ungrouprow').setVisible(true);
							Ext.getCmp('ExtMenu').setHeight(150);
						}
						else{
							Ext.getCmp('grouprow').setVisible(false);
							Ext.getCmp('ungrouprow').setVisible(false);
							if(!Ext.getCmp('groupcreate').isVisible()) 
								Ext.getCmp('groupcreate').setVisible(true);
						}
					}
					else if(status == "User"){
						Ext.getCmp('usesrow').hide();
						Ext.getCmp('removerow').hide();
						Ext.getCmp('managerow').hide();
						Ext.getCmp('grouprow').hide();
						Ext.getCmp('ungrouprow').hide();
						Ext.getCmp('groupcreate').hide();
						Ext.getCmp('ExtMenu').setHeight(50);
					}
				});
			});
		}
	});

}

//EXTJS Menu
function showExtMenu()
{
	var menu = Ext.create('Ext.menu.Menu', {
            width: 150,
            height: 130,
            margin: '0 0 0 0',
            floating: true,  // usually you want this set to True (default)
           // renderTo: Ext.getBody(),  // usually rendered by it's containing component
			id:'ExtMenu',
			//z-index:10,
			hidden:true,
            items: [
				{
					id:'managerow',
					text:'Manage',
					hidden:true,
					handler:OpenManageSingleDiv
				},
				{
					id:'usesrow',
                    text: 'Uses',
					handler: OpenUsesDivForParam
				},
				{
					id:'connectsrow',
					text: 'Connects',
					handler: OpenConnectsDivForParam
				},
				{
					id:'removerow',
                    text: 'Remove',
					handler: MyRemoveFunction
				}
					,
				{
					id:'grouprow',
                    text: 'Details',
					handler: ShowGroupDetails
				},
				{
					id:'groupcreate',
                    text: 'Add To Group',
					handler: createGroup
				},
				{
					id:'ungrouprow',
					text:'Ungroup',
					handler: unGroupFunction
				}
			]
    }); 
	return menu;
}
function onItemClick()
{
	Ext.getCmp('managerow').setVisible(true);
}

function OpenConnectsDiv()
{
	Ext.getCmp('managerow').setVisible(true);
}

function drawCompNames (){
	return allCompNames;
}
function drawimgNames ()
{
	return alltpNames;
}
function getCompLabels(){
	return compLables;
}

function drawStateCircles()
{
	var cirArr = new Array();
	
	var keys = compPosition.listKeys();
	for(var k=0;k<keys.length;k++)
	{
		if(k==0)
		{
			cirArr.push("egurkha.physical.topology");
			allCompNames.push("egurkha.physical.topology");
			alltpNames.push("egurkha.physical.topology");
			continue;
		}
		var key = keys[k];
		var val = compPosition.get(key);
		var xpoint = parseInt(val.substring(0,val.indexOf("#")));
		var ypoint = parseInt(val.substring(val.indexOf("#")+1));

		//var scir = r.image('<%=contextPath%>'+'server_gray.png',xpoint,ypoint,gifWidth,gifHeight);
		
		//scir.toBack();
		//cirArr.push(scir);
		var isnew = newUnmanageMap.get(key);
		if(isnew!=null)
		{
			if(isnew == "NEW"){
				var newimg = r.image('/final/admin/eg_images/'+'icon_new_component.png',xpoint-5*zom,ypoint-8*zom,newWidth,newHeight);
				newUnmanageLables.push(newimg);
				
				var add = new Array();
				add.push(newimg);
				compLables.put(key,add);
			}
			else if(isnew == "UNMANAGE"){
				var unmanageimg = r.image('/final/admin/eg_images/'+'icon_unmanaged_component.png',xpoint,ypoint+22*zom,newWidth,newHeight)
				newUnmanageLables.push(unmanageimg);

				var add = new Array();
				add.push(unmanageimg);
				compLables.put(key,add);
			}			
		}
		else
		{
			newUnmanageLables.push("noimg");
		}
		var latest = "";
		//if(sessionstring.indexOf(key) < 0)
		if(comparisonString != null && comparisonString.indexOf(key) > -1 && isFlag)
		{
			if("<%=modifySegment%>" == "false" || "<%=fromAutoCompType%>" == "true")
			{
				latest = r.image('/final/admin/eg_images/'+'icon_recently_component.png',xpoint+30*zom,ypoint-8*zom,newWidth,newHeight);
				newUnmanageLables.push(latest);
				
				value = compLables.get(key);
				if(value!=undefined && value!=null)
				{
					value.push(latest);
					compLables.put(key,value);
				}
				else
				{
					var add = new Array();
					add.push(latest);
					compLables.put(key,add);
				}
			}
		}
		//getting component name
		var textMsg;
		
		var msg=key.substring(0,key.indexOf(":"));
		//alert(msg);
		if(msg.indexOf('Agg_') == 0) {
			msg=msg.substring(4);
			textMsg=egtop_iniMap.get(msg);
			textMsg=textMsg+" "+"Aggregate";
		}
		else
		{
			textMsg=egtop_iniMap.get(msg);
		}
		var compTextName=textMsg;
		var typeFlag=false;
		if(textMsg.length > 22)
		{
			var midval ;
			if(compTextName.length % 2 == 0)
				midval = compTextName.length / 2;
			else
				midval = (compTextName.length + 1) / 2;
			compTextName = textMsg.substring(0,midval)+"\n"+textMsg.substring(midval);
			typeFlag=true;
		}
		
		//end
		var compName = key.substring(key.indexOf(":")+1);
		if(compName.indexOf(":NULL") > 0)
			compName = compName.substring(0,compName.indexOf(":NULL"));
		var textstr = compName;
		var compFlag=false;
		if(compName.length > 22)
		{
			var mid ;
			if(textstr.length % 2 == 0)
				mid = textstr.length / 2;
			else
				mid = (textstr.length + 1) / 2;
			textstr = compName.substring(0,mid)+"\n"+compName.substring(mid);
			compFlag=true;
		}
		/*if((textMsg.length > 22) || (compName.length > 22))
		{
			alltpNames.push(r.text(xpoint+29*zom,ypoint+63*zom,compTextName).attr({"font-size" : 11*zom,'font-weight': 'bold',"font-family":"Tahoma"}));
		}
		else
		{
			alltpNames.push(r.text(xpoint+29*zom,ypoint+56*zom,compTextName).attr({"font-size" : 11*zom,'font-weight': 'bold',"font-family":"Tahoma"}));
		}
		if((textMsg.length > 22) || (compName.length > 22))
		{
			allCompNames.push(r.text(xpoint+29*zom,ypoint+92*zom,textstr).attr({"font-size" : 11*zom}));
		}
		else
		{
			allCompNames.push(r.text(xpoint+29*zom,ypoint+72*zom,textstr).attr({"font-size" : 11*zom}));
		}*/
		if(!typeFlag && !compFlag ) //1 1
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+55*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+70*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
		else if(!typeFlag && compFlag) // 1 2
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
		else if(typeFlag && !compFlag) // 2 1
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
		else if(typeFlag && compFlag) // 2 2
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+88*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
		
	}
	return cirArr;
}

function drawNewLabels()
{
	return newUnmanageLables;
}

</script>
<%
	}

%>
									</div> 
								</td>
							</tr>


<input type="hidden" name="zoom" id="zoom" value='<%=zoomLevel%>'>
							
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>
</body>
</html>

<%
}
catch(Exception e){
	System.out.println("Exception in EgAutoMainPage.jsp....");
	e.printStackTrace();
}
%>

<%!
	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		//ArrayList newList = new ArrayList();
		//ArrayList unmanageList = new ArrayList();

		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		/*if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);*/
		result.put("NEW" , newSet);
		result.put("UNMANAGE" , unmanageSet);
		return result;
	}

	private String getTopologyString(String segmentName, String site , String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		//EgCrawler strBean = new EgCrawler(iniFile);
		String str = null;
		if (phyTopology.equals("1"))
		{
			String[] lines = iniFile.getLinesUnderSubject(segmentName);
			if(lines!=null)
			{
				//str = strBean.getPhysicalTopology(segmentName ,lines);
				str = getPhysicalTopology(segmentName ,lines);
			}
		}
		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
			newString = EgConstants.BLANK_SPACE;
		else
			//newString = str; //ap.getTopologyPriority(str, site);
			newString = ap.getTopologyPriority(str, site);
		newString = sortTopoString(newString);
		return newString;
	}

	public String getPhysicalTopology(String s_segment, String[] lines)
	{
		if(lines==null)
			return "";
		StringBuffer s_pt = new StringBuffer("Web_site:egurkha.physical.topology=");
		try
		{
			String[] s_var = null;
			ArrayList valList = new ArrayList();
			Hashtable myHt = new Hashtable();
			String state = "NO";
			if (s_segment != null && (!s_segment.equals("null")))
			{
				//s_subject = s_segment;
				for(int i=0;i<lines.length;i++)
				{
					String thisLine = lines[i];
					String thisvar = thisLine.substring(0,thisLine.indexOf("="));
					String thisval = thisLine.substring(thisLine.indexOf("=")+1);
					valList.add(thisvar);
					myHt.put(thisvar,thisval);
				}
				s_var = (String []) valList.toArray (new String [valList.size ()]);
			}
			if (s_var == null || s_var.length < 1)
			{
				return "";
			}
			//setConnection();
			Vector v_com =  new Vector(); //getAllValues(s_subject, s_var, "NO");

			//Get All Values (Begin)
			for (int q = 0; q < s_var.length; q++)
			{
				String thisVar = s_var[q];
				if (thisVar.startsWith("#"))
				{
					continue;
				}
				String s_temp = (String) myHt.get(thisVar);
				if (s_temp.indexOf(",") > 0)
				{
					StringTokenizer st = new StringTokenizer(s_temp, ",");
					while (st.hasMoreTokens())
					{
						if (state.equals("YES"))
						{
							v_com.addElement(st.nextToken());
						}
						else
						{
							String ss = st.nextToken();
							v_com.addElement(ss.substring(0, ss.lastIndexOf(":")));
						}
					}
				}
				else if (!s_temp.equals("null"))
				{
					if (state.equals("YES"))
					{
						v_com.addElement(s_temp);
					}
					else
					{
						v_com.addElement(s_temp.substring(0, s_temp.lastIndexOf(":")));
					}
				}
			}
			//Get All Values (End)

			Vector v_unAssgnList=new Vector();
			StringBuffer s_fline = new StringBuffer();
			int maxCount = s_var.length;

			for (int j = 0; j < maxCount; j++)
			{
				if (s_var[j].startsWith("#"))
					continue;

				if (!v_com.contains(s_var[j]))
				{
					//s_fline.append(s_var[j] +":N:"+ getState(s_var[j], "NULL") +",");
					s_fline.append(s_var[j] +":N:"+ "GOOD" +",");
					v_unAssgnList.add(s_var[j]);
				}
			}
			if (s_fline.toString().endsWith(","))
			{
				int bufferLength = s_fline.length();
				s_fline.delete(bufferLength-1, bufferLength);
			}

			s_pt.append(s_fline.toString());

			while(v_unAssgnList.size()>0)
			{
				String s_key = (String)v_unAssgnList.get(0);
				String s_val = (String) myHt.get(s_key);
				if (s_val==null || s_val=="")			//if there cud be any issue with end component of topology node
					s_val = "null";

				s_pt.append("|" + s_key + "=");

				if(!s_val.equalsIgnoreCase("null"))
				{
					if(s_val.indexOf(",") > -1)
					{
						StringTokenizer st = new StringTokenizer(s_val,",");
						while(st.hasMoreTokens())
						{
							String s_token= st.nextToken().trim();
							String s_comp=s_token.substring(0, s_token.lastIndexOf(":"));
							s_pt.append(s_token + ":" + "GOOD");
							if (st.hasMoreTokens())
								s_pt.append(",");
							if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
						}
					}
					else
					{
						String s_comp = s_val.substring(0, s_val.lastIndexOf(":"));
						s_pt.append(s_val +":"+"GOOD");
						if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
					}
				}
				else
				{
					s_pt.append("null");
				}
				v_unAssgnList.removeElementAt(0);
			}
			//releaseConnection(false);
		}
		catch (Exception e)
		{
			System.out.println("Exception in getPhysicalTopology............");
			e.printStackTrace();
			//releaseConnection(true);
			return "";
		}
		return s_pt.toString();
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr==null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i=0;i<topoToks.length ;i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation!=null && relation.length==2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation!=null && relation.length==1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs)==-1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj!=null && finalLhs.indexOf(thisLhs)==-1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj==null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i=0;i<finalLhs.size() ;i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs!=null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i=0;i<toks.length ;i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				if(rhsCmp != null)
				{
					result.add(rhsCmp);
					//System.out.println("$$$$$:"+rhsCmp.toString()+"\t"+thisLhs+""+i);
					if (rhsCmp.toString() != null && !rhsCmp.toString().equals("null"))
					{
						h.put(rhsCmp.toString(), thisLhs);
					}
				}
			}
		}
		return result;
	}

	public Hashtable getSegmentComps(String segment)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");

		String[] thisSegVar = autoTopoIniFile.getVariables(segment);
		if(thisSegVar!=null && thisSegVar.length > 0)
		{
			for(int k=0;k<thisSegVar.length;k++)
			{
				String varName = thisSegVar[k];
				String thisServerType = varName.substring(0,varName.indexOf(":"));
				String compName =  varName.substring(varName.indexOf(":")+1);

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}

				String thisSegValue = autoTopoIniFile.getValue(segment, varName);
				StringTokenizer st = new StringTokenizer(thisSegValue,",");
				while(st.hasMoreTokens())
				{
					String thistoken = st.nextToken();
					if(thistoken!=null && thistoken.equals("null"))
						continue;
					String thiscomp = thistoken.substring(0,thistoken.lastIndexOf(":"));
					
					String this_server_type = thiscomp.substring(0,thiscomp.indexOf(":"));
					String this_compname = thiscomp.substring(thiscomp.indexOf(":")+1);
					if(result.containsKey(this_server_type))
					{
						ArrayList tmpList = (ArrayList) result.get(this_server_type);
						if(!tmpList.contains(this_compname))
						{
							tmpList.add(this_compname);
							result.put(this_server_type,tmpList);
						}
					}
					else
					{
						ArrayList tmpList =new ArrayList();
						tmpList.add(this_compname);
						result.put(this_server_type,tmpList);
					}
				}
			}
		}
		return result;
	}

	private Hashtable getGroupDetails(EgGroupInfo egGroupInfo)
	{
		// Collect Group Details, if Group Exists
		Hashtable result = new Hashtable();
		List groupList = new ArrayList();
		String[] groupComponents = egGroupInfo.getAllComponentsFromGroups();
		if(groupComponents!=null && groupComponents.length > 0)
		{
			for(int k=0;k<groupComponents.length;k++)
			{
				String groupVariable = groupComponents[k];
				String groupValue = egGroupInfo.getValue("GROUP_DETAILS", groupVariable);
				result.put(groupVariable , groupValue);
			}
		}
		return result;
	}

	public Hashtable getStartCompsFromTopoAuto(ArrayList allZoneCompList)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String autoSubject = "Topo_Auto";
		String[] autoVar = autoTopoIniFile.getVariables(autoSubject);
		EgGroupInfo egGroupInfo = new EgGroupInfo();

		Hashtable groupTable = getGroupDetails(egGroupInfo);
		boolean isGroupExists = false;
		if(groupTable!=null && groupTable.size() > 0)
			isGroupExists = true;

		for(int k=0;k<autoVar.length;k++)
		{
			String varName = autoVar[k];
			String valName = autoTopoIniFile.getValue(autoSubject,varName);

			/*ArrayList deletedList = getDeletedComponents(varName,"null");
			if(deletedList!=null && deletedList.contains(varName))
				continue;*/

			if(allZoneCompList.contains(varName))
				continue;

			StringTokenizer st = new StringTokenizer(valName,",");
			boolean isValid = false;
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();

				/*ArrayList deletedListVal = getDeletedComponents("null",tok);	
				String val=tok;
				if(tok.endsWith(":L") || tok.endsWith(":N"))
					val = tok.substring(0,tok.lastIndexOf(":"));
				if(deletedListVal!=null && deletedListVal.contains(val))
					continue;*/

				tok = tok.substring(0,tok.lastIndexOf(":"));
				if(!allZoneCompList.contains(tok))
				{
					isValid = true;
					break;
				}
			}

			if(isValid)
			{
				String thisServerType = "";
				String compName = "";

				if(isGroupExists && groupTable.containsKey(varName))
				{
					String groupName = (String) groupTable.get(varName);
					boolean checkFlag = checkFunction(valName, groupName, egGroupInfo);
					if(checkFlag)
					{
						thisServerType = "Group";
						compName = groupName+":"+"NULL";
					}
				}
				else
				{
					thisServerType = varName.substring(0,varName.indexOf(":"));
					compName =  varName.substring(varName.indexOf(":")+1);
				}

				if(thisServerType.equals(""))
					continue;

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}
			}
		}
		return result;
	}

	private boolean checkFunction(String valueString, String groupName , EgGroupInfo egGroupInfo)
	{
		boolean flag = false;
		StringTokenizer strTokenizer = new StringTokenizer(valueString,",");
		ArrayList groupCompList = egGroupInfo.getAllComponentsUnderGroup(groupName);
		while(strTokenizer.hasMoreTokens())
		{
			String val = strTokenizer.nextToken();
			val = val.substring(0,val.lastIndexOf(":"));
			if(!groupCompList.contains(val))
			{
				flag = true;
				break;
			}
		}
		return flag;
	}

	public ArrayList getDeletedComponents(String variable,String lineValue)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		ArrayList deletedList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();
		Set deletedSet = new TreeSet();

		if(variable!=null && !variable.equals("null") && !variable.equals(""))
		{
			String varName = variable;
			StringTokenizer stz = new StringTokenizer(varName,":");
			int count = stz.countTokens();

			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
			String deletedValue = disIniFile.getValue(thisCompName,varName);

			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else if(unmanageValue!=null && unmanageValue.length() > 0)	// Check for unmanage component
			{
				unmanageSet.add(varName);
			}
			else
			{
				boolean isOracle= false;
				if(count == 4)
					isOracle = true;
				
				if(!isOracle)
				{
					if(deletedValue==null || deletedValue.length()==0)
					{
						deletedSet.add(varName);
					}
				}
				else if(isOracle)
				{
					String variable2 = varName.substring(0,varName.lastIndexOf(":"));
					String deletedVals = disIniFile.getValue(thisCompName,variable2);
					String newvals = disIniFile.getValue(thisCompName,newstr+variable2);
					String unmanageVals = disIniFile.getValue(thisCompName,unmanagestr+variable2);
					if((newvals==null || newvals.length()==0)&&(unmanageVals==null || unmanageVals.length()==0))
					{
						if((deletedVals==null || deletedVals.length()==0) && (deletedValue==null || deletedValue.length()==0))
						{
							deletedSet.add(varName);
						}
					}
				}
			}
		}

		if(lineValue!=null && !lineValue.equals("") && !lineValue.equals("null"))
		{
			String valName = lineValue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				StringTokenizer str = new StringTokenizer(tmpvar,":");
				int cnt = str.countTokens();

				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				String unmanageVal = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
				String deletedVal = disIniFile.getValue(tmpcompname,tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else if(unmanageVal!=null && unmanageVal.length() > 0)
				{
					unmanageSet.add(tmpvar);
				}
				else
				{
					boolean isOracle= false;
					if(cnt == 4)
						isOracle = true;
					
					if(!isOracle)
					{
						if(deletedVal==null || deletedVal.length()==0)
						{
							deletedSet.add(tmpvar);
						}
					}
					else if(isOracle)
					{
						String variable1 = tmpvar.substring(0,tmpvar.lastIndexOf(":"));
						String newvals = disIniFile.getValue(tmpcompname,newstr+variable1);
						String unmanageVals = disIniFile.getValue(tmpcompname,unmanagestr+variable1);
						String deletedVals = disIniFile.getValue(tmpcompname,variable1);
						if((newvals==null || newvals.length()==0)&&(unmanageVals==null || unmanageVals.length()==0))
						{
							if((deletedVals==null || deletedVals.length()==0) && (deletedVal==null || deletedVal.length()==0))
							{
								deletedSet.add(tmpvar);
							}
						}
					}
				}
			}
		}

		if(deletedSet!=null && deletedSet.size() > 0)
		{
			deletedList = new ArrayList(deletedSet);
		}

		return deletedList;
	}
%>



