<%@ include file = "../../EgTrackerAJSON.jsp"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgConfigFilesSync"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	String enabledTasksOnly = request.getParameter("enabledTasksOnly");
	String disabledTaskOnly = request.getParameter("disabledTaskOnly");
	String username = request.getParameter("username");
	String compType = request.getParameter("s_usercmdtype");

	boolean enabledOnly=false;
	boolean disabledOnly=false;
	ArrayList enabledCmdsOnly=new ArrayList();
	if(!StringUtils.isNull(enabledTasksOnly))
	{
		enabledOnly=true;
		enabledCmdsOnly=StringUtils.myTokenizer(enabledTasksOnly,",");
		if(enabledCmdsOnly == null)
		{
			enabledCmdsOnly=new ArrayList();
		}
	}
	ArrayList disabledCmdsOnly=new ArrayList();
	if(!StringUtils.isNull(disabledTaskOnly))
	{
		disabledOnly=true;
		disabledCmdsOnly=StringUtils.myTokenizer(disabledTaskOnly,",");
		if(disabledCmdsOnly == null)
		{
			disabledCmdsOnly=new ArrayList();
		}
	}
	if(!enabledCmdsOnly.isEmpty() || !disabledCmdsOnly.isEmpty())
	{
		IniFile inifile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_usercommands.ini");
		String alreadyPermittedCmdsOld = inifile.getValue("ALLOWED_COMMANDS",username);
		ArrayList cmdsPermitted = new ArrayList();

		String arrayOld[]=StringUtils.getTokens(alreadyPermittedCmdsOld,"#");
		boolean othersExist=false;
		String searchKeyOld=compType+"|";
		String commonSearchKey=compType+"|";
		for(int i=0;i<arrayOld.length;i++)
		{
			String str=arrayOld[i];
			if(str.startsWith(searchKeyOld))
			{
				str=str.substring(str.indexOf("|")+1);
				String array[]=StringUtils.getTokens(str,",");
				cmdsPermitted.addAll(Arrays.asList(array));
			}
			else
			{
				othersExist=true;
			}
		}
		// remove the disabled commands from the already permitted commands
		if(!cmdsPermitted.isEmpty())
		{
			int count = disabledCmdsOnly.size();
			for(int i=0;i<count;i++)
			{
				String cmd = (String)disabledCmdsOnly.get(i);
				while(cmdsPermitted.contains(cmd))
				{
					cmdsPermitted.remove(cmd);
				}
			}
		}
		// get only newly enabled commands for the permitted commands
		if(!enabledCmdsOnly.isEmpty())
		{
			int count=enabledCmdsOnly.size();
			for(int i=count-1;i>=0;i--)
			{
				String cmd=(String)enabledCmdsOnly.get(i);
				if(cmdsPermitted.contains(cmd))
				{
					enabledCmdsOnly.remove(cmd);
				}
			}
		}
		//add the newly enabled commands into the permitted command list
		if(!enabledCmdsOnly.isEmpty())
		{
			cmdsPermitted.addAll(enabledCmdsOnly);
		}
		if(username != null)
		{
			if(cmdsPermitted.isEmpty() && !othersExist)
			{
				//no permitted commands found. so remove this user from the ini file
				inifile.deleteValue("ALLOWED_COMMANDS",username);
			}
			else
			{
				// build a new permitted commands and update the username in ini file
				Collections.sort(cmdsPermitted,String.CASE_INSENSITIVE_ORDER);
				String compTypeCmdsNow=StringUtils.getArrayAsString(cmdsPermitted.toArray(new String[cmdsPermitted.size()]));
				//String commandsWithCompTypes = inifile.getValue("ALLOWED_COMMANDS",username);
				if(alreadyPermittedCmdsOld == null || alreadyPermittedCmdsOld.trim().length()==0 || alreadyPermittedCmdsOld.trim().equalsIgnoreCase("null"))
				{
					inifile.setValue("ALLOWED_COMMANDS",username,(commonSearchKey+compTypeCmdsNow));
				}
				else
				{
					boolean updated=false;
					String array[]=StringUtils.getTokens(alreadyPermittedCmdsOld,"#");
					StringBuffer buffer = new StringBuffer();
					//String searchKey=compType+"|";
					for(int i=0;i<array.length;i++)
					{
						String str=array[i];
						if(str.startsWith(commonSearchKey))
						{
							if(compTypeCmdsNow.trim().length()>0)
							{
								str=str.substring(str.indexOf("|")+1);
								buffer.append(commonSearchKey);
								buffer.append(compTypeCmdsNow);
								buffer.append("#");
								updated=true;
							}
						}
						else
						{
							buffer.append(str);
							buffer.append("#");
						}
					}
					if(!updated)
					{
						if(compTypeCmdsNow.trim().length()>0)
						{
							buffer.append(commonSearchKey+compTypeCmdsNow);
							buffer.append("#");
						}
					}
					String finalStr = buffer.toString();
					if(finalStr.endsWith("#"))
					{
						finalStr=finalStr.substring(0,finalStr.length()-1);
					}
					inifile.setValue("ALLOWED_COMMANDS",username,finalStr);
				}
			}
		}
		inifile.saveFile();
		EgConfigFilesSync.releaseInstance(inifile);

		rootJson.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		//resultMsg.put("title",_mapping.getTextDescription("admin.title.ALLOW/DISALLOWCOMMANDS"));

		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Commands");
		auditLogThread.setValue("Activity","Associate/Disassociate Commands");

		String s_usercmdtype = request.getParameter("s_usercmdtype");
		IniFile iniUi = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ui.ini");
		int incCmdSize = enabledCmdsOnly.size();
		int excCmdSize = disabledCmdsOnly.size();
		/*Hashtable cmdTypaMap = new Hashtable();
		if(s_usercmdtype.equalsIgnoreCase("WINDOWS_COMMANDS"))
		{
			Vector 
			cmdTypaMap.put();
		}*/
		if(!enabledCmdsOnly.isEmpty())
		{
			StringBuffer includeCmds = new StringBuffer();
			for(int i=0;i<incCmdSize;i++)
			{
				String incCmd = iniUi.getValue(s_usercmdtype,(String)enabledCmdsOnly.get(i));
				if(incCmd == null || (incCmd = incCmd.trim()).length() ==0)
				{
					 incCmd = iniUi.getValue("WINDOWS_COMMANDS_REMOTE_CONTROL",(String)enabledCmdsOnly.get(i));
				}
				int pipeIdx = incCmd.indexOf("|");
				if(pipeIdx >0)
				{
					incCmd = incCmd.substring(0,pipeIdx);
				}

				includeCmds.append(",");
				includeCmds.append(incCmd);
			}
			auditLogThread.setCurrentValue("Associated Commands",includeCmds.toString().substring(1));
		}
		if(!disabledCmdsOnly.isEmpty())
		{
			StringBuffer exludedCmds = new StringBuffer();
			for(int i=0;i<excCmdSize;i++)
			{
				String excCmd = iniUi.getValue(s_usercmdtype,(String)disabledCmdsOnly.get(i));
				int pipeIdx = excCmd.indexOf("|");
				if(pipeIdx >0)
				{
					excCmd = excCmd.substring(0,pipeIdx);
				}
				exludedCmds.append(",");
				exludedCmds.append(excCmd);
			}
			auditLogThread.setCurrentValue("Disassociated Commands",exludedCmds.toString().substring(1));
		}

		String dispUserName = egurkha.EgUIUtils.decodeSecurityChar(request.getParameter("s_dispusername"));
		String hasOrHave = (incCmdSize > 1 || excCmdSize > 1) ? "have" : "has";
		if(enabledOnly && disabledOnly)
		{
			auditLogThread.setValue("Description","Commands "+hasOrHave+" been associated and disassociated for the user " + dispUserName);
			resultMsg.put("message1",_mapping.getTextDescription("admin.test.Commands "+hasOrHave+" been associated/disassociated successfully")+".");
		}
		else if(enabledOnly)
		{
			auditLogThread.setValue("Description","Commands "+hasOrHave+" been associated for the user " + dispUserName);
			resultMsg.put("message1",_mapping.getTextDescription("admin.test.Commands "+hasOrHave+" been associated successfully")+".");
		}
		else
		{
			auditLogThread.setValue("Description","Commands "+hasOrHave+" been disassociated for the user " + dispUserName);
			resultMsg.put("message1",_mapping.getTextDescription("admin.test.Commands "+hasOrHave+" been disassociated successfully")+".");
		}
		auditLogThread.sendItToDB();
		rootJson.put("isEnableDisable",(enabledOnly && disabledOnly));
		rootJson.put("result",resultMsg);
	}

	out.println(rootJson.toString());
%>



