<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.MibParser"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	EgMibUtil.loadMibs();
	JSONObject rootObj = new JSONObject();
	String fromAction = request.getParameter("fromAction");
	String mibFile = request.getParameter("mibFile");
	if (StringUtils.isNull(mibFile))
	{
		mibFile = "-1";
	}
	EgUserRole usrRole = _user.getUserRole();
	boolean hasAllComponentAccess = usrRole.hasAllComponentAccess();
	
	String session_userid = (String)session.getAttribute("sess_userid");
	EgUuidInfo egUuidInfo = new EgUuidInfo();
	String installDir = EgInstallInfo.getInstallDir()+"/.snmp";
	String defaultMibsInstallDir = EgInstallInfo.getInstallDir()+"/.snmp/mibs";
	String orgname = "";
	if (!hasAllComponentAccess)
	{
		boolean isSuperOrg = egUuidInfo.isSuperOrg(session_userid);
		boolean isOrg = egUuidInfo.isOrg(session_userid);
		if (isSuperOrg)
		{
			orgname = session_userid;
		}
		else if (isOrg)
		{
			orgname = session_userid;
		}
		else
		{
			orgname = egUuidInfo.getDirectDependentOU(session_userid);
		}
		
		if (orgname.equalsIgnoreCase("egenterprise"))
		{
			installDir = EgInstallInfo.getInstallDir()+"/.snmp";
			hasAllComponentAccess = true;
		}
		else
		{
			installDir = EgInstallInfo.getInstallDir()+"/.snmp/"+orgname;
		}
	}
	else
	{
		orgname = "egenterprise";
	}
	
	if (!StringUtils.isNull(fromAction) && fromAction.equalsIgnoreCase("checkFileUploaded"))
	{
		boolean isFileUploaded = false;
		File directory=new File(installDir);
		if (directory.exists())
		{
			File[] files = directory.listFiles();  
			for (int i=0; i<files.length; i++)  
			{
				File file = files[i];
				if (file.isDirectory())
				{
					continue;
				}
				String tmpFilePath = file.getAbsolutePath();
				if (!tmpFilePath.toLowerCase().endsWith(".txt") && 
					!tmpFilePath.toLowerCase().endsWith(".mib") && 
					!tmpFilePath.toLowerCase().endsWith(".my"))
				{
					continue;
				}
				
				String mibFileName = file.getName();
				String mibFileNameWithoutExt = mibFileName;
				int extIdx = mibFileName.lastIndexOf(".");
				if (extIdx != -1)
				{
					mibFileNameWithoutExt = mibFileName.substring(0,extIdx);
				}
				if (mibFileName.equalsIgnoreCase(mibFile+".txt") || 
				mibFileName.equalsIgnoreCase(mibFile+".mib") || 
				mibFileName.equalsIgnoreCase(mibFile+".my") || 
				mibFileNameWithoutExt.equalsIgnoreCase(mibFile) ||
				mibFileName.equalsIgnoreCase(mibFile))
				{
					isFileUploaded = true;
				}
			}
		}
		
		if (!isFileUploaded)
		{
			File defMibsDirectory=new File(defaultMibsInstallDir);
			if (defMibsDirectory.exists())
			{
				File[] filesArr = defMibsDirectory.listFiles();  
				for (int i=0; i<filesArr.length; i++)  
				{
					File file = filesArr[i];
					if (file.isDirectory())
					{
						continue;
					}
					String tmpFilePath = file.getAbsolutePath();
					if (!tmpFilePath.toLowerCase().endsWith(".txt") && 
						!tmpFilePath.toLowerCase().endsWith(".mib") && 
						!tmpFilePath.toLowerCase().endsWith(".my"))
					{
						continue;
					}
					
					String mibFileName = file.getName();
					String mibFileNameWithoutExt = mibFileName;
					int extIdx = mibFileName.lastIndexOf(".");
					if (extIdx != -1)
					{
						mibFileNameWithoutExt = mibFileName.substring(0,extIdx);
					}
					if (mibFileName.equalsIgnoreCase(mibFile+".txt") || 
					mibFileName.equalsIgnoreCase(mibFile+".mib") || 
					mibFileName.equalsIgnoreCase(mibFile+".my") || 
					mibFileNameWithoutExt.equalsIgnoreCase(mibFile) ||
					mibFileName.equalsIgnoreCase(mibFile))
					{
						isFileUploaded = true;
					}
				}
			}
		}
		
		rootObj.put("isFileUploaded",isFileUploaded);
	}
	else if (!StringUtils.isNull(fromAction) && fromAction.equalsIgnoreCase("configFiles"))
	{
		ArrayList uploadedFileList = new ArrayList();
		File directory=new File(installDir);
		if (directory.exists())
		{
			File[] files = directory.listFiles();  
			for (int i=0; i<files.length; i++)  
			{
				File file = files[i];
				if (file.isDirectory())
				{
					continue;
				}
				String tmpFilePath = file.getAbsolutePath();
				if (!tmpFilePath.toLowerCase().endsWith(".txt") && 
					!tmpFilePath.toLowerCase().endsWith(".mib") && 
					!tmpFilePath.toLowerCase().endsWith(".my"))
				{
					continue;
				}
				
				String mibFileName = file.getName();
				String mibFileNameWithoutExt = mibFileName;
				int extIdx = mibFileName.lastIndexOf(".");
				if (extIdx != -1)
				{
					mibFileNameWithoutExt = mibFileName.substring(0,extIdx);
				}
				uploadedFileList.add(mibFileNameWithoutExt);
			}
		}
		
		File defMibsDirectory=new File(defaultMibsInstallDir);
		if (defMibsDirectory.exists())
		{
			File[] filesArr = defMibsDirectory.listFiles();  
			for (int i=0; i<filesArr.length; i++)  
			{
				File file = filesArr[i];
				if (file.isDirectory())
				{
					continue;
				}
				String tmpFilePath = file.getAbsolutePath();
				if (!tmpFilePath.toLowerCase().endsWith(".txt") && 
					!tmpFilePath.toLowerCase().endsWith(".mib") && 
					!tmpFilePath.toLowerCase().endsWith(".my"))
				{
					continue;
				}
				
				String mibFileName = file.getName();
				String mibFileNameWithoutExt = mibFileName;
				int extIdx = mibFileName.lastIndexOf(".");
				if (extIdx != -1)
				{
					mibFileNameWithoutExt = mibFileName.substring(0,extIdx);
				}
				uploadedFileList.add(mibFileNameWithoutExt);
			}
		}
		
		IniFile trapsConfig = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini");
		ArrayList userMibFilesList = new ArrayList();
		String[] alltrapsSubjects = trapsConfig.getSubjects();
		if (alltrapsSubjects != null && alltrapsSubjects.length > 0)
		{
			int len = alltrapsSubjects.length;
			for (int x=0; x<len; x++)
			{
				String subject = alltrapsSubjects[x];
				
				if (subject.equalsIgnoreCase(orgname+"^#^OIDNameMap"))
				{
					continue;
				}
				
				if (subject.equalsIgnoreCase(orgname+"^#^ObjectOIDNameMap"))
				{
					continue;
				}
				
				if (subject.startsWith(orgname+"^#^"))
				{
					String subStr = subject.substring(subject.indexOf("^#^")+3);
					int sub_idx = subStr.indexOf("^#^");
					if (sub_idx != -1)
					{
						subStr = subStr.substring(0,sub_idx);
					}
					
					if (!userMibFilesList.contains(subStr))
					{
						userMibFilesList.add(subStr);
					}
				}
			}
		}
		
		JSONArray userMibFilesArr = new JSONArray();
		if (userMibFilesList != null && userMibFilesList.size() > 0)
		{
			Collections.sort(userMibFilesList,String.CASE_INSENSITIVE_ORDER);
			int mib_size = userMibFilesList.size();
			for (int a=0; a<mib_size; a++)
			{
				String isUploadedFile = "false";
				JSONObject userMibFilesObj = new JSONObject();
				String userMibFile = (String) userMibFilesList.get(a);
				if (uploadedFileList != null && uploadedFileList.contains(userMibFile))
				{
					isUploadedFile = "true";
				}
				userMibFilesObj.put("displayField",userMibFile);
				userMibFilesObj.put("valueField",userMibFile);
				userMibFilesObj.put("isUploadedFile",isUploadedFile);
				userMibFilesObj.put("image","comp-others");
				userMibFilesArr.add(userMibFilesObj);
			}
		}
		rootObj.put("userMibFiles",userMibFilesArr);
	}
	else
	{
		JSONArray mibFilesArr = new JSONArray();
		JSONObject mibFileObj = new JSONObject();
		mibFileObj.put("displayField","Choose a MIB file");
		mibFileObj.put("valueField","-1");
		mibFilesArr.add(mibFileObj);
		
		HashMap userMibFileMap = new HashMap();
		MibParser parser = new MibParser();
		String mibWithoutExt = mibFile;
		File directory = new File(installDir);
		if (directory.exists())
		{
			File[] files = directory.listFiles();  
			for (int i=0; i<files.length; i++)  
			{
				File file = files[i];
				if (file.isDirectory())
				{
					continue;
				}
				String tmpFilePath = file.getAbsolutePath();
				if (!tmpFilePath.toLowerCase().endsWith(".txt") && 
					!tmpFilePath.toLowerCase().endsWith(".mib") && 
					!tmpFilePath.toLowerCase().endsWith(".my"))
				{
					continue;
				}
				
				String mibFileNameWithExt = file.getName();
				String mibFileNameWithoutExt = mibFileNameWithExt;
				boolean isTrapsExist = parser.isTrapsExist(mibFileNameWithExt, orgname, hasAllComponentAccess);
				int extIdx = mibFileNameWithExt.lastIndexOf(".");
				if (extIdx != -1)
				{
					mibFileNameWithoutExt = mibFileNameWithExt.substring(0,extIdx);
				}
				
				if (mibFileNameWithExt.equalsIgnoreCase(mibFile+".txt") || 
				mibFileNameWithExt.equalsIgnoreCase(mibFile+".mib") || 
				mibFileNameWithExt.equalsIgnoreCase(mibFile+".my") || 
				mibFileNameWithoutExt.equalsIgnoreCase(mibFile) ||
				mibFileNameWithExt.equalsIgnoreCase(mibFile))
				{
					mibFile = mibFileNameWithExt;
					mibWithoutExt = mibFileNameWithoutExt;
				}
				
				if (!isTrapsExist)
				{
					continue;
				}
				
				userMibFileMap.put(mibFileNameWithoutExt,mibFileNameWithExt);
			}
		}
		
		if (userMibFileMap != null && userMibFileMap.size() > 0)
		{
			HashMap sortedUserMibMap = parser.sortByValue(userMibFileMap);
			Iterator userMibItr = sortedUserMibMap.keySet().iterator();
			while(userMibItr.hasNext())
			{
				JSONObject mibFilesObj = new JSONObject();
				String displayField = (String)userMibItr.next();
				String valueField = (String)sortedUserMibMap.get(displayField);
				mibFilesObj.put("displayField",displayField);
				mibFilesObj.put("valueField",valueField);
				mibFilesObj.put("groupField","Uploaded");
				mibFilesArr.add(mibFilesObj);
			}
		}
		
		IniFile trapsConfig = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini");
		Vector defaultMibList = trapsConfig.getAllValues("DEFAULT_MIBS_WITH_TRAPS");
		
		if (defaultMibList != null && defaultMibList.size() > 0)
		{
			int def_size = defaultMibList.size();
			for (int i=0; i<def_size; i++)  
			{ 
				JSONObject mibFilesObj = new JSONObject();
				
				String mibFileNameWithExt = (String) defaultMibList.get(i);
				String mibFileNameWithoutExt = mibFileNameWithExt;
				int extIdx = mibFileNameWithExt.lastIndexOf(".");
				if (extIdx != -1)
				{
					mibFileNameWithoutExt = mibFileNameWithExt.substring(0,extIdx);
				}
				
				if (mibFileNameWithExt.equalsIgnoreCase(mibFile+".txt") || 
				mibFileNameWithExt.equalsIgnoreCase(mibFile+".mib") || 
				mibFileNameWithExt.equalsIgnoreCase(mibFile+".my") || 
				mibFileNameWithoutExt.equalsIgnoreCase(mibFile) ||
				mibFileNameWithExt.equalsIgnoreCase(mibFile))
				{
					mibFile = mibFileNameWithExt;
					mibWithoutExt = mibFileNameWithoutExt;
				}
				
				mibFilesObj.put("displayField",mibFileNameWithoutExt);
				mibFilesObj.put("valueField",mibFileNameWithExt);
				mibFilesObj.put("groupField","Preloaded");
				mibFilesArr.add(mibFilesObj);
			}
		}
		
		JSONObject mibFileObj1 = new JSONObject();
		mibFileObj1.put("displayField","---- Manually configure trap OIDs ----");
		mibFileObj1.put("valueField","enteramib");
		mibFileObj1.put("groupField","Manual");
		mibFilesArr.add(mibFileObj1);
		
		rootObj.put("selectedMibFile",mibFile);
		rootObj.put("allMibFiles",mibFilesArr);
		
		if (!StringUtils.isNull(mibFile) && !mibFile.equalsIgnoreCase("-1") && !mibFile.equalsIgnoreCase("enteramib"))
		{
			parser.loadMibFileData(mibFile, orgname, hasAllComponentAccess);
			
			JSONArray allTrapsArr = new JSONArray();
			HashMap allTrapsMap = parser.getAllTrapsForMib();
			if (allTrapsMap != null && allTrapsMap.size() > 0)
			{
				JSONObject allTrapObj = new JSONObject();
				allTrapObj.put("displayField","Choose a trap type");
				allTrapObj.put("valueField","-1");
				allTrapsArr.add(allTrapObj);
				Iterator trapsItr = allTrapsMap.keySet().iterator();
				while(trapsItr.hasNext())
				{
					JSONObject allTrapsObj = new JSONObject();
					String valueField = (String)trapsItr.next();
					String dispField = (String)allTrapsMap.get(valueField);
					allTrapsObj.put("displayField",dispField);
					allTrapsObj.put("valueField",valueField);
					allTrapsArr.add(allTrapsObj);
					
					HashMap allObjectsForTrap = parser.getAllObjectsForTrapName(valueField);
					JSONArray allObjsForTrapArr = new JSONArray();
					if (allObjectsForTrap != null && allObjectsForTrap.size() > 0)
					{
						JSONObject allTrapObjs = new JSONObject();
						allTrapObjs.put("displayField","Choose an object");
						allTrapObjs.put("valueField","-1");
						allObjsForTrapArr.add(allTrapObjs);
						Iterator objsTrapItr = allObjectsForTrap.keySet().iterator();
						while(objsTrapItr.hasNext())
						{
							JSONObject allObjsForTrapObj = new JSONObject();
							String objValueField = (String)objsTrapItr.next();
							String objDispField = (String)allObjectsForTrap.get(objValueField);
							allObjsForTrapObj.put("displayField",objDispField);
							allObjsForTrapObj.put("valueField",objValueField);
							allObjsForTrapArr.add(allObjsForTrapObj);
						}
					}
					rootObj.put(valueField,allObjsForTrapArr);
				}
			}
			rootObj.put("allTraps",allTrapsArr);
			
			String[] alltrapsSubjects = trapsConfig.getSubjects();
		
			ArrayList allSelectedSubjectList = new ArrayList();
			if (alltrapsSubjects != null && alltrapsSubjects.length > 0)
			{
				int len = alltrapsSubjects.length;
				for (int x=0; x<len; x++)
				{
					String subject = alltrapsSubjects[x];
					if (subject.startsWith(orgname+"^#^"+mibWithoutExt))
					{
						allSelectedSubjectList.add(subject);
					}
				}
			}
			
			JSONArray allConfigTrapsArr = new JSONArray();
			JSONObject allObjects = new JSONObject();
			if (allSelectedSubjectList != null && allSelectedSubjectList.size() > 0)
			{
				int subject_size = allSelectedSubjectList.size();
				for (int j=0; j<subject_size; j++)
				{
					String subjectStr = (String)allSelectedSubjectList.get(j);
					ArrayList tokensList = new ArrayList(StringUtils.egTokenizer(subjectStr,"^#^"));
					int tokens_size = tokensList.size();
					if (tokens_size > 2)
					{
						String trapOid = (String) tokensList.get(2);
						allConfigTrapsArr.add(trapOid);
						String[] trapsArr = trapsConfig.getVariables(subjectStr);
						
						if (trapsArr != null && trapsArr.length > 0)
						{
							JSONArray allObjsArr = new JSONArray();
							int trap_len = trapsArr.length;
							for (int m=0; m<trap_len; m++)
							{
								String variable = trapsArr[m];
								String trapsPriority = trapsConfig.getValue(subjectStr,variable);
								allObjsArr.add(variable+"#@#"+trapsPriority);
							}
							allObjects.put(trapOid,allObjsArr);
						}
					}
					else
					{
						String[] trapsArr = trapsConfig.getVariables(subjectStr);
						
						if (trapsArr != null && trapsArr.length > 0)
						{
							int trap_len = trapsArr.length;
							for (int m=0; m<trap_len; m++)
							{
								String trapOid = trapsArr[m];
								String trapsPriority = trapsConfig.getValue(subjectStr,trapOid);
								allConfigTrapsArr.add(trapOid+"#@#"+trapsPriority);
							}
						}
					}
				}
			}
			rootObj.put("listConfigTrapObjs",allObjects);
			rootObj.put("listConfigTraps",allConfigTrapsArr);
			
			JSONArray oidNameMap = new JSONArray();
			String[] oidNamVarArr = trapsConfig.getVariables(orgname+"^#^OIDNameMap");
			Vector oidNamValVec = trapsConfig.getAllValues(orgname+"^#^OIDNameMap");
			
			if (oidNamVarArr != null && oidNamVarArr.length > 0)
			{
				JSONObject oidNameObj = new JSONObject();
				int varLen = oidNamVarArr.length;
				for (int m=0; m<varLen; m++)
				{
					String trapOID = oidNamVarArr[m];
					String trapName = (String) oidNamValVec.get(m);
					oidNameObj.put(trapOID,trapName);
				}
				oidNameMap.add(oidNameObj);
			}
			
			JSONArray objectOidNameMap = new JSONArray();
			String[] objOidNamVarArr = trapsConfig.getVariables(orgname+"^#^ObjectOIDNameMap");
			Vector objOidNamValVec = trapsConfig.getAllValues(orgname+"^#^ObjectOIDNameMap");
			
			if (objOidNamVarArr != null && objOidNamVarArr.length > 0)
			{
				JSONObject objectOidNameObj = new JSONObject();
				int varLen = objOidNamVarArr.length;
				for (int m=0; m<varLen; m++)
				{
					String trapObjOID = objOidNamVarArr[m];
					String trapObjName = (String) objOidNamValVec.get(m);
					objectOidNameObj.put(trapObjOID,trapObjName);
				}
				objectOidNameMap.add(objectOidNameObj);
			}
			
			rootObj.put("oidNameMap",oidNameMap);
			rootObj.put("objectOidNameMap",objectOidNameMap);
		}
	}
	out.println(rootObj.toString());
%>



