<%
/*************************************************************************************************/
/*                 Name          : EgAutoCompNamesJson.jsp                                           */
/*                 Purpose       : This page is used to create Java script Auto Topology         */
/*                                 When connect/ uses concepts involves in Auto Topology, this    */
/*                                 page shows the components of paricular type                   */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgDiscInfo2"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject compNameObj = new JSONObject();
	JSONArray compNameArr = new JSONArray();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

try
{
	String zone = request.getParameter("zone");
	String comptype = request.getParameter("comptype");
	String segment = request.getParameter("segment");
	String choice = request.getParameter("choice");
	String frmcomptype =request.getParameter("frmcomptype");
	String frmcompname = request.getParameter("frmcompname");
	String compStatus = request.getParameter("compStatus");
	IniFile autoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList thisZoneComponents = new ArrayList();		// Contains all components from the given zone.
	ArrayList allZoneComponents = new ArrayList();		// Contains all components from all Zones Except the selected Zone
	EgAutoTopologyServlet autoTopoServlet = new EgAutoTopologyServlet();
	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1")){
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;
	}
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	String UserName = _user.getLoginID();
	Hashtable tmpHt = new Hashtable();//groupInfo.getAllComponentsUnderZone();
	if(tmpHt!=null && tmpHt.size() > 0)
	{
		if(isZone && tmpHt.containsKey(zone))
		{
			tmpHt.remove(zone);
		}
		ArrayList valList = new ArrayList(tmpHt.values());
		for(int k=0;k<valList.size();k++)
		{
			ArrayList tmpList = (ArrayList) valList.get(k);
			allZoneComponents.addAll(tmpList);
		}
	}

	ArrayList compNames = new ArrayList ();
	ArrayList zoneCompNames = new ArrayList();
	ArrayList disabledList = new ArrayList();
	ArrayList myList = new ArrayList();
	Hashtable groupNameTable = new Hashtable();
	boolean isGroupType = false;
	boolean fromUser = false;

	if(frmcomptype!=null && frmcomptype.equals("imguser_72") && frmcompname!=null && frmcompname.equals("User:NULL")){
		fromUser = true;
	}

	if(comptype!=null && comptype.equals("Group"))
		isGroupType = true;

	if(isGroupType)
	{
		if(isZone)
		{
			TreeSet mySet =  groupInfo.getAllGroupsUnderZone(zone, true);
			if(mySet!=null && mySet.size() > 0)
			{
				myList.addAll(mySet);
				ArrayList tempList = new ArrayList();
				tempList.addAll(mySet);
				for(int k=0;k<tempList.size(); k++)
				{
					String element = (String) tempList.get(k);
					element = element.substring(element.indexOf(":")+1);
					zoneCompNames.add(element);
				}
			}
		}

		TreeSet independentGroups = groupInfo.getIndependentGroups(true);
		if(independentGroups!=null && independentGroups.size() > 0)
		{
			myList.addAll(independentGroups);
		}
	}
	else
	{
		myList = discInfo.getAllEntries(comptype);
	}

	if(choice.equals("managedComp"))
	{
		ArrayList userMangedCompos = new ArrayList();
		if(isLimitedAdmin)
		{
			 userMangedCompos = _user.getServersForType(comptype);
		}
		for(int y=0;y<myList.size();y++)
		{
			String entry = (String) myList.get(y);
			if(isGroupType)
			{
				String thisCompName = entry.substring(entry.indexOf(":")+1);
				compNames.add(thisCompName);
			}
			else
			{
				if(entry.startsWith("#"))
					continue;
				String thisVar = entry.substring(0,entry.indexOf("="));
				if(isLimitedAdmin && !userMangedCompos.contains(thisVar))  //To display only user specific component.
					continue;
				String thisCompName = thisVar.substring(thisVar.indexOf(":")+1);
				// Consider only the components belongs to this zone
				if(allZoneComponents.contains(thisVar))
					continue;

				//Check, if the above component belongs to any group, If YES add to disabledList
				String groupName = "";//groupInfo.getValue("GROUP_DETAILS", thisVar);
				if(groupName!=null && groupName.length() > 0)
				{
					disabledList.add(thisCompName);
					groupNameTable.put(thisCompName, groupName);
				}
				compNames.add(thisCompName);
				
			}
		}
		if(frmcomptype.equalsIgnoreCase("DGroup"))
		{
			ArrayList grpCompArr = new ArrayList();
			ArrayList managedCompNamesArr = new ArrayList();
			ArrayList grpCompArrVal = autoTopoServlet.getComponentsUnderAutoTopologyGrp(frmcompname);//get all components under specified group
			Hashtable grpNewCompTable = autoTopoServlet.getUnmanageAndNewComponents(frmcompname,"autoTopoGrp");//get newly discovered components
			TreeSet newCompList = (TreeSet)grpNewCompTable.get("NEW");
			grpCompArr.addAll(newCompList);
			grpCompArrVal.removeAll(grpCompArr);
			for(int v=0; v<grpCompArrVal.size(); v++)
			{
				String managedCompNameInGrp = (String)grpCompArrVal.get(v);
				managedCompNameInGrp = managedCompNameInGrp.substring(managedCompNameInGrp.indexOf(":")+1,managedCompNameInGrp.length());
				managedCompNamesArr.add(managedCompNameInGrp);
			}
			compNames.removeAll(managedCompNamesArr);
		}
		for(int y=0;y<thisZoneComponents.size();y++)
		{
			String entry = (String) thisZoneComponents.get(y);
			String thisServerType = entry.substring(0,entry.indexOf(":"));
			if(thisServerType.equals(comptype))
			{
				String thisCompName = entry.substring(entry.indexOf(":")+1);
				zoneCompNames.add(thisCompName);
			}
		}
	}
	else if(choice.equals("newComp"))
	{
		ArrayList userNewCompo = new ArrayList();
		if(isLimitedAdmin)
		{
			userNewCompo = getAllNeworUnmanageCompo(UserName,"#New|");
		}
		for(int y=0;y<myList.size();y++)
		{
			String entry = (String) myList.get(y);
			if(entry.startsWith("#New"))
			{
				String thisVar = entry.substring(0,entry.indexOf("="));
				if(isLimitedAdmin && !userNewCompo.contains(thisVar))
					continue;
				String thisCompName = thisVar.substring(thisVar.indexOf(":")+1);
				compNames.add(thisCompName);
			}
		}
		if(frmcomptype.equalsIgnoreCase("DGroup"))
		{
			ArrayList newCompInGrpArr = new ArrayList();
			ArrayList newCompNameInGrpArr = new ArrayList();
			Hashtable grpNewCompTable = autoTopoServlet.getUnmanageAndNewComponents(frmcompname,"autoTopoGrp");
			TreeSet newCompList = (TreeSet)grpNewCompTable.get("NEW");
			newCompInGrpArr.addAll(newCompList);
			for(int s=0; s<newCompInGrpArr.size(); s++)
			{
				String newCompNameInGrp = (String)newCompInGrpArr.get(s);
				newCompNameInGrp = newCompNameInGrp.substring(newCompNameInGrp.indexOf(":")+1,newCompNameInGrp.length());
				newCompNameInGrpArr.add(newCompNameInGrp);
			}
			compNames.removeAll(newCompNameInGrpArr);
		}
	}
	else if(choice.equals("unManagedComp"))
	{
		ArrayList userUnmanCompo = new ArrayList();
		if(isLimitedAdmin)
		{
			userUnmanCompo = getAllNeworUnmanageCompo(UserName,"#Unmanage|");
		}
		for(int y=0;y<myList.size();y++)
		{
			String entry = (String) myList.get(y);
			if(entry.startsWith("#Unmanage"))
			{
				String thisVar = entry.substring(0,entry.indexOf("="));
				if(isLimitedAdmin && !userUnmanCompo.contains(thisVar))
					continue;
				String thisCompName = thisVar.substring(thisVar.indexOf(":")+1);
				compNames.add(thisCompName);
			}
		}
	}
	else if(choice.equals("managedGrp"))
	{
		String[] grpNames = groupInfo.getGroupNames();
		ArrayList fromGrpComponentlist = new ArrayList();
		if(compStatus.equalsIgnoreCase("MANAGED"))
		{
			if(frmcompname.contains(":NULL"))
			{
				frmcompname = frmcompname.replace(":NULL","");
			}
			fromGrpComponentlist = groupInfo.getAllComponentsUnderGroup(frmcompname);
		}
		else if(compStatus.equalsIgnoreCase("NEW"))
		{
			fromGrpComponentlist = autoTopoServlet.getComponentsUnderAutoTopologyGrp(frmcompname);
		}
		String grpNameValue = "";
		for(int k=0; k<grpNames.length; k++)
		{
			String grpName = grpNames[k];
			ArrayList grpComponentlist = groupInfo.getAllComponentsUnderGroup(grpName);
			grpNameValue = grpName + ":NULL";
			ArrayList compList = new ArrayList();
			for(int n=0; n<grpComponentlist.size(); n++)
			{
				String comp = (String)grpComponentlist.get(n);
				if(fromGrpComponentlist.contains(comp))
				{
					compList.add(comp);
				}
			}
			if(compList.size() <= 0)
			{
				compNames.add(grpNameValue);
			}
		}
	}
	else if(choice.equals("discGrp"))
	{
		ArrayList discGrpArr = discoveredGroup();
		ArrayList discGrpCompList = new ArrayList();
		ArrayList fromGrpComponentlist = autoTopoServlet.getComponentsUnderAutoTopologyGrp(frmcompname);
		for(int k=0; k<discGrpArr.size(); k++)
		{
			String discGrpName = (String)discGrpArr.get(k);
			if(discGrpName.contains("DGroup:"))
			{
				discGrpName = discGrpName.replace("DGroup:","");
			}
			discGrpCompList = autoTopoServlet.getComponentsUnderAutoTopologyGrp(discGrpName);
			ArrayList compList = new ArrayList();
			for(int n=0; n<discGrpCompList.size(); n++)
			{
				String comp = (String)discGrpCompList.get(n);
				if(fromGrpComponentlist.contains(comp))
				{
					compList.add(comp);
				}
			}
			if(compList.size() <= 0)
			{
				compNames.add(discGrpName);
			}
		}
	}
	/*-------- To check already connected / used components (Begin) --------- */
	ArrayList usedList = new ArrayList();
	
	if(fromUser)
	{
		// Nothing to do
	}
	else
	{
		String usedValue = autoIniFile.getValue(segment,frmcomptype+":"+frmcompname);
		if(usedValue.length() > 0)
		{
			StringTokenizer st = new StringTokenizer(usedValue,",");
			while(st.hasMoreTokens())
			{
				String tok =st.nextToken();
				if(tok.startsWith(comptype))
				{
					String ip_port  = tok.substring(tok.indexOf(":")+1,tok.lastIndexOf(":"));
					usedList.add(ip_port);
				}
			}
		}
	}
	//out.println(usedList);
	/*-------- To check already connected / used components (End) --------- */

	/*-------- Disable checkbox to prevent circular topology (Begin) --------- */
	/*
		Connect / Uses  Functionality ( To Avoid Circular Topology )
		============================================================
		1. Can n't create link between Selected or Highligted component and the same component.
		2. Can n't create link between Selected component and it's parent (up to root parent)
		3. If No.of leading component  is only one, Can n't create link between Selected component and the leading component ( Obviously , it is also one of the parent)
	*/
	if(fromUser)
	{
		Vector valueVec = autoIniFile.getAllValues(segment);
		if(valueVec != null && valueVec.size()>0)
		{
			for(int y=0;y<valueVec.size();y++)
			{
				String valuestr = (String) valueVec.get(y);
				if(valuestr!=null && valuestr.equals("null"))
					continue;

				StringTokenizer st = new StringTokenizer(valuestr,",");
				while(st.hasMoreTokens())
				{
					String tok = st.nextToken();
					if(tok.startsWith(comptype))
					{
						String varcompname = tok.substring(tok.indexOf(":")+1,tok.lastIndexOf(":"));
						disabledList.add(varcompname);
					}
				}
			}
		}
	}
	else
	{
		if(frmcomptype.equals(comptype)){
			disabledList.add(frmcompname);	// Add the same component to disabledList
		}

		Hashtable htt = getParentLists(segment);
		ArrayList lhsList = getThisLhsList(htt , segment , frmcomptype+":"+frmcompname);
		//ArrayList lhsList = getLhsList(segment,frmcomptype+":"+frmcompname);
		Vector variableVec = autoIniFile.getVariables(segment,false);
		if(variableVec!=null && variableVec.size() > 0)
		{
			for(int y=0;y<variableVec.size();y++)
			{
				String varstr = (String) variableVec.get(y);
				if(varstr.startsWith(comptype))
				{
					String valuestr = autoIniFile.getValue(segment,varstr);
					if(valuestr!=null && valuestr.indexOf(frmcomptype+":"+frmcompname) > -1)
					{
						String varcompname = varstr.substring(varstr.indexOf(":")+1);
						disabledList.add(varcompname);
					}
					if(lhsList!=null && lhsList.size() > 0)
					{
						for(int k=0;k<lhsList.size();k++)
						{
							String lhsComp = (String) lhsList.get(k);
							if(valuestr!=null && valuestr.indexOf(lhsComp) >= 0)
							{
								String varcompname = varstr.substring(varstr.indexOf(":")+1);
								disabledList.add(varcompname);
							}
						}
					}
				}
			}
		}
	}
	ArrayList startList = getLeadingComponents(segment);
	if(fromUser)
	{
		if(startList!=null)
		{
			for(int k=0;k<startList.size();k++)
			{
				String leadingComponent = (String) startList.get(k);
				String leadingCompType = leadingComponent.substring(0,leadingComponent.indexOf(":"));
				if(leadingCompType.equals(comptype))
				{
					String leadingCompName = leadingComponent.substring(leadingComponent.indexOf(":")+1);
					usedList.add(leadingCompName);
				}
			}
		}
	}
	else
	{
		if(startList!=null && startList.size()==1)	//If No.of leading component  is one. Add this to disabledList
		{
			String leadingComponent = (String) startList.get(0);
			String leadingCompType = leadingComponent.substring(0,leadingComponent.indexOf(":"));
			if(leadingCompType.equals(comptype))
			{
				String leadingCompName = leadingComponent.substring(leadingComponent.indexOf(":")+1);
				disabledList.add(leadingCompName);
			}
		}
	}
	//out.println(disabledList);
	/*-------- Disable checkbox to prevent circular topology (End) --------- */

	JSONObject hiddenValues = new JSONObject();
	hiddenValues.put("zone",zone);
	hiddenValues.put("segment",segment);
	hiddenValues.put("comptype",comptype);
	rootJson.put("hiddenValues",hiddenValues);

	for(int k=0;k<compNames.size();k++)
	{
		String cName = (String) compNames.get(k);
		if(!disabledList.contains(cName))
		{
			String cNameWithOutNull = cName;
			if(cNameWithOutNull.endsWith(":NULL"))
				cNameWithOutNull = cNameWithOutNull.substring(0,cNameWithOutNull.indexOf(":NULL"));
			String checked="";
			String disabled="";
			String grpName="";
			boolean isGroupName = false;
			boolean isZoneComp = false;
			if(usedList.contains(cName))
				checked="checked";
			if(disabledList.contains(cName))
			{
				disabled = "disabled";
				String grpValue = (String) groupNameTable.get(cName);
				if(grpValue!=null && grpValue.length() > 0)
				{
					grpName = grpValue;
					isGroupName = true;
				}
			}
			if(zoneCompNames.contains(cName))
				isZoneComp = true;

			compNameObj.put("Checked",checked);
			compNameObj.put("Disabled",disabled);
			compNameObj.put("CheckboxValue",cName);
			compNameObj.put("isZoneComp",isZoneComp);
			compNameObj.put("isGroupType",isGroupType);
			compNameObj.put("isGroupName",isGroupName);

			if(isZoneComp)
			{
				if(isGroupType)
				{
					ArrayList groupCompList = groupInfo.getAllComponentsUnderGroup(cName.substring(0,cName.indexOf(":")));
					StringBuffer thisBuffer = new StringBuffer();
					for(int kk=0;kk<groupCompList.size();kk++)
					{
						String arrElement = (String) groupCompList .get(kk);
						String arrCompType = arrElement.substring(0,arrElement.indexOf(":"));
						String arrCompName = arrElement.substring(arrElement.indexOf(":")+1);
						String mappingCompType = _mapping.getComponentTypeDescription(arrCompType);
						thisBuffer.append(mappingCompType+":"+arrCompName);
						thisBuffer.append(",");
					}
					String groupCompString = thisBuffer.toString();
					groupCompString = groupCompString.substring(0,groupCompString.lastIndexOf(","));
					compNameObj.put("Componentname",cNameWithOutNull);
				}
				else if(isGroupName)
				{
					compNameObj.put("Componentname",cNameWithOutNull);
					compNameObj.put("AlertTitle",_mapping.getTextDescription("admin.title.It belongs to Group ")+"&nbsp;"+grpName);
				}
				else
				{
					compNameObj.put("Componentname",cNameWithOutNull);
				}
			}
			else
			{
				if(isGroupType)
				{
					ArrayList groupCompList = groupInfo.getAllComponentsUnderGroup(cName.substring(0,cName.indexOf(":")));
					StringBuffer thisBuffer = new StringBuffer();
					for(int kk=0;kk<groupCompList.size();kk++)
					{
						String arrElement = (String) groupCompList .get(kk);
						String arrCompType = arrElement.substring(0,arrElement.indexOf(":"));
						String arrCompName = arrElement.substring(arrElement.indexOf(":")+1);
						String mappingCompType = _mapping.getComponentTypeDescription(arrCompType);
						thisBuffer.append(mappingCompType+":"+arrCompName);
						thisBuffer.append(",");
					}
					String groupCompString = thisBuffer.toString();
					groupCompString = groupCompString.substring(0,groupCompString.lastIndexOf(","));
					compNameObj.put("Componentname",cNameWithOutNull);
				}
				else if(isGroupName)
				{
					compNameObj.put("Componentname",cNameWithOutNull);
					compNameObj.put("AlertTitle",_mapping.getTextDescription("admin.title.It belongs to Group ")+"&nbsp;"+grpName);
				}
				else
				{
					compNameObj.put("Componentname",cNameWithOutNull);
				}
			}
			compNameArr.add(compNameObj);
		}
	}
	rootJson.put("CompNameGridValues",compNameArr);
	out.println(rootJson.toString());
}
catch(Exception e)
{
	System.out.println("Exception in EgAutoCompNames.jsp.....");
	e.printStackTrace();
}
%>

<%!
	private ArrayList getAllNeworUnmanageCompo(String userName,String NeworUnman)
	{
		IniFile userCompMap = new IniFile(EgConfigInfo.egMgrConfigDir+ "eg_usercompmapping.ini");
		String[] vars = userCompMap.getVariables(userName);
		//Vector val = userCompMap.getAllValues(userName);
		ArrayList result = new ArrayList();
		if (vars != null)
		{
			for (int v=0; v<vars.length; v++)
			{
				String compNick = vars[v];
				if(compNick.startsWith(NeworUnman))
				{
					result.add(compNick);	
				}
			}
		}
		return result;
	}
	public ArrayList getLeadingComponents(String subject)
	{
		ArrayList leadingList = new ArrayList();
		IniFile thisIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String[] allVariables = thisIniFile.getVariables(subject);
		if(allVariables!=null && allVariables.length > 0)
		{
			Vector allValueVec = thisIniFile.getAllValues(subject);
			for(int k=0;k<allVariables.length;k++)
			{
				String variable = allVariables[k];
				boolean isStart = true;
				for(int y=0;y<allValueVec.size();y++)
				{
					String valueLine = (String) allValueVec.get(y);
					int index = valueLine.indexOf(variable);
					if(index >=0)
					{
						isStart= false;
						break;
					}
				}
				if(isStart)
				{
					leadingList.add(variable);
				}
			}
		}
		return leadingList;
	}

	public Hashtable getParentLists(String subject)
	{
		Hashtable parantTable = new Hashtable();
		IniFile thisIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String[] allVariables = thisIniFile.getVariables(subject);
		for(int k=0;k<allVariables.length;k++)
		{
			String variable = allVariables[k];
			String value = thisIniFile.getValue(subject,variable);
			StringTokenizer st = new StringTokenizer(value, ",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String keyComp = tok ; 
				if(tok.lastIndexOf(":") > 0)
					 keyComp =  tok.substring(0,tok.lastIndexOf(":"));
				if(parantTable.containsKey(keyComp))
				{
					ArrayList parentList  = (ArrayList) parantTable.get(keyComp);
					parentList.add(variable);
					parantTable.put(keyComp, parentList);
				}
				else
				{
					ArrayList parentList  =  new ArrayList();
					parentList.add(variable);
					parantTable.put(keyComp, parentList);
				}
			}
		}
		return parantTable;
	}

	public ArrayList getThisLhsList(Hashtable ht , String subject , String findValue)
	{
		if(ht.containsKey(findValue))
		{
			ArrayList myList = (ArrayList) ht.get(findValue);
			return getLhsRecFunction(ht, subject, myList ,myList);
		}
		else 
		{
			return new ArrayList();
		}
	}

	private ArrayList getLhsRecFunction(Hashtable ht , String subject , ArrayList arrList , ArrayList resultList)
	{
		if(arrList!=null && arrList.size() > 0)
		{
			for(int k=0;k<arrList.size();k++)
			{
				String thisComp = (String) arrList.get(k);
				if(ht.containsKey(thisComp))
				{
					ArrayList tmpList = (ArrayList) ht.get(thisComp);
					if(tmpList!=null && tmpList.size() > 0)
					{
						ArrayList nextList = new ArrayList();
						for(int yy=0;yy<tmpList.size();yy++)
						{
							String tmpComp = (String) tmpList.get(yy);
							if(resultList.contains(tmpComp))
								continue;
							nextList.add(tmpComp);
							resultList.add(tmpComp);
						}
						resultList = getLhsRecFunction(ht, subject, nextList ,resultList);
					}
				}
			}
		}
		return resultList;
	}

	/*public ArrayList getLhsList(String subject, String findValue)
	{
		ArrayList lhsList = new ArrayList();
		IniFile thisIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String[] allVariables = thisIniFile.getVariables(subject);
		if(allVariables == null)
			return lhsList;
		for(int k=0;k<allVariables.length;k++)
		{
			String variable = allVariables[k];
			String value = thisIniFile.getValue(subject,variable);
			if(value.indexOf(findValue) >=0)
			{
				lhsList.add(variable);
			}
		}
		return lhsList;
	}*/

	public ArrayList discoveredGroup()
	{
		EgGroupInfo groupInfo = new EgGroupInfo();
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		ArrayList discGrp = new ArrayList();
		ArrayList managedGrpArr = new ArrayList();
		String[] var = iniFile.getVariables("Discovered_Groups");
		for(int l=0; l<var.length; l++)
		{
			String varStr = var[l];
			String val = iniFile.getValue("Discovered_Groups",varStr);
			StringTokenizer valTok = new StringTokenizer(val , ",");
			while(valTok.hasMoreTokens())
			{
				String singVal = valTok.nextToken();
				if(!discGrp.contains(singVal))
				{
					discGrp.add(singVal);
				}
			}
		}
		String[] grpName = groupInfo.getGroupNames();
		for(int k=0; k<grpName.length; k++)
		{
			String grpNameVal = grpName[k];
			String grpNameValue = "DGroup:"+ grpNameVal + ":NULL";
			managedGrpArr.add(grpNameValue);
		}
		discGrp.removeAll(managedGrpArr);
		return discGrp;
	}
	
%>