<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "com.egurkha.admin.TestUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "egurkha.ServiceBean" %>
<%@ page import= "net.sf.json.JSONObject"%>
<%@ page import= "net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
	
	JSONObject rootJSON = new JSONObject();
	
	String componentType = request.getParameter("componentType");
	String currentAssoList = request.getParameter("currentAssociated");
	String currentDisassoList = request.getParameter("currentDisassociated");
	String oldAssoList = request.getParameter("hiddenasso");
	String oldDisassoList = request.getParameter("hiddendisasso");
	boolean result = false;

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Tests");
	auditLogThread.setValue("Activity","Associate/Disassociate Tests");

	ArrayList associateAL = new ArrayList();
	if(currentAssoList != null && currentAssoList.length() != 0)
	{
		StringTokenizer st1 = new StringTokenizer(currentAssoList,",");
		while(st1.hasMoreElements())
		{
			String test = (String)st1.nextElement();
			if(test != null && test.length() != 0)
			{
				associateAL.add(test);
			}
		}
	}

	ArrayList oldassociateAL = new ArrayList();
	if(oldAssoList != null && oldAssoList.length() != 0)
	{
		StringTokenizer st2 = new StringTokenizer(oldAssoList,",");
		while(st2.hasMoreElements())
		{
			String test = (String)st2.nextElement();
			if(test != null && test.length() != 0)
			{
				oldassociateAL.add(test);
			}
		}
	}

	ArrayList disassociateAL = new ArrayList();
	if(currentDisassoList != null && currentDisassoList.length() != 0)
	{
		StringTokenizer st4 = new StringTokenizer(currentDisassoList,",");
		while(st4.hasMoreElements())
		{
			String test = (String)st4.nextElement();
			if(test != null && test.length() != 0)
			{
				disassociateAL.add(test);
			}
		}
	}

	ArrayList oldDisassociateAL = new ArrayList();
	if(oldDisassoList != null && oldDisassoList.length() != 0)
	{
		StringTokenizer st3 = new StringTokenizer(oldDisassoList,",");
		while(st3.hasMoreElements())
		{
			String test = (String)st3.nextElement();
			if(test != null && test.length() != 0)
			{
				oldDisassociateAL.add(test);
			}
		}
	}

	TestUtils testUtils = new TestUtils();

	boolean associated = false;
	boolean disassociated = false;

	try
	{
		associateAL.removeAll(oldassociateAL);
		if(associateAL.size() > 0)
		{
			testUtils.associateTestsForCompType(componentType,associateAL);
			associated = true;
			for(int i = 0; i < associateAL.size(); i++)
			{
				String test = (String) associateAL.get(i);
				auditLogThread.setCurrentValue("Associated Test(s)","$test$:"+test);
			}
		}

		disassociateAL.removeAll(oldDisassociateAL);
		if(disassociateAL.size() > 0)
		{
			testUtils.disassociateTestsForCompType(componentType,disassociateAL);
			EgPwdProfile pwdProf = new EgPwdProfile();
			pwdProf.removeDisabledTests(componentType,disassociateAL);
			disassociated = true;
			for(int i = 0; i < disassociateAL.size(); i++)
			{
				String test = (String) disassociateAL.get(i);
				auditLogThread.setCurrentValue("Disassociated Test(s)","$test$:"+test);
			}
			ServiceBean serviceBean = new ServiceBean();
			//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
			IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
			serviceBean.stopDiscovery();
			serviceBean.startDiscovery("1");
			EgConfigFilesSync.releaseInstance(infraIni);

			IniFile mgrMiscObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
			String[] allVariablesArr = mgrMiscObj.getVariables("ASSOCIATED_CORRECTIVE_SCRIPTS");
			Vector delVariableVector = new Vector();
			if (allVariablesArr != null && allVariablesArr.length > 0)
			{
				for (int a=0; a<allVariablesArr.length; a++)
				{
					String miscFileVariable = (String) allVariablesArr[a];
					if (miscFileVariable.startsWith(componentType))
					{
						for (int b=0; b<disassociateAL.size(); b++)
						{
							String disassociateTestStr = (String) disassociateAL.get(b);
							if (miscFileVariable.indexOf(":"+disassociateTestStr) > -1)
							{
								delVariableVector.add(miscFileVariable);
							}
						}
					}
				}
			}
			if (delVariableVector != null && delVariableVector.size() > -1)
			{
				mgrMiscObj.deleteValues("ASSOCIATED_CORRECTIVE_SCRIPTS", delVariableVector);
			}
			mgrMiscObj.saveFile();
			EgConfigFilesSync.releaseInstance(mgrMiscObj);
		}
		result = true;

		if(associated && disassociated)
		{
			auditLogThread.setValue("Description","Tests have been associated and disassociated for server "+"$ctype$:"+componentType);
			auditLogThread.sendItToDB();
		}
		else if(associated)
		{
			auditLogThread.setValue("Description","Tests have been associated to server "+"$ctype$:"+componentType);
			auditLogThread.sendItToDB();
		}
		else if(disassociated)
		{
			auditLogThread.setValue("Description","Tests have been disassociated from server "+"$ctype$:"+componentType);
			auditLogThread.sendItToDB();
		}
		/* code for auditlog ends */
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	rootJSON.put("success","true");
	rootJSON.put("AlertType",result);

	out.println(rootJSON.toString());
%>



