<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "com.egurkha.admin.TestUtils" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import= "net.sf.json.JSONObject"%>
<%@ page import= "net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
	
	JSONObject rootJSON = new JSONObject();
	
	String componentType = request.getParameter("componentType");
	String testType = request.getParameter("testType");
	String search = request.getParameter("search");
	String searchType = request.getParameter("searchType");
	boolean searchEnable = Boolean.parseBoolean(request.getParameter("searchEnable"));

	boolean isAssociateSearch = false;
	if(searchType != null)
	{
		if(searchType.equalsIgnoreCase("associate"))
		{
			isAssociateSearch = true;
		}
	}

	boolean isPerformance = true;

	String userLanguage = _user.getLanguage();
	
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	TestUtils testUtil = new TestUtils();
	ArrayList associateList = new ArrayList();
	ArrayList disassociateList = new ArrayList();

	if(testType == null && componentType == null)
	{
		ArrayList allCompTypeAL = new ArrayList();
		JSONArray allCompType = new JSONArray();

		allCompTypeAL = testUtil.getAllComponentTypes();
		EgUsersInfo usersInfo = new EgUsersInfo();
		if(usersInfo.isUserBasedLicense())
		{
			ArrayList userTypes = usersInfo.getAllUserBasedCompTypes();
			allCompTypeAL.removeAll(userTypes);
		}

		if (EgInstallInfo.isEUCEndPointsLicense)
		{
			EgEndPointsInfo endUsersObj = new EgEndPointsInfo();
			ArrayList types = endUsersObj.getEUCEndPointTypes();
			allCompTypeAL.removeAll(types);
		}
		if (EgInstallInfo.isO365UsersLicense)
		{
			EgMsUsersInfo msInfo = new EgMsUsersInfo();
			ArrayList msTypes = msInfo.getMsTypes();
			allCompTypeAL.removeAll(msTypes);
		}
		allCompTypeAL = sorter.getSortedCompTypeList(allCompTypeAL);
		JSONObject fObj = new JSONObject();
		fObj.put("displayField","Choose a component type");
		fObj.put("valueField","-1");
		allCompType.add(fObj);
		if(allCompTypeAL != null)
		{
			for(int i = 0; i < allCompTypeAL.size(); i++)
			{
				EgName compTypeObj = (EgName) allCompTypeAL.get(i);
				JSONObject obj = new JSONObject();
				obj.put("displayField",compTypeObj.getLocalName());
				obj.put("valueField",compTypeObj.getActualName());
				allCompType.add(obj);
			}
		}
		rootJSON.put("allCompType",allCompType);
	}
	else
	{
		if(testType.equalsIgnoreCase("configuration"))
		{
			isPerformance = false;
		}
		if(!searchEnable)
		{
			associateList = testUtil.getAssociateTests(componentType,isPerformance);
			disassociateList = testUtil.getDisassociateTests(componentType,isPerformance);

			int searchLimit = testUtil.getSearchBoxLimit();
			boolean enableAssoSearch = false;
			boolean enableDisassoSearch = false;

			associateList = sorter.getSortedTestList(associateList);
			disassociateList = sorter.getSortedTestList(disassociateList);

			JSONArray assoList = new JSONArray();
			JSONArray hiddenassoList = new JSONArray();
			if(associateList != null && associateList.size() > 0)
			{
				for(int i = 0; i < associateList.size(); i++)
				{
					EgName testNameObj = (EgName) associateList.get(i);
					JSONObject obj = new JSONObject();
					obj.put("displayField",testNameObj.getLocalName());
					obj.put("valueField",testNameObj.getActualName());
					hiddenassoList.add(testNameObj.getActualName());
					assoList.add(obj);
				}
			}
			JSONArray disassoList = new JSONArray();
			JSONArray hiddendisassoList = new JSONArray();
			if(disassociateList != null && disassociateList.size() > 0)
			{
				for(int i = 0; i < disassociateList.size(); i++)
				{
					EgName testNameObj = (EgName) disassociateList.get(i);
					JSONObject obj = new JSONObject();
					obj.put("displayField",testNameObj.getLocalName());
					obj.put("valueField",testNameObj.getActualName());
					hiddendisassoList.add(testNameObj.getActualName());
					disassoList.add(obj);
				}
			}
			if(associateList.size() > searchLimit)
			{
				enableAssoSearch = true;
			}

			if (disassociateList.size() > searchLimit)
			{
				enableDisassoSearch = true;
			}

			rootJSON.put("assoList",assoList);
			rootJSON.put("disassoList",disassoList);
			rootJSON.put("hiddenassoList",hiddenassoList);
			rootJSON.put("hiddendisassoList",hiddendisassoList);
			rootJSON.put("enableAssoSearch",enableAssoSearch);
			rootJSON.put("enableDisassoSearch",enableDisassoSearch);
		}
		else
		{
			if(isAssociateSearch)
			{
				associateList = testUtil.getAssociateTests(componentType,isPerformance);
				associateList = sorter.getSortedTestList(associateList);
				JSONArray assoList = new JSONArray();
				search = search.toLowerCase();
				if(associateList != null && associateList.size() > 0)
				{
					for(int i = 0; i < associateList.size(); i++)
					{
						EgName testNameObj = (EgName) associateList.get(i);
						String localName = testNameObj.getLocalName();
						String actualName = testNameObj.getActualName();
						if(localName.toLowerCase().indexOf(search) > -1)
						{
							JSONObject obj = new JSONObject();
							obj.put("displayField",localName);
							obj.put("valueField",actualName);
							assoList.add(obj);
						}
					}
				}
				rootJSON.put("assoList",assoList);
			}
			else
			{
				disassociateList = testUtil.getDisassociateTests(componentType,isPerformance);
				disassociateList = sorter.getSortedTestList(disassociateList);
				JSONArray disassoList = new JSONArray();
				search = search.toLowerCase();
				if(disassociateList != null && disassociateList.size() > 0)
				{
					for(int i = 0; i < disassociateList.size(); i++)
					{
						EgName testNameObj = (EgName) disassociateList.get(i);
						String localName = testNameObj.getLocalName();
						String actualName = testNameObj.getActualName();
						if(localName.toLowerCase().indexOf(search) > -1)
						{
							JSONObject obj = new JSONObject();
							obj.put("displayField",localName);
							obj.put("valueField",actualName);
							disassoList.add(obj);
						}
					}
				}
				rootJSON.put("disassoList",disassoList);
			}
		}
	}

	out.println(rootJSON.toString());
%>



