<%
/*
 *	Name			:	EgAgentInfoJson.jsp
 *	Purpose			:	This page displays information of the agent selected from Agent status page
 *  Location		:	Agent Status - [Agent IP/Nick]
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.util.Hashtable" %>
<%@ page import="java.util.StringTokenizer" %>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	AgentConfig agentConfig = AgentConfig.getAgentConfig();
	Hashtable ht_agentDetails = new Hashtable();
	String debug = request.getParameter("debug");
	String debugString = "Disabled";
	if(debug!=null && debug.equalsIgnoreCase("yes"))
		debugString = "Enabled";
	String [] agentDetails = {"AgentIP","AutoUpgrade","LastUpgradedPackage","LastUpgradedTime","HostName","OS","Version","JREVersion","StartupTime","DebugMode","AgentRestartedTime"};
	String agentIp = request.getParameter("agentIp");
	String agentType = request.getParameter("agentType");
	String agentState = request.getParameter("agentStatus");
	rootJSON.put("agentType",agentType);
	rootJSON.put("agentState",agentState);
	String s_packId = null;
	
	try
	{
		s_packId = agentConfig.getAgentDetails(agentIp);
	}
	catch(Exception e)
	{
		rootJSON.put("ErrorAlert",true);
		rootJSON.put("ErrorTitle",_mapping.getTextDescription("admin.upgrade.View Agent Details"));
		rootJSON.put("ErrorMsg",_mapping.getTextDescription("admin.upgrade.Agent details not available"));
		out.println(rootJSON);
		e.printStackTrace();
		return;
	}
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini";
	IniFile egUI = new IniFile(s_iniFile_dir);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String userDtFormat = _user.getUserDateFormat();
	if (userDtFormat != null && userDtFormat.equalsIgnoreCase("default"))
	{
		userDtFormat = currentDateFormat;
	}
	if(s_packId != null && !s_packId.equals("") && !s_packId.equalsIgnoreCase("None"))
	{
		ht_agentDetails.put("AgentIP",agentIp);
		StringTokenizer st = new StringTokenizer(s_packId, ",");
		int count = 1;
		while(st.hasMoreTokens())
		{
			ht_agentDetails.put(agentDetails[count++], st.nextToken());
		}

		if((String)ht_agentDetails.get("AutoUpgrade") != null && ((String)ht_agentDetails.get("AutoUpgrade")).equalsIgnoreCase("false"))
		{
			ht_agentDetails.put("AutoUpgrade","Disabled");
		}
		else if((String)ht_agentDetails.get("AutoUpgrade") != null && ((String)ht_agentDetails.get("AutoUpgrade")).equalsIgnoreCase("None"))
		{
			ht_agentDetails.remove("AutoUpgrade");
		}
		else
		{
			ht_agentDetails.put("AutoUpgrade","Enabled");
		}
		String lastUpgradedTime = (String)ht_agentDetails.get("LastUpgradedTime");
		if(lastUpgradedTime != null && !lastUpgradedTime.equalsIgnoreCase("None"))
		{
			long timeLong = Long.parseLong(lastUpgradedTime);
			Calendar calObj = Calendar.getInstance();
			calObj.setTimeInMillis(timeLong);
			
			String date = calObj.get(Calendar.DATE)+"";
			String month = (calObj.get(Calendar.MONTH)+1)+"";
			String hour = calObj.get(Calendar.HOUR_OF_DAY)+"";
			String min = calObj.get(Calendar.MINUTE)+"";
			String sec = calObj.get(Calendar.SECOND)+"";
			String year = calObj.get(Calendar.YEAR)+"";
			date = (date.length()==1)?"0"+date:date;
			month = (month.length()==1)?"0"+month:month;
			hour = (hour.length()==1)?"0"+hour:hour;
			min = (min.length()==1)?"0"+min:min;
			sec = (sec.length()==1)?"0"+sec:sec;
			
			String destDate = month+"-"+date+"-"+year;
			String destTime = hour+":"+min+":"+sec;
			if(DateUtil.isDate(destDate,"MM-dd-yyyy"))
			{
				destDate = DateUtil.changeDateFormat(destDate,"MM-dd-yyyy",currentDateFormat);
				EgTimeZoneConverter egtc = new EgTimeZoneConverter(destDate+" "+destTime, _user);
				destDate = egtc.getDateTime();
			}

			ht_agentDetails.put("LastUpgradedTime",destDate);
		}
		String startUpTime = (String)ht_agentDetails.get("StartupTime");
		if(startUpTime != null && !startUpTime.equalsIgnoreCase("None"))
		{
			long timeLong = Long.parseLong(startUpTime);
			Calendar calObj = Calendar.getInstance();
			calObj.setTimeInMillis(timeLong);
			
			String date = calObj.get(Calendar.DATE)+"";
			String month = (calObj.get(Calendar.MONTH)+1)+"";
			String hour = calObj.get(Calendar.HOUR_OF_DAY)+"";
			String min = calObj.get(Calendar.MINUTE)+"";
			String sec = calObj.get(Calendar.SECOND)+"";
			String year = calObj.get(Calendar.YEAR)+"";
			date = (date.length()==1)?"0"+date:date;
			month = (month.length()==1)?"0"+month:month;
			hour = (hour.length()==1)?"0"+hour:hour;
			min = (min.length()==1)?"0"+min:min;
			sec = (sec.length()==1)?"0"+sec:sec;
			
			String destDate = month+"-"+date+"-"+year;
			String destTime = hour+":"+min+":"+sec;
			if(DateUtil.isDate(destDate,"MM-dd-yyyy"))
			{
				destDate = DateUtil.changeDateFormat(destDate,"MM-dd-yyyy",currentDateFormat);
				EgTimeZoneConverter egtc = new EgTimeZoneConverter(destDate+" "+destTime, _user);
				destDate = egtc.getDateTime();
			}

			ht_agentDetails.put("StartupTime",destDate);
		}
		String restartedTime = "-";
		String agentIpPipe = "";
		String agentNickPipe = "|"+agentIp+"|";
		EgDiscInfo discObj = new EgDiscInfo("manager");
		Hashtable ht = discObj.getNickIpMap();
		if(ht != null && ht.containsKey(agentIp))
		{
			agentIpPipe = "|"+(String)ht.get(agentIp)+"|";
		}
		else if(ht != null && ht.containsKey(agentIp.toLowerCase()))
		{
			agentIpPipe = "|"+(String)ht.get(agentIp.toLowerCase())+"|";
		}
		else if(ht != null && ht.containsKey(agentIp.toUpperCase()))
		{
			agentIpPipe = "|"+(String)ht.get(agentIp.toUpperCase())+"|";
		}
		IniFile restartedTimeIni = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_agent_restart_time.ini");
		String ipStrs[] = restartedTimeIni.getVariables("AGENT_RESTARTED_TIME");
		if(ipStrs != null)
		{
			for(int k=0;k<ipStrs.length;k++)
			{
				String ipStr = ipStrs[k];
				String key = ipStr;
				if(ipStr.indexOf("^")>-1)
				{
					ipStr = "|"+com.egurkha.util.StringUtils.replace(ipStr,"^","|")+"|";
				}
				else
				{
					ipStr = "|"+com.egurkha.util.StringUtils.replace(ipStr,":","|")+"|";
				}
				if(ipStr.indexOf(agentNickPipe) >=0 || ipStr.indexOf(agentNickPipe.toLowerCase()) >=0 || ipStr.indexOf(agentNickPipe.toUpperCase()) >=0 ||
					ipStr.indexOf(agentIpPipe) >=0 || ipStr.indexOf(agentIpPipe.toLowerCase()) >=0 || ipStr.indexOf(agentIpPipe.toUpperCase()) >=0)
				{
					String tmp = restartedTimeIni.getValue("AGENT_RESTARTED_TIME",key);
					if(tmp != null && (tmp=tmp.trim()).length()>0)
					{
						try
						{
							long time = Long.parseLong(tmp);
							Calendar calObj1 = Calendar.getInstance();
							calObj1.setTimeInMillis(time);
							String date1 = calObj1.get(Calendar.DATE)+"";
							String month1 = (calObj1.get(Calendar.MONTH)+1)+"";
							String hour1 = calObj1.get(Calendar.HOUR_OF_DAY)+"";
							String min1 = calObj1.get(Calendar.MINUTE)+"";
							String sec1 = calObj1.get(Calendar.SECOND)+"";
							String year1 = calObj1.get(Calendar.YEAR)+"";
							date1 = (date1.length()==1)?"0"+date1:date1;
							month1 = (month1.length()==1)?"0"+month1:month1;
							hour1 = (hour1.length()==1)?"0"+hour1:hour1;
							min1 = (min1.length()==1)?"0"+min1:min1;
							sec1 = (sec1.length()==1)?"0"+sec1:sec1;
							
							restartedTime = month1+"-"+date1+"-"+year1;
							String destTime1 = hour1+":"+min1+":"+sec1;
							if(DateUtil.isDate(restartedTime,"MM-dd-yyyy"))
							{
								restartedTime = DateUtil.changeDateFormat(restartedTime,"MM-dd-yyyy",currentDateFormat);
								EgTimeZoneConverter egtc = new EgTimeZoneConverter(restartedTime+" "+destTime1, _user);
								restartedTime = egtc.getDateTime();
							}
						}
						catch(Exception e)
						{
							e.printStackTrace();
						}
						finally
						{
							break;
						}
					}
				}
			}
		}
		rootJSON.put("AgentRestartedTime",restartedTime);
	}
	else if(s_packId != null && s_packId.equalsIgnoreCase("None"))
	{
		rootJSON.put("ErrorAlert",true);
		rootJSON.put("ErrorTitle",_mapping.getTextDescription("admin.upgrade.View Agent Details"));
		rootJSON.put("ErrorMsg",_mapping.getTextDescription("admin.upgrade.Agent details not available"));
		out.println(rootJSON);
		return;
	}
	ht_agentDetails.put("DebugMode",debugString);
	
	for(int x=0;x<ht_agentDetails.size();x++)
	{
		String myString = agentDetails[x];
		if (myString.equalsIgnoreCase("StartupTime"))
		{
			myString = "LastUpdatedTime";
		}
		rootJSON.put(myString,ht_agentDetails.get(agentDetails[x]).toString());
	}
	if(debugString.equalsIgnoreCase("Enabled") || debugString.equalsIgnoreCase("Disabled"))
	{
		rootJSON.put("agentLogView",true);
		rootJSON.put("agentIpEncoded",EgURLEncoder.encode(agentIp,"UTF-8"));
		rootJSON.put("debug",debug);
	}
	else
	{
		rootJSON.put("agentLogView",false);
	}

	if(s_packId != null && !s_packId.equalsIgnoreCase("None") )
	{
		String  agentOS = (String)ht_agentDetails.get("OS");
		rootJSON.put("agentIP",agentIp);
		rootJSON.put("agentOS",agentOS);
		rootJSON.put("button_RestartAgent",true);
		rootJSON.put("button_Reset",true);
	}

	out.println(rootJSON);
%>
