/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.t4;

import com.ibm.db2.jcc.am.bo;
import com.ibm.db2.jcc.am.jb;
import com.ibm.db2.jcc.am.jf;
import com.ibm.db2.jcc.t4.ServerListEntry;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ServerListCache
implements Serializable {
    private static final long serialVersionUID = -6443797109558732499L;
    private HashMap cache_ = new HashMap();

    public synchronized void updateEntryWithLatestServerList(String string, String[] stringArray, int[] nArray, long l2) {
        ServerListEntry serverListEntry = this.getEntry(string);
        if (serverListEntry == null) {
            this.addNewServerListEntry(string, stringArray, nArray, l2);
            this.writeServerListCacheToFile();
        } else {
            boolean bl2 = this.hasEntryChanged(serverListEntry, stringArray, nArray);
            if (bl2) {
                serverListEntry.updateServer(stringArray);
                serverListEntry.updatePortNumber(nArray);
                serverListEntry.updateLastUpdatedTime(l2);
                this.writeServerListCacheToFile();
            }
        }
    }

    public ServerListEntry getEntry(String string) {
        return (ServerListEntry)this.cache_.get(string);
    }

    public HashMap getCache() {
        return this.cache_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeServerListCacheToFile() {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray = bo.a("jccServerListCache.bin", false);
        if (objectArray[0] == null && objectArray[1] == null && jb.yc == null) {
            return;
        }
        ServerListCache serverListCache = (ServerListCache)objectArray[0];
        if (serverListCache != null && !((HashMap)(object3 = serverListCache.getCache())).isEmpty()) {
            object2 = ((HashMap)object3).keySet();
            object = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                jb.uc.addEntry((String)object, (ServerListEntry)((HashMap)object3).get(object));
            }
        }
        object3 = null;
        object2 = null;
        object = null;
        object3 = objectArray[1] != null ? (FileLock)objectArray[1] : bo.a(jb.yc);
        if (object3 == null) return;
        object2 = bo.c(jb.xc);
        if (object2 != null) {
            try {
                object = new ObjectOutputStream((OutputStream)object2);
                ((ObjectOutputStream)object).writeObject(jb.uc);
                if (object != null) {
                    ((ObjectOutputStream)object).close();
                }
                if (object2 != null) {
                    ((FileOutputStream)object2).close();
                }
                if (object3 == null) return;
                ((FileLock)object3).release();
                return;
            }
            catch (IOException iOException) {
                try {
                    if (object != null) {
                        ((ObjectOutputStream)object).close();
                    }
                    if (object2 != null) {
                        ((FileOutputStream)object2).close();
                    }
                    ((FileLock)object3).release();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                object = null;
                object2 = null;
                object3 = null;
                return;
            }
            finally {
                try {
                    if (object3 != null) {
                        ((FileLock)object3).release();
                    }
                }
                catch (IOException iOException) {}
                object3 = null;
            }
        }
        try {
            ((FileLock)object3).release();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addEntry(String string, ServerListEntry serverListEntry) {
        if (serverListEntry != null) {
            ServerListEntry serverListEntry2 = this.getEntry(string);
            if (serverListEntry2 != null) {
                this.updateEntry(serverListEntry2, serverListEntry);
            } else {
                this.cache_.put(string, serverListEntry);
            }
        }
    }

    public void dumpServerListCache(jf jf2) {
        jf2.a("[t4]", 960, "Dumping server list cache content: ");
        if (!this.cache_.isEmpty()) {
            Set set = this.cache_.keySet();
            String string2 = null;
            ServerListEntry serverListEntry = null;
            int n2 = 0;
            for (String string2 : set) {
                serverListEntry = (ServerListEntry)this.cache_.get(string2);
                jf2.a("[t4]", 961, "[" + n2++ + "]" + string2 + " - " + serverListEntry.getLastUpdatedTime());
                this.printServerList(serverListEntry, jf2);
            }
        }
    }

    private void printServerList(ServerListEntry serverListEntry, jf jf2) {
        String[] stringArray = serverListEntry.getServerName();
        int[] nArray = serverListEntry.getPortNumber();
        String string = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = string + stringArray[i2] + ":" + nArray[i2] + ", ";
        }
        jf2.a("[t4]", 962, "   { " + string + "}");
    }

    private void updateEntry(ServerListEntry serverListEntry, ServerListEntry serverListEntry2) {
        if (serverListEntry2.getLastUpdatedTime() > serverListEntry.getLastUpdatedTime()) {
            serverListEntry.update(serverListEntry2.getServerName(), serverListEntry2.getPortNumber(), serverListEntry2.getInetAddress(), serverListEntry2.getLastUpdatedTime());
        }
    }

    private void addNewServerListEntry(String string, String[] stringArray, int[] nArray, long l2) {
        ServerListEntry serverListEntry = new ServerListEntry(stringArray, nArray, l2);
        this.cache_.put(string, serverListEntry);
    }

    private boolean hasEntryChanged(ServerListEntry serverListEntry, String[] stringArray, int[] nArray) {
        InetAddress[] inetAddressArray = serverListEntry.getInetAddress();
        int[] nArray2 = serverListEntry.getPortNumber();
        if (inetAddressArray.length != stringArray.length || nArray2.length != nArray.length) {
            return true;
        }
        InetAddress[] inetAddressArray2 = new InetAddress[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                inetAddressArray2[i2] = InetAddress.getByName(stringArray[i2]);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                inetAddressArray2[i2] = null;
            }
        }
        InetAddress inetAddress = null;
        boolean bl2 = false;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            inetAddress = inetAddressArray2[i3];
            int n2 = nArray[i3];
            bl2 = false;
            if (inetAddress != null) {
                for (int i4 = 0; i4 < inetAddressArray.length; ++i4) {
                    if (!inetAddress.equals(inetAddressArray[i4]) || n2 != nArray2[i3]) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            return true;
        }
        return false;
    }
}

