/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigFilesSync;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.MultiThreadDD;
import com.eg.MultiThreadDDConfigTask;
import com.eg.MultiThreadDDLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class MultiThreadDDInfo {
    private static final ConcurrentHashMap queryDDMap = new ConcurrentHashMap();
    private ArrayList singleThreadDetailsList = null;
    private ArrayList multiThreadDetailsList = null;
    private static final ArrayList excludeTableList = new ArrayList();
    private static final String servicesIni = EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini";
    private static final String multiDDSubject = "MULTITHREAD_DD_INSERT_SETTINGS";
    private static final String multiDDKeyword = "UseMultiThreadedDDInsertion";
    private static boolean isFailure = false;
    private static long hashMapClearSecond;
    private static int failurePercentLimit;
    private static final String SWITCH_SYNC;
    private static AtomicInteger preSingleFailurePercent;
    private static final MultiThreadDDInfo instance;
    private final ReentrantLock lock = new ReentrantLock();

    private MultiThreadDDInfo() {
        this.multiThreadDetailsList = new ArrayList();
        this.multiThreadDetailsList.add(0);
        this.multiThreadDetailsList.add(0);
        this.multiThreadDetailsList.add(0);
        this.singleThreadDetailsList = new ArrayList();
        this.singleThreadDetailsList.add(0);
        this.singleThreadDetailsList.add(0);
        this.singleThreadDetailsList.add(0);
    }

    public static MultiThreadDDInfo getInstance() {
        return instance;
    }

    public void updateStatistics(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7, int n2) {
        block7: {
            boolean bl = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
            try {
                boolean bl2;
                if ((string3.indexOf("PRIMARY KEY constraint") != -1 || string3.indexOf("Cannot insert duplicate key in object") != -1 || string3.indexOf("unique constraint") != -1) && excludeTableList.indexOf(string4.toUpperCase()) != -1) {
                    n = 1;
                }
                if (bl2 = this.isMultiThreadMode()) {
                    if (this.multiThreadDetailsList == null) {
                        this.multiThreadDetailsList = new ArrayList();
                        this.multiThreadDetailsList.add(0);
                        this.multiThreadDetailsList.add(0);
                        this.multiThreadDetailsList.add(0);
                    }
                    this.statisticsCount(this.multiThreadDetailsList, n, bl);
                } else {
                    if (this.singleThreadDetailsList == null) {
                        this.singleThreadDetailsList = new ArrayList();
                        this.singleThreadDetailsList.add(0);
                        this.singleThreadDetailsList.add(0);
                        this.singleThreadDetailsList.add(0);
                    }
                    this.statisticsCount(this.singleThreadDetailsList, n, bl);
                }
            }
            catch (Exception exception) {
                if (!bl) break block7;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void statisticsCount(ArrayList arrayList, int n, boolean bl) {
        block5: {
            try {
                if (n == 1) {
                    this.incrementSummaryDetails(arrayList, 1);
                } else if (n == 0) {
                    this.incrementSummaryDetails(arrayList, 2);
                }
                this.incrementSummaryDetails(arrayList, 0);
            }
            catch (Exception exception) {
                if (!bl) break block5;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void mergeStatisticsHashMap(boolean bl, boolean bl2) {
        block14: {
            try {
                if (bl) {
                    ArrayList arrayList = null;
                    if (this.multiThreadDetailsList != null) {
                        arrayList = (ArrayList)this.multiThreadDetailsList.clone();
                        this.multiThreadDetailsList = null;
                    } else {
                        arrayList = new ArrayList();
                    }
                    if (arrayList.size() > 0) {
                        ArrayList arrayList2 = (ArrayList)queryDDMap.get("multithread");
                        if (arrayList2 == null || arrayList2.size() == 0) {
                            queryDDMap.put("multithread", arrayList);
                        } else {
                            arrayList2.set(0, (Integer)arrayList2.get(0) + (Integer)arrayList.get(0));
                            arrayList2.set(1, (Integer)arrayList2.get(1) + (Integer)arrayList.get(1));
                            arrayList2.set(2, (Integer)arrayList2.get(2) + (Integer)arrayList.get(2));
                            queryDDMap.put("multithread", arrayList2);
                        }
                    }
                } else {
                    ArrayList arrayList = null;
                    if (this.singleThreadDetailsList != null) {
                        arrayList = (ArrayList)this.singleThreadDetailsList.clone();
                        this.singleThreadDetailsList = null;
                    } else {
                        arrayList = new ArrayList();
                    }
                    if (arrayList.size() > 0) {
                        ArrayList arrayList3 = (ArrayList)queryDDMap.get("singlethread");
                        if (arrayList3 == null || arrayList3.size() == 0) {
                            queryDDMap.put("singlethread", arrayList);
                        } else {
                            arrayList3.set(0, (Integer)arrayList3.get(0) + (Integer)arrayList.get(0));
                            arrayList3.set(1, (Integer)arrayList3.get(1) + (Integer)arrayList.get(1));
                            arrayList3.set(2, (Integer)arrayList3.get(2) + (Integer)arrayList.get(2));
                            queryDDMap.put("singlethread", arrayList3);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!bl2) break block14;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void checkForUpdateEgServiceIni(boolean bl) {
        block5: {
            try {
                long l;
                long l2 = IniFile.getLastModified(servicesIni);
                if (queryDDMap.get("iniLastmodified") == null) {
                    queryDDMap.put("iniLastmodified", l2);
                    this.readEgServiceIni(bl);
                }
                if (l2 > (l = ((Long)queryDDMap.get("iniLastmodified")).longValue())) {
                    if (bl) {
                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo", "Change exists on eg_service.ini & Last Modified : " + l2);
                    }
                    this.readEgServiceIni(bl);
                    queryDDMap.put("iniLastmodified", l2);
                }
            }
            catch (Exception exception) {
                if (!bl) break block5;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void readEgServiceIni(boolean bl) {
        block2: {
            try {
                IniFile iniFile = new IniFile(servicesIni);
                hashMapClearSecond = this.stringToLong(iniFile.getValue(multiDDSubject, "ClearSucessFailureStatistics"), 300L);
                failurePercentLimit = this.stringToInt(iniFile.getValue(multiDDSubject, "FailureQueryRatePercentage"), 30);
            }
            catch (Exception exception) {
                if (!bl) break block2;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatistics() {
        block31: {
            boolean bl = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
            try {
                String string;
                if (queryDDMap.get("timestamp") == null) {
                    queryDDMap.put("timestamp", System.currentTimeMillis());
                }
                boolean bl2 = this.isMultiThreadMode();
                this.mergeStatisticsHashMap(bl2, bl);
                this.checkForUpdateEgServiceIni(bl);
                int n = 0;
                int n2 = 0;
                String string2 = bl2 ? "multithread" : "singlethread";
                ArrayList arrayList = (ArrayList)queryDDMap.get(string2);
                if (arrayList != null && arrayList.size() > 0) {
                    double d = Double.valueOf(arrayList.get(0) + "");
                    double d2 = Double.valueOf(arrayList.get(1) + "");
                    double d3 = Double.valueOf(arrayList.get(2) + "");
                    if (d > 0.0) {
                        n = (int)Math.round(d2 / d * 100.0);
                        n2 = (int)Math.round(d3 / d * 100.0);
                    }
                    if (bl) {
                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - THREAD :::", this.getThreadName() + " Is from Executor Pool? " + bl2);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string3 = string2.equals("multithread") ? "MULTI THREAD" : "SINGLE THREAD";
                        stringBuilder.append("MODE Type  - ").append(string3);
                        stringBuilder.append("\tTotal :").append(d);
                        stringBuilder.append("\tSuccess :").append(d2).append(" (").append(n).append("%)");
                        stringBuilder.append("\tFailure :").append(d3).append(" (").append(n2).append("%)");
                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - UpdateStatistics", stringBuilder.toString());
                    }
                }
                MultiThreadDD multiThreadDD = MultiThreadDD.getInstance("Dbinfo");
                if (n2 >= failurePercentLimit && bl2) {
                    if (!isFailure) {
                        string = SWITCH_SYNC;
                        synchronized (string) {
                            if (!isFailure) {
                                try {
                                    preSingleFailurePercent.set(failurePercentLimit);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.updateEgServiceIni(multiDDSubject, multiDDKeyword, "no");
                                IniFile iniFile = new IniFile(servicesIni);
                                multiThreadDD.getMultiThreadSettings(iniFile);
                                isFailure = true;
                                if (bl) {
                                    String string4 = "FAILURE % is crossing " + failurePercentLimit + "% & above. Switching MODE from MULTI to SINGLE Thread - " + this.getThreadName();
                                    MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", string4);
                                    if (multiThreadDD.getExecutor() != null) {
                                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", "Executor Object " + multiThreadDD.getExecutor().toString());
                                    } else {
                                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", "Executor Object is NULL");
                                    }
                                }
                            }
                        }
                    }
                } else if (n2 == 0 && !bl2 && multiThreadDD.getExecutor() == null && preSingleFailurePercent.get() == 0) {
                    string = SWITCH_SYNC;
                    synchronized (string) {
                        if (multiThreadDD.getExecutor() == null) {
                            this.updateEgServiceIni(multiDDSubject, multiDDKeyword, "yes");
                            IniFile iniFile = new IniFile(servicesIni);
                            multiThreadDD.getMultiThreadSettings(iniFile);
                            isFailure = false;
                            if (bl) {
                                String string5 = "FAILURE % is ZERO. Switching MODE from SINGLE to MULTI Thread  - " + this.getThreadName();
                                MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", string5);
                            }
                        }
                    }
                }
                if (this.lock.isLocked()) {
                    return;
                }
                this.lock.lock();
                try {
                    this.clearStatistics(bl2, n2, bl, string2);
                }
                catch (Exception exception) {
                    if (bl) {
                        MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (Exception exception) {
                if (!bl) break block31;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void clearStatistics(boolean bl, int n, boolean bl2, String string) {
        long l = (Long)queryDDMap.get("timestamp");
        long l2 = System.currentTimeMillis();
        long l3 = (l2 - l) / 1000L;
        if (l3 >= hashMapClearSecond) {
            if (!bl) {
                preSingleFailurePercent.set(n);
            } else {
                preSingleFailurePercent.set(0);
            }
            ArrayList arrayList = (ArrayList)queryDDMap.get("singlethread");
            ArrayList arrayList2 = (ArrayList)queryDDMap.get("multithread");
            if (arrayList != null && arrayList.size() > 0) {
                queryDDMap.put("singlethread", new ArrayList());
                if (bl2) {
                    MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - Clearing", "statistics data for " + string + " & Failure % during last time is " + preSingleFailurePercent.get());
                }
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                queryDDMap.put("multithread", new ArrayList());
                if (bl2) {
                    MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - Clearing", "statistics data for " + string + " & Failure % during last time is " + preSingleFailurePercent.get());
                }
            }
            queryDDMap.put("timestamp", l2);
        }
    }

    private void incrementSummaryDetails(ArrayList arrayList, Integer n) {
        try {
            int n2 = (Integer)arrayList.get(n);
            arrayList.set(n, n2 + 1);
        }
        catch (Exception exception) {
            arrayList.set(n, 1);
        }
    }

    private void nullCheckeStack(ArrayList arrayList, Integer n, String string) {
        try {
            String string2 = (String)arrayList.get(n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append("\r\n");
            stringBuffer.append(string);
            arrayList.set(n, stringBuffer.toString());
        }
        catch (Exception exception) {
            arrayList.set(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEgServiceIni(String string, String string2, String string3) {
        IniFile iniFile = EgConfigFilesSync.getInstance(servicesIni);
        try {
            iniFile.setValue(string, string2, string3);
            iniFile.saveFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            EgConfigFilesSync.releaseInstance(iniFile);
        }
    }

    private int stringToInt(String string, int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    private long stringToLong(String string, long l) {
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string.trim());
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    private String getThreadName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Thread.currentThread().getName()).append(" (").append(Thread.currentThread().getId()).append(")");
        return stringBuilder.toString();
    }

    private boolean isMultiThreadMode() {
        String string = this.getThreadName();
        boolean bl = false;
        if (string.indexOf("DD-DataInsertThread") != -1) {
            bl = true;
        }
        return bl;
    }

    public String eStack(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        return string;
    }

    public static ConcurrentHashMap getFailureSuccessResultMap() {
        return queryDDMap;
    }

    static {
        SWITCH_SYNC = new String("Switch");
        preSingleFailurePercent = new AtomicInteger(0);
        instance = new MultiThreadDDInfo();
        excludeTableList.add("BTM_SQL_QUERIES");
        excludeTableList.add("EXTERNAL_SERVICE_DETAILS");
        excludeTableList.add("BTM_EXN_MASTER");
        excludeTableList.add("BTM_EXN_STACKTRACE");
        excludeTableList.add("BTM_EXN_DETAILS");
        excludeTableList.add("BTM_SQL_DETAILS");
        excludeTableList.add("BTM_USER_EXPERIENCE");
        excludeTableList.add("BUSINESSTRANSTEST_DDD");
        excludeTableList.add("KBUSINESSTRANSTEST_DDD");
    }
}

