/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;

public class IPV6Helper {
    private static String validHexaStr = "0123456789abcdefABCDEF";
    public static ConcurrentHashMap IpV6HostDnsCacheTime = new ConcurrentHashMap();
    public static ConcurrentHashMap IpV6HostDnsName = new ConcurrentHashMap();
    public static ConcurrentHashMap HostIpv4AddressCacheTime = new ConcurrentHashMap();
    public static ConcurrentHashMap HostIpv4Address = new ConcurrentHashMap();

    public static String getValidIPAddress(String string) {
        boolean bl = IPV6Helper.validateIPV6(string);
        if (bl) {
            string = "[" + string + "]";
        }
        return string;
    }

    private static ArrayList myTokenizer(String string, char c) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            string2 = string.substring(n, n2).trim();
            arrayList.add(string2);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        string2 = string.substring(n).trim();
        arrayList.add(string2);
        return arrayList;
    }

    public static boolean validateIPV6(String string) {
        boolean bl = false;
        try {
            if (string.indexOf(":") > 0) {
                ArrayList arrayList = IPV6Helper.myTokenizer(string, ':');
                int n = arrayList.size();
                if (n > 8) {
                    return bl;
                }
                for (int i = 0; i < n; ++i) {
                    int n2;
                    String string2 = (String)arrayList.get(i);
                    if (string2 == null || (n2 = string2.length()) == 0) continue;
                    if (string2.indexOf(".") > 0) {
                        if (IPV6Helper.validateIPV4(string2)) continue;
                        return bl;
                    }
                    if (n2 <= 4) {
                        if (IPV6Helper.validHexaDecimal(string2)) continue;
                        return bl;
                    }
                    return bl;
                }
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validateIPV4(String string) {
        try {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) != '.' || string.charAt(i + 1) != '.') continue;
                return false;
            }
            ArrayList arrayList = IPV6Helper.myTokenizer(string, '.');
            if (arrayList.size() != 4) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                String string2 = (String)arrayList.get(i);
                try {
                    int n2 = Integer.parseInt(string2);
                    if (n2 >= 0 && n2 <= 255) continue;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validHexaDecimal(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (validHexaStr.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static String getValidIPForHostName(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        try {
            long l;
            long l2 = 0L;
            long l3 = System.currentTimeMillis();
            Long l4 = (Long)HostIpv4AddressCacheTime.get(string);
            string2 = (String)HostIpv4Address.get(string);
            if (l4 != null) {
                l2 = l4;
            }
            if ((l = l3 - l2) < EgConfigInfo.msecPerHour) {
                return string2;
            }
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getHostAddress();
            if (string2 != null) {
                HostIpv4AddressCacheTime.put(string, new Long(l3));
                HostIpv4Address.put(string, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getHostnameForIPV6(String string) {
        if (string == null) {
            return null;
        }
        try {
            int n;
            int n2;
            long l;
            long l2 = 0L;
            long l3 = System.currentTimeMillis();
            String string2 = null;
            Long l4 = (Long)IpV6HostDnsCacheTime.get(string);
            string2 = (String)IpV6HostDnsName.get(string);
            if (l4 != null) {
                l2 = l4;
            }
            if ((l = l3 - l2) < EgConfigInfo.msecPerHour) {
                return string2;
            }
            ExtendedResolver extendedResolver = new ExtendedResolver();
            Name name = ReverseMap.fromAddress((String)string);
            Record record = Record.newRecord((Name)name, (int)(n2 = 12), (int)(n = 1));
            Message message = Message.newQuery((Record)record);
            Message message2 = extendedResolver.send(message);
            Record[] recordArray = message2.getSectionArray(1);
            string2 = recordArray.length == 0 ? string : recordArray[0].rdataToString();
            if (string2 != null) {
                IpV6HostDnsCacheTime.put(string, new Long(l3));
                IpV6HostDnsName.put(string, string2);
            }
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getIPv6FormatURL(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.lastIndexOf(":");
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        if ((n = string2.indexOf(":")) == -1) {
            return string;
        }
        String string3 = "";
        if (string.toLowerCase().startsWith("http")) {
            n = string.indexOf("/");
            if (n < 0) {
                return string;
            }
            string3 = string.substring(0, n + 2);
            string2 = string.substring(n + 2);
        } else {
            string2 = string;
        }
        n = string2.lastIndexOf(":");
        String string4 = string2.substring(n);
        string2 = string2.substring(0, n);
        return string3 + "[" + string2 + "]" + string4;
    }

    public static void main(String[] stringArray) {
        System.out.println("Hello World!");
    }
}

