/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.ConnectionThread;
import com.eg.EgConMonHelper;
import com.eg.EgConfigInfo;
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HttpConnectionHelper
extends Thread {
    private String ssl;
    private String ip;
    private String port;
    private String managerUrl;
    private URL url;
    private int responseCode = 500;
    private String responseMessage = "Internal Server Error";
    private boolean flag;
    private long msecPerMin = 60000L;
    private long responseCodeTimeout = 1L * this.msecPerMin;
    private int maxBurst = 25;
    private long minimumSleep = 250L;
    private long maxSleep = this.msecPerMin / 2L;

    public HttpConnectionHelper(String string, String string2, String string3) {
        this.ssl = string;
        this.ip = string2;
        this.port = string3;
        this.setName("HttpConnectionHelper");
        this.setDaemon(true);
    }

    public HttpConnectionHelper(String string) {
        this.managerUrl = string;
        if (string != null && string.length() > 0 && string.indexOf(":") > 0) {
            this.ssl = string.substring(0, string.indexOf(":"));
        }
        this.setName("HttpConnectionHelper");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection getConnection(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            if (this.ssl.equals("https")) {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
            try {
                this.url = this.managerUrl != null && this.managerUrl.length() > 0 ? new URL(this.managerUrl + string) : new URL(this.ssl + "://" + this.ip + ":" + this.port + string);
                httpURLConnection = (HttpURLConnection)this.url.openConnection();
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
                this.responseCode = httpURLConnection.getResponseCode();
                this.responseMessage = httpURLConnection.getResponseMessage();
            }
            catch (ConnectException connectException) {
                this.responseCode = 503;
                this.responseMessage = "Service Unavailable";
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.responseCode = 404;
                this.responseMessage = "Not Found";
            }
            catch (Exception exception) {
                this.responseCode = 500;
                this.responseMessage = "Internal Server Error";
                return this.responseMessage;
            }
        }
        catch (Exception exception) {
            this.responseCode = 500;
            this.responseMessage = "Internal Server Error";
            return this.responseMessage;
        }
        finally {
            return httpURLConnection;
        }
    }

    public ArrayList getElementData(String string, String string2, String string3) {
        try {
            String string4 = "/final/servlet/com.eg.EgExternalSupportServlet?whoami=" + EgConMonHelper.whoami + "&pwd=" + EgConMonHelper.pwd + "&paramKey=" + EgURLEncoder.encode(string, "UTF-8") + "&paramValue=" + EgURLEncoder.encode(string2, "UTF-8") + "&filterName=" + EgURLEncoder.encode(string3, "UTF-8");
            HttpURLConnection httpURLConnection = this.getConnection(string4);
            if (httpURLConnection != null && this.responseCode == 200) {
                ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, true);
                boolean bl = this.checkForTimeout(connectionThread);
                if (bl) {
                    ArrayList arrayList;
                    if (connectionThread.code == 200 && (arrayList = connectionThread.data) != null && arrayList.size() > 0) {
                        return arrayList;
                    }
                } else {
                    System.out.println("Response Timed Out ... ");
                }
            } else if (this.responseCode == 401) {
                System.out.println("");
                System.out.println("Unauthorized access ... ");
            } else if (this.responseCode == 404) {
                System.out.println("");
                System.out.println("Requested file was not found : " + httpURLConnection);
            } else if (this.responseCode == 503) {
                System.out.println("");
                System.out.println("Service Unavailable ... ");
            } else if (this.responseCode == 500) {
                System.out.println("");
                System.out.println("Internal Server Error ... ");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = this.responseCodeTimeout / 2L;
        long l3 = this.msecPerMin * 5L;
        if ((l2 = l2 * (long)this.maxBurst / 25L) > l3) {
            l2 = l3;
        } else if (l2 < this.msecPerMin) {
            l2 = this.msecPerMin;
        }
        long l4 = 0L;
        long l5 = 250L;
        do {
            if (EgConfigInfo.todie) {
                return false;
            }
            long l6 = System.currentTimeMillis();
            if (l5 < this.minimumSleep) {
                l5 = this.minimumSleep;
            } else if (l5 > this.maxSleep) {
                l5 = this.maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connectionThread.done) {
                return true;
            }
            long l7 = System.currentTimeMillis();
            long l8 = l7 - l6;
            if ((l4 += l8) >= l2 || l8 < 0L) {
                connectionThread.interrupt();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connectionThread.stop();
                return false;
            }
            l = l5;
            if (l2 - l4 >= l) continue;
            l = l2 - l4;
        } while ((l5 = l) > 0L);
        connectionThread.interrupt();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionThread.stop();
        return false;
    }
}

