/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.CreateIndex;
import com.eg.EgCrypt;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;

public class ExecuteIndex {
    private Connection conn = null;
    private Statement st = null;
    private String dbType = null;
    private String db_driver = null;
    private String conn_string = null;
    private String db_user = null;
    private String db_password = null;
    private String ntlmV2 = null;
    private String fileName = null;
    private String query = "";
    private boolean isOracle = false;
    String dbdir = EgInstallInfo.getInstallDir() + "/manager/config/eg_db.ini";
    private boolean isPartitionEnabled = false;
    private String partitionString = "";
    private boolean isOnline = true;
    BufferedWriter fw = null;

    public ExecuteIndex() {
        this("online");
    }

    public ExecuteIndex(String string) {
        try {
            IniFile iniFile = new IniFile(this.dbdir);
            this.dbType = iniFile.getValue("DB_PROPERTIES", "DB_Server_Type");
            this.db_driver = iniFile.getValue("DB_PROPERTIES", "sql.driver");
            this.conn_string = iniFile.getValue("DB_PROPERTIES", "sql.url");
            this.db_user = iniFile.getValue("DB_PROPERTIES", "sql.user");
            this.ntlmV2 = iniFile.getValue("DB_PROPERTIES", "sql.ntlmv2");
            this.db_password = EgCrypt.decrypt(iniFile.getValue("DB_PROPERTIES", "sql.password")).trim();
            this.partitionString = iniFile.getValue("DB_PROPERTIES", "EnableTablePartition");
            boolean bl = this.setConnection();
            if (this.dbType.equalsIgnoreCase("EgOracleAdapter")) {
                this.isOracle = true;
            }
            if (!bl) {
                System.err.println("Error in Establishing Database Connection.");
                return;
            }
            if (this.partitionString != null && this.partitionString.equalsIgnoreCase("yes")) {
                this.isPartitionEnabled = true;
            }
            if (string != null && string.equalsIgnoreCase("offline")) {
                this.isOnline = false;
            }
            CreateIndex createIndex = new CreateIndex(string);
            System.out.println("Created the indexCreation.sql file in <eGInstallDir>/bin/database folder");
            System.out.println("Now going to execute the indexes in the database....");
            System.out.println("I am going to sleep for 30 seconds. If you want to stop me, stop now....");
            System.out.println(" <ExecuteIndex> isPartitionEnabled :" + this.isPartitionEnabled + " isOnline :" + this.isOnline);
            Thread.sleep(30000L);
            this.executeIndexes();
            try {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("Error Creating the Indexes ... " + exception.toString());
            exception.printStackTrace();
            try {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private void executeIndexes() {
        String string = System.getProperty("file.separator");
        String string2 = "";
        string2 = this.isOracle ? EgInstallInfo.getInstallDir() + string + "bin" + string + "database" + string + "indexCreation.sql" : EgInstallInfo.getInstallDir() + string + "bin" + string + "database" + string + "/mssql/indexCreation.sql";
        File file = new File(string2);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = "";
            String string4 = "";
            while ((string4 = bufferedReader.readLine()) != null) {
                if (!(string3 = string3 + string4).endsWith(";")) continue;
                this.query = string3;
                string3 = "";
                System.out.println(" <executeIndexes> Query : " + this.query);
                if (this.isPartitionEnabled && !this.isOnline && this.query.indexOf(" MOVE") > -1) continue;
                boolean bl = this.createIndexNow(this.query);
                System.out.println(" <ExecuteIndex> b : " + bl);
                if (!bl) {
                    System.out.println(" <ExecuteIndex> Query " + this.query + " >>failed to execute..");
                    continue;
                }
                System.out.println("Query :" + this.query + " Successful..");
            }
            if (this.st != null) {
                this.st.close();
            }
            System.out.println("success in executing Queries which defragments indexes in Databse");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (this.st != null) {
                    this.st.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private boolean createIndexNow(String string) {
        if (this.isOracle) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            boolean bl = this.st.execute(string);
            return true;
        }
        catch (Exception exception) {
            System.out.println(" <ExecuteIndex> Exception while execute index statements str :" + exception.toString() + " query String ::" + string);
            exception.printStackTrace();
            return false;
        }
    }

    private boolean setConnection() {
        try {
            Class.forName(this.db_driver);
            int n = this.db_user.indexOf("\\");
            if (n < 0) {
                n = this.db_user.indexOf("/");
            }
            if (n < 0) {
                this.conn = DriverManager.getConnection(this.conn_string, this.db_user, this.db_password);
            } else {
                String string = this.db_user.substring(0, n);
                String string2 = this.db_user.substring(n + 1);
                Properties properties = new Properties();
                properties.put("user", string2);
                properties.put("password", this.db_password);
                properties.put("domain", string);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.conn_string, properties);
            }
            this.st = this.conn.createStatement();
            return true;
        }
        catch (Exception exception) {
            System.err.println("Problem In DB Connection : " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.setProperty("jsse.enableCBCProtection", "false");
            if (stringArray != null && stringArray.length == 1) {
                ExecuteIndex executeIndex = new ExecuteIndex(stringArray[0]);
            } else {
                System.out.println("Enter your Choice of Index Creation offline or online [DEFAULT:Online] : ");
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = bufferedReader.readLine().trim();
                if (string == null) {
                    System.err.println("Invalid Input ");
                } else {
                    string = string.trim();
                    ExecuteIndex executeIndex = new ExecuteIndex(string);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

