/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgCrypt;
import com.eg.EgThresholdInfo;
import com.eg.IniFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class EgTesterInfo {
    private static long lastImmThresholdCheckTime = 0L;
    private static ArrayList immThresholds = new ArrayList();
    private static long immTimeout = 3L * EgConfigInfo.msecPerMin;
    private boolean isAgent = false;
    private static IniFile testsFilePtr;
    private static IniFile formatFilePtr;
    private static String entity;
    private static String testsFileName;
    private static String formatFileName;
    private static long lastModifiedTime;
    private static long lastSize;
    private static ArrayList globalThresholdList;
    private static ConcurrentHashMap encryptedDesc;
    private static Hashtable descriptorValues;
    private static Hashtable allowNegativeValues;
    private static boolean allImmediate;
    private static String syncString;
    private static final String AGENT_SETTINGS = "AGENT_SETTINGS";
    private static final String EXCLUDE_APPLICATIONS = "EXCLUDE_APPLICATIONS";
    private static final String MAX_DD_UPLOAD_LENGTH = "MAX_DD_UPLOAD_LENGTH";
    private static final String THRESHOLD_TESTS = "THRESHOLD_TESTS";
    private static final String TEST_DEFINITIONS = "TEST_DEFINITIONS";
    private static final String TEST_MAPPING = "TEST_MAPPING";
    private static final String PROCESS_DESCRIPTIONS = "PROCESS_DESCRIPTIONS";
    private static final String RUM_SERVICENAME_MAPPING = "RUM_ServiceName_Mapping";
    private static Hashtable agentSettings;
    private static Hashtable excludeApplications;
    private static Hashtable maxDDLength;
    private static Hashtable thresholdTests;
    private static Hashtable testDefinitions;
    private static Hashtable testMappings;
    private static Hashtable processDescMappings;
    private static Hashtable SrvceNameGUIDCompNameMapping;
    private static String managerVersion;
    private static String configManagerEnabled;
    private static String normalFrequency;
    private static String badFrequency;
    private static String externalAgentRunsAllAggTests;
    public static int MAX_WORDS;
    private static Hashtable maxDDLineCount;
    private static final String MAX_DD_UPLOAD_LINE_COUNT = "MAX_DD_UPLOAD_LINE_COUNT";

    public static void main(String[] stringArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgTesterInfo(String string) {
        if (string.equalsIgnoreCase("agent")) {
            this.isAgent = true;
        }
        if (testsFileName == null) {
            String string2 = syncString;
            synchronized (string2) {
                if (testsFileName == null) {
                    this.clearTables();
                    entity = string;
                    EgConfigInfo egConfigInfo = new EgConfigInfo(string);
                    testsFileName = this.isAgent ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egTestConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egTestConfigFile);
                    lastModifiedTime = this.lastModified();
                    lastSize = this.lastSize();
                    if (!this.isAgent) {
                        formatFileName = new String(EgConfigInfo.egMgrConfigDir + "eg_format.ini");
                        formatFilePtr = new IniFile(formatFileName);
                        this.initForManager();
                    } else {
                        this.initForAgent();
                    }
                }
            }
        }
    }

    public double getEgTimesyncforEsxUptime() {
        String string = null;
        double d = 300.0;
        this.checkForUpdate();
        string = (String)agentSettings.get("ClockSyncTimeForEsxUptime");
        if (string == null || string.length() == 0) {
            return d;
        }
        try {
            double d2 = Double.parseDouble(string);
            d = d2 < 0.0 ? d2 : d2 * 60.0;
        }
        catch (Exception exception) {
            d = 300.0;
        }
        return d;
    }

    public long getTimeoutforVMusedPool() {
        long l = 900000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeoutforVMusedPool");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string) * 1000L;
        }
        catch (Exception exception) {
            l = 900000L;
        }
        return l;
    }

    private String getValueForAgent(String string, String string2) {
        IniFile iniFile = new IniFile(testsFileName);
        String string3 = iniFile.getValue(string, string2);
        iniFile = null;
        return string3;
    }

    private String[] getSubjectsForAgent() {
        IniFile iniFile = new IniFile(testsFileName);
        String[] stringArray = iniFile.getSubjects();
        iniFile = null;
        return stringArray;
    }

    private String[] getVariablesForAgent(String string) {
        IniFile iniFile = new IniFile(testsFileName);
        String[] stringArray = iniFile.getVariables(string);
        iniFile = null;
        return stringArray;
    }

    private Vector getAllValuesForAgent(String string, boolean bl) {
        IniFile iniFile = new IniFile(testsFileName);
        Vector vector = iniFile.getAllValues(string, bl);
        iniFile = null;
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllSections() {
        String[] stringArray = null;
        if (this.isAgent) {
            stringArray = this.getSubjectsForAgent();
            return stringArray;
        }
        this.checkForUpdate();
        String string = syncString;
        synchronized (string) {
            return testsFilePtr.getSubjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllVars(String string) {
        String[] stringArray = null;
        if (this.isAgent) {
            stringArray = this.getVariablesForAgent(string);
            return stringArray;
        }
        this.checkForUpdate();
        String string2 = syncString;
        synchronized (string2) {
            return testsFilePtr.getVariables(string);
        }
    }

    public String getValueFor(String string, String string2) {
        return this.getValueFor(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueFor(String string, String string2, boolean bl) {
        String string3 = null;
        if (this.isAgent) {
            string3 = this.getValueForAgent(string, string2);
            return string3;
        }
        if (bl) {
            this.checkForUpdate();
        }
        String string4 = syncString;
        synchronized (string4) {
            return testsFilePtr.getValue(string, string2);
        }
    }

    public Vector getAllValuesFor(String string, String[] stringArray) {
        return this.getAllValuesFor(string, stringArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllValuesFor(String string, String[] stringArray, boolean bl) {
        Vector vector = null;
        if (this.isAgent) {
            vector = this.getAllValuesForAgent(string, bl);
            return vector;
        }
        if (bl) {
            this.checkForUpdate();
        }
        String string2 = syncString;
        synchronized (string2) {
            return testsFilePtr.getAllValues(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getJavaProcesses() {
        Object object;
        ArrayList<String> arrayList = null;
        String string = null;
        if (this.isAgent) {
            string = this.getValueForAgent("STOP_EG", entity);
        } else {
            this.checkForUpdate();
            object = syncString;
            synchronized (object) {
                string = testsFilePtr.getValue("STOP_EG", entity);
            }
        }
        if (string != null && string.length() > 0) {
            arrayList = new ArrayList<String>();
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        return arrayList;
    }

    public double getMaintenanceUpdate() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("MaintenanceUpdateInterval");
        if (string == null || string.length() == 0) {
            return 6.0;
        }
        try {
            double d = Double.parseDouble(string);
            return d;
        }
        catch (Exception exception) {
            return 6.0;
        }
    }

    public long getCFTestDelayTime() {
        String string = null;
        long l = 900000L;
        string = (String)agentSettings.get("CFTestDelay");
        if (string != null && string.length() > 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                l = 900000L;
            }
        }
        return l;
    }

    public Hashtable getTestInputs(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = null;
        stringArray = this.getAllVars(string);
        this.checkForUpdate();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], this.getValueFor(string, stringArray[i], false));
        }
        return hashtable;
    }

    public long lastModified() {
        return IniFile.getLastModified(testsFileName);
    }

    public long lastSize() {
        return IniFile.getLastSize(testsFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == lastModifiedTime && l2 == lastSize) {
            return false;
        }
        String string = syncString;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == lastModifiedTime && l2 == lastSize) {
                return false;
            }
            this.clearTables();
            lastModifiedTime = l;
            lastSize = l2;
            if (this.isAgent) {
                this.initForAgent();
            } else {
                this.initForManager();
            }
            return true;
        }
    }

    public boolean isResetHardwareForEsx() {
        boolean bl = true;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ToResetHardwareForESX");
        bl = string == null || string.length() == 0 || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        return bl;
    }

    public boolean isReportVmWithoutUserName() {
        boolean bl = false;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("report_vmserver_without_username");
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
            bl = false;
        }
        return bl;
    }

    public boolean isProxyForAllAgentCommunication() {
        boolean bl = false;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ProxyForAllAgentCommunication");
        bl = string != null && string.length() != 0 && !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
        return bl;
    }

    public boolean isInsideViewEnabled() {
        boolean bl = true;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("InsideviewEnabled");
        bl = string == null || string.length() == 0 || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProcessPattern(String string, String string2, String string3) {
        String string4 = null;
        if (this.isAgent) {
            string4 = this.getValueForAgent("OS_PROCESSPATTERN", string + ":" + string2 + ":" + string3);
            return string4;
        }
        this.checkForUpdate();
        String string5 = syncString;
        synchronized (string5) {
            string4 = testsFilePtr.getValue("OS_PROCESSPATTERN", string + ":" + string2 + ":" + string3);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProcessPattern(String string, String string2) {
        String string3;
        this.checkForUpdate();
        ArrayList arrayList = new ArrayList();
        EgConfigInfo egConfigInfo = new EgConfigInfo(entity);
        String string4 = "";
        String[] stringArray = null;
        String string5 = syncString;
        synchronized (string5) {
            stringArray = testsFilePtr.getVariables("OS_PROCESSPATTERN");
        }
        if (stringArray == null) {
            return null;
        }
        string5 = ":" + string + ":" + string2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string5)) continue;
            string3 = null;
            String string6 = syncString;
            synchronized (string6) {
                string3 = testsFilePtr.getValue("OS_PROCESSPATTERN", stringArray[i]);
            }
            arrayList.add(string3);
        }
        arrayList = EgTesterInfo.removeDuplicates(arrayList);
        IniFile iniFile = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_specs.ini");
        string3 = iniFile.getValue("TEST_INFO_DELIMITER", string2);
        if (string3 == null || string3.length() == 0) {
            string3 = "|";
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string7 = (String)arrayList.get(i);
            string4 = i == 0 ? string7 : string4 + string3 + string7;
        }
        return string4;
    }

    static ArrayList removeDuplicates(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return arrayList;
        }
        HashSet hashSet = new HashSet(arrayList);
        arrayList.clear();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public String[] getAllTests() {
        this.checkForUpdate();
        String[] stringArray = null;
        Set set = testDefinitions.keySet();
        if (set != null && set.size() > 0) {
            stringArray = new String[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                ++n;
            }
        }
        return stringArray;
    }

    public String[] getAllSmartTests() {
        this.checkForUpdate();
        String[] stringArray = null;
        Set set = testMappings.keySet();
        if (set != null && set.size() > 0) {
            stringArray = new String[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                ++n;
            }
        }
        return stringArray;
    }

    public String getTesterForTest(String string) {
        this.checkForUpdate();
        return (String)testDefinitions.get(string);
    }

    public boolean getIntersectingThresholds() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("IntersectingThresholds");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean getPreciseWindow() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("PreciseWindow");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public String getSmartTest(String string) {
        this.checkForUpdate();
        String string2 = null;
        if (testMappings != null && testMappings.size() > 0) {
            string2 = (String)testMappings.get(string);
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public boolean getInsideViewDebugs() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("InsideViewDebugs");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean getVCClusterReservations() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("VCClusterReservation");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean getNetworkCorrelation() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("NetworkCorrelation");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean getSpaceInDescriptor() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("SpaceInDescriptor");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean getRunNbtTest() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RunNbtTest");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public long getDataUploadPeriod() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DataUploadPeriod");
        if (string == null || string.length() == 0) {
            return 2000L;
        }
        long l = 2000L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 2000L;
        }
        return l;
    }

    public long getMaxLineCount() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxLineCount");
        if (string == null || string.length() == 0) {
            return 3000L;
        }
        long l = 3000L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 3000L;
        }
        return l;
    }

    public long getDDMaxLineSize() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DDMaxLineSize");
        if (string == null || string.length() == 0) {
            return 1000000L;
        }
        long l = 1000000L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 1000000L;
        }
        return l;
    }

    public long getMaxConnsForVmConnPool() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxConnsForVmConnPool");
        if (string == null || string.length() == 0) {
            return 20L;
        }
        long l = 20L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 20L;
        }
        return l;
    }

    public long getMaxConcurrentConnsForVmConnPool() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxConcurrentConnsForVmConnPool");
        if (string == null || string.length() == 0) {
            return 0L;
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 0L;
        }
        return l;
    }

    public long getMaxDDLength() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxDDLength");
        if (string == null || string.length() == 0) {
            return 200000L;
        }
        long l = 200000L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 200000L;
        }
        return l;
    }

    public long getMaxConfigTestLength() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxConfigTestLength");
        if (string == null || string.length() == 0) {
            string = "5";
        }
        int n = 5;
        long l = 0x100000L;
        try {
            n = Integer.parseInt(string);
            l = n * 1024 * 1024;
        }
        catch (Exception exception) {
            l = 0x500000L;
        }
        return l;
    }

    public int getMaxConfigTestTimeout() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxConfigTestTimeout");
        if (string == null || string.length() == 0) {
            string = "5";
        }
        int n = 5;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 5;
        }
        return n;
    }

    public String[] getKnownTypes() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("KnownFileTypes");
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList arrayList = this.myTokenizer(string, ',');
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((String)arrayList.get(i)).trim();
        }
        return stringArray;
    }

    public boolean isFrequencySet() {
        this.checkForUpdate();
        String string = normalFrequency;
        String string2 = badFrequency;
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return false;
        }
        if (!string.equals("0")) {
            return true;
        }
        return !string2.equals("0");
    }

    public int getTestThreads() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxTestThreads");
        if (string == null || string.length() == 0) {
            return 1;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public int getTimeout() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("Timeout");
        if (string == null || string.length() == 0) {
            return 10;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 10;
        }
    }

    public int getRemoteTestThreads() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxRemoteTestThreads");
        if (string == null || string.length() == 0) {
            return 1;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public double getWinpcapRestart() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("WinpcapRestart");
        if (string == null || string.length() == 0) {
            return 0.0;
        }
        try {
            double d = Double.parseDouble(string);
            return d;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public int getNBTReDisc() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("NbtReDisc");
        if (string == null || string.length() == 0) {
            return 3;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 3;
        }
    }

    public int getRemoteTimeout() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RemoteTestTimeout");
        if (string == null || string.length() == 0) {
            return 10;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 10;
        }
    }

    public int getNetworkDDWaitTime() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxWaitTimeForNetworkTestDD");
        if (string == null || string.length() == 0) {
            return 2;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 2;
        }
    }

    public int getNetworkDDHops() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxHopsForNetworkTestDD");
        if (string == null || string.length() == 0) {
            return 30;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 30;
        }
    }

    public String getDDSeparator1() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DD_separator1");
        if (string == null || string.length() == 0) {
            return ";";
        }
        return string;
    }

    public String getDDSeparator2() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DD_separator2");
        if (string == null || string.length() == 0) {
            return "|";
        }
        return string;
    }

    public ArrayList getThresholdTests() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EgConfigInfo egConfigInfo = new EgConfigInfo(entity);
        IniFile iniFile = new IniFile(egConfigInfo.getTestsFile(entity));
        String string = iniFile.getValue(THRESHOLD_TESTS, "TestName");
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        ArrayList arrayList2 = this.myTokenizer(string, ',');
        int n = arrayList2.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                arrayList.add((String)arrayList2.get(i));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDisabledTrendTests() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = null;
        this.checkForUpdate();
        String string = syncString;
        synchronized (string) {
            stringArray = testsFilePtr.getVariables("TREND_TESTS");
        }
        if (stringArray == null) {
            return arrayList;
        }
        string = new String();
        Vector vector = null;
        String string2 = syncString;
        synchronized (string2) {
            vector = testsFilePtr.getAllValues("TREND_TESTS");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = (String)vector.get(i);
            if (string == null || !string.equalsIgnoreCase("no")) continue;
            arrayList.add(stringArray[i]);
        }
        arrayList = EgTesterInfo.removeDuplicates(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getEnabledCapacityTests() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = null;
        String string = syncString;
        synchronized (string) {
            stringArray = testsFilePtr.getVariables("CAPACITY_TESTS");
        }
        if (stringArray == null) {
            return arrayList;
        }
        string = new String();
        Vector vector = null;
        String string2 = syncString;
        synchronized (string2) {
            vector = testsFilePtr.getAllValues("CAPACITY_TESTS");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = (String)vector.get(i);
            if (string == null || !string.equalsIgnoreCase("Yes")) continue;
            arrayList.add(stringArray[i]);
        }
        arrayList = EgTesterInfo.removeDuplicates(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCustomPercentileName(String string) {
        String string2 = null;
        String string3 = syncString;
        synchronized (string3) {
            string2 = testsFilePtr.getValue("CAPACITY_PLANNING_PERCENTILE", string);
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public double getDbccupdateinterval() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DBCCUpdateUsage");
        double d = -1.0;
        if (string == null || string.length() == 0) {
            return d;
        }
        try {
            d = Double.parseDouble(string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public long getCtxProcsRefreshRate() {
        long l = 30000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CtxProcsRefresh");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
            l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public long getProcessInfoRefreshRate() {
        long l = 30000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ProcessInfoRefresh");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
            l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public double getMaxSleep() {
        double d = -1.0;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxSleep");
        if (string == null || string.length() == 0) {
            return -1.0;
        }
        try {
            d = Double.parseDouble(string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public long getMaxBurst() {
        long l = -1L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AgentMaxBurst");
        if (string == null || string.length() == 0) {
            return 50L;
        }
        try {
            l = Long.parseLong(string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (l < 0L) {
            l = 50L;
        }
        return l;
    }

    public long getMgrUploadSetting() {
        long l = 4L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MgrUploadSetting");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public long getNetstatCacheTime() {
        long l = 10L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("NetstatCacheTime");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public long getHostAvailableCachePeriod() {
        long l = 30000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("HostAvailableCachePeriod");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
            l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public boolean FindCtxXpUser() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("FindCtxXpUser");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public boolean FindTermUser() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("FindTermUser");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public boolean useRandom() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("UseRandom");
        if (string == null || string.length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public boolean divideNumProcessors() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DivideNumProcessors");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public boolean capCpu100() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CapCpu100");
        if (string == null || string.length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public boolean isDDb4Measure() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DDb4Measure");
        if (string == null || string.length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public long getMeasureTimeOutForDD() {
        long l = 10L * EgConfigInfo.msecPerMin;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MeasureTimeOutForDD");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string) * EgConfigInfo.msecPerMin;
        }
        catch (Exception exception) {
            l = 10L * EgConfigInfo.msecPerMin;
        }
        return l;
    }

    public boolean getRemoteDetailed() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RemoteDetailed");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public ArrayList getNoThresholdTests() {
        ArrayList arrayList = new ArrayList();
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("NoThresholdTests");
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        string = string.trim();
        arrayList = this.myTokenizer(string, ',');
        if (thresholdTests != null && thresholdTests.size() > 0) {
            Set set = thresholdTests.keySet();
            for (String string2 : set) {
                String string3;
                if (string2.equals("TestName") || !(string3 = (String)thresholdTests.get(string2)).equalsIgnoreCase("no") && !string3.equalsIgnoreCase("false")) continue;
                arrayList.add(string2);
            }
        }
        arrayList = EgTesterInfo.removeDuplicates(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getOraAlertTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        if (this.isAgent) {
            stringArray = this.getVariablesForAgent("ORA_ALERTS");
        } else {
            this.checkForUpdate();
            String string = syncString;
            synchronized (string) {
                stringArray = testsFilePtr.getVariables("ORA_ALERTS");
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public boolean getMultiUploadForExtRem() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MultiUploadForExtRem");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public boolean getMultiUploadForInternal() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MultiUploadForInternal");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    public boolean getEncryptUsingAES() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("EncryptUsingAES");
        if (string == null || string.length() == 0) {
            EgCrypt.setCryptMode(0);
            return false;
        }
        if ((string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y")) {
            EgCrypt.setCryptMode(1);
            return true;
        }
        EgCrypt.setCryptMode(0);
        return false;
    }

    public ArrayList getWinpcapTests() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("WinpcapTests");
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        string = string.trim();
        ArrayList arrayList = this.myTokenizer(string, ',');
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConfigTestFieldSize(String string) {
        String string2 = null;
        this.checkForUpdate();
        String string3 = syncString;
        synchronized (string3) {
            string2 = testsFilePtr.getValue("CONFIG_TEST_FIELD_SIZE", string);
            if (string2 == null || string2.trim().length() == 0) {
                string2 = testsFilePtr.getValue("CONFIG_TEST_FIELD_SIZE", "Default");
            }
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 128;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDesktopAgentTests(String string) {
        String[] stringArray;
        String[] stringArray2 = null;
        Vector vector = null;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            bl = true;
        }
        if (this.isAgent) {
            stringArray = new IniFile(testsFileName);
            stringArray2 = stringArray.getVariables("DESKTOP_TESTS");
            vector = stringArray.getAllValues("DESKTOP_TESTS");
            stringArray = null;
        } else {
            this.checkForUpdate();
            stringArray = syncString;
            synchronized (stringArray) {
                stringArray2 = testsFilePtr.getVariables("DESKTOP_TESTS");
                vector = testsFilePtr.getAllValues("DESKTOP_TESTS");
            }
        }
        if (stringArray2 == null || stringArray2.length == 0 || vector == null) {
            return null;
        }
        stringArray = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            StringBuffer stringBuffer;
            String string2 = (String)vector.get(i);
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(512);
            synchronized (stringBuffer2) {
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append("=");
                stringBuffer.append(string2);
                if (!bl) {
                    int n = -1;
                    int n2 = 0;
                    String string3 = stringBuffer.toString();
                    while ((n = string3.indexOf("<host-name>", n2)) >= 0) {
                        stringBuffer = stringBuffer.replace(n, n + 11, string);
                        n2 = n + 1;
                        string3 = stringBuffer.toString();
                    }
                }
            }
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDesktopAgentTestNames() {
        Object object;
        String[] stringArray = null;
        if (this.isAgent) {
            stringArray = this.getVariablesForAgent("DESKTOP_TESTS");
        } else {
            this.checkForUpdate();
            object = syncString;
            synchronized (object) {
                stringArray = testsFilePtr.getVariables("DESKTOP_TESTS");
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        object = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            int n = string.indexOf(":");
            if (n < 0) continue;
            ((ArrayList)object).add(string.substring(0, n));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDesktopTestFrequencies() {
        Object object;
        String[] stringArray = null;
        if (this.isAgent) {
            stringArray = this.getVariablesForAgent("DESKTOP_TESTS");
        } else {
            this.checkForUpdate();
            object = syncString;
            synchronized (object) {
                stringArray = testsFilePtr.getVariables("DESKTOP_TESTS");
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        object = new Hashtable();
        int n = stringArray.length;
        String string = "";
        String string2 = "";
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i].trim();
            int n2 = string3.indexOf(":");
            if (n2 < 0) continue;
            string = string3.substring(0, n2);
            n2 = string3.lastIndexOf(",");
            if (n2 < 0) continue;
            try {
                string2 = string3.substring(n2 + 1).trim();
                l = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                l = 300L;
            }
            ((Hashtable)object).put(string, new Long(l));
        }
        return object;
    }

    public long findHighestDesktopTestFrequency() {
        Hashtable hashtable = this.getDesktopTestFrequencies();
        if (hashtable == null || hashtable.size() == 0) {
            return 300L;
        }
        long l = 0L;
        long l2 = 0L;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            l2 = (Long)hashtable.get(enumeration.nextElement());
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public long findDesktopAgentRunningDuration(int n) {
        return this.findHighestDesktopTestFrequency() * (long)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnectionForComponent(String string) {
        Connection connection = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        System.setProperty("jsse.enableCBCProtection", "false");
        if (string != null && string.length() > 0) {
            String string6 = null;
            this.checkForUpdate();
            Object object = syncString;
            synchronized (object) {
                string6 = testsFilePtr.getValue("Ext_DB", string);
            }
            if (string6 == null || string6.length() == 0) {
                return null;
            }
            object = new StringTokenizer(string6, "$");
            if (((StringTokenizer)object).countTokens() != 4) {
                return null;
            }
            string2 = ((StringTokenizer)object).nextToken();
            string3 = ((StringTokenizer)object).nextToken();
            string4 = ((StringTokenizer)object).nextToken();
            string5 = EgCrypt.decrypt(((StringTokenizer)object).nextToken());
            if (string2.equals("")) {
                return null;
            }
            try {
                Class.forName(string2);
                String string7 = "";
                int n = string4.indexOf("\\");
                if (n < 0) {
                    n = string4.indexOf("/");
                }
                if (n < 0) {
                    connection = DriverManager.getConnection(string3, string4, string5);
                } else {
                    string7 = string4.substring(0, n);
                    string4 = string4.substring(n + 1);
                    Properties properties = new Properties();
                    properties.put("user", string4);
                    properties.put("password", string5);
                    properties.put("domain", string7);
                    connection = DriverManager.getConnection(string3, properties);
                }
            }
            catch (Exception exception) {
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getComponentTypes() {
        Vector<String> vector = null;
        String string = null;
        this.checkForUpdate();
        Object object = syncString;
        synchronized (object) {
            string = testsFilePtr.getValue("COMPONENT_TYPE", "ComponentTypes");
        }
        if (string != null && string.length() > 0) {
            vector = new Vector<String>();
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                vector.add(((StringTokenizer)object).nextToken().toUpperCase());
            }
        }
        return vector;
    }

    public boolean getVMWareDetailed() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VMWareDetailed");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getNoThresholdDescriptors() {
        Object object;
        Hashtable hashtable = new Hashtable();
        String[] stringArray = null;
        Vector vector = null;
        if (this.isAgent) {
            object = new IniFile(testsFileName);
            stringArray = ((IniFile)object).getVariables("NOTHRESHOLD_DESCRIPTORS");
            vector = ((IniFile)object).getAllValues("NOTHRESHOLD_DESCRIPTORS");
            object = null;
        } else {
            this.checkForUpdate();
            object = syncString;
            synchronized (object) {
                stringArray = testsFilePtr.getVariables("NOTHRESHOLD_DESCRIPTORS");
                vector = testsFilePtr.getAllValues("NOTHRESHOLD_DESCRIPTORS");
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return hashtable;
        }
        if (vector == null || vector.size() != stringArray.length) {
            return hashtable;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)vector.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
            hashtable.put(stringArray[i], arrayList);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getNoThresholdDescriptors(String string) {
        Object object;
        String string2 = null;
        if (this.isAgent) {
            object = new IniFile(testsFileName);
            string2 = ((IniFile)object).getValue("NOTHRESHOLD_DESCRIPTORS", string);
            object = null;
        } else {
            this.checkForUpdate();
            object = syncString;
            synchronized (object) {
                string2 = testsFilePtr.getValue("NOTHRESHOLD_DESCRIPTORS", string);
            }
        }
        if (string2 == null || string2.length() == 0) {
            return new ArrayList();
        }
        object = new StringTokenizer(string2, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            arrayList.add(((StringTokenizer)object).nextToken().trim());
        }
        return arrayList;
    }

    public boolean isUseShellForRemoteWindows() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("UseShellForVmgWindowsTests");
        if (string == null || string.length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("Yes") || string.equalsIgnoreCase("True");
    }

    public boolean isRemoteDDEnabled() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("RemoteDetailed");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("Yes") || string.equalsIgnoreCase("True");
    }

    public boolean allImmediateThresholds() {
        this.checkForUpdate();
        return allImmediate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getImmediateThresholds() {
        Object object;
        String[] stringArray = null;
        Vector vector = null;
        if (this.isAgent) {
            long l = System.currentTimeMillis();
            if (l - lastImmThresholdCheckTime < immTimeout) {
                if (immThresholds == null) {
                    return immThresholds;
                }
                String string = syncString;
                synchronized (string) {
                    return (ArrayList)immThresholds.clone();
                }
            }
            object = new IniFile(testsFileName);
            stringArray = ((IniFile)object).getVariables("IMMEDIATE_THRESHOLDS");
            vector = ((IniFile)object).getAllValues("IMMEDIATE_THRESHOLDS");
            object = null;
            lastImmThresholdCheckTime = System.currentTimeMillis();
        } else {
            this.checkForUpdate();
            String string = syncString;
            synchronized (string) {
                stringArray = testsFilePtr.getVariables("IMMEDIATE_THRESHOLDS");
                vector = testsFilePtr.getAllValues("IMMEDIATE_THRESHOLDS");
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            if (this.isAgent) {
                String string = syncString;
                synchronized (string) {
                    immThresholds = null;
                }
            }
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            object = (String)vector.get(i);
            if (object == null || ((String)object).length() == 0 || !((String)object).equalsIgnoreCase("true") && !((String)object).equalsIgnoreCase("yes")) continue;
            arrayList.add(stringArray[i]);
        }
        arrayList = EgTesterInfo.removeDuplicates(arrayList);
        if (this.isAgent) {
            String string = syncString;
            synchronized (string) {
                immThresholds = arrayList;
            }
        }
        return arrayList;
    }

    public ArrayList getGlobalThresholds() {
        this.checkForUpdate();
        return globalThresholdList;
    }

    public Hashtable getEncryptedDescriptors() {
        this.checkForUpdate();
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(encryptedDesc);
        return hashtable;
    }

    public Hashtable getEncryptedDescriptors(boolean bl) {
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(encryptedDesc);
        return hashtable;
    }

    public boolean isEncryptedDescriptor(String string) {
        return encryptedDesc.containsKey(string);
    }

    private void updateTestMappings() {
        testMappings = this.updateTables(TEST_MAPPING);
    }

    private void updateTestDefinitions() {
        testDefinitions = this.updateTables(TEST_DEFINITIONS);
    }

    private void updateThresholdTests() {
        thresholdTests = this.updateTables(THRESHOLD_TESTS);
    }

    private void updateMaxDDLength() {
        maxDDLength = this.updateTables(MAX_DD_UPLOAD_LENGTH);
    }

    private void updateExcludeApplications() {
        excludeApplications = this.updateTables(EXCLUDE_APPLICATIONS);
    }

    private void updateAgentSetting() {
        agentSettings = this.updateTables(AGENT_SETTINGS);
    }

    private void updateProcessDescriptions() {
        processDescMappings = this.updateTables(PROCESS_DESCRIPTIONS);
    }

    private void updateComponentServiceNameGUID() {
        SrvceNameGUIDCompNameMapping = this.updateTables(RUM_SERVICENAME_MAPPING);
    }

    public Hashtable getSrvceNameGUIDCompNameMapping() {
        this.checkForUpdate();
        return SrvceNameGUIDCompNameMapping;
    }

    private Hashtable updateTables(String string) {
        Vector vector;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = testsFilePtr.getVariables(string);
        if (stringArray != null && stringArray.length > 0 && (vector = testsFilePtr.getAllValues(string)) != null && vector.size() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = (String)vector.get(i);
                hashtable.put(string2, string3);
            }
        }
        return hashtable;
    }

    private void clearTables() {
        descriptorValues.clear();
        allowNegativeValues.clear();
        agentSettings.clear();
        excludeApplications.clear();
        maxDDLength.clear();
        thresholdTests.clear();
        testDefinitions.clear();
        testMappings.clear();
        processDescMappings.clear();
        maxDDLineCount.clear();
        SrvceNameGUIDCompNameMapping.clear();
    }

    private void init() {
        this.updateGlobalThresholds();
        this.updateEncryptedDescriptors();
        this.updateAgentSetting();
        managerVersion = testsFilePtr.getValue("MANAGER_SETTINGS", "ManagerVersion");
        configManagerEnabled = testsFilePtr.getValue("LICENSE", "ConfigManagement");
        normalFrequency = testsFilePtr.getValue("FREQUENCY_MAPPING", "Normal_frequency");
        badFrequency = testsFilePtr.getValue("FREQUENCY_MAPPING", "Bad_frequency");
        externalAgentRunsAllAggTests = testsFilePtr.getValue("AGENTS_FOR_AGGREGATE_COMPONENTS", "ExternalAgentRunsAllAggTests");
        this.updateExcludeApplications();
        this.updateMaxDDLength();
        this.updateThresholdTests();
        this.updateTestDefinitions();
        this.updateTestMappings();
        this.updateProcessDescriptions();
        this.updateMaxDDLineCount();
        this.updateComponentServiceNameGUID();
        try {
            String string = testsFilePtr.getValue("MAX_WORDS_IN_CLAUSE", "MAX_WORDS");
            if (string != null && string.length() > 0) {
                MAX_WORDS = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            MAX_WORDS = 50;
        }
        if (MAX_WORDS < 1) {
            MAX_WORDS = 50;
        }
    }

    private void initForManager() {
        testsFilePtr = new IniFile(testsFileName);
        this.init();
        String string = testsFilePtr.getValue(AGENT_SETTINGS, "AllImmediateThresholds");
        allImmediate = string != null && string.length() != 0 && !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
    }

    private void initForAgent() {
        if (testsFilePtr == null) {
            testsFilePtr = new IniFile(testsFileName);
        }
        this.init();
        testsFilePtr = null;
        String string = (String)agentSettings.get("AllImmediateThresholds");
        allImmediate = string != null && string.length() != 0 && !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGlobalThresholds() {
        String[] stringArray = null;
        Object object = syncString;
        synchronized (object) {
            stringArray = testsFilePtr.getVariables("GLOBAL_THRESHOLDS");
        }
        if (stringArray == null || stringArray.length == 0) {
            globalThresholdList = null;
            return;
        }
        object = new ArrayList();
        Vector vector = null;
        String string = syncString;
        synchronized (string) {
            vector = testsFilePtr.getAllValues("GLOBAL_THRESHOLDS");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = (String)vector.get(i);
            if (string2 == null || string2.length() == 0 || !string2.equalsIgnoreCase("true") && !string2.equalsIgnoreCase("yes")) continue;
            ((ArrayList)object).add(stringArray[i]);
        }
        globalThresholdList = object = EgTesterInfo.removeDuplicates((ArrayList)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEncryptedDescriptors() {
        String[] stringArray = null;
        Object object = syncString;
        synchronized (object) {
            stringArray = testsFilePtr.getVariables("DEFAULT_ENCRYPTED_DESCRIPTORS");
        }
        if (stringArray == null || stringArray.length == 0) {
            encryptedDesc.clear();
            return;
        }
        object = new ConcurrentHashMap(encryptedDesc);
        for (int i = 0; i < stringArray.length; ++i) {
            if (((ConcurrentHashMap)object).containsKey(stringArray[i])) {
                ((ConcurrentHashMap)object).remove(stringArray[i]);
                continue;
            }
            encryptedDesc.put(stringArray[i], new Boolean(true));
        }
        Enumeration enumeration = ((ConcurrentHashMap)object).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            encryptedDesc.remove(string);
        }
    }

    public int getMaxVmgThreads() {
        int n = 10;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxVmgThreads");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public int getMaxDockerThreads() {
        int n = 8;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxDockerThreads");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 8;
        }
        return n;
    }

    public long getCachePeriod_VmGuestsInfo() {
        int n = 10;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CachePeriod_VmGuestsInfo");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public long getCachePeriod_VCVmGuestsInfo() {
        int n = 10;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CachePeriod_VCVmGuestsInfo");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public double getCachePeriod_LoggedOnUsers() {
        double d = 5.0;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CachePeriod_LoggedOnUsers");
        if (string == null || string.length() == 0) {
            return d;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 5.0;
        }
        return d;
    }

    public long getCachePeriod_OsInfo() {
        int n = 10;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CachePeriod_OsInfo");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public int getVmgCommandTimeOut() {
        int n = 240;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmgCommandTimeOut");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 240;
        }
        return n;
    }

    public int getLparCommandTimeOut() {
        int n = 240;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("LparCommandTimeOut");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 240;
        }
        return n;
    }

    public int getMaxRdpClientThreads() {
        int n = 10;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxRdpClientThreads");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public int getMaxIcaClientThreads() {
        int n = 10;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxIcaClientThreads");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public String getVmGuestsScript() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmGuestsScript");
        if (string == null || string.length() == 0) {
            return "getinfo.sh";
        }
        return string;
    }

    public long getMaxTimer() {
        long l = -1L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxTimer");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    public String getCScriptOptionalParams() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CScriptOptionalParams");
        if (string == null || string.length() == 0) {
            return "";
        }
        string = string.trim();
        return string;
    }

    public boolean isVmDebugEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmDebugEnabled");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean hasToUseJavaSshForVm() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("JavaSshForVm");
        if (string == null || string.length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean hasToEncryptVmAgentData() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("EncryptVmAgentData");
        if (string == null || string.length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean isVmwareExecForInternalAgent() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmwareExecForInternalAgent");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean isReportClusterPerformance() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ReportClusterPerformance");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean isVmwareExecForRemoteAgent() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmwareExecForRemoteAgent");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean hasToUseJavaSshForRemoteAgent() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("JavaSshForRemoteAgent");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean hasToReportVmNameInLowerCase() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmNameInLowercase");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public long getTimeOutForJavaSsh() {
        long l = 60L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeOutForJavaSsh");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 60L;
        }
        return l;
    }

    public long getTimeOutForLparSsh() {
        long l = 60000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeOutForLparSsh");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string) * 1000L;
        }
        catch (Exception exception) {
            l = 60000L;
        }
        return l;
    }

    public int[] getJavaSshPortForVm() {
        int[] nArray = new int[]{22};
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("JavaSshPortForVm");
        if (string == null || string.length() == 0) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray2 = null;
        if (stringTokenizer != null) {
            int n = stringTokenizer.countTokens();
            nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                try {
                    String string2 = stringTokenizer.nextToken();
                    nArray2[i] = Integer.parseInt(string2);
                    continue;
                }
                catch (Exception exception) {
                    nArray2[i] = 22;
                }
            }
        }
        return nArray2;
    }

    public long getTimeOutForVmAPI() {
        long l = 60L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeOutForVmAPI");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 60L;
        }
        return l;
    }

    public long getTimeOutForVmConnPool() {
        long l = 900L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeOutForVmConnPool");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 900L;
        }
        return l;
    }

    public long getTimeOutForEsxHealthCheck() {
        long l = 1800L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeOutForEsxHealthCheck");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 1800L;
        }
        return l;
    }

    public boolean hasToUseDnsNameForVmGetInfo() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("UseDnsNameForVmGetInfo");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public String getDsRefreshXmxValue() {
        String string = "256M";
        String string2 = null;
        this.checkForUpdate();
        string2 = (String)agentSettings.get("DatastoreRefreshXmx");
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        string = string2.trim();
        return string;
    }

    private ArrayList myTokenizer(String string, char c) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            string2 = string.substring(n, n2);
            arrayList.add(string2.trim());
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        string2 = string.substring(n);
        arrayList.add(string2.trim());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList DefaultDDEnabledTypes() {
        if (formatFilePtr == null) {
            return new ArrayList();
        }
        String[] stringArray = null;
        Object object = syncString;
        synchronized (object) {
            stringArray = formatFilePtr.getVariables("Default_DDEnabled");
        }
        object = new ArrayList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = null;
                String string2 = syncString;
                synchronized (string2) {
                    string = formatFilePtr.getValue("Default_DDEnabled", stringArray[i]);
                }
                if (string == null || string.trim().length() <= 0 || !string.equalsIgnoreCase("yes")) continue;
                ((ArrayList)object).add(stringArray[i]);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList DefaultDDEnabledTests() {
        if (formatFilePtr == null) {
            return new ArrayList();
        }
        String[] stringArray = null;
        Object object = syncString;
        synchronized (object) {
            stringArray = formatFilePtr.getVariables("Default_DDEnabled_Test");
        }
        object = new ArrayList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = null;
                String string2 = syncString;
                synchronized (string2) {
                    string = formatFilePtr.getValue("Default_DDEnabled_Test", stringArray[i]);
                }
                if (string == null || string.trim().length() <= 0 || !string.equalsIgnoreCase("yes")) continue;
                ((ArrayList)object).add(stringArray[i]);
            }
        }
        return object;
    }

    public long getWorkingVmIpCachePeriod() {
        long l = 1800000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("WorkingVmIpCachePeriod");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string) * 1000L;
        }
        catch (Exception exception) {
            l = 1800000L;
        }
        return l;
    }

    public long getTesterSuspendPeriod() {
        long l = 500L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TesterSuspendPeriod");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 500L;
        }
        return l;
    }

    public long getWmiInsideViewPort() {
        long l = 60001L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("WmiInsideViewPort");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 60001L;
        }
        return l;
    }

    public long getMaxParalleleGRemote() {
        long l = 10L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("MaxParalleleGRemote");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 10L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDescriptorDetailsInTest() {
        this.checkForUpdate();
        if (descriptorValues != null && descriptorValues.size() > 0) {
            return descriptorValues;
        }
        String[] stringArray = null;
        if (this.isAgent) {
            IniFile iniFile = new IniFile(testsFileName);
            stringArray = iniFile.getVariables("DESCRIPTOR_DETAILS");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (descriptorValues.containsKey(stringArray[i])) continue;
                    descriptorValues.put(stringArray[i], iniFile.getValue("DESCRIPTOR_DETAILS", stringArray[i]));
                }
            }
            iniFile = null;
            return descriptorValues;
        }
        String string = syncString;
        synchronized (string) {
            stringArray = testsFilePtr.getVariables("DESCRIPTOR_DETAILS");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (descriptorValues.containsKey(stringArray[i])) continue;
                    descriptorValues.put(stringArray[i], this.getValueFor("DESCRIPTOR_DETAILS", stringArray[i], false));
                }
            }
        }
        return descriptorValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescriptorDetailsInTest(String string) {
        String string2 = "";
        if (string != null) {
            if (this.isAgent) {
                string2 = this.getValueForAgent("DESCRIPTOR_DETAILS", string);
            } else {
                this.checkForUpdate();
                String string3 = syncString;
                synchronized (string3) {
                    string2 = testsFilePtr.getValue("DESCRIPTOR_DETAILS", string);
                }
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getAllowNegativeValues() {
        this.checkForUpdate();
        if (allowNegativeValues != null && allowNegativeValues.size() > 0) {
            return allowNegativeValues;
        }
        String[] stringArray = null;
        if (this.isAgent) {
            IniFile iniFile = new IniFile(testsFileName);
            stringArray = iniFile.getVariables("ALLOW_NEGATIVE_VALUES");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (allowNegativeValues.containsKey(stringArray[i])) continue;
                    allowNegativeValues.put(stringArray[i], iniFile.getValue("ALLOW_NEGATIVE_VALUES", stringArray[i]));
                }
            }
            iniFile = null;
            return allowNegativeValues;
        }
        String string = syncString;
        synchronized (string) {
            stringArray = testsFilePtr.getVariables("ALLOW_NEGATIVE_VALUES");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (allowNegativeValues.containsKey(stringArray[i])) continue;
                    allowNegativeValues.put(stringArray[i], this.getValueFor("ALLOW_NEGATIVE_VALUES", stringArray[i], false));
                }
            }
        }
        return allowNegativeValues;
    }

    public boolean getAllowNegativeValues(String string, String string2) {
        EgThresholdInfo egThresholdInfo = new EgThresholdInfo(entity);
        String[] stringArray = egThresholdInfo.getMeasurementsForTest(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string3.equalsIgnoreCase(string2)) continue;
                string2 = string3;
                break;
            }
        }
        String string4 = "";
        boolean bl = false;
        String string5 = string + ":" + string2;
        if (string != null && string2 != null) {
            string4 = this.getValueFor("ALLOW_NEGATIVE_VALUES", string5);
        }
        if (string4.equalsIgnoreCase("True")) {
            bl = true;
        } else if (string4.equalsIgnoreCase("False") || string4.length() == 0 || string4.equalsIgnoreCase("")) {
            bl = false;
        }
        return bl;
    }

    public boolean isNegativeValuesAllowed(String string, String string2) {
        EgThresholdInfo egThresholdInfo = new EgThresholdInfo(entity);
        String[] stringArray = egThresholdInfo.getMeasurementsForTest(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string3.equalsIgnoreCase(string2)) continue;
                string2 = string3;
            }
        }
        String string4 = "";
        boolean bl = false;
        String string5 = string + ":" + string2;
        if (string != null && string2 != null) {
            string4 = this.getValueFor("ALLOW_NEGATIVE_VALUES", string5);
        }
        if (string4.equalsIgnoreCase("True")) {
            bl = true;
        } else if (string4.equalsIgnoreCase("False") || string4.length() == 0 || string4.equalsIgnoreCase("")) {
            bl = false;
        }
        return bl;
    }

    public String getFrequencyMapping() {
        String string = "";
        String string2 = normalFrequency;
        String string3 = badFrequency;
        string = string2 == null || string2.equals("") || string3 == null || string3.equals("") ? "" : string2 + ":" + string3;
        return string;
    }

    public boolean isAgentRestart() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AgentRestart");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public int getAgentRestartMemoryPct() {
        int n = 10;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AgentMemory");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public int getAgentHandleCount() {
        this.checkForUpdate();
        String string = null;
        int n = -1;
        string = (String)agentSettings.get("AgentHandlecount");
        if (string == null || string.length() == 0) {
            return -1;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public int getVmgGetCpuCachePeriod() {
        int n = 20;
        String string = null;
        this.checkForUpdate();
        string = (String)excludeApplications.get("GetCpuCachePeriod");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 20;
        }
        return n;
    }

    public boolean isAgentHeartbeatEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AgentHeartbeat");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isDDOptimizationEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DDOptimization");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public String getEgJavaSSHKeyFile() {
        String string = "none";
        String string2 = null;
        this.checkForUpdate();
        string2 = (String)agentSettings.get("EgJavaSSHKeyFile");
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        string = string2.trim();
        return string;
    }

    public long getFailedVMBrokenTimeOut() {
        long l = 20000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("FailedVMBrokenTimeOut");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string) * 1000L;
        }
        catch (Exception exception) {
            l = 20000L;
        }
        return l;
    }

    public long getFailedVmCachePeriod() {
        long l = 600000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("FailedVmCachePeriod");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
            l *= 1000L;
        }
        catch (Exception exception) {
            l = 600000L;
        }
        return l;
    }

    public long getWaitTimeForVmConnPool() {
        long l = 30000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("WaitTimeForVmConnPool");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string) * 1000L;
        }
        catch (Exception exception) {
            l = 30000L;
        }
        return l;
    }

    public boolean getAllowHashInDescriptor() {
        String string = "none";
        String string2 = null;
        this.checkForUpdate();
        string2 = (String)agentSettings.get("AllowHashInDescriptor");
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        string = string2.trim();
        return string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("true");
    }

    public boolean isTopoDiscoveryEnabled() {
        this.checkForUpdate();
        String string = null;
        string = (String)agentSettings.get("TopoDiscoveryEnabled");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public boolean isVmCombinedExecEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CombinedVmExec");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public long getVmCombinedCachePeriod() {
        long l = 240000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CombinedVmCachePeriod");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
            l *= 1000L;
        }
        catch (Exception exception) {
            l = 240000L;
        }
        return l;
    }

    public boolean isCaseSensitiveConfigCompare() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CaseSensitiveConfigCompare");
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isManagerConfigEnabled() {
        String string = null;
        this.checkForUpdate();
        string = configManagerEnabled;
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public int getEventCount() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("EventCount");
        if (string == null || string.length() == 0) {
            return 250;
        }
        int n = 250;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 250;
        }
        return n;
    }

    public boolean isCacheResultEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TestCacheEnabled");
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isToRefreshEsxDatastore() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RefreshEsxDatastore");
        if (string == null || string.length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public ArrayList getVMHarddiskName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VMHarddiskName");
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        if (stringTokenizer != null) {
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public long getEgRemoteTimeout() {
        long l = 60L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("eGRemoteTimeout");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 60L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getGZIPSupportedVersion() {
        int n;
        if (!EgConfigInfo.useGzip) {
            return 0.0;
        }
        double d = 5.6;
        this.checkForUpdate();
        String string = "";
        if (this.isAgent) {
            string = this.getValueForAgent("GZIP_SUPPORT", "ManagerVersion");
        } else {
            String string2 = syncString;
            synchronized (string2) {
                string = testsFilePtr.getValue("GZIP_SUPPORT", "ManagerVersion");
            }
        }
        if (string != null && (n = (string = string.trim()).lastIndexOf(".")) > 0) {
            string = string.substring(0, n);
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 5.6;
            }
        }
        return d;
    }

    public double getManagerVersion() {
        int n;
        double d = 5.6;
        this.checkForUpdate();
        String string = managerVersion;
        if (string != null && (n = (string = string.trim()).lastIndexOf(".")) > 0) {
            string = string.substring(0, n);
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 5.6;
            }
        }
        return d;
    }

    public boolean isUseIPEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("UseIPforWinAgentless");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isMoreInfoForXen() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("XenMoreInfo");
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public long getPublishedAppsRediscoverPeriod() {
        long l = 43200000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("PublishedAppsRediscoverPeriod");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
            l = l * 60L * 1000L;
        }
        catch (Exception exception) {
            l = 43200000L;
        }
        return l;
    }

    public ArrayList getExcludedApps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        this.checkForUpdate();
        string = (String)excludeApplications.get("DesktopOSProcesses");
        if (string == null || string.length() == 0) {
            string = (String)excludeApplications.get("DestopOSProcesses");
        }
        if (string == null || string.length() == 0) {
            string = (String)excludeApplications.get("VmgApplicationTest");
        }
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2 == null || (string2 = string2.trim().toLowerCase()).length() <= 0) continue;
                    arrayList.add(string2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public ArrayList getWhiteListApps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.checkForUpdate();
        String string = (String)excludeApplications.get("WhiteListProcesses");
        if (string == null || string.trim().length() == 0) {
            return arrayList;
        }
        try {
            string = string.toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                String string2 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().trim();
                    int n2 = string2.lastIndexOf(".exe");
                    if (n2 > 0) {
                        string2 = string2.substring(0, n2);
                    }
                    if (arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public boolean isPSSignedScriptEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("UsedSignedPSScripts");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isEsxnetworkReport() {
        String string = null;
        string = (String)agentSettings.get("esxnetwork_reportDelta");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public int getAgentHeartbeatFrequency() {
        int n = 5;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AgentHeartbeatFrequency");
        if (string == null || string.length() == 0) {
            return n * 60;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 5;
        }
        return n * 60;
    }

    public int getRCHeartbeatFrequency() {
        int n = 45;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RCHeartbeatFrequency");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 45;
        }
        return n;
    }

    public long getMaxDDUploadLength(String string) {
        String string2 = null;
        long l = 200000L;
        if (string != null && string.length() > 0) {
            string2 = (String)maxDDLength.get(string);
            try {
                if (string2 != null && string2.length() > 0) {
                    l = Long.parseLong(string2);
                } else if (string2 == null || string2.length() == 0) {
                    string2 = (String)maxDDLength.get("Default");
                    l = Long.parseLong(string2);
                }
            }
            catch (Exception exception) {
                l = 200000L;
            }
        }
        return l;
    }

    public boolean isReportNewInfoForXD7() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ReportNewInfoForXD");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isEnableBrowserMonitoring() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("EnableBrowserMonitoring");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isReportByMsecs() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ReportByMsecs");
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isShowFullName() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ShowFullName");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public long getEgAgentPerfThreadRecheckTime() {
        long l = 900L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("EgAgentPerfThreadTime");
        if (string == null || string.length() == 0) {
            return l * 1000L;
        }
        try {
            l = Long.parseLong(string);
            l *= 1000L;
        }
        catch (Exception exception) {
            l *= 1000L;
        }
        return l;
    }

    public boolean isComputeForAllTest() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ComputeForAllTest");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean hasIPChangedToRestartAgent() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AgentRestartIPChanged");
        if (string == null || string.length() == 0) {
            return true;
        }
        return !string.equalsIgnoreCase("no") && !string.equalsIgnoreCase("false");
    }

    public long getGetCpuExecMemory() {
        long l = -1L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("GetCpuExecMemory");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    public long getTimeOutForUptime() {
        long l = -1L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeOutForUptime");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    public long getUptimeFactor() {
        long l = 1L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("UptimeFactor");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 1L;
        }
        return l;
    }

    public String getJmxServiceUrlPrefix(String string) {
        String string2 = null;
        if (this.isAgent) {
            string2 = this.getValueForAgent("JMX_SERVICE_URL", string);
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "service:jmx:rmi:///jndi/rmi://";
    }

    public String getJmxProvider(String string) {
        String string2 = null;
        if (this.isAgent) {
            string2 = this.getValueForAgent("JMX_PROVIDER", string);
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "com.sun.jmx.remote.protocol";
    }

    public String getJmxDomainName() {
        String string = null;
        if (this.isAgent) {
            string = this.getValueForAgent("JMX_Domain_Name", "Domain");
        }
        if (string != null && string.length() > 0) {
            return string;
        }
        return "Catalina";
    }

    public String getContextName(String string) {
        String string2 = null;
        if (this.isAgent) {
            string2 = this.getValueForAgent("JVM_METRIC_MODE", string);
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "eGJVMMonitor";
    }

    public String getCorrectWildFlyURI(String string, int n) {
        String string2 = null;
        if (this.isAgent) {
            string2 = this.getValueForAgent("WILDFLY_RESTURLS", string + ":" + n);
        }
        return string2;
    }

    public long getvSphreRefreshRate() {
        long l = 1800000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TimeToResetHardwareForESX");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
            l = l * 60L * 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public boolean externalAgentRunsAllAggTests() {
        this.checkForUpdate();
        String string = externalAgentRunsAllAggTests;
        if (string == null || (string = string.trim()).length() == 0 || string.equalsIgnoreCase("null")) {
            string = "yes";
        }
        boolean bl = string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("t");
        return bl;
    }

    public boolean isEvaluateICANetworkLatency() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("EvaluateICANetworkLatency");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public long getvSphereFailureRestartTime() {
        String string = null;
        this.checkForUpdate();
        long l = 3600000L;
        string = (String)agentSettings.get("RestartTimeForvSphereFailure");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            long l2 = Long.parseLong(string);
            l2 = l2 * 60L * 1000L;
            return l2;
        }
        catch (Exception exception) {
            return l;
        }
    }

    public boolean getvSphereFailureRestartRequired() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RestartAgentForvSphereFailure");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean getVmConnPoolUseUsedPool() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmConnPoolUseUsedPool");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean isRemoteAgentPortEnabled() {
        boolean bl = true;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RemoteAgentPortEnabled");
        bl = string == null || string.length() == 0 ? false : string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
        return bl;
    }

    public int getRemoteAgentPort() {
        int n = 60010;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RemoteAgentPort");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 60010;
        }
        return n;
    }

    public boolean isShowUsernameInLowercase() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ShowUsernameInLowercase");
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public int getWebServerDiscoveryContentSize() {
        int n = 50;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("WebServerDiscoveryContentSize");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 50;
        }
        return n;
    }

    public int getVmAgentRequestTimeout() {
        int n = 10000;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VmAgentRequestTimeout");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
            n *= 1000;
        }
        catch (Exception exception) {
            n = 10000;
        }
        return n;
    }

    public int getXmxAllocationPercentage() {
        int n;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AllocateXpercentOfFreememoryToAgent");
        if (string == null || string.trim().length() == 0) {
            return 75;
        }
        string = string.trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("[EgTesterInfo] Unable ot read the xmx percentage value from " + testsFileName);
            return 75;
        }
        return n;
    }

    public boolean readRemoteAgentXmxChangeRequiredFlag() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RemoteAgentXmxChangeRequired");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on");
    }

    public boolean isRunAsRemoteAgent() {
        boolean bl = false;
        EgConfigInfo egConfigInfo = new EgConfigInfo(entity);
        String string = new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egAgentConfigFile);
        IniFile iniFile = new IniFile(string);
        String[] stringArray = iniFile.getSubjects();
        if (stringArray == null || stringArray.length == 0) {
            return bl;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Vector vector = iniFile.getAllValues(string2);
            if (vector == null || vector.size() == 0) {
                return bl;
            }
            for (int j = 0; j < vector.size(); ++j) {
                String string3 = (String)vector.get(j);
                if ((string3 = string3.replaceAll("\\s", "")).indexOf("-agentlessy") < 0) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTeststoComputeMsmtTimeAfterTestExecution() {
        this.checkForUpdate();
        ArrayList<String> arrayList = null;
        String string = null;
        String string2 = syncString;
        synchronized (string2) {
            IniFile iniFile = new IniFile(testsFileName);
            string = iniFile.getValue("MsmtTimeAfterTestExec", "Tests");
            if (string != null && string.trim().length() > 0) {
                arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        return arrayList;
    }

    public boolean isToCopyInsideViewExeToVms() {
        String string = null;
        boolean bl = true;
        this.checkForUpdate();
        string = (String)agentSettings.get("CopyInsideviewExeToVMs");
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        bl = (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on");
        return bl;
    }

    public long getVCOutStandingTaskMaxTime() {
        long l = 1800000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("VCOutStandingTasksMaxTime");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string) * 1000L;
        }
        catch (Exception exception) {
            l = 1800000L;
        }
        return l;
    }

    public boolean isAppPidOptimization() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("AppPidOptimization");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public boolean getIgnoreSpaceToUnderscore(String string) {
        int n;
        boolean bl = false;
        this.checkForUpdate();
        String string2 = (String)agentSettings.get("IgnoreSpaceToUnderScoreConversion");
        if (string2 != null && string2.length() > 0 && (n = string2.indexOf(string)) > -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isCitrixGeoEnabled() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("CitrixGeoEnabled");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public double getTolerance() {
        this.checkForUpdate();
        String string = (String)agentSettings.get("Tolerance");
        if (string == null || string.length() == 0) {
            return 0.1;
        }
        double d = 0.1;
        try {
            double d2 = Double.parseDouble(string);
            if (d2 > 0.0) {
                d = d2;
            }
        }
        catch (Exception exception) {
            d = 0.1;
        }
        return d;
    }

    public boolean isShowProcessDescription() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ShowProcessDescription");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public Hashtable getProcessDescription() {
        this.checkForUpdate();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = "";
        String string2 = "";
        if (processDescMappings != null) {
            Enumeration enumeration = processDescMappings.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string == null || (string2 = (String)processDescMappings.get(string)) == null || string2.trim().length() == 0) continue;
                int n = (string2 = string2.trim()).length();
                if (n > 125) {
                    string2 = string2.substring(0, 124);
                }
                if ((string = string.toLowerCase().trim()).endsWith(".exe")) {
                    int n2 = string.lastIndexOf(".");
                    string = string.substring(0, n2);
                }
                hashtable.put(string, string2);
            }
        }
        return hashtable;
    }

    public boolean isAgentInstalledInCloudInfra() {
        boolean bl = false;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("IsCloudInfraAgent");
        bl = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
        return bl;
    }

    public long getChgMgrIPorDNSRestartRequiredTime() {
        long l = -1L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ChgMgrIPorDNSRestartRequiredTime");
        if (string == null || string.length() == 0) {
            return l;
        }
        string = string.trim();
        try {
            l = Long.parseLong(string);
            l = l * 1000L * 60L;
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    public boolean getChgMgrIPorDNSRestartRequired() {
        boolean bl = false;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("ChgMgrIPorDNSRestartRequired");
        if (string == null || string.length() == 0) {
            return bl;
        }
        if ((string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    public long getBrowserUtilRefresh() {
        long l = 120000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("BrowserUtilRefresh");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
            l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSNMPRetries() {
        int n = 0;
        String string = null;
        this.checkForUpdate();
        String string2 = syncString;
        synchronized (string2) {
            string = (String)agentSettings.get("SNMPRetries");
        }
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public long getDDMaxSizePerFile() {
        long l = 0x500000L;
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("DDMaxSizePerFile");
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            l = Long.parseLong(string.trim());
            l = l * 1024L * 1024L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public boolean getJvmBlockedThreadRestartRequired() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("RestartAgentForJvmBlockedThread");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    public int getJvmBlockedCount() {
        this.checkForUpdate();
        String string = null;
        int n = -1;
        string = (String)agentSettings.get("JvmBlockedCount");
        if (string == null || string.length() == 0) {
            return -1;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public long getTestFileSizeToTransferB4DD() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("TestFileSizeToTransferB4DD");
        if (string == null || string.length() == 0) {
            string = "25";
        }
        long l = 25L;
        try {
            l = Long.parseLong(string);
            l *= 1000L;
        }
        catch (Exception exception) {
            l = 25000L;
        }
        return l;
    }

    public int getEGPushServerThreads() {
        int n = 50;
        this.checkForUpdate();
        String string = (String)agentSettings.get("eGPushServerThreads");
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 50;
        }
        return n;
    }

    public long getMaxDDUploadLineCount(String string) {
        String string2 = null;
        long l = 10000L;
        if (string != null && string.length() > 0) {
            string2 = (String)maxDDLineCount.get(string);
            try {
                if (string2 != null && string2.length() > 0) {
                    l = Long.parseLong(string2);
                } else if (string2 == null || string2.length() == 0) {
                    string2 = (String)maxDDLineCount.get("Default");
                    l = Long.parseLong(string2);
                }
            }
            catch (Exception exception) {
                l = 10000L;
            }
        }
        return l;
    }

    public boolean getValueForSNMPExec() {
        String string = null;
        this.checkForUpdate();
        string = (String)agentSettings.get("UseThreadForSNMPExec");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    private void updateMaxDDLineCount() {
        maxDDLineCount = this.updateTables(MAX_DD_UPLOAD_LINE_COUNT);
    }

    public int getTrimProcessToSize() {
        int n = -1;
        this.checkForUpdate();
        String string = (String)agentSettings.get("TrimProcessToSize");
        if (string == null || string.trim().length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    static {
        testsFileName = null;
        formatFileName = null;
        globalThresholdList = null;
        encryptedDesc = new ConcurrentHashMap();
        descriptorValues = new Hashtable();
        allowNegativeValues = new Hashtable();
        allImmediate = false;
        syncString = new String("gokul");
        agentSettings = new Hashtable();
        excludeApplications = new Hashtable();
        maxDDLength = new Hashtable();
        thresholdTests = new Hashtable();
        testDefinitions = new Hashtable();
        testMappings = new Hashtable();
        processDescMappings = new Hashtable();
        SrvceNameGUIDCompNameMapping = new Hashtable();
        managerVersion = null;
        configManagerEnabled = null;
        normalFrequency = null;
        badFrequency = null;
        externalAgentRunsAllAggTests = null;
        MAX_WORDS = 50;
        maxDDLineCount = new Hashtable();
    }
}

