/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgDiscInfo;
import com.eg.EgInstallInfo;
import com.eg.EgTablesInfo;
import com.eg.EgThresholdInfo;
import com.eg.IniFile;
import com.eg.SmIniFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class EgSpecsInfo {
    public static long lastSpecsCheckTime = 0L;
    public static long specsCacheTime = 5L * EgConfigInfo.msecPerMin;
    public static String defTestMappingSection = "DEFAULT_TEST_MAPPING";
    public static String testSpecSection = "TEST_SPECIFICATION";
    public static String testMappingSection = "TEST_MAPPING";
    public static String settingsSection = "SETTINGS";
    public static String fGenericTestSection = "CONFIG_FGENERIC_TESTS";
    public static String testInfoDelimiter = "TEST_INFO_DELIMITER";
    public static String testInfoPattern = "TEST_INFO_PATTERN";
    public static String testPatternDisplay = "TEST_PATTERN_DISPLAY";
    public static String aggregateTestSection = "AGGREGATE_TESTS";
    private static IniFile specsFilePtr;
    private static String specsFileName;
    private static String whoami;
    private static long lastSize;
    public static ConcurrentHashMap portRelevantForTest;
    public static ConcurrentHashMap infoRelevantForTest;
    public static ConcurrentHashMap siteRelevantForTest;
    public static ConcurrentHashMap testServerMap;
    public static ConcurrentHashMap fullTestServerMap;
    public static ConcurrentHashMap allTestsServerMap;
    public static ConcurrentHashMap internalTests;
    private static String[] testSpecVars;
    private static Vector testSpecVals;
    private static String[] allExtTests;
    private static String[] allExtTestsCommon;
    private static String[] allIntTests;
    private static String[] allExtServers;
    private static final String str_YES = "yes";
    private static long lastUpdatedTime;
    public static long lastModifiedTime;
    private static String[] eventServers;
    private static ArrayList eventTests;
    private static String testsFileName;
    private static boolean externalAgentsForAggComps;

    public static void main(String[] stringArray) {
        EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
        String[] stringArray2 = egSpecsInfo.getEventLogTypes();
        System.out.println(Arrays.asList(stringArray2));
        System.out.println(egSpecsInfo.getAllAgentlessServers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTestSpecVars() {
        if (testSpecVars == null) {
            String string = settingsSection;
            synchronized (string) {
                if (testSpecVars == null) {
                    testSpecVars = specsFilePtr.getVariables(testSpecSection);
                    testSpecVals = specsFilePtr.getAllValues(testSpecSection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTestSpecVars(boolean bl) {
        String string = settingsSection;
        synchronized (string) {
            testSpecVars = specsFilePtr.getVariables(testSpecSection);
            testSpecVals = specsFilePtr.getAllValues(testSpecSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgSpecsInfo(String string) {
        if (whoami == null) {
            String string2 = settingsSection;
            synchronized (string2) {
                if (whoami == null) {
                    EgConfigInfo egConfigInfo = new EgConfigInfo(string);
                    specsFileName = egConfigInfo.getSpecsFile(string);
                    testsFileName = egConfigInfo.getTestsFile(string);
                    egConfigInfo = null;
                    lastModifiedTime = this.lastModified();
                    lastSize = this.lastSize();
                    specsFilePtr = new IniFile(specsFileName);
                    this.checkTestSpecVars(true);
                    internalTests.clear();
                    portRelevantForTest.clear();
                    infoRelevantForTest.clear();
                    siteRelevantForTest.clear();
                    testServerMap.clear();
                    fullTestServerMap.clear();
                    allTestsServerMap.clear();
                    allExtTests = null;
                    allExtTestsCommon = null;
                    allExtServers = null;
                    eventServers = null;
                    allIntTests = null;
                    if (eventTests.size() == 0) {
                        eventTests.add("SecurityLogTest");
                        eventTests.add("AppEvtLogTest");
                        eventTests.add("SystemEvtLogTest");
                        eventTests.add("AppEvtTest");
                        eventTests.add("SystemEvtTest");
                    }
                    this.setExternalAgentsForAggComps();
                    this.loadInternalTests();
                    whoami = string;
                    lastUpdatedTime = System.currentTimeMillis();
                }
            }
        }
    }

    public long lastModified() {
        return IniFile.getLastModified(specsFileName);
    }

    public long lastSize() {
        return IniFile.getLastSize(specsFileName);
    }

    static ArrayList removeDuplicates(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return arrayList;
        }
        HashSet hashSet = new HashSet(arrayList);
        arrayList.clear();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    static List removeDuplicates2(List list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        HashSet hashSet = new HashSet(list);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (hashSet.contains(e)) {
                hashSet.remove(e);
                continue;
            }
            list.remove(i);
            --i;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        boolean bl = false;
        if (EgInstallInfo.isSuperManager && SmIniFile.modifyIniList.contains("eg_specs.ini")) {
            bl = true;
        }
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (!bl && l == lastModifiedTime && lastSize == l2) {
            lastSpecsCheckTime = System.currentTimeMillis();
            return false;
        }
        String string = settingsSection;
        synchronized (string) {
            lastSpecsCheckTime = System.currentTimeMillis();
            l = this.lastModified();
            l2 = this.lastSize();
            if (bl) {
                SmIniFile.modifyIniList.remove("eg_specs.ini");
            } else if (l == lastModifiedTime && lastSize == l2) {
                return false;
            }
            internalTests.clear();
            portRelevantForTest.clear();
            infoRelevantForTest.clear();
            siteRelevantForTest.clear();
            testServerMap.clear();
            fullTestServerMap.clear();
            allTestsServerMap.clear();
            allExtTests = null;
            allExtTestsCommon = null;
            allExtServers = null;
            allIntTests = null;
            eventServers = null;
            lastModifiedTime = this.lastModified();
            lastSize = this.lastSize();
            specsFilePtr = new IniFile(specsFileName);
            this.checkTestSpecVars(true);
            this.setExternalAgentsForAggComps();
            this.loadInternalTests();
            lastSpecsCheckTime = lastUpdatedTime = System.currentTimeMillis();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEGServer() {
        this.checkForUpdate();
        String string = settingsSection;
        synchronized (string) {
            return specsFilePtr.getValue(settingsSection, "EG_SERVER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArgsForTest(String string, boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        String string2 = settingsSection;
        synchronized (string2) {
            return specsFilePtr.getValue(testSpecSection, string);
        }
    }

    public String getArgsForTest(String string) {
        return this.getArgsForTest(string, true);
    }

    public String findTest(String string, String string2) {
        return this.findTest(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getAllTests(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = settingsSection;
        synchronized (object) {
            this.checkTestSpecVars();
            stringArray = testSpecVars;
            vector = testSpecVals;
        }
        object = new Hashtable();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Hashtable<String, String> hashtable;
            int n2;
            String string = stringArray[i];
            if (string.startsWith("Format:") || (n2 = string.indexOf(58)) < 0) continue;
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            if ((n2 = string3.indexOf(58)) < 0) continue;
            String string4 = string3.substring(0, n2);
            String string5 = string2;
            if (string4.length() > 0) {
                string5 = string5 + ':' + string4;
            }
            if ((hashtable = (Hashtable<String, String>)((Hashtable)object).get(string5)) == null) {
                hashtable = new Hashtable<String, String>();
                ((Hashtable)object).put(string5, hashtable);
            }
            hashtable.put(stringArray[i], (String)vector.get(i));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findTest(String string, String string2, boolean bl) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        if (bl) {
            this.checkForUpdate();
        }
        this.checkTestSpecVars();
        String[] stringArray = testSpecVars;
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        CharSequence charSequence = stringBuffer2 = new StringBuffer(128);
        synchronized (charSequence) {
            stringBuffer2.append(string);
            stringBuffer2.append(":");
            stringBuffer2.append(string2);
            stringBuffer2.append(":");
        }
        charSequence = stringBuffer2.toString();
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith((String)charSequence)) continue;
            return stringArray[i];
        }
        StringBuffer stringBuffer3 = stringBuffer = new StringBuffer(128);
        synchronized (stringBuffer3) {
            stringBuffer.append(string);
            stringBuffer.append("::");
        }
        charSequence = stringBuffer.toString();
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith((String)charSequence)) continue;
            return stringArray[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTestInfosWithDelimiters() {
        this.checkForUpdate();
        String string = settingsSection;
        synchronized (string) {
            return specsFilePtr.getVariables(testInfoDelimiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTestInfoDelimiter(String string) {
        this.checkForUpdate();
        String string2 = settingsSection;
        synchronized (string2) {
            String string3 = specsFilePtr.getValue(testInfoDelimiter, string);
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTestInfoPattern(String string) {
        this.checkForUpdate();
        String string2 = settingsSection;
        synchronized (string2) {
            String string3 = specsFilePtr.getValue(testInfoPattern, string);
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTestPatternDisplay(String string) {
        this.checkForUpdate();
        String string2 = settingsSection;
        synchronized (string2) {
            String string3 = specsFilePtr.getValue(testPatternDisplay, string);
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
    }

    public String[] getTestsForServer(String string) {
        return this.getTestsForServer(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTestsForServer(String string, boolean bl) {
        String[] stringArray;
        if (string != null && string.equals("Host_system")) {
            EgTablesInfo egTablesInfo = new EgTablesInfo("manager");
            ArrayList arrayList = egTablesInfo.getHostLevelTests();
            String[] stringArray2 = arrayList.toArray(new String[0]);
            return stringArray2;
        }
        if (bl) {
            this.checkForUpdate();
        }
        if ((stringArray = (String[])allTestsServerMap.get(string)) != null && stringArray.length > 0) {
            return stringArray;
        }
        String string2 = null;
        long l = lastUpdatedTime;
        Object object = settingsSection;
        synchronized (object) {
            string2 = specsFilePtr.getValue(testMappingSection, string);
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        object = new StringTokenizer(string2, ",");
        int n = ((StringTokenizer)object).countTokens();
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = ((StringTokenizer)object).nextToken().trim();
        }
        if (l == lastUpdatedTime) {
            String string3 = settingsSection;
            synchronized (string3) {
                if (l == lastUpdatedTime) {
                    allTestsServerMap.put(string, stringArray3);
                }
            }
        }
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefaultTestsForServer(String string) {
        if (string != null && string.equals("Host_system")) {
            EgTablesInfo egTablesInfo = new EgTablesInfo("manager");
            ArrayList arrayList = egTablesInfo.getHostLevelTests();
            String[] stringArray = arrayList.toArray(new String[0]);
            return stringArray;
        }
        this.checkForUpdate();
        String string2 = null;
        Object object = settingsSection;
        synchronized (object) {
            string2 = specsFilePtr.getValue(defTestMappingSection, string);
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        object = new StringTokenizer(string2, ",");
        int n = ((StringTokenizer)object).countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((StringTokenizer)object).nextToken().trim();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTestRelevantForServer(String string, String string2, boolean bl) {
        if (string != null && string.equals("Host_system")) {
            EgTablesInfo egTablesInfo = new EgTablesInfo("manager");
            return egTablesInfo.isHostLevelTest(string2);
        }
        if (!bl) {
            return this.isTestRelevantForServer(string, string2);
        }
        this.checkForUpdate();
        ArrayList arrayList = (ArrayList)fullTestServerMap.get(string);
        if (arrayList != null) {
            return arrayList.contains(string2);
        }
        long l = lastUpdatedTime;
        String string3 = null;
        Object object = settingsSection;
        synchronized (object) {
            string3 = specsFilePtr.getValue(defTestMappingSection, string);
        }
        if (string3 == null || string3.length() == 0) {
            fullTestServerMap.put(string, new ArrayList());
            return false;
        }
        object = new StringTokenizer(string3, ",");
        int n = ((StringTokenizer)object).countTokens();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string4 = ((StringTokenizer)object).nextToken().trim();
            arrayList2.add(string4);
        }
        if (l == lastUpdatedTime) {
            String string5 = settingsSection;
            synchronized (string5) {
                if (l == lastUpdatedTime) {
                    fullTestServerMap.put(string, arrayList2);
                }
            }
        }
        return arrayList2.contains(string2);
    }

    public boolean isTestRelevantForServer(String string, String string2) {
        return this.isTestRelevantForServer(string, string2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTestRelevantForServer(String string, String string2, int n) {
        ArrayList arrayList;
        if (string != null && string.equals("Host_system")) {
            EgTablesInfo egTablesInfo = new EgTablesInfo("manager");
            return egTablesInfo.isHostLevelTest(string2);
        }
        if (n != 0) {
            this.checkForUpdate();
        }
        if ((arrayList = (ArrayList)testServerMap.get(string)) != null) {
            return arrayList.contains(string2);
        }
        long l = lastUpdatedTime;
        String string3 = null;
        Object object = settingsSection;
        synchronized (object) {
            string3 = specsFilePtr.getValue(testMappingSection, string);
        }
        if (string3 == null || string3.length() == 0) {
            testServerMap.put(string, new ArrayList());
            return false;
        }
        object = new StringTokenizer(string3, ",");
        int n2 = ((StringTokenizer)object).countTokens();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            String string4 = ((StringTokenizer)object).nextToken().trim();
            arrayList2.add(string4);
        }
        if (l == lastUpdatedTime) {
            String string5 = settingsSection;
            synchronized (string5) {
                if (l == lastUpdatedTime) {
                    testServerMap.put(string, arrayList2);
                }
            }
        }
        return arrayList2.contains(string2);
    }

    public boolean isPortRelevantForTest(String string) {
        return this.isPortRelevantForTest(string, true);
    }

    public boolean isPortRelevantForTest(String string, int n) {
        long l;
        if (n == 1 && (l = System.currentTimeMillis()) - lastSpecsCheckTime > specsCacheTime) {
            this.checkForUpdate();
        }
        return this.isPortRelevantForTest(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortRelevantForTest(String string, boolean bl) {
        StringBuffer stringBuffer;
        Boolean bl2;
        if (bl) {
            this.checkForUpdate();
        }
        if ((bl2 = (Boolean)portRelevantForTest.get(string)) != null) {
            return bl2;
        }
        this.checkTestSpecVars();
        Vector vector = null;
        vector = testSpecVals;
        if (testSpecVars == null) {
            return false;
        }
        boolean bl3 = false;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(128);
        synchronized (stringBuffer2) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        long l = lastUpdatedTime;
        String string2 = stringBuffer.toString();
        String[] stringArray = testSpecVars;
        int n = stringArray.length;
        if (vector.size() != n) {
            String string3 = settingsSection;
            synchronized (string3) {
                this.checkTestSpecVars();
                stringArray = testSpecVars;
                vector = testSpecVals;
            }
            n = stringArray.length;
            if (vector.size() != n) {
                vector = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith(string2)) continue;
            String string4 = null;
            if (vector == null) {
                String string5 = settingsSection;
                synchronized (string5) {
                    string4 = specsFilePtr.getValue(testSpecSection, stringArray[i]);
                }
            } else {
                string4 = (String)vector.get(i);
            }
            if (string4.indexOf("-port ") < 0) {
                bl3 = false;
                break;
            }
            bl3 = true;
            break;
        }
        if (l == lastUpdatedTime) {
            String string6 = settingsSection;
            synchronized (string6) {
                portRelevantForTest.put(string, new Boolean(bl3));
            }
        }
        return bl3;
    }

    public boolean isInfoRelevantForTest(String string) {
        return this.isInfoRelevantForTest(string, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInfoRelevantForTest(String string, int n) {
        StringBuffer stringBuffer;
        Boolean bl;
        if (n != 0) {
            this.checkForUpdate();
        }
        if ((bl = (Boolean)infoRelevantForTest.get(string)) != null) {
            return bl;
        }
        long l = lastUpdatedTime;
        this.checkTestSpecVars();
        if (testSpecVars == null) {
            return false;
        }
        Vector vector = testSpecVals;
        boolean bl2 = false;
        CharSequence charSequence = stringBuffer = new StringBuffer(128);
        synchronized (charSequence) {
            stringBuffer.append(string);
            stringBuffer.append("::");
        }
        charSequence = stringBuffer.toString();
        String[] stringArray = testSpecVars;
        int n2 = stringArray.length;
        if (vector.size() != n2) {
            String string2 = settingsSection;
            synchronized (string2) {
                this.checkTestSpecVars();
                vector = testSpecVals;
                stringArray = testSpecVars;
            }
            n2 = stringArray.length;
            if (vector.size() != n2) {
                vector = null;
            }
        }
        for (int i = 0; i < n2; ++i) {
            if (!stringArray[i].startsWith((String)charSequence)) continue;
            String string3 = null;
            if (vector == null) {
                String string4 = settingsSection;
                synchronized (string4) {
                    string3 = specsFilePtr.getValue(testSpecSection, stringArray[i]);
                }
            } else {
                string3 = (String)vector.get(i);
            }
            if (string3.indexOf("-info") < 0) {
                bl2 = false;
                break;
            }
            bl2 = true;
            break;
        }
        if (l == lastUpdatedTime) {
            String string5 = settingsSection;
            synchronized (string5) {
                infoRelevantForTest.put(string, new Boolean(bl2));
            }
        }
        return bl2;
    }

    public boolean isInfoRelevantForTest(String string, String string2) {
        return this.isInfoRelevantForTest(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInfoRelevantForTest(String string, String string2, boolean bl) {
        String string3;
        int n;
        StringBuffer stringBuffer;
        Boolean bl2;
        if (bl) {
            this.checkForUpdate();
        }
        if ((bl2 = (Boolean)infoRelevantForTest.get(string + ':' + string2)) != null) {
            return bl2;
        }
        long l = lastUpdatedTime;
        this.checkTestSpecVars();
        if (testSpecVars == null) {
            return false;
        }
        Vector vector = testSpecVals;
        boolean bl3 = false;
        CharSequence charSequence = stringBuffer = new StringBuffer(128);
        synchronized (charSequence) {
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            stringBuffer.append(":");
        }
        charSequence = stringBuffer.toString();
        boolean bl4 = false;
        String[] stringArray = testSpecVars;
        int n2 = stringArray.length;
        if (vector.size() != n2) {
            String string4 = settingsSection;
            synchronized (string4) {
                this.checkTestSpecVars();
                vector = testSpecVals;
                stringArray = testSpecVars;
            }
            n2 = stringArray.length;
            if (vector.size() != n2) {
                vector = null;
            }
        }
        for (n = 0; n < n2; n += 1) {
            if (!stringArray[n].startsWith((String)charSequence)) continue;
            string3 = null;
            if (vector == null) {
                String string5 = settingsSection;
                synchronized (string5) {
                    string3 = specsFilePtr.getValue(testSpecSection, stringArray[n]);
                }
            } else {
                string3 = (String)vector.get(n);
            }
            bl4 = true;
            if (string3.indexOf("-info") < 0) {
                bl3 = false;
                break;
            }
            bl3 = true;
            break;
        }
        if (bl4) {
            if (l == lastUpdatedTime) {
                String string6 = settingsSection;
                synchronized (string6) {
                    infoRelevantForTest.put(string + ':' + string2, new Boolean(bl3));
                }
            }
            return bl3;
        }
        n = bl ? (int)(this.isInfoRelevantForTest(string, 1) ? 1 : 0) : (int)(this.isInfoRelevantForTest(string, 0) ? 1 : 0);
        if (l == lastUpdatedTime) {
            string3 = settingsSection;
            synchronized (string3) {
                infoRelevantForTest.put(string + ':' + string2, new Boolean(n != 0));
            }
        }
        return n;
    }

    public boolean isSiteRelevantForTest(String string) {
        return this.isSiteRelevantForTest(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSiteRelevantForTest(String string, boolean bl) {
        StringBuffer stringBuffer;
        Boolean bl2;
        if (bl) {
            this.checkForUpdate();
        }
        if ((bl2 = (Boolean)siteRelevantForTest.get(string)) != null) {
            return bl2;
        }
        long l = lastUpdatedTime;
        this.checkTestSpecVars();
        if (testSpecVars == null) {
            return false;
        }
        Vector vector = testSpecVals;
        boolean bl3 = false;
        CharSequence charSequence = stringBuffer = new StringBuffer(128);
        synchronized (charSequence) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        charSequence = stringBuffer.toString();
        String[] stringArray = testSpecVars;
        int n = stringArray.length;
        if (vector.size() != n) {
            String string2 = settingsSection;
            synchronized (string2) {
                this.checkTestSpecVars();
                vector = testSpecVals;
                stringArray = testSpecVars;
            }
            n = stringArray.length;
            if (vector.size() != n) {
                vector = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith((String)charSequence)) continue;
            String string3 = null;
            if (vector == null) {
                String string4 = settingsSection;
                synchronized (string4) {
                    string3 = specsFilePtr.getValue(testSpecSection, stringArray[i]);
                }
            } else {
                string3 = (String)vector.get(i);
            }
            if (string3.indexOf("-site") < 0) {
                bl3 = false;
                break;
            }
            bl3 = true;
            break;
        }
        if (l == lastUpdatedTime) {
            String string5 = settingsSection;
            synchronized (string5) {
                siteRelevantForTest.put(string, new Boolean(bl3));
            }
        }
        return bl3;
    }

    public boolean isTestInternal(String string, String string2) {
        return this.isTestInternal(string, string2, true);
    }

    public boolean isTestInternal(String string, String string2, boolean bl) {
        Boolean bl2;
        if (bl) {
            this.checkForUpdate();
        }
        if ((bl2 = (Boolean)internalTests.get(string + ":" + string2)) != null) {
            return bl2;
        }
        bl2 = (Boolean)internalTests.get(string);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExternalAgentsForAggComps() {
        String string = settingsSection;
        synchronized (string) {
            externalAgentsForAggComps = false;
            IniFile iniFile = new IniFile(testsFileName);
            String string2 = iniFile.getValue("AGENTS_FOR_AGGREGATE_COMPONENTS", "ExternalAgentRunsAllAggTests");
            if (string2 != null && (string2.equalsIgnoreCase(str_YES) || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("y"))) {
                externalAgentsForAggComps = true;
            }
            iniFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInternalTests() {
        String[] stringArray = null;
        Vector vector = new Vector();
        String string = settingsSection;
        synchronized (string) {
            this.checkTestSpecVars();
            stringArray = testSpecVars;
            vector = testSpecVals;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(":");
            if (n < 0) continue;
            String string2 = stringArray[i].substring(0, n);
            String string3 = stringArray[i].substring(n + 1);
            if (string3.startsWith(":")) {
                String string4 = (String)vector.get(i);
                if (string4.trim().startsWith("$hostName")) {
                    internalTests.put(string2, new Boolean(true));
                    continue;
                }
                internalTests.put(string2, new Boolean(false));
                continue;
            }
            int n2 = string3.indexOf(":");
            if (n2 < 0) continue;
            String string5 = string3.substring(0, n2);
            String string6 = (String)vector.get(i);
            if (string6.trim().startsWith("$hostName")) {
                internalTests.put(string2 + ":" + string5, new Boolean(true));
                continue;
            }
            internalTests.put(string2 + ":" + string5, new Boolean(false));
        }
    }

    public boolean isExternalTest(String string) {
        if (externalAgentsForAggComps && (string.endsWith("_ag") || string.endsWith("_agx"))) {
            return true;
        }
        return this.isTestExternal(string);
    }

    public boolean isExternalTest(String string, String string2) {
        if (externalAgentsForAggComps && (string.endsWith("_ag") || string.endsWith("_agx"))) {
            return true;
        }
        return this.isTestExternal(string, string2);
    }

    public boolean isTestExternal(String string, String string2) {
        if (externalAgentsForAggComps && (string.endsWith("_ag") || string.endsWith("_agx"))) {
            return true;
        }
        return !this.isTestInternal(string, string2);
    }

    public boolean isTestExternal(String string, String string2, boolean bl) {
        if (externalAgentsForAggComps && (string.endsWith("_ag") || string.endsWith("_agx"))) {
            return true;
        }
        return !this.isTestInternal(string, string2, bl);
    }

    public boolean isTestExternal(String string) {
        if (externalAgentsForAggComps && (string.endsWith("_ag") || string.endsWith("_agx"))) {
            return true;
        }
        return this.isTestExternal(string, true);
    }

    public boolean isTestExternal(String string, boolean bl) {
        int n;
        if (externalAgentsForAggComps && (string.endsWith("_ag") || string.endsWith("_agx"))) {
            return true;
        }
        if (bl) {
            this.checkForUpdate();
        }
        if ((n = string.indexOf(58)) >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return this.isTestExternal(string2, string3);
        }
        Boolean bl2 = (Boolean)internalTests.get(string);
        if (bl2 != null) {
            return bl2 == false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllExternalServerTypes() {
        String[] stringArray;
        this.checkForUpdate();
        if (allExtServers != null) {
            return allExtServers;
        }
        List<String> list = new LinkedList();
        String[] stringArray2 = null;
        String string = settingsSection;
        synchronized (string) {
            stringArray2 = specsFilePtr.getVariables(defTestMappingSection);
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray2[i].startsWith("Format:") || stringArray2[i].startsWith("#") || stringArray2[i].startsWith("Agg_") && externalAgentsForAggComps) continue;
            stringArray = this.getTestsForServer(stringArray2[i]);
            if (stringArray == null || stringArray.length == 0) {
                list.add(stringArray2[i]);
                continue;
            }
            boolean bl = true;
            for (int j = 0; j < stringArray.length; ++j) {
                if (this.isTestExternal(stringArray[j], stringArray2[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (EgInstallInfo.isSuperManager) {
                String string2 = stringArray2[i];
                list.add(string2);
                continue;
            }
            list.add(stringArray2[i]);
        }
        n = (list = EgSpecsInfo.removeDuplicates2(list)).size();
        if (n == 0) {
            return new String[0];
        }
        String[] stringArray3 = new String[n];
        stringArray3 = list.toArray(stringArray3);
        stringArray = settingsSection;
        synchronized (settingsSection) {
            allExtServers = stringArray3;
            // ** MonitorExit[var5_8] (shouldn't be in output)
            return stringArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExternalTests() {
        Object object;
        int n;
        this.checkForUpdate();
        if (allExtTests != null) {
            return allExtTests;
        }
        this.checkTestSpecVars();
        if (testSpecVars == null || testSpecVars.length == 0) {
            return null;
        }
        Vector vector = testSpecVals;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = testSpecVars;
        int n2 = stringArray.length;
        if (vector.size() != n2) {
            String string = settingsSection;
            synchronized (string) {
                this.checkTestSpecVars();
                vector = testSpecVals;
                stringArray = testSpecVars;
            }
            n2 = stringArray.length;
            if (vector.size() != n2) {
                vector = null;
            }
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            String string;
            int n4;
            if (stringArray[n].startsWith("Format:")) continue;
            object = null;
            if (vector == null) {
                String string2 = settingsSection;
                synchronized (string2) {
                    object = specsFilePtr.getValue(testSpecSection, stringArray[n]);
                }
            } else {
                object = (String)vector.get(n);
            }
            if (((String)object).startsWith("$EG_SERVER")) {
                n4 = stringArray[n].indexOf(58);
                if (n4 < 0 || arrayList2.contains(string = stringArray[n].substring(0, n4)) || (n3 = arrayList.indexOf(string)) >= 0) continue;
                arrayList.add(string);
                continue;
            }
            n4 = stringArray[n].indexOf(58);
            if (n4 < 0) continue;
            string = stringArray[n].substring(0, n4);
            if (!arrayList2.contains(string)) {
                arrayList2.add(string);
            }
            if ((n3 = arrayList.indexOf(string)) < 0) continue;
            arrayList.remove(n3);
        }
        n = arrayList.size();
        object = new String[n];
        object = arrayList.toArray((T[])object);
        String string = settingsSection;
        synchronized (string) {
            allExtTests = object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExternalTests(boolean bl) {
        String string;
        this.checkForUpdate();
        if (allExtTestsCommon != null) {
            return allExtTestsCommon;
        }
        this.checkTestSpecVars();
        if (testSpecVars == null || testSpecVars.length == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = testSpecVars;
        int n = stringArray.length;
        Vector vector = testSpecVals;
        if (vector.size() != n) {
            String string2 = settingsSection;
            synchronized (string2) {
                this.checkTestSpecVars();
                stringArray = testSpecVars;
                vector = testSpecVals;
            }
            n = stringArray.length;
            if (vector.size() != n) {
                vector = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            if (stringArray[i].startsWith("Format:")) continue;
            string = null;
            if (vector == null) {
                String string3 = settingsSection;
                synchronized (string3) {
                    string = specsFilePtr.getValue(testSpecSection, stringArray[i]);
                }
            } else {
                string = (String)vector.get(i);
            }
            if (!string.startsWith("$EG_SERVER") || (n2 = stringArray[i].indexOf("::")) < 0) continue;
            String string4 = stringArray[i].substring(0, n2);
            hashSet.add(string4);
        }
        String[] stringArray2 = hashSet.toArray(new String[0]);
        string = settingsSection;
        synchronized (string) {
            allExtTestsCommon = stringArray2;
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInternalTests() {
        Object object;
        int n;
        this.checkForUpdate();
        if (allIntTests != null) {
            return allIntTests;
        }
        this.checkTestSpecVars();
        if (testSpecVars == null || testSpecVars.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        String[] stringArray = testSpecVars;
        int n2 = stringArray.length;
        Vector vector = testSpecVals;
        if (vector.size() != n2) {
            String string = settingsSection;
            synchronized (string) {
                this.checkTestSpecVars();
                vector = testSpecVals;
                stringArray = testSpecVars;
            }
            n2 = stringArray.length;
            if (vector.size() != n2) {
                vector = null;
            }
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            if (stringArray[n].startsWith("Format:")) continue;
            object = null;
            if (vector == null) {
                String string = settingsSection;
                synchronized (string) {
                    object = specsFilePtr.getValue(testSpecSection, stringArray[n]);
                }
            } else {
                object = (String)vector.get(n);
            }
            if (!((String)object).startsWith("$hostName") || (n3 = stringArray[n].indexOf(58)) < 0) continue;
            String string = stringArray[n].substring(0, n3);
            arrayList.add(string);
        }
        arrayList = EgSpecsInfo.removeDuplicates(arrayList);
        n = arrayList.size();
        object = new String[n];
        object = arrayList.toArray((T[])object);
        String string = settingsSection;
        synchronized (string) {
            allIntTests = object;
        }
        return object;
    }

    public String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTestsInGroup(String string) {
        this.checkForUpdate();
        String string2 = settingsSection;
        synchronized (string2) {
            String string3 = specsFilePtr.getValue(fGenericTestSection, string);
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
    }

    public String[] getTestSpecVar() {
        this.checkForUpdate();
        this.checkTestSpecVars();
        return testSpecVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTestsWithGroupNames() {
        this.checkForUpdate();
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        String string = "";
        Vector vector2 = null;
        String string2 = settingsSection;
        synchronized (string2) {
            stringArray = specsFilePtr.getVariables(fGenericTestSection);
            vector2 = specsFilePtr.getAllValues(fGenericTestSection);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + (String)vector2.get(i) + ',';
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentlessTest(String string, String string2) {
        String string3;
        int n;
        this.checkForUpdate();
        String[] stringArray = null;
        Vector vector = null;
        String string4 = settingsSection;
        synchronized (string4) {
            this.checkTestSpecVars();
            stringArray = testSpecVars;
            vector = testSpecVals;
        }
        if (stringArray == null || vector == null) {
            return false;
        }
        string4 = string + ':' + string2 + ':';
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith(string4)) continue;
            string3 = null;
            try {
                string3 = (String)vector.get(n);
            }
            catch (Exception exception) {
                continue;
            }
            string3 = string3.trim();
            if (string3.startsWith("$EG_SERVER")) {
                return false;
            }
            return string3.indexOf(" -agentless ") >= 0;
        }
        string4 = string + "::";
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith(string4)) continue;
            string3 = null;
            try {
                string3 = (String)vector.get(n);
            }
            catch (Exception exception) {
                continue;
            }
            if (string3.startsWith("$EG_SERVER")) {
                return false;
            }
            return string3.indexOf(" -agentless ") >= 0;
        }
        return false;
    }

    public boolean isAgentlessServer(String string) {
        this.checkForUpdate();
        String[] stringArray = this.getTestsForServer(string);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.isAgentlessTest(stringArray[i], string);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList getAllAgentlessServers() {
        this.checkForUpdate();
        EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
        String[] stringArray = egDiscInfo.getServerTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.isAgentlessServer(stringArray[i]);
                if (!bl) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    private ArrayList getTestsFromTests() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EgThresholdInfo egThresholdInfo = new EgThresholdInfo("manager");
        String[] stringArray = egThresholdInfo.getAllTests();
        egThresholdInfo = null;
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public ArrayList getAllConfigTests() {
        ArrayList arrayList = this.getTestsFromTests();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        String string = null;
        for (int i = 0; i < n; ++i) {
            string = (String)arrayList.get(i);
            if (!EgInstallInfo.isConfigTest(string)) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getConfigTestsForServer(String string) {
        String string2 = null;
        Object object = settingsSection;
        synchronized (object) {
            string2 = specsFilePtr.getValue(testMappingSection, string);
        }
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        object = new StringTokenizer(string2, ",");
        int n = ((StringTokenizer)object).countTokens();
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string3 = ((StringTokenizer)object).nextToken();
            if (!EgInstallInfo.isConfigTest(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllowedConfigTests() {
        ArrayList arrayList = this.getAllConfigTests();
        String[] stringArray = null;
        String string = settingsSection;
        synchronized (string) {
            stringArray = specsFilePtr.getVariables(defTestMappingSection);
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray.length;
        ArrayList arrayList2 = null;
        for (int i = 0; i < n; ++i) {
            arrayList2 = this.getConfigTestsForServer(stringArray[i]);
            if (arrayList2 == null || arrayList2.size() == 0) continue;
            arrayList.removeAll(arrayList2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigTestEnabled(String string) {
        this.checkForUpdate();
        String string2 = null;
        String string3 = settingsSection;
        synchronized (string3) {
            string2 = specsFilePtr.getValue(testMappingSection, string);
        }
        return string2.indexOf("_cf") > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getEnabledTests(String string, boolean bl) {
        this.checkForUpdate();
        ArrayList arrayList = new ArrayList();
        String string2 = null;
        Object object = settingsSection;
        synchronized (object) {
            string2 = specsFilePtr.getValue(testMappingSection, string);
        }
        object = new StringTokenizer(string2, ",");
        int n = ((StringTokenizer)object).countTokens();
        for (int i = 0; i < n; ++i) {
            String string3 = ((StringTokenizer)object).nextToken();
            string3 = string3.trim();
            if (bl) {
                if (!EgInstallInfo.isConfigTest(string3)) continue;
                arrayList.add(string3);
                continue;
            }
            if (EgInstallInfo.isConfigTest(string3)) continue;
            arrayList.add(string3);
        }
        arrayList = EgSpecsInfo.removeDuplicates(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTestsFromAggTestsSection() {
        this.checkForUpdate();
        String[] stringArray = null;
        String string = settingsSection;
        synchronized (string) {
            stringArray = specsFilePtr.getVariables(aggregateTestSection);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            Object[] objectArray = null;
            Vector<String> vector = new Vector<String>();
            for (String string2 : stringArray) {
                String string3 = specsFilePtr.getValue(aggregateTestSection, string2);
                if (!string3.equalsIgnoreCase(str_YES)) continue;
                if (EgInstallInfo.isSuperManager) {
                    if (vector.contains(string2)) continue;
                    vector.add(string2);
                    continue;
                }
                vector.add(string2);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    public ArrayList getLicensedTests(ArrayList arrayList) {
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null || arrayList2.size() == 0) {
            return new ArrayList();
        }
        boolean bl = EgInstallInfo.isAggregationSupported();
        String[] stringArray = this.getTestsFromAggTestsSection();
        if (stringArray != null && !bl) {
            for (String string : stringArray) {
                int n = arrayList2.indexOf(string);
                if (n <= -1) continue;
                arrayList2.remove(n);
            }
        }
        if (EgInstallInfo.isSuperManager) {
            TreeSet treeSet = new TreeSet();
            treeSet.addAll(arrayList2);
            arrayList2.clear();
            arrayList2.addAll(treeSet);
        }
        return arrayList2;
    }

    public boolean isInfoRelevantForTest(String string, boolean bl) {
        if (!this.isInfoRelevantForTest(string)) {
            return this.isInfoRelevantForTest(string, "Oracle_server");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEventLogTypes() {
        String[] stringArray;
        this.checkForUpdate();
        if (eventServers != null) {
            return eventServers;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray2 = null;
        String string = settingsSection;
        synchronized (string) {
            stringArray2 = specsFilePtr.getVariables(defTestMappingSection);
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray2[i].startsWith("Format:") || stringArray2[i].startsWith("#") || (stringArray = this.getTestsForServer(stringArray2[i])) == null || stringArray.length == 0) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!eventTests.contains(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            if (EgInstallInfo.isSuperManager) {
                String string2 = stringArray2[i];
                if (linkedList.contains(string2)) continue;
                linkedList.add(string2);
                continue;
            }
            linkedList.add(stringArray2[i]);
        }
        n = linkedList.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray3 = new String[n];
        stringArray3 = linkedList.toArray(stringArray3);
        stringArray = settingsSection;
        synchronized (settingsSection) {
            eventServers = stringArray3;
            // ** MonitorExit[var5_8] (shouldn't be in output)
            return stringArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDescriptorDetailsInSpec(String string) {
        boolean bl = false;
        String string2 = null;
        String string3 = settingsSection;
        synchronized (string3) {
            string2 = specsFilePtr.getValue("DESCRIPTOR_DETAILS", string);
        }
        if (string2 != null && !string2.equals("")) {
            bl = true;
            return bl;
        }
        return bl;
    }

    public String[] getManagedCompTestList(String[] stringArray) {
        String[] stringArray2;
        EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
        ArrayList arrayList = egDiscInfo.getManagedComponentTypes();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray2 = arrayList.get(i).toString();
            String[] stringArray3 = this.getTestsForServer((String)stringArray2);
            if (stringArray3 == null || stringArray3.length <= 0) continue;
            for (int j = 0; j < stringArray3.length; ++j) {
                String string = stringArray3[j];
                arrayList2.add(string);
            }
        }
        arrayList2 = EgSpecsInfo.removeDuplicates(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList3.retainAll(arrayList2);
        stringArray2 = arrayList3.toArray(new String[0]);
        return stringArray2;
    }

    public List getManagedCompTestList(List list) {
        String[] stringArray = list.toArray(new String[0]);
        stringArray = this.getManagedCompTestList(stringArray);
        return Arrays.asList(stringArray);
    }

    public ArrayList getAllComponentTypesForTest(String string) {
        EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
        String[] stringArray = egDiscInfo.getServerTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!this.isTestRelevantForServer(stringArray[i], string, true)) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    public boolean isTypeHasExternalTests(String string) {
        boolean bl = false;
        String[] stringArray = this.getDefaultTestsForServer(string);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.isTestExternal(stringArray[i], string, false)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public ArrayList getInternalTestsAloneCompNicks() {
        EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
        ArrayList arrayList = egDiscInfo.getManagedComponentTypes();
        String[] stringArray = this.getAllExternalServerTypes();
        ArrayList<Object> arrayList2 = new ArrayList();
        if (stringArray != null) {
            arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
        }
        arrayList.removeAll(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                if (this.isTypeHasExternalTests(string)) continue;
                arrayList3.add(string);
            }
        }
        ArrayList arrayList4 = egDiscInfo.getAllHostsOfTypes(arrayList3);
        return arrayList4;
    }

    static {
        whoami = null;
        lastSize = 0L;
        portRelevantForTest = new ConcurrentHashMap();
        infoRelevantForTest = new ConcurrentHashMap();
        siteRelevantForTest = new ConcurrentHashMap();
        testServerMap = new ConcurrentHashMap();
        fullTestServerMap = new ConcurrentHashMap();
        allTestsServerMap = new ConcurrentHashMap();
        internalTests = new ConcurrentHashMap();
        allExtTests = null;
        allExtTestsCommon = null;
        allIntTests = null;
        allExtServers = null;
        lastUpdatedTime = 0L;
        eventServers = null;
        eventTests = new ArrayList();
    }
}

