/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class EgRouteInfo {
    IniFile routeFilePtr;
    private String routeFileName;
    private File routeFile;
    private String entity;
    private long lastModifiedTime;
    private long lastSize;
    private String sectionName = "ROUTES";
    private Hashtable routeDepMap = new Hashtable();
    private long routeDepMapSize = 0L;

    public static void main(String[] stringArray) {
    }

    public EgRouteInfo(String string) {
        this.entity = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.routeFileName = egConfigInfo.getRouteFile(string);
        egConfigInfo = null;
        this.routeFile = new File(this.routeFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.routeFilePtr = new IniFile(this.routeFileName);
        this.routeDepMap = new Hashtable();
        String[] stringArray = this.routeFilePtr.getVariables(this.sectionName);
        Vector vector = this.routeFilePtr.getAllValues(this.sectionName);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.routeDepMap.put(stringArray[i], (String)vector.get(i));
            }
        }
        this.routeDepMapSize = this.routeDepMap.size();
    }

    public EgRouteInfo(String string, IniFile iniFile) {
        this.entity = string;
        this.routeFilePtr = iniFile;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.routeFileName = egConfigInfo.getRouteFile(string);
        egConfigInfo = null;
        this.routeFile = new File(this.routeFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.routeDepMap = new Hashtable();
        String[] stringArray = iniFile.getVariables(this.sectionName);
        Vector vector = iniFile.getAllValues(this.sectionName);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.routeDepMap.put(stringArray[i], (String)vector.get(i));
            }
        }
        this.routeDepMapSize = this.routeDepMap.size();
    }

    public EgRouteInfo(String string, boolean bl) {
        this.entity = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.routeFileName = egConfigInfo.getRouteFile(string);
        egConfigInfo = null;
        this.routeFile = new File(this.routeFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.routeFilePtr = new IniFile(this.routeFileName, bl);
        this.routeDepMap = new Hashtable();
        String[] stringArray = this.routeFilePtr.getVariables(this.sectionName);
        Vector vector = this.routeFilePtr.getAllValues(this.sectionName);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.routeDepMap.put(stringArray[i], (String)vector.get(i));
            }
        }
        this.routeDepMapSize = this.routeDepMap.size();
    }

    public void release() {
        this.routeFilePtr = null;
    }

    public long lastModified() {
        if (this.entity.equalsIgnoreCase("agent")) {
            return this.routeFile.lastModified();
        }
        return IniFile.getLastModified(this.routeFileName);
    }

    public long lastSize() {
        if (this.entity.equalsIgnoreCase("agent")) {
            return this.routeFile.length();
        }
        return IniFile.getLastSize(this.routeFileName);
    }

    public synchronized boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && this.lastSize == l2) {
            return false;
        }
        this.lastModifiedTime = l;
        this.lastSize = l2;
        this.routeFilePtr = new IniFile(this.routeFileName);
        this.routeDepMap = new Hashtable();
        String[] stringArray = this.routeFilePtr.getVariables(this.sectionName);
        Vector vector = this.routeFilePtr.getAllValues(this.sectionName);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.routeDepMap.put(stringArray[i], (String)vector.get(i));
            }
        }
        this.routeDepMapSize = this.routeDepMap.size();
        return true;
    }

    public void addRoute(String string, String string2) {
        this.routeFilePtr.setValue(this.sectionName, string, string2);
    }

    public boolean isRouteDependent(String string, String string2, String string3) {
        if (this.routeDepMapSize == 0L) {
            return false;
        }
        int n = string.indexOf(":");
        if (n < 0) {
            return false;
        }
        String string4 = string.substring(0, n);
        n = string3.indexOf(":");
        if (n < 0) {
            return false;
        }
        String string5 = string3.substring(0, n);
        if (string4.equals(string5)) {
            return false;
        }
        String string6 = "";
        string6 = string2 != null ? string4 + ":" + string2 : string4;
        String string7 = null;
        string7 = (String)this.routeDepMap.get(string6);
        if (string7 == null) {
            return false;
        }
        if (string7.indexOf(string5) < 0) {
            return false;
        }
        String string8 = string5 + ":";
        String string9 = string5 + "|";
        return string7.startsWith(string8) || string7.startsWith(string9) || string7.indexOf(":" + string8) >= 0 || string7.indexOf(":" + string9) >= 0 || string7.endsWith(":" + string5) || string7.endsWith("|" + string5) || string7.indexOf("|" + string8) >= 0;
    }

    public void save() {
        this.routeFilePtr.saveFile();
    }
}

