/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class EgNewJar {
    private static boolean isWindows = false;
    private static String fileSeparator = System.getProperty("file.separator");

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length < 1) {
            System.err.println("Usage: EgNewJar <JarFileName> <dirToExtractTo>");
            System.exit(-1);
        }
        if ((string = System.getProperty("os.name").toLowerCase()).startsWith("win")) {
            isWindows = true;
        }
        String string2 = "";
        string2 = stringArray.length > 1 ? stringArray[1] : EgInstallInfo.getInstallDir() + fileSeparator + "lib";
        File file = new File(string2);
        if (!file.exists()) {
            string2 = EgInstallInfo.getInstallDir() + fileSeparator + "lib";
        }
        System.out.println(EgNewJar.extractAllFiles(stringArray[0], string2));
    }

    private static String recreateFileName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(fileSeparator);
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    private static boolean createDirIfNeeded(String string) {
        if (isWindows) {
            string = EgNewJar.replace(string, "\\", "/");
        }
        String string2 = string;
        if (string.endsWith("/")) {
            return false;
        }
        string2 = string.substring(0, string.lastIndexOf("/"));
        File file = new File(string2);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    private static boolean extractAllFiles(String string, String string2) {
        try {
            JarEntry jarEntry;
            FileInputStream fileInputStream = new FileInputStream(string);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String string3 = EgNewJar.recreateFileName(jarEntry.getName());
                String string4 = string2 + fileSeparator + string3;
                if (!EgNewJar.createDirIfNeeded(string4)) continue;
                File file = new File(string4);
                if (!file.exists()) {
                    file.createNewFile();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = jarInputStream.read(byArray, 0, byArray.length)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                jarInputStream.closeEntry();
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            fileInputStream.close();
            jarInputStream.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }
}

