/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;

public class EgManagerIniInfo
extends EgConfigInfo {
    private String entity;
    private String mgrIniFileName;
    private File mgrIniFile;
    private long lastModifiedTime = 0L;
    private long oldSize = 0L;
    private String managerSettings = "MANAGER_SETTINGS";
    private int maxThreadCount = 5;
    private double storageSize = 0.0;
    private int numberOfFiles = 0;
    private boolean computeState = false;
    private double storageSizeForDD = 0.0;
    private int numberOfFilesForDD = 0;
    private long maxLineCountForMeasures = 3000L;
    private int retryFreq = 0;
    private int retryFreqOnStorage = 0;
    private long timeoutPeriod = 60000L;
    private int maxSyncDbThreadCount = 5;
    private int maxSyncDDDbThreadCount = 5;
    private String syncString = new String("mySync");
    private int maxBurstLines = 50;
    private int maxTimeOut = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgManagerIniInfo(String string) {
        this.entity = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.mgrIniFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egManagerConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egManagerConfigFile);
        this.mgrIniFile = new File(this.mgrIniFileName);
        if (this.lastModifiedTime == 0L || this.oldSize == 0L) {
            String string2 = this.syncString;
            synchronized (string2) {
                if (this.lastModifiedTime == 0L || this.oldSize == 0L) {
                    this.lastModifiedTime = this.lastModified();
                    this.oldSize = this.lastSize();
                    this.init();
                }
            }
        }
    }

    private void init() {
        IniFile iniFile = new IniFile(this.mgrIniFileName);
        String string = iniFile.getValue(this.managerSettings, "maxThreadCountForDataXfer");
        String string2 = iniFile.getValue(this.managerSettings, "maxStoragePerFile");
        String string3 = iniFile.getValue(this.managerSettings, "maxStoragePerFileForDD");
        String string4 = iniFile.getValue(this.managerSettings, "filesPerManager");
        String string5 = iniFile.getValue(this.managerSettings, "filesPerManagerForDD");
        String string6 = iniFile.getValue(this.managerSettings, "computeStateForOldData");
        String string7 = iniFile.getValue(this.managerSettings, "maxLineCountForMeasures");
        String string8 = iniFile.getValue(this.managerSettings, "maxLinesBurst");
        String string9 = iniFile.getValue(this.managerSettings, "maxDataTransferTimeout");
        String string10 = iniFile.getValue(this.managerSettings, "retryFreq");
        String string11 = iniFile.getValue(this.managerSettings, "retryFreqOnStorage");
        String string12 = iniFile.getValue(this.managerSettings, "timeoutPeriod");
        String string13 = iniFile.getValue(this.managerSettings, "maxSyncDbThreadCount");
        String string14 = iniFile.getValue(this.managerSettings, "maxSyncDDDbThreadCount");
        iniFile = null;
        try {
            this.maxSyncDbThreadCount = Integer.parseInt(string13);
        }
        catch (Exception exception) {
            this.maxSyncDbThreadCount = 5;
        }
        try {
            this.maxSyncDDDbThreadCount = Integer.parseInt(string14);
        }
        catch (Exception exception) {
            this.maxSyncDDDbThreadCount = 5;
        }
        try {
            this.maxThreadCount = Integer.parseInt(string);
            if (this.maxThreadCount < 0) {
                this.maxThreadCount = 0;
            }
        }
        catch (Exception exception) {
            this.maxThreadCount = 5;
        }
        try {
            this.storageSize = Double.parseDouble(string2) * 1048576.0;
            if (this.storageSize < 0.0) {
                this.storageSize = 0.0;
            }
        }
        catch (Exception exception) {
            this.storageSize = 0.0;
        }
        if (this.storageSize > 2.097152E7) {
            this.storageSize = 2.097152E7;
        }
        try {
            this.storageSizeForDD = Double.parseDouble(string3) * 1048576.0;
            if (this.storageSizeForDD < 0.0) {
                this.storageSizeForDD = 0.0;
            }
        }
        catch (Exception exception) {
            this.storageSizeForDD = 0.0;
        }
        if (this.storageSizeForDD > 2.097152E7) {
            this.storageSizeForDD = 2.097152E7;
        }
        try {
            this.numberOfFiles = Integer.parseInt(string4);
            if (this.numberOfFiles < 0) {
                this.numberOfFiles = 0;
            }
        }
        catch (Exception exception) {
            this.numberOfFiles = 0;
        }
        try {
            this.numberOfFilesForDD = Integer.parseInt(string5);
            if (this.numberOfFilesForDD < 0) {
                this.numberOfFilesForDD = 0;
            }
        }
        catch (Exception exception) {
            this.numberOfFilesForDD = 0;
        }
        try {
            this.computeState = new Boolean(string6);
        }
        catch (Exception exception) {
            this.computeState = false;
        }
        try {
            this.maxLineCountForMeasures = Long.parseLong(string7);
        }
        catch (Exception exception) {
            this.maxLineCountForMeasures = 3000L;
        }
        try {
            this.maxBurstLines = Integer.parseInt(string8);
        }
        catch (Exception exception) {
            this.maxBurstLines = 50;
        }
        try {
            this.maxTimeOut = Integer.parseInt(string9);
        }
        catch (Exception exception) {
            this.maxTimeOut = 3;
        }
        try {
            this.retryFreq = Integer.parseInt(string10);
        }
        catch (Exception exception) {
            this.retryFreq = 5;
        }
        try {
            this.retryFreqOnStorage = Integer.parseInt(string11);
        }
        catch (Exception exception) {
            this.retryFreqOnStorage = 10;
        }
        try {
            this.timeoutPeriod = Long.parseLong(string12);
        }
        catch (Exception exception) {
            this.timeoutPeriod = 60000L;
        }
    }

    public long lastModified() {
        if (this.entity.equals("agent")) {
            return this.mgrIniFile.lastModified();
        }
        return IniFile.getLastModified(this.mgrIniFileName);
    }

    public long lastSize() {
        if (this.entity.equals("agent")) {
            return this.mgrIniFile.length();
        }
        return IniFile.getLastSize(this.mgrIniFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && l2 == this.oldSize) {
            return false;
        }
        String string = this.syncString;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == this.lastModifiedTime && l2 == this.oldSize) {
                return false;
            }
            this.init();
            this.lastModifiedTime = l;
            this.oldSize = l2;
            return true;
        }
    }

    public int getMaxThreadCount() {
        return this.getMaxThreadCount(true);
    }

    public int getMaxThreadCount(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.maxThreadCount;
    }

    public double getStorageSize() {
        return this.getStorageSize();
    }

    public double getStorageSize(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.storageSize;
    }

    public double getStorageSizeForDD() {
        return this.getStorageSizeForDD(true);
    }

    public double getStorageSizeForDD(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.storageSizeForDD;
    }

    public int getNumberOfFiles() {
        return this.getNumberOfFiles(true);
    }

    public int getNumberOfFiles(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.numberOfFiles;
    }

    public int getNumberOfFilesForDD() {
        return this.getNumberOfFilesForDD(true);
    }

    public int getNumberOfFilesForDD(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.numberOfFilesForDD;
    }

    public boolean isStateComputationNeeded() {
        return this.isStateComputationNeeded(true);
    }

    public boolean isStateComputationNeeded(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.computeState;
    }

    public long getMaxLineCountForMeasures() {
        return this.getMaxLineCountForMeasures(true);
    }

    public long getMaxLineCountForMeasures(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.maxLineCountForMeasures;
    }

    public int getMaxBurstLines() {
        return this.getMaxBurstLines(true);
    }

    public int getMaxBurstLines(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.maxBurstLines;
    }

    public int getMaxDataTrasferTimeout() {
        return this.getMaxDataTrasferTimeout(true);
    }

    public int getMaxDataTrasferTimeout(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.maxTimeOut;
    }

    public int getRetryFreq() {
        return this.getRetryFreq(true);
    }

    public int getRetryFreq(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.retryFreq;
    }

    public int getRetryFreqOnStorage() {
        return this.getRetryFreqOnStorage(true);
    }

    public int getRetryFreqOnStorage(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.retryFreqOnStorage;
    }

    public long getTimeoutPeriod() {
        return this.getTimeoutPeriod(true);
    }

    public long getTimeoutPeriod(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.timeoutPeriod;
    }

    public int getMaxSyncDbThreadCount() {
        return this.getMaxSyncDbThreadCount(true);
    }

    public int getMaxSyncDbThreadCount(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.maxSyncDbThreadCount;
    }

    public int getMaxSyncDDDbThreadCount() {
        return this.getMaxSyncDDDbThreadCount(true);
    }

    public int getMaxSyncDDDbThreadCount(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        return this.maxSyncDDDbThreadCount;
    }
}

