/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgManagersInfo;
import java.util.ArrayList;
import java.util.Hashtable;

public class EgManager {
    private String id;
    private String ip;
    private String port;
    private String hostname;
    private boolean ssl = false;
    private int responseCode;
    private String responseMessage;
    private String lastReportedTime;
    private ArrayList secondaryManagers = new ArrayList();
    private boolean isPrimary = false;
    private String displayHost;
    private String timeZoneId;
    private String dbType;
    private String altIps;
    private String supermanagerURL;
    private String url;

    public EgManager(String string, String string2, String string3, String string4) {
        this.id = string;
        this.ip = string2;
        this.altIps = string3;
        this.supermanagerURL = string4;
    }

    public EgManager(String string, String string2, String string3) {
        this.id = string;
        this.altIps = string2;
        this.supermanagerURL = string3;
    }

    public EgManager(String string, String string2, ArrayList arrayList) {
        this.id = string;
        this.url = string2;
        this.secondaryManagers = arrayList;
    }

    public EgManager(String string, String string2) {
        this.id = string;
        this.url = string2;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getIP() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isSSL() {
        String string = this.url.substring(0, this.url.indexOf(":"));
        if (string.toLowerCase().endsWith("s")) {
            this.ssl = true;
        }
        return this.ssl;
    }

    public boolean isClusterSupported() {
        return this.secondaryManagers != null && this.secondaryManagers.size() > 0;
    }

    public String getURL() {
        return this.url;
    }

    public void setSecondaryManagers(ArrayList arrayList) {
        this.secondaryManagers = arrayList;
    }

    public void setTimeZoneId(String string) {
        this.timeZoneId = string;
    }

    public String getTimeZoneId() {
        if (this.timeZoneId == null && this.id.endsWith("~eg#eg~secondary")) {
            String string = this.id.substring(0, this.id.indexOf("~eg#eg~")) + "~eg#eg~primary";
            Hashtable hashtable = EgManagersInfo.getInstance().getConfiguredManagers();
            if (!hashtable.isEmpty() && hashtable.containsKey(string)) {
                this.timeZoneId = ((EgManager)EgManagersInfo.getInstance().getConfiguredManagers().get(string)).getTimeZoneId();
                string = null;
            }
        }
        return this.timeZoneId;
    }

    public ArrayList getSecondaryManagers() {
        return this.secondaryManagers;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
    }

    public void setResponseMessage(String string) {
        this.responseMessage = string;
    }

    public boolean isRunning() {
        return this.responseCode == 200;
    }

    public void setLastReportedTime(String string) {
        this.lastReportedTime = string;
    }

    public String getLastReportedTime() {
        return this.lastReportedTime;
    }

    public String toString() {
        return this.url + ":" + this.responseCode + ":" + this.responseMessage + ":" + this.secondaryManagers + ":" + this.timeZoneId;
    }

    public void setHostnameAndIPAddress(String string) {
        this.hostname = string.substring(0, string.indexOf("#"));
        this.ip = string.substring(string.indexOf("#") + 1);
    }

    public String getHostnameAndIPAddress() {
        return this.hostname + "#" + this.ip;
    }

    public String getSuperManagerURL() {
        return this.supermanagerURL;
    }

    public String getAltIps() {
        return this.altIps;
    }

    public String getURLByIP() {
        return this.url;
    }

    public String getURLByHostname() {
        return this.url;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setPrimary(boolean bl) {
        this.isPrimary = bl;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setDisplayHost(String string) {
        this.displayHost = string;
    }

    public String getDisplayHost() {
        return this.isPrimary ? this.displayHost : this.ip;
    }

    public void setDbType(String string) {
        this.dbType = string;
    }

    public String getDbType() {
        return this.dbType;
    }

    public boolean isOracleAdapter() {
        return this.dbType != null && this.dbType.equals("EgOracleAdapter");
    }

    public boolean isMsSqlAdapter() {
        return this.dbType != null && this.dbType.equals("EgMsSqlAdapter");
    }
}

