/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgSpecsInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class EgConfigTestsInfo {
    private static String strTestNameMappingSection = "TEST_NAME_MAPPING";
    private static IniFile configTestsFilePtr;
    private static File configTestsFile;
    private static String configTestsFileName;
    private static String whoami;
    private static long lastSize;
    private static long lastModifiedTime;
    private static EgSpecsInfo specsInfo;
    private String refresh = "REFRESH";
    private String miscArg = "MISC_ARGS";
    private String configChanges = "DISPLAY_DATACHANGES";
    private String serverDisplay = "DASHBOARD_COUNT_SORT";
    private String configComponentInformationListSection = "CONFIGURATION_COMPONENT_INFORMATION_LIST";
    private String configComponentInformationSublistSection = "CONFIGURATION_COMPONENT_INFORMATION_SUBLIST";
    private String configComponentInformationSublistDetailsSection = "CONFIGURATION_COMPONENT_INFORMATION_SUBLIST_DETAILS";
    private String configComponentDataColumnCountSection = "CONFIGURATION_DATA_COLUMN_COUNT";
    private String consolidatedViewSection = "CONSOLIDATED_VIEW";
    private String osSection = "OPERATING_SYSTEMS";

    public static void main(String[] stringArray) {
        EgConfigTestsInfo egConfigTestsInfo = new EgConfigTestsInfo("manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgConfigTestsInfo(String string) {
        if (whoami == null) {
            String string2 = strTestNameMappingSection;
            synchronized (string2) {
                if (whoami == null) {
                    EgConfigInfo egConfigInfo = new EgConfigInfo();
                    configTestsFileName = egConfigInfo.getConfigTestsFile();
                    egConfigInfo = null;
                    configTestsFilePtr = new IniFile(configTestsFileName);
                    configTestsFile = new File(configTestsFileName);
                    lastModifiedTime = this.lastModified();
                    lastSize = this.lastSize();
                    whoami = string;
                }
            }
        }
    }

    public long lastModified() {
        return IniFile.getLastModified(configTestsFileName);
    }

    public long lastSize() {
        return IniFile.getLastSize(configTestsFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        String string = strTestNameMappingSection;
        synchronized (string) {
            long l = this.lastModified();
            long l2 = this.lastSize();
            if (l == lastModifiedTime && lastSize == l2) {
                return false;
            }
            lastModifiedTime = this.lastModified();
            lastSize = this.lastSize();
            configTestsFilePtr = new IniFile(configTestsFileName);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String string, String string2) {
        this.checkForUpdate();
        String string3 = null;
        String string4 = strTestNameMappingSection;
        synchronized (string4) {
            string3 = configTestsFilePtr.getValue(string, string2);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(String string, String string2, String string3) {
        this.checkForUpdate();
        boolean bl = false;
        String string4 = strTestNameMappingSection;
        synchronized (string4) {
            bl = configTestsFilePtr.setValue(string, string2, string3);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteValue(String string, String string2) {
        this.checkForUpdate();
        String string3 = strTestNameMappingSection;
        synchronized (string3) {
            configTestsFilePtr.deleteValue(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVariables(String string) {
        this.checkForUpdate();
        String[] stringArray = null;
        String string2 = strTestNameMappingSection;
        synchronized (string2) {
            stringArray = configTestsFilePtr.getVariables(string);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() {
        String string = strTestNameMappingSection;
        synchronized (string) {
            configTestsFilePtr.saveFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayNameForTest(String string) {
        this.checkForUpdate();
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String string2 = "";
        String string3 = strTestNameMappingSection;
        synchronized (string3) {
            string2 = configTestsFilePtr.getValue(strTestNameMappingSection, string);
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string2;
    }

    public String getTestName(String string) {
        ArrayList arrayList = specsInfo.getAllowedConfigTests();
        int n = arrayList.size();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            String string4 = this.getDisplayNameForTest(string3);
            if (string4 == null || !string4.equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public String getTestName(String string, String string2) {
        ArrayList arrayList = specsInfo.getConfigTestsForServer(string);
        int n = arrayList.size();
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            String string4 = (String)arrayList.get(i);
            String string5 = this.getDisplayNameForTest(string4);
            if (string5 == null || !string5.equals(string2)) continue;
            string3 = string4;
            break;
        }
        return string3;
    }

    public ArrayList getInformationList(String string) {
        ArrayList<String> arrayList = null;
        String string2 = this.getValue(this.configComponentInformationListSection, string);
        if (string2 != null && !string2.equals(" ") && string2.length() > 0) {
            arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public ArrayList getInformationSublist(String string) {
        ArrayList<String> arrayList = null;
        String string2 = this.getValue(this.configComponentInformationSublistSection, string);
        if (string2 != null && !string2.equals(" ") && string2.length() > 0) {
            arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public ArrayList getInformationSublistDetails(String string) {
        ArrayList<String> arrayList = null;
        String string2 = this.getValue(this.configComponentInformationSublistDetailsSection, string);
        if (string2 != null && !string2.equals(" ") && string2.length() > 0) {
            arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            arrayList.add(stringTokenizer.nextToken());
            stringTokenizer = new StringTokenizer(stringTokenizer.nextToken(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public int getConfigurationDataColumnCount() {
        String string = this.getValue(this.configComponentDataColumnCountSection, "ColumnCount");
        int n = 1;
        if (string != null && !string.equals(" ") && string.length() > 0) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRefreshValue(String string) {
        this.checkForUpdate();
        String string2 = "";
        String string3 = strTestNameMappingSection;
        synchronized (string3) {
            string2 = configTestsFilePtr.getValue(this.configChanges, string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMiscArgsValue(String string) {
        this.checkForUpdate();
        String string2 = "";
        String string3 = strTestNameMappingSection;
        synchronized (string3) {
            string2 = configTestsFilePtr.getValue(this.miscArg, string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSortByCount(String string) {
        this.checkForUpdate();
        String string2 = "";
        String string3 = strTestNameMappingSection;
        synchronized (string3) {
            string2 = configTestsFilePtr.getValue(string, "ComponentStatus");
            boolean bl = string2 == null ? false : string2.equalsIgnoreCase("true");
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHighlyUsed(String string) {
        this.checkForUpdate();
        String string2 = "";
        String string3 = strTestNameMappingSection;
        synchronized (string3) {
            string2 = configTestsFilePtr.getValue(string, "HighlyUsed");
            boolean bl = string2 == null ? false : string2.equalsIgnoreCase("true");
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerDisplayValue(String string, String string2) {
        this.checkForUpdate();
        String string3 = "";
        String string4 = strTestNameMappingSection;
        synchronized (string4) {
            string3 = configTestsFilePtr.getValue(string, string2);
        }
        return string3;
    }

    public String getDisplayCountForServiceStatus() {
        return this.getValue(this.miscArg, "ServicesCountInServiceStatus");
    }

    public int getPieChartSamplesLimit() {
        String string = this.getValue(this.miscArg, "PieChartSamplesLimit");
        int n = 10;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public String getSortTypeForComponentsView() {
        return this.getValue("SORT_BY_COUNT", "EcComponentsView");
    }

    public ArrayList getDataForCompareView(String string, String string2) {
        String[] stringArray = this.getVariables(this.consolidatedViewSection);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string3.equalsIgnoreCase(string + ":" + string2)) continue;
                String string4 = this.getValue(this.consolidatedViewSection, string3);
                if (string4.indexOf("|") > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        arrayList.add(string5);
                    }
                    continue;
                }
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    public ArrayList getReportTypesForServerType(String string) {
        String[] stringArray = this.getVariables(this.consolidatedViewSection);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.startsWith(string + ":")) continue;
            arrayList.add(string2.substring(string2.indexOf(":") + 1));
        }
        return arrayList;
    }

    public Map getOSMapping() {
        String[] stringArray = this.getVariables(this.osSection);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (stringArray == null) {
            return treeMap;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = this.getValue(this.osSection, string);
            treeMap.put(string, string2);
        }
        return treeMap;
    }

    static {
        whoami = null;
        lastSize = 0L;
        specsInfo = new EgSpecsInfo("manager");
    }
}

