/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.WeightedMovingAverageModel;

public class MovingAverageModel
extends WeightedMovingAverageModel {
    public MovingAverageModel() {
    }

    public MovingAverageModel(String independentVariable) {
        super(independentVariable);
    }

    public MovingAverageModel(int period) {
        double[] weights = new double[period];
        int p = 0;
        while (p < period) {
            weights[p] = 1.0 / (double)period;
            ++p;
        }
        this.setWeights(weights);
    }

    public MovingAverageModel(String independentVariable, int period) {
        super(independentVariable);
        double[] weights = new double[period];
        int p = 0;
        while (p < period) {
            weights[p] = 1.0 / (double)period;
            ++p;
        }
        this.setWeights(weights);
    }

    public void init(DataSet dataSet) {
        if (this.getNumberOfPeriods() <= 0) {
            int period = this.getNumberOfPeriods();
            double[] weights = new double[period];
            int p = 0;
            while (p < period) {
                weights[p] = 1 / period;
                ++p;
            }
            this.setWeights(weights);
        }
        super.init(dataSet);
    }

    public String getForecastType() {
        return "Moving average";
    }

    public String toString() {
        return "Moving average model, spanning " + this.getNumberOfPeriods() + " periods and using an independent variable of " + this.getIndependentVariable() + ".";
    }
}

