/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Blob;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class Network
extends XenAPIObject {
    protected final String ref;

    Network(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Network) {
            Network network = (Network)object;
            return network.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toNetworkRecord(v);
    }

    public static Network getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "network.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toNetwork(v);
    }

    public static Task createAsync(Connection connection, Record record) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.network.create";
        String string2 = connection.getSessionReference();
        Map<String, Object> map = record.toMap();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static Network create(Connection connection, Record record) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.create";
        String string2 = connection.getSessionReference();
        Map<String, Object> map = record.toMap();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toNetwork(v);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.network.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<Network> getByNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "network.get_by_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfNetwork(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameLabel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_name_label";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameDescription(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_name_description";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<Types.NetworkOperations> getAllowedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfNetworkOperations(v);
    }

    public Map<String, Types.NetworkOperations> getCurrentOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_current_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringNetworkOperations(v);
    }

    public Set<VIF> getVIFs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_VIFs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVIF(v);
    }

    public Set<PIF> getPIFs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_PIFs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPIF(v);
    }

    public Long getMTU(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_MTU";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public String getBridge(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_bridge";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Boolean getManaged(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_managed";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, Blob> getBlobs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_blobs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringBlob(v);
    }

    public Set<String> getTags(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Types.NetworkDefaultLockingMode getDefaultLockingMode(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_default_locking_mode";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toNetworkDefaultLockingMode(v);
    }

    public Map<VIF, String> getAssignedIps(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_assigned_ips";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVIFString(v);
    }

    public Set<Types.NetworkPurpose> getPurpose(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_purpose";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfNetworkPurpose(v);
    }

    public void setNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "network.set_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setNameDescription(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "network.set_name_description";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setMTU(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.set_MTU";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "network.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "network.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setTags(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.set_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void addTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "network.add_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void removeTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "network.remove_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task createNewBlobAsync(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.network.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Blob createNewBlob(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "network.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toBlob(v);
    }

    public Task createNewBlobAsync(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.network.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Blob createNewBlob(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "network.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toBlob(v);
    }

    public Task setDefaultLockingModeAsync(Connection connection, Types.NetworkDefaultLockingMode networkDefaultLockingMode) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.network.set_default_locking_mode";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)networkDefaultLockingMode)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setDefaultLockingMode(Connection connection, Types.NetworkDefaultLockingMode networkDefaultLockingMode) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.set_default_locking_mode";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)networkDefaultLockingMode)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task addPurposeAsync(Connection connection, Types.NetworkPurpose networkPurpose) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.NetworkIncompatiblePurposes {
        String string = "Async.network.add_purpose";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)networkPurpose)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void addPurpose(Connection connection, Types.NetworkPurpose networkPurpose) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.NetworkIncompatiblePurposes {
        String string = "network.add_purpose";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)networkPurpose)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task removePurposeAsync(Connection connection, Types.NetworkPurpose networkPurpose) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.network.remove_purpose";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)networkPurpose)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void removePurpose(Connection connection, Types.NetworkPurpose networkPurpose) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.remove_purpose";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)networkPurpose)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<Network> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfNetwork(v);
    }

    public static Map<Network, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "network.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfNetworkNetworkRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Set<Types.NetworkOperations> allowedOperations;
        public Map<String, Types.NetworkOperations> currentOperations;
        public Set<VIF> VIFs;
        public Set<PIF> PIFs;
        public Long MTU;
        public Map<String, String> otherConfig;
        public String bridge;
        public Boolean managed;
        public Map<String, Blob> blobs;
        public Set<String> tags;
        public Types.NetworkDefaultLockingMode defaultLockingMode;
        public Map<VIF, String> assignedIps;
        public Set<Types.NetworkPurpose> purpose;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            printWriter.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            printWriter.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            printWriter.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            printWriter.printf("%1$20s: %2$s\n", "VIFs", this.VIFs);
            printWriter.printf("%1$20s: %2$s\n", "PIFs", this.PIFs);
            printWriter.printf("%1$20s: %2$s\n", "MTU", this.MTU);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "bridge", this.bridge);
            printWriter.printf("%1$20s: %2$s\n", "managed", this.managed);
            printWriter.printf("%1$20s: %2$s\n", "blobs", this.blobs);
            printWriter.printf("%1$20s: %2$s\n", "tags", this.tags);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"defaultLockingMode", this.defaultLockingMode});
            printWriter.printf("%1$20s: %2$s\n", "assignedIps", this.assignedIps);
            printWriter.printf("%1$20s: %2$s\n", "purpose", this.purpose);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            hashMap.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            hashMap.put("allowed_operations", this.allowedOperations == null ? new LinkedHashSet() : this.allowedOperations);
            hashMap.put("current_operations", this.currentOperations == null ? new HashMap() : this.currentOperations);
            hashMap.put("VIFs", this.VIFs == null ? new LinkedHashSet() : this.VIFs);
            hashMap.put("PIFs", this.PIFs == null ? new LinkedHashSet() : this.PIFs);
            hashMap.put("MTU", this.MTU == null ? 0L : this.MTU);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("bridge", this.bridge == null ? "" : this.bridge);
            hashMap.put("managed", this.managed == null ? false : this.managed);
            hashMap.put("blobs", this.blobs == null ? new HashMap() : this.blobs);
            hashMap.put("tags", this.tags == null ? new LinkedHashSet() : this.tags);
            hashMap.put("default_locking_mode", (Object)(this.defaultLockingMode == null ? Types.NetworkDefaultLockingMode.UNRECOGNIZED : this.defaultLockingMode));
            hashMap.put("assigned_ips", this.assignedIps == null ? new HashMap() : this.assignedIps);
            hashMap.put("purpose", this.purpose == null ? new LinkedHashSet() : this.purpose);
            return hashMap;
        }
    }
}

