/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChartRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Hashtable;

public class PieChart
extends Chart {
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    private int ca;
    private double cd;
    private boolean b6;
    private boolean b1;
    private int ce;
    private int bY;
    private boolean bX;
    private Color b8;
    private double bV;
    private Hashtable bZ;
    private int b0;
    private Color b3;
    private Color[] b5;
    private Color b7;
    private Color[] bW;
    private Color b9;
    private Color[] b2;
    private boolean cc;
    int[] cb;
    private boolean b4;

    public PieChart() {
        this(1);
    }

    public PieChart(int n) {
        this(1, n);
    }

    public PieChart(int n, int n2) {
        super(n, n2);
        this.renderer = new PieChartRenderer(this);
        this.chartType = "pie";
        this.b5 = new Color[n2];
        this.bW = new Color[n2];
        this.b2 = new Color[n2];
        this.cb = new int[n2];
        this.bZ = new Hashtable();
        this.ca = 20;
        this.cd = 0.4f;
        this.bB = false;
        this.b6 = false;
        this.b1 = false;
        this.ce = 0;
        this.bY = 0;
        this.bX = true;
        this.b8 = null;
        this.bV = 0.1;
        this.b0 = 3;
        this.bz = 3;
        this.bG = 3;
        this.by = 3;
    }

    public void reset() {
        super.reset();
        this.ca = 20;
        this.cd = 0.4f;
        this.b6 = false;
        this.b1 = false;
        this.ce = 0;
        this.bY = 0;
        this.bX = true;
        this.b8 = null;
        this.bV = 0.1;
        this.cc = true;
        if (this.bZ != null) {
            this.bZ.clear();
        }
        this.b4 = false;
        this.b0 = 3;
        this.bz = 3;
        this.bG = 3;
        this.by = 3;
    }

    public double getPercentValue(int n, int n2) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
        if (n2 < 0 || n2 >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid sample index: " + n2);
        }
        int n3 = this.getSeriesCount();
        if (n3 == 1) {
            int n4 = this.getSampleCount();
            double d = 0.0;
            for (int i = 0; i < n4; ++i) {
                double d2 = this.getSampleValue(0, i);
                if (!(d2 > 0.0)) continue;
                d += d2;
            }
            double d3 = this.getSampleValue(0, n2);
            if (d3 >= 0.0) {
                return d3 / d * 100.0;
            }
        } else {
            double d = 0.0;
            for (int i = 0; i < n3; ++i) {
                double d4 = this.getSampleValue(i, n2);
                if (!(d4 > 0.0)) continue;
                d += d4;
            }
            double d5 = this.getSampleValue(n, n2);
            if (d5 > 0.0) {
                return d5 / d * 100.0;
            }
        }
        return 0.0;
    }

    public void setAngle(int n) {
        if (this.ca != n) {
            this.ca = n;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getAngle() {
        return this.ca;
    }

    public void setStartAngle(int n) {
        this.setStartAngle(0, n);
    }

    public void setStartAngle(int n, int n2) {
        if (n >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
        n2 = (n2 %= 360) < 0 ? -360 - n2 : -n2;
        if (n < 0) {
            for (int i = 0; i < this.getSampleCount(); ++i) {
                this.cb[i] = n2;
            }
        } else {
            this.cb[n] = n2;
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getStartAngle(int n) {
        return -this.cb[n];
    }

    public void setDepth(double d) {
        if (this.cd != d) {
            this.cd = d;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public float getDepth() {
        return (float)this.cd;
    }

    public void setPercentDecimalCount(int n) {
        if (this.ce != n) {
            this.ce = n;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public int getPercentDecimalCount() {
        return this.ce;
    }

    public void setPercentLabelsOn(boolean bl) {
        if (this.b6 != bl) {
            this.b6 = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isPercentLabelsOn() {
        return this.b6;
    }

    public void setPercentLabelStyle(int n) {
        if (this.b0 != n) {
            this.b0 = 3;
            if (n == 0 || n == 1 || n == 5) {
                this.b0 = n;
            }
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public int getPercentLabelStyle() {
        return this.b0;
    }

    public void setPieLabelsOn(boolean bl) {
        if (this.b1 != bl) {
            this.b1 = bl;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isPieLabelsOn() {
        return this.b1;
    }

    public void setInsideLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.b5.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.b5, 0, colorArray, 0, this.b5.length);
                this.b5 = colorArray;
            }
            this.b5[n] = color;
            this.autoRepaint();
        } else {
            this.b3 = color;
        }
    }

    public Color getInsideLabelColor(int n) {
        if (n == -1) {
            return this.b3;
        }
        try {
            return this.b5[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
    }

    public void setOutsideLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.bW.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.bW, 0, colorArray, 0, this.bW.length);
                this.bW = colorArray;
            }
            this.bW[n] = color;
            this.autoRepaint();
        } else {
            this.b7 = color;
        }
    }

    public Color getOutsideLabelColor(int n) {
        if (n == -1) {
            return this.b7;
        }
        try {
            return this.bW[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
    }

    public void setPointingLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.b2.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.b2, 0, colorArray, 0, this.b2.length);
                this.b2 = colorArray;
            }
            this.b2[n] = color;
            this.autoRepaint();
        } else {
            this.b9 = color;
        }
    }

    public Color getPointingLabelColor(int n) {
        if (n == -1) {
            return this.b9;
        }
        try {
            return this.b2[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
    }

    public void setFont(String string, Font font) {
        super.setFont(string, font);
    }

    public void setSelectionStyle(int n) {
        if (this.bY != n) {
            this.bY = n;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSelectionStyle() {
        return this.bY;
    }

    public void setDetachedDistance(double d) {
        if (this.bV != d) {
            this.bV = d;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public double getDetachedDistance() {
        return this.bV;
    }

    public void setDetachedSlice(int n, int n2, double d) {
        Double d2 = new Double(n * 1000000 + n2);
        if (d != 0.0) {
            this.bZ.put(d2, new Double(d));
        } else {
            this.bZ.remove(d2);
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getDetachedSlice(int n, int n2) {
        Double d = new Double(n * 1000000 + n2);
        Double d2 = (Double)this.bZ.get(d);
        if (d2 != null) {
            return d2;
        }
        return 0.0;
    }

    public void setSliceSeperatorOn(boolean bl) {
        if (this.bX != bl) {
            this.bX = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isSliceSeperatorOn() {
        return this.bX;
    }

    public void setSliceSeperatorColor(Color color) {
        if (this.b8 != color) {
            this.b8 = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getSliceSeperatorColor() {
        return this.b8;
    }

    public void setGradientSamplesOn(boolean bl) {
        this.cc = bl;
    }

    public boolean isGradientSamplesOn() {
        return this.cc;
    }

    public void setPieRotationOn(boolean bl) {
        this.b4 = bl;
    }

    public boolean isPieRotationOn() {
        return this.b4;
    }

    public Polygon getSlicePolygon(int n, int n2) {
        return ((PieChartRenderer)this.renderer).getSlicePolygon(n, n2);
    }

    protected Rectangle getTotalGraphBounds() {
        return this.getGraphBounds();
    }

    protected void checkDataIntegrity() {
        int n;
        Object[] objectArray;
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int n2 = this.getSampleCount();
        if (this.b5 != null && n2 != this.b5.length) {
            objectArray = new Color[n2];
            n = Math.min(n2, this.b5.length);
            System.arraycopy(this.b5, 0, objectArray, 0, n);
            this.b5 = objectArray;
        }
        if (this.bW != null && n2 != this.bW.length) {
            objectArray = new Color[n2];
            n = Math.min(n2, this.bW.length);
            System.arraycopy(this.bW, 0, objectArray, 0, n);
            this.bW = objectArray;
        }
        if (this.b2 != null && n2 != this.b2.length) {
            objectArray = new Color[n2];
            n = Math.min(n2, this.b2.length);
            System.arraycopy(this.b2, 0, objectArray, 0, n);
            this.b2 = objectArray;
        }
        if (this.cb != null && n2 != this.cb.length) {
            objectArray = new int[n2];
            n = Math.min(n2, this.cb.length);
            System.arraycopy(this.cb, 0, objectArray, 0, n);
            this.cb = (int[])objectArray;
        }
    }

    protected String constructLabel(int n, int n2, int n3, boolean bl, String string) {
        boolean bl2;
        boolean bl3 = bl2 = this.b6 && this.b0 == n3;
        if (bl2 && n >= 0) {
            string = this.formatNumber(this.getPercentValue(n, n2), this.getPercentDecimalCount()) + "%";
        }
        return super.constructLabel(n, n2, n3, bl, string);
    }

    public boolean isAnyFloatingLabelsOn(int n) {
        boolean bl = this.bB && this.bG == 3;
        bl |= this.bA && this.by == 3;
        bl |= this.isValueLabelsOn(n) && this.bz == 3;
        return bl |= this.b6 && this.b0 == 3;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.b4) {
            ((PieChartRenderer)this.renderer).handlePieRotation(aWTEvent);
        }
        super.processEvent(aWTEvent);
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }
}

