/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ws.SoapConsts;
import com.vmware.vim25.ws.SoapFaultException;
import com.vmware.vim25.ws.XmlGen;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.doublecloud.ws.util.ReflectUtil;
import org.doublecloud.ws.util.TypeUtil;

final class XmlGenDom
extends XmlGen {
    XmlGenDom() {
    }

    @Override
    public Object fromXML(String returnType, InputStream is) throws RemoteException {
        Element root = null;
        try {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read(is);
                root = doc.getRootElement();
            }
            catch (Exception e1) {
                throw new RemoteException("VI SDK invoke exception:" + e1);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Element body = (Element)root.elements().get(0);
        Element resp = (Element)body.elements().get(0);
        if (resp.getName().indexOf("Fault") != -1) {
            SoapFaultException sfe = null;
            try {
                sfe = this.parseSoapFault(resp);
            }
            catch (Exception e) {
                throw new RemoteException("Exception in WSClient.invoke:", e);
            }
            if (sfe != null && sfe.detail != null) {
                throw (RemoteException)sfe.detail;
            }
            throw sfe;
        }
        if (returnType != null) {
            try {
                return this.fromXML(returnType, resp);
            }
            catch (Exception e) {
                throw new RemoteException("Exception in WSClient.invoke:", e);
            }
        }
        return null;
    }

    private SoapFaultException parseSoapFault(Element root) throws Exception {
        Element faultE;
        String faultTypeName;
        List subElems;
        SoapFaultException sfe = new SoapFaultException();
        sfe.setFaultCode(root.elementText("faultcode"));
        sfe.setFaultString(root.elementText("faultstring"));
        sfe.setFaultActor(root.elementText("faultactor"));
        Element detailE = root.element("detail");
        if (detailE != null && (subElems = detailE.elements()).size() != 0 && (faultTypeName = (faultE = (Element)subElems.get(0)).attributeValue(SoapConsts.XSI_TYPE)) != null) {
            sfe.detail = (Throwable)this.fromXml(TypeUtil.getVimClass(faultTypeName), faultE);
        }
        return sfe;
    }

    private Object fromXML(String type, Element root) throws Exception {
        List subNodes = root.elements();
        if (subNodes.size() == 0) {
            return null;
        }
        if (type.startsWith("ManagedObjectReference")) {
            if (!type.endsWith("[]")) {
                Element e = (Element)subNodes.get(0);
                return XmlGenDom.createMOR(e.attributeValue("type"), e.getText());
            }
            ManagedObjectReference[] mos = new ManagedObjectReference[subNodes.size()];
            int i = 0;
            while (i < subNodes.size()) {
                Element elem = (Element)subNodes.get(i);
                mos[i] = XmlGenDom.createMOR(elem.attributeValue("type"), elem.getText());
                ++i;
            }
            return mos;
        }
        if (TypeUtil.isBasicType(type)) {
            ArrayList<String> vals = new ArrayList<String>();
            int i = 0;
            while (i < subNodes.size()) {
                vals.add(((Element)subNodes.get(i)).getText());
                ++i;
            }
            return ReflectUtil.parseToObject(type, vals);
        }
        if (type.endsWith("[]")) {
            String arrayItemTypeName = type.substring(0, type.length() - 2);
            Class<?> clazz = TypeUtil.getVimClass(arrayItemTypeName);
            Object ao = Array.newInstance(clazz, subNodes.size());
            int i = 0;
            while (i < subNodes.size()) {
                Element e = (Element)subNodes.get(i);
                String xsiType = e.attributeValue(SoapConsts.XSI_TYPE);
                Object o = this.fromXml(TypeUtil.getVimClass(xsiType == null ? arrayItemTypeName : xsiType), (Element)subNodes.get(i));
                Array.set(ao, i, o);
                ++i;
            }
            return ao;
        }
        return this.fromXml(TypeUtil.getVimClass(type), (Element)subNodes.get(0));
    }

    private Object fromXml(Class<?> clazz, Element node) throws Exception {
        Object obj = clazz.newInstance();
        List subNodes = node.elements();
        int sizeOfSubNodes = subNodes.size();
        int i = 0;
        while (i < sizeOfSubNodes) {
            Object ao;
            Element e = (Element)subNodes.get(i);
            String tagName = e.getName();
            Field field = null;
            field = TypeUtil.isPrimitiveType(tagName) ? clazz.getField("_" + tagName) : clazz.getField(tagName);
            Class<?> fType = field.getType();
            boolean isFieldArray = fType.isArray();
            if (isFieldArray) {
                fType = fType.getComponentType();
            }
            Class<?> fRealType = fType;
            String xsiType = e.attributeValue(SoapConsts.XSI_TYPE);
            if (xsiType != null && !xsiType.startsWith("xsd:")) {
                fRealType = TypeUtil.getVimClass(xsiType);
            }
            if (fRealType == ManagedObjectReference.class) {
                if (isFieldArray) {
                    int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ManagedObjectReference[] mos = new ManagedObjectReference[sizeOfFieldArray];
                    int j = 0;
                    while (j < sizeOfFieldArray) {
                        Element elem = (Element)subNodes.get(j + i);
                        mos[j] = XmlGenDom.createMOR(elem.attributeValue("type"), elem.getText());
                        ++j;
                    }
                    field.set(obj, mos);
                    i = i + sizeOfFieldArray - 1;
                } else {
                    field.set(obj, XmlGenDom.createMOR(e.attributeValue("type"), e.getText()));
                }
            } else if (fRealType.isEnum()) {
                if (!isFieldArray) {
                    Object fo = Enum.valueOf(fRealType, e.getText());
                    field.set(obj, fo);
                } else {
                    int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ao = Array.newInstance(fRealType, sizeOfFieldArray);
                    int j = 0;
                    while (j < sizeOfFieldArray) {
                        String enumStr = ((Element)subNodes.get(j + i)).getText();
                        Array.set(ao, j, Enum.valueOf(fRealType, enumStr));
                        ++j;
                    }
                    field.set(obj, ao);
                    i = i + sizeOfFieldArray - 1;
                }
            } else if (TypeUtil.isBasicType(fRealType)) {
                if (isFieldArray) {
                    int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ArrayList<String> values = new ArrayList<String>();
                    int j = 0;
                    while (j < sizeOfFieldArray) {
                        values.add(((Element)subNodes.get(j + i)).getText());
                        ++j;
                    }
                    String fTrueType = null;
                    if (xsiType != null) {
                        fTrueType = String.valueOf(xsiType.substring("xsd:".length())) + "[]";
                    } else {
                        fTrueType = fRealType.getSimpleName();
                        if (!fTrueType.endsWith("[]")) {
                            fTrueType = String.valueOf(fTrueType) + "[]";
                        }
                    }
                    ReflectUtil.setObjectArrayField(obj, field, fTrueType, values);
                    i = i + sizeOfFieldArray - 1;
                } else if (xsiType != null) {
                    xsiType = xsiType.substring("xsd:".length());
                    ReflectUtil.setObjectField(obj, field, xsiType, e.getText());
                } else {
                    ReflectUtil.setObjectField(obj, field, fRealType.getSimpleName(), e.getText());
                }
            } else if (isFieldArray) {
                int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                ao = Array.newInstance(fType, sizeOfFieldArray);
                String fGenericType = fType.getSimpleName();
                int j = 0;
                while (j < sizeOfFieldArray) {
                    Element elem = (Element)subNodes.get(j + i);
                    String elemXsiType = elem.attributeValue(SoapConsts.XSI_TYPE);
                    String elemType = elemXsiType != null ? elemXsiType : fGenericType;
                    Object o = this.fromXml(TypeUtil.getVimClass(elemType), elem);
                    Array.set(ao, j, o);
                    ++j;
                }
                field.set(obj, ao);
                i = i + sizeOfFieldArray - 1;
            } else {
                Object o = this.fromXml(fRealType, e);
                field.set(obj, o);
            }
            ++i;
        }
        return obj;
    }

    private static final int getNumberOfSameTags(List<Element> subNodes, int sizeOfSubNodes, int from, String tagName) {
        int numOfTags = 1;
        int j = from + 1;
        while (j < sizeOfSubNodes) {
            if (!subNodes.get(j).getName().equals(tagName)) break;
            ++numOfTags;
            ++j;
        }
        return numOfTags;
    }
}

