/*
 * Decompiled with CFR 0.152.
 */
package com.pd4ml.fonts;

import com.pd4ml.ForcedTerminationException;
import com.pd4ml.cache.FileCache;
import com.pd4ml.cache.f;
import com.pd4ml.fonts.b;
import com.pd4ml.fonts.e;
import com.pd4ml.fonts.i;
import com.pd4ml.fonts.l;
import com.pd4ml.util.Base;
import com.pd4ml.util.j;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FontCache
extends Base {
    public static final String \u00d8\u00f4\u00d4000 = "pd4ml.autoindex.fonts";
    public static final String \u00d8\u00f5\u00d4000 = "pd4fonts.properties";
    public static final String newwhilenew = "font.dir.location";
    public static final String O\u00f4\u00d4000 = "java:/defaultfonts";
    private static final String \u00d4\u00f5\u00d4000 = "[\\p{Punct}&&[^-()\\[\\]{}]]";
    public static final Pattern returnwhilenew = Pattern.compile("[\\p{Punct}&&[^-()\\[\\]{}]]");
    public FileCache o\u00f4\u00d4000;
    private Map<String, l> nulldonew;
    private Map<String, i> o\u00f5\u00d4000;
    private Map<String, f> \u00d4\u00f4\u00d4000;
    private Map<String, String> \u00d3\u00f5\u00d4000;
    private Map<String, String> \u00d3\u00f4\u00d4000;
    public boolean O\u00f5\u00d4000;
    public boolean \u00f8\u00d8\u00d4000;
    public boolean privatedonew;
    private boolean \u00d5\u00f5\u00d4000;
    private boolean \u00f4\u00f4\u00d4000;
    private String[] fordonew = new String[]{"times new roman", "customserif1", "customserif2", "customserif3", "customserif4", "customserif5", "ms mincho", "mingliu", "simsun", "mangal", "david", "batang", "lucida sans regular", "ms gothic", "gulim", "gulimche"};
    private String[] \u00f5\u00f4\u00d4000 = new String[]{"arial", "customsans1", "customsans2", "customsans3", "customsans4", "customsans5", "ms gothic", "mingliu", "simsun", "mangal", "david", "gulim", "lucida sans regular", "ms mincho", "batang", "gulimche", "ha_mingliu"};
    private String[] \u00f8\u00f4\u00d4000 = new String[]{"courier new", "custommono1", "custommono2", "custommono3", "custommono4", "custommono5", "ms gothic", "mingliu", "simsun", "mangal", "david", "gulimche", "lucida sans regular", "ms mincho", "batang", "gulim"};
    private static HashMap \u00d5\u00f4\u00d4000 = new HashMap(100);

    public FontCache(FileCache fileCache) throws ForcedTerminationException {
        this(fileCache, null, true, false, false);
    }

    public FontCache(FileCache fileCache, String[] stringArray, boolean bl, boolean bl2, boolean bl3) throws ForcedTerminationException {
        super(fileCache.getLogLevel(), "FONT CACHE");
        this.o\u00f4\u00d4000 = fileCache;
        this.\u00f8\u00d8\u00d4000 = bl;
        this.privatedonew = bl2;
        this.\u00d5\u00f5\u00d4000 = bl3;
        boolean bl4 = fileCache.\u00f8\u00d40000 == null ? false : "true".equals(fileCache.\u00f8\u00d40000.getProperty(\u00d8\u00f4\u00d4000, "false"));
        this.\u00d4\u00f4\u00d4000 = new HashMap<String, f>();
        this.o\u00f5\u00d4000 = new HashMap<String, i>();
        this.nulldonew = new HashMap<String, l>();
        this.\u00d4\u00f4\u00d4000.put("arial", new b("arial", 0, _b.\u00d200000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("arial bold", new b("arial", 1, _b.\u00d200000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("arial italic", new b("arial", 2, _b.\u00d200000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("arial bold italic", new b("arial", 3, _b.\u00d200000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("times new roman", new b("times new roman", 0, _b.\u00d400000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("times new roman bold", new b("times new roman", 1, _b.\u00d400000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("times new roman italic", new b("times new roman", 2, _b.\u00d400000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("times new roman bold italic", new b("times new roman", 3, _b.\u00d400000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("courier new", new b("courier new", 0, _b.o00000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("courier new bold", new b("courier new", 1, _b.o00000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("courier new italic", new b("courier new", 2, _b.o00000, fileCache));
        this.\u00d4\u00f4\u00d4000.put("courier new bold italic", new b("courier new", 3, _b.o00000, fileCache));
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Properties properties;
                this.log((short)128, "init: " + stringArray[i2]);
                String string = stringArray[i2];
                if (string == null) continue;
                f f2 = fileCache.getItem(string);
                if (f2 == null && string.startsWith("java:") && !string.endsWith(\u00d8\u00f5\u00d4000)) {
                    this.log((short)128, "cannot read '" + string + "'");
                    string = string + "/pd4fonts.properties";
                    f2 = fileCache.getItem(string);
                }
                if (f2 == null || !f2.int() || f2.\u00d3O0000() != null && !f2.\u00d3O0000().canRead()) {
                    this.log((short)128, "cannot read '" + string + "'");
                    if (f2 == null || !f2.\u00d3o0000()) continue;
                }
                Object object5 = null;
                String string2 = null;
                if (!string.endsWith(\u00d8\u00f5\u00d4000)) {
                    object5 = string;
                    string2 = (String)object5 + "/" + \u00d8\u00f5\u00d4000;
                } else {
                    string2 = string;
                    if (string.startsWith("java:")) {
                        object5 = string.substring(0, string.length() - \u00d8\u00f5\u00d4000.length() - 1);
                    } else if (f2.\u00d3O0000() != null) {
                        object5 = f2.\u00d3O0000().getParent();
                    }
                }
                Properties properties2 = null;
                f2 = fileCache.getItem(string2);
                byte[] byArray = f2.\u00f600000();
                if (byArray == null) {
                    if (bl4) {
                        this.log((short)128, "not found a mapping file by: " + stringArray[i2] + "; autoindexing the font dir");
                        boolean bl5 = fileCache.thisObject;
                        fileCache.thisObject = true;
                        properties2 = this.OO0000((String)object5, null);
                        fileCache.thisObject = bl5;
                    } else {
                        this.log((short)2, "not found a mapping file by: " + stringArray[i2]);
                        continue;
                    }
                }
                if (properties2 != null) {
                    properties = properties2;
                } else {
                    try {
                        properties = new Properties();
                        properties.load(new ByteArrayInputStream(byArray));
                    }
                    catch (IOException iOException) {
                        this.log((short)2, string + " not found or not readable");
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        this.log((short)2, string + " not found or not readable.");
                        continue;
                    }
                    object4 = properties.getProperty(newwhilenew);
                    if (object4 != null) {
                        properties.remove(newwhilenew);
                        object5 = object4;
                        if (!((String)object5).endsWith("/") && !((String)object5).endsWith("\\")) {
                            object5 = (String)object5 + "/";
                        }
                        if (!(((String)object5).startsWith("http:") || ((String)object5).startsWith("https:") || ((String)object5).startsWith("java:"))) {
                            object3 = new File((String)object5);
                            object2 = new File(string);
                            object = ((File)object2).isDirectory() ? object2 : ((File)object2).getParentFile();
                            if (!((File)object3).exists() && ((File)(object3 = new File((File)object, (String)object5))).exists()) {
                                object5 = ((File)object3).getAbsolutePath();
                            }
                        }
                        this.log((short)128, "resolved fonts dir: " + (String)object5);
                    }
                }
                object4 = properties.keys();
                while (object4.hasMoreElements()) {
                    object3 = (String)object4.nextElement();
                    object = (String)properties.get(object3);
                    object2 = FontCache.\u00f8\u00d20000((String)object5 + "/" + (String)object);
                    String string3 = ((String)object3).toLowerCase();
                    f f3 = fileCache.getItem((String)object2);
                    f f4 = this.\u00d4\u00f4\u00d4000.get(string3);
                    if (f4 != null && f4.int()) {
                        if (!f3.int()) continue;
                        this.\u00d4\u00f4\u00d4000.put(string3, f3);
                        this.log((short)128, "registering (overwrite existent): " + string3 + " -> " + (String)object2);
                        continue;
                    }
                    this.\u00d4\u00f4\u00d4000.put(string3, f3);
                    this.log((short)128, "registering: " + string3 + " -> " + (String)object2);
                }
            }
        }
    }

    public void log(short s2, String string) {
        super.log(s2, string);
    }

    public void clearCache() {
        for (String string : this.o\u00f5\u00d4000.keySet()) {
            this.o\u00f5\u00d4000.get(string).Objectint();
        }
        if (this.o\u00f4\u00d4000 != null) {
            this.o\u00f4\u00d4000.cleanInlineResources();
        }
    }

    private static String \u00f8\u00d20000(String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            stringBuilder.append(c2 == '\\' ? (char)'/' : (char)c2);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addFont(String string, String string2, boolean bl, boolean bl2, String string3, String string4) throws ForcedTerminationException {
        Object object;
        if (string == null) return false;
        if ("".equals(string.trim())) {
            return false;
        }
        if (string4 != null) {
            if (this.\u00d3\u00f4\u00d4000 == null) {
                this.\u00d3\u00f4\u00d4000 = new HashMap<String, String>();
            }
            this.\u00d3\u00f4\u00d4000.put(string.toLowerCase(), j.super(string4));
        }
        String string5 = string.toLowerCase();
        string5 = FontCache.extendNameWithStyle(string5, (bl ? 1 : 0) | (bl2 ? 2 : 0));
        if (string2 != null && string2.trim().length() > 0) {
            object = string2.split(",");
            for (String string6 : object) {
                f f2 = this.\u00d4\u00f4\u00d4000.get(string6 = FontCache.extendNameWithStyle(string6, (bl ? 1 : 0) | (bl2 ? 2 : 0)));
                if (f2 == null) continue;
                this.\u00d4\u00f4\u00d4000.put(string5, f2);
                this.log((short)128, "registering by API (aliasing existent): " + string5 + " -> " + string6);
                if (bl) return true;
                if (bl2) return true;
                String string7 = FontCache.extendNameWithStyle(string6, 1);
                String string8 = FontCache.extendNameWithStyle(string5, 1);
                f2 = this.\u00d4\u00f4\u00d4000.get(string7);
                if (f2 != null) {
                    this.\u00d4\u00f4\u00d4000.put(string8, f2);
                    this.log((short)128, "registering by API (aliasing existent): " + string8 + " -> " + string7);
                }
                string7 = FontCache.extendNameWithStyle(string6, 2);
                string8 = FontCache.extendNameWithStyle(string5, 2);
                f2 = this.\u00d4\u00f4\u00d4000.get(string7);
                if (f2 != null) {
                    this.\u00d4\u00f4\u00d4000.put(string8, f2);
                    this.log((short)128, "registering by API (aliasing existent): " + string8 + " -> " + string7);
                }
                string7 = FontCache.extendNameWithStyle(string6, 3);
                string8 = FontCache.extendNameWithStyle(string5, 3);
                f2 = this.\u00d4\u00f4\u00d4000.get(string7);
                if (f2 == null) return true;
                this.\u00d4\u00f4\u00d4000.put(string8, f2);
                this.log((short)128, "registering by API (aliasing existent): " + string8 + " -> " + string7);
                return true;
            }
        }
        if (string3 == null) return false;
        if ("".equals(string3.trim())) {
            return false;
        }
        object = string3.toLowerCase();
        if (!(((String)object).endsWith(".ttf") || ((String)object).endsWith(".otf") || ((String)object).indexOf(".ttc_") > 0 || ((String)object).endsWith(".woff"))) {
            return false;
        }
        String string9 = FontCache.\u00f8\u00d20000(string3);
        f f3 = this.o\u00f4\u00d4000.getItem(string9);
        if (f3.voidsuper()) {
            this.log((short)16, "font file not found: " + string3);
            return false;
        }
        f3.\u00f6O0000();
        try {
            new l(this, f3.\u00d3O0000().toString());
        }
        catch (Exception exception) {
            this.log((short)16, "Unsupported font file format of " + string3);
            return false;
        }
        f f4 = this.\u00d4\u00f4\u00d4000.get(string5);
        if (f4 != null && f4.int()) {
            if (f3.int()) {
                this.\u00d4\u00f4\u00d4000.put(string5, f3);
                this.log((short)128, "registering by API (overwrite existent): " + string5 + " -> " + string9);
                return true;
            }
            this.log((short)16, "cannot register not existent font file: " + string5 + " -> " + string9);
            return false;
        }
        this.\u00d4\u00f4\u00d4000.put(string5, f3);
        this.log((short)128, "registering by API: " + string5 + " -> " + string9);
        return true;
    }

    public void addFontAlias(String string, String string2) {
        if (string == null || "".equals(string.trim())) {
            return;
        }
        if (string2 == null || "".equals(string2.trim())) {
            return;
        }
        if (this.\u00d3\u00f5\u00d4000 == null) {
            this.\u00d3\u00f5\u00d4000 = new HashMap<String, String>();
        }
        this.\u00d3\u00f5\u00d4000.put(string2.toLowerCase(), string.toLowerCase());
    }

    public void assignToFamily(String string, _b _b2) {
        if (string == null || "".equals(string.trim())) {
            return;
        }
        if (_b2 == null) {
            return;
        }
        string = string.toLowerCase();
        String[] stringArray = this.fordonew;
        if (_b2 == _b.\u00d200000) {
            stringArray = this.\u00f5\u00f4\u00d4000;
        } else if (_b2 == _b.o00000) {
            stringArray = this.\u00f8\u00f4\u00d4000;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            if (i2 == 0) {
                return;
            }
            for (int i3 = i2; i3 > 0; --i3) {
                stringArray[i3] = stringArray[i3 - 1];
            }
            stringArray[0] = string;
            return;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        for (int i4 = 0; i4 < stringArray.length; ++i4) {
            stringArray2[i4 + 1] = stringArray[i4];
        }
        if (_b2 == _b.\u00d200000) {
            this.\u00f5\u00f4\u00d4000 = stringArray2;
        } else if (_b2 == _b.o00000) {
            this.\u00f8\u00f4\u00d4000 = stringArray2;
        } else {
            this.fordonew = stringArray2;
        }
    }

    public l getTrueType(String string) throws IOException {
        l l2 = this.nulldonew.get(string);
        if (l2 != null) {
            return l2;
        }
        l2 = new l(this, string);
        this.nulldonew.put(string, l2);
        return l2;
    }

    public i getFontMetrics(String[] stringArray, int n2, float f2, String string) throws ForcedTerminationException {
        Object object;
        String string2;
        if (stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0] == null) {
            stringArray = new String[]{"arial"};
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = stringArray[i2].toLowerCase();
            if (this.\u00d3\u00f5\u00d4000 == null || (string2 = this.\u00d3\u00f5\u00d4000.get(stringArray2[i2])) == null) continue;
            stringArray2[i2] = string2;
        }
        i i3 = null;
        string2 = FontCache.buildKey(stringArray2, n2, f2);
        this.log((short)1024, "lookup: " + string2 + " for '" + string + "'");
        i i4 = this.o\u00f5\u00d4000.get(string2);
        if (i4 != null) {
            if (i4.O\u00d30000(string)) {
                this.log((short)1024, "returns cached: " + i4.toString());
                return i4;
            }
            if ((i4 = i4.\u00d300000(string, n2)) != null) {
                this.log((short)1024, "returns known substitution: " + i4.toString());
                return i4;
            }
        }
        String string3 = "returns: ";
        HashSet<String> hashSet = new HashSet<String>();
        i i5 = this.super(stringArray2, 0, f2, null, hashSet);
        if (n2 == 0) {
            i3 = i5;
            i5.super(0, i5);
        } else {
            object = i5.\u00f800000(n2);
            if (object != null) {
                i3 = object;
            } else {
                object = this.super(stringArray2, n2, f2, null, hashSet);
                i5.super(n2, (i)object);
                i3 = object;
            }
        }
        if (string != null && string.length() != 0 && !i3.O\u00d30000(string)) {
            i i6;
            object = i5.\u00d300000(string, n2);
            if (object == null) {
                object = this.super(stringArray2, n2, f2, string, hashSet);
                i5.super((i)object, string);
            }
            if ((i6 = i3.\u00d300000(string, n2)) == null) {
                i6 = this.super(stringArray2, n2, f2, string, hashSet);
                i3.super(i6, string);
            }
            if (((i)object).\u00d8\u00f6\u00d4000 < i6.\u00d8\u00f6\u00d4000) {
                i6 = new i(((i)object).\u00f4\u00f8\u00d4000, n2, f2, ((i)object).\u00f40O000(), this);
                i6.OO0000(true);
                i6.super((short)4);
                ((i)object).super(n2, i6);
            }
            i3 = i6;
            string3 = "returns new substitution: ";
        } else {
            string3 = "found: ";
        }
        if (!this.O\u00f5\u00d4000) {
            object = this.o\u00f5\u00d4000.get(string2);
            if (object != null) {
                ((i)object).super(i3, string);
            } else {
                this.o\u00f5\u00d4000.put(string2, i3);
            }
        }
        if (this.\u00d3\u00f4\u00d4000 != null && (object = this.\u00d3\u00f4\u00d4000.get(i3.\u00f4\u00f8\u00d4000)) != null) {
            i3.interfacenew((String)object);
        }
        this.log((short)1024, string3 + i3.toString());
        return i3;
    }

    private i super(String[] stringArray, int n2, float f2, String string, HashSet<String> hashSet) throws ForcedTerminationException {
        f f3;
        Object object;
        Object object2;
        String string2;
        int n3;
        _b _b2 = _b.\u00d200000;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 == 0) {
                _b2 = this.\u00f6\u00d20000(stringArray[0]);
            }
            if ("sans-serif".equals(stringArray[i2])) {
                _b2 = _b.\u00d200000;
                break;
            }
            if ("serif".equals(stringArray[i2])) {
                _b2 = _b.\u00d400000;
                break;
            }
            if (!"monospace".equals(stringArray[i2])) continue;
            _b2 = _b.o00000;
            break;
        }
        i i3 = null;
        i i4 = null;
        i i5 = null;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            string2 = FontCache.extendNameWithStyle(stringArray[n3], n2);
            object2 = string2 + " " + f2;
            Object object3 = object = string != null ? null : this.o\u00f5\u00d4000.get(object2);
            if (object != null) {
                i4 = object;
            } else {
                if (hashSet.contains(string2)) continue;
                f3 = this.\u00d4\u00f4\u00d4000.get(string2);
                if (f3 != null && f3.int()) {
                    i4 = f3 instanceof b ? new e(stringArray[n3], n2, f2, f3) : new i(stringArray[n3], n2, f2, f3, this);
                    i5 = i4;
                    i4.super(_b2, this);
                    i4.super((short)1);
                    if (string == null) {
                        this.o\u00f5\u00d4000.put((String)object2, i4);
                    }
                } else {
                    hashSet.add(string2);
                    continue;
                }
            }
            if (i3 == null) {
                i3 = i4;
            }
            if (string == null || string.length() == 0 || i4.O\u00d30000(string)) break;
            i4 = null;
            hashSet.add(string2);
        }
        if (i4 == null) {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                string2 = stringArray[n3];
                if (hashSet.contains(string2)) continue;
                object2 = this.\u00d4\u00f4\u00d4000.get(string2);
                if (object2 == null || !((f)object2).int()) {
                    hashSet.add(string2);
                    continue;
                }
                i4 = object2 instanceof b ? new e(stringArray[n3], n2, f2, (f)object2) : new i(stringArray[n3], n2, f2, (f)object2, this);
                i4.super((short)4);
                i4.OO0000(true);
                i4.super(_b2, this);
                if (i3 == null) {
                    i3 = i4;
                }
                if (string != null && string.length() != 0 && !i4.O\u00d30000(string)) {
                    i4 = null;
                    hashSet.add(string2);
                    continue;
                }
                if (i5 == null) break;
                i5.super(i4, string);
                break;
            }
        }
        if (i4 == null) {
            String[] stringArray2;
            switch (_b2) {
                case o00000: {
                    stringArray2 = this.\u00f8\u00f4\u00d4000;
                    break;
                }
                case \u00d400000: {
                    stringArray2 = this.fordonew;
                    break;
                }
                default: {
                    stringArray2 = this.\u00f5\u00f4\u00d4000;
                }
            }
            for (int i6 = 0; i6 < stringArray2.length; ++i6) {
                object2 = FontCache.extendNameWithStyle(stringArray2[i6].toLowerCase(), n2);
                if (hashSet.contains(object2)) continue;
                object = this.\u00d4\u00f4\u00d4000.get(object2);
                if (object != null && ((f)object).int()) {
                    if (object instanceof b) {
                        f3 = this.\u00d4\u00f4\u00d4000.get(stringArray2[i6].toLowerCase());
                        if (n2 != 0 && f3 != null && !(f3 instanceof b) && f3.int()) {
                            i4 = new i(stringArray2[i6], n2, f2, f3, this);
                            i4.OO0000(true);
                        } else {
                            i4 = new e(stringArray2[i6], n2, f2, (f)object);
                        }
                    } else {
                        i4 = new i(stringArray2[i6], n2, f2, (f)object, this);
                    }
                    i4.super((short)2);
                    if (i3 == null) {
                        i3 = i4;
                    }
                    if (string == null || string.length() == 0 || i4.O\u00d30000(string)) break;
                    i4 = null;
                    hashSet.add((String)object2);
                    continue;
                }
                hashSet.add((String)object2);
            }
        }
        if (i4 == null) {
            for (String string3 : this.\u00d4\u00f4\u00d4000.keySet()) {
                if ((n2 & 1) > 0 && string3.indexOf(" bold") < 0 || (n2 & 2) > 0 && string3.indexOf(" italic") < 0 || (object2 = this.\u00f6\u00d20000(string3)) != _b2 || ((f)(object = this.\u00d4\u00f4\u00d4000.get(string3))).voidsuper() || object == null || !((f)object).int()) continue;
                i4 = object instanceof b ? new e(string3, n2, f2, (f)object) : new i(string3, n2, f2, (f)object, this);
                i4.super((short)8);
                i4.super(_b2, this);
                if (i3 == null) {
                    i3 = i4;
                }
                if (string == null || string.length() == 0 || i4.O\u00d30000(string)) break;
                i4 = null;
            }
        }
        if (i4 == null) {
            for (String string4 : this.\u00d4\u00f4\u00d4000.keySet()) {
                if ((n2 & 1) == 0 && string4.indexOf(" bold") > 0 || (n2 & 2) == 0 && string4.indexOf(" italic") > 0) continue;
                object2 = j.super(string4, " bold", "");
                object2 = j.super((String)object2, " italic", "");
                object = this.\u00f6\u00d20000(string4);
                if (object != _b2 || (f3 = this.\u00d4\u00f4\u00d4000.get(string4)) == null || !f3.int()) continue;
                if (f3 instanceof b) {
                    f f4 = this.\u00d4\u00f4\u00d4000.get(object2);
                    if (n2 != 0 && f4 != null && !(f4 instanceof b) && f4.int()) {
                        i4 = new i((String)object2, n2, f2, f4, this);
                        i4.OO0000(true);
                    } else {
                        i4 = new e(string4, n2, f2, f3);
                    }
                } else {
                    i4 = new i(string4, n2, f2, f3, this);
                    if ((n2 & 1) > 0 && string4.indexOf(" bold") < 0 || (n2 & 2) > 0 && string4.indexOf(" italic") < 0) {
                        i4.OO0000(true);
                    }
                }
                i4.super((short)8);
                i4.super(_b2, this);
                if (i3 == null) {
                    i3 = i4;
                }
                if (string == null || string.length() == 0 || i4.O\u00d30000(string)) break;
                i4 = null;
            }
        }
        if (i4 == null) {
            for (String string5 : this.\u00d4\u00f4\u00d4000.keySet()) {
                if ((n2 & 1) == 0 && string5.indexOf(" bold") > 0 || (n2 & 2) == 0 && string5.indexOf(" italic") > 0) continue;
                object2 = j.super(string5, " bold", "");
                object2 = j.super((String)object2, " italic", "");
                object = this.\u00d4\u00f4\u00d4000.get(string5);
                if (object == null || !((f)object).int() || object instanceof b) continue;
                i4 = new i(string5, n2, f2, (f)object, this);
                if ((n2 & 1) > 0 && string5.indexOf(" bold") < 0 || (n2 & 2) > 0 && string5.indexOf(" italic") < 0) {
                    i4.OO0000(true);
                }
                i4.super((short)16);
                i4.super(_b2, this);
                if (i3 == null) {
                    i3 = i4;
                }
                if (string == null || string.length() == 0 || i4.O\u00d30000(string)) break;
                i4 = null;
            }
        }
        if (i4 == null) {
            i4 = i3;
            if (i4 != null) {
                i4.super((short)16);
            }
        } else {
            i4.super(_b2, this);
        }
        return i4;
    }

    private _b \u00f6\u00d20000(String string) {
        string = string.toLowerCase();
        string = j.super(string, " bold", "");
        if ((string = j.super(string, " italic", "")).startsWith("sansserif") || string.startsWith("helv") || string.indexOf("sans") >= 0 || string.indexOf("arial") >= 0 || string.indexOf("verdana") >= 0 || string.indexOf("calibri") >= 0 || string.indexOf("trebuchet") >= 0 || string.startsWith("tahoma")) {
            return _b.\u00d200000;
        }
        if (string.indexOf("serif") >= 0 || string.startsWith("times") || string.startsWith("tms") || string.startsWith("book") || string.startsWith("palatino") || string.startsWith("thames") || string.startsWith("georgia") || string.startsWith("lucida bright") || string.startsWith("garamond")) {
            return _b.\u00d400000;
        }
        if (string.indexOf("monospace") >= 0 || string.indexOf("courier") >= 0 || string.indexOf("typewriter") >= 0 || string.startsWith("letter gothic")) {
            return _b.o00000;
        }
        return _b.\u00d200000;
    }

    public static String buildKey(String[] stringArray, int n2, float f2) {
        String string = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].trim();
            string = string + stringArray[i2] + ":";
        }
        string = string.substring(0, string.length() - 1);
        if ((n2 & 1) > 0) {
            string = string + ":bold";
        }
        if ((n2 & 2) > 0) {
            string = string + ":italic";
        }
        return string + ":" + f2;
    }

    public static String extendNameWithStyle(String string, int n2) {
        string = string.trim().toLowerCase();
        if ((n2 & 1) > 0) {
            string = string + " bold";
        }
        if ((n2 & 2) > 0) {
            string = string + " italic";
        }
        return string;
    }

    public static boolean hasMultipleLanguageGroups(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = 0;
        char c2 = string.charAt(n2++);
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        if (string.length() > 1 && Character.isSurrogate(c2)) {
            ++n2;
        }
        if (Character.isWhitespace(c2) || Character.isSpaceChar(c2)) {
            unicodeBlock = null;
        }
        char c3 = c2;
        int n3 = string.length();
        while (n2 < n3) {
            c2 = string.charAt(n2);
            if (c2 == '$' && n2 < n3 - 3 && string.charAt(n2 + 1) == '[' && !FontCache.super(unicodeBlock)) {
                return true;
            }
            if (bl && (c2 == '(' || c2 == '[' || c2 == '{')) {
                return true;
            }
            boolean bl2 = c2 == '$' && n2 < n3 - 3 && string.charAt(n2 + 1) == '[' && !FontCache.super(unicodeBlock);
            boolean bl3 = bl && (c3 == '(' || c2 == ')' || c3 == '[' || c2 == ']' || c3 == '{' || c2 == '}');
            Character.UnicodeBlock unicodeBlock2 = Character.UnicodeBlock.of(c2);
            if (bl && n3 > 1 && (c2 == '-' || c3 == '-' || c2 == '\u060c' || c3 == '\u060c')) {
                bl2 = true;
            }
            if (unicodeBlock != unicodeBlock2 && (Character.UnicodeBlock.THAI.equals(unicodeBlock) || Character.UnicodeBlock.THAI.equals(unicodeBlock2))) {
                bl2 = true;
            }
            if (c2 != '\u00ad' && !Character.isWhitespace(c2) && !returnwhilenew.matcher("" + c2).matches() || bl2) {
                if (!bl3 && FontCache.super(unicodeBlock, unicodeBlock2, bl)) {
                    return true;
                }
                unicodeBlock = unicodeBlock2;
            }
            if (Character.isSurrogate(c2) && n2 < n3 - 1) {
                ++n2;
            }
            c3 = c2;
            ++n2;
        }
        return false;
    }

    public static _c[] splitStringByLanguageGroups(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Vector<_c> vector = new Vector<_c>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        char c2 = string.charAt(n2++);
        stringBuilder.append(c2);
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        if (string.length() > 1 && Character.isSurrogate(c2)) {
            stringBuilder.append(string.charAt(n2++));
        }
        if (Character.isWhitespace(c2) || Character.isSpaceChar(c2)) {
            unicodeBlock = null;
        }
        char c3 = c2;
        int n3 = string.length();
        while (n2 < n3) {
            c2 = string.charAt(n2);
            boolean bl2 = bl && (c2 == '(' || c3 == ')' || c2 == '[' || c3 == ']' || c2 == '{' || c3 == '}');
            boolean bl3 = c2 == '$' && n2 < n3 - 3 && string.charAt(n2 + 1) == '[' && !FontCache.super(unicodeBlock);
            boolean bl4 = bl && (c3 == '(' || c2 == ')' || c3 == '[' || c2 == ']' || c3 == '{' || c2 == '}');
            Character.UnicodeBlock unicodeBlock2 = Character.UnicodeBlock.of(c2);
            if (bl && n3 > 1 && (c2 == '-' || c3 == '-' || c2 == '\u060c' || c3 == '\u060c')) {
                bl3 = true;
            }
            if (unicodeBlock != unicodeBlock2 && (Character.UnicodeBlock.THAI.equals(unicodeBlock) || Character.UnicodeBlock.THAI.equals(unicodeBlock2))) {
                bl3 = true;
            }
            if (c2 != '\u00ad' && !Character.isWhitespace(c2) && !returnwhilenew.matcher("" + c2).matches() || bl3) {
                if ((bl2 || bl3 || !bl4 && FontCache.super(unicodeBlock, unicodeBlock2, bl)) && stringBuilder.length() > 0) {
                    if (vector.size() > 0) {
                        _c _c2 = (_c)vector.get(vector.size() - 1);
                        if (_c2.\u00d200000() && !FontCache.isRtlScript(stringBuilder.toString())) {
                            vector.addElement(new _c(stringBuilder, unicodeBlock, !bl3));
                            _c2.o00000();
                        } else {
                            vector.addElement(new _c(stringBuilder, unicodeBlock));
                        }
                    } else {
                        vector.addElement(new _c(stringBuilder, unicodeBlock));
                    }
                    stringBuilder.setLength(0);
                }
                unicodeBlock = unicodeBlock2;
            }
            stringBuilder.append(c2);
            if (Character.isSurrogate(c2) && n2 < n3 - 1) {
                stringBuilder.append(string.charAt(++n2));
            }
            c3 = c2;
            ++n2;
        }
        if (stringBuilder.length() > 0) {
            vector.addElement(new _c(stringBuilder, unicodeBlock));
        }
        return vector.toArray(new _c[vector.size()]);
    }

    public boolean isApplyKerning() {
        return this.\u00d5\u00f5\u00d4000;
    }

    public void setApplyKerning(boolean bl) {
        this.\u00d5\u00f5\u00d4000 = bl;
    }

    public boolean supportComplexScripts() {
        return this.\u00f4\u00f4\u00d4000;
    }

    public void supportComplexScripts(boolean bl) {
        this.\u00f4\u00f4\u00d4000 = bl;
    }

    public static boolean isRtlScript(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = Character.getDirectionality(string.charAt(i2));
            switch (by) {
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    return true;
                }
            }
        }
        return false;
    }

    protected static boolean super(Character.UnicodeBlock unicodeBlock) {
        if (unicodeBlock == null) {
            return false;
        }
        String string = unicodeBlock.toString();
        return string.indexOf("LATIN") >= 0;
    }

    protected static boolean super(Character.UnicodeBlock unicodeBlock, Character.UnicodeBlock unicodeBlock2, boolean bl) {
        if (FontCache.super(unicodeBlock) && FontCache.super(unicodeBlock2) || !bl && (Character.UnicodeBlock.GENERAL_PUNCTUATION.equals(unicodeBlock) || Character.UnicodeBlock.GENERAL_PUNCTUATION.equals(unicodeBlock2))) {
            return false;
        }
        return unicodeBlock != null && unicodeBlock2 != unicodeBlock;
    }

    public static void generateFontPropertiesFile(String string, String string2) throws IOException {
        FontCache.generateFontPropertiesFile(string, string2, null, (short)0);
    }

    public static void generateFontPropertiesFile(String string, String string2, short s2) throws IOException {
        FontCache.generateFontPropertiesFile(string, string2, null, s2);
    }

    public static void generateFontPropertiesFile(String string, String string2, String string3, short s2) throws IOException {
        File file;
        File file2 = new File(string, \u00d8\u00f5\u00d4000);
        if (string2 != null && string2.length() > 0) {
            file = new File(string2);
            file2 = file.exists() && file.isDirectory() ? new File(file, \u00d8\u00f5\u00d4000) : file;
        }
        file = new File(file2.getAbsolutePath());
        file.getParentFile().mkdirs();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        FontCache.generateFontPropertiesFile(string, bufferedOutputStream, string2 != null && string2.length() > 0, string3, s2);
    }

    public static void generateFontPropertiesFile(String string, BufferedOutputStream bufferedOutputStream, boolean bl) throws IOException {
        FontCache.generateFontPropertiesFile(string, bufferedOutputStream, bl, null, (short)0);
    }

    public static void generateFontPropertiesFile(String string, BufferedOutputStream bufferedOutputStream, boolean bl, String string2, short s2) throws IOException {
        FontCache fontCache = new FontCache(new FileCache(null, "./", null, new Properties(), s2));
        Properties properties = fontCache.OO0000(string, string2);
        if (bl) {
            properties.put(newwhilenew, string);
        }
        properties.store(bufferedOutputStream, "this is an autogenerated file. please remove manually any references to copyrighted fonts");
        bufferedOutputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    private Properties OO0000(String string, String string2) {
        int n2;
        Object object;
        int n3;
        File file = new File(string);
        String[] stringArray = null;
        if (string2 != null && (n3 = ((StringTokenizer)(object = new StringTokenizer(string2, ","))).countTokens()) > 0) {
            stringArray = new String[n3];
            n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringArray[n2++] = ((StringTokenizer)object).nextToken().toLowerCase();
            }
        }
        Object object2 = object = j.\u00d200000() ? new Properties() : new Properties(){

            @Override
            public synchronized Enumeration keys() {
                ArrayList<Object> arrayList = Collections.list(super.keys());
                Collections.sort(arrayList);
                return Collections.enumeration(arrayList);
            }
        };
        if (file.isDirectory()) {
            String[] stringArray2 = file.list();
            if (stringArray2.length > 40) {
                this.log((short)16, "Too many font files to index (" + stringArray2.length + "). To improve performance generate " + \u00d8\u00f5\u00d4000 + " in advance");
            }
            if (stringArray2 != null) {
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    File file2;
                    String string3 = stringArray2[n2].toLowerCase();
                    if (stringArray != null) {
                        boolean bl = true;
                        for (String stringArray3 : stringArray) {
                            if (string3.indexOf(stringArray3) < 0) continue;
                            bl = false;
                            break;
                        }
                        if (bl) continue;
                    }
                    if (string3.indexOf(".tt") <= 0 && string3.indexOf(".ot") <= 0 || (file2 = new File(string + "/" + stringArray2[n2])).isDirectory() || !file2.canRead()) continue;
                    try {
                        void var13_26;
                        if (string3.endsWith(".ttc")) {
                            try {
                                int n4 = 0;
                                while (true) {
                                    file2 = new File(string + "/" + stringArray2[n2] + "_" + n4);
                                    l l2 = new l(this, "file:" + file2.toString());
                                    String string4 = l2.\u00d200000();
                                    string4 = "regular".equalsIgnoreCase(string4) ? "" : " " + string4;
                                    String[] stringArray3 = l2.\u00d4O0000();
                                    for (int i2 = 0; i2 < stringArray3.length; ++i2) {
                                        if (((Properties)object).get(stringArray3[i2] + string4) != null) continue;
                                        ((Properties)object).put(stringArray3[i2] + string4, stringArray2[n2] + "_" + n4);
                                    }
                                    ++n4;
                                }
                            }
                            catch (Exception exception) {
                                continue;
                            }
                        }
                        l l3 = new l(this, "file:" + file2.toString());
                        String string5 = l3.\u00d200000();
                        string5 = "regular".equalsIgnoreCase(string5) ? "" : " " + string5;
                        String[] stringArray4 = l3.\u00d4O0000();
                        boolean bl = false;
                        while (var13_26 < stringArray4.length) {
                            if (((Properties)object).get(stringArray4[var13_26] + string5) == null) {
                                ((Properties)object).put(stringArray4[var13_26] + string5, stringArray2[n2]);
                            }
                            ++var13_26;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        this.log((short)8, exception.getMessage() + " " + file2.getAbsolutePath());
                    }
                }
            }
        }
        this.log((short)128, ((Properties)object).size() + " mapping entries added");
        return object;
    }

    static {
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.BASIC_LATIN, "\u0000");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.LATIN_1_SUPPLEMENT, "\u0080");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.LATIN_EXTENDED_A, "\u0100");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.LATIN_EXTENDED_B, "\u0180");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.IPA_EXTENSIONS, "\u0250");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SPACING_MODIFIER_LETTERS, "\u02b0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS, "\u0300");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.GREEK, "\u0370");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CYRILLIC, "\u0400");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ARMENIAN, "\u0530");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.HEBREW, "\u0590");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ARABIC, "\u0600");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SYRIAC, "\u0700");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.THAANA, "\u0780");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.DEVANAGARI, "\u0900");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.BENGALI, "\u0980");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.GURMUKHI, "\u0a00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.GUJARATI, "\u0a80");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ORIYA, "\u0b00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.TAMIL, "\u0b80");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.TELUGU, "\u0c00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.KANNADA, "\u0c80");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.MALAYALAM, "\u0d00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SINHALA, "\u0d80");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.THAI, "\u0e00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.LAO, "\u0e80");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.TIBETAN, "\u0f00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.MYANMAR, "\u1000");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.GEORGIAN, "\u10a0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.HANGUL_JAMO, "\u1100");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ETHIOPIC, "\u1200");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CHEROKEE, "\u13a0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, "\u1400");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.OGHAM, "\u1680");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.RUNIC, "\u16a0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.KHMER, "\u1780");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.MONGOLIAN, "\u1800");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL, "\u1e00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.GREEK_EXTENDED, "\u1f00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.GENERAL_PUNCTUATION, "\u2000");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SUPERSCRIPTS_AND_SUBSCRIPTS, "\u2070");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CURRENCY_SYMBOLS, "\u20a0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.COMBINING_MARKS_FOR_SYMBOLS, "\u20d0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.LETTERLIKE_SYMBOLS, "\u2100");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.NUMBER_FORMS, "\u2150");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ARROWS, "\u2190");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.MATHEMATICAL_OPERATORS, "\u2200");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.MISCELLANEOUS_TECHNICAL, "\u2300");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CONTROL_PICTURES, "\u2400");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.OPTICAL_CHARACTER_RECOGNITION, "\u2440");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS, "\u2460");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.BOX_DRAWING, "\u2500");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.BLOCK_ELEMENTS, "\u2580");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.GEOMETRIC_SHAPES, "\u25a0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS, "\u2600");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.DINGBATS, "\u2700");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.BRAILLE_PATTERNS, "\u2800");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, "\u2e80");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.KANGXI_RADICALS, "\u2f00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.IDEOGRAPHIC_DESCRIPTION_CHARACTERS, "\u2ff0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, "\u3000");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.HIRAGANA, "\u3040");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.KATAKANA, "\u30a0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.BOPOMOFO, "\u3100");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO, "\u3130");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.KANBUN, "\u3190");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.BOPOMOFO_EXTENDED, "\u31a0");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS, "\u3200");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CJK_COMPATIBILITY, "\u3300");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, "\u3400");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, "\u4e00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.YI_SYLLABLES, "\ua000");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.YI_RADICALS, "\ua490");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.HANGUL_SYLLABLES, "\uac00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SURROGATES_AREA, "\ud800");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.PRIVATE_USE_AREA, "\ue000");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, "\uf900");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ALPHABETIC_PRESENTATION_FORMS, "\ufb00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A, "\ufb50");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.COMBINING_HALF_MARKS, "\ufe20");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, "\ufe30");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SMALL_FORM_VARIANTS, "\ufe50");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B, "\ufe70");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SPECIALS, "\ufeff");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS, "\uff00");
        \u00d5\u00f4\u00d4000.put(Character.UnicodeBlock.SPECIALS, "\ufff0");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class _c {
        public String new;
        public Character.UnicodeBlock o00000;

        public _c(StringBuilder stringBuilder, Character.UnicodeBlock unicodeBlock) {
            this.new = stringBuilder.toString();
            this.o00000 = unicodeBlock;
        }

        public _c(StringBuilder stringBuilder, Character.UnicodeBlock unicodeBlock, boolean bl) {
            this(stringBuilder, unicodeBlock);
            if (bl) {
                this.new = " " + this.new;
            }
        }

        public void o00000() {
            if (this.new.length() > 0 && Character.isWhitespace(this.new.charAt(this.new.length() - 1))) {
                this.new = this.new.substring(0, this.new.length() - 1);
            }
        }

        public boolean \u00d200000() {
            return FontCache.isRtlScript(this.new);
        }
    }

    public static enum _b {
        \u00d200000,
        \u00d400000,
        o00000;

    }
}

