/*
 * Decompiled with CFR 0.152.
 */
package com.representqueens.web.tags.spark;

import com.representqueens.util.StringUtils;
import com.representqueens.web.tags.spark.AbstractGraph;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractServerGraph
extends AbstractGraph {
    private static final String DEFAULT_PATH = "/spark";
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getRealPath() {
        Object object = this.pageContext.findAttribute("sparkPath");
        if (object instanceof String) {
            return this.convertPath(object.toString());
        }
        return this.convertPath(this.path == null ? DEFAULT_PATH : this.path);
    }

    private String convertPath(String string) {
        String string2 = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        return String.format("%s%s", string2, string);
    }

    protected String getQueryParams() {
        Number[] numberArray;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{"color", "highcolor", "lastcolor", "background", "width", "height", "spacing", "output"};
        String[] stringArray2 = new String[]{this.getColor(), this.getHighColor(), this.getLastColor(), this.getBackground(), this.getWidth(), this.getHeight(), this.getSpacing(), this.getOutput()};
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (StringUtils.isEmpty(stringArray2[i])) continue;
                stringBuilder.append("&").append(stringArray[i]).append("=").append(URLEncoder.encode(stringArray2[i], "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if ((numberArray = this.getData()) != null && numberArray.length > 0) {
            stringBuilder.append("&data=");
            stringBuilder.append(StringUtils.toString(numberArray));
        }
        return stringBuilder.toString();
    }
}

