/*
 * Decompiled with CFR 0.152.
 */
package com.representqueens.spark;

import com.representqueens.spark.GraphUtils;
import com.representqueens.spark.SizeParams;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class BarGraph {
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 25;
    public static final int DEFAULT_SPACING = 2;
    public static final SizeParams DEFAULT_SIZE = new SizeParams(100, 25, 2);
    public static final Color DEFAULT_COLOR = Color.GRAY;
    public static final Color DEFAULT_HIGH_COLOR = Color.BLACK;
    public static final Color DEFAULT_LAST_COLOR = Color.RED;

    public static BufferedImage createGraph(Number[] numberArray) {
        return BarGraph.createGraph(numberArray, DEFAULT_SIZE, DEFAULT_COLOR, DEFAULT_HIGH_COLOR, DEFAULT_LAST_COLOR);
    }

    public static BufferedImage createGraph(Number[] numberArray, SizeParams sizeParams, Color color, Color color2, Color color3) {
        return BarGraph.createGraph(numberArray, sizeParams, color, color2, color3, null);
    }

    public static BufferedImage createGraph(Number[] numberArray, SizeParams sizeParams, Color color, Color color2, Color color3, Color color4) {
        BufferedImage bufferedImage = new BufferedImage(sizeParams.getWidth(), sizeParams.getHeight(), 2);
        if (numberArray == null || numberArray.length < 1) {
            return bufferedImage;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color4 != null) {
            graphics2D.setBackground(color4);
            graphics2D.clearRect(0, 0, sizeParams.getWidth(), sizeParams.getHeight());
        }
        float f = GraphUtils.getDivisor(numberArray, sizeParams.getHeight());
        int n = BarGraph.getAvg(numberArray);
        int n2 = (sizeParams.getWidth() - sizeParams.getSpacing() * numberArray.length) / numberArray.length;
        int n3 = 0;
        int n4 = 0;
        for (Number number : numberArray) {
            int n5 = (int)(number.floatValue() / f);
            if (n4 == numberArray.length - 1 && color3 != null) {
                graphics2D.setPaint(color3);
            } else if (number.intValue() < n || color2 == null) {
                graphics2D.setPaint(color);
            } else {
                graphics2D.setPaint(color2);
            }
            graphics2D.fill(new Rectangle2D.Double(n3, 0 + (sizeParams.getHeight() - n5), n2, (float)number.intValue() / f));
            n3 += n2 + sizeParams.getSpacing();
            ++n4;
        }
        return bufferedImage;
    }

    private static final int getAvg(Number[] numberArray) {
        int n = 0;
        for (Number number : numberArray) {
            n += number.intValue();
        }
        return n / numberArray.length;
    }
}

