/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import com.egurkha.util.UploadedFile;
import com.egurkha.util.multipart.FilePart;
import com.egurkha.util.multipart.FileRenamePolicy;
import com.egurkha.util.multipart.MultipartParser;
import com.egurkha.util.multipart.ParamPart;
import com.egurkha.util.multipart.Part;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Hashtable parameters = new Hashtable();
    protected Hashtable files = new Hashtable();

    public MultipartRequest(HttpServletRequest httpServletRequest, String string) throws IOException {
        this(httpServletRequest, string, 0x100000);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n) throws IOException {
        this(httpServletRequest, string, n, null, null);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, String string2) throws IOException {
        this(httpServletRequest, string, 0x100000, string2, null);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n, FileRenamePolicy fileRenamePolicy) throws IOException {
        this(httpServletRequest, string, n, null, fileRenamePolicy);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n, String string2) throws IOException {
        this(httpServletRequest, string, n, string2, null);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n, String string2, FileRenamePolicy fileRenamePolicy) throws IOException {
        Vector<String[]> vector;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + string);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + string);
        }
        MultipartParser multipartParser = new MultipartParser(httpServletRequest, n, true, true, string2);
        if (httpServletRequest.getQueryString() != null) {
            object4 = HttpUtils.parseQueryString((String)httpServletRequest.getQueryString());
            object3 = ((Hashtable)object4).keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = (String[])((Hashtable)object4).get(object2);
                vector = new Vector<String[]>();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    vector.add((String[])object[i]);
                }
                this.parameters.put(object2, vector);
            }
        }
        while ((object4 = multipartParser.readNextPart()) != null) {
            object3 = ((Part)object4).getName();
            if (((Part)object4).isParam()) {
                object2 = (ParamPart)object4;
                object = ((ParamPart)object2).getStringValue();
                vector = (Vector<String[]>)this.parameters.get(object3);
                if (vector == null) {
                    vector = new Vector<String[]>();
                    this.parameters.put(object3, vector);
                }
                vector.addElement((String[])object);
                continue;
            }
            if (!((Part)object4).isFile()) continue;
            object2 = (FilePart)object4;
            object = ((FilePart)object2).getFileName();
            if (object != null) {
                ((FilePart)object2).setRenamePolicy(fileRenamePolicy);
                ((FilePart)object2).writeTo(file);
                this.files.put(object3, new UploadedFile(file.toString(), ((FilePart)object2).getFileName(), (String)object, ((FilePart)object2).getContentType()));
                continue;
            }
            this.files.put(object3, new UploadedFile(null, null, null, null));
        }
    }

    public MultipartRequest(ServletRequest servletRequest, String string) throws IOException {
        this((HttpServletRequest)servletRequest, string);
    }

    public MultipartRequest(ServletRequest servletRequest, String string, int n) throws IOException {
        this((HttpServletRequest)servletRequest, string, n);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getParameter(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = (String)vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFilesystemName(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFilesystemName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOriginalFileName(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getOriginalFileName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getContentType(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getContentType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

