/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import com.egurkha.util.InetAddressValidator;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPAddressUtils {
    private static InetAddressValidator ipvalidator = InetAddressValidator.getInstance();

    public static boolean isValidIPAddress(String string) {
        return ipvalidator.isValid(string);
    }

    public static boolean isValidIPV4(String string) {
        return ipvalidator.isValidInet4Address(string);
    }

    public static boolean isValidIPV6(String string) {
        return ipvalidator.isValidInet6Address(string);
    }

    public static boolean isValidPublicIp(String string, boolean bl) {
        InetAddress inetAddress = null;
        if (bl && !IPAddressUtils.isValidIPAddress(string)) {
            throw new RuntimeException("--------invalid ipAddress------" + string);
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return !inetAddress.isSiteLocalAddress() && !inetAddress.isAnyLocalAddress() && !inetAddress.isLinkLocalAddress() && !inetAddress.isLoopbackAddress() && !inetAddress.isMulticastAddress();
    }
}

