/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcStorageProfileType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMWProviderVdcStorageProfile
extends VcloudEntity<VMWProviderVdcStorageProfileType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType vmwProviderVdcRef;

    VMWProviderVdcStorageProfile(VcloudClient client, VMWProviderVdcStorageProfileType vmwProviderVdcStorageProfileType) {
        super(client, vmwProviderVdcStorageProfileType);
    }

    public static VMWProviderVdcStorageProfile getVMWProviderVdcStorageProfileByReference(VcloudClient client, ReferenceType vmwProviderVdcStorageProfileRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vmwProviderVdcStorageProfileRef.getHref());
        return new VMWProviderVdcStorageProfile(client, (VMWProviderVdcStorageProfileType)VMWProviderVdcStorageProfile.getResourceByReference(client, vmwProviderVdcStorageProfileRef));
    }

    public ReferenceType getVMWProviderVdcReference() throws VCloudException {
        if (this.vmwProviderVdcRef == null) {
            for (LinkType ref : ((VMWProviderVdcStorageProfileType)this.getResource()).getLink()) {
                if (!ref.getRel().equals("up") || !ref.getType().equals("application/vnd.vmware.admin.vmwprovidervdc+xml")) continue;
                return ref;
            }
        } else {
            return this.vmwProviderVdcRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public VMWProviderVdcStorageProfile updateVMWProviderVdcStorageProfile(VMWProviderVdcStorageProfileType vmwProviderVdcStorageProfileResource) throws VCloudException {
        String requestString = JAXBUtil.marshal(new ObjectFactory().createVMWProviderVdcStorageProfile(vmwProviderVdcStorageProfileResource));
        return new VMWProviderVdcStorageProfile(this.getVcloudClient(), (VMWProviderVdcStorageProfileType)SdkUtil.put(this.getVcloudClient(), this.getReference().getHref(), requestString, "application/vnd.vmware.admin.vmwPvdcStorageProfile+xml", 200));
    }
}

