/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.BlockingTaskOperationParamsType;
import com.vmware.vcloud.api.rest.schema.extension.BlockingTaskType;
import com.vmware.vcloud.api.rest.schema.extension.BlockingTaskUpdateProgressParamsType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingTask
extends VcloudEntity<BlockingTaskType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType taskReference;

    BlockingTask(VcloudClient client, BlockingTaskType resourceType) {
        super(client, resourceType);
        this.sortBlockingTaskRefs_v1_5();
    }

    private void sortBlockingTaskRefs_v1_5() {
        for (LinkType taskLink : ((BlockingTaskType)this.getResource()).getLink()) {
            if (!taskLink.getRel().equals("up") || !taskLink.getType().equals("application/vnd.vmware.vcloud.task+xml")) continue;
            this.taskReference = taskLink;
        }
    }

    public ReferenceType getTaskReference() throws VCloudException {
        if (this.taskReference != null) {
            return this.taskReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public static BlockingTask getBlockingTaskByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new BlockingTask(client, (BlockingTaskType)BlockingTask.getResourceByReference(client, reference));
    }

    public static BlockingTask getBlockingTaskById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new BlockingTask(client, (BlockingTaskType)BlockingTask.getEntityById(client, vCloudId, "application/vnd.vmware.admin.blockingTask+xml"));
    }

    public ReferenceType getOrgReference() {
        return ((BlockingTaskType)this.getResource()).getOrganization();
    }

    public ReferenceType getUserReference() {
        return ((BlockingTaskType)this.getResource()).getUser();
    }

    public ReferenceType getOwnerReference() {
        return ((BlockingTaskType)this.getResource()).getTaskOwner();
    }

    public XMLGregorianCalendar getCreatedDate() {
        return ((BlockingTaskType)this.getResource()).getCreatedTime();
    }

    public XMLGregorianCalendar getTimeoutDate() {
        return ((BlockingTaskType)this.getResource()).getTimeoutDate();
    }

    public String getStatus() {
        return ((BlockingTaskType)this.getResource()).getStatus();
    }

    public String getTimeoutAction() {
        return ((BlockingTaskType)this.getResource()).getTimeoutAction();
    }

    public void abortOperation(String abortMessage) throws VCloudException {
        BlockingTaskOperationParamsType requestOperationParams = new BlockingTaskOperationParamsType();
        requestOperationParams.setMessage(abortMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskOperationParams(requestOperationParams));
        SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/abort", requestString, "application/vnd.vmware.admin.blockingTaskOperationParams+xml", 204);
    }

    public void failOperation(String failMessage) throws VCloudException {
        BlockingTaskOperationParamsType requestOperationParams = new BlockingTaskOperationParamsType();
        requestOperationParams.setMessage(failMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskOperationParams(requestOperationParams));
        SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/fail", requestString, "application/vnd.vmware.admin.blockingTaskOperationParams+xml", 204);
    }

    public void resumeOperation(String resumeMessage) throws VCloudException {
        BlockingTaskOperationParamsType requestOperationParams = new BlockingTaskOperationParamsType();
        requestOperationParams.setMessage(resumeMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskOperationParams(requestOperationParams));
        SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/resume", requestString, "application/vnd.vmware.admin.blockingTaskOperationParams+xml", 204);
    }

    public BlockingTask updateProgress(String updateMessage, long timeout) throws VCloudException {
        BlockingTaskUpdateProgressParamsType progressParamsType = new BlockingTaskUpdateProgressParamsType();
        progressParamsType.setMessage(updateMessage);
        progressParamsType.setTimeoutValueInMilliseconds(Long.valueOf(timeout));
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskUpdateProgressParams(progressParamsType));
        return new BlockingTask(this.getVcloudClient(), (BlockingTaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/updateProgress", requestString, "application/vnd.vmware.admin.blockingTaskUpdateProgressOperationParams+xml", 200));
    }

    public BlockingTask updateProgress(String updateMessage) throws VCloudException {
        BlockingTaskUpdateProgressParamsType progressParamsType = new BlockingTaskUpdateProgressParamsType();
        progressParamsType.setMessage(updateMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskUpdateProgressParams(progressParamsType));
        return new BlockingTask(this.getVcloudClient(), (BlockingTaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/updateProgress", requestString, "application/vnd.vmware.admin.blockingTaskUpdateProgressOperationParams+xml", 200));
    }

    public static ReferenceType getOrgReference(VcloudClient client, ReferenceType blockingTaskRef) throws VCloudException {
        return ((BlockingTaskType)SdkUtil.get(client, blockingTaskRef.getHref(), 200)).getOrganization();
    }

    public static ReferenceType getUserReference(VcloudClient client, ReferenceType blockingTaskRef) throws VCloudException {
        return ((BlockingTaskType)SdkUtil.get(client, blockingTaskRef.getHref(), 200)).getUser();
    }

    public static ReferenceType getOwnerReference(VcloudClient client, ReferenceType blockingTaskRef) throws VCloudException {
        return ((BlockingTaskType)SdkUtil.get(client, blockingTaskRef.getHref(), 200)).getTaskOwner();
    }

    public static XMLGregorianCalendar getCreatedDate(VcloudClient client, ReferenceType blockingTaskRef) throws VCloudException {
        return ((BlockingTaskType)SdkUtil.get(client, blockingTaskRef.getHref(), 200)).getCreatedTime();
    }

    public static XMLGregorianCalendar getTimeoutDate(VcloudClient client, ReferenceType blockingTaskRef) throws VCloudException {
        return ((BlockingTaskType)SdkUtil.get(client, blockingTaskRef.getHref(), 200)).getTimeoutDate();
    }

    public static String getStatus(VcloudClient client, ReferenceType blockingTaskRef) throws VCloudException {
        return ((BlockingTaskType)SdkUtil.get(client, blockingTaskRef.getHref(), 200)).getStatus();
    }

    public static String getTimeoutAction(VcloudClient client, ReferenceType blockingTaskRef) throws VCloudException {
        return ((BlockingTaskType)SdkUtil.get(client, blockingTaskRef.getHref(), 200)).getTimeoutAction();
    }

    public static void abortOperation(VcloudClient client, ReferenceType blockingTaskRef, String abortMessage) throws VCloudException {
        BlockingTaskOperationParamsType requestOperationParams = new BlockingTaskOperationParamsType();
        requestOperationParams.setMessage(abortMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskOperationParams(requestOperationParams));
        SdkUtil.post(client, blockingTaskRef.getHref() + "/action/abort", requestString, "application/vnd.vmware.admin.blockingTaskOperationParams+xml", 204);
    }

    public static void failOperation(VcloudClient client, ReferenceType blockingTaskRef, String failMessage) throws VCloudException {
        BlockingTaskOperationParamsType requestOperationParams = new BlockingTaskOperationParamsType();
        requestOperationParams.setMessage(failMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskOperationParams(requestOperationParams));
        SdkUtil.post(client, blockingTaskRef.getHref() + "/action/fail", requestString, "application/vnd.vmware.admin.blockingTaskOperationParams+xml", 204);
    }

    public static void resumeOperation(VcloudClient client, ReferenceType blockingTaskRef, String resumeMessage) throws VCloudException {
        BlockingTaskOperationParamsType requestOperationParams = new BlockingTaskOperationParamsType();
        requestOperationParams.setMessage(resumeMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskOperationParams(requestOperationParams));
        SdkUtil.post(client, blockingTaskRef.getHref() + "/action/resume", requestString, "application/vnd.vmware.admin.blockingTaskOperationParams+xml", 204);
    }

    public static BlockingTask updateProgress(VcloudClient client, ReferenceType blockingTaskRef, String updateMessage, long timeout) throws VCloudException {
        BlockingTaskUpdateProgressParamsType progressParamsType = new BlockingTaskUpdateProgressParamsType();
        progressParamsType.setMessage(updateMessage);
        progressParamsType.setTimeoutValueInMilliseconds(Long.valueOf(timeout));
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskUpdateProgressParams(progressParamsType));
        return new BlockingTask(client, (BlockingTaskType)SdkUtil.post(client, blockingTaskRef.getHref() + "/action/updateProgress", requestString, "application/vnd.vmware.admin.blockingTaskUpdateProgressOperationParams+xml", 200));
    }

    public static BlockingTask updateProgress(VcloudClient client, ReferenceType blockingTaskRef, String updateMessage) throws VCloudException {
        BlockingTaskUpdateProgressParamsType progressParamsType = new BlockingTaskUpdateProgressParamsType();
        progressParamsType.setMessage(updateMessage);
        String requestString = JAXBUtil.marshal(new ObjectFactory().createBlockingTaskUpdateProgressParams(progressParamsType));
        return new BlockingTask(client, (BlockingTaskType)SdkUtil.post(client, blockingTaskRef.getHref() + "/action/updateProgress", requestString, "application/vnd.vmware.admin.blockingTaskUpdateProgressOperationParams+xml", 200));
    }
}

