/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.RoleType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Role
extends VcloudEntity<RoleType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    Role(VcloudClient client, RoleType roleType_v1_5) {
        super(client, roleType_v1_5);
    }

    public static Role getRoleByReference(VcloudClient client, ReferenceType roleRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + roleRef.getHref());
        return new Role(client, (RoleType)Role.getResourceByReference(client, roleRef));
    }

    public static Role getRoleById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Role(client, (RoleType)Role.getEntityById(client, vCloudId, "application/vnd.vmware.admin.role+xml"));
    }

    public Role updateRole(RoleType roleType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String roleUpdateUrl = this.getReference().getHref();
        String roleUpdateRequestXmlString = JAXBUtil.marshal(of.createRole(roleType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + roleUpdateUrl);
        return new Role(this.getVcloudClient(), (RoleType)SdkUtil.put(this.getVcloudClient(), roleUpdateUrl, roleUpdateRequestXmlString, "application/vnd.vmware.admin.role+xml", 200));
    }

    public void delete() throws VCloudException {
        String roleUrl = this.getReference().getHref();
        Role.deleteRole(this.getVcloudClient(), roleUrl);
    }

    public static void delete(VcloudClient client, ReferenceType roleRef) throws VCloudException {
        Role.deleteRole(client, roleRef.getHref());
    }

    private static void deleteRole(VcloudClient client, String roleUrl) throws VCloudException {
        SdkUtil.delete(client, roleUrl, 204);
    }
}

