/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.EntityType;
import com.vmware.vcloud.api.rest.schema.IdentifiableResourceType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.MetadataType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.Metadata;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VcloudEntity<T extends IdentifiableResourceType>
extends VcloudResource<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType referenceType;
    private List<Task> tasks;

    protected VcloudEntity(VcloudClient client, T entityType) {
        super(client, entityType);
        this.setEntityLinks(client, entityType);
    }

    protected void setEntityLinks(VcloudClient client, T entityType) {
        this.setTasks(client, (EntityType)entityType);
        this.setReference((EntityType)entityType);
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public ReferenceType getReference() {
        return this.referenceType;
    }

    private void setTasks(VcloudClient client, EntityType entityType) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Task>();
            if (entityType.getTasks() != null) {
                for (TaskType taskType : entityType.getTasks().getTask()) {
                    this.tasks.add(new Task(client, taskType));
                }
            }
        }
    }

    private void setReference(EntityType entity) {
        this.referenceType = new ReferenceType();
        this.referenceType.setHref(entity.getHref());
        this.referenceType.setName(entity.getName());
        this.referenceType.setType(entity.getType());
        this.referenceType.setId(entity.getId());
    }

    protected void setReference(IdentifiableResourceType identifiableResourceType) {
        this.referenceType = new ReferenceType();
        this.referenceType.setHref(identifiableResourceType.getHref());
        this.referenceType.setType(identifiableResourceType.getType());
        this.referenceType.setId(identifiableResourceType.getId());
    }

    protected static EntityType getEntityById(VcloudClient client, String vCloudId, String mediaType) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + client.getVcloudApiURL() + "/entity" + "/" + vCloudId);
        EntityType entity = (EntityType)SdkUtil.get(client, client.getVcloudApiURL() + "/entity" + "/" + vCloudId, 200);
        for (LinkType link : entity.getLink()) {
            if (!link.getType().equals(mediaType)) continue;
            return (EntityType)SdkUtil.get(client, link.getHref(), 200);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public Metadata getMetadata() throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + this.getReference().getHref() + "/metadata");
        return new Metadata(this.getVcloudClient(), (MetadataType)SdkUtil.get(this.getVcloudClient(), this.getReference().getHref() + "/metadata", 200));
    }
}

