/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.AbstractVAppType;
import com.vmware.vcloud.api.rest.schema.ControlAccessParamsType;
import com.vmware.vcloud.api.rest.schema.FileType;
import com.vmware.vcloud.api.rest.schema.FilesListType;
import com.vmware.vcloud.api.rest.schema.LeaseSettingsSectionType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.NetworkConfigSectionType;
import com.vmware.vcloud.api.rest.schema.OwnerType;
import com.vmware.vcloud.api.rest.schema.RecomposeVAppParamsType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VAppChildrenType;
import com.vmware.vcloud.api.rest.schema.VAppNetworkConfigurationType;
import com.vmware.vcloud.api.rest.schema.VAppType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.VmType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.api.rest.schema.ovf.EnvelopeType;
import com.vmware.vcloud.api.rest.schema.ovf.NetworkSectionNetwork;
import com.vmware.vcloud.api.rest.schema.ovf.NetworkSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ovf.ReferencesType;
import com.vmware.vcloud.api.rest.schema.ovf.SectionType;
import com.vmware.vcloud.api.rest.schema.ovf.StartupSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.VirtualHardwareSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.VirtualSystemCollectionType;
import com.vmware.vcloud.api.rest.schema.ovf.VirtualSystemType;
import com.vmware.vcloud.api.rest.schema.ovf.vmware.ConfigType;
import com.vmware.vcloud.sdk.AbstractVapp;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VM;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VappStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vapp
extends AbstractVapp<VAppType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private StartupSectionType startupSection;
    private NetworkSectionType networkSection;
    private NetworkConfigSectionType networkConfigSection;
    private LeaseSettingsSectionType leaseSettingsSection;
    private List<Vapp> childrenvApps;
    private List<VM> childrenVms;
    private ReferenceType vdcReference;
    private HashMap<String, ReferenceType> vappNetworkRefsByName;
    private HashMap<String, FileType> uploadFileMap;
    private HashMap<String, FileType> uploadedFileMap;
    private HashMap<String, String> vmUuidMap;

    public Vapp(VcloudClient client, VAppType vAppType) {
        super(client, (AbstractVAppType)vAppType);
        this.sortVAppFiles();
        this.sortOvfSectionsAndReferences();
    }

    public static Vapp getVappByReference(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vappRef.getHref());
        VAppType vAppType = (VAppType)Vapp.getResourceByReference(client, vappRef);
        Vapp vapp = new Vapp(client, vAppType);
        return vapp;
    }

    public static Vapp getVappById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        VAppType vAppType = (VAppType)Vapp.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.vApp+xml");
        Vapp vapp = new Vapp(client, vAppType);
        return vapp;
    }

    public Task updateVapp(VAppType vAppType) throws VCloudException {
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String vAppUpdateUrl = this.getReference().getHref();
        String vAppRequestXmlString = JAXBUtil.marshal(of.createVApp(vAppType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vAppUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), vAppUpdateUrl, vAppRequestXmlString, "application/vnd.vmware.vcloud.vApp+xml", 202));
    }

    public VappStatus getVappStatus() {
        return VappStatus.fromValue(((VAppType)this.getResource()).getStatus());
    }

    public List<Vapp> getChildrenVapps() throws VCloudException {
        if (this.childrenvApps == null) {
            this.childrenvApps = new ArrayList<Vapp>();
            if (((VAppType)this.getResource()).getChildren() != null) {
                VAppChildrenType vAppChildrenType = ((VAppType)this.getResource()).getChildren();
                List vAppTypeList = vAppChildrenType.getVApp();
                for (VAppType vAppType : vAppTypeList) {
                    this.childrenvApps.add(new Vapp(this.getVcloudClient(), vAppType));
                }
            }
        }
        return this.childrenvApps;
    }

    public List<VM> getChildrenVms() throws VCloudException {
        if (this.childrenVms == null) {
            this.childrenVms = new ArrayList<VM>();
            if (((VAppType)this.getResource()).getChildren() != null) {
                VAppChildrenType childrenType = ((VAppType)this.getResource()).getChildren();
                List vmTypeList = childrenType.getVm();
                for (VmType vmType : vmTypeList) {
                    this.childrenVms.add(new VM(this.getVcloudClient(), vmType));
                }
            }
        }
        return this.childrenVms;
    }

    public LeaseSettingsSectionType getLeaseSettingsSection() throws VCloudException {
        if (this.leaseSettingsSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.leaseSettingsSection;
    }

    public static LeaseSettingsSectionType getLeaseSettingsSection(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        return (LeaseSettingsSectionType)SdkUtil.get(client, vappRef.getHref() + "/leaseSettingsSection/", 200);
    }

    public StartupSectionType getStartUpSection() throws VCloudException {
        if (this.startupSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.startupSection;
    }

    public static StartupSectionType getStartUpSection(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        return (StartupSectionType)SdkUtil.get(client, vappRef.getHref() + "/startupSection/", 200);
    }

    public NetworkSectionType getNetworkSection() throws VCloudException {
        if (this.networkSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.networkSection;
    }

    public static NetworkSectionType getNetworkSection(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        return (NetworkSectionType)SdkUtil.get(client, vappRef.getHref() + "/networkSection/", 200);
    }

    public HashMap<String, NetworkSectionNetwork> getNetworksByName() throws VCloudException {
        HashMap<String, NetworkSectionNetwork> networks = new HashMap<String, NetworkSectionNetwork>();
        if (this.networkSection != null) {
            for (NetworkSectionNetwork network : this.networkSection.getNetwork()) {
                networks.put(network.getName(), network);
            }
        }
        return networks;
    }

    public NetworkSectionNetwork getNetworkByName(String networkName) throws VCloudException {
        return this.getNetworksByName().get(networkName);
    }

    public Set<String> getNetworkNames() throws VCloudException {
        return this.getNetworksByName().keySet();
    }

    public Collection<NetworkSectionNetwork> getNetworks() throws VCloudException {
        return this.getNetworksByName().values();
    }

    public NetworkConfigSectionType getNetworkConfigSection() throws VCloudException {
        if (this.networkConfigSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.networkConfigSection;
    }

    public static NetworkConfigSectionType getNetworkConfigSection(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        return (NetworkConfigSectionType)SdkUtil.get(client, vappRef.getHref() + "/networkConfigSection/", 200);
    }

    public HashMap<String, ReferenceType> getVappNetworkRefsByName() {
        return this.vappNetworkRefsByName;
    }

    public HashMap<String, VAppNetworkConfigurationType> getVappNetworkConfigurationsByName() throws VCloudException {
        if (this.networkConfigSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        HashMap<String, VAppNetworkConfigurationType> networks = new HashMap<String, VAppNetworkConfigurationType>();
        List netConnections = this.networkConfigSection.getNetworkConfig();
        for (VAppNetworkConfigurationType conn : netConnections) {
            networks.put(conn.getNetworkName(), conn);
        }
        return networks;
    }

    public VAppNetworkConfigurationType getVappNetworkConfigurationByName(String vappNetworkConfigurationName) throws VCloudException {
        return this.getVappNetworkConfigurationsByName().get(vappNetworkConfigurationName);
    }

    public Set<String> getVappNetworkConfigurationNames() throws VCloudException {
        return this.getVappNetworkConfigurationsByName().keySet();
    }

    public Collection<VAppNetworkConfigurationType> getVappNetworkConfigurations() throws VCloudException {
        return this.getVappNetworkConfigurationsByName().values();
    }

    public Task updateSection(SectionType sectionType) throws VCloudException {
        ObjectFactory ovfObjectFactory = new ObjectFactory();
        com.vmware.vcloud.api.rest.schema.ObjectFactory vCloudObjectFactory_v1_5 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String sectionUrl = this.getReference().getHref();
        String sectionContentType = null;
        String sectionRequestString = null;
        if (sectionType instanceof LeaseSettingsSectionType) {
            JAXBElement section = vCloudObjectFactory_v1_5.createLeaseSettingsSection((LeaseSettingsSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/leaseSettingsSection/";
            sectionContentType = "application/vnd.vmware.vcloud.leaseSettingsSection+xml";
        } else if (sectionType instanceof StartupSectionType) {
            JAXBElement section = ovfObjectFactory.createStartupSection((StartupSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/startupSection/";
            sectionContentType = "application/vnd.vmware.vcloud.startupSection+xml";
        } else if (sectionType instanceof NetworkConfigSectionType) {
            JAXBElement section = vCloudObjectFactory_v1_5.createNetworkConfigSection((NetworkConfigSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/networkConfigSection/";
            sectionContentType = "application/vnd.vmware.vcloud.networkConfigSection+xml";
        } else {
            logger.info(sectionType.getClass().getName() + " - " + SdkUtil.getI18nString(SdkMessage.NOT_VALID_SECTION_MSG));
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_VALID_SECTION_MSG));
        }
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), sectionUrl, sectionRequestString, sectionContentType, 202));
    }

    public ControlAccessParamsType getControlAccess() throws VCloudException {
        String url = this.getReference().getHref() + "/controlAccess/";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return (ControlAccessParamsType)SdkUtil.get(this.getVcloudClient(), url, 200);
    }

    public ControlAccessParamsType updateControlAccess(ControlAccessParamsType controlAccessParams) throws VCloudException {
        String url = this.getReference().getHref() + "/action/controlAccess";
        com.vmware.vcloud.api.rest.schema.ObjectFactory vcloudObjectFactory = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestString = JAXBUtil.marshal(vcloudObjectFactory.createControlAccessParams(controlAccessParams));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (ControlAccessParamsType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.vcloud.controlAccess+xml", 200);
    }

    public BigInteger getVappSize() throws VCloudException {
        BigInteger size = BigInteger.ZERO;
        for (VM childVm : this.getChildrenVms()) {
            size = size.add(childVm.getVmSize());
        }
        return size;
    }

    private void sortOvfSectionsAndReferences() {
        this.vappNetworkRefsByName = new HashMap();
        List sections = ((VAppType)this.getResource()).getSection();
        for (JAXBElement sec : sections) {
            if (sec.getValue() instanceof NetworkConfigSectionType) {
                this.networkConfigSection = (NetworkConfigSectionType)sec.getValue();
            } else if (sec.getValue() instanceof NetworkSectionType) {
                this.networkSection = (NetworkSectionType)sec.getValue();
            } else if (sec.getValue() instanceof LeaseSettingsSectionType) {
                this.leaseSettingsSection = (LeaseSettingsSectionType)sec.getValue();
            } else if (sec.getValue() instanceof StartupSectionType) {
                this.startupSection = (StartupSectionType)sec.getValue();
            }
            logger.info(((SectionType)sec.getValue()).getClass().getName());
        }
        for (LinkType vAppLink : ((VAppType)this.getResource()).getLink()) {
            if (vAppLink.getRel() == null || vAppLink.getType() == null) continue;
            if (vAppLink.getRel().equals("up") && vAppLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) {
                this.vdcReference = vAppLink;
                continue;
            }
            if (!vAppLink.getRel().equals("down") || !vAppLink.getType().equals("application/vnd.vmware.vcloud.vAppNetwork+xml")) continue;
            this.vappNetworkRefsByName.put(vAppLink.getName(), (ReferenceType)vAppLink);
        }
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public VimObjectRefType getNetworkVimRef(String vAppNetworkName) throws VCloudException {
        VAppNetworkConfigurationType vappNetworkConfig = this.getVappNetworkConfigurationByName(vAppNetworkName);
        if (vappNetworkConfig != null) {
            for (VCloudExtensionType vappExtension : vappNetworkConfig.getVCloudExtension()) {
                for (Object jaxb : vappExtension.getAny()) {
                    if (!(((JAXBElement)jaxb).getValue() instanceof VimObjectRefType)) continue;
                    return (VimObjectRefType)((JAXBElement)jaxb).getValue();
                }
            }
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public Task recomposeVapp(RecomposeVAppParamsType recomposeVappParamsType) throws VCloudException {
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        JAXBElement composeVappParams = of.createRecomposeVAppParams(recomposeVappParamsType);
        String requestBodyXml = JAXBUtil.marshal(composeVappParams);
        String postURL = this.getReference().getHref() + "/action/recomposeVApp";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.recomposeVAppParams+xml", 202));
    }

    public ReferenceType getOwner() throws VCloudException {
        return ((VAppType)this.getResource()).getOwner().getUser();
    }

    public static ReferenceType getOwner(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        String url = vappRef.getHref() + "/owner";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return ((OwnerType)SdkUtil.get(client, url, 200)).getUser();
    }

    public static void changeOwner(VcloudClient client, ReferenceType vappRef, ReferenceType userReference) throws VCloudException {
        String url = vappRef.getHref() + "/owner";
        Vapp.changeOwner(url, userReference, client);
    }

    public void changeOwner(ReferenceType userReference) throws VCloudException {
        String url = this.getReference().getHref() + "/owner";
        Vapp.changeOwner(url, userReference, this.getVcloudClient());
    }

    private static void changeOwner(String url, ReferenceType userReference, VcloudClient client) throws VCloudException {
        String requestXML = null;
        com.vmware.vcloud.api.rest.schema.ObjectFactory objectFactory = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        OwnerType ownerType = new OwnerType();
        ownerType.setUser(userReference);
        JAXBElement changeOwnerParams = objectFactory.createOwner(ownerType);
        requestXML = JAXBUtil.marshal(changeOwnerParams);
        SdkUtil.put(client, url, requestXML, "application/vnd.vmware.vcloud.owner+xml", 204);
    }

    public Task resetvAppNetwork(String vAppNetworkName) throws VCloudException {
        VAppNetworkConfigurationType vappNetworkConfig = this.getVappNetworkConfigurationByName(vAppNetworkName);
        for (LinkType vappNetworkConfigLink : vappNetworkConfig.getLink()) {
            if (!vappNetworkConfigLink.getRel().equals("repair")) continue;
            return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), vappNetworkConfigLink.getHref(), null, null, 202);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.RESOURCE_NOT_FOUND_MSG));
    }

    public Task syncSyslogServer(String vAppNetworkName) throws VCloudException {
        VAppNetworkConfigurationType vappNetworkConfig = this.getVappNetworkConfigurationByName(vAppNetworkName);
        for (LinkType vappNetworkConfigLink : vappNetworkConfig.getLink()) {
            if (!vappNetworkConfigLink.getRel().equals("syncSyslogSettings")) continue;
            return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), vappNetworkConfigLink.getHref(), null, null, 202);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.RESOURCE_NOT_FOUND_MSG));
    }

    public void enableMaintenance() throws VCloudException {
        String url = this.getReference().getHref() + "/action/enterMaintenanceMode";
        SdkUtil.post(this.getVcloudClient(), url, null, null, 204);
    }

    public void disableMaintenance() throws VCloudException {
        String url = this.getReference().getHref() + "/action/exitMaintenanceMode";
        SdkUtil.post(this.getVcloudClient(), url, null, null, 204);
    }

    public static void enableMaintenance(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        String url = vappRef.getHref() + "/action/enterMaintenanceMode";
        SdkUtil.post(client, url, null, null, 204);
    }

    public static void disableMaintenance(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        String url = vappRef.getHref() + "/action/exitMaintenanceMode";
        SdkUtil.post(client, url, null, null, 204);
    }

    public static EnvelopeType getOvf(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        return Vapp.getOvf(client, vappRef.getHref() + "/ovf");
    }

    public EnvelopeType getOvf() throws VCloudException {
        return Vapp.getOvf(this.getVcloudClient(), this.getReference().getHref() + "/ovf");
    }

    private static EnvelopeType getOvf(VcloudClient client, String vAppOvfUrl) throws VCloudException {
        return (EnvelopeType)SdkUtil.get(client, vAppOvfUrl, 200);
    }

    public Task enableDownload() throws VCloudException {
        String url = this.getReference().getHref() + "/action/enableDownload";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task enableDownload(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        String url = vappRef.getHref() + "/action/enableDownload";
        return new Task(client, (TaskType)SdkUtil.post(client, url, null, null, 202));
    }

    public void disableDownload() throws VCloudException {
        String url = this.getReference().getHref() + "/action/disableDownload";
        SdkUtil.post(this.getVcloudClient(), url, null, null, 204);
    }

    public static void disableDownload(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        String url = vappRef.getHref() + "/action/disableDownload";
        SdkUtil.post(client, url, null, null, 204);
    }

    public InputStream downloadOVFFile() throws VCloudException {
        for (LinkType link : ((VAppType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:default")) continue;
            return RestUtil.downloadFile(this.getVcloudClient(), link.getHref());
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    public InputStream downloadLosslessOVF() throws VCloudException {
        for (LinkType link : ((VAppType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:identity")) continue;
            return RestUtil.downloadFile(this.getVcloudClient(), link.getHref());
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    public HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType> getDownloadFileNames() throws VCloudException {
        HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType> downloadFileMap = new HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType>();
        ReferencesType fileReferences = this.downloadOvfEnvelope().getReferences();
        if (fileReferences != null) {
            List files = fileReferences.getFile();
            for (com.vmware.vcloud.api.rest.schema.ovf.FileType file : files) {
                if (downloadFileMap.containsKey(file.getHref())) continue;
                downloadFileMap.put(file.getHref(), file);
            }
        }
        return downloadFileMap;
    }

    public InputStream downloadFile(String fileName) throws VCloudException {
        for (LinkType link : ((VAppType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:default")) continue;
            return this.downloadFile(fileName, link.getHref());
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    private InputStream downloadFile(String fileName, String href) throws VCloudException {
        HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType> downloadFiles = this.getDownloadFileNames();
        if (!downloadFiles.containsKey(fileName)) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.FILE_NOT_FOUND_MSG));
        }
        return RestUtil.downloadFile(this.getVcloudClient(), href.replaceAll("descriptor.ovf", fileName));
    }

    private EnvelopeType downloadOvfEnvelope() throws VCloudException {
        for (LinkType link : ((VAppType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:default")) continue;
            return (EnvelopeType)JAXBUtil.unmarshallResource(RestUtil.downloadFile(this.getVcloudClient(), link.getHref()));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    public void downloadVapp(String downloadLocation) throws VCloudException {
        Set<String> downloadFileNames = this.getDownloadFileNames().keySet();
        InputStream ovfInputStream = this.downloadOVFFile();
        this.writeToFile(downloadLocation, "descriptor.ovf", ovfInputStream);
        for (String fileName : downloadFileNames) {
            InputStream vmdkInputStream = this.downloadFile(fileName);
            this.writeToFile(downloadLocation, fileName, vmdkInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String downloadLocation, String fileName, InputStream inputStream) throws VCloudException {
        File file = new File(downloadLocation + "/" + fileName);
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
                inputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
    }

    public void uploadOVFFile(InputStream is, long size) throws VCloudException {
        if (((VAppType)this.getResource()).isOvfDescriptorUploaded().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OVF_DESCRIPTOR_ALREADY_UPLOADED_MSG));
        }
        if (this.uploadFileMap.size() != 1) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.INVALID_NO_FILES_MSG) + " - " + this.uploadFileMap.size());
        }
        Set<String> keys = this.uploadFileMap.keySet();
        String fileName = keys.iterator().next();
        FileType file = this.uploadFileMap.get(fileName);
        RestUtil.uploadFile(this.getVcloudClient(), file, is, size, 0L, 0L);
    }

    public Set<String> getUploadFileNames() throws VCloudException {
        if (!((VAppType)this.getResource()).isOvfDescriptorUploaded().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OVF_DESCRIPTOR_NOT_UPLOADED_NO_FILES_MSG));
        }
        return this.uploadFileMap.keySet();
    }

    public Set<String> getUploadedFileNames() throws VCloudException {
        return this.uploadedFileMap.keySet();
    }

    public void uploadFile(String fileName, InputStream is, long size) throws VCloudException {
        if (!((VAppType)this.getResource()).isOvfDescriptorUploaded().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OVF_DESCRIPTOR_NOT_UPLOADED_MSG));
        }
        if (this.uploadFileMap.isEmpty()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_FILES_TO_UPLOAD_MSG));
        }
        FileType file = this.uploadFileMap.get(fileName);
        if (file == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.FILE_NOT_FOUND_MSG));
        }
        RestUtil.uploadFile(this.getVcloudClient(), file, is, size, 0L, 0L);
    }

    private void sortVAppFiles() {
        this.uploadFileMap = new HashMap();
        this.uploadedFileMap = new HashMap();
        if (this.getResource() instanceof VAppType) {
            FilesListType fileList = ((VAppType)this.getResource()).getFiles();
            if (fileList == null) {
                return;
            }
            List files = fileList.getFile();
            for (FileType file : files) {
                String fileName = file.getName();
                if (file.getSize().compareTo(file.getBytesTransferred()) == 0) {
                    this.uploadedFileMap.put(fileName, file);
                    continue;
                }
                this.uploadFileMap.put(fileName, file);
            }
        }
    }

    public String getOvfAsString() throws VCloudException {
        return JAXBUtil.marshal(new ObjectFactory().createEnvelope(this.getOvf()));
    }

    public HashMap<String, String> getVmUUIDsByName() throws VCloudException {
        if (this.vmUuidMap == null) {
            EnvelopeType ovf = this.getOvf();
            this.vmUuidMap = new HashMap();
            if (ovf.getContent() != null && ovf.getContent().getValue() instanceof VirtualSystemCollectionType) {
                VirtualSystemCollectionType virtualSystemCollection = (VirtualSystemCollectionType)ovf.getContent().getValue();
                for (JAXBElement virtualSystems : virtualSystemCollection.getContent()) {
                    VirtualSystemType virtualSystem = (VirtualSystemType)virtualSystems.getValue();
                    String vmName = virtualSystem.getName().getValue();
                    for (JAXBElement sections : virtualSystem.getSection()) {
                        if (!(sections.getValue() instanceof VirtualHardwareSectionType)) continue;
                        VirtualHardwareSectionType virtualHardwareSection = (VirtualHardwareSectionType)sections.getValue();
                        for (Object configs : virtualHardwareSection.getAny()) {
                            JAXBElement vmConfig = (JAXBElement)configs;
                            if (!((ConfigType)vmConfig.getValue()).getKey().equalsIgnoreCase("uuid")) continue;
                            this.vmUuidMap.put(vmName, ((ConfigType)vmConfig.getValue()).getValue());
                        }
                    }
                }
            }
        }
        return this.vmUuidMap;
    }
}

