/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ServiceType;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
extends VcloudEntity<ServiceType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    public Service(VcloudClient client, ServiceType serviceResource) {
        super(client, serviceResource);
    }

    public static Service getServiceByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new Service(client, (ServiceType)Service.getResourceByReference(client, reference));
    }

    public static Service getServiceById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Service(client, (ServiceType)Service.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.service+xml"));
    }

    public ReferenceResult getApiDefinitionRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/apidefinitions" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }
}

