/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ContainerType;
import com.vmware.vcloud.api.rest.schema.QueryResultRecordType;
import com.vmware.vcloud.api.rest.schema.QueryResultRecordsType;
import com.vmware.vcloud.api.rest.schema.ReferencesType;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.Result;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class RecordResult<T extends QueryResultRecordType>
extends Result<QueryResultRecordsType> {
    private List<T> records;

    RecordResult(VcloudClient client, QueryResultRecordsType recordsType) {
        super(client, (ContainerType)recordsType);
        this.sortRecords_v1_5();
    }

    private void sortRecords_v1_5() {
        QueryResultRecordsType recordsType = this.getResource();
        if (this.records == null) {
            this.records = new ArrayList<T>();
        }
        for (JAXBElement recordType : recordsType.getRecord()) {
            this.records.add((QueryResultRecordType)recordType.getValue());
        }
    }

    @Override
    public QueryResultRecordsType getResource() {
        return (QueryResultRecordsType)super.getResource();
    }

    public List<T> getRecords() {
        if (this.records == null) {
            this.records = new ArrayList<T>();
        }
        return this.records;
    }

    public RecordResult<T> getFirstPage() throws VCloudException {
        if (this.hasFirstPage().booleanValue()) {
            return new RecordResult<T>(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getFirstPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public RecordResult<T> getPreviousPage() throws VCloudException {
        if (this.hasPreviousPage().booleanValue()) {
            return new RecordResult<T>(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getPreviousPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public RecordResult<T> getNextPage() throws VCloudException {
        if (this.hasNextPage().booleanValue()) {
            return new RecordResult<T>(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getNextPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public RecordResult<T> getLastPage() throws VCloudException {
        if (this.hasLastPage().booleanValue()) {
            return new RecordResult<T>(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getLastPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceResult getReferenceResult() throws VCloudException {
        if (this.hasAlternateReferencesRefResult().booleanValue()) {
            return new ReferenceResult(this.getVcloudClient(), (ReferencesType)SdkUtil.get(this.getVcloudClient(), this.getAlternateReferencesRef().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public RecordResult getRecordResult() throws VCloudException {
        if (this.hasAlternateRecordsRefResult().booleanValue()) {
            return new RecordResult<T>(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getAlternateRecordRef().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public RecordResult getIdRecordResult() throws VCloudException {
        if (this.hasAlternateIdRecordsRefResult().booleanValue()) {
            return new RecordResult<T>(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getAlternateIdRecordRef().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

