/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.CatalogItemType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogItem
extends VcloudEntity<CatalogItemType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType catalogReference;

    public CatalogItem(VcloudClient client, CatalogItemType catalogItemType_v1_5) {
        super(client, catalogItemType_v1_5);
        this.sortReferences_v1_5();
    }

    public ReferenceType getCatalogReference() throws VCloudException {
        if (this.catalogReference != null) {
            return this.catalogReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getEntityReference() throws VCloudException {
        if (((CatalogItemType)this.getResource()).getEntity() != null) {
            return ((CatalogItemType)this.getResource()).getEntity();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortReferences_v1_5() {
        for (LinkType catalogItemLink : ((CatalogItemType)this.getResource()).getLink()) {
            if (!catalogItemLink.getRel().equals("up") || !catalogItemLink.getType().equals("application/vnd.vmware.vcloud.catalog+xml")) continue;
            this.catalogReference = catalogItemLink;
        }
    }

    public static CatalogItem getCatalogItemByReference(VcloudClient client, ReferenceType catalogItemRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + catalogItemRef.getHref());
        return new CatalogItem(client, (CatalogItemType)CatalogItem.getResourceByReference(client, catalogItemRef));
    }

    public static CatalogItem getCatalogItemById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new CatalogItem(client, (CatalogItemType)CatalogItem.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.catalogItem+xml"));
    }

    public CatalogItem updateCatalogItem(CatalogItemType catalogItemType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String catalogItemUpdateUrl = ((CatalogItemType)this.getResource()).getHref();
        String catalogItemRequestXmlString = JAXBUtil.marshal(of.createCatalogItem(catalogItemType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + catalogItemUpdateUrl);
        return new CatalogItem(this.getVcloudClient(), (CatalogItemType)SdkUtil.put(this.getVcloudClient(), catalogItemUpdateUrl, catalogItemRequestXmlString, "application/vnd.vmware.vcloud.catalogItem+xml", 200));
    }

    public void delete() throws VCloudException {
        String catalogItemUrl = this.getReference().getHref();
        CatalogItem.deleteCatalogItem(this.getVcloudClient(), catalogItemUrl);
    }

    public static void delete(VcloudClient client, ReferenceType catalogItemRef) throws VCloudException {
        CatalogItem.deleteCatalogItem(client, catalogItemRef.getHref());
    }

    private static void deleteCatalogItem(VcloudClient client, String catalogItemrl) throws VCloudException {
        SdkUtil.delete(client, catalogItemrl, 204);
    }

    public Task sync() throws VCloudException {
        String postURL = this.getReference().getHref() + "/action/sync";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), postURL, null, null, 202));
    }
}

