/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.CaptureVAppParamsType;
import com.vmware.vcloud.api.rest.schema.CatalogItemType;
import com.vmware.vcloud.api.rest.schema.CatalogItemsType;
import com.vmware.vcloud.api.rest.schema.CatalogType;
import com.vmware.vcloud.api.rest.schema.CopyOrMoveCatalogItemParamsType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.UploadVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.VAppTemplateType;
import com.vmware.vcloud.sdk.CatalogItem;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VappTemplate;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VappTemplateStatus;
import com.vmware.vcloud.sdk.exception.DuplicateNameException;
import com.vmware.vcloud.sdk.exception.ResourceNotAddedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Catalog
extends VcloudEntity<CatalogType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType orgReference;
    private HashMap<String, ReferenceType> catalogItemRefsByName;

    protected Catalog(VcloudClient client, CatalogType catalogType_v1_5) {
        super(client, catalogType_v1_5);
        this.sortItemRefs_v1_5();
    }

    public static Catalog getCatalogByReference(VcloudClient client, ReferenceType catalogRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + catalogRef.getHref());
        return new Catalog(client, (CatalogType)Catalog.getResourceByReference(client, catalogRef));
    }

    public static Catalog getCatalogById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Catalog(client, (CatalogType)Catalog.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.catalog+xml"));
    }

    private void sortItemRefs_v1_5() {
        this.catalogItemRefsByName = new HashMap();
        if (((CatalogType)this.getResource()).getCatalogItems() != null) {
            CatalogItemsType catalogItems = ((CatalogType)this.getResource()).getCatalogItems();
            List items = catalogItems.getCatalogItem();
            for (ReferenceType ref : items) {
                this.catalogItemRefsByName.put(ref.getName(), ref);
            }
        }
        for (LinkType catalogLink : ((CatalogType)this.getResource()).getLink()) {
            if (!catalogLink.getRel().equals("up") || !catalogLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) continue;
            this.orgReference = catalogLink;
        }
    }

    public CatalogItem addCatalogItem(CatalogItemType catalogItemType) throws VCloudException {
        ObjectFactory factory_v1_5 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(factory_v1_5.createCatalogItem(catalogItemType));
        String postURL = this.getReference().getHref() + "/catalogItems";
        return new CatalogItem(this.getVcloudClient(), (CatalogItemType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.catalogItem+xml", 201));
    }

    public HashMap<String, ReferenceType> getCatalogItemRefsByName() {
        return this.catalogItemRefsByName;
    }

    public ReferenceType getCatalogItemRefByName(String name) {
        return this.catalogItemRefsByName.get(name);
    }

    public Collection<ReferenceType> getCatalogItemReferences() {
        return this.catalogItemRefsByName.values();
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgReference != null) {
            return this.orgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VappTemplate uploadVappTemplate(String vAppTemplateName, String vAppTemplateDesc, String localOvfFileLocation, Boolean manifestRequired, ReferenceType vdcStorageRef) throws VCloudException, DuplicateNameException, ResourceNotAddedException, TimeoutException {
        UploadVAppTemplateParamsType vappTemplParams = new UploadVAppTemplateParamsType();
        vappTemplParams.setDescription(vAppTemplateDesc);
        vappTemplParams.setName(vAppTemplateName);
        vappTemplParams.setManifestRequired(manifestRequired);
        vappTemplParams.setVdcStorageProfile(vdcStorageRef);
        VappTemplate vappTemplate = this.createVappTemplate(vappTemplParams);
        File ovfFile = new File(localOvfFileLocation);
        String ovfFileName = ovfFile.getName();
        try {
            FileInputStream ovfFileInputStream = new FileInputStream(ovfFile);
            try {
                vappTemplate.uploadOVFFile(ovfFileInputStream, ovfFile.length());
                vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
                while (!((VAppTemplateType)vappTemplate.getResource()).isOvfDescriptorUploaded().booleanValue()) {
                    vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
                }
            }
            finally {
                ovfFileInputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
        Set<String> vmdkFileNames = vappTemplate.getUploadFileNames();
        for (String vmdkFileName : vmdkFileNames) {
            String vmdkFileLocation = localOvfFileLocation.replace(ovfFileName, vmdkFileName);
            File vmdkFile = new File(vmdkFileLocation);
            try {
                FileInputStream vmdkFileInputStream = new FileInputStream(vmdkFile);
                try {
                    vappTemplate.uploadFile(vmdkFileName, vmdkFileInputStream, vmdkFile.length());
                }
                finally {
                    vmdkFileInputStream.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new VCloudRuntimeException(e);
            }
            catch (IOException e) {
                throw new VCloudRuntimeException(e);
            }
        }
        vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        while (((VAppTemplateType)vappTemplate.getResource()).getStatus().intValue() == VappTemplateStatus.UNRESOLVED.value()) {
            vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        }
        vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), vappTemplate.getReference());
        return vappTemplate;
    }

    public VappTemplate createVappTemplate(UploadVAppTemplateParamsType vappTemplateParams) throws VCloudException {
        String url = this.getReference().getHref() + "/action/upload";
        JAXBElement params = new ObjectFactory().createUploadVAppTemplateParams(vappTemplateParams);
        String reqPayload = JAXBUtil.marshal(params);
        return this.executeVappTemplateUpload(this.getVcloudClient(), url, reqPayload, "application/vnd.vmware.vcloud.uploadVAppTemplateParams+xml");
    }

    private VappTemplate executeVappTemplateUpload(VcloudClient client, String vdcActionUrl, String reqPayload, String contentType) throws VCloudException {
        CatalogItem catalogItem = new CatalogItem(client, (CatalogItemType)SdkUtil.post(client, vdcActionUrl, reqPayload, contentType, 201));
        ReferenceType vappTemplateRef = ((CatalogItemType)catalogItem.getResource()).getEntity();
        return VappTemplate.getVappTemplateByReference(client, vappTemplateRef);
    }

    public Task capturevApp(CaptureVAppParamsType captureVApp) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement jaxbElement = of.createCaptureVAppParams(captureVApp);
        String requestBodyXml = JAXBUtil.marshal(jaxbElement);
        String postURL = this.getReference().getHref() + "/action/captureVApp";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.captureVAppParams+xml", 202));
    }

    public Task sync() throws VCloudException {
        String postURL = this.getReference().getHref() + "/action/sync";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), postURL, null, null, 202));
    }

    public Task copyCatalogItem(String name, String description, ReferenceType sourceRef) throws VCloudException {
        CopyOrMoveCatalogItemParamsType copyCatalogItemParams = new CopyOrMoveCatalogItemParamsType();
        copyCatalogItemParams.setName(name);
        copyCatalogItemParams.setDescription(description);
        copyCatalogItemParams.setSource(sourceRef);
        String postUrl = ((CatalogType)this.getResource()).getHref() + "/action/copy";
        ObjectFactory of = new ObjectFactory();
        String requestXml = JAXBUtil.marshal(of.createCopyOrMoveCatalogItemParams(copyCatalogItemParams));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), postUrl, requestXml, "application/vnd.vmware.vcloud.copyOrMoveCatalogItemParams+xml", 202));
    }

    public Task moveCatalogItem(String name, String description, ReferenceType sourceRef) throws VCloudException {
        CopyOrMoveCatalogItemParamsType moveCatalogItemParams = new CopyOrMoveCatalogItemParamsType();
        moveCatalogItemParams.setName(name);
        moveCatalogItemParams.setDescription(description);
        moveCatalogItemParams.setSource(sourceRef);
        String postUrl = ((CatalogType)this.getResource()).getHref() + "/action/move";
        ObjectFactory of = new ObjectFactory();
        String requestXml = JAXBUtil.marshal(of.createCopyOrMoveCatalogItemParams(moveCatalogItemParams));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), postUrl, requestXml, "application/vnd.vmware.vcloud.copyOrMoveCatalogItemParams+xml", 202));
    }
}

