/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class UpgradingIndex {
    private Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private String dbType = null;
    private String db_driver = null;
    private String conn_string = null;
    private String db_user = null;
    private String db_password = null;
    private static boolean b_flag = true;
    private boolean isOracle = false;
    private boolean isMsSql = false;
    private boolean isDoubleByteEnabled = false;
    private String query = null;
    String installDir = EgInstallInfo.getInstallDir();
    private String SQLFilePath = new String();
    private String upgradeFilePath = new String();
    private ArrayList a_allTables = new ArrayList();
    private ArrayList a_allIndexNames = new ArrayList();
    private String fileSeparator = System.getProperty("file.separator");
    String Indexmssql = null;
    String IndexOrcle = null;
    String strntlmv2 = "false";
    private String dbVersionName = null;
    private String dbuser1 = "";
    String OperationType = "";

    private boolean dbTruncateChanges(String[] stringArray) {
        this.OperationType = stringArray[0];
        System.setProperty("jsse.enableCBCProtection", "false");
        String string = this.installDir + "/manager/config/eg_db.ini";
        IniFile iniFile = new IniFile(string);
        this.dbType = iniFile.getValue("DB_PROPERTIES", "DB_Server_Type");
        this.db_driver = iniFile.getValue("DB_PROPERTIES", "sql.driver");
        this.conn_string = iniFile.getValue("DB_PROPERTIES", "sql.url");
        this.db_user = iniFile.getValue("DB_PROPERTIES", "sql.user");
        this.db_password = EgCrypt.decrypt((String)iniFile.getValue("DB_PROPERTIES", "sql.password")).trim();
        this.strntlmv2 = iniFile.getValue("DB_PROPERTIES", "sql.ntlmv2");
        String string2 = iniFile.getValue("DB_PROPERTIES", "DoubleByteEnabled");
        if (string2 != null && !string2.equals("") && (string2.equalsIgnoreCase("TRUE") || string2.equalsIgnoreCase("YES"))) {
            this.isDoubleByteEnabled = true;
        }
        System.out.println("Attempting to get Database Connection...");
        boolean bl = this.setConnection();
        if (!bl) {
            System.out.println("Error in establishing the database connection");
            System.err.println("Error in establishing the database connection");
            return false;
        }
        System.out.println("Database Connection Obtained...");
        if (this.dbType.equalsIgnoreCase("EgOracleAdapter")) {
            this.isOracle = true;
            this.isMsSql = false;
        } else if (this.dbType.equalsIgnoreCase("EgMsSqlAdapter")) {
            this.isOracle = false;
            this.isMsSql = true;
        }
        this.a_allTables = this.getAllTables();
        this.a_allIndexNames = this.getAllIndex();
        System.out.println("a_allTables ______ " + this.a_allTables);
        System.out.println("a_allIndexNames ______ " + this.a_allIndexNames);
        b_flag = this.upgradeDB();
        System.out.println("Releasing the Established Database Connection....");
        this.releaseConnection();
        System.out.println("b_flag______________" + b_flag);
        if (!b_flag) {
            System.out.println("Upgrade Failed");
            System.err.println("Upgrade Failed");
            return false;
        }
        return true;
    }

    private boolean setConnection() {
        try {
            String string = "";
            Class.forName(this.db_driver);
            int n = this.db_user.indexOf("\\");
            if (n < 0) {
                n = this.db_user.indexOf("/");
                if (n < 0) {
                    this.conn = DriverManager.getConnection(this.conn_string, this.db_user, this.db_password);
                } else {
                    String string2 = this.db_user.substring(0, n);
                    this.db_user = this.db_user.substring(n + 1);
                    Properties properties = new Properties();
                    properties.put("user", this.db_user);
                    properties.put("password", this.db_password);
                    properties.put("domain", string2);
                    string = this.strntlmv2 != null && this.strntlmv2.trim().equalsIgnoreCase("True") ? "true" : "false";
                    properties.put("useNTLMv2", string);
                    this.conn = DriverManager.getConnection(this.conn_string, properties);
                }
            } else {
                String string3 = this.db_user.substring(0, n);
                this.db_user = this.db_user.substring(n + 1);
                Properties properties = new Properties();
                properties.put("user", this.db_user);
                properties.put("password", this.db_password);
                properties.put("domain", string3);
                string = this.strntlmv2 != null && this.strntlmv2.trim().equalsIgnoreCase("True") ? "true" : "false";
                properties.put("useNTLMv2", string);
                this.conn = DriverManager.getConnection(this.conn_string, properties);
            }
            this.stmt = this.conn.createStatement();
            return true;
        }
        catch (Exception exception) {
            b_flag = false;
            System.out.println("Problem In DB Connection : " + exception);
            System.err.println("Problem In DB Connection : " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    private void releaseConnection() {
        block5: {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exception) {
                if (this.stmt != null) {
                    this.stmt = null;
                }
                if (this.conn == null) break block5;
                this.conn = null;
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet == null) {
                return;
            }
            resultSet.close();
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement == null) {
                return;
            }
            statement.close();
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String databaseVersionName() {
        String string = null;
        try {
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery("select @@version");
            if (this.rs != null && this.rs.next()) {
                string = this.rs.getString(1);
            }
            System.out.println("dbVersionName__" + string);
        }
        catch (Exception exception) {
            System.out.println("Exception" + exception);
        }
        return string;
    }

    private ArrayList getAllIndex() {
        System.out.println("Collecting All Index Names in arraylist object...");
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isOracle) {
                this.query = "select index_name from user_indexes";
            } else if (this.isMsSql) {
                this.dbVersionName = this.databaseVersionName();
                this.query = this.dbVersionName != null && this.dbVersionName.startsWith("Microsoft SQL Azure") ? "SELECT i.name as index_name,o.name as object_name,col1 = MIN (CASE ik.index_column_id WHEN 1 THEN c.name END),col2 = MIN (CASE ik.index_column_id WHEN 2 THEN c.name END),col3 = MIN (CASE ik.index_column_id WHEN 3 THEN c.name END),col4 = MIN (CASE ik.index_column_id WHEN 4 THEN c.name END),col5 = MIN (CASE ik.index_column_id WHEN 5 THEN c.name END) FROM sys.objects o JOIN sys.indexes i ON i.object_id = o.object_id JOIN sys.index_columns ik ON ik.object_id = i.object_id AND ik.index_id = i.index_id JOIN sys.columns c ON c.object_id = ik.object_id AND c.column_id = ik.column_id WHERE i.index_id BETWEEN 1 AND 254 AND indexproperty(o.object_id, i.name, 'IsStatistics') = 0 AND indexproperty(o.object_id, i.name, 'IsHypothetical') = 0 GROUP BY o.name, i.name ORDER BY o.name, i.name" : "select i.name index_name,object_name(t.object_id) ,t.type from sys.indexes i, sys.tables t where i.object_id=t.object_id";
            }
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery(this.query);
            while (this.rs.next()) {
                if (this.rs.getString(1) == null) continue;
                arrayList.add(this.rs.getString(1).toUpperCase().trim());
            }
            this.closeRs(this.rs);
            this.closeSt(this.stmt);
            this.rs = null;
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println("Error in getAllTables Method ");
            exception.printStackTrace();
            this.closeSt(this.stmt);
            System.err.println("Error" + exception);
            return null;
        }
    }

    public ArrayList readFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!string2.equals("") && string2.length() > 0) {
                    arrayList.add(string2);
                }
                string2 = bufferedReader.readLine();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ArrayList();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgradeDB() {
        block27: {
            try {
                String string;
                int n;
                ArrayList arrayList = new ArrayList();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string2 = "";
                if (this.isMsSql) {
                    arrayList.addAll(this.readFile(this.installDir + "\\bin\\upgradeIndex_mssql.sql"));
                    string2 = this.installDir + "\\bin\\upgradeIndex_mssql.sql";
                } else if (this.isOracle) {
                    arrayList.addAll(this.readFile(this.installDir + "\\bin\\upgradeIndex_oracle.sql"));
                    string2 = this.installDir + "\\bin\\upgradeIndex_oracle.sql";
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    string = (String)arrayList.get(n);
                    String string3 = string.toUpperCase();
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    String string7 = "";
                    String string8 = "";
                    if (string3 != null && string3.indexOf("CREATE INDEX") > -1) {
                        string4 = string3.substring(string3.indexOf("INDEX") + 5, string3.length());
                        string5 = string4.substring(string4.indexOf(" ON") + 3, string4.indexOf("("));
                        string6 = string5.trim();
                        string7 = string4.substring(0, string4.indexOf(" ON"));
                        string8 = string7.trim();
                        if (this.a_allTables != null && this.a_allTables.contains(string6.toUpperCase())) {
                            System.out.println("str5__insideif__" + string6);
                            if (this.a_allIndexNames != null && !this.a_allIndexNames.contains(string8.toUpperCase())) {
                                try {
                                    System.out.println("create query ___________ " + string);
                                    arrayList2.add(string);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    System.out.println("Problem in executing the query and exception is : " + exception.getMessage());
                                }
                            }
                        }
                    }
                    if (string3 == null || string3.indexOf("DROP INDEX") <= -1) continue;
                    if (this.isOracle) {
                        string4 = string3.substring(string3.indexOf("INDEX") + 5, string3.length() - 1);
                        string8 = string4.trim();
                        string6 = "";
                    }
                    if (this.isMsSql) {
                        string4 = string3.substring(string3.indexOf("INDEX") + 5, string3.length());
                        System.out.println("str3_+drop query__" + string4);
                        string6 = string4.substring(0, string4.indexOf("."));
                        string6 = string6.trim();
                        string8 = string4.substring(string4.indexOf(".") + 1, string4.length() - 1);
                        string8 = string8.trim();
                    }
                    if (this.a_allIndexNames == null || !this.a_allIndexNames.contains(string8.toUpperCase())) continue;
                    try {
                        System.out.println(" drop query ___________ " + string);
                        arrayList2.add(string);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.out.println("Problem in executing the query and exception is : " + exception.getMessage());
                    }
                }
                if (arrayList2 == null || arrayList2.size() <= 0) break block27;
                if (this.OperationType != null && this.OperationType.equalsIgnoreCase("Execute")) {
                    System.out.println("Total Indexes = " + arrayList2);
                    try {
                        this.stmt = this.conn.createStatement();
                        for (n = 0; n < arrayList2.size(); ++n) {
                            string = "";
                            try {
                                string = (String)arrayList2.get(n);
                                if (string.lastIndexOf(";") > -1) {
                                    string = string.substring(0, string.lastIndexOf(";"));
                                }
                                System.out.println(new Date() + " Going to update the Indexes  " + string);
                                this.stmt.executeUpdate(string);
                                System.out.println(new Date() + " Sucessfully updated " + string);
                                continue;
                            }
                            catch (Exception exception) {
                                System.out.println("Unable to Execute the Query :" + string);
                            }
                        }
                        break block27;
                    }
                    catch (Exception exception) {
                        break block27;
                    }
                    finally {
                        this.closeSt(this.stmt);
                    }
                }
                try {
                    this.store(arrayList2, string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Problem in Updating the index and exception is : " + exception.getMessage());
            }
        }
        return true;
    }

    public boolean store(ArrayList arrayList, String string) {
        Object object;
        if (string != null && string.endsWith(".sql")) {
            object = string.substring(string.lastIndexOf("\\") + 1);
            if (object != null && ((String)object).endsWith(".sql")) {
                object = "IndexUpgrade.sql";
            }
            string = string.substring(0, string.lastIndexOf("\\"));
            string = string + "\\" + (String)object;
        }
        System.out.println("strFilePath_______" + string);
        object = new File(string);
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return false;
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean truncateTable(String string) {
        try {
            this.stmt = this.conn.createStatement();
            this.stmt.executeUpdate("TRUNCATE TABLE " + string);
            this.closeSt(this.stmt);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem in truncating the query and exception is : " + exception.getMessage());
            return false;
        }
    }

    private ArrayList getAllTables() {
        System.out.println("Collecting All Table Names in arraylist object...");
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isOracle) {
                this.query = "SELECT table_name FROM user_tables";
            } else if (this.isMsSql) {
                this.query = "SELECT TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_TYPE = 'BASE TABLE'";
            }
            this.stmt = this.conn.createStatement();
            ResultSet resultSet = this.stmt.executeQuery(this.query);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1).toUpperCase().trim());
            }
            this.closeRs(resultSet);
            this.closeSt(this.stmt);
            resultSet = null;
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println("Error in getAllTables Method ");
            exception.printStackTrace();
            this.closeSt(this.stmt);
            System.err.println("Error" + exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        UpgradingIndex upgradingIndex = new UpgradingIndex();
        upgradingIndex.dbTruncateChanges(stringArray);
    }
}

