/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart2;
import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.GridRenderer;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LegendRenderer;
import com.objectplanet.chart.Renderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class GenericChart
extends JComponent
implements Serializable {
    public static final int LABEL_ALIGNMENT_LEFT = -1;
    public static final int LABEL_ALIGNMENT_CENTER = 0;
    public static final int LABEL_ALIGNMENT_RIGHT = 1;
    private static final int PRINT_RESOLUTION = 600;
    private static final int DEFAULT_SCREEN_RESOLUTION = 96;
    protected ChartRenderer renderer;
    protected Legend legend;
    protected LegendRenderer legendRenderer;
    protected Grid grid;
    protected GridRenderer gridRenderer;
    protected Vector overlayCharts;
    private String chartTitle;
    private boolean chartTitleOn;
    private boolean floatingOnLegendOn;
    private String thousandsDelimiter;
    protected boolean display3dOn;
    protected Point depth3dPoint;
    int depth3d;
    private boolean gridOutline3DOn;
    private Color chartBackground;
    private Color chartBackground2;
    private Color background2;
    private Color alternateChartBackground;
    private Color chartForeground;
    String gridImage;
    private boolean automaticRepaintOn;
    private Dimension preferredSize;
    private boolean printAsBitmap;
    private boolean overlayChartOn;
    private boolean servletModeOn;
    boolean multiSeriesOn;
    protected boolean displayVersionOn;
    Hashtable images;
    private Hashtable labels;
    private Hashtable labelFonts;
    private Hashtable labelAngles;
    String[] labelIDs;
    Hashtable labelTexts;
    Hashtable labelXs;
    Hashtable labelYs;
    Hashtable labelURLs;
    Hashtable labelSeries;
    Hashtable labelSamples;
    Hashtable labelColors;
    double[] overlayInsets;
    protected Cursor old_cursor;
    protected Cursor new_cursor;
    protected boolean[] legendSelection;
    private boolean zoomOn;
    private boolean antialiasingOn;
    private String complexLabelSeparator;
    private int multilineLabelAlignment;
    protected String chartType;
    GenericChart parentChart;
    private NumberFormat numberFormatter;
    private Locale currentLocale;
    protected boolean needRender;
    protected boolean needGraphBounds;
    protected boolean needChartCalculation;
    Hashtable labelSizeCache;
    MediaTracker imageTracker;
    private Frame servletFrame;
    private long lastRenderTime;
    private int mousePressX;
    private int mousePressY;
    boolean shouldSelect;
    protected String dragged_label;
    private double dragged_start_x;
    private double dragged_start_y;
    private Chart2 c2;
    protected static Color[] DEFAULT_SAMPLE_COLORS = new Color[]{new Color(132, 130, 255), new Color(132, 32, 99), new Color(255, 255, 198), new Color(165, 227, 231), new Color(99, 0, 132), new Color(255, 130, 132), new Color(0, 130, 198), new Color(198, 195, 255), new Color(0, 0, 132), new Color(255, 0, 255), new Color(255, 255, 0), new Color(0, 255, 255), new Color(132, 0, 132), new Color(132, 0, 0), new Color(0, 130, 132), new Color(0, 0, 255), new Color(0, 207, 255), new Color(107, 255, 255), new Color(206, 255, 206), new Color(255, 255, 156)};
    private Class bufferedImageClass;
    private Constructor bufferedImageConstructor;
    private boolean bufferedImageClass_tried_loading;
    private int TYPE_INT_RGB;

    public GenericChart() {
        this.setAutomaticRepaintOn(false);
        this.grid = new Grid(this);
        this.legend = new Legend();
        this.legendRenderer = new LegendRenderer(this);
        this.labelIDs = new String[0];
        this.labelTexts = new Hashtable();
        this.labelXs = new Hashtable();
        this.labelYs = new Hashtable();
        this.labelURLs = new Hashtable();
        this.labelSeries = new Hashtable();
        this.labelSamples = new Hashtable();
        this.labelColors = new Hashtable();
        this.setCursor(this.new_cursor);
        this.labelSizeCache = new Hashtable();
        this.labels = new Hashtable();
        this.labelFonts = new Hashtable();
        this.labelAngles = new Hashtable();
        this.preferredSize = new Dimension(300, 200);
        this.numberFormatter = NumberFormat.getInstance();
        this.overlayCharts = new Vector();
        this.old_cursor = null;
        this.new_cursor = Renderer.DEFAULT_CURSOR;
        this.enableEvents(49L);
        try {
            this.c2 = new Chart2();
            this.c2.version = GenericChart.getVersion();
        }
        catch (Throwable e) {
            throw new IllegalAccessError("No valid license");
        }
        this.chartTitle = null;
        this.chartTitleOn = false;
        this.display3dOn = false;
        this.depth3dPoint = new Point();
        this.depth3d = -1;
        this.chartBackground = Color.white;
        this.chartForeground = Color.black;
        this.setForeground(Color.black);
        this.setBackground(new Color(231, 221, 231));
        this.labelFonts.clear();
        this.labels.clear();
        this.preferredSize.setSize(300, 200);
        this.setFont(new Font("Arial", 0, 11));
        this.setFont("titleFont", new Font("Arial", 1, 14));
        this.overlayChartOn = true;
        this.servletModeOn = false;
        this.floatingOnLegendOn = true;
        this.shouldSelect = true;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.antialiasingOn = true;
        this.labelIDs = new String[0];
        this.mousePressX = -1;
        this.mousePressY = -1;
        this.setSize(300, 200);
        this.images = new Hashtable();
        this.imageTracker = new MediaTracker(this);
        this.overlayInsets = new double[4];
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        this.chartTitle = null;
        this.chartTitleOn = false;
        this.display3dOn = false;
        this.chartBackground = Color.white;
        this.chartForeground = Color.black;
        this.setForeground(Color.black);
        this.setBackground(new Color(231, 221, 231));
        this.labelFonts.clear();
        this.labels.clear();
        this.labelAngles.clear();
        this.preferredSize.setSize(300, 200);
        this.setFont(new Font("Arial", 0, 11));
        this.setFont("titleFont", new Font("Arial", 1, 14));
        this.complexLabelSeparator = null;
        this.overlayInsets = new double[4];
        this.overlayChartOn = true;
        this.servletModeOn = false;
        this.floatingOnLegendOn = true;
        this.antialiasingOn = true;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.shouldSelect = true;
        this.labelIDs = new String[0];
        this.labelTexts.clear();
        this.labelXs.clear();
        this.labelYs.clear();
        this.labelSeries.clear();
        this.labelSamples.clear();
        this.labelURLs.clear();
        this.labelColors.clear();
        this.mousePressX = -1;
        this.mousePressY = -1;
        this.images = new Hashtable();
        this.imageTracker = new MediaTracker(this);
        this.displayVersionOn = false;
        this.currentLocale = this.getLocale();
        this.overlayCharts.removeAllElements();
        this.renderer.reset();
    }

    void setGrid(Grid grid) {
        this.grid = grid;
    }

    Grid getGrid() {
        return this.grid;
    }

    public ChartRenderer getRenderer() {
        return this.renderer;
    }

    GridRenderer getGridRenderer() {
        return this.gridRenderer;
    }

    public abstract int getSeriesCount();

    public abstract int getSampleCount();

    public abstract boolean isSeriesEmpty(int var1);

    protected abstract double getHighestValue(int var1);

    protected abstract double getLowestValue(int var1);

    public void setMultiSeriesOn(boolean on) {
        this.multiSeriesOn = on;
    }

    public boolean isMultiSeriesOn() {
        return this.multiSeriesOn;
    }

    public void setLegendLabels(String[] labels) {
        this.legend.setLegendLabels(labels);
        this.labelSizeCache.clear();
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String[] getLegendLabels() {
        return this.legend.getLegendLabels();
    }

    public void setLabel(String name, String label) {
        if (name != null && name.length() > 0) {
            name = name.toLowerCase().trim();
            if (label != null && label.length() > 0) {
                this.labels.put(name, label);
            } else {
                this.labels.remove(name);
            }
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            if (this.getLabelAngle(name + "Angle") != 0) {
                this.clearAngledLabelCache();
            }
            this.autoRepaint();
        }
    }

    public String getLabel(String name) {
        if (name != null) {
            name = name.toLowerCase().trim();
            return (String)this.labels.get(name);
        }
        return null;
    }

    public void setLabelAngle(String name, int angle) {
        if (name != null && name.length() > 0) {
            angle = (angle %= 360) < 0 ? angle + 360 : angle;
            name = name.toLowerCase().trim();
            this.labelAngles.put(name, new Integer(angle));
            this.clearAngledLabelCache();
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getLabelAngle(String name) {
        if (name != null && this.labelAngles.get(name = name.toLowerCase().trim()) != null) {
            return (Integer)this.labelAngles.get(name);
        }
        return 0;
    }

    public static void setLabelAngleCacheSize(int count) {
        Renderer.setLabelAngleCacheSize(count);
    }

    protected void clearAngledLabelCache() {
        Renderer.angledLabelCache.clear();
    }

    public void setThousandsDelimiter(String delimiter) {
        this.thousandsDelimiter = delimiter;
        if (this.thousandsDelimiter != null && this.thousandsDelimiter.length() > 1 && !this.thousandsDelimiter.trim().equalsIgnoreCase("off")) {
            this.thousandsDelimiter = this.thousandsDelimiter.substring(0, 1);
        } else if (this.thousandsDelimiter != null && !this.thousandsDelimiter.equals(" ")) {
            this.thousandsDelimiter = this.thousandsDelimiter.trim().toLowerCase();
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public String getThousandsDelimeter() {
        return this.thousandsDelimiter;
    }

    public void setLabel(String id, String text, int x, int y) {
        if (text == null) {
            String[] labelIDs_new = new String[Math.max(this.labelIDs.length - 1, 0)];
            for (int i = 0; i < this.labelIDs.length; ++i) {
                if (!id.equals(this.labelIDs[i])) continue;
                System.arraycopy(this.labelIDs, 0, labelIDs_new, 0, i);
                System.arraycopy(this.labelIDs, i + 1, labelIDs_new, i, this.labelIDs.length - i - 1);
                break;
            }
            this.labelIDs = labelIDs_new;
            this.labelTexts.remove(id);
            this.labelXs.remove(id);
            this.labelYs.remove(id);
        } else {
            if (!this.labelTexts.containsKey(id)) {
                String[] new_labelIDs = new String[this.labelIDs.length + 1];
                System.arraycopy(this.labelIDs, 0, new_labelIDs, 0, this.labelIDs.length);
                this.labelIDs = new_labelIDs;
                this.labelIDs[this.labelIDs.length - 1] = id;
            }
            this.labelTexts.put(id, text);
            this.labelXs.put(id, new Double(x));
            this.labelYs.put(id, new Double(y));
        }
        this.labelSamples.remove(id);
        this.labelSeries.remove(id);
        this.autoRepaint();
    }

    public void setLabel(String id, String text, double x, double y) {
        if (text == null) {
            String[] labelIDs_new = new String[Math.max(this.labelIDs.length - 1, 0)];
            for (int i = 0; i < this.labelIDs.length; ++i) {
                if (!id.equals(this.labelIDs[i])) continue;
                System.arraycopy(this.labelIDs, 0, labelIDs_new, 0, i);
                System.arraycopy(this.labelIDs, i + 1, labelIDs_new, i, this.labelIDs.length - i - 1);
                break;
            }
            this.labelIDs = labelIDs_new;
            this.labelTexts.remove(id);
            this.labelXs.remove(id);
            this.labelYs.remove(id);
        } else {
            if (!this.labelTexts.containsKey(id)) {
                String[] new_labelIDs = new String[this.labelIDs.length + 1];
                System.arraycopy(this.labelIDs, 0, new_labelIDs, 0, this.labelIDs.length);
                this.labelIDs = new_labelIDs;
                this.labelIDs[this.labelIDs.length - 1] = id;
            }
            this.labelTexts.put(id, text);
            this.labelXs.put(id, new Double(x));
            this.labelYs.put(id, new Double(y));
        }
        this.labelSamples.remove(id);
        this.labelSeries.remove(id);
        this.autoRepaint();
    }

    public void setLabel(String id, String text, int x, int y, int serie, int sample) {
        if (text == null) {
            String[] labelIDs_new = new String[Math.max(this.labelIDs.length - 1, 0)];
            for (int i = 0; i < this.labelIDs.length; ++i) {
                if (!id.equals(this.labelIDs[i])) continue;
                System.arraycopy(this.labelIDs, 0, labelIDs_new, 0, i);
                System.arraycopy(this.labelIDs, i + 1, labelIDs_new, i, this.labelIDs.length - i - 1);
                break;
            }
            this.labelIDs = labelIDs_new;
            this.labelTexts.remove(id);
            this.labelXs.remove(id);
            this.labelYs.remove(id);
            this.labelSamples.remove(id);
            this.labelSeries.remove(id);
        } else {
            if (!this.labelTexts.containsKey(id)) {
                String[] new_labelIDs = new String[this.labelIDs.length + 1];
                System.arraycopy(this.labelIDs, 0, new_labelIDs, 0, this.labelIDs.length);
                this.labelIDs = new_labelIDs;
                this.labelIDs[this.labelIDs.length - 1] = id;
            }
            this.labelTexts.put(id, text);
            this.labelXs.put(id, new Double(x));
            this.labelYs.put(id, new Double(y));
            this.labelSamples.put(id, new Integer(sample));
            this.labelSeries.put(id, new Integer(serie));
        }
        this.autoRepaint();
    }

    public void setLabel(String id, String text, double x, double y, int serie, int sample) {
        if (text == null) {
            String[] labelIDs_new = new String[Math.max(this.labelIDs.length - 1, 0)];
            for (int i = 0; i < this.labelIDs.length; ++i) {
                if (!id.equals(this.labelIDs[i])) continue;
                System.arraycopy(this.labelIDs, 0, labelIDs_new, 0, i);
                System.arraycopy(this.labelIDs, i + 1, labelIDs_new, i, this.labelIDs.length - i - 1);
                break;
            }
            this.labelIDs = labelIDs_new;
            this.labelTexts.remove(id);
            this.labelXs.remove(id);
            this.labelYs.remove(id);
            this.labelSamples.remove(id);
            this.labelSeries.remove(id);
        } else {
            if (!this.labelTexts.containsKey(id)) {
                String[] new_labelIDs = new String[this.labelIDs.length + 1];
                System.arraycopy(this.labelIDs, 0, new_labelIDs, 0, this.labelIDs.length);
                this.labelIDs = new_labelIDs;
                this.labelIDs[this.labelIDs.length - 1] = id;
            }
            this.labelTexts.put(id, text);
            this.labelXs.put(id, new Double(x));
            this.labelYs.put(id, new Double(y));
            this.labelSamples.put(id, new Integer(sample));
            this.labelSeries.put(id, new Integer(serie));
        }
        this.autoRepaint();
    }

    public void setLabelPosition(String id, int x, int y) {
        String label_id = null;
        for (int i = 0; i < this.labelIDs.length; ++i) {
            if (!id.equals(this.labelIDs[i])) continue;
            label_id = id;
        }
        if (label_id != null) {
            this.labelXs.put(id, new Double(x));
            this.labelYs.put(id, new Double(y));
        }
        this.autoRepaint();
    }

    public Point getLabelPosition(String id) {
        FontMetrics fm = this.getFontMetrics(this.getFont("font"));
        Rectangle bounds = this.getLabelBounds(id);
        Point p = new Point(bounds.x, bounds.y + fm.getAscent());
        return p;
    }

    public void setLabelPosition(String id, double x, double y) {
        String label_id = null;
        for (int i = 0; i < this.labelIDs.length; ++i) {
            if (!id.equals(this.labelIDs[i])) continue;
            label_id = id;
        }
        if (label_id != null) {
            this.labelXs.put(id, new Double(x));
            this.labelYs.put(id, new Double(y));
        }
        this.autoRepaint();
    }

    public void setLabelColor(String id, Color color) {
        if (id != null) {
            this.labelColors.put(id, color);
        }
        this.autoRepaint();
    }

    public Color getLabelColor(String id) {
        Color color = (Color)this.labelColors.get(id);
        if (color != null) {
            return (Color)this.labelColors.get(id);
        }
        return this.getForeground();
    }

    public String getLabelAtPoint(int x, int y) {
        if (this.gridRenderer.getGraphBounds() == null) {
            return null;
        }
        for (int i = this.labelIDs.length - 1; i >= 0; --i) {
            String id = this.labelIDs[i];
            Rectangle bounds = this.getLabelBounds(id);
            if (!bounds.contains(new Point(x, y))) continue;
            return id;
        }
        return null;
    }

    public Rectangle getLabelBounds(String id) {
        String label = (String)this.labelTexts.get(id);
        Double x = (Double)this.labelXs.get(id);
        Double y = (Double)this.labelYs.get(id);
        Integer sample = (Integer)this.labelSamples.get(id);
        Integer serie = (Integer)this.labelSeries.get(id);
        int angle = this.getLabelAngle(id);
        Font font = this.getFont(id);
        if (font == null) {
            font = this.getFont("font");
        }
        FontMetrics fm = this.getFontMetrics(font);
        int absolute_x = -100;
        int absolute_y = -100;
        int label_width = 0;
        int label_height = 0;
        if (id != null && x != null && y != null) {
            Dimension angledSize = this.renderer.getAngledLabelSize(this.renderer.getLabelSize(label, fm), angle);
            double x_pos = x;
            double y_pos = y;
            label_width = angledSize.width + 4;
            label_height = angledSize.height + 2;
            if (sample != null && serie != null && this.getSampleCenter(sample, serie) != null && (x_pos >= 1.0 || x_pos <= 0.0) && (y_pos <= 0.0 || y_pos >= 1.0)) {
                Dimension size = this.getSize();
                x_pos = Math.max(x_pos, 0.0);
                x_pos = Math.min(x_pos, (double)(size.width - label_width - 1));
                y_pos = Math.max(y_pos, (double)fm.getAscent());
                y_pos = Math.min(y_pos, (double)(size.height - label_height + fm.getAscent() - 1));
            }
            Rectangle bounds = this.gridRenderer.getDataBounds(this.grid);
            if (this.chartType.equals("pie")) {
                bounds = this.getBounds();
                --bounds.width;
                --bounds.height;
            }
            if (x_pos > 0.0 && x_pos < 1.0 && y_pos > 0.0 && y_pos < 1.0) {
                absolute_x = bounds.x + (int)Math.round((double)(bounds.width - label_width) * x_pos);
                absolute_y = bounds.y + (int)Math.round((double)(bounds.height - label_height) * y_pos);
            } else {
                absolute_x = (int)x_pos;
                absolute_y = (int)y_pos - fm.getAscent();
            }
        }
        return new Rectangle(absolute_x, absolute_y, label_width, label_height);
    }

    public void setLabelURL(String id, String adress) {
        if (adress == null) {
            this.labelURLs.remove(id);
        } else {
            this.labelURLs.put(id, adress);
        }
    }

    public void setTitle(String title) {
        if (this.chartTitle != null) {
            Long key = new Long(this.chartTitle.hashCode() + this.getFont("titleFont").hashCode());
            this.labelSizeCache.remove(key);
        }
        this.chartTitle = title;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String getTitle() {
        return this.chartTitle;
    }

    public void setTitleOn(boolean on) {
        if (on != this.chartTitleOn) {
            this.chartTitleOn = on;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isTitleOn() {
        return this.chartTitleOn;
    }

    public void setComplexLabelSeparator(String labelSeparator) {
        this.complexLabelSeparator = labelSeparator;
    }

    public String getComplexLabelSeparator() {
        return this.complexLabelSeparator;
    }

    public void setMultilineLabelAlignment(int alignment) {
        this.multilineLabelAlignment = alignment;
    }

    public int getMultilineLabelAlignment() {
        return this.multilineLabelAlignment;
    }

    public void set3DModeOn(boolean on) {
        if (this.display3dOn != on) {
            this.display3dOn = on;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public void setThreeDModeOn(boolean on) {
        this.set3DModeOn(on);
    }

    public boolean is3DModeOn() {
        return this.display3dOn;
    }

    public boolean get3DModeOn() {
        return this.is3DModeOn();
    }

    public boolean isThreeDModeOn() {
        return this.is3DModeOn();
    }

    public boolean getThreeDModeOn() {
        return this.is3DModeOn();
    }

    public void setGridOutline3DOn(boolean on) {
        this.gridOutline3DOn = on;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isGridOutline3DOn() {
        return this.gridOutline3DOn;
    }

    public void setFont(String label, Font font) {
        if (label == null || label.trim().length() < 1) {
            return;
        }
        label = label.trim().toLowerCase();
        if (font != null) {
            this.labelFonts.put(label, font);
        } else {
            this.labelFonts.remove(label);
        }
        this.labelSizeCache.clear();
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public Font getFont(String label) {
        if (label == null) {
            return this.getFont();
        }
        Font font = (Font)this.labelFonts.get(label.trim().toLowerCase());
        if (font != null) {
            return font;
        }
        return this.getFont();
    }

    public void setLegendPosition(int position) {
        this.legend.setLegendPosition(position);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getLegendPosition() {
        return this.legend.getLegendPosition();
    }

    public void setLegendColumns(int columns) {
        this.legend.setLegendColumns(columns);
    }

    public int getLegendColumns() {
        return this.legend.getLegendColumns();
    }

    public void setLegendReverseOn(boolean on) {
        this.legend.setLegendReverseOn(on);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isLegendReverseOn() {
        return this.legend.isLegendReverseOn();
    }

    public void setLegendOn(boolean on) {
        this.legend.setLegendOn(on);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isLegendOn() {
        return this.legend.isLegendOn();
    }

    public void setLegendColors(Color[] colors) {
        this.legend.setLegendColors(colors);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color[] getLegendColors() {
        return this.legend.getLegendColors();
    }

    public void setLegendColor(int index, Color color) {
        this.legend.setLegendColor(index, color);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getLegendColor(int index) {
        Color[] legendColors = this.legend.getLegendColors();
        if (legendColors != null && index >= 0 && index < legendColors.length && legendColors[index] != null) {
            return legendColors[index];
        }
        return null;
    }

    public void setLegendImage(int index, String name) {
        if (index >= 0 && index < 1000) {
            this.legend.setLegendImage(index, name);
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public String getLegendImage(int index) {
        return this.legend.getLegendImage(index);
    }

    public void setFloatingOnLegendOn(boolean on) {
        this.floatingOnLegendOn = on;
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isFloatingOnLegendOn() {
        return this.floatingOnLegendOn;
    }

    public boolean isSampleHighlightOn(int series) {
        return false;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setBackground2(Color color) {
        this.background2 = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getBackground2() {
        return this.background2;
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setChartBackground2(Color color) {
        this.chartBackground2 = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getChartBackground2() {
        return this.chartBackground2;
    }

    public void setAlternateChartBackground(Color color) {
        this.alternateChartBackground = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getAlternateChartBackground() {
        return this.alternateChartBackground;
    }

    public void setGridImage(String name) {
        this.gridImage = name;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String getGridImage(int index) {
        return this.gridImage;
    }

    public void setChartForeground(Color color) {
        this.chartForeground = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getChartForeground() {
        return this.chartForeground;
    }

    public void setZoomOn(boolean on) {
        this.zoomOn = on;
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isZoomOn() {
        return this.zoomOn;
    }

    public void setAutomaticRepaintOn(boolean state) {
        this.automaticRepaintOn = state;
    }

    public boolean isAutomaticRepaintOn() {
        return this.automaticRepaintOn;
    }

    public boolean hasDataChangedSince(long time) {
        return true;
    }

    public String toString() {
        if (this.chartTitle != null) {
            return this.getTitle();
        }
        return super.toString();
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
        this.numberFormatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
    }

    public Locale getLocale() {
        if (this.currentLocale != null) {
            return this.currentLocale;
        }
        return Locale.getDefault();
    }

    public String formatNumber(double value, int decimals) {
        if (this.currentLocale != null) {
            this.numberFormatter.setMaximumFractionDigits(decimals);
            this.numberFormatter.setMinimumFractionDigits(decimals);
            return this.numberFormatter.format(value);
        }
        long rounded = value >= 0.0 ? (long)(value + 0.5) : (long)(value - 0.5);
        if (decimals == 0 && rounded < 1000L && rounded > -1000L) {
            return rounded + "";
        }
        long pow = (long)Math.pow(10.0, decimals);
        if (pow == 0L) {
            return rounded + "";
        }
        long integer = Math.round(value * (double)pow);
        long fraction = Math.abs(integer) % pow + pow;
        String formatted = "";
        if (decimals > 0) {
            formatted = "." + (fraction + "").substring(1);
        }
        integer /= pow;
        if (this.thousandsDelimiter == null) {
            this.numberFormatter.setGroupingUsed(true);
            this.numberFormatter.setMinimumFractionDigits(0);
            formatted = this.numberFormatter.format(integer) + formatted;
        } else if (this.thousandsDelimiter.trim().equalsIgnoreCase("off")) {
            this.numberFormatter.setGroupingUsed(false);
            this.numberFormatter.setMinimumFractionDigits(0);
            formatted = this.numberFormatter.format(integer) + formatted;
        } else {
            long integer_part = integer;
            if (integer_part > 0L) {
                while (integer_part >= 1L) {
                    long n = integer_part % 1000L + 1000L;
                    formatted = n >= 1000L && integer_part >= 1000L ? this.thousandsDelimiter + (n + "").substring(1) + formatted : integer_part % 1000L + formatted;
                    integer_part /= 1000L;
                }
            } else if (integer_part < 0L) {
                while (integer_part <= -1L) {
                    long n = integer_part % 1000L - 1000L;
                    formatted = n <= -1000L && integer_part <= -1000L ? this.thousandsDelimiter + (n + "").substring(2) + formatted : integer_part % 1000L + formatted;
                    integer_part /= 1000L;
                }
            } else if (integer_part == 0L) {
                formatted = "0" + formatted;
            }
        }
        if (value < 0.0 && integer == 0L) {
            formatted = "-" + formatted;
        }
        return formatted;
    }

    protected abstract String constructLabel(int var1, int var2, int var3, boolean var4, String var5);

    public abstract void setSelection(int var1, int var2, boolean var3, boolean var4, boolean var5);

    protected void checkDataIntegrity() {
    }

    public Rectangle getGraphBounds() {
        Rectangle bounds = null;
        if (!this.chartType.equals("pie")) {
            bounds = this.gridRenderer.getGraphBounds();
        }
        if (bounds == null || this.needGraphBounds) {
            bounds = new Rectangle(10, 10, this.getSize().width - 20, this.getSize().height - 20);
            this.renderer.calculateGraphBounds(bounds);
            this.needGraphBounds = false;
        }
        return bounds;
    }

    protected Rectangle getTotalGraphBounds() {
        return this.gridRenderer.getTotalGraphBounds();
    }

    public void setGraphInsets(int top, int left, int bottom, int right) {
        this.grid.setGraphInsets(top, left, bottom, right);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public Insets getGraphInsets() {
        return this.grid.getGraphInsets();
    }

    public void setOverlayInsets(double top, double left, double bottom, double right) {
        this.overlayInsets[2] = top;
        this.overlayInsets[0] = left;
        this.overlayInsets[3] = bottom;
        this.overlayInsets[1] = right;
    }

    public double getOverlayInsets(int side) {
        return this.overlayInsets[side];
    }

    public void addImage(String name, Image image) {
        if (name != null) {
            try {
                if (image != null) {
                    this.images.put(name, image);
                    this.imageTracker.addImage(image, 0);
                    this.imageTracker.waitForAll();
                } else {
                    this.images.remove(name);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Image loadImage(String name) {
        if (name == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(name);
        MediaTracker tracker = new MediaTracker(this);
        int id = (int)(Math.random() * 2.147483647E9);
        tracker.addImage(image, id);
        try {
            tracker.waitForID(id);
        }
        catch (InterruptedException e) {
            System.out.println("Could not load image: " + name);
        }
        return image;
    }

    public Image getImage(String name) {
        return (Image)this.images.get(name);
    }

    public void setServletModeOn(boolean on) {
        this.servletModeOn = on;
    }

    public boolean isServletModeOn() {
        return this.servletModeOn;
    }

    public int addOverlayChart(GenericChart chart) {
        if (chart != null) {
            chart.overlayChartOn = true;
            chart.parentChart = this;
            chart.setGrid(this.grid);
            this.overlayCharts.addElement(chart);
            this.renderer.addOverlayRenderer(chart.renderer);
            this.needRender = true;
            this.autoRepaint();
            return this.overlayCharts.lastIndexOf(chart);
        }
        return 0;
    }

    public void removeOverlayChart(int index) {
        if (index < 0 || index >= this.overlayCharts.size()) {
            throw new IllegalArgumentException("invalid overlay index: " + index);
        }
        this.overlayCharts.removeElementAt(index);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setOverlayChart(int index, GenericChart chart) {
        if (chart != null) {
            chart.parentChart = this;
            chart.setGrid(this.grid);
            int count = this.overlayCharts.size();
            if (index >= 0 && index <= count) {
                if (index == count) {
                    this.overlayCharts.addElement(chart);
                } else {
                    this.overlayCharts.setElementAt(chart, index);
                }
                this.renderer.setOverlayRenderer(index, chart.renderer);
                this.needRender = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid index for overlay chart: " + index);
            }
        }
    }

    public GenericChart getOverlayChart(int index) {
        if (index >= 0 && index < this.overlayCharts.size()) {
            return (GenericChart)this.overlayCharts.elementAt(index);
        }
        return null;
    }

    public void setOverlayChartOn(int index, boolean on) {
        GenericChart chart = this.getOverlayChart(index);
        if (chart != null) {
            chart.overlayChartOn = on;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isOverlayChartOn(int index) {
        GenericChart chart = this.getOverlayChart(index);
        if (chart != null) {
            return chart.overlayChartOn;
        }
        return false;
    }

    public Dimension getSize() {
        if (this.parentChart != null) {
            return this.parentChart.getSize();
        }
        return super.getSize();
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize.width = width;
        this.preferredSize.height = height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 70);
    }

    public Image getImage(int width, int height) {
        Graphics g;
        width = Math.max(1, width);
        height = Math.max(1, height);
        Dimension oldSize = this.getSize();
        Image image = this.createImage(width, height);
        if (image != null && (g = image.getGraphics()) != null) {
            this.setSize(width, height);
            boolean servlet_on = this.isServletModeOn();
            this.setServletModeOn(true);
            this.paint(g);
            this.setServletModeOn(servlet_on);
        }
        this.setSize(oldSize.width, oldSize.height);
        return image;
    }

    public BufferedImage getHighResolutionImage(int width, int height, int dpi) {
        Dimension oldSize = this.getSize();
        width = Math.max(1, width);
        height = Math.max(1, height);
        int screenResolution = 96;
        if (!GraphicsEnvironment.isHeadless()) {
            screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        double ratio = dpi / screenResolution;
        BufferedImage image = new BufferedImage((int)Math.round((double)width * ratio), (int)Math.round((double)height * ratio), 1);
        Graphics2D g = image.createGraphics();
        g.transform(AffineTransform.getScaleInstance(ratio, ratio));
        this.setSize(width, height);
        boolean servletModeOn = this.isServletModeOn();
        this.setServletModeOn(true);
        this.paint(g);
        this.setServletModeOn(servletModeOn);
        this.setSize(oldSize.width, oldSize.height);
        return image;
    }

    public Image createImage(int width, int height) {
        boolean is_java2;
        boolean bl = is_java2 = !System.getProperty("java.version").startsWith("1.1");
        if (is_java2) {
            if (!this.bufferedImageClass_tried_loading) {
                try {
                    this.bufferedImageClass = Class.forName("java.awt.image.BufferedImage");
                    Class[] parameters = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                    this.bufferedImageConstructor = this.bufferedImageClass.getConstructor(parameters);
                    Field field = this.bufferedImageClass.getField("TYPE_INT_RGB");
                    this.TYPE_INT_RGB = field.getInt(null);
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoSuchMethodException e) {
                    this.bufferedImageClass = null;
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                this.bufferedImageClass_tried_loading = true;
            }
        } else {
            this.bufferedImageClass_tried_loading = true;
        }
        width = Math.max(1, width);
        height = Math.max(1, height);
        Image image = null;
        if (this.bufferedImageClass != null) {
            try {
                Object[] parameters = new Object[]{new Integer(width), new Integer(height), new Integer(this.TYPE_INT_RGB)};
                image = (Image)this.bufferedImageConstructor.newInstance(parameters);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (image == null && (image = super.createImage(width, height)) == null) {
            if (this.servletFrame == null) {
                this.servletFrame = new Frame();
                this.servletFrame.addNotify();
            }
            image = this.servletFrame.createImage(width, height);
            this.servletFrame.removeNotify();
        }
        return image;
    }

    public Image createImage_oldstyle(int width, int height) {
        Image image = super.createImage(width = Math.max(1, width), height = Math.max(1, height));
        if (image == null) {
            if (this.servletFrame == null) {
                this.servletFrame = new Frame();
                this.servletFrame.addNotify();
            }
            image = this.servletFrame.createImage(width, height);
            this.servletFrame.removeNotify();
        }
        return image;
    }

    public void setAntialiasingOn(boolean on) {
        this.antialiasingOn = on;
    }

    public boolean isAntialiasingOn() {
        return this.antialiasingOn;
    }

    public void setExternalGraphics(Graphics g, Image image) {
        this.renderer.setExternalGraphics(g, image);
        this.needRender = true;
        this.autoRepaint();
    }

    public void removeExternalGraphics() {
        this.renderer.removeExternalGraphics();
        this.needRender = true;
        this.autoRepaint();
    }

    public void autoRepaint() {
        if (this.parentChart != null) {
            this.parentChart.autoRepaint();
        } else if (this.automaticRepaintOn) {
            this.repaint();
        }
    }

    public void forceRepaint() {
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.repaint();
    }

    protected void setNeedChartCalculation(boolean state) {
        this.needChartCalculation = true;
        for (int i = 0; i < this.overlayCharts.size(); ++i) {
            GenericChart overlay = (GenericChart)this.overlayCharts.elementAt(i);
            overlay.needChartCalculation = true;
        }
    }

    public final void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g) {
        if (g == null) {
            return;
        }
        Dimension size = this.getSize();
        if (this.c2 != null) {
            if (this.hasDataChangedSince(this.lastRenderTime)) {
                this.needRender = true;
                this.needChartCalculation = true;
                this.checkDataIntegrity();
            }
            for (int i = 0; i < this.overlayCharts.size(); ++i) {
                GenericChart overlay = (GenericChart)this.overlayCharts.elementAt(i);
                if (overlay.hasDataChangedSince(this.lastRenderTime)) {
                    overlay.needRender = true;
                    this.needRender = true;
                    overlay.needChartCalculation = true;
                    this.needChartCalculation = true;
                }
                if (overlay.needRender) {
                    this.needRender = overlay.needRender;
                }
                if (!overlay.needChartCalculation) continue;
                this.needChartCalculation = true;
            }
            this.render(g);
            this.lastRenderTime = System.currentTimeMillis();
            ChartRenderer chartRenderer = this.renderer;
            synchronized (chartRenderer) {
                this.c2.paint(g, size);
            }
        }
        if (this.displayVersionOn) {
            g.setColor(Color.white);
            g.fillRect(0, 0, size.width, 20);
            g.setColor(Color.black);
            g.setFont(new Font("Arial", 0, 12));
            g.drawString("EasyCharts " + GenericChart.getVersion() + ", Copyright 1998-2009, ObjectPlanet, Inc.", 0, 12);
        }
    }

    public void render(Graphics g) {
        this.renderer.render(g);
    }

    protected void render(Graphics g, boolean offscreenOn) {
        this.renderer.render(g, offscreenOn);
    }

    protected void renderOffScreen(Graphics g) {
    }

    public void setPrintAsBitmap(boolean on) {
        this.printAsBitmap = on;
    }

    public boolean isPrintAsBitmap() {
        return this.printAsBitmap;
    }

    public final void print(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.getForeground());
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        int screenResolution = 96;
        if (!GraphicsEnvironment.isHeadless()) {
            screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        double ratio = 600 / screenResolution;
        BufferedImage image = new BufferedImage((int)Math.round((double)size.width * ratio), (int)Math.round((double)size.height * ratio), 1);
        Graphics2D g2 = image.createGraphics();
        g2.transform(AffineTransform.getScaleInstance(ratio, ratio));
        this.render(g2, false);
        if (this.printAsBitmap) {
            this.render(g2, true);
        }
        this.c2.paint(g2, size);
        g.drawImage(image, 0, 0, size.width, size.height, this);
    }

    public boolean isAnyFloatingLabelsOn(int serie) {
        return this.renderer.isAnyFloatingLabelsOn(serie);
    }

    protected void processEvent(AWTEvent event) {
        switch (event.getID()) {
            case 501: {
                int xpos = 0;
                int ypos = 0;
                if (event instanceof MouseEvent) {
                    xpos = ((MouseEvent)event).getX();
                    ypos = ((MouseEvent)event).getY();
                }
                Dimension size = this.getSize();
                if (this.c2.copyright) {
                    this.c2.copyright = false;
                } else if (xpos > 0 && xpos < 11 && ypos > size.height - 11 && ypos < size.height) {
                    this.c2.copyright = true;
                }
                this.gridRenderer.lastClickTime = System.currentTimeMillis();
                this.repaint();
            }
        }
        super.processEvent(event);
    }

    protected void handleCustomLabels(AWTEvent event) {
        String id;
        int xpos = 0;
        int ypos = 0;
        if (event instanceof MouseEvent) {
            xpos = ((MouseEvent)event).getX();
            ypos = ((MouseEvent)event).getY();
        }
        if ((id = this.getLabelAtPoint(xpos, ypos)) != null && this.labelURLs.get(id) != null) {
            this.new_cursor = Renderer.HAND_CURSOR;
        }
        switch (event.getID()) {
            case 501: {
                this.mousePressX = xpos;
                this.mousePressY = ypos;
                this.dragged_label = this.getLabelAtPoint(xpos, ypos);
                if (this.dragged_label != null && this.labelSamples.get(this.dragged_label) != null && this.labelSeries.get(this.dragged_label) != null) {
                    this.dragged_start_x = (Double)this.labelXs.get(this.dragged_label);
                    this.dragged_start_y = (Double)this.labelYs.get(this.dragged_label);
                    for (int i = 0; i < this.labelIDs.length; ++i) {
                        if (!this.dragged_label.equals(this.labelIDs[i])) continue;
                        System.arraycopy(this.labelIDs, i + 1, this.labelIDs, i, this.labelIDs.length - i - 1);
                        break;
                    }
                    this.labelIDs[this.labelIDs.length - 1] = this.dragged_label;
                    this.shouldSelect = false;
                }
                this.repaint();
                break;
            }
            case 506: {
                double new_y;
                double new_x;
                if (this.dragged_label == null || this.labelSamples.get(this.dragged_label) == null || this.labelSeries.get(this.dragged_label) == null) break;
                Font font = this.getFont("font");
                FontMetrics fm = this.getFontMetrics(font);
                Rectangle labelBounds = this.getLabelBounds(this.dragged_label);
                int label_width = labelBounds.width;
                int label_height = labelBounds.height;
                int delta_x = xpos - this.mousePressX;
                int delta_y = ypos - this.mousePressY;
                if (this.dragged_start_x > 0.0 && this.dragged_start_x < 1.0 && this.dragged_start_y > 0.0 && this.dragged_start_y < 1.0) {
                    Rectangle bounds = this.gridRenderer.getDataBounds(this.grid);
                    if (this.chartType.equals("pie")) {
                        bounds = this.getBounds();
                        --bounds.width;
                        --bounds.height;
                    }
                    new_x = this.dragged_start_x + (double)delta_x / (double)(bounds.width - label_width);
                    new_y = this.dragged_start_y + (double)delta_y / (double)(bounds.height - label_height);
                    new_x = Math.max(new_x, 1.0E-6);
                    new_y = Math.max(new_y, 1.0E-6);
                    new_x = Math.min(new_x, 0.999999);
                    new_y = Math.min(new_y, 0.999999);
                } else {
                    Dimension size = this.getSize();
                    new_x = this.dragged_start_x + (double)delta_x;
                    new_y = this.dragged_start_y + (double)delta_y;
                    new_x = Math.max(new_x, 0.0);
                    new_x = Math.min(new_x, (double)(size.width - label_width - 1));
                    new_y = Math.max(new_y, (double)fm.getAscent());
                    new_y = Math.min(new_y, (double)(size.height - label_height + fm.getAscent() - 1));
                }
                this.labelXs.put(this.dragged_label, new Double(new_x));
                this.labelYs.put(this.dragged_label, new Double(new_y));
                this.needRender = true;
                this.repaint();
                break;
            }
            case 502: {
                this.mousePressX = -1;
                this.mousePressY = -1;
            }
        }
    }

    protected Point getSampleCenter(int sample, int serie) {
        return this.renderer.getSampleCenter(sample, serie);
    }

    public static String getVersion() {
        return "4.1";
    }
}

