/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import java.math.BigDecimal;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BooleanExpression;
import org.activemq.filter.mockrunner.Expression;

public class ConstantExpression
implements Expression {
    public static final BooleanConstantExpression NULL = new BooleanConstantExpression(null);
    public static final BooleanConstantExpression TRUE = new BooleanConstantExpression(Boolean.TRUE);
    public static final BooleanConstantExpression FALSE = new BooleanConstantExpression(Boolean.FALSE);
    private Object value;

    public static ConstantExpression createFromDecimal(String string) {
        Number number;
        if (string.endsWith("l") || string.endsWith("L")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            number = new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            number = new BigDecimal(string);
        }
        long l = number.longValue();
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            number = new Integer(number.intValue());
        }
        return new ConstantExpression(number);
    }

    public static ConstantExpression createFromHex(String string) {
        Number number = new Long(Long.parseLong(string.substring(2), 16));
        long l = number;
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            number = new Integer(((Number)number).intValue());
        }
        return new ConstantExpression(number);
    }

    public static ConstantExpression createFromOctal(String string) {
        Number number = new Long(Long.parseLong(string, 8));
        long l = number;
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            number = new Integer(((Number)number).intValue());
        }
        return new ConstantExpression(number);
    }

    public static ConstantExpression createFloat(String string) {
        Double d = new Double(string);
        return new ConstantExpression(d);
    }

    public ConstantExpression(Object object) {
        this.value = object;
    }

    public Object evaluate(Message message) throws JMSException {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? "TRUE" : "FALSE";
        }
        if (this.value instanceof String) {
            return ConstantExpression.encodeString((String)this.value);
        }
        return this.value.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public static String encodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\'') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static class BooleanConstantExpression
    extends ConstantExpression
    implements BooleanExpression {
        public BooleanConstantExpression(Object object) {
            super(object);
        }
    }
}

