/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopicSubscriber;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;

public class MockTopic
extends MockDestination
implements Topic {
    private String name;

    public MockTopic(String string) {
        this.name = string;
    }

    public String getTopicName() throws JMSException {
        return this.name;
    }

    public void addMessage(Message message) throws JMSException {
        this.addReceivedMessage(message);
        boolean bl = false;
        Iterator iterator = this.sessionSet().iterator();
        while (iterator.hasNext()) {
            Object object;
            MockSession mockSession = (MockSession)iterator.next();
            MessageListener messageListener = mockSession.getMessageListener();
            if (null != messageListener) {
                messageListener.onMessage(message);
                bl = true;
                this.acknowledgeMessage(message, mockSession);
                continue;
            }
            List list = mockSession.getTopicTransmissionManager().getTopicSubscriberList(this.name);
            int n = 0;
            while (n < list.size()) {
                object = (MockTopicSubscriber)list.get(n);
                if (((MockMessageConsumer)object).canConsume(message)) {
                    ((MockMessageConsumer)object).receiveMessage(message);
                    bl = true;
                    this.acknowledgeMessage(message, mockSession);
                }
                ++n;
            }
            object = mockSession.getTopicTransmissionManager().getDurableTopicSubscriberMap(this.name);
            Iterator iterator2 = object.keySet().iterator();
            while (iterator2.hasNext()) {
                MockTopicSubscriber mockTopicSubscriber = (MockTopicSubscriber)object.get(iterator2.next());
                if (!mockTopicSubscriber.canConsume(message)) continue;
                mockTopicSubscriber.receiveMessage(message);
                bl = true;
                this.acknowledgeMessage(message, mockSession);
            }
        }
        if (!bl) {
            this.addCurrentMessage(message);
        }
    }
}

