/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChartRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Hashtable;

public class PieChart
extends Chart {
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    private int pieAngle;
    private double pieDepth;
    private boolean percentLabelsOn;
    private boolean pieLabelsOn;
    private int percentDecimalCount;
    private int selectionStyle;
    private boolean sliceSeperatorOn;
    private Color sliceSeperatorColor;
    private double detachedDistance;
    private Hashtable detachedSlices;
    private int percentLabelStyle;
    private Color insideLabelColor;
    private Color[] insideLabelColors;
    private Color outsideLabelColor;
    private Color[] outsideLabelColors;
    private Color pointingLabelColor;
    private Color[] pointingLabelColors;
    private boolean gradientSamplesOn;
    int[] startAngle;
    private boolean pieRotationOn;

    public PieChart() {
        this(1);
    }

    public PieChart(int sampleCount) {
        this(1, sampleCount);
    }

    public PieChart(int seriesCount, int sampleCount) {
        super(seriesCount, sampleCount);
        this.renderer = new PieChartRenderer(this);
        this.chartType = "pie";
        this.insideLabelColors = new Color[sampleCount];
        this.outsideLabelColors = new Color[sampleCount];
        this.pointingLabelColors = new Color[sampleCount];
        this.startAngle = new int[sampleCount];
        this.detachedSlices = new Hashtable();
        this.pieAngle = 20;
        this.pieDepth = 0.4f;
        this.sampleLabelsOn = false;
        this.percentLabelsOn = false;
        this.pieLabelsOn = false;
        this.percentDecimalCount = 0;
        this.selectionStyle = 0;
        this.sliceSeperatorOn = true;
        this.sliceSeperatorColor = null;
        this.detachedDistance = 0.1;
        this.percentLabelStyle = 3;
        this.valueLabelStyle = 3;
        this.sampleLabelStyle = 3;
        this.seriesLabelStyle = 3;
    }

    public void reset() {
        super.reset();
        this.pieAngle = 20;
        this.pieDepth = 0.4f;
        this.percentLabelsOn = false;
        this.pieLabelsOn = false;
        this.percentDecimalCount = 0;
        this.selectionStyle = 0;
        this.sliceSeperatorOn = true;
        this.sliceSeperatorColor = null;
        this.detachedDistance = 0.1;
        this.gradientSamplesOn = true;
        if (this.detachedSlices != null) {
            this.detachedSlices.clear();
        }
        this.pieRotationOn = false;
        this.percentLabelStyle = 3;
        this.valueLabelStyle = 3;
        this.sampleLabelStyle = 3;
        this.seriesLabelStyle = 3;
    }

    public double getPercentValue(int serie, int index) {
        if (serie < 0 || serie >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + serie);
        }
        if (index < 0 || index >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid sample index: " + index);
        }
        int seriesCount = this.getSeriesCount();
        if (seriesCount == 1) {
            int sampleCount = this.getSampleCount();
            double sum = 0.0;
            for (int i = 0; i < sampleCount; ++i) {
                double value = this.getSampleValue(0, i);
                if (!(value > 0.0)) continue;
                sum += value;
            }
            double value = this.getSampleValue(0, index);
            if (value >= 0.0) {
                return value / sum * 100.0;
            }
        } else {
            double sum = 0.0;
            for (int i = 0; i < seriesCount; ++i) {
                double value = this.getSampleValue(i, index);
                if (!(value > 0.0)) continue;
                sum += value;
            }
            double value = this.getSampleValue(serie, index);
            if (value > 0.0) {
                return value / sum * 100.0;
            }
        }
        return 0.0;
    }

    public void setAngle(int angle) {
        if (this.pieAngle != angle) {
            this.pieAngle = angle;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getAngle() {
        return this.pieAngle;
    }

    public void setStartAngle(int angle) {
        this.setStartAngle(0, angle);
    }

    public void setStartAngle(int index, int angle) {
        if (index >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid pie index: " + index);
        }
        angle = (angle %= 360) < 0 ? -360 - angle : -angle;
        if (index < 0) {
            for (int i = 0; i < this.getSampleCount(); ++i) {
                this.startAngle[i] = angle;
            }
        } else {
            this.startAngle[index] = angle;
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getStartAngle(int index) {
        return -this.startAngle[index];
    }

    public void setDepth(double depth) {
        if (this.pieDepth != depth) {
            this.pieDepth = depth;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public float getDepth() {
        return (float)this.pieDepth;
    }

    public void setPercentDecimalCount(int count) {
        if (this.percentDecimalCount != count) {
            this.percentDecimalCount = count;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public int getPercentDecimalCount() {
        return this.percentDecimalCount;
    }

    public void setPercentLabelsOn(boolean on) {
        if (this.percentLabelsOn != on) {
            this.percentLabelsOn = on;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isPercentLabelsOn() {
        return this.percentLabelsOn;
    }

    public void setPercentLabelStyle(int style) {
        if (this.percentLabelStyle != style) {
            this.percentLabelStyle = 3;
            if (style == 0 || style == 1 || style == 5) {
                this.percentLabelStyle = style;
            }
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public int getPercentLabelStyle() {
        return this.percentLabelStyle;
    }

    public void setPieLabelsOn(boolean on) {
        if (this.pieLabelsOn != on) {
            this.pieLabelsOn = on;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isPieLabelsOn() {
        return this.pieLabelsOn;
    }

    public void setInsideLabelColor(int index, Color color) {
        if (index >= 0) {
            if (index >= this.insideLabelColors.length) {
                Color[] newinsideLabelColors = new Color[index + 1];
                System.arraycopy(this.insideLabelColors, 0, newinsideLabelColors, 0, this.insideLabelColors.length);
                this.insideLabelColors = newinsideLabelColors;
            }
            this.insideLabelColors[index] = color;
            this.autoRepaint();
        } else {
            this.insideLabelColor = color;
        }
    }

    public Color getInsideLabelColor(int index) {
        if (index == -1) {
            return this.insideLabelColor;
        }
        try {
            return this.insideLabelColors[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid pie index: " + index);
        }
    }

    public void setOutsideLabelColor(int index, Color color) {
        if (index >= 0) {
            if (index >= this.outsideLabelColors.length) {
                Color[] newOutsideLabelColors = new Color[index + 1];
                System.arraycopy(this.outsideLabelColors, 0, newOutsideLabelColors, 0, this.outsideLabelColors.length);
                this.outsideLabelColors = newOutsideLabelColors;
            }
            this.outsideLabelColors[index] = color;
            this.autoRepaint();
        } else {
            this.outsideLabelColor = color;
        }
    }

    public Color getOutsideLabelColor(int index) {
        if (index == -1) {
            return this.outsideLabelColor;
        }
        try {
            return this.outsideLabelColors[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid pie index: " + index);
        }
    }

    public void setPointingLabelColor(int index, Color color) {
        if (index >= 0) {
            if (index >= this.pointingLabelColors.length) {
                Color[] newPointingLabelColors = new Color[index + 1];
                System.arraycopy(this.pointingLabelColors, 0, newPointingLabelColors, 0, this.pointingLabelColors.length);
                this.pointingLabelColors = newPointingLabelColors;
            }
            this.pointingLabelColors[index] = color;
            this.autoRepaint();
        } else {
            this.pointingLabelColor = color;
        }
    }

    public Color getPointingLabelColor(int index) {
        if (index == -1) {
            return this.pointingLabelColor;
        }
        try {
            return this.pointingLabelColors[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid pie index: " + index);
        }
    }

    public void setFont(String label, Font font) {
        super.setFont(label, font);
    }

    public void setSelectionStyle(int style) {
        if (this.selectionStyle != style) {
            this.selectionStyle = style;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSelectionStyle() {
        return this.selectionStyle;
    }

    public void setDetachedDistance(double distance) {
        if (this.detachedDistance != distance) {
            this.detachedDistance = distance;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public double getDetachedDistance() {
        return this.detachedDistance;
    }

    public void setDetachedSlice(int serie, int index, double distance) {
        Double key = new Double(serie * 1000000 + index);
        if (distance != 0.0) {
            this.detachedSlices.put(key, new Double(distance));
        } else {
            this.detachedSlices.remove(key);
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getDetachedSlice(int serie, int index) {
        Double key = new Double(serie * 1000000 + index);
        Double value = (Double)this.detachedSlices.get(key);
        if (value != null) {
            return value;
        }
        return 0.0;
    }

    public void setSliceSeperatorOn(boolean state) {
        if (this.sliceSeperatorOn != state) {
            this.sliceSeperatorOn = state;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isSliceSeperatorOn() {
        return this.sliceSeperatorOn;
    }

    public void setSliceSeperatorColor(Color color) {
        if (this.sliceSeperatorColor != color) {
            this.sliceSeperatorColor = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getSliceSeperatorColor() {
        return this.sliceSeperatorColor;
    }

    public void setGradientSamplesOn(boolean on) {
        this.gradientSamplesOn = on;
    }

    public boolean isGradientSamplesOn() {
        return this.gradientSamplesOn;
    }

    public void setPieRotationOn(boolean on) {
        this.pieRotationOn = on;
    }

    public boolean isPieRotationOn() {
        return this.pieRotationOn;
    }

    public Polygon getSlicePolygon(int serie, int sample) {
        return ((PieChartRenderer)this.renderer).getSlicePolygon(serie, sample);
    }

    protected Rectangle getTotalGraphBounds() {
        return this.getGraphBounds();
    }

    protected void checkDataIntegrity() {
        int count;
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int sampleCount = this.getSampleCount();
        if (this.insideLabelColors != null && sampleCount != this.insideLabelColors.length) {
            Color[] newinsideLabelColors = new Color[sampleCount];
            count = Math.min(sampleCount, this.insideLabelColors.length);
            System.arraycopy(this.insideLabelColors, 0, newinsideLabelColors, 0, count);
            this.insideLabelColors = newinsideLabelColors;
        }
        if (this.outsideLabelColors != null && sampleCount != this.outsideLabelColors.length) {
            Color[] newoutsideLabelColors = new Color[sampleCount];
            count = Math.min(sampleCount, this.outsideLabelColors.length);
            System.arraycopy(this.outsideLabelColors, 0, newoutsideLabelColors, 0, count);
            this.outsideLabelColors = newoutsideLabelColors;
        }
        if (this.pointingLabelColors != null && sampleCount != this.pointingLabelColors.length) {
            Color[] newpointingLabelColors = new Color[sampleCount];
            count = Math.min(sampleCount, this.pointingLabelColors.length);
            System.arraycopy(this.pointingLabelColors, 0, newpointingLabelColors, 0, count);
            this.pointingLabelColors = newpointingLabelColors;
        }
        if (this.startAngle != null && sampleCount != this.startAngle.length) {
            int[] newStartAngle = new int[sampleCount];
            count = Math.min(sampleCount, this.startAngle.length);
            System.arraycopy(this.startAngle, 0, newStartAngle, 0, count);
            this.startAngle = newStartAngle;
        }
    }

    protected String constructLabel(int series, int sample, int style, boolean paintSeriesOn, String percentLabel) {
        boolean percentOn;
        boolean bl = percentOn = this.percentLabelsOn && this.percentLabelStyle == style;
        if (percentOn && series >= 0) {
            percentLabel = this.formatNumber(this.getPercentValue(series, sample), this.getPercentDecimalCount()) + "%";
        }
        return super.constructLabel(series, sample, style, paintSeriesOn, percentLabel);
    }

    public boolean isAnyFloatingLabelsOn(int serie) {
        boolean labels_on = this.sampleLabelsOn && this.sampleLabelStyle == 3;
        labels_on |= this.seriesLabelsOn && this.seriesLabelStyle == 3;
        labels_on |= this.isValueLabelsOn(serie) && this.valueLabelStyle == 3;
        return labels_on |= this.percentLabelsOn && this.percentLabelStyle == 3;
    }

    protected void processEvent(AWTEvent e) {
        if (this.pieRotationOn) {
            ((PieChartRenderer)this.renderer).handlePieRotation(e);
        }
        super.processEvent(e);
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }
}

