/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChartRenderer;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

public class BarChart
extends Chart {
    public static final int SIDE_BY_SIDE_BARS = 0;
    public static final int STACKED_BARS = 1;
    public static final int BEHIND_BARS = 2;
    public static final int BLOCK = 0;
    public static final int CYLINDER = 1;
    private Color[] barLabelColors;
    private boolean multiColorOn;
    private boolean barOutlineOn;
    private Color barOutlineColor;
    private boolean autoLabelSpacingOn;
    private double barWidthFraction;
    private int barType;
    private int barShape;

    public BarChart() {
        this(1);
    }

    public BarChart(int count) {
        this(count, 100.0);
    }

    public BarChart(int count, double range) {
        this(count, range, 0.0);
    }

    public BarChart(int sampleCount, double range, double lowerRange) {
        this(1, sampleCount, range, lowerRange);
    }

    public BarChart(int seriesCount, int sampleCount, double range, double lowerRange) {
        super(sampleCount);
        this.renderer = new BarChartRenderer(this);
        this.chartType = "bar";
        this.barLabelColors = new Color[sampleCount];
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(seriesCount);
        this.grid.setRange(0, range);
        this.grid.setLowerRange(0, lowerRange);
        this.grid.setCurrentRange(0, range);
        this.grid.setCurrentLowerRange(0, lowerRange);
        this.multiColorOn = false;
        this.valueLabelStyle = 1;
        this.seriesLabelStyle = 1;
        this.sampleLabelStyle = 1;
        this.barOutlineOn = true;
        this.autoLabelSpacingOn = false;
        this.barWidthFraction = 0.4;
        this.barType = 0;
        this.multiSeriesOn = false;
        this.barOutlineColor = null;
        this.seriesLabelsOn = false;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.multiColorOn = false;
        this.sampleLabelStyle = 1;
        this.seriesLabelStyle = 1;
        this.valueLabelStyle = 1;
        this.barOutlineOn = true;
        this.autoLabelSpacingOn = false;
        this.barWidthFraction = 0.4;
        this.barType = 0;
        this.multiSeriesOn = false;
        this.barOutlineColor = null;
        this.seriesLabelsOn = false;
    }

    protected double getHighestValue(int range) {
        if (this.barType == 1 && this.getSeriesRange(0) == range) {
            double max = super.getHighestValue(range);
            int sampleCount = this.getSampleCount();
            int seriesCount = this.getSeriesCount();
            for (int sample = 0; sample < sampleCount; ++sample) {
                double sum = 0.0;
                for (int serie = 0; serie < seriesCount; ++serie) {
                    ChartSample s = this.getSample(serie, sample);
                    if (s == null || s.value == null || s.value.isNaN() || !(s.value > 0.0)) continue;
                    sum += s.value.doubleValue();
                }
                max = Math.max(max, sum);
            }
            return max;
        }
        return super.getHighestValue(range);
    }

    protected double getLowestValue(int range) {
        if (this.barType == 0) {
            return super.getLowestValue(range);
        }
        double min = super.getLowestValue(range);
        int sampleCount = this.getSampleCount();
        int seriesCount = this.getSeriesCount();
        for (int sample = 0; sample < sampleCount; ++sample) {
            double sum = 0.0;
            for (int serie = 0; serie < seriesCount; ++serie) {
                ChartSample s = this.getSample(serie, sample);
                if (s == null || s.value == null || s.value.isNaN() || !(s.value < 0.0)) continue;
                sum += s.value.doubleValue();
            }
            min = Math.min(min, sum);
        }
        return min;
    }

    public int getValuePosition(double value) {
        return this.grid.getValuePosition(0, value, this.getGraphBounds());
    }

    public void setMultiColorOn(boolean on) {
        if (on != this.multiColorOn) {
            this.multiColorOn = on;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiColorOn() {
        return this.multiColorOn;
    }

    public void setBarLabels(String[] labels) {
        this.barLabels = labels;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String[] getBarLabels() {
        if (this.barLabels != null) {
            return this.barLabels;
        }
        return this.getSampleLabels();
    }

    public void setBarLabelsOn(boolean on) {
        this.barLabelsOn = on;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isBarLabelsOn() {
        return this.barLabelsOn;
    }

    public synchronized void setBarLabelColor(int index, Color color) {
        try {
            this.barLabelColors[index] = color;
            this.autoRepaint();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid sample index: " + index);
        }
    }

    public Color getBarLabelColor(int index) {
        if (this.barLabels != null && index < this.barLabelColors.length) {
            return this.barLabelColors[index];
        }
        return null;
    }

    public void setBarOutlineOn(boolean on) {
        if (this.barOutlineOn != on) {
            this.barOutlineOn = on;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isBarOutlineOn() {
        return this.barOutlineOn;
    }

    public void setBarOutlineColor(Color color) {
        if (color != this.barOutlineColor) {
            this.barOutlineColor = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getBarOutlineColor() {
        return this.barOutlineColor;
    }

    public void setBarAlignment(int alignment) {
        this.grid.setGridAlignment(alignment);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getGridAlignment() {
        return this.grid.getGridAlignment();
    }

    public void setBarType(int type) {
        if (type != this.barType) {
            if (type == 0 || type == 1 || type == 2) {
                this.barType = type;
                this.needRender = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar type: " + type);
            }
        }
    }

    public int getBarType() {
        return this.barType;
    }

    public void setBarShape(int shape) {
        if (shape != this.barShape) {
            if (shape == 1 || shape == 0) {
                this.barShape = shape;
                this.needRender = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar shape: " + shape);
            }
        }
    }

    public int getBarShape() {
        return this.barShape;
    }

    public void setAutoLabelSpacingOn(boolean on) {
        if (on != this.autoLabelSpacingOn) {
            this.autoLabelSpacingOn = on;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    public void setBarWidth(double width) {
        if (width != this.barWidthFraction) {
            width = Math.max(0.0, width);
            this.barWidthFraction = width = Math.min(1.0, width);
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public double getBarWidth() {
        return this.barWidthFraction;
    }

    public Rectangle getBarBounds(int serie, int sample) {
        return ((BarChartRenderer)this.renderer).getBarBounds(serie, sample);
    }

    public void setMultiSeriesOn(boolean state) {
        if (state != this.multiSeriesOn) {
            this.multiSeriesOn = state;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiSeriesOn() {
        return this.multiSeriesOn;
    }

    public String[] getLegendLabels() {
        String[] legendLabels = this.legend.getLegendLabels();
        if (legendLabels != null) {
            return legendLabels;
        }
        if (this.getSeriesCount() > 1 || this.barType == 1 || this.multiSeriesOn) {
            return this.getSeriesLabels();
        }
        return this.getSampleLabels();
    }

    protected void checkDataIntegrity() {
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int sampleCount = this.chartData.getSampleCount();
        if (sampleCount != this.barLabelColors.length) {
            this.needRender = true;
            Color[] newBarLabelColors = new Color[sampleCount];
            int count = Math.min(sampleCount, this.barLabelColors.length);
            System.arraycopy(this.barLabelColors, 0, newBarLabelColors, 0, count);
            this.barLabelColors = newBarLabelColors;
        }
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }
}

