/*
 * Decompiled with CFR 0.152.
 */
package Acme.Widgets;

import Acme.GuiUtils;
import Acme.Widgets.ImageLabel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class ButtonDialog
extends Dialog
implements Runnable {
    private String[] buttons;
    private int[] answers;
    private boolean clicked = false;
    private int answer;

    public ButtonDialog(Frame parent, String message, String button1, int answer1) {
        super(parent, true);
        this.build(message, button1, answer1);
    }

    public ButtonDialog(Frame parent, String title, String message, String button1, int answer1) {
        super(parent, title, true);
        this.build(message, button1, answer1);
    }

    private void build(String message, String button1, int answer1) {
        this.buttons = new String[1];
        this.answers = new int[1];
        this.buttons[0] = button1;
        this.answers[0] = answer1;
        this.build(message);
    }

    public ButtonDialog(Frame parent, String message, String button1, int answer1, String button2, int answer2) {
        super(parent, true);
        this.build(message, button1, answer1, button2, answer2);
    }

    public ButtonDialog(Frame parent, String title, String message, String button1, int answer1, String button2, int answer2) {
        super(parent, title, true);
        this.build(message, button1, answer1, button2, answer2);
    }

    private void build(String message, String button1, int answer1, String button2, int answer2) {
        this.buttons = new String[2];
        this.answers = new int[2];
        this.buttons[0] = button1;
        this.answers[0] = answer1;
        this.buttons[1] = button2;
        this.answers[1] = answer2;
        this.build(message);
    }

    public ButtonDialog(Frame parent, String message, String button1, int answer1, String button2, int answer2, String button3, int answer3) {
        super(parent, true);
        this.build(message, button1, answer1, button2, answer2, button3, answer3);
    }

    public ButtonDialog(Frame parent, String title, String message, String button1, int answer1, String button2, int answer2, String button3, int answer3) {
        super(parent, title, true);
        this.build(message, button1, answer1, button2, answer2, button3, answer3);
    }

    private void build(String message, String button1, int answer1, String button2, int answer2, String button3, int answer3) {
        this.buttons = new String[3];
        this.answers = new int[3];
        this.buttons[0] = button1;
        this.answers[0] = answer1;
        this.buttons[1] = button2;
        this.answers[1] = answer2;
        this.buttons[2] = button3;
        this.answers[2] = answer3;
        this.build(message);
    }

    public ButtonDialog(Frame parent, String message, String button1, int answer1, String button2, int answer2, String button3, int answer3, String button4, int answer4) {
        super(parent, true);
        this.build(message, button1, answer1, button2, answer2, button3, answer3, button4, answer4);
    }

    public ButtonDialog(Frame parent, String title, String message, String button1, int answer1, String button2, int answer2, String button3, int answer3, String button4, int answer4) {
        super(parent, title, true);
        this.build(message, button1, answer1, button2, answer2, button3, answer3, button4, answer4);
    }

    private void build(String message, String button1, int answer1, String button2, int answer2, String button3, int answer3, String button4, int answer4) {
        this.buttons = new String[4];
        this.answers = new int[4];
        this.buttons[0] = button1;
        this.answers[0] = answer1;
        this.buttons[1] = button2;
        this.answers[1] = answer2;
        this.buttons[2] = button3;
        this.answers[2] = answer3;
        this.buttons[3] = button4;
        this.answers[3] = answer4;
        this.build(message);
    }

    private void build(String message) {
        this.setResizable(false);
        ((Component)this).setBackground(GuiUtils.qmarkColor);
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        ImageLabel imageLabel = new ImageLabel(GuiUtils.qmarkIcon(this));
        gb.setConstraints(imageLabel, gbc);
        this.add(imageLabel);
        Label label = new Label(message);
        gbc.gridwidth = 0;
        gb.setConstraints(label, gbc);
        this.add(label);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout(0));
        int i = 0;
        while (i < this.buttons.length) {
            buttonPanel.add(new Button(this.buttons[i]));
            ++i;
        }
        gb.setConstraints(buttonPanel, gbc);
        this.add(buttonPanel);
    }

    public void show() {
        this.pack();
        this.validate();
        new Thread(this).start();
    }

    public void run() {
        super.show();
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 1001: {
                int i = 0;
                while (i < this.buttons.length) {
                    if (evt.arg.equals(this.buttons[i])) {
                        this.click(this.answers[i]);
                        return true;
                    }
                    ++i;
                }
                break;
            }
        }
        return super.handleEvent(evt);
    }

    private synchronized void click(int val) {
        this.clicked = true;
        this.notify();
        this.answer = val;
        ((Component)this).hide();
        this.dispose();
    }

    public synchronized int getAnswer() {
        while (!this.clicked) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.answer;
    }
}

