/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.RefDouble;
import Acme.RefInt;
import java.util.Date;
import java.util.GregorianCalendar;

public class Phase {
    private static final double epoch = 2444238.5;
    private static final double elonge = 278.83354;
    private static final double elongp = 282.596403;
    private static final double eccent = 0.016718;
    private static final double sunsmax = 1.495985E8;
    private static final double sunangsiz = 0.533128;
    private static final double mmlong = 64.975464;
    private static final double mmlongp = 349.383063;
    private static final double mlnode = 151.950429;
    private static final double minc = 5.145396;
    private static final double mecc = 0.0549;
    private static final double mangsiz = 0.5181;
    private static final double msmax = 384401.0;
    private static final double mparallax = 0.9507;
    private static final double synmonth = 29.53058868;
    private static final double lunatbase = 2423436.0;
    private static final double earthrad = 6378.16;
    private static final double EPSILON = 1.0E-6;

    private static double fixangle(double a) {
        double b = a - 360.0 * Math.floor(a / 360.0);
        return b;
    }

    private static double torad(double d) {
        return d * Math.PI / 180.0;
    }

    private static double todeg(double r) {
        return r * 180.0 / Math.PI;
    }

    private static double dsin(double d) {
        return Math.sin(Phase.torad(d));
    }

    private static double dcos(double d) {
        return Math.cos(Phase.torad(d));
    }

    private static long jdate(Date t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(t);
        long y = cal.get(1) + 1900;
        long m = cal.get(2) + 1;
        if (m > 2L) {
            m -= 3L;
        } else {
            m += 9L;
            --y;
        }
        long c = y / 100L;
        return (long)cal.get(5) + c * 146097L / 4L + (y -= 100L * c) * 1461L / 4L + (m * 153L + 2L) / 5L + 1721119L;
    }

    public static double jtime(Date t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(t);
        int c = -cal.get(15);
        return (double)Phase.jdate(t) - 0.5 + (double)(cal.get(13) + 60 * (cal.get(12) + c + 60 * cal.get(11))) / 86400.0;
    }

    private static void jyear(double td, RefInt yy, RefInt mm, RefInt dd) {
        double j = Math.floor(td += 0.5);
        double y = Math.floor((4.0 * (j -= 1721119.0) - 1.0) / 146097.0);
        j = j * 4.0 - (1.0 + 146097.0 * y);
        double d = Math.floor(j / 4.0);
        j = Math.floor((4.0 * d + 3.0) / 1461.0);
        d = 4.0 * d + 3.0 - 1461.0 * j;
        d = Math.floor((d + 4.0) / 4.0);
        double m = Math.floor((5.0 * d - 3.0) / 153.0);
        d = 5.0 * d - (3.0 + 153.0 * m);
        d = Math.floor((d + 5.0) / 5.0);
        y = 100.0 * y + j;
        if (m < 10.0) {
            m += 3.0;
        } else {
            m -= 9.0;
            y += 1.0;
        }
        yy.val = (int)y;
        mm.val = (int)m;
        dd.val = (int)d;
    }

    private static double meanphase(double sdate, double phase, RefDouble usek) {
        RefInt yy = new RefInt();
        RefInt mm = new RefInt();
        RefInt dd = new RefInt();
        Phase.jyear(sdate, yy, mm, dd);
        double k = ((double)yy.val + (double)(mm.val - 1) * 0.08333333333333333 - 1900.0) * 12.3685;
        double t = (sdate - 2415020.0) / 36525.0;
        double t2 = t * t;
        double t3 = t2 * t;
        usek.val = k = Math.floor(k) + phase;
        double nt1 = 2415020.75933 + 29.53058868 * k + 1.178E-4 * t2 - 1.55E-7 * t3 + 3.3E-4 * Phase.dsin(166.56 + 132.87 * t - 0.009173 * t2);
        return nt1;
    }

    private static double truephase(double k, double phase) {
        boolean apcor = false;
        double t = (k += phase) / 1236.85;
        double t2 = t * t;
        double t3 = t2 * t;
        double pt = 2415020.75933 + 29.53058868 * k + 1.178E-4 * t2 - 1.55E-7 * t3 + 3.3E-4 * Phase.dsin(166.56 + 132.87 * t - 0.009173 * t2);
        double m = 359.2242 + 29.10535608 * k - 3.33E-5 * t2 - 3.47E-6 * t3;
        double mprime = 306.0253 + 385.81691806 * k + 0.0107306 * t2 + 1.236E-5 * t3;
        double f = 21.2964 + 390.67050646 * k - 0.0016528 * t2 - 2.39E-6 * t3;
        if (phase < 0.01 || Math.abs(phase - 0.5) < 0.01) {
            pt += (0.1734 - 3.93E-4 * t) * Phase.dsin(m) + 0.0021 * Phase.dsin(2.0 * m) - 0.4068 * Phase.dsin(mprime) + 0.0161 * Phase.dsin(2.0 * mprime) - 4.0E-4 * Phase.dsin(3.0 * mprime) + 0.0104 * Phase.dsin(2.0 * f) - 0.0051 * Phase.dsin(m + mprime) - 0.0074 * Phase.dsin(m - mprime) + 4.0E-4 * Phase.dsin(2.0 * f + m) - 4.0E-4 * Phase.dsin(2.0 * f - m) - 6.0E-4 * Phase.dsin(2.0 * f + mprime) + 0.001 * Phase.dsin(2.0 * f - mprime) + 5.0E-4 * Phase.dsin(m + 2.0 * mprime);
            apcor = true;
        } else if (Math.abs(phase - 0.25) < 0.01 || Math.abs(phase - 0.75) < 0.01) {
            pt += (0.1721 - 4.0E-4 * t) * Phase.dsin(m) + 0.0021 * Phase.dsin(2.0 * m) - 0.628 * Phase.dsin(mprime) + 0.0089 * Phase.dsin(2.0 * mprime) - 4.0E-4 * Phase.dsin(3.0 * mprime) + 0.0079 * Phase.dsin(2.0 * f) - 0.0119 * Phase.dsin(m + mprime) - 0.0047 * Phase.dsin(m - mprime) + 3.0E-4 * Phase.dsin(2.0 * f + m) - 4.0E-4 * Phase.dsin(2.0 * f - m) - 6.0E-4 * Phase.dsin(2.0 * f + mprime) + 0.0021 * Phase.dsin(2.0 * f - mprime) + 3.0E-4 * Phase.dsin(m + 2.0 * mprime) + 4.0E-4 * Phase.dsin(m - 2.0 * mprime) - 3.0E-4 * Phase.dsin(2.0 * m + mprime);
            pt = phase < 0.5 ? (pt += 0.0028 - 4.0E-4 * Phase.dcos(m) + 3.0E-4 * Phase.dcos(mprime)) : (pt += -0.0028 + 4.0E-4 * Phase.dcos(m) - 3.0E-4 * Phase.dcos(mprime));
            apcor = true;
        }
        if (!apcor) {
            throw new InternalError("Acme.Phase.truephase() called with invalid phase selector");
        }
        return pt;
    }

    public static void phasehunt5(double sdate, double[] phases) {
        RefDouble k1 = new RefDouble();
        RefDouble k2 = new RefDouble();
        double adate = sdate - 45.0;
        double nt1 = Phase.meanphase(adate, 0.0, k1);
        while (true) {
            double nt2 = Phase.meanphase(adate += 29.53058868, 0.0, k2);
            if (nt1 <= sdate && nt2 > sdate) break;
            nt1 = nt2;
            k1.val = k2.val;
        }
        phases[0] = Phase.truephase(k1.val, 0.0);
        phases[1] = Phase.truephase(k1.val, 0.25);
        phases[2] = Phase.truephase(k1.val, 0.5);
        phases[3] = Phase.truephase(k1.val, 0.75);
        phases[4] = Phase.truephase(k2.val, 0.0);
    }

    void phasehunt2(double sdate, double[] phases, double[] which) {
        RefDouble k1 = new RefDouble();
        RefDouble k2 = new RefDouble();
        double adate = sdate - 45.0;
        double nt1 = Phase.meanphase(adate, 0.0, k1);
        while (true) {
            double nt2 = Phase.meanphase(adate += 29.53058868, 0.0, k2);
            if (nt1 <= sdate && nt2 > sdate) break;
            nt1 = nt2;
            k1.val = k2.val;
        }
        phases[0] = Phase.truephase(k1.val, 0.0);
        which[0] = 0.0;
        phases[1] = Phase.truephase(k1.val, 0.25);
        which[1] = 0.25;
        if (phases[1] <= sdate) {
            phases[0] = phases[1];
            which[0] = which[1];
            phases[1] = Phase.truephase(k1.val, 0.5);
            which[1] = 0.5;
            if (phases[1] <= sdate) {
                phases[0] = phases[1];
                which[0] = which[1];
                phases[1] = Phase.truephase(k1.val, 0.75);
                which[1] = 0.75;
                if (phases[1] <= sdate) {
                    phases[0] = phases[1];
                    which[0] = which[1];
                    phases[1] = Phase.truephase(k2.val, 0.0);
                    which[1] = 0.0;
                }
            }
        }
    }

    private static double kepler(double m, double ecc) {
        double delta;
        double e = m = Phase.torad(m);
        do {
            delta = e - ecc * Math.sin(e) - m;
            e -= delta / (1.0 - ecc * Math.cos(e));
        } while (Math.abs(delta) > 1.0E-6);
        return e;
    }

    public static double phase(double pdate, RefDouble pphaseR, RefDouble mageR, RefDouble distR, RefDouble angdiaR, RefDouble sudistR, RefDouble suangdiaR) {
        double Day = pdate - 2444238.5;
        double N = Phase.fixangle(0.9856473320990837 * Day);
        double M = Phase.fixangle(N + 278.83354 - 282.596403);
        double Ec = Phase.kepler(M, 0.016718);
        Ec = Math.sqrt(1.0340044870138985) * Math.tan(Ec / 2.0);
        Ec = 2.0 * Phase.todeg(Math.atan(Ec));
        double Lambdasun = Phase.fixangle(Ec + 282.596403);
        double F = (1.0 + 0.016718 * Math.cos(Phase.torad(Ec))) / 0.999720508476;
        double SunDist = 1.495985E8 / F;
        double SunAng = F * 0.533128;
        double ml = Phase.fixangle(13.1763966 * Day + 64.975464);
        double MM = Phase.fixangle(ml - 0.1114041 * Day - 349.383063);
        double Ev = 1.2739 * Math.sin(Phase.torad(2.0 * (ml - Lambdasun) - MM));
        double Ae = 0.1858 * Math.sin(Phase.torad(M));
        double A3 = 0.37 * Math.sin(Phase.torad(M));
        double MmP = MM + Ev - Ae - A3;
        double mEc = 6.2886 * Math.sin(Phase.torad(MmP));
        double A4 = 0.214 * Math.sin(Phase.torad(2.0 * MmP));
        double lP = ml + Ev + mEc - Ae + A4;
        double V = 0.6583 * Math.sin(Phase.torad(2.0 * (lP - Lambdasun)));
        double lPP = lP + V;
        double MoonAge = lPP - Lambdasun;
        double MoonPhase = (1.0 - Math.cos(Phase.torad(MoonAge))) / 2.0;
        double MoonDist = 383242.41154199 / (1.0 + 0.0549 * Math.cos(Phase.torad(MmP + mEc)));
        double MoonDFrac = MoonDist / 384401.0;
        double MoonAng = 0.5181 / MoonDFrac;
        pphaseR.val = MoonPhase;
        mageR.val = 29.53058868 * (Phase.fixangle(MoonAge) / 360.0);
        distR.val = MoonDist;
        angdiaR.val = MoonAng;
        sudistR.val = SunDist;
        suangdiaR.val = SunAng;
        return Phase.torad(Phase.fixangle(MoonAge));
    }
}

