/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import Acme.JPM.Filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Shear
extends RGBAllFilter {
    private double angle;

    public Shear(ImageProducer producer, double angle) {
        super(producer);
        this.angle = angle * Math.PI / 180.0;
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        double shearfac = Math.tan(this.angle);
        if (shearfac < 0.0) {
            shearfac = -shearfac;
        }
        int newWidth = (int)((double)height * shearfac + (double)width + 0.999999);
        int[][] newPixels = new int[height][newWidth];
        int row = 0;
        while (row < height) {
            double new0 = this.angle > 0.0 ? (double)row * shearfac : (double)(height - row) * shearfac;
            int intnew0 = (int)new0;
            double fracnew0 = new0 - (double)intnew0;
            double omfracnew0 = 1.0 - fracnew0;
            int col = 0;
            while (col < newWidth) {
                newPixels[row][col] = 0;
                ++col;
            }
            int preva = 0;
            int prevr = rgbPixels[row][0] >> 16 & 0xFF;
            int prevg = rgbPixels[row][0] >> 8 & 0xFF;
            int prevb = rgbPixels[row][0] & 0xFF;
            int col2 = 0;
            while (col2 < width) {
                int rgb = rgbPixels[row][col2];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                newPixels[row][intnew0 + col2] = (int)(fracnew0 * (double)preva + omfracnew0 * (double)a) << 24 | (int)(fracnew0 * (double)prevr + omfracnew0 * (double)r) << 16 | (int)(fracnew0 * (double)prevg + omfracnew0 * (double)g) << 8 | (int)(fracnew0 * (double)prevb + omfracnew0 * (double)b);
                preva = a;
                prevr = r;
                prevg = g;
                prevb = b;
                ++col2;
            }
            newPixels[row][intnew0 + width] = (int)(fracnew0 * (double)preva) << 24 | prevr << 16 | prevg << 8 | prevb;
            ++row;
        }
        this.setPixels(newWidth, height, newPixels);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Shear.usage();
        }
        Shear filter = new Shear(null, Integer.parseInt(args[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Shear <angle>");
        System.exit(1);
    }
}

