/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Cacheable;
import java.io.IOException;
import java.io.InputStream;

public abstract class CacheableInputStream
extends InputStream
implements Cacheable {
    protected InputStream _is;
    protected CacheManager _cm;
    protected int _state = 0;

    public abstract void cache() throws IOException;

    public void checkRead() throws IOException {
        if (this._state == 0) {
            CacheManager.raiseIOException("IO_NOT_OPEN");
        }
    }

    public abstract void clear() throws IOException;

    public void close() throws IOException {
        this._state = 0;
        this._cm.dead(this);
        this._cm = null;
    }

    public int getState() {
        return this._state;
    }

    public void open(boolean caching) throws IOException {
        this._state = caching ? 2 : 1;
    }

    public int read() throws IOException {
        this.checkRead();
        return this._is.read();
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        this.checkRead();
        int numRead = 0;
        while (length > 0) {
            int n = this._is.read(buf, offset + numRead, length);
            if (n < 0) {
                if (numRead != 0) break;
                return -1;
            }
            numRead += n;
            length -= n;
        }
        return numRead;
    }

    public void reset() throws IOException {
        if (this._state == 2) {
            this.cache();
        }
        ((CacheStream)this._is).reset();
    }

    public void resetInputStream(InputStream is) {
        this._is = is;
    }

    public void setManager(CacheManager cm) {
        this._cm = cm;
    }

    public long skip(long n) throws IOException {
        this.checkRead();
        return this._is.skip(n);
    }
}

